# insights_python_client
## Introduction to PlotRisk  PlotRisk is a module, which ease to create plot for the given area of interest and also   facilitate to check satellite indices, weather and yield data.    **Note**``  Indices, Weather and Yield data can be accessed based on features subscriptions.  ``  ## Resources  A resource is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```  For more details, see [CRUD Operations](https://docs.microsoft.com/en-us/iis-administration/api/crud) to learn more about it.  ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as ,[Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST API.    **Swagger UI**    **Step 1.** Generate access tokens using **/token** resource      **Info** : ``If you are a SMARTFARM_PLUS user, you can request for tokens using tenant,username,password  ``    **Step 2.** Copy **_access_token_** from **Step 1**, then click on **Authorize** button and paste the token.    **Step 3.** Select an API resource and click on **_Try it out_**.    **Step 4.** Fill the headers such as _**TenantType**_, _**OrgId**_ & _**X-Api-Key**_.    **Info** : ``X-Api-Key can be obtained from Step 1  ``    **Step 5.**  Query parameters are optional. It filters result based on provided parameter value.  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```   **Step 6.** Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **swagger.json** hypelink at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol.  **Access Token** is required to access PlotRisk APIs & same can be generated by following API on passing valid request payload (see Token API)  ```  POST   /tokens  ```    For more details, see [Authentication and Authorization](https://swagger.io/docs/specification/authentication/).    ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    For more details on HTTP Status code, see [HTTP Status Codes](https://restfulapi.net/http-status-codes/) 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1.0
- Package version: 0.0.2
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import insights_python_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import insights_python_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import insights_python_client
from insights_python_client.rest import ApiException
from pprint import pprint


# create an instance of the API class
api_instance = insights_python_client.BoundaryApi(insights_python_client.ApiClient(configuration))
tenant_type = 'tenant_type_example' # str |  TenantType is an identifier to track API uses. Valid input : 'SMARTFARM_PLUS'
x_api_key = 'x_api_key_example' # str | Security key to grant access to APIs
org_id = 'org_id_example' # str | OrgId represents unique Id for a company or entity (optional)
page = 56 # int | Page represents page no. in a paginated response. Valid page can be zero or a positive number (optional)
size = 56 # int | Size represents the number of records that are displayed when a page loads. Valid size can be between 10 and 300 (optional)
sort_by = 'sort_by_example' # str | Sort the result based on given criteria in descending(default) order (optional)
direction = 'direction_example' # str | Order the result in ascending or descending form (optional)
ids = 'ids_example' # str | Id (boundaryId/plotId) is the unique identifier for each plot, e.g. ids= 4d35861 or 4d35861,61e6c83 (optional)
external_ids = 'external_ids_example' # str | ExternalId is a unique id to identify plot, e.g. externalIds= 4d35861 or 4d35861,61e6c83 (optional)
min_created_date_time = 'min_created_date_time_example' # str | Indicates plot creation time, filters record > createdDateTime e.g  minCreatedDateTime = 2021-12-23T00:00:00Z (optional)
max_created_date_time = 'max_created_date_time_example' # str | Indicates plot creation time, filters record < createdDateTime, e.g  maxCreatedDateTime = 2021-12-23T00:00:00Z (optional)

try:
    # Get plots
    api_response = api_instance.list_all3(tenant_type, x_api_key, org_id=org_id, page=page, size=size, sort_by=sort_by, direction=direction, ids=ids, external_ids=external_ids, min_created_date_time=min_created_date_time, max_created_date_time=max_created_date_time)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BoundaryApi->list_all3: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://t608jbcx83.execute-api.ap-southeast-1.amazonaws.com/dev/{basePath}*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BoundaryApi* | [**list_all3**](docs/BoundaryApi.md#list_all3) | **GET** /plots | Get plots
*FileApi* | [**get_plot_image_for_satellite_and_health_indices**](docs/FileApi.md#get_plot_image_for_satellite_and_health_indices) | **GET** /download | Download plot images
*MetricsApi* | [**list_all2**](docs/MetricsApi.md#list_all2) | **GET** /satellite | Get satellite metrics
*TokenApi* | [**get_token**](docs/TokenApi.md#get_token) | **POST** /tokens | Generate token to authenticate
*WeatherApi* | [**list_all1**](docs/WeatherApi.md#list_all1) | **GET** /weather | Get weather data
*YieldApi* | [**list_all**](docs/YieldApi.md#list_all) | **GET** /yield | Get yield data

## Documentation For Models

 - [AccessTokenRequest](docs/AccessTokenRequest.md)
 - [AccessTokenResponse](docs/AccessTokenResponse.md)
 - [BoundaryMetrics](docs/BoundaryMetrics.md)
 - [BoundaryResponse](docs/BoundaryResponse.md)
 - [CropDetail](docs/CropDetail.md)
 - [CropMetric](docs/CropMetric.md)
 - [CustomErrorResponse](docs/CustomErrorResponse.md)
 - [Gdd](docs/Gdd.md)
 - [Metrics](docs/Metrics.md)
 - [ModelInfo](docs/ModelInfo.md)
 - [PlotImageResponse](docs/PlotImageResponse.md)
 - [SatelliteMetricsResponse](docs/SatelliteMetricsResponse.md)
 - [Weather](docs/Weather.md)
 - [WeatherDataResponse](docs/WeatherDataResponse.md)
 - [YieldResponse](docs/YieldResponse.md)
 - [YieldsData](docs/YieldsData.md)

## Documentation For Authorization


## OAuth



## Author


