# Pintless
<img align="right" width="100" height="100" src="https://raw.githubusercontent.com/StephenWattam/pintless/main/pintless-dalle.jpg" alt="Pintless, the unit library for people who don't want pint"/>

[![DeepSource](https://deepsource.io/gh/StephenWattam/pintless.svg/?label=active+issues&show_trend=true&token=wd9lW1wQHaG9lCc3Jrp-FKVu)](https://deepsource.io/gh/StephenWattam/pintless/?ref=repository-badge)
[![CodeFactor](https://www.codefactor.io/repository/github/stephenwattam/pintless/badge)](https://www.codefactor.io/repository/github/stephenwattam/pintless)
![Linting and building](https://github.com/StephenWattam/pintless/actions/workflows/python-package.yml/badge.svg)
<!-- Pytest Coverage Comment:Begin -->
<a href="https://github.com/StephenWattam/pintless/blob/main/README.md"><img alt="Coverage" src="https://img.shields.io/badge/Coverage-84%25-green.svg" /></a><details><summary>Coverage Report </summary><table><tr><th>File</th><th>Stmts</th><th>Miss</th><th>Cover</th><th>Missing</th></tr><tbody><tr><td colspan="5"><b>pintless</b></td></tr><tr><td>&nbsp; &nbsp;<a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py">quantity.py</a></td><td>150</td><td>51</td><td>66%</td><td><a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L33">33</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L37">37</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L53">53</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L60">60</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L71">71</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L78">78</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L90-L98">90&ndash;98</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L104">104</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L128">128</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L136">136</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L154-L167">154&ndash;167</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L176">176</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L180">180</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L184">184</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L229">229</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L245">245</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L254-L272">254&ndash;272</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L278">278</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L281-L285">281&ndash;285</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L289">289</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L292">292</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L295">295</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L298">298</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L301">301</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L305">305</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L308">308</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L311">311</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/quantity.py#L317">317</a></td></tr><tr><td>&nbsp; &nbsp;<a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py">registry.py</a></td><td>165</td><td>15</td><td>91%</td><td><a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L75">75</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L94">94</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L111">111</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L124">124</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L127">127</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L143">143</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L145">145</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L171">171</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L193">193</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L273">273</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L295">295</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L299">299</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L314">314</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L320">320</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/registry.py#L328">328</a></td></tr><tr><td>&nbsp; &nbsp;<a href="https://github.com/StephenWattam/pintless/blob/main/pintless/unit.py">unit.py</a></td><td>148</td><td>11</td><td>93%</td><td><a href="https://github.com/StephenWattam/pintless/blob/main/pintless/unit.py#L37">37</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/unit.py#L46">46</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/unit.py#L49">49</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/unit.py#L52">52</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/unit.py#L119">119</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/unit.py#L127">127</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/unit.py#L239">239</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/unit.py#L255">255</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/unit.py#L295">295</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/unit.py#L309">309</a>, <a href="https://github.com/StephenWattam/pintless/blob/main/pintless/unit.py#L351">351</a></td></tr><tr><td><b>TOTAL</b></td><td><b>468</b></td><td><b>77</b></td><td><b>84%</b></td><td>&nbsp;</td></tr></tbody></table></details>
<!-- Pytest Coverage Comment:End -->

---

The unit library [pint](https://github.com/hgrecco/pint) is fantastic.  It removes a whole class of bugs from common data science workloads, and provides good tools for humans to process numbers.  But it's very slow, and provides vast swaths of functionality that I don't need.

This library is like pint, but _less_ --- it lets you use units without pain, but aims to be performant and small-in-memory.  It's designed as a drop-in replacement to pint for those of us who don't use most of pint's features.

Choice of features is based on my personal experience in projects.  From this I've developed some principles that will be followed here to prevent creep/bloat:

Things this doesn't support:

 - Units that don't scale from 0, e.g. degrees C and F
 - LaTeX output
 - Translation to other languages --- want different units?  Use a different definition file
 - Simplification of units: algebraic simplifications are necessary, but choosing 'sensible' units for humans is beyond the scope of this lib
 - Scientific notation and other non-unit number representation problems.  Pintless attempts to touch the values as little as possible.
 - Numpy/pandas support

Design Principles

 - Fast is more important than small or simple
 - Precompute where possible
 - Having principles usually leads you to design for them rather than reality: design based on benchmarks
 - Don't incur performance costs for obscure units or use-cases: allow users to specify minimal sets of things for common workflows
 - Don't incur performance costs for nicer APIs that are only useful in interactive workflows (e.g. string processing, output to notebooks, etc)
 - Quantity and Unit classes are numbers and should be as transparent/minimal as possible, holding as few external references as possible, and should be serialisable with as little pain as possible


## Road Map

 - Better test pack
 - Better benchmarks, and performance testing in CI
 - Compilation of parts of the library to C


## Performance
At the time of writing, pintless is roughly 20 times faster than pint.  One of the roadmap actions above is to estabilish a much better benchmarking process for this figure, though, so take it with a grain of salt for now.

## Benchmarking
A small benchmark script is in the root of this repository, `benchmark.py`.  To run (and visualise the output using [snakeviz](https://jiffyclub.github.io/snakeviz/):

    python -m cProfile -o both.prof benchmark.py
    snakeviz both.prof

The benchmark is dead simple, and prioritises repeated simple actions (as per a lot of processing workloads).
