# Generated by Django 3.1.6 on 2023-03-29 08:40

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AuthToken',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
            ],
            options={
                'verbose_name_plural': 'Auth Tokens',
            },
        ),
        migrations.CreateModel(
            name='Token',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255)),
                ('description', models.CharField(default='', max_length=255)),
                ('symbol', models.CharField(max_length=100)),
                ('decimals', models.PositiveIntegerField(default=0)),
                ('icon', models.ImageField(blank=True, null=True, upload_to='')),
                ('is_nft', models.BooleanField(default=False)),
                ('nft_description', models.CharField(default='', max_length=255)),
                ('nft_types', models.JSONField(default=dict)),
                ('date_created', models.DateTimeField(default=django.utils.timezone.now)),
                ('status', models.CharField(choices=[('active', 'Active'), ('inactive', 'Inactive'), ('burned', 'Burned')], default='active', max_length=10)),
                ('owner', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='tokens', to='bcmr.authtoken')),
            ],
            options={
                'ordering': ('name', 'symbol', 'is_nft'),
            },
        ),
        migrations.CreateModel(
            name='Registry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('major', models.PositiveIntegerField(default=0)),
                ('minor', models.PositiveIntegerField(default=0)),
                ('patch', models.PositiveIntegerField(default=0)),
                ('name', models.CharField(max_length=255)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('active', models.BooleanField(default=False)),
                ('date_created', models.DateTimeField(default=django.utils.timezone.now)),
                ('latest_revision', models.DateTimeField(default=django.utils.timezone.now)),
                ('tokens', models.ManyToManyField(to='bcmr.Token')),
            ],
            options={
                'verbose_name_plural': 'Registries',
                'ordering': ('name',),
            },
        ),
    ]
