# mypy-boto3-kafka

[![PyPI - mypy-boto3-kafka](https://img.shields.io/pypi/v/mypy-boto3-kafka.svg?color=blue)](https://pypi.org/project/mypy-boto3-kafka)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-kafka.svg?color=blue)](https://pypi.org/project/mypy-boto3-kafka)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-kafka](#mypy-boto3-kafka)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)

Type annotations for
[boto3.Kafka 1.14.0](https://boto3.amazonaws.com/v1/documentation/api/1.14.0/reference/services/kafka.html#Kafka) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Kafka` service.

```bash
python -m pip install boto3-stubs[kafka]
```

Use `boto3` with `mypy_boto3_kafka` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_kafka import KafkaClient

# Now mypy can check if your code is valid.
client: KafkaClient = boto3.client("kafka")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: KafkaClient = session.client("kafka")



# Annotated paginators are included as well

import mypy_boto3_kafka.paginator as kafka_paginators

list_cluster_operations_paginator: kafka_paginators.ListClusterOperationsPaginator = client.get_paginator("list_cluster_operations")
list_clusters_paginator: kafka_paginators.ListClustersPaginator = client.get_paginator("list_clusters")
list_configuration_revisions_paginator: kafka_paginators.ListConfigurationRevisionsPaginator = client.get_paginator("list_configuration_revisions")
list_configurations_paginator: kafka_paginators.ListConfigurationsPaginator = client.get_paginator("list_configurations")
list_kafka_versions_paginator: kafka_paginators.ListKafkaVersionsPaginator = client.get_paginator("list_kafka_versions")
list_nodes_paginator: kafka_paginators.ListNodesPaginator = client.get_paginator("list_nodes")
```

## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_kafka` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python
import boto3

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("kafka")

session_client = boto3.Session().client("kafka")
```