#ifndef LFORTRAN_AST_H
#define LFORTRAN_AST_H

// Generated by grammar/asdl_cpp.py

#include <lfortran/parser/alloc.h>
#include <lfortran/parser/location.h>
#include <lfortran/casts.h>
#include <lfortran/colors.h>
#include <lfortran/exception.h>


namespace LFortran::AST {

enum astType
{
    unit, mod, program_unit, unit_decl1, unit_decl2, stmt, expr, attribute, tbind, array_index, case_stmt, use_symbol
};

struct ast_t
{
    astType type;
    Location loc;
};

/******************************************************************************/
// Forward declarations

struct unit_t; // Sum
struct mod_t; // Sum
struct program_unit_t; // Sum
struct unit_decl1_t; // Sum
struct unit_decl2_t; // Sum
struct stmt_t; // Sum
struct expr_t; // Sum
enum boolopType // Simple Sum
{ // Types
    And, Or, Eqv, NEqv
};
enum operatorType // Simple Sum
{ // Types
    Add, Sub, Mul, Div, Pow
};
enum unaryopType // Simple Sum
{ // Types
    Invert, Not, UAdd, USub
};
enum cmpopType // Simple Sum
{ // Types
    Eq, NotEq, Lt, LtE, Gt, GtE
};
struct decl_t; // Product
struct dimension_t; // Product
struct attribute_t; // Sum
struct attribute_arg_t; // Product
struct arg_t; // Product
struct keyword_t; // Product
struct tbind_t; // Sum
struct array_index_t; // Sum
struct case_stmt_t; // Sum
struct use_symbol_t; // Sum


/******************************************************************************/
// Products declarations

struct decl_t // Product
{
    char* m_sym;
    char* m_sym_type;
    dimension_t* m_dims; size_t n_dims; // Sequence
    attribute_t** m_attrs; size_t n_attrs; // Sequence
    expr_t* m_initializer;
};
struct dimension_t // Product
{
    expr_t* m_start;
    expr_t* m_end;
};
struct attribute_arg_t // Product
{
    char* m_arg;
};
struct arg_t // Product
{
    char* m_arg;
};
struct keyword_t // Product
{
    char* m_arg;
    expr_t* m_value;
};


/******************************************************************************/
// Sums declarations

enum unitType // Types
{
    TranslationUnit
};

struct unit_t // Sum
{
    ast_t base;
    unitType type;
};

    struct TranslationUnit_t // Constructor
    {
        unit_t base;
        int /* object */* m_items; size_t n_items; // Sequence
    };
    static inline ast_t* make_TranslationUnit_t(Allocator &al, const Location &a_loc, int /* object */* a_items, size_t n_items) {
        TranslationUnit_t *n;
        n = al.make_new<TranslationUnit_t>();
        n->base.type = unitType::TranslationUnit;
        n->base.base.type = astType::unit;
        n->base.base.loc = a_loc;
        n->m_items = a_items;
        n->n_items = n_items;
        return (ast_t*)n;
    }



enum modType // Types
{
    Module, Program
};

struct mod_t // Sum
{
    ast_t base;
    modType type;
};

    struct Module_t // Constructor
    {
        mod_t base;
        char* m_name;
        unit_decl1_t** m_use; size_t n_use; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        program_unit_t** m_contains; size_t n_contains; // Sequence
    };
    static inline ast_t* make_Module_t(Allocator &al, const Location &a_loc, char* a_name, unit_decl1_t** a_use, size_t n_use, unit_decl2_t** a_decl, size_t n_decl, program_unit_t** a_contains, size_t n_contains) {
        Module_t *n;
        n = al.make_new<Module_t>();
        n->base.type = modType::Module;
        n->base.base.type = astType::mod;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_use = a_use;
        n->n_use = n_use;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_contains = a_contains;
        n->n_contains = n_contains;
        return (ast_t*)n;
    }

    struct Program_t // Constructor
    {
        mod_t base;
        char* m_name;
        unit_decl1_t** m_use; size_t n_use; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        program_unit_t** m_contains; size_t n_contains; // Sequence
    };
    static inline ast_t* make_Program_t(Allocator &al, const Location &a_loc, char* a_name, unit_decl1_t** a_use, size_t n_use, unit_decl2_t** a_decl, size_t n_decl, stmt_t** a_body, size_t n_body, program_unit_t** a_contains, size_t n_contains) {
        Program_t *n;
        n = al.make_new<Program_t>();
        n->base.type = modType::Program;
        n->base.base.type = astType::mod;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_use = a_use;
        n->n_use = n_use;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_contains = a_contains;
        n->n_contains = n_contains;
        return (ast_t*)n;
    }



enum program_unitType // Types
{
    Subroutine, Function
};

struct program_unit_t // Sum
{
    ast_t base;
    program_unitType type;
};

    struct Subroutine_t // Constructor
    {
        program_unit_t base;
        char* m_name;
        arg_t* m_args; size_t n_args; // Sequence
        unit_decl1_t** m_use; size_t n_use; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        program_unit_t** m_contains; size_t n_contains; // Sequence
    };
    static inline ast_t* make_Subroutine_t(Allocator &al, const Location &a_loc, char* a_name, arg_t* a_args, size_t n_args, unit_decl1_t** a_use, size_t n_use, unit_decl2_t** a_decl, size_t n_decl, stmt_t** a_body, size_t n_body, program_unit_t** a_contains, size_t n_contains) {
        Subroutine_t *n;
        n = al.make_new<Subroutine_t>();
        n->base.type = program_unitType::Subroutine;
        n->base.base.type = astType::program_unit;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_use = a_use;
        n->n_use = n_use;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_contains = a_contains;
        n->n_contains = n_contains;
        return (ast_t*)n;
    }

    struct Function_t // Constructor
    {
        program_unit_t base;
        char* m_name;
        arg_t* m_args; size_t n_args; // Sequence
        char* m_return_type;
        expr_t* m_return_var;
        tbind_t* m_bind;
        unit_decl1_t** m_use; size_t n_use; // Sequence
        unit_decl2_t** m_decl; size_t n_decl; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        program_unit_t** m_contains; size_t n_contains; // Sequence
    };
    static inline ast_t* make_Function_t(Allocator &al, const Location &a_loc, char* a_name, arg_t* a_args, size_t n_args, char* a_return_type, expr_t* a_return_var, tbind_t* a_bind, unit_decl1_t** a_use, size_t n_use, unit_decl2_t** a_decl, size_t n_decl, stmt_t** a_body, size_t n_body, program_unit_t** a_contains, size_t n_contains) {
        Function_t *n;
        n = al.make_new<Function_t>();
        n->base.type = program_unitType::Function;
        n->base.base.type = astType::program_unit;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_return_type = a_return_type;
        n->m_return_var = a_return_var;
        n->m_bind = a_bind;
        n->m_use = a_use;
        n->n_use = n_use;
        n->m_decl = a_decl;
        n->n_decl = n_decl;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_contains = a_contains;
        n->n_contains = n_contains;
        return (ast_t*)n;
    }



enum unit_decl1Type // Types
{
    Use
};

struct unit_decl1_t // Sum
{
    ast_t base;
    unit_decl1Type type;
};

    struct Use_t // Constructor
    {
        unit_decl1_t base;
        char* m_module;
        use_symbol_t** m_symbols; size_t n_symbols; // Sequence
    };
    static inline ast_t* make_Use_t(Allocator &al, const Location &a_loc, char* a_module, use_symbol_t** a_symbols, size_t n_symbols) {
        Use_t *n;
        n = al.make_new<Use_t>();
        n->base.type = unit_decl1Type::Use;
        n->base.base.type = astType::unit_decl1;
        n->base.base.loc = a_loc;
        n->m_module = a_module;
        n->m_symbols = a_symbols;
        n->n_symbols = n_symbols;
        return (ast_t*)n;
    }



enum unit_decl2Type // Types
{
    Declaration, Private, Public, Interface, Interface2
};

struct unit_decl2_t // Sum
{
    ast_t base;
    unit_decl2Type type;
};

    struct Declaration_t // Constructor
    {
        unit_decl2_t base;
        decl_t* m_vars; size_t n_vars; // Sequence
    };
    static inline ast_t* make_Declaration_t(Allocator &al, const Location &a_loc, decl_t* a_vars, size_t n_vars) {
        Declaration_t *n;
        n = al.make_new<Declaration_t>();
        n->base.type = unit_decl2Type::Declaration;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (ast_t*)n;
    }

    struct Private_t // Constructor
    {
        unit_decl2_t base;
        char** m_vars; size_t n_vars; // Sequence
    };
    static inline ast_t* make_Private_t(Allocator &al, const Location &a_loc, char** a_vars, size_t n_vars) {
        Private_t *n;
        n = al.make_new<Private_t>();
        n->base.type = unit_decl2Type::Private;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (ast_t*)n;
    }

    struct Public_t // Constructor
    {
        unit_decl2_t base;
        char** m_vars; size_t n_vars; // Sequence
    };
    static inline ast_t* make_Public_t(Allocator &al, const Location &a_loc, char** a_vars, size_t n_vars) {
        Public_t *n;
        n = al.make_new<Public_t>();
        n->base.type = unit_decl2Type::Public;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (ast_t*)n;
    }

    struct Interface_t // Constructor
    {
        unit_decl2_t base;
        char* m_name;
        char** m_procs; size_t n_procs; // Sequence
    };
    static inline ast_t* make_Interface_t(Allocator &al, const Location &a_loc, char* a_name, char** a_procs, size_t n_procs) {
        Interface_t *n;
        n = al.make_new<Interface_t>();
        n->base.type = unit_decl2Type::Interface;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_procs = a_procs;
        n->n_procs = n_procs;
        return (ast_t*)n;
    }

    struct Interface2_t // Constructor
    {
        unit_decl2_t base;
        char* m_name;
        program_unit_t** m_procs; size_t n_procs; // Sequence
    };
    static inline ast_t* make_Interface2_t(Allocator &al, const Location &a_loc, char* a_name, program_unit_t** a_procs, size_t n_procs) {
        Interface2_t *n;
        n = al.make_new<Interface2_t>();
        n->base.type = unit_decl2Type::Interface2;
        n->base.base.type = astType::unit_decl2;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_procs = a_procs;
        n->n_procs = n_procs;
        return (ast_t*)n;
    }



enum stmtType // Types
{
    Assignment, Associate, SubroutineCall, BuiltinCall, If, Where, Stop, ErrorStop, DoLoop, Select, Cycle, Exit, Return, WhileLoop, Print
};

struct stmt_t // Sum
{
    ast_t base;
    stmtType type;
};

    struct Assignment_t // Constructor
    {
        stmt_t base;
        expr_t* m_target;
        expr_t* m_value;
    };
    static inline ast_t* make_Assignment_t(Allocator &al, const Location &a_loc, expr_t* a_target, expr_t* a_value) {
        Assignment_t *n;
        n = al.make_new<Assignment_t>();
        n->base.type = stmtType::Assignment;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_target = a_target;
        n->m_value = a_value;
        return (ast_t*)n;
    }

    struct Associate_t // Constructor
    {
        stmt_t base;
        expr_t* m_target;
        expr_t* m_value;
    };
    static inline ast_t* make_Associate_t(Allocator &al, const Location &a_loc, expr_t* a_target, expr_t* a_value) {
        Associate_t *n;
        n = al.make_new<Associate_t>();
        n->base.type = stmtType::Associate;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_target = a_target;
        n->m_value = a_value;
        return (ast_t*)n;
    }

    struct SubroutineCall_t // Constructor
    {
        stmt_t base;
        char* m_name;
        expr_t** m_args; size_t n_args; // Sequence
    };
    static inline ast_t* make_SubroutineCall_t(Allocator &al, const Location &a_loc, char* a_name, expr_t** a_args, size_t n_args) {
        SubroutineCall_t *n;
        n = al.make_new<SubroutineCall_t>();
        n->base.type = stmtType::SubroutineCall;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        return (ast_t*)n;
    }

    struct BuiltinCall_t // Constructor
    {
        stmt_t base;
        char* m_name;
        expr_t** m_args; size_t n_args; // Sequence
    };
    static inline ast_t* make_BuiltinCall_t(Allocator &al, const Location &a_loc, char* a_name, expr_t** a_args, size_t n_args) {
        BuiltinCall_t *n;
        n = al.make_new<BuiltinCall_t>();
        n->base.type = stmtType::BuiltinCall;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        return (ast_t*)n;
    }

    struct If_t // Constructor
    {
        stmt_t base;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
    };
    static inline ast_t* make_If_t(Allocator &al, const Location &a_loc, expr_t* a_test, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse) {
        If_t *n;
        n = al.make_new<If_t>();
        n->base.type = stmtType::If;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        return (ast_t*)n;
    }

    struct Where_t // Constructor
    {
        stmt_t base;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
    };
    static inline ast_t* make_Where_t(Allocator &al, const Location &a_loc, expr_t* a_test, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse) {
        Where_t *n;
        n = al.make_new<Where_t>();
        n->base.type = stmtType::Where;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        return (ast_t*)n;
    }

    struct Stop_t // Constructor
    {
        stmt_t base;
        expr_t* m_code;
    };
    static inline ast_t* make_Stop_t(Allocator &al, const Location &a_loc, expr_t* a_code) {
        Stop_t *n;
        n = al.make_new<Stop_t>();
        n->base.type = stmtType::Stop;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_code = a_code;
        return (ast_t*)n;
    }

    struct ErrorStop_t // Constructor
    {
        stmt_t base;
    };
    static inline ast_t* make_ErrorStop_t(Allocator &al, const Location &a_loc) {
        ErrorStop_t *n;
        n = al.make_new<ErrorStop_t>();
        n->base.type = stmtType::ErrorStop;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }

    struct DoLoop_t // Constructor
    {
        stmt_t base;
        char* m_var;
        expr_t* m_start;
        expr_t* m_end;
        expr_t* m_increment;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_DoLoop_t(Allocator &al, const Location &a_loc, char* a_var, expr_t* a_start, expr_t* a_end, expr_t* a_increment, stmt_t** a_body, size_t n_body) {
        DoLoop_t *n;
        n = al.make_new<DoLoop_t>();
        n->base.type = stmtType::DoLoop;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_var = a_var;
        n->m_start = a_start;
        n->m_end = a_end;
        n->m_increment = a_increment;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }

    struct Select_t // Constructor
    {
        stmt_t base;
        expr_t* m_test;
        case_stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_default; size_t n_default; // Sequence
    };
    static inline ast_t* make_Select_t(Allocator &al, const Location &a_loc, expr_t* a_test, case_stmt_t** a_body, size_t n_body, stmt_t** a_default, size_t n_default) {
        Select_t *n;
        n = al.make_new<Select_t>();
        n->base.type = stmtType::Select;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_default = a_default;
        n->n_default = n_default;
        return (ast_t*)n;
    }

    struct Cycle_t // Constructor
    {
        stmt_t base;
    };
    static inline ast_t* make_Cycle_t(Allocator &al, const Location &a_loc) {
        Cycle_t *n;
        n = al.make_new<Cycle_t>();
        n->base.type = stmtType::Cycle;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }

    struct Exit_t // Constructor
    {
        stmt_t base;
    };
    static inline ast_t* make_Exit_t(Allocator &al, const Location &a_loc) {
        Exit_t *n;
        n = al.make_new<Exit_t>();
        n->base.type = stmtType::Exit;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }

    struct Return_t // Constructor
    {
        stmt_t base;
    };
    static inline ast_t* make_Return_t(Allocator &al, const Location &a_loc) {
        Return_t *n;
        n = al.make_new<Return_t>();
        n->base.type = stmtType::Return;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        return (ast_t*)n;
    }

    struct WhileLoop_t // Constructor
    {
        stmt_t base;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_WhileLoop_t(Allocator &al, const Location &a_loc, expr_t* a_test, stmt_t** a_body, size_t n_body) {
        WhileLoop_t *n;
        n = al.make_new<WhileLoop_t>();
        n->base.type = stmtType::WhileLoop;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }

    struct Print_t // Constructor
    {
        stmt_t base;
        char* m_fmt;
        expr_t** m_values; size_t n_values; // Sequence
    };
    static inline ast_t* make_Print_t(Allocator &al, const Location &a_loc, char* a_fmt, expr_t** a_values, size_t n_values) {
        Print_t *n;
        n = al.make_new<Print_t>();
        n->base.type = stmtType::Print;
        n->base.base.type = astType::stmt;
        n->base.base.loc = a_loc;
        n->m_fmt = a_fmt;
        n->m_values = a_values;
        n->n_values = n_values;
        return (ast_t*)n;
    }



enum exprType // Types
{
    BoolOp, BinOp, UnaryOp, Compare, FuncCall, FuncCallOrArray, Array, ArrayInitializer, Num, Real, Str, Name, Constant
};

struct expr_t // Sum
{
    ast_t base;
    exprType type;
};

    struct BoolOp_t // Constructor
    {
        expr_t base;
        expr_t* m_left;
        boolopType m_op;
        expr_t* m_right;
    };
    static inline ast_t* make_BoolOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, boolopType a_op, expr_t* a_right) {
        BoolOp_t *n;
        n = al.make_new<BoolOp_t>();
        n->base.type = exprType::BoolOp;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        return (ast_t*)n;
    }

    struct BinOp_t // Constructor
    {
        expr_t base;
        expr_t* m_left;
        operatorType m_op;
        expr_t* m_right;
    };
    static inline ast_t* make_BinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, operatorType a_op, expr_t* a_right) {
        BinOp_t *n;
        n = al.make_new<BinOp_t>();
        n->base.type = exprType::BinOp;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        return (ast_t*)n;
    }

    struct UnaryOp_t // Constructor
    {
        expr_t base;
        unaryopType m_op;
        expr_t* m_operand;
    };
    static inline ast_t* make_UnaryOp_t(Allocator &al, const Location &a_loc, unaryopType a_op, expr_t* a_operand) {
        UnaryOp_t *n;
        n = al.make_new<UnaryOp_t>();
        n->base.type = exprType::UnaryOp;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_op = a_op;
        n->m_operand = a_operand;
        return (ast_t*)n;
    }

    struct Compare_t // Constructor
    {
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
    };
    static inline ast_t* make_Compare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right) {
        Compare_t *n;
        n = al.make_new<Compare_t>();
        n->base.type = exprType::Compare;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        return (ast_t*)n;
    }

    struct FuncCall_t // Constructor
    {
        expr_t base;
        char* m_func;
        expr_t** m_args; size_t n_args; // Sequence
        keyword_t* m_keywords; size_t n_keywords; // Sequence
    };
    static inline ast_t* make_FuncCall_t(Allocator &al, const Location &a_loc, char* a_func, expr_t** a_args, size_t n_args, keyword_t* a_keywords, size_t n_keywords) {
        FuncCall_t *n;
        n = al.make_new<FuncCall_t>();
        n->base.type = exprType::FuncCall;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_func = a_func;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_keywords = a_keywords;
        n->n_keywords = n_keywords;
        return (ast_t*)n;
    }

    struct FuncCallOrArray_t // Constructor
    {
        expr_t base;
        char* m_func;
        expr_t** m_args; size_t n_args; // Sequence
        keyword_t* m_keywords; size_t n_keywords; // Sequence
    };
    static inline ast_t* make_FuncCallOrArray_t(Allocator &al, const Location &a_loc, char* a_func, expr_t** a_args, size_t n_args, keyword_t* a_keywords, size_t n_keywords) {
        FuncCallOrArray_t *n;
        n = al.make_new<FuncCallOrArray_t>();
        n->base.type = exprType::FuncCallOrArray;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_func = a_func;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_keywords = a_keywords;
        n->n_keywords = n_keywords;
        return (ast_t*)n;
    }

    struct Array_t // Constructor
    {
        expr_t base;
        char* m_name;
        array_index_t** m_args; size_t n_args; // Sequence
    };
    static inline ast_t* make_Array_t(Allocator &al, const Location &a_loc, char* a_name, array_index_t** a_args, size_t n_args) {
        Array_t *n;
        n = al.make_new<Array_t>();
        n->base.type = exprType::Array;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        return (ast_t*)n;
    }

    struct ArrayInitializer_t // Constructor
    {
        expr_t base;
        expr_t** m_args; size_t n_args; // Sequence
    };
    static inline ast_t* make_ArrayInitializer_t(Allocator &al, const Location &a_loc, expr_t** a_args, size_t n_args) {
        ArrayInitializer_t *n;
        n = al.make_new<ArrayInitializer_t>();
        n->base.type = exprType::ArrayInitializer;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        return (ast_t*)n;
    }

    struct Num_t // Constructor
    {
        expr_t base;
        int /* object */ m_n;
    };
    static inline ast_t* make_Num_t(Allocator &al, const Location &a_loc, int /* object */ a_n) {
        Num_t *n;
        n = al.make_new<Num_t>();
        n->base.type = exprType::Num;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_n = a_n;
        return (ast_t*)n;
    }

    struct Real_t // Constructor
    {
        expr_t base;
        char* m_n;
    };
    static inline ast_t* make_Real_t(Allocator &al, const Location &a_loc, char* a_n) {
        Real_t *n;
        n = al.make_new<Real_t>();
        n->base.type = exprType::Real;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_n = a_n;
        return (ast_t*)n;
    }

    struct Str_t // Constructor
    {
        expr_t base;
        char* m_s;
    };
    static inline ast_t* make_Str_t(Allocator &al, const Location &a_loc, char* a_s) {
        Str_t *n;
        n = al.make_new<Str_t>();
        n->base.type = exprType::Str;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_s = a_s;
        return (ast_t*)n;
    }

    struct Name_t // Constructor
    {
        expr_t base;
        char* m_id;
    };
    static inline ast_t* make_Name_t(Allocator &al, const Location &a_loc, char* a_id) {
        Name_t *n;
        n = al.make_new<Name_t>();
        n->base.type = exprType::Name;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_id = a_id;
        return (ast_t*)n;
    }

    struct Constant_t // Constructor
    {
        expr_t base;
        bool m_value;
    };
    static inline ast_t* make_Constant_t(Allocator &al, const Location &a_loc, bool a_value) {
        Constant_t *n;
        n = al.make_new<Constant_t>();
        n->base.type = exprType::Constant;
        n->base.base.type = astType::expr;
        n->base.base.loc = a_loc;
        n->m_value = a_value;
        return (ast_t*)n;
    }



enum attributeType // Types
{
    Attribute
};

struct attribute_t // Sum
{
    ast_t base;
    attributeType type;
};

    struct Attribute_t // Constructor
    {
        attribute_t base;
        char* m_name;
        attribute_arg_t* m_args; size_t n_args; // Sequence
    };
    static inline ast_t* make_Attribute_t(Allocator &al, const Location &a_loc, char* a_name, attribute_arg_t* a_args, size_t n_args) {
        Attribute_t *n;
        n = al.make_new<Attribute_t>();
        n->base.type = attributeType::Attribute;
        n->base.base.type = astType::attribute;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        return (ast_t*)n;
    }



enum tbindType // Types
{
    Bind
};

struct tbind_t // Sum
{
    ast_t base;
    tbindType type;
};

    struct Bind_t // Constructor
    {
        tbind_t base;
        keyword_t* m_args; size_t n_args; // Sequence
    };
    static inline ast_t* make_Bind_t(Allocator &al, const Location &a_loc, keyword_t* a_args, size_t n_args) {
        Bind_t *n;
        n = al.make_new<Bind_t>();
        n->base.type = tbindType::Bind;
        n->base.base.type = astType::tbind;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        return (ast_t*)n;
    }



enum array_indexType // Types
{
    ArrayIndex
};

struct array_index_t // Sum
{
    ast_t base;
    array_indexType type;
};

    struct ArrayIndex_t // Constructor
    {
        array_index_t base;
        expr_t* m_left;
        expr_t* m_right;
        expr_t* m_step;
    };
    static inline ast_t* make_ArrayIndex_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, expr_t* a_step) {
        ArrayIndex_t *n;
        n = al.make_new<ArrayIndex_t>();
        n->base.type = array_indexType::ArrayIndex;
        n->base.base.type = astType::array_index;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_step = a_step;
        return (ast_t*)n;
    }



enum case_stmtType // Types
{
    CaseStmt
};

struct case_stmt_t // Sum
{
    ast_t base;
    case_stmtType type;
};

    struct CaseStmt_t // Constructor
    {
        case_stmt_t base;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline ast_t* make_CaseStmt_t(Allocator &al, const Location &a_loc, expr_t* a_test, stmt_t** a_body, size_t n_body) {
        CaseStmt_t *n;
        n = al.make_new<CaseStmt_t>();
        n->base.type = case_stmtType::CaseStmt;
        n->base.base.type = astType::case_stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        return (ast_t*)n;
    }



enum use_symbolType // Types
{
    UseSymbol
};

struct use_symbol_t // Sum
{
    ast_t base;
    use_symbolType type;
};

    struct UseSymbol_t // Constructor
    {
        use_symbol_t base;
        char* m_sym;
        char* m_rename;
    };
    static inline ast_t* make_UseSymbol_t(Allocator &al, const Location &a_loc, char* a_sym, char* a_rename) {
        UseSymbol_t *n;
        n = al.make_new<UseSymbol_t>();
        n->base.type = use_symbolType::UseSymbol;
        n->base.base.type = astType::use_symbol;
        n->base.base.loc = a_loc;
        n->m_sym = a_sym;
        n->m_rename = a_rename;
        return (ast_t*)n;
    }





/******************************************************************************/
// Visitor functions

template <class Visitor>
static void visit_unit_t(const unit_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == astType::unit)
    switch (x.type) {
        case unitType::TranslationUnit: { v.visit_TranslationUnit((const TranslationUnit_t &)x); return; }
    }
}

template <class Visitor>
static void visit_mod_t(const mod_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == astType::mod)
    switch (x.type) {
        case modType::Module: { v.visit_Module((const Module_t &)x); return; }
        case modType::Program: { v.visit_Program((const Program_t &)x); return; }
    }
}

template <class Visitor>
static void visit_program_unit_t(const program_unit_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == astType::program_unit)
    switch (x.type) {
        case program_unitType::Subroutine: { v.visit_Subroutine((const Subroutine_t &)x); return; }
        case program_unitType::Function: { v.visit_Function((const Function_t &)x); return; }
    }
}

template <class Visitor>
static void visit_unit_decl1_t(const unit_decl1_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == astType::unit_decl1)
    switch (x.type) {
        case unit_decl1Type::Use: { v.visit_Use((const Use_t &)x); return; }
    }
}

template <class Visitor>
static void visit_unit_decl2_t(const unit_decl2_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == astType::unit_decl2)
    switch (x.type) {
        case unit_decl2Type::Declaration: { v.visit_Declaration((const Declaration_t &)x); return; }
        case unit_decl2Type::Private: { v.visit_Private((const Private_t &)x); return; }
        case unit_decl2Type::Public: { v.visit_Public((const Public_t &)x); return; }
        case unit_decl2Type::Interface: { v.visit_Interface((const Interface_t &)x); return; }
        case unit_decl2Type::Interface2: { v.visit_Interface2((const Interface2_t &)x); return; }
    }
}

template <class Visitor>
static void visit_stmt_t(const stmt_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == astType::stmt)
    switch (x.type) {
        case stmtType::Assignment: { v.visit_Assignment((const Assignment_t &)x); return; }
        case stmtType::Associate: { v.visit_Associate((const Associate_t &)x); return; }
        case stmtType::SubroutineCall: { v.visit_SubroutineCall((const SubroutineCall_t &)x); return; }
        case stmtType::BuiltinCall: { v.visit_BuiltinCall((const BuiltinCall_t &)x); return; }
        case stmtType::If: { v.visit_If((const If_t &)x); return; }
        case stmtType::Where: { v.visit_Where((const Where_t &)x); return; }
        case stmtType::Stop: { v.visit_Stop((const Stop_t &)x); return; }
        case stmtType::ErrorStop: { v.visit_ErrorStop((const ErrorStop_t &)x); return; }
        case stmtType::DoLoop: { v.visit_DoLoop((const DoLoop_t &)x); return; }
        case stmtType::Select: { v.visit_Select((const Select_t &)x); return; }
        case stmtType::Cycle: { v.visit_Cycle((const Cycle_t &)x); return; }
        case stmtType::Exit: { v.visit_Exit((const Exit_t &)x); return; }
        case stmtType::Return: { v.visit_Return((const Return_t &)x); return; }
        case stmtType::WhileLoop: { v.visit_WhileLoop((const WhileLoop_t &)x); return; }
        case stmtType::Print: { v.visit_Print((const Print_t &)x); return; }
    }
}

template <class Visitor>
static void visit_expr_t(const expr_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == astType::expr)
    switch (x.type) {
        case exprType::BoolOp: { v.visit_BoolOp((const BoolOp_t &)x); return; }
        case exprType::BinOp: { v.visit_BinOp((const BinOp_t &)x); return; }
        case exprType::UnaryOp: { v.visit_UnaryOp((const UnaryOp_t &)x); return; }
        case exprType::Compare: { v.visit_Compare((const Compare_t &)x); return; }
        case exprType::FuncCall: { v.visit_FuncCall((const FuncCall_t &)x); return; }
        case exprType::FuncCallOrArray: { v.visit_FuncCallOrArray((const FuncCallOrArray_t &)x); return; }
        case exprType::Array: { v.visit_Array((const Array_t &)x); return; }
        case exprType::ArrayInitializer: { v.visit_ArrayInitializer((const ArrayInitializer_t &)x); return; }
        case exprType::Num: { v.visit_Num((const Num_t &)x); return; }
        case exprType::Real: { v.visit_Real((const Real_t &)x); return; }
        case exprType::Str: { v.visit_Str((const Str_t &)x); return; }
        case exprType::Name: { v.visit_Name((const Name_t &)x); return; }
        case exprType::Constant: { v.visit_Constant((const Constant_t &)x); return; }
    }
}

template <class Visitor>
static void visit_attribute_t(const attribute_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == astType::attribute)
    switch (x.type) {
        case attributeType::Attribute: { v.visit_Attribute((const Attribute_t &)x); return; }
    }
}

template <class Visitor>
static void visit_tbind_t(const tbind_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == astType::tbind)
    switch (x.type) {
        case tbindType::Bind: { v.visit_Bind((const Bind_t &)x); return; }
    }
}

template <class Visitor>
static void visit_array_index_t(const array_index_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == astType::array_index)
    switch (x.type) {
        case array_indexType::ArrayIndex: { v.visit_ArrayIndex((const ArrayIndex_t &)x); return; }
    }
}

template <class Visitor>
static void visit_case_stmt_t(const case_stmt_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == astType::case_stmt)
    switch (x.type) {
        case case_stmtType::CaseStmt: { v.visit_CaseStmt((const CaseStmt_t &)x); return; }
    }
}

template <class Visitor>
static void visit_use_symbol_t(const use_symbol_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == astType::use_symbol)
    switch (x.type) {
        case use_symbolType::UseSymbol: { v.visit_UseSymbol((const UseSymbol_t &)x); return; }
    }
}



template <class Visitor>
static void visit_ast_t(const ast_t &x, Visitor &v) {
    switch (x.type) {
        case astType::unit: { v.visit_unit((const unit_t &)x); return; }
        case astType::mod: { v.visit_mod((const mod_t &)x); return; }
        case astType::program_unit: { v.visit_program_unit((const program_unit_t &)x); return; }
        case astType::unit_decl1: { v.visit_unit_decl1((const unit_decl1_t &)x); return; }
        case astType::unit_decl2: { v.visit_unit_decl2((const unit_decl2_t &)x); return; }
        case astType::stmt: { v.visit_stmt((const stmt_t &)x); return; }
        case astType::expr: { v.visit_expr((const expr_t &)x); return; }
        case astType::attribute: { v.visit_attribute((const attribute_t &)x); return; }
        case astType::tbind: { v.visit_tbind((const tbind_t &)x); return; }
        case astType::array_index: { v.visit_array_index((const array_index_t &)x); return; }
        case astType::case_stmt: { v.visit_case_stmt((const case_stmt_t &)x); return; }
        case astType::use_symbol: { v.visit_use_symbol((const use_symbol_t &)x); return; }
    }
}



/******************************************************************************/
// Visitor base class

template <class Derived>
class BaseVisitor
{
private:
    Derived& self() { return static_cast<Derived&>(*this); }
public:
    void visit_ast(const ast_t &b) { visit_ast_t(b, self()); }
    void visit_unit(const unit_t &b) { visit_unit_t(b, self()); }
        void visit_TranslationUnit(const TranslationUnit_t &x) { throw LFortran::LFortranException("visit_TranslationUnit() not implemented"); }
    void visit_mod(const mod_t &b) { visit_mod_t(b, self()); }
        void visit_Module(const Module_t &x) { throw LFortran::LFortranException("visit_Module() not implemented"); }
        void visit_Program(const Program_t &x) { throw LFortran::LFortranException("visit_Program() not implemented"); }
    void visit_program_unit(const program_unit_t &b) { visit_program_unit_t(b, self()); }
        void visit_Subroutine(const Subroutine_t &x) { throw LFortran::LFortranException("visit_Subroutine() not implemented"); }
        void visit_Function(const Function_t &x) { throw LFortran::LFortranException("visit_Function() not implemented"); }
    void visit_unit_decl1(const unit_decl1_t &b) { visit_unit_decl1_t(b, self()); }
        void visit_Use(const Use_t &x) { throw LFortran::LFortranException("visit_Use() not implemented"); }
    void visit_unit_decl2(const unit_decl2_t &b) { visit_unit_decl2_t(b, self()); }
        void visit_Declaration(const Declaration_t &x) { throw LFortran::LFortranException("visit_Declaration() not implemented"); }
        void visit_Private(const Private_t &x) { throw LFortran::LFortranException("visit_Private() not implemented"); }
        void visit_Public(const Public_t &x) { throw LFortran::LFortranException("visit_Public() not implemented"); }
        void visit_Interface(const Interface_t &x) { throw LFortran::LFortranException("visit_Interface() not implemented"); }
        void visit_Interface2(const Interface2_t &x) { throw LFortran::LFortranException("visit_Interface2() not implemented"); }
    void visit_stmt(const stmt_t &b) { visit_stmt_t(b, self()); }
        void visit_Assignment(const Assignment_t &x) { throw LFortran::LFortranException("visit_Assignment() not implemented"); }
        void visit_Associate(const Associate_t &x) { throw LFortran::LFortranException("visit_Associate() not implemented"); }
        void visit_SubroutineCall(const SubroutineCall_t &x) { throw LFortran::LFortranException("visit_SubroutineCall() not implemented"); }
        void visit_BuiltinCall(const BuiltinCall_t &x) { throw LFortran::LFortranException("visit_BuiltinCall() not implemented"); }
        void visit_If(const If_t &x) { throw LFortran::LFortranException("visit_If() not implemented"); }
        void visit_Where(const Where_t &x) { throw LFortran::LFortranException("visit_Where() not implemented"); }
        void visit_Stop(const Stop_t &x) { throw LFortran::LFortranException("visit_Stop() not implemented"); }
        void visit_ErrorStop(const ErrorStop_t &x) { throw LFortran::LFortranException("visit_ErrorStop() not implemented"); }
        void visit_DoLoop(const DoLoop_t &x) { throw LFortran::LFortranException("visit_DoLoop() not implemented"); }
        void visit_Select(const Select_t &x) { throw LFortran::LFortranException("visit_Select() not implemented"); }
        void visit_Cycle(const Cycle_t &x) { throw LFortran::LFortranException("visit_Cycle() not implemented"); }
        void visit_Exit(const Exit_t &x) { throw LFortran::LFortranException("visit_Exit() not implemented"); }
        void visit_Return(const Return_t &x) { throw LFortran::LFortranException("visit_Return() not implemented"); }
        void visit_WhileLoop(const WhileLoop_t &x) { throw LFortran::LFortranException("visit_WhileLoop() not implemented"); }
        void visit_Print(const Print_t &x) { throw LFortran::LFortranException("visit_Print() not implemented"); }
    void visit_expr(const expr_t &b) { visit_expr_t(b, self()); }
        void visit_BoolOp(const BoolOp_t &x) { throw LFortran::LFortranException("visit_BoolOp() not implemented"); }
        void visit_BinOp(const BinOp_t &x) { throw LFortran::LFortranException("visit_BinOp() not implemented"); }
        void visit_UnaryOp(const UnaryOp_t &x) { throw LFortran::LFortranException("visit_UnaryOp() not implemented"); }
        void visit_Compare(const Compare_t &x) { throw LFortran::LFortranException("visit_Compare() not implemented"); }
        void visit_FuncCall(const FuncCall_t &x) { throw LFortran::LFortranException("visit_FuncCall() not implemented"); }
        void visit_FuncCallOrArray(const FuncCallOrArray_t &x) { throw LFortran::LFortranException("visit_FuncCallOrArray() not implemented"); }
        void visit_Array(const Array_t &x) { throw LFortran::LFortranException("visit_Array() not implemented"); }
        void visit_ArrayInitializer(const ArrayInitializer_t &x) { throw LFortran::LFortranException("visit_ArrayInitializer() not implemented"); }
        void visit_Num(const Num_t &x) { throw LFortran::LFortranException("visit_Num() not implemented"); }
        void visit_Real(const Real_t &x) { throw LFortran::LFortranException("visit_Real() not implemented"); }
        void visit_Str(const Str_t &x) { throw LFortran::LFortranException("visit_Str() not implemented"); }
        void visit_Name(const Name_t &x) { throw LFortran::LFortranException("visit_Name() not implemented"); }
        void visit_Constant(const Constant_t &x) { throw LFortran::LFortranException("visit_Constant() not implemented"); }
    void visit_attribute(const attribute_t &b) { visit_attribute_t(b, self()); }
        void visit_Attribute(const Attribute_t &x) { throw LFortran::LFortranException("visit_Attribute() not implemented"); }
    void visit_tbind(const tbind_t &b) { visit_tbind_t(b, self()); }
        void visit_Bind(const Bind_t &x) { throw LFortran::LFortranException("visit_Bind() not implemented"); }
    void visit_array_index(const array_index_t &b) { visit_array_index_t(b, self()); }
        void visit_ArrayIndex(const ArrayIndex_t &x) { throw LFortran::LFortranException("visit_ArrayIndex() not implemented"); }
    void visit_case_stmt(const case_stmt_t &b) { visit_case_stmt_t(b, self()); }
        void visit_CaseStmt(const CaseStmt_t &x) { throw LFortran::LFortranException("visit_CaseStmt() not implemented"); }
    void visit_use_symbol(const use_symbol_t &b) { visit_use_symbol_t(b, self()); }
        void visit_UseSymbol(const UseSymbol_t &x) { throw LFortran::LFortranException("visit_UseSymbol() not implemented"); }
};


/******************************************************************************/
// Walk Visitor base class

template <class Derived>
class BaseWalkVisitor : public BaseVisitor<Derived>
{
public:
    void visit_TranslationUnit(const TranslationUnit_t &x) {
    }
    void visit_Module(const Module_t &x) {
        // self.visit_sequence(node.use)
        // self.visit_sequence(node.decl)
        // self.visit_sequence(node.contains)
    }
    void visit_Program(const Program_t &x) {
        // self.visit_sequence(node.use)
        // self.visit_sequence(node.decl)
        // self.visit_sequence(node.body)
        // self.visit_sequence(node.contains)
    }
    void visit_Subroutine(const Subroutine_t &x) {
        // self.visit_sequence(node.args)
        // self.visit_sequence(node.use)
        // self.visit_sequence(node.decl)
        // self.visit_sequence(node.body)
        // self.visit_sequence(node.contains)
    }
    void visit_Function(const Function_t &x) {
        // self.visit_sequence(node.args)
        //if node.return_var:
            this->visit_expr(*x.m_return_var);
        //if node.bind:
            this->visit_tbind(*x.m_bind);
        // self.visit_sequence(node.use)
        // self.visit_sequence(node.decl)
        // self.visit_sequence(node.body)
        // self.visit_sequence(node.contains)
    }
    void visit_Use(const Use_t &x) {
        // self.visit_sequence(node.symbols)
    }
    void visit_Declaration(const Declaration_t &x) {
        // self.visit_sequence(node.vars)
    }
    void visit_Private(const Private_t &x) {
    }
    void visit_Public(const Public_t &x) {
    }
    void visit_Interface(const Interface_t &x) {
    }
    void visit_Interface2(const Interface2_t &x) {
        // self.visit_sequence(node.procs)
    }
    void visit_Assignment(const Assignment_t &x) {
        this->visit_expr(*x.m_target);
        this->visit_expr(*x.m_value);
    }
    void visit_Associate(const Associate_t &x) {
        this->visit_expr(*x.m_target);
        this->visit_expr(*x.m_value);
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        // self.visit_sequence(node.args)
    }
    void visit_BuiltinCall(const BuiltinCall_t &x) {
        // self.visit_sequence(node.args)
    }
    void visit_If(const If_t &x) {
        this->visit_expr(*x.m_test);
        // self.visit_sequence(node.body)
        // self.visit_sequence(node.orelse)
    }
    void visit_Where(const Where_t &x) {
        this->visit_expr(*x.m_test);
        // self.visit_sequence(node.body)
        // self.visit_sequence(node.orelse)
    }
    void visit_Stop(const Stop_t &x) {
        //if node.code:
            this->visit_expr(*x.m_code);
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
    }
    void visit_DoLoop(const DoLoop_t &x) {
        //if node.start:
            this->visit_expr(*x.m_start);
        //if node.end:
            this->visit_expr(*x.m_end);
        //if node.increment:
            this->visit_expr(*x.m_increment);
        // self.visit_sequence(node.body)
    }
    void visit_Select(const Select_t &x) {
        this->visit_expr(*x.m_test);
        // self.visit_sequence(node.body)
        // self.visit_sequence(node.default)
    }
    void visit_Cycle(const Cycle_t &x) {
    }
    void visit_Exit(const Exit_t &x) {
    }
    void visit_Return(const Return_t &x) {
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        this->visit_expr(*x.m_test);
        // self.visit_sequence(node.body)
    }
    void visit_Print(const Print_t &x) {
        // self.visit_sequence(node.values)
    }
    void visit_BoolOp(const BoolOp_t &x) {
        this->visit_expr(*x.m_left);
        this->visit_expr(*x.m_right);
    }
    void visit_BinOp(const BinOp_t &x) {
        this->visit_expr(*x.m_left);
        this->visit_expr(*x.m_right);
    }
    void visit_UnaryOp(const UnaryOp_t &x) {
        this->visit_expr(*x.m_operand);
    }
    void visit_Compare(const Compare_t &x) {
        this->visit_expr(*x.m_left);
        this->visit_expr(*x.m_right);
    }
    void visit_FuncCall(const FuncCall_t &x) {
        // self.visit_sequence(node.args)
        // self.visit_sequence(node.keywords)
    }
    void visit_FuncCallOrArray(const FuncCallOrArray_t &x) {
        // self.visit_sequence(node.args)
        // self.visit_sequence(node.keywords)
    }
    void visit_Array(const Array_t &x) {
        // self.visit_sequence(node.args)
    }
    void visit_ArrayInitializer(const ArrayInitializer_t &x) {
        // self.visit_sequence(node.args)
    }
    void visit_Num(const Num_t &x) {
    }
    void visit_Real(const Real_t &x) {
    }
    void visit_Str(const Str_t &x) {
    }
    void visit_Name(const Name_t &x) {
    }
    void visit_Constant(const Constant_t &x) {
    }
    void visit_decl(const decl_t &x) {
        // self.visit_sequence(node.dims)
        // self.visit_sequence(node.attrs)
        //if node.initializer:
            this->visit_expr(*x.m_initializer);
    }
    void visit_dimension(const dimension_t &x) {
        //if node.start:
            this->visit_expr(*x.m_start);
        //if node.end:
            this->visit_expr(*x.m_end);
    }
    void visit_Attribute(const Attribute_t &x) {
        // self.visit_sequence(node.args)
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
    }
    void visit_arg(const arg_t &x) {
    }
    void visit_keyword(const keyword_t &x) {
        this->visit_expr(*x.m_value);
    }
    void visit_Bind(const Bind_t &x) {
        // self.visit_sequence(node.args)
    }
    void visit_ArrayIndex(const ArrayIndex_t &x) {
        //if node.left:
            this->visit_expr(*x.m_left);
        //if node.right:
            this->visit_expr(*x.m_right);
        //if node.step:
            this->visit_expr(*x.m_step);
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        this->visit_expr(*x.m_test);
        // self.visit_sequence(node.body)
    }
    void visit_UseSymbol(const UseSymbol_t &x) {
    }
};


/******************************************************************************/
// Walk Visitor base class

template <class Derived>
class PickleBaseVisitor : public BaseVisitor<Derived>
{
public:
    std::string s;
    bool use_colors;
public:
    PickleBaseVisitor() : use_colors(false) { s.reserve(100000); }
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("translationunit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("Unimplementedobject");
        s.append(")");
    }
    void visit_Module(const Module_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("module");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_use; i++) {
            this->visit_unit_decl1(*x.m_use[i]);
            if (i < x.n_use-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            this->visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_contains; i++) {
            this->visit_program_unit(*x.m_contains[i]);
            if (i < x.n_contains-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Program(const Program_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("prog");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_use; i++) {
            this->visit_unit_decl1(*x.m_use[i]);
            if (i < x.n_use-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            this->visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_contains; i++) {
            this->visit_program_unit(*x.m_contains[i]);
            if (i < x.n_contains-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Subroutine(const Subroutine_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("sub");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_arg(x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_use; i++) {
            this->visit_unit_decl1(*x.m_use[i]);
            if (i < x.n_use-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            this->visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_contains; i++) {
            this->visit_program_unit(*x.m_contains[i]);
            if (i < x.n_contains-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Function(const Function_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("fn");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_arg(x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        if (x.m_return_type) {
            s.append(x.m_return_type);
        } else {
            s.append("()");
        }
        s.append(" ");
        if (x.m_return_var) {
            this->visit_expr(*x.m_return_var);
        } else {
            s.append("()");
        }
        s.append(" ");
        if (x.m_bind) {
            this->visit_tbind(*x.m_bind);
        } else {
            s.append("()");
        }
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_use; i++) {
            this->visit_unit_decl1(*x.m_use[i]);
            if (i < x.n_use-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_decl; i++) {
            this->visit_unit_decl2(*x.m_decl[i]);
            if (i < x.n_decl-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_contains; i++) {
            this->visit_program_unit(*x.m_contains[i]);
            if (i < x.n_contains-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Use(const Use_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("use");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_module);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_symbols; i++) {
            this->visit_use_symbol(*x.m_symbols[i]);
            if (i < x.n_symbols-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Declaration(const Declaration_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("decl");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_vars; i++) {
            this->visit_decl(x.m_vars[i]);
            if (i < x.n_vars-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Private(const Private_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("private");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("Unimplementedidentifier");
        s.append(")");
    }
    void visit_Public(const Public_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("public");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("Unimplementedidentifier");
        s.append(")");
    }
    void visit_Interface(const Interface_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("interface");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("Unimplementedidentifier");
        s.append(")");
    }
    void visit_Interface2(const Interface2_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("interface2");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_procs; i++) {
            this->visit_program_unit(*x.m_procs[i]);
            if (i < x.n_procs-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Assignment(const Assignment_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("=");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_target);
        s.append(" ");
        this->visit_expr(*x.m_value);
        s.append(")");
    }
    void visit_Associate(const Associate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("=>");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_target);
        s.append(" ");
        this->visit_expr(*x.m_value);
        s.append(")");
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("subroutinecall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_BuiltinCall(const BuiltinCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("builtincall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_If(const If_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("if");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_test);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            this->visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Where(const Where_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("where");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_test);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            this->visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Stop(const Stop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("stop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        if (x.m_code) {
            this->visit_expr(*x.m_code);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("errorstop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
    }
    void visit_DoLoop(const DoLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("do");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        if (x.m_var) {
            s.append(x.m_var);
        } else {
            s.append("()");
        }
        s.append(" ");
        if (x.m_start) {
            this->visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        s.append(" ");
        if (x.m_end) {
            this->visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        s.append(" ");
        if (x.m_increment) {
            this->visit_expr(*x.m_increment);
        } else {
            s.append("()");
        }
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Select(const Select_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("select");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_test);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_case_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_default; i++) {
            this->visit_stmt(*x.m_default[i]);
            if (i < x.n_default-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Cycle(const Cycle_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("cycle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
    }
    void visit_Exit(const Exit_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("exit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
    }
    void visit_Return(const Return_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("return");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("while");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_test);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Print(const Print_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("print");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        if (x.m_fmt) {
            s.append(x.m_fmt);
        } else {
            s.append("()");
        }
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            this->visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_BoolOp(const BoolOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("boolop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_left);
        s.append(" ");
        s.append("boolopType" + std::to_string(x.m_op));
        s.append(" ");
        this->visit_expr(*x.m_right);
        s.append(")");
    }
    void visit_BinOp(const BinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("binop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_left);
        s.append(" ");
        s.append("operatorType" + std::to_string(x.m_op));
        s.append(" ");
        this->visit_expr(*x.m_right);
        s.append(")");
    }
    void visit_UnaryOp(const UnaryOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("unaryop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("unaryopType" + std::to_string(x.m_op));
        s.append(" ");
        this->visit_expr(*x.m_operand);
        s.append(")");
    }
    void visit_Compare(const Compare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("compare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_left);
        s.append(" ");
        s.append("cmpopType" + std::to_string(x.m_op));
        s.append(" ");
        this->visit_expr(*x.m_right);
        s.append(")");
    }
    void visit_FuncCall(const FuncCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("funccall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_func);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_keywords; i++) {
            this->visit_keyword(x.m_keywords[i]);
            if (i < x.n_keywords-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_FuncCallOrArray(const FuncCallOrArray_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("funccallorarray");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_func);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_keywords; i++) {
            this->visit_keyword(x.m_keywords[i]);
            if (i < x.n_keywords-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Array(const Array_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("array");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_array_index(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_ArrayInitializer(const ArrayInitializer_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("arrayinitializer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Num(const Num_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("num");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("Unimplementedobject");
        s.append(")");
    }
    void visit_Real(const Real_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("real");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("\"" + std::string(x.m_n) + "\"");
        s.append(")");
    }
    void visit_Str(const Str_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("str");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("\"" + std::string(x.m_s) + "\"");
        s.append(")");
    }
    void visit_Name(const Name_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("name");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_id);
        s.append(")");
    }
    void visit_Constant(const Constant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("constant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("Unimplementedconstant");
        s.append(")");
    }
    void visit_decl(const decl_t &x) {
        s.append("(");
        s.append(x.m_sym);
        s.append(" ");
        s.append("\"" + std::string(x.m_sym_type) + "\"");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dims; i++) {
            this->visit_dimension(x.m_dims[i]);
            if (i < x.n_dims-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_attrs; i++) {
            this->visit_attribute(*x.m_attrs[i]);
            if (i < x.n_attrs-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        if (x.m_initializer) {
            this->visit_expr(*x.m_initializer);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_dimension(const dimension_t &x) {
        s.append("(");
        if (x.m_start) {
            this->visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        s.append(" ");
        if (x.m_end) {
            this->visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_Attribute(const Attribute_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("attribute");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_attribute_arg(x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
        s.append("(");
        s.append(x.m_arg);
        s.append(")");
    }
    void visit_arg(const arg_t &x) {
        s.append("(");
        s.append(x.m_arg);
        s.append(")");
    }
    void visit_keyword(const keyword_t &x) {
        s.append("(");
        if (x.m_arg) {
            s.append(x.m_arg);
        } else {
            s.append("()");
        }
        s.append(" ");
        this->visit_expr(*x.m_value);
        s.append(")");
    }
    void visit_Bind(const Bind_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("bind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_keyword(x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_ArrayIndex(const ArrayIndex_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("arrayindex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        if (x.m_left) {
            this->visit_expr(*x.m_left);
        } else {
            s.append("()");
        }
        s.append(" ");
        if (x.m_right) {
            this->visit_expr(*x.m_right);
        } else {
            s.append("()");
        }
        s.append(" ");
        if (x.m_step) {
            this->visit_expr(*x.m_step);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("casestmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_test);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_UseSymbol(const UseSymbol_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("usesymbol");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_sym);
        s.append(" ");
        if (x.m_rename) {
            s.append(x.m_rename);
        } else {
            s.append("()");
        }
        s.append(")");
    }
};


} // namespace LFortran::AST

#endif // LFORTRAN_AST_H
