# Generated by utils/asdl_py.py

class AST(object):
    _attrs_ = ['lineno', 'col_offset']

    def __init__(self):
        self._fields = ()
        self._type = None

    def walkabout(self, visitor):
        raise AssertionError("walkabout() implementation not provided")

    def mutate_over(self, visitor):
        raise AssertionError("mutate_over() implementation not provided")


class NodeVisitorNotImplemented(Exception):
    pass

def checkinstance(a, b, opt=False):
    if opt and a is None:
        return
    from .utils import dump
    if not isinstance(a, b):
        if isinstance(a, AST):
            a_dump = dump(a)
        else:
            a_dump = a
        print("Wrong instance: %s, types: a=%s; b=%s" % (a_dump, type(a), b))
    assert isinstance(a, b)

class unit(AST): # Sum
    pass


class TranslationUnit(unit): # Constructor

    def __init__(self, items=[]):
        self.items = items
        assert isinstance(items, list)
        for x in items:
            checkinstance(x, object, False)
        self._fields = ('items',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_TranslationUnit(self)



class mod(AST): # Sum
    pass


class Module(mod): # Constructor

    def __init__(self, name=None, use=[], decl=[], contains=[]):
        self.name = name
        checkinstance(name, str, False)
        self.use = use
        assert isinstance(use, list)
        for x in use:
            checkinstance(x, unit_decl1, False)
        self.decl = decl
        assert isinstance(decl, list)
        for x in decl:
            checkinstance(x, unit_decl2, False)
        self.contains = contains
        assert isinstance(contains, list)
        for x in contains:
            checkinstance(x, program_unit, False)
        self._fields = ('name', 'use', 'decl', 'contains')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Module(self)



class Program(mod): # Constructor

    def __init__(self, name=None, use=[], decl=[], body=[], contains=[]):
        self.name = name
        checkinstance(name, str, False)
        self.use = use
        assert isinstance(use, list)
        for x in use:
            checkinstance(x, unit_decl1, False)
        self.decl = decl
        assert isinstance(decl, list)
        for x in decl:
            checkinstance(x, unit_decl2, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self.contains = contains
        assert isinstance(contains, list)
        for x in contains:
            checkinstance(x, program_unit, False)
        self._fields = ('name', 'use', 'decl', 'body', 'contains')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Program(self)



class program_unit(AST): # Sum

    def __init__(self, lineno=1, col_offset=1):
        self.lineno = lineno
        checkinstance(lineno, int, False)
        self.col_offset = col_offset
        checkinstance(col_offset, int, False)
        self._type = None


class Subroutine(program_unit): # Constructor

    def __init__(self, name=None, args=[], use=[], decl=[], body=[], contains=[], lineno=1, col_offset=1):
        self.name = name
        checkinstance(name, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, arg, False)
        self.use = use
        assert isinstance(use, list)
        for x in use:
            checkinstance(x, unit_decl1, False)
        self.decl = decl
        assert isinstance(decl, list)
        for x in decl:
            checkinstance(x, unit_decl2, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self.contains = contains
        assert isinstance(contains, list)
        for x in contains:
            checkinstance(x, program_unit, False)
        program_unit.__init__(self, lineno, col_offset)
        self._fields = ('name', 'args', 'use', 'decl', 'body', 'contains')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Subroutine(self)



class Function(program_unit): # Constructor

    def __init__(self, name=None, args=[], return_type=None, return_var=None, bind=None, use=[], decl=[], body=[], contains=[], lineno=1, col_offset=1):
        self.name = name
        checkinstance(name, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, arg, False)
        self.return_type = return_type
        checkinstance(return_type, str, True)
        self.return_var = return_var
        checkinstance(return_var, expr, True)
        self.bind = bind
        checkinstance(bind, tbind, True)
        self.use = use
        assert isinstance(use, list)
        for x in use:
            checkinstance(x, unit_decl1, False)
        self.decl = decl
        assert isinstance(decl, list)
        for x in decl:
            checkinstance(x, unit_decl2, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self.contains = contains
        assert isinstance(contains, list)
        for x in contains:
            checkinstance(x, program_unit, False)
        program_unit.__init__(self, lineno, col_offset)
        self._fields = ('name', 'args', 'return_type', 'return_var', 'bind', 'use', 'decl', 'body', 'contains')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Function(self)



class unit_decl1(AST): # Sum

    def __init__(self, lineno=1, col_offset=1):
        self.lineno = lineno
        checkinstance(lineno, int, False)
        self.col_offset = col_offset
        checkinstance(col_offset, int, False)
        self._type = None


class Use(unit_decl1): # Constructor

    def __init__(self, module=None, symbols=[], lineno=1, col_offset=1):
        self.module = module
        checkinstance(module, str, False)
        self.symbols = symbols
        assert isinstance(symbols, list)
        for x in symbols:
            checkinstance(x, use_symbol, False)
        unit_decl1.__init__(self, lineno, col_offset)
        self._fields = ('module', 'symbols')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Use(self)



class unit_decl2(AST): # Sum

    def __init__(self, lineno=1, col_offset=1):
        self.lineno = lineno
        checkinstance(lineno, int, False)
        self.col_offset = col_offset
        checkinstance(col_offset, int, False)
        self._type = None


class Declaration(unit_decl2): # Constructor

    def __init__(self, vars=[], lineno=1, col_offset=1):
        self.vars = vars
        assert isinstance(vars, list)
        for x in vars:
            checkinstance(x, decl, False)
        unit_decl2.__init__(self, lineno, col_offset)
        self._fields = ('vars',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Declaration(self)



class Private(unit_decl2): # Constructor

    def __init__(self, vars=None, lineno=1, col_offset=1):
        self.vars = vars
        assert isinstance(vars, list)
        for x in vars:
            checkinstance(x, str, False)
        unit_decl2.__init__(self, lineno, col_offset)
        self._fields = ('vars',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Private(self)



class Public(unit_decl2): # Constructor

    def __init__(self, vars=None, lineno=1, col_offset=1):
        self.vars = vars
        assert isinstance(vars, list)
        for x in vars:
            checkinstance(x, str, False)
        unit_decl2.__init__(self, lineno, col_offset)
        self._fields = ('vars',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Public(self)



class Interface(unit_decl2): # Constructor

    def __init__(self, name=None, procs=None, lineno=1, col_offset=1):
        self.name = name
        checkinstance(name, str, False)
        self.procs = procs
        assert isinstance(procs, list)
        for x in procs:
            checkinstance(x, str, False)
        unit_decl2.__init__(self, lineno, col_offset)
        self._fields = ('name', 'procs')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Interface(self)



class Interface2(unit_decl2): # Constructor

    def __init__(self, name=None, procs=[], lineno=1, col_offset=1):
        self.name = name
        checkinstance(name, str, True)
        self.procs = procs
        assert isinstance(procs, list)
        for x in procs:
            checkinstance(x, program_unit, False)
        unit_decl2.__init__(self, lineno, col_offset)
        self._fields = ('name', 'procs')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Interface2(self)



class stmt(AST): # Sum

    def __init__(self, lineno=1, col_offset=1):
        self.lineno = lineno
        checkinstance(lineno, int, False)
        self.col_offset = col_offset
        checkinstance(col_offset, int, False)
        self._type = None


class Assignment(stmt): # Constructor

    def __init__(self, target=None, value=None, lineno=1, col_offset=1):
        self.target = target
        checkinstance(target, expr, False)
        self.value = value
        checkinstance(value, expr, False)
        stmt.__init__(self, lineno, col_offset)
        self._fields = ('target', 'value')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Assignment(self)



class Associate(stmt): # Constructor

    def __init__(self, target=None, value=None, lineno=1, col_offset=1):
        self.target = target
        checkinstance(target, expr, False)
        self.value = value
        checkinstance(value, expr, False)
        stmt.__init__(self, lineno, col_offset)
        self._fields = ('target', 'value')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Associate(self)



class SubroutineCall(stmt): # Constructor

    def __init__(self, name=None, args=[], lineno=1, col_offset=1):
        self.name = name
        checkinstance(name, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, expr, False)
        stmt.__init__(self, lineno, col_offset)
        self._fields = ('name', 'args')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_SubroutineCall(self)



class BuiltinCall(stmt): # Constructor

    def __init__(self, name=None, args=[], lineno=1, col_offset=1):
        self.name = name
        checkinstance(name, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, expr, False)
        stmt.__init__(self, lineno, col_offset)
        self._fields = ('name', 'args')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_BuiltinCall(self)



class If(stmt): # Constructor

    def __init__(self, test=None, body=[], orelse=[], lineno=1, col_offset=1):
        self.test = test
        checkinstance(test, expr, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self.orelse = orelse
        assert isinstance(orelse, list)
        for x in orelse:
            checkinstance(x, stmt, False)
        stmt.__init__(self, lineno, col_offset)
        self._fields = ('test', 'body', 'orelse')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_If(self)



class Where(stmt): # Constructor

    def __init__(self, test=None, body=[], orelse=[], lineno=1, col_offset=1):
        self.test = test
        checkinstance(test, expr, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self.orelse = orelse
        assert isinstance(orelse, list)
        for x in orelse:
            checkinstance(x, stmt, False)
        stmt.__init__(self, lineno, col_offset)
        self._fields = ('test', 'body', 'orelse')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Where(self)



class Stop(stmt): # Constructor

    def __init__(self, code=None, lineno=1, col_offset=1):
        self.code = code
        checkinstance(code, expr, True)
        stmt.__init__(self, lineno, col_offset)
        self._fields = ('code',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Stop(self)



class ErrorStop(stmt): # Constructor

    def __init__(self, lineno=1, col_offset=1):
        stmt.__init__(self, lineno, col_offset)
        self._fields = ()
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_ErrorStop(self)



class DoLoop(stmt): # Constructor

    def __init__(self, var=None, start=None, end=None, increment=None, body=[], lineno=1, col_offset=1):
        self.var = var
        checkinstance(var, str, True)
        self.start = start
        checkinstance(start, expr, True)
        self.end = end
        checkinstance(end, expr, True)
        self.increment = increment
        checkinstance(increment, expr, True)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        stmt.__init__(self, lineno, col_offset)
        self._fields = ('var', 'start', 'end', 'increment', 'body')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_DoLoop(self)



class Select(stmt): # Constructor

    def __init__(self, test=None, body=[], default=[], lineno=1, col_offset=1):
        self.test = test
        checkinstance(test, expr, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, case_stmt, False)
        self.default = default
        assert isinstance(default, list)
        for x in default:
            checkinstance(x, stmt, False)
        stmt.__init__(self, lineno, col_offset)
        self._fields = ('test', 'body', 'default')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Select(self)



class Cycle(stmt): # Constructor

    def __init__(self, lineno=1, col_offset=1):
        stmt.__init__(self, lineno, col_offset)
        self._fields = ()
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Cycle(self)



class Exit(stmt): # Constructor

    def __init__(self, lineno=1, col_offset=1):
        stmt.__init__(self, lineno, col_offset)
        self._fields = ()
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Exit(self)



class Return(stmt): # Constructor

    def __init__(self, lineno=1, col_offset=1):
        stmt.__init__(self, lineno, col_offset)
        self._fields = ()
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Return(self)



class WhileLoop(stmt): # Constructor

    def __init__(self, test=None, body=[], lineno=1, col_offset=1):
        self.test = test
        checkinstance(test, expr, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        stmt.__init__(self, lineno, col_offset)
        self._fields = ('test', 'body')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_WhileLoop(self)



class Print(stmt): # Constructor

    def __init__(self, fmt=None, values=[], lineno=1, col_offset=1):
        self.fmt = fmt
        checkinstance(fmt, str, True)
        self.values = values
        assert isinstance(values, list)
        for x in values:
            checkinstance(x, expr, False)
        stmt.__init__(self, lineno, col_offset)
        self._fields = ('fmt', 'values')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Print(self)



class expr(AST): # Sum

    def __init__(self, lineno=1, col_offset=1):
        self.lineno = lineno
        checkinstance(lineno, int, False)
        self.col_offset = col_offset
        checkinstance(col_offset, int, False)
        self._type = None


class BoolOp(expr): # Constructor

    def __init__(self, left=None, op=None, right=None, lineno=1, col_offset=1):
        self.left = left
        checkinstance(left, expr, False)
        self.op = op
        checkinstance(op, boolop, False)
        self.right = right
        checkinstance(right, expr, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('left', 'op', 'right')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_BoolOp(self)



class BinOp(expr): # Constructor

    def __init__(self, left=None, op=None, right=None, lineno=1, col_offset=1):
        self.left = left
        checkinstance(left, expr, False)
        self.op = op
        checkinstance(op, operator, False)
        self.right = right
        checkinstance(right, expr, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('left', 'op', 'right')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_BinOp(self)



class UnaryOp(expr): # Constructor

    def __init__(self, op=None, operand=None, lineno=1, col_offset=1):
        self.op = op
        checkinstance(op, unaryop, False)
        self.operand = operand
        checkinstance(operand, expr, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('op', 'operand')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_UnaryOp(self)



class Compare(expr): # Constructor

    def __init__(self, left=None, op=None, right=None, lineno=1, col_offset=1):
        self.left = left
        checkinstance(left, expr, False)
        self.op = op
        checkinstance(op, cmpop, False)
        self.right = right
        checkinstance(right, expr, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('left', 'op', 'right')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Compare(self)



class FuncCall(expr): # Constructor

    def __init__(self, func=None, args=[], keywords=[], lineno=1, col_offset=1):
        self.func = func
        checkinstance(func, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, expr, False)
        self.keywords = keywords
        assert isinstance(keywords, list)
        for x in keywords:
            checkinstance(x, keyword, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('func', 'args', 'keywords')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_FuncCall(self)



class FuncCallOrArray(expr): # Constructor

    def __init__(self, func=None, args=[], keywords=[], lineno=1, col_offset=1):
        self.func = func
        checkinstance(func, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, expr, False)
        self.keywords = keywords
        assert isinstance(keywords, list)
        for x in keywords:
            checkinstance(x, keyword, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('func', 'args', 'keywords')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_FuncCallOrArray(self)



class Array(expr): # Constructor

    def __init__(self, name=None, args=[], lineno=1, col_offset=1):
        self.name = name
        checkinstance(name, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, array_index, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('name', 'args')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Array(self)



class ArrayInitializer(expr): # Constructor

    def __init__(self, args=[], lineno=1, col_offset=1):
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, expr, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('args',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_ArrayInitializer(self)



class Num(expr): # Constructor

    def __init__(self, n=None, lineno=1, col_offset=1):
        self.n = n
        checkinstance(n, object, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('n',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Num(self)



class Real(expr): # Constructor

    def __init__(self, n=None, lineno=1, col_offset=1):
        self.n = n
        checkinstance(n, str, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('n',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Real(self)



class Str(expr): # Constructor

    def __init__(self, s=None, lineno=1, col_offset=1):
        self.s = s
        checkinstance(s, str, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('s',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Str(self)



class Name(expr): # Constructor

    def __init__(self, id=None, lineno=1, col_offset=1):
        self.id = id
        checkinstance(id, str, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('id',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Name(self)



class Constant(expr): # Constructor

    def __init__(self, value=None, lineno=1, col_offset=1):
        self.value = value
        checkinstance(value, bool, False)
        expr.__init__(self, lineno, col_offset)
        self._fields = ('value',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Constant(self)



class boolop(AST): # Sum
    pass


class And(boolop): # Type
    pass


class Or(boolop): # Type
    pass


class Eqv(boolop): # Type
    pass


class NEqv(boolop): # Type
    pass


class operator(AST): # Sum
    pass


class Add(operator): # Type
    pass


class Sub(operator): # Type
    pass


class Mul(operator): # Type
    pass


class Div(operator): # Type
    pass


class Pow(operator): # Type
    pass


class unaryop(AST): # Sum
    pass


class Invert(unaryop): # Type
    pass


class Not(unaryop): # Type
    pass


class UAdd(unaryop): # Type
    pass


class USub(unaryop): # Type
    pass


class cmpop(AST): # Sum
    pass


class Eq(cmpop): # Type
    pass


class NotEq(cmpop): # Type
    pass


class Lt(cmpop): # Type
    pass


class LtE(cmpop): # Type
    pass


class Gt(cmpop): # Type
    pass


class GtE(cmpop): # Type
    pass


class decl(AST): # Product

    def __init__(self, sym=None, sym_type=None, dims=[], attrs=[], initializer=None):
        self.sym = sym
        checkinstance(sym, str, False)
        self.sym_type = sym_type
        checkinstance(sym_type, str, False)
        self.dims = dims
        assert isinstance(dims, list)
        for x in dims:
            checkinstance(x, dimension, False)
        self.attrs = attrs
        assert isinstance(attrs, list)
        for x in attrs:
            checkinstance(x, attribute, False)
        self.initializer = initializer
        checkinstance(initializer, expr, True)
        self._fields = ('sym', 'sym_type', 'dims', 'attrs', 'initializer')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_decl(self)


class dimension(AST): # Product

    def __init__(self, start=None, end=None):
        self.start = start
        checkinstance(start, expr, True)
        self.end = end
        checkinstance(end, expr, True)
        self._fields = ('start', 'end')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_dimension(self)


class attribute(AST): # Sum
    pass


class Attribute(attribute): # Constructor

    def __init__(self, name=None, args=[]):
        self.name = name
        checkinstance(name, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, attribute_arg, False)
        self._fields = ('name', 'args')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Attribute(self)



class attribute_arg(AST): # Product

    def __init__(self, arg=None):
        self.arg = arg
        checkinstance(arg, str, False)
        self._fields = ('arg',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_attribute_arg(self)


class arg(AST): # Product

    def __init__(self, arg=None):
        self.arg = arg
        checkinstance(arg, str, False)
        self._fields = ('arg',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_arg(self)


class keyword(AST): # Product

    def __init__(self, arg=None, value=None):
        self.arg = arg
        checkinstance(arg, str, True)
        self.value = value
        checkinstance(value, expr, False)
        self._fields = ('arg', 'value')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_keyword(self)


class tbind(AST): # Sum
    pass


class Bind(tbind): # Constructor

    def __init__(self, args=[]):
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, keyword, False)
        self._fields = ('args',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Bind(self)



class array_index(AST): # Sum
    pass


class ArrayIndex(array_index): # Constructor

    def __init__(self, left=None, right=None, step=None):
        self.left = left
        checkinstance(left, expr, True)
        self.right = right
        checkinstance(right, expr, True)
        self.step = step
        checkinstance(step, expr, True)
        self._fields = ('left', 'right', 'step')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_ArrayIndex(self)



class case_stmt(AST): # Sum
    pass


class CaseStmt(case_stmt): # Constructor

    def __init__(self, test=None, body=[]):
        self.test = test
        checkinstance(test, expr, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self._fields = ('test', 'body')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_CaseStmt(self)



class use_symbol(AST): # Sum
    pass


class UseSymbol(use_symbol): # Constructor

    def __init__(self, sym=None, rename=None):
        self.sym = sym
        checkinstance(sym, str, False)
        self.rename = rename
        checkinstance(rename, str, True)
        self._fields = ('sym', 'rename')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_UseSymbol(self)



class ASTVisitor(object):

    def visit_sequence(self, seq):
        if seq is not None:
            for node in seq:
                self.visit(node)

    def visit(self, node):
        return node.walkabout(self)

    def default_visitor(self, node):
        raise NodeVisitorNotImplemented

    def visit_TranslationUnit(self, node):
        return self.default_visitor(node)
    def visit_Module(self, node):
        return self.default_visitor(node)
    def visit_Program(self, node):
        return self.default_visitor(node)
    def visit_Subroutine(self, node):
        return self.default_visitor(node)
    def visit_Function(self, node):
        return self.default_visitor(node)
    def visit_Use(self, node):
        return self.default_visitor(node)
    def visit_Declaration(self, node):
        return self.default_visitor(node)
    def visit_Private(self, node):
        return self.default_visitor(node)
    def visit_Public(self, node):
        return self.default_visitor(node)
    def visit_Interface(self, node):
        return self.default_visitor(node)
    def visit_Interface2(self, node):
        return self.default_visitor(node)
    def visit_Assignment(self, node):
        return self.default_visitor(node)
    def visit_Associate(self, node):
        return self.default_visitor(node)
    def visit_SubroutineCall(self, node):
        return self.default_visitor(node)
    def visit_BuiltinCall(self, node):
        return self.default_visitor(node)
    def visit_If(self, node):
        return self.default_visitor(node)
    def visit_Where(self, node):
        return self.default_visitor(node)
    def visit_Stop(self, node):
        return self.default_visitor(node)
    def visit_ErrorStop(self, node):
        return self.default_visitor(node)
    def visit_DoLoop(self, node):
        return self.default_visitor(node)
    def visit_Select(self, node):
        return self.default_visitor(node)
    def visit_Cycle(self, node):
        return self.default_visitor(node)
    def visit_Exit(self, node):
        return self.default_visitor(node)
    def visit_Return(self, node):
        return self.default_visitor(node)
    def visit_WhileLoop(self, node):
        return self.default_visitor(node)
    def visit_Print(self, node):
        return self.default_visitor(node)
    def visit_BoolOp(self, node):
        return self.default_visitor(node)
    def visit_BinOp(self, node):
        return self.default_visitor(node)
    def visit_UnaryOp(self, node):
        return self.default_visitor(node)
    def visit_Compare(self, node):
        return self.default_visitor(node)
    def visit_FuncCall(self, node):
        return self.default_visitor(node)
    def visit_FuncCallOrArray(self, node):
        return self.default_visitor(node)
    def visit_Array(self, node):
        return self.default_visitor(node)
    def visit_ArrayInitializer(self, node):
        return self.default_visitor(node)
    def visit_Num(self, node):
        return self.default_visitor(node)
    def visit_Real(self, node):
        return self.default_visitor(node)
    def visit_Str(self, node):
        return self.default_visitor(node)
    def visit_Name(self, node):
        return self.default_visitor(node)
    def visit_Constant(self, node):
        return self.default_visitor(node)
    def visit_decl(self, node):
        return self.default_visitor(node)
    def visit_dimension(self, node):
        return self.default_visitor(node)
    def visit_Attribute(self, node):
        return self.default_visitor(node)
    def visit_attribute_arg(self, node):
        return self.default_visitor(node)
    def visit_arg(self, node):
        return self.default_visitor(node)
    def visit_keyword(self, node):
        return self.default_visitor(node)
    def visit_Bind(self, node):
        return self.default_visitor(node)
    def visit_ArrayIndex(self, node):
        return self.default_visitor(node)
    def visit_CaseStmt(self, node):
        return self.default_visitor(node)
    def visit_UseSymbol(self, node):
        return self.default_visitor(node)

class GenericASTVisitor(ASTVisitor):

    def visit_TranslationUnit(self, node):
        pass

    def visit_Module(self, node):
        self.visit_sequence(node.use)
        self.visit_sequence(node.decl)
        self.visit_sequence(node.contains)

    def visit_Program(self, node):
        self.visit_sequence(node.use)
        self.visit_sequence(node.decl)
        self.visit_sequence(node.body)
        self.visit_sequence(node.contains)

    def visit_Subroutine(self, node):
        self.visit_sequence(node.args)
        self.visit_sequence(node.use)
        self.visit_sequence(node.decl)
        self.visit_sequence(node.body)
        self.visit_sequence(node.contains)

    def visit_Function(self, node):
        self.visit_sequence(node.args)
        if node.return_var:
            self.visit(node.return_var)
        if node.bind:
            self.visit(node.bind)
        self.visit_sequence(node.use)
        self.visit_sequence(node.decl)
        self.visit_sequence(node.body)
        self.visit_sequence(node.contains)

    def visit_Use(self, node):
        self.visit_sequence(node.symbols)

    def visit_Declaration(self, node):
        self.visit_sequence(node.vars)

    def visit_Private(self, node):
        pass

    def visit_Public(self, node):
        pass

    def visit_Interface(self, node):
        pass

    def visit_Interface2(self, node):
        self.visit_sequence(node.procs)

    def visit_Assignment(self, node):
        self.visit(node.target)
        self.visit(node.value)

    def visit_Associate(self, node):
        self.visit(node.target)
        self.visit(node.value)

    def visit_SubroutineCall(self, node):
        self.visit_sequence(node.args)

    def visit_BuiltinCall(self, node):
        self.visit_sequence(node.args)

    def visit_If(self, node):
        self.visit(node.test)
        self.visit_sequence(node.body)
        self.visit_sequence(node.orelse)

    def visit_Where(self, node):
        self.visit(node.test)
        self.visit_sequence(node.body)
        self.visit_sequence(node.orelse)

    def visit_Stop(self, node):
        if node.code:
            self.visit(node.code)

    def visit_ErrorStop(self, node):
        pass

    def visit_DoLoop(self, node):
        if node.start:
            self.visit(node.start)
        if node.end:
            self.visit(node.end)
        if node.increment:
            self.visit(node.increment)
        self.visit_sequence(node.body)

    def visit_Select(self, node):
        self.visit(node.test)
        self.visit_sequence(node.body)
        self.visit_sequence(node.default)

    def visit_Cycle(self, node):
        pass

    def visit_Exit(self, node):
        pass

    def visit_Return(self, node):
        pass

    def visit_WhileLoop(self, node):
        self.visit(node.test)
        self.visit_sequence(node.body)

    def visit_Print(self, node):
        self.visit_sequence(node.values)

    def visit_BoolOp(self, node):
        self.visit(node.left)
        self.visit(node.right)

    def visit_BinOp(self, node):
        self.visit(node.left)
        self.visit(node.right)

    def visit_UnaryOp(self, node):
        self.visit(node.operand)

    def visit_Compare(self, node):
        self.visit(node.left)
        self.visit(node.right)

    def visit_FuncCall(self, node):
        self.visit_sequence(node.args)
        self.visit_sequence(node.keywords)

    def visit_FuncCallOrArray(self, node):
        self.visit_sequence(node.args)
        self.visit_sequence(node.keywords)

    def visit_Array(self, node):
        self.visit_sequence(node.args)

    def visit_ArrayInitializer(self, node):
        self.visit_sequence(node.args)

    def visit_Num(self, node):
        pass

    def visit_Real(self, node):
        pass

    def visit_Str(self, node):
        pass

    def visit_Name(self, node):
        pass

    def visit_Constant(self, node):
        pass

    def visit_decl(self, node):
        self.visit_sequence(node.dims)
        self.visit_sequence(node.attrs)
        if node.initializer:
            self.visit(node.initializer)

    def visit_dimension(self, node):
        if node.start:
            self.visit(node.start)
        if node.end:
            self.visit(node.end)

    def visit_Attribute(self, node):
        self.visit_sequence(node.args)

    def visit_attribute_arg(self, node):
        pass

    def visit_arg(self, node):
        pass

    def visit_keyword(self, node):
        self.visit(node.value)

    def visit_Bind(self, node):
        self.visit_sequence(node.args)

    def visit_ArrayIndex(self, node):
        if node.left:
            self.visit(node.left)
        if node.right:
            self.visit(node.right)
        if node.step:
            self.visit(node.step)

    def visit_CaseStmt(self, node):
        self.visit(node.test)
        self.visit_sequence(node.body)

    def visit_UseSymbol(self, node):
        pass


class NodeTransformerBase(ASTVisitor):

    def visit_TranslationUnit(self, node):
        items = self.visit_object(node.items)
        return TranslationUnit(items=items)

    def visit_Module(self, node):
        name = self.visit_object(node.name)
        use = self.visit_sequence(node.use)
        decl = self.visit_sequence(node.decl)
        contains = self.visit_sequence(node.contains)
        return Module(name=name, use=use, decl=decl, contains=contains)

    def visit_Program(self, node):
        name = self.visit_object(node.name)
        use = self.visit_sequence(node.use)
        decl = self.visit_sequence(node.decl)
        body = self.visit_sequence(node.body)
        contains = self.visit_sequence(node.contains)
        return Program(name=name, use=use, decl=decl, body=body, contains=contains)

    def visit_Subroutine(self, node):
        name = self.visit_object(node.name)
        args = self.visit_sequence(node.args)
        use = self.visit_sequence(node.use)
        decl = self.visit_sequence(node.decl)
        body = self.visit_sequence(node.body)
        contains = self.visit_sequence(node.contains)
        return Subroutine(name=name, args=args, use=use, decl=decl, body=body, contains=contains)

    def visit_Function(self, node):
        name = self.visit_object(node.name)
        args = self.visit_sequence(node.args)
        return_type = self.visit_object(node.return_type)
        if node.return_var:
            return_var = self.visit(node.return_var)
        else:
            return_var = None
        if node.bind:
            bind = self.visit(node.bind)
        else:
            bind = None
        use = self.visit_sequence(node.use)
        decl = self.visit_sequence(node.decl)
        body = self.visit_sequence(node.body)
        contains = self.visit_sequence(node.contains)
        return Function(name=name, args=args, return_type=return_type, return_var=return_var, bind=bind, use=use, decl=decl, body=body, contains=contains)

    def visit_Use(self, node):
        module = self.visit_object(node.module)
        symbols = self.visit_sequence(node.symbols)
        return Use(module=module, symbols=symbols)

    def visit_Declaration(self, node):
        vars = self.visit_sequence(node.vars)
        return Declaration(vars=vars)

    def visit_Private(self, node):
        vars = self.visit_object(node.vars)
        return Private(vars=vars)

    def visit_Public(self, node):
        vars = self.visit_object(node.vars)
        return Public(vars=vars)

    def visit_Interface(self, node):
        name = self.visit_object(node.name)
        procs = self.visit_object(node.procs)
        return Interface(name=name, procs=procs)

    def visit_Interface2(self, node):
        name = self.visit_object(node.name)
        procs = self.visit_sequence(node.procs)
        return Interface2(name=name, procs=procs)

    def visit_Assignment(self, node):
        target = self.visit(node.target)
        value = self.visit(node.value)
        return Assignment(target=target, value=value)

    def visit_Associate(self, node):
        target = self.visit(node.target)
        value = self.visit(node.value)
        return Associate(target=target, value=value)

    def visit_SubroutineCall(self, node):
        name = self.visit_object(node.name)
        args = self.visit_sequence(node.args)
        return SubroutineCall(name=name, args=args)

    def visit_BuiltinCall(self, node):
        name = self.visit_object(node.name)
        args = self.visit_sequence(node.args)
        return BuiltinCall(name=name, args=args)

    def visit_If(self, node):
        test = self.visit(node.test)
        body = self.visit_sequence(node.body)
        orelse = self.visit_sequence(node.orelse)
        return If(test=test, body=body, orelse=orelse)

    def visit_Where(self, node):
        test = self.visit(node.test)
        body = self.visit_sequence(node.body)
        orelse = self.visit_sequence(node.orelse)
        return Where(test=test, body=body, orelse=orelse)

    def visit_Stop(self, node):
        if node.code:
            code = self.visit(node.code)
        else:
            code = None
        return Stop(code=code)

    def visit_ErrorStop(self, node):
        return ErrorStop()

    def visit_DoLoop(self, node):
        var = self.visit_object(node.var)
        if node.start:
            start = self.visit(node.start)
        else:
            start = None
        if node.end:
            end = self.visit(node.end)
        else:
            end = None
        if node.increment:
            increment = self.visit(node.increment)
        else:
            increment = None
        body = self.visit_sequence(node.body)
        return DoLoop(var=var, start=start, end=end, increment=increment, body=body)

    def visit_Select(self, node):
        test = self.visit(node.test)
        body = self.visit_sequence(node.body)
        default = self.visit_sequence(node.default)
        return Select(test=test, body=body, default=default)

    def visit_Cycle(self, node):
        return Cycle()

    def visit_Exit(self, node):
        return Exit()

    def visit_Return(self, node):
        return Return()

    def visit_WhileLoop(self, node):
        test = self.visit(node.test)
        body = self.visit_sequence(node.body)
        return WhileLoop(test=test, body=body)

    def visit_Print(self, node):
        fmt = self.visit_object(node.fmt)
        values = self.visit_sequence(node.values)
        return Print(fmt=fmt, values=values)

    def visit_BoolOp(self, node):
        left = self.visit(node.left)
        op = self.visit_object(node.op)
        right = self.visit(node.right)
        return BoolOp(left=left, op=op, right=right)

    def visit_BinOp(self, node):
        left = self.visit(node.left)
        op = self.visit_object(node.op)
        right = self.visit(node.right)
        return BinOp(left=left, op=op, right=right)

    def visit_UnaryOp(self, node):
        op = self.visit_object(node.op)
        operand = self.visit(node.operand)
        return UnaryOp(op=op, operand=operand)

    def visit_Compare(self, node):
        left = self.visit(node.left)
        op = self.visit_object(node.op)
        right = self.visit(node.right)
        return Compare(left=left, op=op, right=right)

    def visit_FuncCall(self, node):
        func = self.visit_object(node.func)
        args = self.visit_sequence(node.args)
        keywords = self.visit_sequence(node.keywords)
        return FuncCall(func=func, args=args, keywords=keywords)

    def visit_FuncCallOrArray(self, node):
        func = self.visit_object(node.func)
        args = self.visit_sequence(node.args)
        keywords = self.visit_sequence(node.keywords)
        return FuncCallOrArray(func=func, args=args, keywords=keywords)

    def visit_Array(self, node):
        name = self.visit_object(node.name)
        args = self.visit_sequence(node.args)
        return Array(name=name, args=args)

    def visit_ArrayInitializer(self, node):
        args = self.visit_sequence(node.args)
        return ArrayInitializer(args=args)

    def visit_Num(self, node):
        n = self.visit_object(node.n)
        return Num(n=n)

    def visit_Real(self, node):
        n = self.visit_object(node.n)
        return Real(n=n)

    def visit_Str(self, node):
        s = self.visit_object(node.s)
        return Str(s=s)

    def visit_Name(self, node):
        id = self.visit_object(node.id)
        return Name(id=id)

    def visit_Constant(self, node):
        value = self.visit_object(node.value)
        return Constant(value=value)

    def visit_decl(self, node):
        sym = self.visit_object(node.sym)
        sym_type = self.visit_object(node.sym_type)
        dims = self.visit_sequence(node.dims)
        attrs = self.visit_sequence(node.attrs)
        if node.initializer:
            initializer = self.visit(node.initializer)
        else:
            initializer = None
        return decl(sym=sym, sym_type=sym_type, dims=dims, attrs=attrs, initializer=initializer)

    def visit_dimension(self, node):
        if node.start:
            start = self.visit(node.start)
        else:
            start = None
        if node.end:
            end = self.visit(node.end)
        else:
            end = None
        return dimension(start=start, end=end)

    def visit_Attribute(self, node):
        name = self.visit_object(node.name)
        args = self.visit_sequence(node.args)
        return Attribute(name=name, args=args)

    def visit_attribute_arg(self, node):
        arg = self.visit_object(node.arg)
        return attribute_arg(arg=arg)

    def visit_arg(self, node):
        arg = self.visit_object(node.arg)
        return arg(arg=arg)

    def visit_keyword(self, node):
        arg = self.visit_object(node.arg)
        value = self.visit(node.value)
        return keyword(arg=arg, value=value)

    def visit_Bind(self, node):
        args = self.visit_sequence(node.args)
        return Bind(args=args)

    def visit_ArrayIndex(self, node):
        if node.left:
            left = self.visit(node.left)
        else:
            left = None
        if node.right:
            right = self.visit(node.right)
        else:
            right = None
        if node.step:
            step = self.visit(node.step)
        else:
            step = None
        return ArrayIndex(left=left, right=right, step=step)

    def visit_CaseStmt(self, node):
        test = self.visit(node.test)
        body = self.visit_sequence(node.body)
        return CaseStmt(test=test, body=body)

    def visit_UseSymbol(self, node):
        sym = self.visit_object(node.sym)
        rename = self.visit_object(node.rename)
        return UseSymbol(sym=sym, rename=rename)


