"""File generated by TLObjects' generator. All changes will be ERASED"""
from .._misc.tlobject import TLObject, TLRequest
from . import fn
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from ..storage import TypeFileType
    from . import TypeFileHash



@dataclasses.dataclass(init=False, frozen=True)
class CdnFile(TLObject):
    """
    Constructor for upload.CdnFile: Instance of either CdnFileReuploadNeeded, CdnFile.
    """
    __slots__ = ('bytes',)
    CONSTRUCTOR_ID = 0xa99fca4f
    SUBCLASS_OF_ID = 0xf5ccf928

    bytes: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, bytes: bytes):
        object.__setattr__(self, 'bytes', bytes)

    def _bytes(self):
        return b''.join((
            b'O\xca\x9f\xa9',
            self._serialize_bytes(self.bytes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _bytes = reader.tgread_bytes()
        return cls(bytes=_bytes)


@dataclasses.dataclass(init=False, frozen=True)
class CdnFileReuploadNeeded(TLObject):
    """
    Constructor for upload.CdnFile: Instance of either CdnFileReuploadNeeded, CdnFile.
    """
    __slots__ = ('request_token',)
    CONSTRUCTOR_ID = 0xeea8e46e
    SUBCLASS_OF_ID = 0xf5ccf928

    request_token: bytes
    def __init__(self, request_token: bytes):
        object.__setattr__(self, 'request_token', request_token)

    def _bytes(self):
        return b''.join((
            b'n\xe4\xa8\xee',
            self._serialize_bytes(self.request_token),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _request_token = reader.tgread_bytes()
        return cls(request_token=_request_token)


@dataclasses.dataclass(init=False, frozen=True)
class File(TLObject):
    """
    Constructor for upload.File: Instance of either File, FileCdnRedirect.
    """
    __slots__ = ('type', 'mtime', 'bytes',)
    CONSTRUCTOR_ID = 0x96a18d5
    SUBCLASS_OF_ID = 0x6c9bd728

    type: 'TypeFileType'
    mtime: int
    bytes: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeFileType', mtime: int, bytes: bytes):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'mtime', mtime)
        object.__setattr__(self, 'bytes', bytes)

    def _bytes(self):
        return b''.join((
            b'\xd5\x18j\t',
            self.type._bytes(),
            struct.pack('<i', self.mtime),
            self._serialize_bytes(self.bytes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_object()
        _mtime = reader.read_int()
        _bytes = reader.tgread_bytes()
        return cls(type=_type, mtime=_mtime, bytes=_bytes)


@dataclasses.dataclass(init=False, frozen=True)
class FileCdnRedirect(TLObject):
    """
    Constructor for upload.File: Instance of either File, FileCdnRedirect.
    """
    __slots__ = ('dc_id', 'file_token', 'encryption_key', 'encryption_iv', 'file_hashes',)
    CONSTRUCTOR_ID = 0xf18cda44
    SUBCLASS_OF_ID = 0x6c9bd728

    dc_id: int
    file_token: bytes
    encryption_key: bytes
    encryption_iv: bytes
    file_hashes: List['TypeFileHash']
    def __init__(self, dc_id: int, file_token: bytes, encryption_key: bytes, encryption_iv: bytes, file_hashes: List['TypeFileHash']):
        object.__setattr__(self, 'dc_id', dc_id)
        object.__setattr__(self, 'file_token', file_token)
        object.__setattr__(self, 'encryption_key', encryption_key)
        object.__setattr__(self, 'encryption_iv', encryption_iv)
        object.__setattr__(self, 'file_hashes', file_hashes)

    def _bytes(self):
        return b''.join((
            b'D\xda\x8c\xf1',
            struct.pack('<i', self.dc_id),
            self._serialize_bytes(self.file_token),
            self._serialize_bytes(self.encryption_key),
            self._serialize_bytes(self.encryption_iv),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.file_hashes)),b''.join(x._bytes() for x in self.file_hashes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _dc_id = reader.read_int()
        _file_token = reader.tgread_bytes()
        _encryption_key = reader.tgread_bytes()
        _encryption_iv = reader.tgread_bytes()
        reader.read_int()
        _file_hashes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _file_hashes.append(_x)

        return cls(dc_id=_dc_id, file_token=_file_token, encryption_key=_encryption_key, encryption_iv=_encryption_iv, file_hashes=_file_hashes)


@dataclasses.dataclass(init=False, frozen=True)
class WebFile(TLObject):
    """
    Constructor for upload.WebFile: Instance of WebFile.
    """
    __slots__ = ('size', 'mime_type', 'file_type', 'mtime', 'bytes',)
    CONSTRUCTOR_ID = 0x21e753bc
    SUBCLASS_OF_ID = 0x68f17f51

    size: int
    mime_type: str
    file_type: 'TypeFileType'
    mtime: int
    bytes: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, size: int, mime_type: str, file_type: 'TypeFileType', mtime: int, bytes: bytes):
        object.__setattr__(self, 'size', size)
        object.__setattr__(self, 'mime_type', mime_type)
        object.__setattr__(self, 'file_type', file_type)
        object.__setattr__(self, 'mtime', mtime)
        object.__setattr__(self, 'bytes', bytes)

    def _bytes(self):
        return b''.join((
            b'\xbcS\xe7!',
            struct.pack('<i', self.size),
            self._serialize_bytes(self.mime_type),
            self.file_type._bytes(),
            struct.pack('<i', self.mtime),
            self._serialize_bytes(self.bytes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _size = reader.read_int()
        _mime_type = reader.tgread_string()
        _file_type = reader.tgread_object()
        _mtime = reader.read_int()
        _bytes = reader.tgread_bytes()
        return cls(size=_size, mime_type=_mime_type, file_type=_file_type, mtime=_mtime, bytes=_bytes)

