"""File generated by TLObjects' generator. All changes will be ERASED"""
from .._misc.tlobject import TLObject, TLRequest
from . import fn
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from . import TypeAvailableReaction, TypeBotInlineResult, TypeChat, TypeChatAdminWithInvites, TypeChatFull, TypeChatInviteImporter, TypeDialog, TypeDocument, TypeEncryptedFile, TypeExportedChatInvite, TypeHighScore, TypeInlineBotSwitchPM, TypeMessage, TypeMessagePeerReaction, TypeMessageUserVote, TypeMessageViews, TypeMessagesFilter, TypePeerSettings, TypeSearchResultsCalendarPeriod, TypeSearchResultsPosition, TypeSponsoredMessage, TypeStickerPack, TypeStickerSet, TypeStickerSetCovered, TypeUser
    from ..updates import TypeState



@dataclasses.dataclass(init=False, frozen=True)
class AffectedFoundMessages(TLObject):
    """
    Constructor for messages.AffectedFoundMessages: Instance of AffectedFoundMessages.
    """
    __slots__ = ('pts', 'pts_count', 'offset', 'messages',)
    CONSTRUCTOR_ID = 0xef8d3e6c
    SUBCLASS_OF_ID = 0xf817652e

    pts: int
    pts_count: int
    offset: int
    messages: List[int]
    def __init__(self, pts: int, pts_count: int, offset: int, messages: List[int]):
        object.__setattr__(self, 'pts', pts)
        object.__setattr__(self, 'pts_count', pts_count)
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'messages', messages)

    def _bytes(self):
        return b''.join((
            b'l>\x8d\xef',
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
            struct.pack('<i', self.offset),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(struct.pack('<i', x) for x in self.messages),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        _offset = reader.read_int()
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _messages.append(_x)

        return cls(pts=_pts, pts_count=_pts_count, offset=_offset, messages=_messages)


@dataclasses.dataclass(init=False, frozen=True)
class AffectedHistory(TLObject):
    """
    Constructor for messages.AffectedHistory: Instance of AffectedHistory.
    """
    __slots__ = ('pts', 'pts_count', 'offset',)
    CONSTRUCTOR_ID = 0xb45c69d1
    SUBCLASS_OF_ID = 0x2c49c116

    pts: int
    pts_count: int
    offset: int
    def __init__(self, pts: int, pts_count: int, offset: int):
        object.__setattr__(self, 'pts', pts)
        object.__setattr__(self, 'pts_count', pts_count)
        object.__setattr__(self, 'offset', offset)

    def _bytes(self):
        return b''.join((
            b'\xd1i\\\xb4',
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
            struct.pack('<i', self.offset),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        _offset = reader.read_int()
        return cls(pts=_pts, pts_count=_pts_count, offset=_offset)


@dataclasses.dataclass(init=False, frozen=True)
class AffectedMessages(TLObject):
    """
    Constructor for messages.AffectedMessages: Instance of AffectedMessages.
    """
    __slots__ = ('pts', 'pts_count',)
    CONSTRUCTOR_ID = 0x84d19185
    SUBCLASS_OF_ID = 0xced3c06e

    pts: int
    pts_count: int
    def __init__(self, pts: int, pts_count: int):
        object.__setattr__(self, 'pts', pts)
        object.__setattr__(self, 'pts_count', pts_count)

    def _bytes(self):
        return b''.join((
            b'\x85\x91\xd1\x84',
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(pts=_pts, pts_count=_pts_count)


@dataclasses.dataclass(init=False, frozen=True)
class AllStickers(TLObject):
    """
    Constructor for messages.AllStickers: Instance of either AllStickersNotModified, AllStickers.
    """
    __slots__ = ('hash', 'sets',)
    CONSTRUCTOR_ID = 0xcdbbcebb
    SUBCLASS_OF_ID = 0x45834829

    hash: int
    sets: List['TypeStickerSet']
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, sets: List['TypeStickerSet']):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'sets', sets)

    def _bytes(self):
        return b''.join((
            b'\xbb\xce\xbb\xcd',
            struct.pack('<q', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sets)),b''.join(x._bytes() for x in self.sets),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        reader.read_int()
        _sets = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _sets.append(_x)

        return cls(hash=_hash, sets=_sets)


@dataclasses.dataclass(init=False, frozen=True)
class AllStickersNotModified(TLObject):
    """
    Constructor for messages.AllStickers: Instance of either AllStickersNotModified, AllStickers.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xe86602c3
    SUBCLASS_OF_ID = 0x45834829

    def _bytes(self):
        return b''.join((
            b'\xc3\x02f\xe8',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ArchivedStickers(TLObject):
    """
    Constructor for messages.ArchivedStickers: Instance of ArchivedStickers.
    """
    __slots__ = ('count', 'sets',)
    CONSTRUCTOR_ID = 0x4fcba9c8
    SUBCLASS_OF_ID = 0x7296d771

    count: int
    sets: List['TypeStickerSetCovered']
    def __init__(self, count: int, sets: List['TypeStickerSetCovered']):
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'sets', sets)

    def _bytes(self):
        return b''.join((
            b'\xc8\xa9\xcbO',
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sets)),b''.join(x._bytes() for x in self.sets),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _count = reader.read_int()
        reader.read_int()
        _sets = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _sets.append(_x)

        return cls(count=_count, sets=_sets)


@dataclasses.dataclass(init=False, frozen=True)
class AvailableReactions(TLObject):
    """
    Constructor for messages.AvailableReactions: Instance of either AvailableReactionsNotModified, AvailableReactions.
    """
    __slots__ = ('hash', 'reactions',)
    CONSTRUCTOR_ID = 0x768e3aad
    SUBCLASS_OF_ID = 0xe426ad82

    hash: int
    reactions: List['TypeAvailableReaction']
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, reactions: List['TypeAvailableReaction']):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'reactions', reactions)

    def _bytes(self):
        return b''.join((
            b'\xad:\x8ev',
            struct.pack('<i', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.reactions)),b''.join(x._bytes() for x in self.reactions),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_int()
        reader.read_int()
        _reactions = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _reactions.append(_x)

        return cls(hash=_hash, reactions=_reactions)


@dataclasses.dataclass(init=False, frozen=True)
class AvailableReactionsNotModified(TLObject):
    """
    Constructor for messages.AvailableReactions: Instance of either AvailableReactionsNotModified, AvailableReactions.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9f071957
    SUBCLASS_OF_ID = 0xe426ad82

    def _bytes(self):
        return b''.join((
            b'W\x19\x07\x9f',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class BotCallbackAnswer(TLObject):
    """
    Constructor for messages.BotCallbackAnswer: Instance of BotCallbackAnswer.
    """
    __slots__ = ('cache_time', 'alert', 'has_url', 'native_ui', 'message', 'url',)
    CONSTRUCTOR_ID = 0x36585ea4
    SUBCLASS_OF_ID = 0x6c4dd18c

    cache_time: int
    alert: Optional[bool]
    has_url: Optional[bool]
    native_ui: Optional[bool]
    message: Optional[str]
    url: Optional[str]
    def __init__(self, cache_time: int, alert: Optional[bool]=None, has_url: Optional[bool]=None, native_ui: Optional[bool]=None, message: Optional[str]=None, url: Optional[str]=None):
        object.__setattr__(self, 'cache_time', cache_time)
        object.__setattr__(self, 'alert', alert)
        object.__setattr__(self, 'has_url', has_url)
        object.__setattr__(self, 'native_ui', native_ui)
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'url', url)

    def _bytes(self):
        return b''.join((
            b'\xa4^X6',
            struct.pack('<I', (0 if self.alert is None or self.alert is False else 2) | (0 if self.has_url is None or self.has_url is False else 8) | (0 if self.native_ui is None or self.native_ui is False else 16) | (0 if self.message is None or self.message is False else 1) | (0 if self.url is None or self.url is False else 4)),
            b'' if self.message is None or self.message is False else (self._serialize_bytes(self.message)),
            b'' if self.url is None or self.url is False else (self._serialize_bytes(self.url)),
            struct.pack('<i', self.cache_time),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _alert = bool(flags & 2)
        _has_url = bool(flags & 8)
        _native_ui = bool(flags & 16)
        if flags & 1:
            _message = reader.tgread_string()
        else:
            _message = None
        if flags & 4:
            _url = reader.tgread_string()
        else:
            _url = None
        _cache_time = reader.read_int()
        return cls(cache_time=_cache_time, alert=_alert, has_url=_has_url, native_ui=_native_ui, message=_message, url=_url)


@dataclasses.dataclass(init=False, frozen=True)
class BotResults(TLObject):
    """
    Constructor for messages.BotResults: Instance of BotResults.
    """
    __slots__ = ('query_id', 'results', 'cache_time', 'users', 'gallery', 'next_offset', 'switch_pm',)
    CONSTRUCTOR_ID = 0x947ca848
    SUBCLASS_OF_ID = 0x3ed4d9c9

    query_id: int
    results: List['TypeBotInlineResult']
    cache_time: int
    users: List['TypeUser']
    gallery: Optional[bool]
    next_offset: Optional[str]
    switch_pm: Optional['TypeInlineBotSwitchPM']
    def __init__(self, query_id: int, results: List['TypeBotInlineResult'], cache_time: int, users: List['TypeUser'], gallery: Optional[bool]=None, next_offset: Optional[str]=None, switch_pm: Optional['TypeInlineBotSwitchPM']=None):
        object.__setattr__(self, 'query_id', query_id)
        object.__setattr__(self, 'results', results)
        object.__setattr__(self, 'cache_time', cache_time)
        object.__setattr__(self, 'users', users)
        object.__setattr__(self, 'gallery', gallery)
        object.__setattr__(self, 'next_offset', next_offset)
        object.__setattr__(self, 'switch_pm', switch_pm)

    def _bytes(self):
        return b''.join((
            b'H\xa8|\x94',
            struct.pack('<I', (0 if self.gallery is None or self.gallery is False else 1) | (0 if self.next_offset is None or self.next_offset is False else 2) | (0 if self.switch_pm is None or self.switch_pm is False else 4)),
            struct.pack('<q', self.query_id),
            b'' if self.next_offset is None or self.next_offset is False else (self._serialize_bytes(self.next_offset)),
            b'' if self.switch_pm is None or self.switch_pm is False else (self.switch_pm._bytes()),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.results)),b''.join(x._bytes() for x in self.results),
            struct.pack('<i', self.cache_time),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _gallery = bool(flags & 1)
        _query_id = reader.read_long()
        if flags & 2:
            _next_offset = reader.tgread_string()
        else:
            _next_offset = None
        if flags & 4:
            _switch_pm = reader.tgread_object()
        else:
            _switch_pm = None
        reader.read_int()
        _results = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _results.append(_x)

        _cache_time = reader.read_int()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(query_id=_query_id, results=_results, cache_time=_cache_time, users=_users, gallery=_gallery, next_offset=_next_offset, switch_pm=_switch_pm)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelMessages(TLObject):
    """
    Constructor for messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('pts', 'count', 'messages', 'chats', 'users', 'inexact', 'offset_id_offset',)
    CONSTRUCTOR_ID = 0x64479808
    SUBCLASS_OF_ID = 0xd4b40b5e

    pts: int
    count: int
    messages: List['TypeMessage']
    chats: List['TypeChat']
    users: List['TypeUser']
    inexact: Optional[bool]
    offset_id_offset: Optional[int]
    def __init__(self, pts: int, count: int, messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser'], inexact: Optional[bool]=None, offset_id_offset: Optional[int]=None):
        object.__setattr__(self, 'pts', pts)
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'messages', messages)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)
        object.__setattr__(self, 'inexact', inexact)
        object.__setattr__(self, 'offset_id_offset', offset_id_offset)

    def _bytes(self):
        return b''.join((
            b'\x08\x98Gd',
            struct.pack('<I', (0 if self.inexact is None or self.inexact is False else 2) | (0 if self.offset_id_offset is None or self.offset_id_offset is False else 4)),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.count),
            b'' if self.offset_id_offset is None or self.offset_id_offset is False else (struct.pack('<i', self.offset_id_offset)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _inexact = bool(flags & 2)
        _pts = reader.read_int()
        _count = reader.read_int()
        if flags & 4:
            _offset_id_offset = reader.read_int()
        else:
            _offset_id_offset = None
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(pts=_pts, count=_count, messages=_messages, chats=_chats, users=_users, inexact=_inexact, offset_id_offset=_offset_id_offset)


@dataclasses.dataclass(init=False, frozen=True)
class ChatAdminsWithInvites(TLObject):
    """
    Constructor for messages.ChatAdminsWithInvites: Instance of ChatAdminsWithInvites.
    """
    __slots__ = ('admins', 'users',)
    CONSTRUCTOR_ID = 0xb69b72d7
    SUBCLASS_OF_ID = 0x8f5bad2b

    admins: List['TypeChatAdminWithInvites']
    users: List['TypeUser']
    def __init__(self, admins: List['TypeChatAdminWithInvites'], users: List['TypeUser']):
        object.__setattr__(self, 'admins', admins)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\xd7r\x9b\xb6',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.admins)),b''.join(x._bytes() for x in self.admins),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _admins = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _admins.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(admins=_admins, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class ChatFull(TLObject):
    """
    Constructor for messages.ChatFull: Instance of ChatFull.
    """
    __slots__ = ('full_chat', 'chats', 'users',)
    CONSTRUCTOR_ID = 0xe5d7d19c
    SUBCLASS_OF_ID = 0x225a5109

    full_chat: 'TypeChatFull'
    chats: List['TypeChat']
    users: List['TypeUser']
    def __init__(self, full_chat: 'TypeChatFull', chats: List['TypeChat'], users: List['TypeUser']):
        object.__setattr__(self, 'full_chat', full_chat)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\x9c\xd1\xd7\xe5',
            self.full_chat._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _full_chat = reader.tgread_object()
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(full_chat=_full_chat, chats=_chats, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class ChatInviteImporters(TLObject):
    """
    Constructor for messages.ChatInviteImporters: Instance of ChatInviteImporters.
    """
    __slots__ = ('count', 'importers', 'users',)
    CONSTRUCTOR_ID = 0x81b6b00a
    SUBCLASS_OF_ID = 0xd9bc8aa6

    count: int
    importers: List['TypeChatInviteImporter']
    users: List['TypeUser']
    def __init__(self, count: int, importers: List['TypeChatInviteImporter'], users: List['TypeUser']):
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'importers', importers)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\n\xb0\xb6\x81',
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.importers)),b''.join(x._bytes() for x in self.importers),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _count = reader.read_int()
        reader.read_int()
        _importers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _importers.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(count=_count, importers=_importers, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class Chats(TLObject):
    """
    Constructor for messages.Chats: Instance of either Chats, ChatsSlice.
    """
    __slots__ = ('chats',)
    CONSTRUCTOR_ID = 0x64ff9fd5
    SUBCLASS_OF_ID = 0x99d5cb14

    chats: List['TypeChat']
    def __init__(self, chats: List['TypeChat']):
        object.__setattr__(self, 'chats', chats)

    def _bytes(self):
        return b''.join((
            b'\xd5\x9f\xffd',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        return cls(chats=_chats)


@dataclasses.dataclass(init=False, frozen=True)
class ChatsSlice(TLObject):
    """
    Constructor for messages.Chats: Instance of either Chats, ChatsSlice.
    """
    __slots__ = ('count', 'chats',)
    CONSTRUCTOR_ID = 0x9cd81144
    SUBCLASS_OF_ID = 0x99d5cb14

    count: int
    chats: List['TypeChat']
    def __init__(self, count: int, chats: List['TypeChat']):
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'chats', chats)

    def _bytes(self):
        return b''.join((
            b'D\x11\xd8\x9c',
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _count = reader.read_int()
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        return cls(count=_count, chats=_chats)


@dataclasses.dataclass(init=False, frozen=True)
class CheckedHistoryImportPeer(TLObject):
    """
    Constructor for messages.CheckedHistoryImportPeer: Instance of CheckedHistoryImportPeer.
    """
    __slots__ = ('confirm_text',)
    CONSTRUCTOR_ID = 0xa24de717
    SUBCLASS_OF_ID = 0xb84bb337

    confirm_text: str
    def __init__(self, confirm_text: str):
        object.__setattr__(self, 'confirm_text', confirm_text)

    def _bytes(self):
        return b''.join((
            b'\x17\xe7M\xa2',
            self._serialize_bytes(self.confirm_text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _confirm_text = reader.tgread_string()
        return cls(confirm_text=_confirm_text)


@dataclasses.dataclass(init=False, frozen=True)
class DhConfig(TLObject):
    """
    Constructor for messages.DhConfig: Instance of either DhConfigNotModified, DhConfig.
    """
    __slots__ = ('g', 'p', 'version', 'random',)
    CONSTRUCTOR_ID = 0x2c221edd
    SUBCLASS_OF_ID = 0xe488ed8b

    g: int
    p: bytes
    version: int
    random: bytes
    def __init__(self, g: int, p: bytes, version: int, random: bytes):
        object.__setattr__(self, 'g', g)
        object.__setattr__(self, 'p', p)
        object.__setattr__(self, 'version', version)
        object.__setattr__(self, 'random', random)

    def _bytes(self):
        return b''.join((
            b'\xdd\x1e",',
            struct.pack('<i', self.g),
            self._serialize_bytes(self.p),
            struct.pack('<i', self.version),
            self._serialize_bytes(self.random),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _g = reader.read_int()
        _p = reader.tgread_bytes()
        _version = reader.read_int()
        _random = reader.tgread_bytes()
        return cls(g=_g, p=_p, version=_version, random=_random)


@dataclasses.dataclass(init=False, frozen=True)
class DhConfigNotModified(TLObject):
    """
    Constructor for messages.DhConfig: Instance of either DhConfigNotModified, DhConfig.
    """
    __slots__ = ('random',)
    CONSTRUCTOR_ID = 0xc0e24635
    SUBCLASS_OF_ID = 0xe488ed8b

    random: bytes
    def __init__(self, random: bytes):
        object.__setattr__(self, 'random', random)

    def _bytes(self):
        return b''.join((
            b'5F\xe2\xc0',
            self._serialize_bytes(self.random),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _random = reader.tgread_bytes()
        return cls(random=_random)


@dataclasses.dataclass(init=False, frozen=True)
class Dialogs(TLObject):
    """
    Constructor for messages.Dialogs: Instance of either Dialogs, DialogsSlice, DialogsNotModified.
    """
    __slots__ = ('dialogs', 'messages', 'chats', 'users',)
    CONSTRUCTOR_ID = 0x15ba6c40
    SUBCLASS_OF_ID = 0xe1b52ee

    dialogs: List['TypeDialog']
    messages: List['TypeMessage']
    chats: List['TypeChat']
    users: List['TypeUser']
    def __init__(self, dialogs: List['TypeDialog'], messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser']):
        object.__setattr__(self, 'dialogs', dialogs)
        object.__setattr__(self, 'messages', messages)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'@l\xba\x15',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dialogs)),b''.join(x._bytes() for x in self.dialogs),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _dialogs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _dialogs.append(_x)

        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(dialogs=_dialogs, messages=_messages, chats=_chats, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class DialogsNotModified(TLObject):
    """
    Constructor for messages.Dialogs: Instance of either Dialogs, DialogsSlice, DialogsNotModified.
    """
    __slots__ = ('count',)
    CONSTRUCTOR_ID = 0xf0e3e596
    SUBCLASS_OF_ID = 0xe1b52ee

    count: int
    def __init__(self, count: int):
        object.__setattr__(self, 'count', count)

    def _bytes(self):
        return b''.join((
            b'\x96\xe5\xe3\xf0',
            struct.pack('<i', self.count),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _count = reader.read_int()
        return cls(count=_count)


@dataclasses.dataclass(init=False, frozen=True)
class DialogsSlice(TLObject):
    """
    Constructor for messages.Dialogs: Instance of either Dialogs, DialogsSlice, DialogsNotModified.
    """
    __slots__ = ('count', 'dialogs', 'messages', 'chats', 'users',)
    CONSTRUCTOR_ID = 0x71e094f3
    SUBCLASS_OF_ID = 0xe1b52ee

    count: int
    dialogs: List['TypeDialog']
    messages: List['TypeMessage']
    chats: List['TypeChat']
    users: List['TypeUser']
    def __init__(self, count: int, dialogs: List['TypeDialog'], messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser']):
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'dialogs', dialogs)
        object.__setattr__(self, 'messages', messages)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\xf3\x94\xe0q',
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dialogs)),b''.join(x._bytes() for x in self.dialogs),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _count = reader.read_int()
        reader.read_int()
        _dialogs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _dialogs.append(_x)

        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(count=_count, dialogs=_dialogs, messages=_messages, chats=_chats, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class DiscussionMessage(TLObject):
    """
    Constructor for messages.DiscussionMessage: Instance of DiscussionMessage.
    """
    __slots__ = ('messages', 'unread_count', 'chats', 'users', 'max_id', 'read_inbox_max_id', 'read_outbox_max_id',)
    CONSTRUCTOR_ID = 0xa6341782
    SUBCLASS_OF_ID = 0x53f8e3e8

    messages: List['TypeMessage']
    unread_count: int
    chats: List['TypeChat']
    users: List['TypeUser']
    max_id: Optional[int]
    read_inbox_max_id: Optional[int]
    read_outbox_max_id: Optional[int]
    def __init__(self, messages: List['TypeMessage'], unread_count: int, chats: List['TypeChat'], users: List['TypeUser'], max_id: Optional[int]=None, read_inbox_max_id: Optional[int]=None, read_outbox_max_id: Optional[int]=None):
        object.__setattr__(self, 'messages', messages)
        object.__setattr__(self, 'unread_count', unread_count)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)
        object.__setattr__(self, 'max_id', max_id)
        object.__setattr__(self, 'read_inbox_max_id', read_inbox_max_id)
        object.__setattr__(self, 'read_outbox_max_id', read_outbox_max_id)

    def _bytes(self):
        return b''.join((
            b'\x82\x174\xa6',
            struct.pack('<I', (0 if self.max_id is None or self.max_id is False else 1) | (0 if self.read_inbox_max_id is None or self.read_inbox_max_id is False else 2) | (0 if self.read_outbox_max_id is None or self.read_outbox_max_id is False else 4)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'' if self.max_id is None or self.max_id is False else (struct.pack('<i', self.max_id)),
            b'' if self.read_inbox_max_id is None or self.read_inbox_max_id is False else (struct.pack('<i', self.read_inbox_max_id)),
            b'' if self.read_outbox_max_id is None or self.read_outbox_max_id is False else (struct.pack('<i', self.read_outbox_max_id)),
            struct.pack('<i', self.unread_count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        if flags & 1:
            _max_id = reader.read_int()
        else:
            _max_id = None
        if flags & 2:
            _read_inbox_max_id = reader.read_int()
        else:
            _read_inbox_max_id = None
        if flags & 4:
            _read_outbox_max_id = reader.read_int()
        else:
            _read_outbox_max_id = None
        _unread_count = reader.read_int()
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(messages=_messages, unread_count=_unread_count, chats=_chats, users=_users, max_id=_max_id, read_inbox_max_id=_read_inbox_max_id, read_outbox_max_id=_read_outbox_max_id)


@dataclasses.dataclass(init=False, frozen=True)
class ExportedChatInvite(TLObject):
    """
    Constructor for messages.ExportedChatInvite: Instance of either ExportedChatInvite, ExportedChatInviteReplaced.
    """
    __slots__ = ('invite', 'users',)
    CONSTRUCTOR_ID = 0x1871be50
    SUBCLASS_OF_ID = 0x82dcd4ca

    invite: 'TypeExportedChatInvite'
    users: List['TypeUser']
    def __init__(self, invite: 'TypeExportedChatInvite', users: List['TypeUser']):
        object.__setattr__(self, 'invite', invite)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'P\xbeq\x18',
            self.invite._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _invite = reader.tgread_object()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(invite=_invite, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class ExportedChatInviteReplaced(TLObject):
    """
    Constructor for messages.ExportedChatInvite: Instance of either ExportedChatInvite, ExportedChatInviteReplaced.
    """
    __slots__ = ('invite', 'new_invite', 'users',)
    CONSTRUCTOR_ID = 0x222600ef
    SUBCLASS_OF_ID = 0x82dcd4ca

    invite: 'TypeExportedChatInvite'
    new_invite: 'TypeExportedChatInvite'
    users: List['TypeUser']
    def __init__(self, invite: 'TypeExportedChatInvite', new_invite: 'TypeExportedChatInvite', users: List['TypeUser']):
        object.__setattr__(self, 'invite', invite)
        object.__setattr__(self, 'new_invite', new_invite)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\xef\x00&"',
            self.invite._bytes(),
            self.new_invite._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _invite = reader.tgread_object()
        _new_invite = reader.tgread_object()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(invite=_invite, new_invite=_new_invite, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class ExportedChatInvites(TLObject):
    """
    Constructor for messages.ExportedChatInvites: Instance of ExportedChatInvites.
    """
    __slots__ = ('count', 'invites', 'users',)
    CONSTRUCTOR_ID = 0xbdc62dcc
    SUBCLASS_OF_ID = 0x603d3871

    count: int
    invites: List['TypeExportedChatInvite']
    users: List['TypeUser']
    def __init__(self, count: int, invites: List['TypeExportedChatInvite'], users: List['TypeUser']):
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'invites', invites)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\xcc-\xc6\xbd',
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.invites)),b''.join(x._bytes() for x in self.invites),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _count = reader.read_int()
        reader.read_int()
        _invites = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _invites.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(count=_count, invites=_invites, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class FavedStickers(TLObject):
    """
    Constructor for messages.FavedStickers: Instance of either FavedStickersNotModified, FavedStickers.
    """
    __slots__ = ('hash', 'packs', 'stickers',)
    CONSTRUCTOR_ID = 0x2cb51097
    SUBCLASS_OF_ID = 0x8e736fb9

    hash: int
    packs: List['TypeStickerPack']
    stickers: List['TypeDocument']
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, packs: List['TypeStickerPack'], stickers: List['TypeDocument']):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'packs', packs)
        object.__setattr__(self, 'stickers', stickers)

    def _bytes(self):
        return b''.join((
            b'\x97\x10\xb5,',
            struct.pack('<q', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.packs)),b''.join(x._bytes() for x in self.packs),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(x._bytes() for x in self.stickers),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        reader.read_int()
        _packs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _packs.append(_x)

        reader.read_int()
        _stickers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _stickers.append(_x)

        return cls(hash=_hash, packs=_packs, stickers=_stickers)


@dataclasses.dataclass(init=False, frozen=True)
class FavedStickersNotModified(TLObject):
    """
    Constructor for messages.FavedStickers: Instance of either FavedStickersNotModified, FavedStickers.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9e8fa6d3
    SUBCLASS_OF_ID = 0x8e736fb9

    def _bytes(self):
        return b''.join((
            b'\xd3\xa6\x8f\x9e',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class FeaturedStickers(TLObject):
    """
    Constructor for messages.FeaturedStickers: Instance of either FeaturedStickersNotModified, FeaturedStickers.
    """
    __slots__ = ('hash', 'count', 'sets', 'unread',)
    CONSTRUCTOR_ID = 0x84c02310
    SUBCLASS_OF_ID = 0x2614b722

    hash: int
    count: int
    sets: List['TypeStickerSetCovered']
    unread: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, count: int, sets: List['TypeStickerSetCovered'], unread: List[int]):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'sets', sets)
        object.__setattr__(self, 'unread', unread)

    def _bytes(self):
        return b''.join((
            b'\x10#\xc0\x84',
            struct.pack('<q', self.hash),
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sets)),b''.join(x._bytes() for x in self.sets),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.unread)),b''.join(struct.pack('<q', x) for x in self.unread),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        _count = reader.read_int()
        reader.read_int()
        _sets = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _sets.append(_x)

        reader.read_int()
        _unread = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _unread.append(_x)

        return cls(hash=_hash, count=_count, sets=_sets, unread=_unread)


@dataclasses.dataclass(init=False, frozen=True)
class FeaturedStickersNotModified(TLObject):
    """
    Constructor for messages.FeaturedStickers: Instance of either FeaturedStickersNotModified, FeaturedStickers.
    """
    __slots__ = ('count',)
    CONSTRUCTOR_ID = 0xc6dc0c66
    SUBCLASS_OF_ID = 0x2614b722

    count: int
    def __init__(self, count: int):
        object.__setattr__(self, 'count', count)

    def _bytes(self):
        return b''.join((
            b'f\x0c\xdc\xc6',
            struct.pack('<i', self.count),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _count = reader.read_int()
        return cls(count=_count)


@dataclasses.dataclass(init=False, frozen=True)
class FoundStickerSets(TLObject):
    """
    Constructor for messages.FoundStickerSets: Instance of either FoundStickerSetsNotModified, FoundStickerSets.
    """
    __slots__ = ('hash', 'sets',)
    CONSTRUCTOR_ID = 0x8af09dd2
    SUBCLASS_OF_ID = 0x40df361

    hash: int
    sets: List['TypeStickerSetCovered']
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, sets: List['TypeStickerSetCovered']):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'sets', sets)

    def _bytes(self):
        return b''.join((
            b'\xd2\x9d\xf0\x8a',
            struct.pack('<q', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sets)),b''.join(x._bytes() for x in self.sets),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        reader.read_int()
        _sets = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _sets.append(_x)

        return cls(hash=_hash, sets=_sets)


@dataclasses.dataclass(init=False, frozen=True)
class FoundStickerSetsNotModified(TLObject):
    """
    Constructor for messages.FoundStickerSets: Instance of either FoundStickerSetsNotModified, FoundStickerSets.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd54b65d
    SUBCLASS_OF_ID = 0x40df361

    def _bytes(self):
        return b''.join((
            b']\xb6T\r',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class HighScores(TLObject):
    """
    Constructor for messages.HighScores: Instance of HighScores.
    """
    __slots__ = ('scores', 'users',)
    CONSTRUCTOR_ID = 0x9a3bfd99
    SUBCLASS_OF_ID = 0x6ccd95fd

    scores: List['TypeHighScore']
    users: List['TypeUser']
    def __init__(self, scores: List['TypeHighScore'], users: List['TypeUser']):
        object.__setattr__(self, 'scores', scores)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\x99\xfd;\x9a',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.scores)),b''.join(x._bytes() for x in self.scores),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _scores = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _scores.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(scores=_scores, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class HistoryImport(TLObject):
    """
    Constructor for messages.HistoryImport: Instance of HistoryImport.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x1662af0b
    SUBCLASS_OF_ID = 0xb18bb50a

    id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'\x0b\xafb\x16',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class HistoryImportParsed(TLObject):
    """
    Constructor for messages.HistoryImportParsed: Instance of HistoryImportParsed.
    """
    __slots__ = ('pm', 'group', 'title',)
    CONSTRUCTOR_ID = 0x5e0fb7b9
    SUBCLASS_OF_ID = 0x5bb2720b

    pm: Optional[bool]
    group: Optional[bool]
    title: Optional[str]
    def __init__(self, pm: Optional[bool]=None, group: Optional[bool]=None, title: Optional[str]=None):
        object.__setattr__(self, 'pm', pm)
        object.__setattr__(self, 'group', group)
        object.__setattr__(self, 'title', title)

    def _bytes(self):
        return b''.join((
            b'\xb9\xb7\x0f^',
            struct.pack('<I', (0 if self.pm is None or self.pm is False else 1) | (0 if self.group is None or self.group is False else 2) | (0 if self.title is None or self.title is False else 4)),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _pm = bool(flags & 1)
        _group = bool(flags & 2)
        if flags & 4:
            _title = reader.tgread_string()
        else:
            _title = None
        return cls(pm=_pm, group=_group, title=_title)


@dataclasses.dataclass(init=False, frozen=True)
class InactiveChats(TLObject):
    """
    Constructor for messages.InactiveChats: Instance of InactiveChats.
    """
    __slots__ = ('dates', 'chats', 'users',)
    CONSTRUCTOR_ID = 0xa927fec5
    SUBCLASS_OF_ID = 0x8bf3d7d4

    dates: List[int]
    chats: List['TypeChat']
    users: List['TypeUser']
    def __init__(self, dates: List[int], chats: List['TypeChat'], users: List['TypeUser']):
        object.__setattr__(self, 'dates', dates)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b"\xc5\xfe'\xa9",
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dates)),b''.join(struct.pack('<i', x) for x in self.dates),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _dates = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _dates.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(dates=_dates, chats=_chats, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEditData(TLObject):
    """
    Constructor for messages.MessageEditData: Instance of MessageEditData.
    """
    __slots__ = ('caption',)
    CONSTRUCTOR_ID = 0x26b5dde6
    SUBCLASS_OF_ID = 0xfb47949d

    caption: Optional[bool]
    def __init__(self, caption: Optional[bool]=None):
        object.__setattr__(self, 'caption', caption)

    def _bytes(self):
        return b''.join((
            b'\xe6\xdd\xb5&',
            struct.pack('<I', (0 if self.caption is None or self.caption is False else 1)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _caption = bool(flags & 1)
        return cls(caption=_caption)


@dataclasses.dataclass(init=False, frozen=True)
class MessageReactionsList(TLObject):
    """
    Constructor for messages.MessageReactionsList: Instance of MessageReactionsList.
    """
    __slots__ = ('count', 'reactions', 'chats', 'users', 'next_offset',)
    CONSTRUCTOR_ID = 0x31bd492d
    SUBCLASS_OF_ID = 0x60fce5e6

    count: int
    reactions: List['TypeMessagePeerReaction']
    chats: List['TypeChat']
    users: List['TypeUser']
    next_offset: Optional[str]
    def __init__(self, count: int, reactions: List['TypeMessagePeerReaction'], chats: List['TypeChat'], users: List['TypeUser'], next_offset: Optional[str]=None):
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'reactions', reactions)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)
        object.__setattr__(self, 'next_offset', next_offset)

    def _bytes(self):
        return b''.join((
            b'-I\xbd1',
            struct.pack('<I', (0 if self.next_offset is None or self.next_offset is False else 1)),
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.reactions)),b''.join(x._bytes() for x in self.reactions),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
            b'' if self.next_offset is None or self.next_offset is False else (self._serialize_bytes(self.next_offset)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _count = reader.read_int()
        reader.read_int()
        _reactions = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _reactions.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        if flags & 1:
            _next_offset = reader.tgread_string()
        else:
            _next_offset = None
        return cls(count=_count, reactions=_reactions, chats=_chats, users=_users, next_offset=_next_offset)


@dataclasses.dataclass(init=False, frozen=True)
class MessageViews(TLObject):
    """
    Constructor for messages.MessageViews: Instance of MessageViews.
    """
    __slots__ = ('views', 'chats', 'users',)
    CONSTRUCTOR_ID = 0xb6c4f543
    SUBCLASS_OF_ID = 0xafb5eb9c

    views: List['TypeMessageViews']
    chats: List['TypeChat']
    users: List['TypeUser']
    def __init__(self, views: List['TypeMessageViews'], chats: List['TypeChat'], users: List['TypeUser']):
        object.__setattr__(self, 'views', views)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'C\xf5\xc4\xb6',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.views)),b''.join(x._bytes() for x in self.views),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _views = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _views.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(views=_views, chats=_chats, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class Messages(TLObject):
    """
    Constructor for messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('messages', 'chats', 'users',)
    CONSTRUCTOR_ID = 0x8c718e87
    SUBCLASS_OF_ID = 0xd4b40b5e

    messages: List['TypeMessage']
    chats: List['TypeChat']
    users: List['TypeUser']
    def __init__(self, messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser']):
        object.__setattr__(self, 'messages', messages)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\x87\x8eq\x8c',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(messages=_messages, chats=_chats, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class MessagesNotModified(TLObject):
    """
    Constructor for messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('count',)
    CONSTRUCTOR_ID = 0x74535f21
    SUBCLASS_OF_ID = 0xd4b40b5e

    count: int
    def __init__(self, count: int):
        object.__setattr__(self, 'count', count)

    def _bytes(self):
        return b''.join((
            b'!_St',
            struct.pack('<i', self.count),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _count = reader.read_int()
        return cls(count=_count)


@dataclasses.dataclass(init=False, frozen=True)
class MessagesSlice(TLObject):
    """
    Constructor for messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('count', 'messages', 'chats', 'users', 'inexact', 'next_rate', 'offset_id_offset',)
    CONSTRUCTOR_ID = 0x3a54685e
    SUBCLASS_OF_ID = 0xd4b40b5e

    count: int
    messages: List['TypeMessage']
    chats: List['TypeChat']
    users: List['TypeUser']
    inexact: Optional[bool]
    next_rate: Optional[int]
    offset_id_offset: Optional[int]
    def __init__(self, count: int, messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser'], inexact: Optional[bool]=None, next_rate: Optional[int]=None, offset_id_offset: Optional[int]=None):
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'messages', messages)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)
        object.__setattr__(self, 'inexact', inexact)
        object.__setattr__(self, 'next_rate', next_rate)
        object.__setattr__(self, 'offset_id_offset', offset_id_offset)

    def _bytes(self):
        return b''.join((
            b'^hT:',
            struct.pack('<I', (0 if self.inexact is None or self.inexact is False else 2) | (0 if self.next_rate is None or self.next_rate is False else 1) | (0 if self.offset_id_offset is None or self.offset_id_offset is False else 4)),
            struct.pack('<i', self.count),
            b'' if self.next_rate is None or self.next_rate is False else (struct.pack('<i', self.next_rate)),
            b'' if self.offset_id_offset is None or self.offset_id_offset is False else (struct.pack('<i', self.offset_id_offset)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _inexact = bool(flags & 2)
        _count = reader.read_int()
        if flags & 1:
            _next_rate = reader.read_int()
        else:
            _next_rate = None
        if flags & 4:
            _offset_id_offset = reader.read_int()
        else:
            _offset_id_offset = None
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(count=_count, messages=_messages, chats=_chats, users=_users, inexact=_inexact, next_rate=_next_rate, offset_id_offset=_offset_id_offset)


@dataclasses.dataclass(init=False, frozen=True)
class PeerDialogs(TLObject):
    """
    Constructor for messages.PeerDialogs: Instance of PeerDialogs.
    """
    __slots__ = ('dialogs', 'messages', 'chats', 'users', 'state',)
    CONSTRUCTOR_ID = 0x3371c354
    SUBCLASS_OF_ID = 0x3ac70132

    dialogs: List['TypeDialog']
    messages: List['TypeMessage']
    chats: List['TypeChat']
    users: List['TypeUser']
    state: 'TypeState'
    def __init__(self, dialogs: List['TypeDialog'], messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser'], state: 'TypeState'):
        object.__setattr__(self, 'dialogs', dialogs)
        object.__setattr__(self, 'messages', messages)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)
        object.__setattr__(self, 'state', state)

    def _bytes(self):
        return b''.join((
            b'T\xc3q3',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dialogs)),b''.join(x._bytes() for x in self.dialogs),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
            self.state._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _dialogs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _dialogs.append(_x)

        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        _state = reader.tgread_object()
        return cls(dialogs=_dialogs, messages=_messages, chats=_chats, users=_users, state=_state)


@dataclasses.dataclass(init=False, frozen=True)
class PeerSettings(TLObject):
    """
    Constructor for messages.PeerSettings: Instance of PeerSettings.
    """
    __slots__ = ('settings', 'chats', 'users',)
    CONSTRUCTOR_ID = 0x6880b94d
    SUBCLASS_OF_ID = 0x65a2f7a1

    settings: 'TypePeerSettings'
    chats: List['TypeChat']
    users: List['TypeUser']
    def __init__(self, settings: 'TypePeerSettings', chats: List['TypeChat'], users: List['TypeUser']):
        object.__setattr__(self, 'settings', settings)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'M\xb9\x80h',
            self.settings._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _settings = reader.tgread_object()
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(settings=_settings, chats=_chats, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class RecentStickers(TLObject):
    """
    Constructor for messages.RecentStickers: Instance of either RecentStickersNotModified, RecentStickers.
    """
    __slots__ = ('hash', 'packs', 'stickers', 'dates',)
    CONSTRUCTOR_ID = 0x88d37c56
    SUBCLASS_OF_ID = 0xf76f8683

    hash: int
    packs: List['TypeStickerPack']
    stickers: List['TypeDocument']
    dates: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, packs: List['TypeStickerPack'], stickers: List['TypeDocument'], dates: List[int]):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'packs', packs)
        object.__setattr__(self, 'stickers', stickers)
        object.__setattr__(self, 'dates', dates)

    def _bytes(self):
        return b''.join((
            b'V|\xd3\x88',
            struct.pack('<q', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.packs)),b''.join(x._bytes() for x in self.packs),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(x._bytes() for x in self.stickers),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dates)),b''.join(struct.pack('<i', x) for x in self.dates),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        reader.read_int()
        _packs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _packs.append(_x)

        reader.read_int()
        _stickers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _stickers.append(_x)

        reader.read_int()
        _dates = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _dates.append(_x)

        return cls(hash=_hash, packs=_packs, stickers=_stickers, dates=_dates)


@dataclasses.dataclass(init=False, frozen=True)
class RecentStickersNotModified(TLObject):
    """
    Constructor for messages.RecentStickers: Instance of either RecentStickersNotModified, RecentStickers.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb17f890
    SUBCLASS_OF_ID = 0xf76f8683

    def _bytes(self):
        return b''.join((
            b'\x90\xf8\x17\x0b',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SavedGifs(TLObject):
    """
    Constructor for messages.SavedGifs: Instance of either SavedGifsNotModified, SavedGifs.
    """
    __slots__ = ('hash', 'gifs',)
    CONSTRUCTOR_ID = 0x84a02a0d
    SUBCLASS_OF_ID = 0xa68b61f5

    hash: int
    gifs: List['TypeDocument']
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, gifs: List['TypeDocument']):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'gifs', gifs)

    def _bytes(self):
        return b''.join((
            b'\r*\xa0\x84',
            struct.pack('<q', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.gifs)),b''.join(x._bytes() for x in self.gifs),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        reader.read_int()
        _gifs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _gifs.append(_x)

        return cls(hash=_hash, gifs=_gifs)


@dataclasses.dataclass(init=False, frozen=True)
class SavedGifsNotModified(TLObject):
    """
    Constructor for messages.SavedGifs: Instance of either SavedGifsNotModified, SavedGifs.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xe8025ca2
    SUBCLASS_OF_ID = 0xa68b61f5

    def _bytes(self):
        return b''.join((
            b'\xa2\\\x02\xe8',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SearchCounter(TLObject):
    """
    Constructor for messages.SearchCounter: Instance of SearchCounter.
    """
    __slots__ = ('filter', 'count', 'inexact',)
    CONSTRUCTOR_ID = 0xe844ebff
    SUBCLASS_OF_ID = 0xd6a7bfa2

    filter: 'TypeMessagesFilter'
    count: int
    inexact: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, filter: 'TypeMessagesFilter', count: int, inexact: Optional[bool]=None):
        object.__setattr__(self, 'filter', filter)
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'inexact', inexact)

    def _bytes(self):
        return b''.join((
            b'\xff\xebD\xe8',
            struct.pack('<I', (0 if self.inexact is None or self.inexact is False else 2)),
            self.filter._bytes(),
            struct.pack('<i', self.count),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _inexact = bool(flags & 2)
        _filter = reader.tgread_object()
        _count = reader.read_int()
        return cls(filter=_filter, count=_count, inexact=_inexact)


@dataclasses.dataclass(init=False, frozen=True)
class SearchResultsCalendar(TLObject):
    """
    Constructor for messages.SearchResultsCalendar: Instance of SearchResultsCalendar.
    """
    __slots__ = ('count', 'min_date', 'min_msg_id', 'periods', 'messages', 'chats', 'users', 'inexact', 'offset_id_offset',)
    CONSTRUCTOR_ID = 0x147ee23c
    SUBCLASS_OF_ID = 0x92c5640f

    count: int
    min_date: Optional[datetime]
    min_msg_id: int
    periods: List['TypeSearchResultsCalendarPeriod']
    messages: List['TypeMessage']
    chats: List['TypeChat']
    users: List['TypeUser']
    inexact: Optional[bool]
    offset_id_offset: Optional[int]
    def __init__(self, count: int, min_date: Optional[datetime], min_msg_id: int, periods: List['TypeSearchResultsCalendarPeriod'], messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser'], inexact: Optional[bool]=None, offset_id_offset: Optional[int]=None):
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'min_date', min_date)
        object.__setattr__(self, 'min_msg_id', min_msg_id)
        object.__setattr__(self, 'periods', periods)
        object.__setattr__(self, 'messages', messages)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)
        object.__setattr__(self, 'inexact', inexact)
        object.__setattr__(self, 'offset_id_offset', offset_id_offset)

    def _bytes(self):
        return b''.join((
            b'<\xe2~\x14',
            struct.pack('<I', (0 if self.inexact is None or self.inexact is False else 1) | (0 if self.offset_id_offset is None or self.offset_id_offset is False else 2)),
            struct.pack('<i', self.count),
            self._serialize_datetime(self.min_date),
            struct.pack('<i', self.min_msg_id),
            b'' if self.offset_id_offset is None or self.offset_id_offset is False else (struct.pack('<i', self.offset_id_offset)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.periods)),b''.join(x._bytes() for x in self.periods),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _inexact = bool(flags & 1)
        _count = reader.read_int()
        _min_date = reader.tgread_date()
        _min_msg_id = reader.read_int()
        if flags & 2:
            _offset_id_offset = reader.read_int()
        else:
            _offset_id_offset = None
        reader.read_int()
        _periods = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _periods.append(_x)

        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(count=_count, min_date=_min_date, min_msg_id=_min_msg_id, periods=_periods, messages=_messages, chats=_chats, users=_users, inexact=_inexact, offset_id_offset=_offset_id_offset)


@dataclasses.dataclass(init=False, frozen=True)
class SearchResultsPositions(TLObject):
    """
    Constructor for messages.SearchResultsPositions: Instance of SearchResultsPositions.
    """
    __slots__ = ('count', 'positions',)
    CONSTRUCTOR_ID = 0x53b22baf
    SUBCLASS_OF_ID = 0xd963708d

    count: int
    positions: List['TypeSearchResultsPosition']
    def __init__(self, count: int, positions: List['TypeSearchResultsPosition']):
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'positions', positions)

    def _bytes(self):
        return b''.join((
            b'\xaf+\xb2S',
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.positions)),b''.join(x._bytes() for x in self.positions),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _count = reader.read_int()
        reader.read_int()
        _positions = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _positions.append(_x)

        return cls(count=_count, positions=_positions)


@dataclasses.dataclass(init=False, frozen=True)
class SentEncryptedFile(TLObject):
    """
    Constructor for messages.SentEncryptedMessage: Instance of either SentEncryptedMessage, SentEncryptedFile.
    """
    __slots__ = ('date', 'file',)
    CONSTRUCTOR_ID = 0x9493ff32
    SUBCLASS_OF_ID = 0xc99e3e50

    date: Optional[datetime]
    file: 'TypeEncryptedFile'
    def __init__(self, date: Optional[datetime], file: 'TypeEncryptedFile'):
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'file', file)

    def _bytes(self):
        return b''.join((
            b'2\xff\x93\x94',
            self._serialize_datetime(self.date),
            self.file._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _date = reader.tgread_date()
        _file = reader.tgread_object()
        return cls(date=_date, file=_file)


@dataclasses.dataclass(init=False, frozen=True)
class SentEncryptedMessage(TLObject):
    """
    Constructor for messages.SentEncryptedMessage: Instance of either SentEncryptedMessage, SentEncryptedFile.
    """
    __slots__ = ('date',)
    CONSTRUCTOR_ID = 0x560f8935
    SUBCLASS_OF_ID = 0xc99e3e50

    date: Optional[datetime]
    def __init__(self, date: Optional[datetime]):
        object.__setattr__(self, 'date', date)

    def _bytes(self):
        return b''.join((
            b'5\x89\x0fV',
            self._serialize_datetime(self.date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _date = reader.tgread_date()
        return cls(date=_date)


@dataclasses.dataclass(init=False, frozen=True)
class SponsoredMessages(TLObject):
    """
    Constructor for messages.SponsoredMessages: Instance of SponsoredMessages.
    """
    __slots__ = ('messages', 'chats', 'users',)
    CONSTRUCTOR_ID = 0x65a4c7d5
    SUBCLASS_OF_ID = 0x7f4169e0

    messages: List['TypeSponsoredMessage']
    chats: List['TypeChat']
    users: List['TypeUser']
    def __init__(self, messages: List['TypeSponsoredMessage'], chats: List['TypeChat'], users: List['TypeUser']):
        object.__setattr__(self, 'messages', messages)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\xd5\xc7\xa4e',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(messages=_messages, chats=_chats, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class StickerSet(TLObject):
    """
    Constructor for messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
    """
    __slots__ = ('set', 'packs', 'documents',)
    CONSTRUCTOR_ID = 0xb60a24a6
    SUBCLASS_OF_ID = 0x9b704a5a

    set: 'TypeStickerSet'
    packs: List['TypeStickerPack']
    documents: List['TypeDocument']
    # noinspection PyShadowingBuiltins
    def __init__(self, set: 'TypeStickerSet', packs: List['TypeStickerPack'], documents: List['TypeDocument']):
        object.__setattr__(self, 'set', set)
        object.__setattr__(self, 'packs', packs)
        object.__setattr__(self, 'documents', documents)

    def _bytes(self):
        return b''.join((
            b'\xa6$\n\xb6',
            self.set._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.packs)),b''.join(x._bytes() for x in self.packs),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.documents)),b''.join(x._bytes() for x in self.documents),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _set = reader.tgread_object()
        reader.read_int()
        _packs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _packs.append(_x)

        reader.read_int()
        _documents = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _documents.append(_x)

        return cls(set=_set, packs=_packs, documents=_documents)


@dataclasses.dataclass(init=False, frozen=True)
class StickerSetInstallResultArchive(TLObject):
    """
    Constructor for messages.StickerSetInstallResult: Instance of either StickerSetInstallResultSuccess, StickerSetInstallResultArchive.
    """
    __slots__ = ('sets',)
    CONSTRUCTOR_ID = 0x35e410a8
    SUBCLASS_OF_ID = 0x67cb3fe8

    sets: List['TypeStickerSetCovered']
    def __init__(self, sets: List['TypeStickerSetCovered']):
        object.__setattr__(self, 'sets', sets)

    def _bytes(self):
        return b''.join((
            b'\xa8\x10\xe45',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sets)),b''.join(x._bytes() for x in self.sets),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _sets = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _sets.append(_x)

        return cls(sets=_sets)


@dataclasses.dataclass(init=False, frozen=True)
class StickerSetInstallResultSuccess(TLObject):
    """
    Constructor for messages.StickerSetInstallResult: Instance of either StickerSetInstallResultSuccess, StickerSetInstallResultArchive.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x38641628
    SUBCLASS_OF_ID = 0x67cb3fe8

    def _bytes(self):
        return b''.join((
            b'(\x16d8',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class StickerSetNotModified(TLObject):
    """
    Constructor for messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd3f924eb
    SUBCLASS_OF_ID = 0x9b704a5a

    def _bytes(self):
        return b''.join((
            b'\xeb$\xf9\xd3',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class Stickers(TLObject):
    """
    Constructor for messages.Stickers: Instance of either StickersNotModified, Stickers.
    """
    __slots__ = ('hash', 'stickers',)
    CONSTRUCTOR_ID = 0x30a6ec7e
    SUBCLASS_OF_ID = 0xd73bb9de

    hash: int
    stickers: List['TypeDocument']
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, stickers: List['TypeDocument']):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'stickers', stickers)

    def _bytes(self):
        return b''.join((
            b'~\xec\xa60',
            struct.pack('<q', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(x._bytes() for x in self.stickers),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        reader.read_int()
        _stickers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _stickers.append(_x)

        return cls(hash=_hash, stickers=_stickers)


@dataclasses.dataclass(init=False, frozen=True)
class StickersNotModified(TLObject):
    """
    Constructor for messages.Stickers: Instance of either StickersNotModified, Stickers.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xf1749a22
    SUBCLASS_OF_ID = 0xd73bb9de

    def _bytes(self):
        return b''.join((
            b'"\x9at\xf1',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class TranslateNoResult(TLObject):
    """
    Constructor for messages.TranslatedText: Instance of either TranslateNoResult, TranslateResultText.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x67ca4737
    SUBCLASS_OF_ID = 0x24243e8

    def _bytes(self):
        return b''.join((
            b'7G\xcag',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class TranslateResultText(TLObject):
    """
    Constructor for messages.TranslatedText: Instance of either TranslateNoResult, TranslateResultText.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0xa214f7d0
    SUBCLASS_OF_ID = 0x24243e8

    text: str
    def __init__(self, text: str):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xd0\xf7\x14\xa2',
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class VotesList(TLObject):
    """
    Constructor for messages.VotesList: Instance of VotesList.
    """
    __slots__ = ('count', 'votes', 'users', 'next_offset',)
    CONSTRUCTOR_ID = 0x823f649
    SUBCLASS_OF_ID = 0xc2199885

    count: int
    votes: List['TypeMessageUserVote']
    users: List['TypeUser']
    next_offset: Optional[str]
    def __init__(self, count: int, votes: List['TypeMessageUserVote'], users: List['TypeUser'], next_offset: Optional[str]=None):
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'votes', votes)
        object.__setattr__(self, 'users', users)
        object.__setattr__(self, 'next_offset', next_offset)

    def _bytes(self):
        return b''.join((
            b'I\xf6#\x08',
            struct.pack('<I', (0 if self.next_offset is None or self.next_offset is False else 1)),
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.votes)),b''.join(x._bytes() for x in self.votes),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
            b'' if self.next_offset is None or self.next_offset is False else (self._serialize_bytes(self.next_offset)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _count = reader.read_int()
        reader.read_int()
        _votes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _votes.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        if flags & 1:
            _next_offset = reader.tgread_string()
        else:
            _next_offset = None
        return cls(count=_count, votes=_votes, users=_users, next_offset=_next_offset)

