"""File generated by TLObjects' generator. All changes will be ERASED"""
from .._misc.tlobject import TLObject, TLRequest
from . import fn
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from . import TypeAccessPointRule, TypeChat, TypeDataJSON, TypeDocument, TypeMessageEntity, TypePeer, TypeRecentMeUrl, TypeUser
    from ..help import TypeCountry, TypeCountryCode, TypeTermsOfService



@dataclasses.dataclass(init=False, frozen=True)
class AppUpdate(TLObject):
    """
    Constructor for help.AppUpdate: Instance of either AppUpdate, NoAppUpdate.
    """
    __slots__ = ('id', 'version', 'text', 'entities', 'can_not_skip', 'document', 'url', 'sticker',)
    CONSTRUCTOR_ID = 0xccbbce30
    SUBCLASS_OF_ID = 0x5897069e

    id: int
    version: str
    text: str
    entities: List['TypeMessageEntity']
    can_not_skip: Optional[bool]
    document: Optional['TypeDocument']
    url: Optional[str]
    sticker: Optional['TypeDocument']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, version: str, text: str, entities: List['TypeMessageEntity'], can_not_skip: Optional[bool]=None, document: Optional['TypeDocument']=None, url: Optional[str]=None, sticker: Optional['TypeDocument']=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'version', version)
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'entities', entities)
        object.__setattr__(self, 'can_not_skip', can_not_skip)
        object.__setattr__(self, 'document', document)
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'sticker', sticker)

    def _bytes(self):
        return b''.join((
            b'0\xce\xbb\xcc',
            struct.pack('<I', (0 if self.can_not_skip is None or self.can_not_skip is False else 1) | (0 if self.document is None or self.document is False else 2) | (0 if self.url is None or self.url is False else 4) | (0 if self.sticker is None or self.sticker is False else 8)),
            struct.pack('<i', self.id),
            self._serialize_bytes(self.version),
            self._serialize_bytes(self.text),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
            b'' if self.url is None or self.url is False else (self._serialize_bytes(self.url)),
            b'' if self.sticker is None or self.sticker is False else (self.sticker._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _can_not_skip = bool(flags & 1)
        _id = reader.read_int()
        _version = reader.tgread_string()
        _text = reader.tgread_string()
        reader.read_int()
        _entities = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _entities.append(_x)

        if flags & 2:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 4:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 8:
            _sticker = reader.tgread_object()
        else:
            _sticker = None
        return cls(id=_id, version=_version, text=_text, entities=_entities, can_not_skip=_can_not_skip, document=_document, url=_url, sticker=_sticker)


@dataclasses.dataclass(init=False, frozen=True)
class ConfigSimple(TLObject):
    """
    Constructor for help.ConfigSimple: Instance of ConfigSimple.
    """
    __slots__ = ('date', 'expires', 'rules',)
    CONSTRUCTOR_ID = 0x5a592a6c
    SUBCLASS_OF_ID = 0x29183ac4

    date: Optional[datetime]
    expires: Optional[datetime]
    rules: List['TypeAccessPointRule']
    def __init__(self, date: Optional[datetime], expires: Optional[datetime], rules: List['TypeAccessPointRule']):
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'expires', expires)
        object.__setattr__(self, 'rules', rules)

    def _bytes(self):
        return b''.join((
            b'l*YZ',
            self._serialize_datetime(self.date),
            self._serialize_datetime(self.expires),
            struct.pack('<i', len(self.rules)),b''.join(x._bytes() for x in self.rules),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _date = reader.tgread_date()
        _expires = reader.tgread_date()
        _rules = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _rules.append(_x)

        return cls(date=_date, expires=_expires, rules=_rules)


@dataclasses.dataclass(init=False, frozen=True)
class CountriesList(TLObject):
    """
    Constructor for help.CountriesList: Instance of either CountriesListNotModified, CountriesList.
    """
    __slots__ = ('countries', 'hash',)
    CONSTRUCTOR_ID = 0x87d0759e
    SUBCLASS_OF_ID = 0xea31fe88

    countries: List['TypeCountry']
    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, countries: List['TypeCountry'], hash: int):
        object.__setattr__(self, 'countries', countries)
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\x9eu\xd0\x87',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.countries)),b''.join(x._bytes() for x in self.countries),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _countries = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _countries.append(_x)

        _hash = reader.read_int()
        return cls(countries=_countries, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class CountriesListNotModified(TLObject):
    """
    Constructor for help.CountriesList: Instance of either CountriesListNotModified, CountriesList.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x93cc1f32
    SUBCLASS_OF_ID = 0xea31fe88

    def _bytes(self):
        return b''.join((
            b'2\x1f\xcc\x93',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class Country(TLObject):
    """
    Constructor for help.Country: Instance of Country.
    """
    __slots__ = ('iso2', 'default_name', 'country_codes', 'hidden', 'name',)
    CONSTRUCTOR_ID = 0xc3878e23
    SUBCLASS_OF_ID = 0xa22e9e28

    iso2: str
    default_name: str
    country_codes: List['TypeCountryCode']
    hidden: Optional[bool]
    name: Optional[str]
    def __init__(self, iso2: str, default_name: str, country_codes: List['TypeCountryCode'], hidden: Optional[bool]=None, name: Optional[str]=None):
        object.__setattr__(self, 'iso2', iso2)
        object.__setattr__(self, 'default_name', default_name)
        object.__setattr__(self, 'country_codes', country_codes)
        object.__setattr__(self, 'hidden', hidden)
        object.__setattr__(self, 'name', name)

    def _bytes(self):
        return b''.join((
            b'#\x8e\x87\xc3',
            struct.pack('<I', (0 if self.hidden is None or self.hidden is False else 1) | (0 if self.name is None or self.name is False else 2)),
            self._serialize_bytes(self.iso2),
            self._serialize_bytes(self.default_name),
            b'' if self.name is None or self.name is False else (self._serialize_bytes(self.name)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.country_codes)),b''.join(x._bytes() for x in self.country_codes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _hidden = bool(flags & 1)
        _iso2 = reader.tgread_string()
        _default_name = reader.tgread_string()
        if flags & 2:
            _name = reader.tgread_string()
        else:
            _name = None
        reader.read_int()
        _country_codes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _country_codes.append(_x)

        return cls(iso2=_iso2, default_name=_default_name, country_codes=_country_codes, hidden=_hidden, name=_name)


@dataclasses.dataclass(init=False, frozen=True)
class CountryCode(TLObject):
    """
    Constructor for help.CountryCode: Instance of CountryCode.
    """
    __slots__ = ('country_code', 'prefixes', 'patterns',)
    CONSTRUCTOR_ID = 0x4203c5ef
    SUBCLASS_OF_ID = 0x76f34665

    country_code: str
    prefixes: Optional[List[str]]
    patterns: Optional[List[str]]
    def __init__(self, country_code: str, prefixes: Optional[List[str]]=None, patterns: Optional[List[str]]=None):
        object.__setattr__(self, 'country_code', country_code)
        object.__setattr__(self, 'prefixes', prefixes)
        object.__setattr__(self, 'patterns', patterns)

    def _bytes(self):
        return b''.join((
            b'\xef\xc5\x03B',
            struct.pack('<I', (0 if self.prefixes is None or self.prefixes is False else 1) | (0 if self.patterns is None or self.patterns is False else 2)),
            self._serialize_bytes(self.country_code),
            b'' if self.prefixes is None or self.prefixes is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.prefixes)),b''.join(self._serialize_bytes(x) for x in self.prefixes))),
            b'' if self.patterns is None or self.patterns is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.patterns)),b''.join(self._serialize_bytes(x) for x in self.patterns))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _country_code = reader.tgread_string()
        if flags & 1:
            reader.read_int()
            _prefixes = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_string()
                _prefixes.append(_x)

        else:
            _prefixes = None
        if flags & 2:
            reader.read_int()
            _patterns = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_string()
                _patterns.append(_x)

        else:
            _patterns = None
        return cls(country_code=_country_code, prefixes=_prefixes, patterns=_patterns)


@dataclasses.dataclass(init=False, frozen=True)
class DeepLinkInfo(TLObject):
    """
    Constructor for help.DeepLinkInfo: Instance of either DeepLinkInfoEmpty, DeepLinkInfo.
    """
    __slots__ = ('message', 'update_app', 'entities',)
    CONSTRUCTOR_ID = 0x6a4ee832
    SUBCLASS_OF_ID = 0x984aac38

    message: str
    update_app: Optional[bool]
    entities: Optional[List['TypeMessageEntity']]
    def __init__(self, message: str, update_app: Optional[bool]=None, entities: Optional[List['TypeMessageEntity']]=None):
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'update_app', update_app)
        object.__setattr__(self, 'entities', entities)

    def _bytes(self):
        return b''.join((
            b'2\xe8Nj',
            struct.pack('<I', (0 if self.update_app is None or self.update_app is False else 1) | (0 if self.entities is None or self.entities is False else 2)),
            self._serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _update_app = bool(flags & 1)
        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(message=_message, update_app=_update_app, entities=_entities)


@dataclasses.dataclass(init=False, frozen=True)
class DeepLinkInfoEmpty(TLObject):
    """
    Constructor for help.DeepLinkInfo: Instance of either DeepLinkInfoEmpty, DeepLinkInfo.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x66afa166
    SUBCLASS_OF_ID = 0x984aac38

    def _bytes(self):
        return b''.join((
            b'f\xa1\xaff',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InviteText(TLObject):
    """
    Constructor for help.InviteText: Instance of InviteText.
    """
    __slots__ = ('message',)
    CONSTRUCTOR_ID = 0x18cb9f78
    SUBCLASS_OF_ID = 0xcf70aa35

    message: str
    def __init__(self, message: str):
        object.__setattr__(self, 'message', message)

    def _bytes(self):
        return b''.join((
            b'x\x9f\xcb\x18',
            self._serialize_bytes(self.message),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _message = reader.tgread_string()
        return cls(message=_message)


@dataclasses.dataclass(init=False, frozen=True)
class NoAppUpdate(TLObject):
    """
    Constructor for help.AppUpdate: Instance of either AppUpdate, NoAppUpdate.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xc45a6536
    SUBCLASS_OF_ID = 0x5897069e

    def _bytes(self):
        return b''.join((
            b'6eZ\xc4',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PassportConfig(TLObject):
    """
    Constructor for help.PassportConfig: Instance of either PassportConfigNotModified, PassportConfig.
    """
    __slots__ = ('hash', 'countries_langs',)
    CONSTRUCTOR_ID = 0xa098d6af
    SUBCLASS_OF_ID = 0xc666c0ad

    hash: int
    countries_langs: 'TypeDataJSON'
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, countries_langs: 'TypeDataJSON'):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'countries_langs', countries_langs)

    def _bytes(self):
        return b''.join((
            b'\xaf\xd6\x98\xa0',
            struct.pack('<i', self.hash),
            self.countries_langs._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_int()
        _countries_langs = reader.tgread_object()
        return cls(hash=_hash, countries_langs=_countries_langs)


@dataclasses.dataclass(init=False, frozen=True)
class PassportConfigNotModified(TLObject):
    """
    Constructor for help.PassportConfig: Instance of either PassportConfigNotModified, PassportConfig.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xbfb9f457
    SUBCLASS_OF_ID = 0xc666c0ad

    def _bytes(self):
        return b''.join((
            b'W\xf4\xb9\xbf',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PromoData(TLObject):
    """
    Constructor for help.PromoData: Instance of either PromoDataEmpty, PromoData.
    """
    __slots__ = ('expires', 'peer', 'chats', 'users', 'proxy', 'psa_type', 'psa_message',)
    CONSTRUCTOR_ID = 0x8c39793f
    SUBCLASS_OF_ID = 0x9d595542

    expires: Optional[datetime]
    peer: 'TypePeer'
    chats: List['TypeChat']
    users: List['TypeUser']
    proxy: Optional[bool]
    psa_type: Optional[str]
    psa_message: Optional[str]
    def __init__(self, expires: Optional[datetime], peer: 'TypePeer', chats: List['TypeChat'], users: List['TypeUser'], proxy: Optional[bool]=None, psa_type: Optional[str]=None, psa_message: Optional[str]=None):
        object.__setattr__(self, 'expires', expires)
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)
        object.__setattr__(self, 'proxy', proxy)
        object.__setattr__(self, 'psa_type', psa_type)
        object.__setattr__(self, 'psa_message', psa_message)

    def _bytes(self):
        return b''.join((
            b'?y9\x8c',
            struct.pack('<I', (0 if self.proxy is None or self.proxy is False else 1) | (0 if self.psa_type is None or self.psa_type is False else 2) | (0 if self.psa_message is None or self.psa_message is False else 4)),
            self._serialize_datetime(self.expires),
            self.peer._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
            b'' if self.psa_type is None or self.psa_type is False else (self._serialize_bytes(self.psa_type)),
            b'' if self.psa_message is None or self.psa_message is False else (self._serialize_bytes(self.psa_message)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _proxy = bool(flags & 1)
        _expires = reader.tgread_date()
        _peer = reader.tgread_object()
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        if flags & 2:
            _psa_type = reader.tgread_string()
        else:
            _psa_type = None
        if flags & 4:
            _psa_message = reader.tgread_string()
        else:
            _psa_message = None
        return cls(expires=_expires, peer=_peer, chats=_chats, users=_users, proxy=_proxy, psa_type=_psa_type, psa_message=_psa_message)


@dataclasses.dataclass(init=False, frozen=True)
class PromoDataEmpty(TLObject):
    """
    Constructor for help.PromoData: Instance of either PromoDataEmpty, PromoData.
    """
    __slots__ = ('expires',)
    CONSTRUCTOR_ID = 0x98f6ac75
    SUBCLASS_OF_ID = 0x9d595542

    expires: Optional[datetime]
    def __init__(self, expires: Optional[datetime]):
        object.__setattr__(self, 'expires', expires)

    def _bytes(self):
        return b''.join((
            b'u\xac\xf6\x98',
            self._serialize_datetime(self.expires),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _expires = reader.tgread_date()
        return cls(expires=_expires)


@dataclasses.dataclass(init=False, frozen=True)
class RecentMeUrls(TLObject):
    """
    Constructor for help.RecentMeUrls: Instance of RecentMeUrls.
    """
    __slots__ = ('urls', 'chats', 'users',)
    CONSTRUCTOR_ID = 0xe0310d7
    SUBCLASS_OF_ID = 0xf269c477

    urls: List['TypeRecentMeUrl']
    chats: List['TypeChat']
    users: List['TypeUser']
    def __init__(self, urls: List['TypeRecentMeUrl'], chats: List['TypeChat'], users: List['TypeUser']):
        object.__setattr__(self, 'urls', urls)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\xd7\x10\x03\x0e',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.urls)),b''.join(x._bytes() for x in self.urls),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _urls = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _urls.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(urls=_urls, chats=_chats, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class Support(TLObject):
    """
    Constructor for help.Support: Instance of Support.
    """
    __slots__ = ('phone_number', 'user',)
    CONSTRUCTOR_ID = 0x17c6b5f6
    SUBCLASS_OF_ID = 0x7159bceb

    phone_number: str
    user: 'TypeUser'
    def __init__(self, phone_number: str, user: 'TypeUser'):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'user', user)

    def _bytes(self):
        return b''.join((
            b'\xf6\xb5\xc6\x17',
            self._serialize_bytes(self.phone_number),
            self.user._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _user = reader.tgread_object()
        return cls(phone_number=_phone_number, user=_user)


@dataclasses.dataclass(init=False, frozen=True)
class SupportName(TLObject):
    """
    Constructor for help.SupportName: Instance of SupportName.
    """
    __slots__ = ('name',)
    CONSTRUCTOR_ID = 0x8c05f1c9
    SUBCLASS_OF_ID = 0x7f50b7c2

    name: str
    def __init__(self, name: str):
        object.__setattr__(self, 'name', name)

    def _bytes(self):
        return b''.join((
            b'\xc9\xf1\x05\x8c',
            self._serialize_bytes(self.name),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _name = reader.tgread_string()
        return cls(name=_name)


@dataclasses.dataclass(init=False, frozen=True)
class TermsOfService(TLObject):
    """
    Constructor for help.TermsOfService: Instance of TermsOfService.
    """
    __slots__ = ('id', 'text', 'entities', 'popup', 'min_age_confirm',)
    CONSTRUCTOR_ID = 0x780a0310
    SUBCLASS_OF_ID = 0x20ee8312

    id: 'TypeDataJSON'
    text: str
    entities: List['TypeMessageEntity']
    popup: Optional[bool]
    min_age_confirm: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeDataJSON', text: str, entities: List['TypeMessageEntity'], popup: Optional[bool]=None, min_age_confirm: Optional[int]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'entities', entities)
        object.__setattr__(self, 'popup', popup)
        object.__setattr__(self, 'min_age_confirm', min_age_confirm)

    def _bytes(self):
        return b''.join((
            b'\x10\x03\nx',
            struct.pack('<I', (0 if self.popup is None or self.popup is False else 1) | (0 if self.min_age_confirm is None or self.min_age_confirm is False else 2)),
            self.id._bytes(),
            self._serialize_bytes(self.text),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities),
            b'' if self.min_age_confirm is None or self.min_age_confirm is False else (struct.pack('<i', self.min_age_confirm)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _popup = bool(flags & 1)
        _id = reader.tgread_object()
        _text = reader.tgread_string()
        reader.read_int()
        _entities = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _entities.append(_x)

        if flags & 2:
            _min_age_confirm = reader.read_int()
        else:
            _min_age_confirm = None
        return cls(id=_id, text=_text, entities=_entities, popup=_popup, min_age_confirm=_min_age_confirm)


@dataclasses.dataclass(init=False, frozen=True)
class TermsOfServiceUpdate(TLObject):
    """
    Constructor for help.TermsOfServiceUpdate: Instance of either TermsOfServiceUpdateEmpty, TermsOfServiceUpdate.
    """
    __slots__ = ('expires', 'terms_of_service',)
    CONSTRUCTOR_ID = 0x28ecf961
    SUBCLASS_OF_ID = 0x293c2977

    expires: Optional[datetime]
    terms_of_service: 'TypeTermsOfService'
    def __init__(self, expires: Optional[datetime], terms_of_service: 'TypeTermsOfService'):
        object.__setattr__(self, 'expires', expires)
        object.__setattr__(self, 'terms_of_service', terms_of_service)

    def _bytes(self):
        return b''.join((
            b'a\xf9\xec(',
            self._serialize_datetime(self.expires),
            self.terms_of_service._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _expires = reader.tgread_date()
        _terms_of_service = reader.tgread_object()
        return cls(expires=_expires, terms_of_service=_terms_of_service)


@dataclasses.dataclass(init=False, frozen=True)
class TermsOfServiceUpdateEmpty(TLObject):
    """
    Constructor for help.TermsOfServiceUpdate: Instance of either TermsOfServiceUpdateEmpty, TermsOfServiceUpdate.
    """
    __slots__ = ('expires',)
    CONSTRUCTOR_ID = 0xe3309f7f
    SUBCLASS_OF_ID = 0x293c2977

    expires: Optional[datetime]
    def __init__(self, expires: Optional[datetime]):
        object.__setattr__(self, 'expires', expires)

    def _bytes(self):
        return b''.join((
            b'\x7f\x9f0\xe3',
            self._serialize_datetime(self.expires),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _expires = reader.tgread_date()
        return cls(expires=_expires)


@dataclasses.dataclass(init=False, frozen=True)
class UserInfo(TLObject):
    """
    Constructor for help.UserInfo: Instance of either UserInfoEmpty, UserInfo.
    """
    __slots__ = ('message', 'entities', 'author', 'date',)
    CONSTRUCTOR_ID = 0x1eb3758
    SUBCLASS_OF_ID = 0x5c53d7d8

    message: str
    entities: List['TypeMessageEntity']
    author: str
    date: Optional[datetime]
    def __init__(self, message: str, entities: List['TypeMessageEntity'], author: str, date: Optional[datetime]):
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'entities', entities)
        object.__setattr__(self, 'author', author)
        object.__setattr__(self, 'date', date)

    def _bytes(self):
        return b''.join((
            b'X7\xeb\x01',
            self._serialize_bytes(self.message),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities),
            self._serialize_bytes(self.author),
            self._serialize_datetime(self.date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _message = reader.tgread_string()
        reader.read_int()
        _entities = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _entities.append(_x)

        _author = reader.tgread_string()
        _date = reader.tgread_date()
        return cls(message=_message, entities=_entities, author=_author, date=_date)


@dataclasses.dataclass(init=False, frozen=True)
class UserInfoEmpty(TLObject):
    """
    Constructor for help.UserInfo: Instance of either UserInfoEmpty, UserInfo.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xf3ae2eed
    SUBCLASS_OF_ID = 0x5c53d7d8

    def _bytes(self):
        return b''.join((
            b'\xed.\xae\xf3',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()

