"""File generated by TLObjects' generator. All changes will be ERASED"""
from ..._misc.tlobject import TLObject, TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from .. import TypeChannelMessagesFilter, TypeInputChannel



@dataclasses.dataclass(init=False, frozen=True)
class GetChannelDifference(TLRequest):
    """
    :returns updates.ChannelDifference: Instance of either ChannelDifferenceEmpty, ChannelDifferenceTooLong, ChannelDifference.
    """
    __slots__ = ('channel', 'filter', 'pts', 'limit', 'force',)
    CONSTRUCTOR_ID = 0x3173d78
    SUBCLASS_OF_ID = 0x29896f5d

    channel: 'TypeInputChannel'
    filter: 'TypeChannelMessagesFilter'
    pts: int
    limit: int
    force: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', filter: 'TypeChannelMessagesFilter', pts: int, limit: int, force: Optional[bool]=None):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'filter', filter)
        object.__setattr__(self, 'pts', pts)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'force', force)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'x=\x17\x03',
            struct.pack('<I', (0 if self.force is None or self.force is False else 1)),
            self.channel._bytes(),
            self.filter._bytes(),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _force = bool(flags & 1)
        _channel = reader.tgread_object()
        _filter = reader.tgread_object()
        _pts = reader.read_int()
        _limit = reader.read_int()
        return cls(channel=_channel, filter=_filter, pts=_pts, limit=_limit, force=_force)


@dataclasses.dataclass(init=False, frozen=True)
class GetDifference(TLRequest):
    """
    :returns updates.Difference: Instance of either DifferenceEmpty, Difference, DifferenceSlice, DifferenceTooLong.
    """
    __slots__ = ('pts', 'date', 'qts', 'pts_total_limit',)
    CONSTRUCTOR_ID = 0x25939651
    SUBCLASS_OF_ID = 0x20482874

    pts: int
    date: Optional[datetime]
    qts: int
    pts_total_limit: Optional[int]
    def __init__(self, pts: int, date: Optional[datetime], qts: int, pts_total_limit: Optional[int]=None):
        object.__setattr__(self, 'pts', pts)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'qts', qts)
        object.__setattr__(self, 'pts_total_limit', pts_total_limit)

    def _bytes(self):
        return b''.join((
            b'Q\x96\x93%',
            struct.pack('<I', (0 if self.pts_total_limit is None or self.pts_total_limit is False else 1)),
            struct.pack('<i', self.pts),
            b'' if self.pts_total_limit is None or self.pts_total_limit is False else (struct.pack('<i', self.pts_total_limit)),
            self._serialize_datetime(self.date),
            struct.pack('<i', self.qts),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _pts = reader.read_int()
        if flags & 1:
            _pts_total_limit = reader.read_int()
        else:
            _pts_total_limit = None
        _date = reader.tgread_date()
        _qts = reader.read_int()
        return cls(pts=_pts, date=_date, qts=_qts, pts_total_limit=_pts_total_limit)


@dataclasses.dataclass(init=False, frozen=True)
class GetState(TLRequest):
    """
    :returns updates.State: Instance of State.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xedd4882a
    SUBCLASS_OF_ID = 0x23df1a01

    def _bytes(self):
        return b''.join((
            b'*\x88\xd4\xed',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()

