"""File generated by TLObjects' generator. All changes will be ERASED"""
from ..._misc.tlobject import TLObject, TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from .. import TypeInputDocument, TypeInputStickerSet, TypeInputStickerSetItem, TypeInputUser



@dataclasses.dataclass(init=False, frozen=True)
class AddStickerToSet(TLRequest):
    """
    :returns messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
    """
    __slots__ = ('stickerset', 'sticker',)
    CONSTRUCTOR_ID = 0x8653febe
    SUBCLASS_OF_ID = 0x9b704a5a

    stickerset: 'TypeInputStickerSet'
    sticker: 'TypeInputStickerSetItem'
    def __init__(self, stickerset: 'TypeInputStickerSet', sticker: 'TypeInputStickerSetItem'):
        object.__setattr__(self, 'stickerset', stickerset)
        object.__setattr__(self, 'sticker', sticker)

    def _bytes(self):
        return b''.join((
            b'\xbe\xfeS\x86',
            self.stickerset._bytes(),
            self.sticker._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        _sticker = reader.tgread_object()
        return cls(stickerset=_stickerset, sticker=_sticker)


@dataclasses.dataclass(init=False, frozen=True)
class ChangeStickerPosition(TLRequest):
    """
    :returns messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
    """
    __slots__ = ('sticker', 'position',)
    CONSTRUCTOR_ID = 0xffb6d4ca
    SUBCLASS_OF_ID = 0x9b704a5a

    sticker: 'TypeInputDocument'
    position: int
    def __init__(self, sticker: 'TypeInputDocument', position: int):
        object.__setattr__(self, 'sticker', sticker)
        object.__setattr__(self, 'position', position)

    async def _resolve(self, client, utils):
        r = {}
        r['sticker'] = utils.get_input_document(self.sticker)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xca\xd4\xb6\xff',
            self.sticker._bytes(),
            struct.pack('<i', self.position),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _sticker = reader.tgread_object()
        _position = reader.read_int()
        return cls(sticker=_sticker, position=_position)


@dataclasses.dataclass(init=False, frozen=True)
class CheckShortName(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('short_name',)
    CONSTRUCTOR_ID = 0x284b3639
    SUBCLASS_OF_ID = 0xf5b399ac

    short_name: str
    def __init__(self, short_name: str):
        object.__setattr__(self, 'short_name', short_name)

    def _bytes(self):
        return b''.join((
            b'96K(',
            self._serialize_bytes(self.short_name),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _short_name = reader.tgread_string()
        return cls(short_name=_short_name)


@dataclasses.dataclass(init=False, frozen=True)
class CreateStickerSet(TLRequest):
    """
    :returns messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
    """
    __slots__ = ('user_id', 'title', 'short_name', 'stickers', 'masks', 'animated', 'videos', 'thumb', 'software',)
    CONSTRUCTOR_ID = 0x9021ab67
    SUBCLASS_OF_ID = 0x9b704a5a

    user_id: 'TypeInputUser'
    title: str
    short_name: str
    stickers: List['TypeInputStickerSetItem']
    masks: Optional[bool]
    animated: Optional[bool]
    videos: Optional[bool]
    thumb: Optional['TypeInputDocument']
    software: Optional[str]
    def __init__(self, user_id: 'TypeInputUser', title: str, short_name: str, stickers: List['TypeInputStickerSetItem'], masks: Optional[bool]=None, animated: Optional[bool]=None, videos: Optional[bool]=None, thumb: Optional['TypeInputDocument']=None, software: Optional[str]=None):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'short_name', short_name)
        object.__setattr__(self, 'stickers', stickers)
        object.__setattr__(self, 'masks', masks)
        object.__setattr__(self, 'animated', animated)
        object.__setattr__(self, 'videos', videos)
        object.__setattr__(self, 'thumb', thumb)
        object.__setattr__(self, 'software', software)

    async def _resolve(self, client, utils):
        r = {}
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        if self.thumb:
            r['thumb'] = utils.get_input_document(self.thumb)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'g\xab!\x90',
            struct.pack('<I', (0 if self.masks is None or self.masks is False else 1) | (0 if self.animated is None or self.animated is False else 2) | (0 if self.videos is None or self.videos is False else 16) | (0 if self.thumb is None or self.thumb is False else 4) | (0 if self.software is None or self.software is False else 8)),
            self.user_id._bytes(),
            self._serialize_bytes(self.title),
            self._serialize_bytes(self.short_name),
            b'' if self.thumb is None or self.thumb is False else (self.thumb._bytes()),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(x._bytes() for x in self.stickers),
            b'' if self.software is None or self.software is False else (self._serialize_bytes(self.software)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _masks = bool(flags & 1)
        _animated = bool(flags & 2)
        _videos = bool(flags & 16)
        _user_id = reader.tgread_object()
        _title = reader.tgread_string()
        _short_name = reader.tgread_string()
        if flags & 4:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        reader.read_int()
        _stickers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _stickers.append(_x)

        if flags & 8:
            _software = reader.tgread_string()
        else:
            _software = None
        return cls(user_id=_user_id, title=_title, short_name=_short_name, stickers=_stickers, masks=_masks, animated=_animated, videos=_videos, thumb=_thumb, software=_software)


@dataclasses.dataclass(init=False, frozen=True)
class RemoveStickerFromSet(TLRequest):
    """
    :returns messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
    """
    __slots__ = ('sticker',)
    CONSTRUCTOR_ID = 0xf7760f51
    SUBCLASS_OF_ID = 0x9b704a5a

    sticker: 'TypeInputDocument'
    def __init__(self, sticker: 'TypeInputDocument'):
        object.__setattr__(self, 'sticker', sticker)

    async def _resolve(self, client, utils):
        r = {}
        r['sticker'] = utils.get_input_document(self.sticker)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'Q\x0fv\xf7',
            self.sticker._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _sticker = reader.tgread_object()
        return cls(sticker=_sticker)


@dataclasses.dataclass(init=False, frozen=True)
class SetStickerSetThumb(TLRequest):
    """
    :returns messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
    """
    __slots__ = ('stickerset', 'thumb',)
    CONSTRUCTOR_ID = 0x9a364e30
    SUBCLASS_OF_ID = 0x9b704a5a

    stickerset: 'TypeInputStickerSet'
    thumb: 'TypeInputDocument'
    def __init__(self, stickerset: 'TypeInputStickerSet', thumb: 'TypeInputDocument'):
        object.__setattr__(self, 'stickerset', stickerset)
        object.__setattr__(self, 'thumb', thumb)

    async def _resolve(self, client, utils):
        r = {}
        r['thumb'] = utils.get_input_document(self.thumb)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'0N6\x9a',
            self.stickerset._bytes(),
            self.thumb._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        _thumb = reader.tgread_object()
        return cls(stickerset=_stickerset, thumb=_thumb)


@dataclasses.dataclass(init=False, frozen=True)
class SuggestShortName(TLRequest):
    """
    :returns stickers.SuggestedShortName: Instance of SuggestedShortName.
    """
    __slots__ = ('title',)
    CONSTRUCTOR_ID = 0x4dafc503
    SUBCLASS_OF_ID = 0xc44a4b21

    title: str
    def __init__(self, title: str):
        object.__setattr__(self, 'title', title)

    def _bytes(self):
        return b''.join((
            b'\x03\xc5\xafM',
            self._serialize_bytes(self.title),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _title = reader.tgread_string()
        return cls(title=_title)

