"""File generated by TLObjects' generator. All changes will be ERASED"""
from ..._misc.tlobject import TLObject, TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from .. import TypeInputChannel, TypeInputPeer



@dataclasses.dataclass(init=False, frozen=True)
class GetBroadcastStats(TLRequest):
    """
    :returns stats.BroadcastStats: Instance of BroadcastStats.
    """
    __slots__ = ('channel', 'dark',)
    CONSTRUCTOR_ID = 0xab42441a
    SUBCLASS_OF_ID = 0x7ff25428

    channel: 'TypeInputChannel'
    dark: Optional[bool]
    def __init__(self, channel: 'TypeInputChannel', dark: Optional[bool]=None):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'dark', dark)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x1aDB\xab',
            struct.pack('<I', (0 if self.dark is None or self.dark is False else 1)),
            self.channel._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _dark = bool(flags & 1)
        _channel = reader.tgread_object()
        return cls(channel=_channel, dark=_dark)


@dataclasses.dataclass(init=False, frozen=True)
class GetMegagroupStats(TLRequest):
    """
    :returns stats.MegagroupStats: Instance of MegagroupStats.
    """
    __slots__ = ('channel', 'dark',)
    CONSTRUCTOR_ID = 0xdcdf8607
    SUBCLASS_OF_ID = 0x5b59be8d

    channel: 'TypeInputChannel'
    dark: Optional[bool]
    def __init__(self, channel: 'TypeInputChannel', dark: Optional[bool]=None):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'dark', dark)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x07\x86\xdf\xdc',
            struct.pack('<I', (0 if self.dark is None or self.dark is False else 1)),
            self.channel._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _dark = bool(flags & 1)
        _channel = reader.tgread_object()
        return cls(channel=_channel, dark=_dark)


@dataclasses.dataclass(init=False, frozen=True)
class GetMessagePublicForwards(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('channel', 'msg_id', 'offset_rate', 'offset_peer', 'offset_id', 'limit',)
    CONSTRUCTOR_ID = 0x5630281b
    SUBCLASS_OF_ID = 0xd4b40b5e

    channel: 'TypeInputChannel'
    msg_id: int
    offset_rate: int
    offset_peer: 'TypeInputPeer'
    offset_id: int
    limit: int
    def __init__(self, channel: 'TypeInputChannel', msg_id: int, offset_rate: int, offset_peer: 'TypeInputPeer', offset_id: int, limit: int):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'offset_rate', offset_rate)
        object.__setattr__(self, 'offset_peer', offset_peer)
        object.__setattr__(self, 'offset_id', offset_id)
        object.__setattr__(self, 'limit', limit)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        r['offset_peer'] = utils.get_input_peer(await client._get_input_peer(self.offset_peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x1b(0V',
            self.channel._bytes(),
            struct.pack('<i', self.msg_id),
            struct.pack('<i', self.offset_rate),
            self.offset_peer._bytes(),
            struct.pack('<i', self.offset_id),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _msg_id = reader.read_int()
        _offset_rate = reader.read_int()
        _offset_peer = reader.tgread_object()
        _offset_id = reader.read_int()
        _limit = reader.read_int()
        return cls(channel=_channel, msg_id=_msg_id, offset_rate=_offset_rate, offset_peer=_offset_peer, offset_id=_offset_id, limit=_limit)


@dataclasses.dataclass(init=False, frozen=True)
class GetMessageStats(TLRequest):
    """
    :returns stats.MessageStats: Instance of MessageStats.
    """
    __slots__ = ('channel', 'msg_id', 'dark',)
    CONSTRUCTOR_ID = 0xb6e0a3f5
    SUBCLASS_OF_ID = 0x9604a322

    channel: 'TypeInputChannel'
    msg_id: int
    dark: Optional[bool]
    def __init__(self, channel: 'TypeInputChannel', msg_id: int, dark: Optional[bool]=None):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'dark', dark)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xf5\xa3\xe0\xb6',
            struct.pack('<I', (0 if self.dark is None or self.dark is False else 1)),
            self.channel._bytes(),
            struct.pack('<i', self.msg_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _dark = bool(flags & 1)
        _channel = reader.tgread_object()
        _msg_id = reader.read_int()
        return cls(channel=_channel, msg_id=_msg_id, dark=_dark)


@dataclasses.dataclass(init=False, frozen=True)
class LoadAsyncGraph(TLRequest):
    """
    :returns StatsGraph: Instance of either StatsGraphAsync, StatsGraphError, StatsGraph.
    """
    __slots__ = ('token', 'x',)
    CONSTRUCTOR_ID = 0x621d5fa0
    SUBCLASS_OF_ID = 0x9b903153

    token: str
    x: Optional[int]
    def __init__(self, token: str, x: Optional[int]=None):
        object.__setattr__(self, 'token', token)
        object.__setattr__(self, 'x', x)

    def _bytes(self):
        return b''.join((
            b'\xa0_\x1db',
            struct.pack('<I', (0 if self.x is None or self.x is False else 1)),
            self._serialize_bytes(self.token),
            b'' if self.x is None or self.x is False else (struct.pack('<q', self.x)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _token = reader.tgread_string()
        if flags & 1:
            _x = reader.read_long()
        else:
            _x = None
        return cls(token=_token, x=_x)

