"""File generated by TLObjects' generator. All changes will be ERASED"""
from ..._misc.tlobject import TLObject, TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from .. import TypeInputFile, TypeInputPhoto, TypeInputUser



@dataclasses.dataclass(init=False, frozen=True)
class DeletePhotos(TLRequest):
    """
    :returns Vector<long>: This type has no constructors.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x87cf7f2f
    SUBCLASS_OF_ID = 0x8918e168

    id: List['TypeInputPhoto']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: List['TypeInputPhoto']):
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['id'] = []
        for x in self.id:
            r['id'].append(utils.get_input_photo(x))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'/\x7f\xcf\x87',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(x._bytes() for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _id.append(_x)

        return cls(id=_id)

    @staticmethod
    def _read_result(reader):
        reader.read_int()  # Vector ID
        return [reader.read_long() for _ in range(reader.read_int())]


@dataclasses.dataclass(init=False, frozen=True)
class GetUserPhotos(TLRequest):
    """
    :returns photos.Photos: Instance of either Photos, PhotosSlice.
    """
    __slots__ = ('user_id', 'offset', 'max_id', 'limit',)
    CONSTRUCTOR_ID = 0x91cd32a8
    SUBCLASS_OF_ID = 0x27cfb967

    user_id: 'TypeInputUser'
    offset: int
    max_id: int
    limit: int
    def __init__(self, user_id: 'TypeInputUser', offset: int, max_id: int, limit: int):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'max_id', max_id)
        object.__setattr__(self, 'limit', limit)

    async def _resolve(self, client, utils):
        r = {}
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xa82\xcd\x91',
            self.user_id._bytes(),
            struct.pack('<i', self.offset),
            struct.pack('<q', self.max_id),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.tgread_object()
        _offset = reader.read_int()
        _max_id = reader.read_long()
        _limit = reader.read_int()
        return cls(user_id=_user_id, offset=_offset, max_id=_max_id, limit=_limit)


@dataclasses.dataclass(init=False, frozen=True)
class UpdateProfilePhoto(TLRequest):
    """
    :returns photos.Photo: Instance of Photo.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x72d4742c
    SUBCLASS_OF_ID = 0xc292bd24

    id: 'TypeInputPhoto'
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputPhoto'):
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['id'] = utils.get_input_photo(self.id)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b',t\xd4r',
            self.id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class UploadProfilePhoto(TLRequest):
    """
    :returns photos.Photo: Instance of Photo.
    """
    __slots__ = ('file', 'video', 'video_start_ts',)
    CONSTRUCTOR_ID = 0x89f30f69
    SUBCLASS_OF_ID = 0xc292bd24

    file: Optional['TypeInputFile']
    video: Optional['TypeInputFile']
    video_start_ts: Optional[float]
    def __init__(self, file: Optional['TypeInputFile']=None, video: Optional['TypeInputFile']=None, video_start_ts: Optional[float]=None):
        object.__setattr__(self, 'file', file)
        object.__setattr__(self, 'video', video)
        object.__setattr__(self, 'video_start_ts', video_start_ts)

    def _bytes(self):
        return b''.join((
            b'i\x0f\xf3\x89',
            struct.pack('<I', (0 if self.file is None or self.file is False else 1) | (0 if self.video is None or self.video is False else 2) | (0 if self.video_start_ts is None or self.video_start_ts is False else 4)),
            b'' if self.file is None or self.file is False else (self.file._bytes()),
            b'' if self.video is None or self.video is False else (self.video._bytes()),
            b'' if self.video_start_ts is None or self.video_start_ts is False else (struct.pack('<d', self.video_start_ts)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _file = reader.tgread_object()
        else:
            _file = None
        if flags & 2:
            _video = reader.tgread_object()
        else:
            _video = None
        if flags & 4:
            _video_start_ts = reader.read_double()
        else:
            _video_start_ts = None
        return cls(file=_file, video=_video, video_start_ts=_video_start_ts)

