"""File generated by TLObjects' generator. All changes will be ERASED"""
from ..._misc.tlobject import TLObject, TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from .. import TypeDataJSON, TypeInputGroupCall, TypeInputPeer, TypeInputPhoneCall, TypeInputUser, TypePhoneCallDiscardReason, TypePhoneCallProtocol



@dataclasses.dataclass(init=False, frozen=True)
class AcceptCall(TLRequest):
    """
    :returns phone.PhoneCall: Instance of PhoneCall.
    """
    __slots__ = ('peer', 'g_b', 'protocol',)
    CONSTRUCTOR_ID = 0x3bd2b4a0
    SUBCLASS_OF_ID = 0xd48afe4f

    peer: 'TypeInputPhoneCall'
    g_b: bytes
    protocol: 'TypePhoneCallProtocol'
    def __init__(self, peer: 'TypeInputPhoneCall', g_b: bytes, protocol: 'TypePhoneCallProtocol'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'g_b', g_b)
        object.__setattr__(self, 'protocol', protocol)

    def _bytes(self):
        return b''.join((
            b'\xa0\xb4\xd2;',
            self.peer._bytes(),
            self._serialize_bytes(self.g_b),
            self.protocol._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _g_b = reader.tgread_bytes()
        _protocol = reader.tgread_object()
        return cls(peer=_peer, g_b=_g_b, protocol=_protocol)


@dataclasses.dataclass(init=False, frozen=True)
class CheckGroupCall(TLRequest):
    """
    :returns Vector<int>: This type has no constructors.
    """
    __slots__ = ('call', 'sources',)
    CONSTRUCTOR_ID = 0xb59cf977
    SUBCLASS_OF_ID = 0x5026710f

    call: 'TypeInputGroupCall'
    sources: List[int]
    def __init__(self, call: 'TypeInputGroupCall', sources: List[int]):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'sources', sources)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'w\xf9\x9c\xb5',
            self.call._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sources)),b''.join(struct.pack('<i', x) for x in self.sources),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        reader.read_int()
        _sources = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _sources.append(_x)

        return cls(call=_call, sources=_sources)

    @staticmethod
    def _read_result(reader):
        reader.read_int()  # Vector ID
        return [reader.read_int() for _ in range(reader.read_int())]


@dataclasses.dataclass(init=False, frozen=True)
class ConfirmCall(TLRequest):
    """
    :returns phone.PhoneCall: Instance of PhoneCall.
    """
    __slots__ = ('peer', 'g_a', 'key_fingerprint', 'protocol',)
    CONSTRUCTOR_ID = 0x2efe1722
    SUBCLASS_OF_ID = 0xd48afe4f

    peer: 'TypeInputPhoneCall'
    g_a: bytes
    key_fingerprint: int
    protocol: 'TypePhoneCallProtocol'
    def __init__(self, peer: 'TypeInputPhoneCall', g_a: bytes, key_fingerprint: int, protocol: 'TypePhoneCallProtocol'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'g_a', g_a)
        object.__setattr__(self, 'key_fingerprint', key_fingerprint)
        object.__setattr__(self, 'protocol', protocol)

    def _bytes(self):
        return b''.join((
            b'"\x17\xfe.',
            self.peer._bytes(),
            self._serialize_bytes(self.g_a),
            struct.pack('<q', self.key_fingerprint),
            self.protocol._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _g_a = reader.tgread_bytes()
        _key_fingerprint = reader.read_long()
        _protocol = reader.tgread_object()
        return cls(peer=_peer, g_a=_g_a, key_fingerprint=_key_fingerprint, protocol=_protocol)


@dataclasses.dataclass(init=False, frozen=True)
class CreateGroupCall(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'rtmp_stream', 'random_id', 'title', 'schedule_date',)
    CONSTRUCTOR_ID = 0x48cdc6d8
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    rtmp_stream: Optional[bool]
    random_id: int
    title: Optional[str]
    schedule_date: Optional[datetime]
    def __init__(self, peer: 'TypeInputPeer', rtmp_stream: Optional[bool]=None, random_id: int=None, title: Optional[str]=None, schedule_date: Optional[datetime]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'rtmp_stream', rtmp_stream)
        object.__setattr__(self, 'random_id', random_id)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'schedule_date', schedule_date)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        if self.random_id is None:
            r['random_id'] = int.from_bytes(os.urandom(4), 'big', signed=True)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xd8\xc6\xcdH',
            struct.pack('<I', (0 if self.rtmp_stream is None or self.rtmp_stream is False else 4) | (0 if self.title is None or self.title is False else 1) | (0 if self.schedule_date is None or self.schedule_date is False else 2)),
            self.peer._bytes(),
            struct.pack('<i', self.random_id),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
            b'' if self.schedule_date is None or self.schedule_date is False else (self._serialize_datetime(self.schedule_date)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _rtmp_stream = bool(flags & 4)
        _peer = reader.tgread_object()
        _random_id = reader.read_int()
        if flags & 1:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 2:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        return cls(peer=_peer, rtmp_stream=_rtmp_stream, random_id=_random_id, title=_title, schedule_date=_schedule_date)


@dataclasses.dataclass(init=False, frozen=True)
class DiscardCall(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'duration', 'reason', 'connection_id', 'video',)
    CONSTRUCTOR_ID = 0xb2cbc1c0
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPhoneCall'
    duration: int
    reason: 'TypePhoneCallDiscardReason'
    connection_id: int
    video: Optional[bool]
    def __init__(self, peer: 'TypeInputPhoneCall', duration: int, reason: 'TypePhoneCallDiscardReason', connection_id: int, video: Optional[bool]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'duration', duration)
        object.__setattr__(self, 'reason', reason)
        object.__setattr__(self, 'connection_id', connection_id)
        object.__setattr__(self, 'video', video)

    def _bytes(self):
        return b''.join((
            b'\xc0\xc1\xcb\xb2',
            struct.pack('<I', (0 if self.video is None or self.video is False else 1)),
            self.peer._bytes(),
            struct.pack('<i', self.duration),
            self.reason._bytes(),
            struct.pack('<q', self.connection_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 1)
        _peer = reader.tgread_object()
        _duration = reader.read_int()
        _reason = reader.tgread_object()
        _connection_id = reader.read_long()
        return cls(peer=_peer, duration=_duration, reason=_reason, connection_id=_connection_id, video=_video)


@dataclasses.dataclass(init=False, frozen=True)
class DiscardGroupCall(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('call',)
    CONSTRUCTOR_ID = 0x7a777135
    SUBCLASS_OF_ID = 0x8af52aac

    call: 'TypeInputGroupCall'
    def __init__(self, call: 'TypeInputGroupCall'):
        object.__setattr__(self, 'call', call)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'5qwz',
            self.call._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        return cls(call=_call)


@dataclasses.dataclass(init=False, frozen=True)
class EditGroupCallParticipant(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('call', 'participant', 'muted', 'volume', 'raise_hand', 'video_stopped', 'video_paused', 'presentation_paused',)
    CONSTRUCTOR_ID = 0xa5273abf
    SUBCLASS_OF_ID = 0x8af52aac

    call: 'TypeInputGroupCall'
    participant: 'TypeInputPeer'
    muted: Optional[bool]
    volume: Optional[int]
    raise_hand: Optional[bool]
    video_stopped: Optional[bool]
    video_paused: Optional[bool]
    presentation_paused: Optional[bool]
    def __init__(self, call: 'TypeInputGroupCall', participant: 'TypeInputPeer', muted: Optional[bool]=None, volume: Optional[int]=None, raise_hand: Optional[bool]=None, video_stopped: Optional[bool]=None, video_paused: Optional[bool]=None, presentation_paused: Optional[bool]=None):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'participant', participant)
        object.__setattr__(self, 'muted', muted)
        object.__setattr__(self, 'volume', volume)
        object.__setattr__(self, 'raise_hand', raise_hand)
        object.__setattr__(self, 'video_stopped', video_stopped)
        object.__setattr__(self, 'video_paused', video_paused)
        object.__setattr__(self, 'presentation_paused', presentation_paused)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        r['participant'] = utils.get_input_peer(await client._get_input_peer(self.participant))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b"\xbf:'\xa5",
            struct.pack('<I', (0 if self.muted is None else 1) | (0 if self.volume is None or self.volume is False else 2) | (0 if self.raise_hand is None else 4) | (0 if self.video_stopped is None else 8) | (0 if self.video_paused is None else 16) | (0 if self.presentation_paused is None else 32)),
            self.call._bytes(),
            self.participant._bytes(),
            b'' if self.muted is None else (b'\xb5ur\x99' if self.muted else b'7\x97y\xbc'),
            b'' if self.volume is None or self.volume is False else (struct.pack('<i', self.volume)),
            b'' if self.raise_hand is None else (b'\xb5ur\x99' if self.raise_hand else b'7\x97y\xbc'),
            b'' if self.video_stopped is None else (b'\xb5ur\x99' if self.video_stopped else b'7\x97y\xbc'),
            b'' if self.video_paused is None else (b'\xb5ur\x99' if self.video_paused else b'7\x97y\xbc'),
            b'' if self.presentation_paused is None else (b'\xb5ur\x99' if self.presentation_paused else b'7\x97y\xbc'),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _call = reader.tgread_object()
        _participant = reader.tgread_object()
        if flags & 1:
            _muted = reader.tgread_bool()
        else:
            _muted = None
        if flags & 2:
            _volume = reader.read_int()
        else:
            _volume = None
        if flags & 4:
            _raise_hand = reader.tgread_bool()
        else:
            _raise_hand = None
        if flags & 8:
            _video_stopped = reader.tgread_bool()
        else:
            _video_stopped = None
        if flags & 16:
            _video_paused = reader.tgread_bool()
        else:
            _video_paused = None
        if flags & 32:
            _presentation_paused = reader.tgread_bool()
        else:
            _presentation_paused = None
        return cls(call=_call, participant=_participant, muted=_muted, volume=_volume, raise_hand=_raise_hand, video_stopped=_video_stopped, video_paused=_video_paused, presentation_paused=_presentation_paused)


@dataclasses.dataclass(init=False, frozen=True)
class EditGroupCallTitle(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('call', 'title',)
    CONSTRUCTOR_ID = 0x1ca6ac0a
    SUBCLASS_OF_ID = 0x8af52aac

    call: 'TypeInputGroupCall'
    title: str
    def __init__(self, call: 'TypeInputGroupCall', title: str):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'title', title)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\n\xac\xa6\x1c',
            self.call._bytes(),
            self._serialize_bytes(self.title),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        _title = reader.tgread_string()
        return cls(call=_call, title=_title)


@dataclasses.dataclass(init=False, frozen=True)
class ExportGroupCallInvite(TLRequest):
    """
    :returns phone.ExportedGroupCallInvite: Instance of ExportedGroupCallInvite.
    """
    __slots__ = ('call', 'can_self_unmute',)
    CONSTRUCTOR_ID = 0xe6aa647f
    SUBCLASS_OF_ID = 0x3b3bfe8f

    call: 'TypeInputGroupCall'
    can_self_unmute: Optional[bool]
    def __init__(self, call: 'TypeInputGroupCall', can_self_unmute: Optional[bool]=None):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'can_self_unmute', can_self_unmute)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x7fd\xaa\xe6',
            struct.pack('<I', (0 if self.can_self_unmute is None or self.can_self_unmute is False else 1)),
            self.call._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _can_self_unmute = bool(flags & 1)
        _call = reader.tgread_object()
        return cls(call=_call, can_self_unmute=_can_self_unmute)


@dataclasses.dataclass(init=False, frozen=True)
class GetCallConfig(TLRequest):
    """
    :returns DataJSON: Instance of DataJSON.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x55451fa9
    SUBCLASS_OF_ID = 0xad0352e8

    def _bytes(self):
        return b''.join((
            b'\xa9\x1fEU',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetGroupCall(TLRequest):
    """
    :returns phone.GroupCall: Instance of GroupCall.
    """
    __slots__ = ('call', 'limit',)
    CONSTRUCTOR_ID = 0x41845db
    SUBCLASS_OF_ID = 0x304116be

    call: 'TypeInputGroupCall'
    limit: int
    def __init__(self, call: 'TypeInputGroupCall', limit: int):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'limit', limit)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xdbE\x18\x04',
            self.call._bytes(),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        _limit = reader.read_int()
        return cls(call=_call, limit=_limit)


@dataclasses.dataclass(init=False, frozen=True)
class GetGroupCallJoinAs(TLRequest):
    """
    :returns phone.JoinAsPeers: Instance of JoinAsPeers.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0xef7c213a
    SUBCLASS_OF_ID = 0xb4b770fb

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b':!|\xef',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class GetGroupCallStreamChannels(TLRequest):
    """
    :returns phone.GroupCallStreamChannels: Instance of GroupCallStreamChannels.
    """
    __slots__ = ('call',)
    CONSTRUCTOR_ID = 0x1ab21940
    SUBCLASS_OF_ID = 0x9157c5e4

    call: 'TypeInputGroupCall'
    def __init__(self, call: 'TypeInputGroupCall'):
        object.__setattr__(self, 'call', call)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'@\x19\xb2\x1a',
            self.call._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        return cls(call=_call)


@dataclasses.dataclass(init=False, frozen=True)
class GetGroupCallStreamRtmpUrl(TLRequest):
    """
    :returns phone.GroupCallStreamRtmpUrl: Instance of GroupCallStreamRtmpUrl.
    """
    __slots__ = ('peer', 'revoke',)
    CONSTRUCTOR_ID = 0xdeb3abbf
    SUBCLASS_OF_ID = 0xd1f515cb

    peer: 'TypeInputPeer'
    revoke: bool
    def __init__(self, peer: 'TypeInputPeer', revoke: bool):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'revoke', revoke)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xbf\xab\xb3\xde',
            self.peer._bytes(),
            b'\xb5ur\x99' if self.revoke else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _revoke = reader.tgread_bool()
        return cls(peer=_peer, revoke=_revoke)


@dataclasses.dataclass(init=False, frozen=True)
class GetGroupParticipants(TLRequest):
    """
    :returns phone.GroupParticipants: Instance of GroupParticipants.
    """
    __slots__ = ('call', 'ids', 'sources', 'offset', 'limit',)
    CONSTRUCTOR_ID = 0xc558d8ab
    SUBCLASS_OF_ID = 0x72d304f4

    call: 'TypeInputGroupCall'
    ids: List['TypeInputPeer']
    sources: List[int]
    offset: str
    limit: int
    def __init__(self, call: 'TypeInputGroupCall', ids: List['TypeInputPeer'], sources: List[int], offset: str, limit: int):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'ids', ids)
        object.__setattr__(self, 'sources', sources)
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'limit', limit)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        r['ids'] = []
        for x in self.ids:
            r['ids'].append(utils.get_input_peer(await client._get_input_peer(x)))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xab\xd8X\xc5',
            self.call._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.ids)),b''.join(x._bytes() for x in self.ids),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sources)),b''.join(struct.pack('<i', x) for x in self.sources),
            self._serialize_bytes(self.offset),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        reader.read_int()
        _ids = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _ids.append(_x)

        reader.read_int()
        _sources = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _sources.append(_x)

        _offset = reader.tgread_string()
        _limit = reader.read_int()
        return cls(call=_call, ids=_ids, sources=_sources, offset=_offset, limit=_limit)


@dataclasses.dataclass(init=False, frozen=True)
class InviteToGroupCall(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('call', 'users',)
    CONSTRUCTOR_ID = 0x7b393160
    SUBCLASS_OF_ID = 0x8af52aac

    call: 'TypeInputGroupCall'
    users: List['TypeInputUser']
    def __init__(self, call: 'TypeInputGroupCall', users: List['TypeInputUser']):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'users', users)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        r['users'] = []
        for x in self.users:
            r['users'].append(utils.get_input_user(await client._get_input_peer(x)))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'`19{',
            self.call._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(call=_call, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class JoinGroupCall(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('call', 'join_as', 'params', 'muted', 'video_stopped', 'invite_hash',)
    CONSTRUCTOR_ID = 0xb132ff7b
    SUBCLASS_OF_ID = 0x8af52aac

    call: 'TypeInputGroupCall'
    join_as: 'TypeInputPeer'
    params: 'TypeDataJSON'
    muted: Optional[bool]
    video_stopped: Optional[bool]
    invite_hash: Optional[str]
    def __init__(self, call: 'TypeInputGroupCall', join_as: 'TypeInputPeer', params: 'TypeDataJSON', muted: Optional[bool]=None, video_stopped: Optional[bool]=None, invite_hash: Optional[str]=None):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'join_as', join_as)
        object.__setattr__(self, 'params', params)
        object.__setattr__(self, 'muted', muted)
        object.__setattr__(self, 'video_stopped', video_stopped)
        object.__setattr__(self, 'invite_hash', invite_hash)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        r['join_as'] = utils.get_input_peer(await client._get_input_peer(self.join_as))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'{\xff2\xb1',
            struct.pack('<I', (0 if self.muted is None or self.muted is False else 1) | (0 if self.video_stopped is None or self.video_stopped is False else 4) | (0 if self.invite_hash is None or self.invite_hash is False else 2)),
            self.call._bytes(),
            self.join_as._bytes(),
            b'' if self.invite_hash is None or self.invite_hash is False else (self._serialize_bytes(self.invite_hash)),
            self.params._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _muted = bool(flags & 1)
        _video_stopped = bool(flags & 4)
        _call = reader.tgread_object()
        _join_as = reader.tgread_object()
        if flags & 2:
            _invite_hash = reader.tgread_string()
        else:
            _invite_hash = None
        _params = reader.tgread_object()
        return cls(call=_call, join_as=_join_as, params=_params, muted=_muted, video_stopped=_video_stopped, invite_hash=_invite_hash)


@dataclasses.dataclass(init=False, frozen=True)
class JoinGroupCallPresentation(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('call', 'params',)
    CONSTRUCTOR_ID = 0xcbea6bc4
    SUBCLASS_OF_ID = 0x8af52aac

    call: 'TypeInputGroupCall'
    params: 'TypeDataJSON'
    def __init__(self, call: 'TypeInputGroupCall', params: 'TypeDataJSON'):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'params', params)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xc4k\xea\xcb',
            self.call._bytes(),
            self.params._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        _params = reader.tgread_object()
        return cls(call=_call, params=_params)


@dataclasses.dataclass(init=False, frozen=True)
class LeaveGroupCall(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('call', 'source',)
    CONSTRUCTOR_ID = 0x500377f9
    SUBCLASS_OF_ID = 0x8af52aac

    call: 'TypeInputGroupCall'
    source: int
    def __init__(self, call: 'TypeInputGroupCall', source: int):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'source', source)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xf9w\x03P',
            self.call._bytes(),
            struct.pack('<i', self.source),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        _source = reader.read_int()
        return cls(call=_call, source=_source)


@dataclasses.dataclass(init=False, frozen=True)
class LeaveGroupCallPresentation(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('call',)
    CONSTRUCTOR_ID = 0x1c50d144
    SUBCLASS_OF_ID = 0x8af52aac

    call: 'TypeInputGroupCall'
    def __init__(self, call: 'TypeInputGroupCall'):
        object.__setattr__(self, 'call', call)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'D\xd1P\x1c',
            self.call._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        return cls(call=_call)


@dataclasses.dataclass(init=False, frozen=True)
class ReceivedCall(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0x17d54f61
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPhoneCall'
    def __init__(self, peer: 'TypeInputPhoneCall'):
        object.__setattr__(self, 'peer', peer)

    def _bytes(self):
        return b''.join((
            b'aO\xd5\x17',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class RequestCall(TLRequest):
    """
    :returns phone.PhoneCall: Instance of PhoneCall.
    """
    __slots__ = ('user_id', 'g_a_hash', 'protocol', 'video', 'random_id',)
    CONSTRUCTOR_ID = 0x42ff96ed
    SUBCLASS_OF_ID = 0xd48afe4f

    user_id: 'TypeInputUser'
    g_a_hash: bytes
    protocol: 'TypePhoneCallProtocol'
    video: Optional[bool]
    random_id: int
    def __init__(self, user_id: 'TypeInputUser', g_a_hash: bytes, protocol: 'TypePhoneCallProtocol', video: Optional[bool]=None, random_id: int=None):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'g_a_hash', g_a_hash)
        object.__setattr__(self, 'protocol', protocol)
        object.__setattr__(self, 'video', video)
        object.__setattr__(self, 'random_id', random_id)

    async def _resolve(self, client, utils):
        r = {}
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        if self.random_id is None:
            r['random_id'] = int.from_bytes(os.urandom(4), 'big', signed=True)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xed\x96\xffB',
            struct.pack('<I', (0 if self.video is None or self.video is False else 1)),
            self.user_id._bytes(),
            struct.pack('<i', self.random_id),
            self._serialize_bytes(self.g_a_hash),
            self.protocol._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 1)
        _user_id = reader.tgread_object()
        _random_id = reader.read_int()
        _g_a_hash = reader.tgread_bytes()
        _protocol = reader.tgread_object()
        return cls(user_id=_user_id, g_a_hash=_g_a_hash, protocol=_protocol, video=_video, random_id=_random_id)


@dataclasses.dataclass(init=False, frozen=True)
class SaveCallDebug(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'debug',)
    CONSTRUCTOR_ID = 0x277add7e
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPhoneCall'
    debug: 'TypeDataJSON'
    def __init__(self, peer: 'TypeInputPhoneCall', debug: 'TypeDataJSON'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'debug', debug)

    def _bytes(self):
        return b''.join((
            b"~\xddz'",
            self.peer._bytes(),
            self.debug._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _debug = reader.tgread_object()
        return cls(peer=_peer, debug=_debug)


@dataclasses.dataclass(init=False, frozen=True)
class SaveDefaultGroupCallJoinAs(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'join_as',)
    CONSTRUCTOR_ID = 0x575e1f8c
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    join_as: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer', join_as: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'join_as', join_as)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        r['join_as'] = utils.get_input_peer(await client._get_input_peer(self.join_as))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x8c\x1f^W',
            self.peer._bytes(),
            self.join_as._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _join_as = reader.tgread_object()
        return cls(peer=_peer, join_as=_join_as)


@dataclasses.dataclass(init=False, frozen=True)
class SendSignalingData(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'data',)
    CONSTRUCTOR_ID = 0xff7a9383
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPhoneCall'
    data: bytes
    def __init__(self, peer: 'TypeInputPhoneCall', data: bytes):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'data', data)

    def _bytes(self):
        return b''.join((
            b'\x83\x93z\xff',
            self.peer._bytes(),
            self._serialize_bytes(self.data),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _data = reader.tgread_bytes()
        return cls(peer=_peer, data=_data)


@dataclasses.dataclass(init=False, frozen=True)
class SetCallRating(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'rating', 'comment', 'user_initiative',)
    CONSTRUCTOR_ID = 0x59ead627
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPhoneCall'
    rating: int
    comment: str
    user_initiative: Optional[bool]
    def __init__(self, peer: 'TypeInputPhoneCall', rating: int, comment: str, user_initiative: Optional[bool]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'rating', rating)
        object.__setattr__(self, 'comment', comment)
        object.__setattr__(self, 'user_initiative', user_initiative)

    def _bytes(self):
        return b''.join((
            b"'\xd6\xeaY",
            struct.pack('<I', (0 if self.user_initiative is None or self.user_initiative is False else 1)),
            self.peer._bytes(),
            struct.pack('<i', self.rating),
            self._serialize_bytes(self.comment),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _user_initiative = bool(flags & 1)
        _peer = reader.tgread_object()
        _rating = reader.read_int()
        _comment = reader.tgread_string()
        return cls(peer=_peer, rating=_rating, comment=_comment, user_initiative=_user_initiative)


@dataclasses.dataclass(init=False, frozen=True)
class StartScheduledGroupCall(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('call',)
    CONSTRUCTOR_ID = 0x5680e342
    SUBCLASS_OF_ID = 0x8af52aac

    call: 'TypeInputGroupCall'
    def __init__(self, call: 'TypeInputGroupCall'):
        object.__setattr__(self, 'call', call)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'B\xe3\x80V',
            self.call._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        return cls(call=_call)


@dataclasses.dataclass(init=False, frozen=True)
class ToggleGroupCallRecord(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('call', 'start', 'video', 'title', 'video_portrait',)
    CONSTRUCTOR_ID = 0xf128c708
    SUBCLASS_OF_ID = 0x8af52aac

    call: 'TypeInputGroupCall'
    start: Optional[bool]
    video: Optional[bool]
    title: Optional[str]
    video_portrait: Optional[bool]
    def __init__(self, call: 'TypeInputGroupCall', start: Optional[bool]=None, video: Optional[bool]=None, title: Optional[str]=None, video_portrait: Optional[bool]=None):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'start', start)
        object.__setattr__(self, 'video', video)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'video_portrait', video_portrait)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        assert ((self.video or self.video is not None) and (self.video_portrait or self.video_portrait is not None)) or ((self.video is None or self.video is False) and (self.video_portrait is None or self.video_portrait is False)), 'video, video_portrait parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\x08\xc7(\xf1',
            struct.pack('<I', (0 if self.start is None or self.start is False else 1) | (0 if self.video is None or self.video is False else 4) | (0 if self.title is None or self.title is False else 2) | (0 if self.video_portrait is None else 4)),
            self.call._bytes(),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
            b'' if self.video_portrait is None else (b'\xb5ur\x99' if self.video_portrait else b'7\x97y\xbc'),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _start = bool(flags & 1)
        _video = bool(flags & 4)
        _call = reader.tgread_object()
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 4:
            _video_portrait = reader.tgread_bool()
        else:
            _video_portrait = None
        return cls(call=_call, start=_start, video=_video, title=_title, video_portrait=_video_portrait)


@dataclasses.dataclass(init=False, frozen=True)
class ToggleGroupCallSettings(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('call', 'reset_invite_hash', 'join_muted',)
    CONSTRUCTOR_ID = 0x74bbb43d
    SUBCLASS_OF_ID = 0x8af52aac

    call: 'TypeInputGroupCall'
    reset_invite_hash: Optional[bool]
    join_muted: Optional[bool]
    def __init__(self, call: 'TypeInputGroupCall', reset_invite_hash: Optional[bool]=None, join_muted: Optional[bool]=None):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'reset_invite_hash', reset_invite_hash)
        object.__setattr__(self, 'join_muted', join_muted)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'=\xb4\xbbt',
            struct.pack('<I', (0 if self.reset_invite_hash is None or self.reset_invite_hash is False else 2) | (0 if self.join_muted is None else 1)),
            self.call._bytes(),
            b'' if self.join_muted is None else (b'\xb5ur\x99' if self.join_muted else b'7\x97y\xbc'),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _reset_invite_hash = bool(flags & 2)
        _call = reader.tgread_object()
        if flags & 1:
            _join_muted = reader.tgread_bool()
        else:
            _join_muted = None
        return cls(call=_call, reset_invite_hash=_reset_invite_hash, join_muted=_join_muted)


@dataclasses.dataclass(init=False, frozen=True)
class ToggleGroupCallStartSubscription(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('call', 'subscribed',)
    CONSTRUCTOR_ID = 0x219c34e6
    SUBCLASS_OF_ID = 0x8af52aac

    call: 'TypeInputGroupCall'
    subscribed: bool
    def __init__(self, call: 'TypeInputGroupCall', subscribed: bool):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'subscribed', subscribed)

    async def _resolve(self, client, utils):
        r = {}
        r['call'] = utils.get_input_group_call(self.call)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xe64\x9c!',
            self.call._bytes(),
            b'\xb5ur\x99' if self.subscribed else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        _subscribed = reader.tgread_bool()
        return cls(call=_call, subscribed=_subscribed)

