"""File generated by TLObjects' generator. All changes will be ERASED"""
from ..._misc.tlobject import TLObject, TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from .. import TypeDataJSON, TypeInputPaymentCredentials, TypeInputPeer, TypePaymentRequestedInfo



@dataclasses.dataclass(init=False, frozen=True)
class ClearSavedInfo(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('credentials', 'info',)
    CONSTRUCTOR_ID = 0xd83d70c1
    SUBCLASS_OF_ID = 0xf5b399ac

    credentials: Optional[bool]
    info: Optional[bool]
    def __init__(self, credentials: Optional[bool]=None, info: Optional[bool]=None):
        object.__setattr__(self, 'credentials', credentials)
        object.__setattr__(self, 'info', info)

    def _bytes(self):
        return b''.join((
            b'\xc1p=\xd8',
            struct.pack('<I', (0 if self.credentials is None or self.credentials is False else 1) | (0 if self.info is None or self.info is False else 2)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _credentials = bool(flags & 1)
        _info = bool(flags & 2)
        return cls(credentials=_credentials, info=_info)


@dataclasses.dataclass(init=False, frozen=True)
class GetBankCardData(TLRequest):
    """
    :returns payments.BankCardData: Instance of BankCardData.
    """
    __slots__ = ('number',)
    CONSTRUCTOR_ID = 0x2e79d779
    SUBCLASS_OF_ID = 0x8c6dd68b

    number: str
    def __init__(self, number: str):
        object.__setattr__(self, 'number', number)

    def _bytes(self):
        return b''.join((
            b'y\xd7y.',
            self._serialize_bytes(self.number),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _number = reader.tgread_string()
        return cls(number=_number)


@dataclasses.dataclass(init=False, frozen=True)
class GetPaymentForm(TLRequest):
    """
    :returns payments.PaymentForm: Instance of PaymentForm.
    """
    __slots__ = ('peer', 'msg_id', 'theme_params',)
    CONSTRUCTOR_ID = 0x8a333c8d
    SUBCLASS_OF_ID = 0xa0483f19

    peer: 'TypeInputPeer'
    msg_id: int
    theme_params: Optional['TypeDataJSON']
    def __init__(self, peer: 'TypeInputPeer', msg_id: int, theme_params: Optional['TypeDataJSON']=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'theme_params', theme_params)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x8d<3\x8a',
            struct.pack('<I', (0 if self.theme_params is None or self.theme_params is False else 1)),
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            b'' if self.theme_params is None or self.theme_params is False else (self.theme_params._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        if flags & 1:
            _theme_params = reader.tgread_object()
        else:
            _theme_params = None
        return cls(peer=_peer, msg_id=_msg_id, theme_params=_theme_params)


@dataclasses.dataclass(init=False, frozen=True)
class GetPaymentReceipt(TLRequest):
    """
    :returns payments.PaymentReceipt: Instance of PaymentReceipt.
    """
    __slots__ = ('peer', 'msg_id',)
    CONSTRUCTOR_ID = 0x2478d1cc
    SUBCLASS_OF_ID = 0x590093c9

    peer: 'TypeInputPeer'
    msg_id: int
    def __init__(self, peer: 'TypeInputPeer', msg_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xcc\xd1x$',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetSavedInfo(TLRequest):
    """
    :returns payments.SavedInfo: Instance of SavedInfo.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x227d824b
    SUBCLASS_OF_ID = 0xad3cf146

    def _bytes(self):
        return b''.join((
            b'K\x82}"',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SendPaymentForm(TLRequest):
    """
    :returns payments.PaymentResult: Instance of either PaymentResult, PaymentVerificationNeeded.
    """
    __slots__ = ('form_id', 'peer', 'msg_id', 'credentials', 'requested_info_id', 'shipping_option_id', 'tip_amount',)
    CONSTRUCTOR_ID = 0x30c3bc9d
    SUBCLASS_OF_ID = 0x8ae16a9d

    form_id: int
    peer: 'TypeInputPeer'
    msg_id: int
    credentials: 'TypeInputPaymentCredentials'
    requested_info_id: Optional[str]
    shipping_option_id: Optional[str]
    tip_amount: Optional[int]
    def __init__(self, form_id: int, peer: 'TypeInputPeer', msg_id: int, credentials: 'TypeInputPaymentCredentials', requested_info_id: Optional[str]=None, shipping_option_id: Optional[str]=None, tip_amount: Optional[int]=None):
        object.__setattr__(self, 'form_id', form_id)
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'credentials', credentials)
        object.__setattr__(self, 'requested_info_id', requested_info_id)
        object.__setattr__(self, 'shipping_option_id', shipping_option_id)
        object.__setattr__(self, 'tip_amount', tip_amount)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x9d\xbc\xc30',
            struct.pack('<I', (0 if self.requested_info_id is None or self.requested_info_id is False else 1) | (0 if self.shipping_option_id is None or self.shipping_option_id is False else 2) | (0 if self.tip_amount is None or self.tip_amount is False else 4)),
            struct.pack('<q', self.form_id),
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            b'' if self.requested_info_id is None or self.requested_info_id is False else (self._serialize_bytes(self.requested_info_id)),
            b'' if self.shipping_option_id is None or self.shipping_option_id is False else (self._serialize_bytes(self.shipping_option_id)),
            self.credentials._bytes(),
            b'' if self.tip_amount is None or self.tip_amount is False else (struct.pack('<q', self.tip_amount)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _form_id = reader.read_long()
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        if flags & 1:
            _requested_info_id = reader.tgread_string()
        else:
            _requested_info_id = None
        if flags & 2:
            _shipping_option_id = reader.tgread_string()
        else:
            _shipping_option_id = None
        _credentials = reader.tgread_object()
        if flags & 4:
            _tip_amount = reader.read_long()
        else:
            _tip_amount = None
        return cls(form_id=_form_id, peer=_peer, msg_id=_msg_id, credentials=_credentials, requested_info_id=_requested_info_id, shipping_option_id=_shipping_option_id, tip_amount=_tip_amount)


@dataclasses.dataclass(init=False, frozen=True)
class ValidateRequestedInfo(TLRequest):
    """
    :returns payments.ValidatedRequestedInfo: Instance of ValidatedRequestedInfo.
    """
    __slots__ = ('peer', 'msg_id', 'info', 'save',)
    CONSTRUCTOR_ID = 0xdb103170
    SUBCLASS_OF_ID = 0x8f8044b7

    peer: 'TypeInputPeer'
    msg_id: int
    info: 'TypePaymentRequestedInfo'
    save: Optional[bool]
    def __init__(self, peer: 'TypeInputPeer', msg_id: int, info: 'TypePaymentRequestedInfo', save: Optional[bool]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'info', info)
        object.__setattr__(self, 'save', save)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'p1\x10\xdb',
            struct.pack('<I', (0 if self.save is None or self.save is False else 1)),
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            self.info._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _save = bool(flags & 1)
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _info = reader.tgread_object()
        return cls(peer=_peer, msg_id=_msg_id, info=_info, save=_save)

