"""File generated by TLObjects' generator. All changes will be ERASED"""
from ..._misc.tlobject import TLObject, TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from .. import TypeChatBannedRights, TypeDialogFilter, TypeInlineBotSwitchPM, TypeInputBotInlineMessageID, TypeInputBotInlineResult, TypeInputChatPhoto, TypeInputCheckPasswordSRP, TypeInputDialogPeer, TypeInputDocument, TypeInputEncryptedChat, TypeInputEncryptedFile, TypeInputFile, TypeInputGeoPoint, TypeInputMedia, TypeInputMessage, TypeInputPeer, TypeInputSingleMedia, TypeInputStickerSet, TypeInputStickeredMedia, TypeInputUser, TypeMessageEntity, TypeMessagesFilter, TypeReplyMarkup, TypeReportReason, TypeSendMessageAction, TypeShippingOption



@dataclasses.dataclass(init=False, frozen=True)
class AcceptEncryption(TLRequest):
    """
    :returns EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
    """
    __slots__ = ('peer', 'g_b', 'key_fingerprint',)
    CONSTRUCTOR_ID = 0x3dbc0415
    SUBCLASS_OF_ID = 0x6d28a37a

    peer: 'TypeInputEncryptedChat'
    g_b: bytes
    key_fingerprint: int
    def __init__(self, peer: 'TypeInputEncryptedChat', g_b: bytes, key_fingerprint: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'g_b', g_b)
        object.__setattr__(self, 'key_fingerprint', key_fingerprint)

    def _bytes(self):
        return b''.join((
            b'\x15\x04\xbc=',
            self.peer._bytes(),
            self._serialize_bytes(self.g_b),
            struct.pack('<q', self.key_fingerprint),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _g_b = reader.tgread_bytes()
        _key_fingerprint = reader.read_long()
        return cls(peer=_peer, g_b=_g_b, key_fingerprint=_key_fingerprint)


@dataclasses.dataclass(init=False, frozen=True)
class AcceptUrlAuth(TLRequest):
    """
    :returns UrlAuthResult: Instance of either UrlAuthResultRequest, UrlAuthResultAccepted, UrlAuthResultDefault.
    """
    __slots__ = ('write_allowed', 'peer', 'msg_id', 'button_id', 'url',)
    CONSTRUCTOR_ID = 0xb12c7125
    SUBCLASS_OF_ID = 0x7765cb1e

    write_allowed: Optional[bool]
    peer: Optional['TypeInputPeer']
    msg_id: Optional[int]
    button_id: Optional[int]
    url: Optional[str]
    def __init__(self, write_allowed: Optional[bool]=None, peer: Optional['TypeInputPeer']=None, msg_id: Optional[int]=None, button_id: Optional[int]=None, url: Optional[str]=None):
        object.__setattr__(self, 'write_allowed', write_allowed)
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'button_id', button_id)
        object.__setattr__(self, 'url', url)

    async def _resolve(self, client, utils):
        r = {}
        if self.peer:
            r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        assert ((self.peer or self.peer is not None) and (self.msg_id or self.msg_id is not None) and (self.button_id or self.button_id is not None)) or ((self.peer is None or self.peer is False) and (self.msg_id is None or self.msg_id is False) and (self.button_id is None or self.button_id is False)), 'peer, msg_id, button_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'%q,\xb1',
            struct.pack('<I', (0 if self.write_allowed is None or self.write_allowed is False else 1) | (0 if self.peer is None or self.peer is False else 2) | (0 if self.msg_id is None or self.msg_id is False else 2) | (0 if self.button_id is None or self.button_id is False else 2) | (0 if self.url is None or self.url is False else 4)),
            b'' if self.peer is None or self.peer is False else (self.peer._bytes()),
            b'' if self.msg_id is None or self.msg_id is False else (struct.pack('<i', self.msg_id)),
            b'' if self.button_id is None or self.button_id is False else (struct.pack('<i', self.button_id)),
            b'' if self.url is None or self.url is False else (self._serialize_bytes(self.url)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _write_allowed = bool(flags & 1)
        if flags & 2:
            _peer = reader.tgread_object()
        else:
            _peer = None
        if flags & 2:
            _msg_id = reader.read_int()
        else:
            _msg_id = None
        if flags & 2:
            _button_id = reader.read_int()
        else:
            _button_id = None
        if flags & 4:
            _url = reader.tgread_string()
        else:
            _url = None
        return cls(write_allowed=_write_allowed, peer=_peer, msg_id=_msg_id, button_id=_button_id, url=_url)


@dataclasses.dataclass(init=False, frozen=True)
class AddChatUser(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('chat_id', 'user_id', 'fwd_limit',)
    CONSTRUCTOR_ID = 0xf24753e3
    SUBCLASS_OF_ID = 0x8af52aac

    chat_id: int
    user_id: 'TypeInputUser'
    fwd_limit: int
    def __init__(self, chat_id: int, user_id: 'TypeInputUser', fwd_limit: int):
        object.__setattr__(self, 'chat_id', chat_id)
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'fwd_limit', fwd_limit)

    async def _resolve(self, client, utils):
        r = {}
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xe3SG\xf2',
            struct.pack('<q', self.chat_id),
            self.user_id._bytes(),
            struct.pack('<i', self.fwd_limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat_id = reader.read_long()
        _user_id = reader.tgread_object()
        _fwd_limit = reader.read_int()
        return cls(chat_id=_chat_id, user_id=_user_id, fwd_limit=_fwd_limit)


@dataclasses.dataclass(init=False, frozen=True)
class CheckChatInvite(TLRequest):
    """
    :returns ChatInvite: Instance of either ChatInviteAlready, ChatInvite, ChatInvitePeek.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0x3eadb1bb
    SUBCLASS_OF_ID = 0x4561736

    hash: str
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: str):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\xbb\xb1\xad>',
            self._serialize_bytes(self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.tgread_string()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class CheckHistoryImport(TLRequest):
    """
    :returns messages.HistoryImportParsed: Instance of HistoryImportParsed.
    """
    __slots__ = ('import_head',)
    CONSTRUCTOR_ID = 0x43fe19f3
    SUBCLASS_OF_ID = 0x5bb2720b

    import_head: str
    def __init__(self, import_head: str):
        object.__setattr__(self, 'import_head', import_head)

    def _bytes(self):
        return b''.join((
            b'\xf3\x19\xfeC',
            self._serialize_bytes(self.import_head),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _import_head = reader.tgread_string()
        return cls(import_head=_import_head)


@dataclasses.dataclass(init=False, frozen=True)
class CheckHistoryImportPeer(TLRequest):
    """
    :returns messages.CheckedHistoryImportPeer: Instance of CheckedHistoryImportPeer.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0x5dc60f03
    SUBCLASS_OF_ID = 0xb84bb337

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x03\x0f\xc6]',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class ClearAllDrafts(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x7e58ee9c
    SUBCLASS_OF_ID = 0xf5b399ac

    def _bytes(self):
        return b''.join((
            b'\x9c\xeeX~',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ClearRecentStickers(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('attached',)
    CONSTRUCTOR_ID = 0x8999602d
    SUBCLASS_OF_ID = 0xf5b399ac

    attached: Optional[bool]
    def __init__(self, attached: Optional[bool]=None):
        object.__setattr__(self, 'attached', attached)

    def _bytes(self):
        return b''.join((
            b'-`\x99\x89',
            struct.pack('<I', (0 if self.attached is None or self.attached is False else 1)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _attached = bool(flags & 1)
        return cls(attached=_attached)


@dataclasses.dataclass(init=False, frozen=True)
class CreateChat(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('users', 'title',)
    CONSTRUCTOR_ID = 0x9cb126e
    SUBCLASS_OF_ID = 0x8af52aac

    users: List['TypeInputUser']
    title: str
    def __init__(self, users: List['TypeInputUser'], title: str):
        object.__setattr__(self, 'users', users)
        object.__setattr__(self, 'title', title)

    async def _resolve(self, client, utils):
        r = {}
        r['users'] = []
        for x in self.users:
            r['users'].append(utils.get_input_user(await client._get_input_peer(x)))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'n\x12\xcb\t',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
            self._serialize_bytes(self.title),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        _title = reader.tgread_string()
        return cls(users=_users, title=_title)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteChat(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('chat_id',)
    CONSTRUCTOR_ID = 0x5bd0ee50
    SUBCLASS_OF_ID = 0xf5b399ac

    chat_id: int
    def __init__(self, chat_id: int):
        object.__setattr__(self, 'chat_id', chat_id)

    def _bytes(self):
        return b''.join((
            b'P\xee\xd0[',
            struct.pack('<q', self.chat_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat_id = reader.read_long()
        return cls(chat_id=_chat_id)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteChatUser(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('chat_id', 'user_id', 'revoke_history',)
    CONSTRUCTOR_ID = 0xa2185cab
    SUBCLASS_OF_ID = 0x8af52aac

    chat_id: int
    user_id: 'TypeInputUser'
    revoke_history: Optional[bool]
    def __init__(self, chat_id: int, user_id: 'TypeInputUser', revoke_history: Optional[bool]=None):
        object.__setattr__(self, 'chat_id', chat_id)
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'revoke_history', revoke_history)

    async def _resolve(self, client, utils):
        r = {}
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xab\\\x18\xa2',
            struct.pack('<I', (0 if self.revoke_history is None or self.revoke_history is False else 1)),
            struct.pack('<q', self.chat_id),
            self.user_id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _revoke_history = bool(flags & 1)
        _chat_id = reader.read_long()
        _user_id = reader.tgread_object()
        return cls(chat_id=_chat_id, user_id=_user_id, revoke_history=_revoke_history)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteExportedChatInvite(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'link',)
    CONSTRUCTOR_ID = 0xd464a42b
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    link: str
    def __init__(self, peer: 'TypeInputPeer', link: str):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'link', link)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'+\xa4d\xd4',
            self.peer._bytes(),
            self._serialize_bytes(self.link),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _link = reader.tgread_string()
        return cls(peer=_peer, link=_link)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteHistory(TLRequest):
    """
    :returns messages.AffectedHistory: Instance of AffectedHistory.
    """
    __slots__ = ('peer', 'max_id', 'just_clear', 'revoke', 'min_date', 'max_date',)
    CONSTRUCTOR_ID = 0xb08f922a
    SUBCLASS_OF_ID = 0x2c49c116

    peer: 'TypeInputPeer'
    max_id: int
    just_clear: Optional[bool]
    revoke: Optional[bool]
    min_date: Optional[datetime]
    max_date: Optional[datetime]
    def __init__(self, peer: 'TypeInputPeer', max_id: int, just_clear: Optional[bool]=None, revoke: Optional[bool]=None, min_date: Optional[datetime]=None, max_date: Optional[datetime]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'max_id', max_id)
        object.__setattr__(self, 'just_clear', just_clear)
        object.__setattr__(self, 'revoke', revoke)
        object.__setattr__(self, 'min_date', min_date)
        object.__setattr__(self, 'max_date', max_date)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'*\x92\x8f\xb0',
            struct.pack('<I', (0 if self.just_clear is None or self.just_clear is False else 1) | (0 if self.revoke is None or self.revoke is False else 2) | (0 if self.min_date is None or self.min_date is False else 4) | (0 if self.max_date is None or self.max_date is False else 8)),
            self.peer._bytes(),
            struct.pack('<i', self.max_id),
            b'' if self.min_date is None or self.min_date is False else (self._serialize_datetime(self.min_date)),
            b'' if self.max_date is None or self.max_date is False else (self._serialize_datetime(self.max_date)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _just_clear = bool(flags & 1)
        _revoke = bool(flags & 2)
        _peer = reader.tgread_object()
        _max_id = reader.read_int()
        if flags & 4:
            _min_date = reader.tgread_date()
        else:
            _min_date = None
        if flags & 8:
            _max_date = reader.tgread_date()
        else:
            _max_date = None
        return cls(peer=_peer, max_id=_max_id, just_clear=_just_clear, revoke=_revoke, min_date=_min_date, max_date=_max_date)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteMessages(TLRequest):
    """
    :returns messages.AffectedMessages: Instance of AffectedMessages.
    """
    __slots__ = ('id', 'revoke',)
    CONSTRUCTOR_ID = 0xe58e95d2
    SUBCLASS_OF_ID = 0xced3c06e

    id: List[int]
    revoke: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: List[int], revoke: Optional[bool]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'revoke', revoke)

    def _bytes(self):
        return b''.join((
            b'\xd2\x95\x8e\xe5',
            struct.pack('<I', (0 if self.revoke is None or self.revoke is False else 1)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _revoke = bool(flags & 1)
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(id=_id, revoke=_revoke)


@dataclasses.dataclass(init=False, frozen=True)
class DeletePhoneCallHistory(TLRequest):
    """
    :returns messages.AffectedFoundMessages: Instance of AffectedFoundMessages.
    """
    __slots__ = ('revoke',)
    CONSTRUCTOR_ID = 0xf9cbe409
    SUBCLASS_OF_ID = 0xf817652e

    revoke: Optional[bool]
    def __init__(self, revoke: Optional[bool]=None):
        object.__setattr__(self, 'revoke', revoke)

    def _bytes(self):
        return b''.join((
            b'\t\xe4\xcb\xf9',
            struct.pack('<I', (0 if self.revoke is None or self.revoke is False else 1)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _revoke = bool(flags & 1)
        return cls(revoke=_revoke)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteRevokedExportedChatInvites(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'admin_id',)
    CONSTRUCTOR_ID = 0x56987bd5
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    admin_id: 'TypeInputUser'
    def __init__(self, peer: 'TypeInputPeer', admin_id: 'TypeInputUser'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'admin_id', admin_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        r['admin_id'] = utils.get_input_user(await client._get_input_peer(self.admin_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xd5{\x98V',
            self.peer._bytes(),
            self.admin_id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _admin_id = reader.tgread_object()
        return cls(peer=_peer, admin_id=_admin_id)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteScheduledMessages(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'id',)
    CONSTRUCTOR_ID = 0x59ae2b16
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    id: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: List[int]):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x16+\xaeY',
            self.peer._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(peer=_peer, id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class DiscardEncryption(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('chat_id', 'delete_history',)
    CONSTRUCTOR_ID = 0xf393aea0
    SUBCLASS_OF_ID = 0xf5b399ac

    chat_id: int
    delete_history: Optional[bool]
    def __init__(self, chat_id: int, delete_history: Optional[bool]=None):
        object.__setattr__(self, 'chat_id', chat_id)
        object.__setattr__(self, 'delete_history', delete_history)

    def _bytes(self):
        return b''.join((
            b'\xa0\xae\x93\xf3',
            struct.pack('<I', (0 if self.delete_history is None or self.delete_history is False else 1)),
            struct.pack('<i', self.chat_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _delete_history = bool(flags & 1)
        _chat_id = reader.read_int()
        return cls(chat_id=_chat_id, delete_history=_delete_history)


@dataclasses.dataclass(init=False, frozen=True)
class EditChatAbout(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'about',)
    CONSTRUCTOR_ID = 0xdef60797
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    about: str
    def __init__(self, peer: 'TypeInputPeer', about: str):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'about', about)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x97\x07\xf6\xde',
            self.peer._bytes(),
            self._serialize_bytes(self.about),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _about = reader.tgread_string()
        return cls(peer=_peer, about=_about)


@dataclasses.dataclass(init=False, frozen=True)
class EditChatAdmin(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('chat_id', 'user_id', 'is_admin',)
    CONSTRUCTOR_ID = 0xa85bd1c2
    SUBCLASS_OF_ID = 0xf5b399ac

    chat_id: int
    user_id: 'TypeInputUser'
    is_admin: bool
    def __init__(self, chat_id: int, user_id: 'TypeInputUser', is_admin: bool):
        object.__setattr__(self, 'chat_id', chat_id)
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'is_admin', is_admin)

    async def _resolve(self, client, utils):
        r = {}
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xc2\xd1[\xa8',
            struct.pack('<q', self.chat_id),
            self.user_id._bytes(),
            b'\xb5ur\x99' if self.is_admin else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat_id = reader.read_long()
        _user_id = reader.tgread_object()
        _is_admin = reader.tgread_bool()
        return cls(chat_id=_chat_id, user_id=_user_id, is_admin=_is_admin)


@dataclasses.dataclass(init=False, frozen=True)
class EditChatDefaultBannedRights(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'banned_rights',)
    CONSTRUCTOR_ID = 0xa5866b41
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    banned_rights: 'TypeChatBannedRights'
    def __init__(self, peer: 'TypeInputPeer', banned_rights: 'TypeChatBannedRights'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'banned_rights', banned_rights)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'Ak\x86\xa5',
            self.peer._bytes(),
            self.banned_rights._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _banned_rights = reader.tgread_object()
        return cls(peer=_peer, banned_rights=_banned_rights)


@dataclasses.dataclass(init=False, frozen=True)
class EditChatPhoto(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('chat_id', 'photo',)
    CONSTRUCTOR_ID = 0x35ddd674
    SUBCLASS_OF_ID = 0x8af52aac

    chat_id: int
    photo: 'TypeInputChatPhoto'
    def __init__(self, chat_id: int, photo: 'TypeInputChatPhoto'):
        object.__setattr__(self, 'chat_id', chat_id)
        object.__setattr__(self, 'photo', photo)

    async def _resolve(self, client, utils):
        r = {}
        r['photo'] = utils.get_input_chat_photo(self.photo)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b't\xd6\xdd5',
            struct.pack('<q', self.chat_id),
            self.photo._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat_id = reader.read_long()
        _photo = reader.tgread_object()
        return cls(chat_id=_chat_id, photo=_photo)


@dataclasses.dataclass(init=False, frozen=True)
class EditChatTitle(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('chat_id', 'title',)
    CONSTRUCTOR_ID = 0x73783ffd
    SUBCLASS_OF_ID = 0x8af52aac

    chat_id: int
    title: str
    def __init__(self, chat_id: int, title: str):
        object.__setattr__(self, 'chat_id', chat_id)
        object.__setattr__(self, 'title', title)

    def _bytes(self):
        return b''.join((
            b'\xfd?xs',
            struct.pack('<q', self.chat_id),
            self._serialize_bytes(self.title),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat_id = reader.read_long()
        _title = reader.tgread_string()
        return cls(chat_id=_chat_id, title=_title)


@dataclasses.dataclass(init=False, frozen=True)
class EditExportedChatInvite(TLRequest):
    """
    :returns messages.ExportedChatInvite: Instance of either ExportedChatInvite, ExportedChatInviteReplaced.
    """
    __slots__ = ('peer', 'link', 'revoked', 'expire_date', 'usage_limit', 'request_needed', 'title',)
    CONSTRUCTOR_ID = 0xbdca2f75
    SUBCLASS_OF_ID = 0x82dcd4ca

    peer: 'TypeInputPeer'
    link: str
    revoked: Optional[bool]
    expire_date: Optional[datetime]
    usage_limit: Optional[int]
    request_needed: Optional[bool]
    title: Optional[str]
    def __init__(self, peer: 'TypeInputPeer', link: str, revoked: Optional[bool]=None, expire_date: Optional[datetime]=None, usage_limit: Optional[int]=None, request_needed: Optional[bool]=None, title: Optional[str]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'link', link)
        object.__setattr__(self, 'revoked', revoked)
        object.__setattr__(self, 'expire_date', expire_date)
        object.__setattr__(self, 'usage_limit', usage_limit)
        object.__setattr__(self, 'request_needed', request_needed)
        object.__setattr__(self, 'title', title)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'u/\xca\xbd',
            struct.pack('<I', (0 if self.revoked is None or self.revoked is False else 4) | (0 if self.expire_date is None or self.expire_date is False else 1) | (0 if self.usage_limit is None or self.usage_limit is False else 2) | (0 if self.request_needed is None else 8) | (0 if self.title is None or self.title is False else 16)),
            self.peer._bytes(),
            self._serialize_bytes(self.link),
            b'' if self.expire_date is None or self.expire_date is False else (self._serialize_datetime(self.expire_date)),
            b'' if self.usage_limit is None or self.usage_limit is False else (struct.pack('<i', self.usage_limit)),
            b'' if self.request_needed is None else (b'\xb5ur\x99' if self.request_needed else b'7\x97y\xbc'),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _revoked = bool(flags & 4)
        _peer = reader.tgread_object()
        _link = reader.tgread_string()
        if flags & 1:
            _expire_date = reader.tgread_date()
        else:
            _expire_date = None
        if flags & 2:
            _usage_limit = reader.read_int()
        else:
            _usage_limit = None
        if flags & 8:
            _request_needed = reader.tgread_bool()
        else:
            _request_needed = None
        if flags & 16:
            _title = reader.tgread_string()
        else:
            _title = None
        return cls(peer=_peer, link=_link, revoked=_revoked, expire_date=_expire_date, usage_limit=_usage_limit, request_needed=_request_needed, title=_title)


@dataclasses.dataclass(init=False, frozen=True)
class EditInlineBotMessage(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('id', 'no_webpage', 'message', 'media', 'reply_markup', 'entities',)
    CONSTRUCTOR_ID = 0x83557dba
    SUBCLASS_OF_ID = 0xf5b399ac

    id: 'TypeInputBotInlineMessageID'
    no_webpage: Optional[bool]
    message: Optional[str]
    media: Optional['TypeInputMedia']
    reply_markup: Optional['TypeReplyMarkup']
    entities: Optional[List['TypeMessageEntity']]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputBotInlineMessageID', no_webpage: Optional[bool]=None, message: Optional[str]=None, media: Optional['TypeInputMedia']=None, reply_markup: Optional['TypeReplyMarkup']=None, entities: Optional[List['TypeMessageEntity']]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'no_webpage', no_webpage)
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'media', media)
        object.__setattr__(self, 'reply_markup', reply_markup)
        object.__setattr__(self, 'entities', entities)

    async def _resolve(self, client, utils):
        r = {}
        if self.media:
            r['media'] = utils.get_input_media(self.media)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xba}U\x83',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 2) | (0 if self.message is None or self.message is False else 2048) | (0 if self.media is None or self.media is False else 16384) | (0 if self.reply_markup is None or self.reply_markup is False else 4) | (0 if self.entities is None or self.entities is False else 8)),
            self.id._bytes(),
            b'' if self.message is None or self.message is False else (self._serialize_bytes(self.message)),
            b'' if self.media is None or self.media is False else (self.media._bytes()),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 2)
        _id = reader.tgread_object()
        if flags & 2048:
            _message = reader.tgread_string()
        else:
            _message = None
        if flags & 16384:
            _media = reader.tgread_object()
        else:
            _media = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(id=_id, no_webpage=_no_webpage, message=_message, media=_media, reply_markup=_reply_markup, entities=_entities)


@dataclasses.dataclass(init=False, frozen=True)
class EditMessage(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'id', 'no_webpage', 'message', 'media', 'reply_markup', 'entities', 'schedule_date',)
    CONSTRUCTOR_ID = 0x48f71778
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    id: int
    no_webpage: Optional[bool]
    message: Optional[str]
    media: Optional['TypeInputMedia']
    reply_markup: Optional['TypeReplyMarkup']
    entities: Optional[List['TypeMessageEntity']]
    schedule_date: Optional[datetime]
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int, no_webpage: Optional[bool]=None, message: Optional[str]=None, media: Optional['TypeInputMedia']=None, reply_markup: Optional['TypeReplyMarkup']=None, entities: Optional[List['TypeMessageEntity']]=None, schedule_date: Optional[datetime]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'no_webpage', no_webpage)
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'media', media)
        object.__setattr__(self, 'reply_markup', reply_markup)
        object.__setattr__(self, 'entities', entities)
        object.__setattr__(self, 'schedule_date', schedule_date)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        if self.media:
            r['media'] = utils.get_input_media(self.media)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'x\x17\xf7H',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 2) | (0 if self.message is None or self.message is False else 2048) | (0 if self.media is None or self.media is False else 16384) | (0 if self.reply_markup is None or self.reply_markup is False else 4) | (0 if self.entities is None or self.entities is False else 8) | (0 if self.schedule_date is None or self.schedule_date is False else 32768)),
            self.peer._bytes(),
            struct.pack('<i', self.id),
            b'' if self.message is None or self.message is False else (self._serialize_bytes(self.message)),
            b'' if self.media is None or self.media is False else (self.media._bytes()),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.schedule_date is None or self.schedule_date is False else (self._serialize_datetime(self.schedule_date)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 2)
        _peer = reader.tgread_object()
        _id = reader.read_int()
        if flags & 2048:
            _message = reader.tgread_string()
        else:
            _message = None
        if flags & 16384:
            _media = reader.tgread_object()
        else:
            _media = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 32768:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        return cls(peer=_peer, id=_id, no_webpage=_no_webpage, message=_message, media=_media, reply_markup=_reply_markup, entities=_entities, schedule_date=_schedule_date)


@dataclasses.dataclass(init=False, frozen=True)
class ExportChatInvite(TLRequest):
    """
    :returns ExportedChatInvite: Instance of ChatInviteExported.
    """
    __slots__ = ('peer', 'legacy_revoke_permanent', 'request_needed', 'expire_date', 'usage_limit', 'title',)
    CONSTRUCTOR_ID = 0xa02ce5d5
    SUBCLASS_OF_ID = 0xb4748a58

    peer: 'TypeInputPeer'
    legacy_revoke_permanent: Optional[bool]
    request_needed: Optional[bool]
    expire_date: Optional[datetime]
    usage_limit: Optional[int]
    title: Optional[str]
    def __init__(self, peer: 'TypeInputPeer', legacy_revoke_permanent: Optional[bool]=None, request_needed: Optional[bool]=None, expire_date: Optional[datetime]=None, usage_limit: Optional[int]=None, title: Optional[str]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'legacy_revoke_permanent', legacy_revoke_permanent)
        object.__setattr__(self, 'request_needed', request_needed)
        object.__setattr__(self, 'expire_date', expire_date)
        object.__setattr__(self, 'usage_limit', usage_limit)
        object.__setattr__(self, 'title', title)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xd5\xe5,\xa0',
            struct.pack('<I', (0 if self.legacy_revoke_permanent is None or self.legacy_revoke_permanent is False else 4) | (0 if self.request_needed is None or self.request_needed is False else 8) | (0 if self.expire_date is None or self.expire_date is False else 1) | (0 if self.usage_limit is None or self.usage_limit is False else 2) | (0 if self.title is None or self.title is False else 16)),
            self.peer._bytes(),
            b'' if self.expire_date is None or self.expire_date is False else (self._serialize_datetime(self.expire_date)),
            b'' if self.usage_limit is None or self.usage_limit is False else (struct.pack('<i', self.usage_limit)),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _legacy_revoke_permanent = bool(flags & 4)
        _request_needed = bool(flags & 8)
        _peer = reader.tgread_object()
        if flags & 1:
            _expire_date = reader.tgread_date()
        else:
            _expire_date = None
        if flags & 2:
            _usage_limit = reader.read_int()
        else:
            _usage_limit = None
        if flags & 16:
            _title = reader.tgread_string()
        else:
            _title = None
        return cls(peer=_peer, legacy_revoke_permanent=_legacy_revoke_permanent, request_needed=_request_needed, expire_date=_expire_date, usage_limit=_usage_limit, title=_title)


@dataclasses.dataclass(init=False, frozen=True)
class FaveSticker(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('id', 'unfave',)
    CONSTRUCTOR_ID = 0xb9ffc55b
    SUBCLASS_OF_ID = 0xf5b399ac

    id: 'TypeInputDocument'
    unfave: bool
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputDocument', unfave: bool):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'unfave', unfave)

    async def _resolve(self, client, utils):
        r = {}
        r['id'] = utils.get_input_document(self.id)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'[\xc5\xff\xb9',
            self.id._bytes(),
            b'\xb5ur\x99' if self.unfave else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_object()
        _unfave = reader.tgread_bool()
        return cls(id=_id, unfave=_unfave)


@dataclasses.dataclass(init=False, frozen=True)
class ForwardMessages(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('from_peer', 'id', 'to_peer', 'silent', 'background', 'with_my_score', 'drop_author', 'drop_media_captions', 'noforwards', 'random_id', 'schedule_date', 'send_as',)
    CONSTRUCTOR_ID = 0xcc30290b
    SUBCLASS_OF_ID = 0x8af52aac

    from_peer: 'TypeInputPeer'
    id: List[int]
    to_peer: 'TypeInputPeer'
    silent: Optional[bool]
    background: Optional[bool]
    with_my_score: Optional[bool]
    drop_author: Optional[bool]
    drop_media_captions: Optional[bool]
    noforwards: Optional[bool]
    random_id: List[int]
    schedule_date: Optional[datetime]
    send_as: Optional['TypeInputPeer']
    # noinspection PyShadowingBuiltins
    def __init__(self, from_peer: 'TypeInputPeer', id: List[int], to_peer: 'TypeInputPeer', silent: Optional[bool]=None, background: Optional[bool]=None, with_my_score: Optional[bool]=None, drop_author: Optional[bool]=None, drop_media_captions: Optional[bool]=None, noforwards: Optional[bool]=None, random_id: List[int]=None, schedule_date: Optional[datetime]=None, send_as: Optional['TypeInputPeer']=None):
        object.__setattr__(self, 'from_peer', from_peer)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'to_peer', to_peer)
        object.__setattr__(self, 'silent', silent)
        object.__setattr__(self, 'background', background)
        object.__setattr__(self, 'with_my_score', with_my_score)
        object.__setattr__(self, 'drop_author', drop_author)
        object.__setattr__(self, 'drop_media_captions', drop_media_captions)
        object.__setattr__(self, 'noforwards', noforwards)
        object.__setattr__(self, 'random_id', random_id)
        object.__setattr__(self, 'schedule_date', schedule_date)
        object.__setattr__(self, 'send_as', send_as)

    async def _resolve(self, client, utils):
        r = {}
        r['from_peer'] = utils.get_input_peer(await client._get_input_peer(self.from_peer))
        r['to_peer'] = utils.get_input_peer(await client._get_input_peer(self.to_peer))
        if self.random_id is None:
            r['random_id'] = [int.from_bytes(os.urandom(8), 'big', signed=True) for _ in range(len(self.id))]

        if self.send_as:
            r['send_as'] = utils.get_input_peer(await client._get_input_peer(self.send_as))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x0b)0\xcc',
            struct.pack('<I', (0 if self.silent is None or self.silent is False else 32) | (0 if self.background is None or self.background is False else 64) | (0 if self.with_my_score is None or self.with_my_score is False else 256) | (0 if self.drop_author is None or self.drop_author is False else 2048) | (0 if self.drop_media_captions is None or self.drop_media_captions is False else 4096) | (0 if self.noforwards is None or self.noforwards is False else 16384) | (0 if self.schedule_date is None or self.schedule_date is False else 1024) | (0 if self.send_as is None or self.send_as is False else 8192)),
            self.from_peer._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.random_id)),b''.join(struct.pack('<q', x) for x in self.random_id),
            self.to_peer._bytes(),
            b'' if self.schedule_date is None or self.schedule_date is False else (self._serialize_datetime(self.schedule_date)),
            b'' if self.send_as is None or self.send_as is False else (self.send_as._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _silent = bool(flags & 32)
        _background = bool(flags & 64)
        _with_my_score = bool(flags & 256)
        _drop_author = bool(flags & 2048)
        _drop_media_captions = bool(flags & 4096)
        _noforwards = bool(flags & 16384)
        _from_peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        reader.read_int()
        _random_id = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _random_id.append(_x)

        _to_peer = reader.tgread_object()
        if flags & 1024:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        if flags & 8192:
            _send_as = reader.tgread_object()
        else:
            _send_as = None
        return cls(from_peer=_from_peer, id=_id, to_peer=_to_peer, silent=_silent, background=_background, with_my_score=_with_my_score, drop_author=_drop_author, drop_media_captions=_drop_media_captions, noforwards=_noforwards, random_id=_random_id, schedule_date=_schedule_date, send_as=_send_as)


@dataclasses.dataclass(init=False, frozen=True)
class GetAdminsWithInvites(TLRequest):
    """
    :returns messages.ChatAdminsWithInvites: Instance of ChatAdminsWithInvites.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0x3920e6ef
    SUBCLASS_OF_ID = 0x8f5bad2b

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xef\xe6 9',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class GetAllChats(TLRequest):
    """
    :returns messages.Chats: Instance of either Chats, ChatsSlice.
    """
    __slots__ = ('except_ids',)
    CONSTRUCTOR_ID = 0x875f74be
    SUBCLASS_OF_ID = 0x99d5cb14

    except_ids: List[int]
    def __init__(self, except_ids: List[int]):
        object.__setattr__(self, 'except_ids', except_ids)

    def _bytes(self):
        return b''.join((
            b'\xbet_\x87',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.except_ids)),b''.join(struct.pack('<q', x) for x in self.except_ids),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _except_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _except_ids.append(_x)

        return cls(except_ids=_except_ids)


@dataclasses.dataclass(init=False, frozen=True)
class GetAllDrafts(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x6a3f8d65
    SUBCLASS_OF_ID = 0x8af52aac

    def _bytes(self):
        return b''.join((
            b'e\x8d?j',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetAllStickers(TLRequest):
    """
    :returns messages.AllStickers: Instance of either AllStickersNotModified, AllStickers.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0xb8a0a1a8
    SUBCLASS_OF_ID = 0x45834829

    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\xa8\xa1\xa0\xb8',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetArchivedStickers(TLRequest):
    """
    :returns messages.ArchivedStickers: Instance of ArchivedStickers.
    """
    __slots__ = ('offset_id', 'limit', 'masks',)
    CONSTRUCTOR_ID = 0x57f17692
    SUBCLASS_OF_ID = 0x7296d771

    offset_id: int
    limit: int
    masks: Optional[bool]
    def __init__(self, offset_id: int, limit: int, masks: Optional[bool]=None):
        object.__setattr__(self, 'offset_id', offset_id)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'masks', masks)

    def _bytes(self):
        return b''.join((
            b'\x92v\xf1W',
            struct.pack('<I', (0 if self.masks is None or self.masks is False else 1)),
            struct.pack('<q', self.offset_id),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _masks = bool(flags & 1)
        _offset_id = reader.read_long()
        _limit = reader.read_int()
        return cls(offset_id=_offset_id, limit=_limit, masks=_masks)


@dataclasses.dataclass(init=False, frozen=True)
class GetAttachedStickers(TLRequest):
    """
    :returns Vector<StickerSetCovered>: This type has no constructors.
    """
    __slots__ = ('media',)
    CONSTRUCTOR_ID = 0xcc5b67cc
    SUBCLASS_OF_ID = 0xcc125f6b

    media: 'TypeInputStickeredMedia'
    def __init__(self, media: 'TypeInputStickeredMedia'):
        object.__setattr__(self, 'media', media)

    def _bytes(self):
        return b''.join((
            b'\xccg[\xcc',
            self.media._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _media = reader.tgread_object()
        return cls(media=_media)


@dataclasses.dataclass(init=False, frozen=True)
class GetAvailableReactions(TLRequest):
    """
    :returns messages.AvailableReactions: Instance of either AvailableReactionsNotModified, AvailableReactions.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0x18dea0ac
    SUBCLASS_OF_ID = 0xe426ad82

    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\xac\xa0\xde\x18',
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_int()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetBotCallbackAnswer(TLRequest):
    """
    :returns messages.BotCallbackAnswer: Instance of BotCallbackAnswer.
    """
    __slots__ = ('peer', 'msg_id', 'game', 'data', 'password',)
    CONSTRUCTOR_ID = 0x9342ca07
    SUBCLASS_OF_ID = 0x6c4dd18c

    peer: 'TypeInputPeer'
    msg_id: int
    game: Optional[bool]
    data: Optional[bytes]
    password: Optional['TypeInputCheckPasswordSRP']
    def __init__(self, peer: 'TypeInputPeer', msg_id: int, game: Optional[bool]=None, data: Optional[bytes]=None, password: Optional['TypeInputCheckPasswordSRP']=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'game', game)
        object.__setattr__(self, 'data', data)
        object.__setattr__(self, 'password', password)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x07\xcaB\x93',
            struct.pack('<I', (0 if self.game is None or self.game is False else 2) | (0 if self.data is None or self.data is False else 1) | (0 if self.password is None or self.password is False else 4)),
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            b'' if self.data is None or self.data is False else (self._serialize_bytes(self.data)),
            b'' if self.password is None or self.password is False else (self.password._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _game = bool(flags & 2)
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        if flags & 1:
            _data = reader.tgread_bytes()
        else:
            _data = None
        if flags & 4:
            _password = reader.tgread_object()
        else:
            _password = None
        return cls(peer=_peer, msg_id=_msg_id, game=_game, data=_data, password=_password)


@dataclasses.dataclass(init=False, frozen=True)
class GetChatInviteImporters(TLRequest):
    """
    :returns messages.ChatInviteImporters: Instance of ChatInviteImporters.
    """
    __slots__ = ('peer', 'offset_date', 'offset_user', 'limit', 'requested', 'link', 'q',)
    CONSTRUCTOR_ID = 0xdf04dd4e
    SUBCLASS_OF_ID = 0xd9bc8aa6

    peer: 'TypeInputPeer'
    offset_date: Optional[datetime]
    offset_user: 'TypeInputUser'
    limit: int
    requested: Optional[bool]
    link: Optional[str]
    q: Optional[str]
    def __init__(self, peer: 'TypeInputPeer', offset_date: Optional[datetime], offset_user: 'TypeInputUser', limit: int, requested: Optional[bool]=None, link: Optional[str]=None, q: Optional[str]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'offset_date', offset_date)
        object.__setattr__(self, 'offset_user', offset_user)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'requested', requested)
        object.__setattr__(self, 'link', link)
        object.__setattr__(self, 'q', q)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        r['offset_user'] = utils.get_input_user(await client._get_input_peer(self.offset_user))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'N\xdd\x04\xdf',
            struct.pack('<I', (0 if self.requested is None or self.requested is False else 1) | (0 if self.link is None or self.link is False else 2) | (0 if self.q is None or self.q is False else 4)),
            self.peer._bytes(),
            b'' if self.link is None or self.link is False else (self._serialize_bytes(self.link)),
            b'' if self.q is None or self.q is False else (self._serialize_bytes(self.q)),
            self._serialize_datetime(self.offset_date),
            self.offset_user._bytes(),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _requested = bool(flags & 1)
        _peer = reader.tgread_object()
        if flags & 2:
            _link = reader.tgread_string()
        else:
            _link = None
        if flags & 4:
            _q = reader.tgread_string()
        else:
            _q = None
        _offset_date = reader.tgread_date()
        _offset_user = reader.tgread_object()
        _limit = reader.read_int()
        return cls(peer=_peer, offset_date=_offset_date, offset_user=_offset_user, limit=_limit, requested=_requested, link=_link, q=_q)


@dataclasses.dataclass(init=False, frozen=True)
class GetChats(TLRequest):
    """
    :returns messages.Chats: Instance of either Chats, ChatsSlice.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x49e9528f
    SUBCLASS_OF_ID = 0x99d5cb14

    id: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: List[int]):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'\x8fR\xe9I',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<q', x) for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _id.append(_x)

        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetCommonChats(TLRequest):
    """
    :returns messages.Chats: Instance of either Chats, ChatsSlice.
    """
    __slots__ = ('user_id', 'max_id', 'limit',)
    CONSTRUCTOR_ID = 0xe40ca104
    SUBCLASS_OF_ID = 0x99d5cb14

    user_id: 'TypeInputUser'
    max_id: int
    limit: int
    def __init__(self, user_id: 'TypeInputUser', max_id: int, limit: int):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'max_id', max_id)
        object.__setattr__(self, 'limit', limit)

    async def _resolve(self, client, utils):
        r = {}
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x04\xa1\x0c\xe4',
            self.user_id._bytes(),
            struct.pack('<q', self.max_id),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.tgread_object()
        _max_id = reader.read_long()
        _limit = reader.read_int()
        return cls(user_id=_user_id, max_id=_max_id, limit=_limit)


@dataclasses.dataclass(init=False, frozen=True)
class GetDhConfig(TLRequest):
    """
    :returns messages.DhConfig: Instance of either DhConfigNotModified, DhConfig.
    """
    __slots__ = ('version', 'random_length',)
    CONSTRUCTOR_ID = 0x26cf8950
    SUBCLASS_OF_ID = 0xe488ed8b

    version: int
    random_length: int
    def __init__(self, version: int, random_length: int):
        object.__setattr__(self, 'version', version)
        object.__setattr__(self, 'random_length', random_length)

    def _bytes(self):
        return b''.join((
            b'P\x89\xcf&',
            struct.pack('<i', self.version),
            struct.pack('<i', self.random_length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _version = reader.read_int()
        _random_length = reader.read_int()
        return cls(version=_version, random_length=_random_length)


@dataclasses.dataclass(init=False, frozen=True)
class GetDialogFilters(TLRequest):
    """
    :returns Vector<DialogFilter>: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xf19ed96d
    SUBCLASS_OF_ID = 0x601ce94d

    def _bytes(self):
        return b''.join((
            b'm\xd9\x9e\xf1',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetDialogUnreadMarks(TLRequest):
    """
    :returns Vector<DialogPeer>: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x22e24e22
    SUBCLASS_OF_ID = 0xbec64ad9

    def _bytes(self):
        return b''.join((
            b'"N\xe2"',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetDialogs(TLRequest):
    """
    :returns messages.Dialogs: Instance of either Dialogs, DialogsSlice, DialogsNotModified.
    """
    __slots__ = ('offset_date', 'offset_id', 'offset_peer', 'limit', 'hash', 'exclude_pinned', 'folder_id',)
    CONSTRUCTOR_ID = 0xa0f4cb4f
    SUBCLASS_OF_ID = 0xe1b52ee

    offset_date: Optional[datetime]
    offset_id: int
    offset_peer: 'TypeInputPeer'
    limit: int
    hash: int
    exclude_pinned: Optional[bool]
    folder_id: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, offset_date: Optional[datetime], offset_id: int, offset_peer: 'TypeInputPeer', limit: int, hash: int, exclude_pinned: Optional[bool]=None, folder_id: Optional[int]=None):
        object.__setattr__(self, 'offset_date', offset_date)
        object.__setattr__(self, 'offset_id', offset_id)
        object.__setattr__(self, 'offset_peer', offset_peer)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'exclude_pinned', exclude_pinned)
        object.__setattr__(self, 'folder_id', folder_id)

    async def _resolve(self, client, utils):
        r = {}
        r['offset_peer'] = utils.get_input_peer(await client._get_input_peer(self.offset_peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'O\xcb\xf4\xa0',
            struct.pack('<I', (0 if self.exclude_pinned is None or self.exclude_pinned is False else 1) | (0 if self.folder_id is None or self.folder_id is False else 2)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            self._serialize_datetime(self.offset_date),
            struct.pack('<i', self.offset_id),
            self.offset_peer._bytes(),
            struct.pack('<i', self.limit),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _exclude_pinned = bool(flags & 1)
        if flags & 2:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        _offset_date = reader.tgread_date()
        _offset_id = reader.read_int()
        _offset_peer = reader.tgread_object()
        _limit = reader.read_int()
        _hash = reader.read_long()
        return cls(offset_date=_offset_date, offset_id=_offset_id, offset_peer=_offset_peer, limit=_limit, hash=_hash, exclude_pinned=_exclude_pinned, folder_id=_folder_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetDiscussionMessage(TLRequest):
    """
    :returns messages.DiscussionMessage: Instance of DiscussionMessage.
    """
    __slots__ = ('peer', 'msg_id',)
    CONSTRUCTOR_ID = 0x446972fd
    SUBCLASS_OF_ID = 0x53f8e3e8

    peer: 'TypeInputPeer'
    msg_id: int
    def __init__(self, peer: 'TypeInputPeer', msg_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xfdriD',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetDocumentByHash(TLRequest):
    """
    :returns Document: Instance of either DocumentEmpty, Document.
    """
    __slots__ = ('sha256', 'size', 'mime_type',)
    CONSTRUCTOR_ID = 0x338e2464
    SUBCLASS_OF_ID = 0x211fe820

    sha256: bytes
    size: int
    mime_type: str
    def __init__(self, sha256: bytes, size: int, mime_type: str):
        object.__setattr__(self, 'sha256', sha256)
        object.__setattr__(self, 'size', size)
        object.__setattr__(self, 'mime_type', mime_type)

    def _bytes(self):
        return b''.join((
            b'd$\x8e3',
            self._serialize_bytes(self.sha256),
            struct.pack('<i', self.size),
            self._serialize_bytes(self.mime_type),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _sha256 = reader.tgread_bytes()
        _size = reader.read_int()
        _mime_type = reader.tgread_string()
        return cls(sha256=_sha256, size=_size, mime_type=_mime_type)


@dataclasses.dataclass(init=False, frozen=True)
class GetEmojiKeywords(TLRequest):
    """
    :returns EmojiKeywordsDifference: Instance of EmojiKeywordsDifference.
    """
    __slots__ = ('lang_code',)
    CONSTRUCTOR_ID = 0x35a0e062
    SUBCLASS_OF_ID = 0xd279c672

    lang_code: str
    def __init__(self, lang_code: str):
        object.__setattr__(self, 'lang_code', lang_code)

    def _bytes(self):
        return b''.join((
            b'b\xe0\xa05',
            self._serialize_bytes(self.lang_code),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        return cls(lang_code=_lang_code)


@dataclasses.dataclass(init=False, frozen=True)
class GetEmojiKeywordsDifference(TLRequest):
    """
    :returns EmojiKeywordsDifference: Instance of EmojiKeywordsDifference.
    """
    __slots__ = ('lang_code', 'from_version',)
    CONSTRUCTOR_ID = 0x1508b6af
    SUBCLASS_OF_ID = 0xd279c672

    lang_code: str
    from_version: int
    def __init__(self, lang_code: str, from_version: int):
        object.__setattr__(self, 'lang_code', lang_code)
        object.__setattr__(self, 'from_version', from_version)

    def _bytes(self):
        return b''.join((
            b'\xaf\xb6\x08\x15',
            self._serialize_bytes(self.lang_code),
            struct.pack('<i', self.from_version),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        _from_version = reader.read_int()
        return cls(lang_code=_lang_code, from_version=_from_version)


@dataclasses.dataclass(init=False, frozen=True)
class GetEmojiKeywordsLanguages(TLRequest):
    """
    :returns Vector<EmojiLanguage>: This type has no constructors.
    """
    __slots__ = ('lang_codes',)
    CONSTRUCTOR_ID = 0x4e9963b2
    SUBCLASS_OF_ID = 0xe795d387

    lang_codes: List[str]
    def __init__(self, lang_codes: List[str]):
        object.__setattr__(self, 'lang_codes', lang_codes)

    def _bytes(self):
        return b''.join((
            b'\xb2c\x99N',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.lang_codes)),b''.join(self._serialize_bytes(x) for x in self.lang_codes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _lang_codes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _lang_codes.append(_x)

        return cls(lang_codes=_lang_codes)


@dataclasses.dataclass(init=False, frozen=True)
class GetEmojiURL(TLRequest):
    """
    :returns EmojiURL: Instance of EmojiURL.
    """
    __slots__ = ('lang_code',)
    CONSTRUCTOR_ID = 0xd5b10c26
    SUBCLASS_OF_ID = 0x1fa08a19

    lang_code: str
    def __init__(self, lang_code: str):
        object.__setattr__(self, 'lang_code', lang_code)

    def _bytes(self):
        return b''.join((
            b'&\x0c\xb1\xd5',
            self._serialize_bytes(self.lang_code),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        return cls(lang_code=_lang_code)


@dataclasses.dataclass(init=False, frozen=True)
class GetExportedChatInvite(TLRequest):
    """
    :returns messages.ExportedChatInvite: Instance of either ExportedChatInvite, ExportedChatInviteReplaced.
    """
    __slots__ = ('peer', 'link',)
    CONSTRUCTOR_ID = 0x73746f5c
    SUBCLASS_OF_ID = 0x82dcd4ca

    peer: 'TypeInputPeer'
    link: str
    def __init__(self, peer: 'TypeInputPeer', link: str):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'link', link)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\\ots',
            self.peer._bytes(),
            self._serialize_bytes(self.link),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _link = reader.tgread_string()
        return cls(peer=_peer, link=_link)


@dataclasses.dataclass(init=False, frozen=True)
class GetExportedChatInvites(TLRequest):
    """
    :returns messages.ExportedChatInvites: Instance of ExportedChatInvites.
    """
    __slots__ = ('peer', 'admin_id', 'limit', 'revoked', 'offset_date', 'offset_link',)
    CONSTRUCTOR_ID = 0xa2b5a3f6
    SUBCLASS_OF_ID = 0x603d3871

    peer: 'TypeInputPeer'
    admin_id: 'TypeInputUser'
    limit: int
    revoked: Optional[bool]
    offset_date: Optional[datetime]
    offset_link: Optional[str]
    def __init__(self, peer: 'TypeInputPeer', admin_id: 'TypeInputUser', limit: int, revoked: Optional[bool]=None, offset_date: Optional[datetime]=None, offset_link: Optional[str]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'admin_id', admin_id)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'revoked', revoked)
        object.__setattr__(self, 'offset_date', offset_date)
        object.__setattr__(self, 'offset_link', offset_link)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        r['admin_id'] = utils.get_input_user(await client._get_input_peer(self.admin_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        assert ((self.offset_date or self.offset_date is not None) and (self.offset_link or self.offset_link is not None)) or ((self.offset_date is None or self.offset_date is False) and (self.offset_link is None or self.offset_link is False)), 'offset_date, offset_link parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xf6\xa3\xb5\xa2',
            struct.pack('<I', (0 if self.revoked is None or self.revoked is False else 8) | (0 if self.offset_date is None or self.offset_date is False else 4) | (0 if self.offset_link is None or self.offset_link is False else 4)),
            self.peer._bytes(),
            self.admin_id._bytes(),
            b'' if self.offset_date is None or self.offset_date is False else (self._serialize_datetime(self.offset_date)),
            b'' if self.offset_link is None or self.offset_link is False else (self._serialize_bytes(self.offset_link)),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _revoked = bool(flags & 8)
        _peer = reader.tgread_object()
        _admin_id = reader.tgread_object()
        if flags & 4:
            _offset_date = reader.tgread_date()
        else:
            _offset_date = None
        if flags & 4:
            _offset_link = reader.tgread_string()
        else:
            _offset_link = None
        _limit = reader.read_int()
        return cls(peer=_peer, admin_id=_admin_id, limit=_limit, revoked=_revoked, offset_date=_offset_date, offset_link=_offset_link)


@dataclasses.dataclass(init=False, frozen=True)
class GetFavedStickers(TLRequest):
    """
    :returns messages.FavedStickers: Instance of either FavedStickersNotModified, FavedStickers.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0x4f1aaa9
    SUBCLASS_OF_ID = 0x8e736fb9

    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\xa9\xaa\xf1\x04',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetFeaturedStickers(TLRequest):
    """
    :returns messages.FeaturedStickers: Instance of either FeaturedStickersNotModified, FeaturedStickers.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0x64780b14
    SUBCLASS_OF_ID = 0x2614b722

    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\x14\x0bxd',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetFullChat(TLRequest):
    """
    :returns messages.ChatFull: Instance of ChatFull.
    """
    __slots__ = ('chat_id',)
    CONSTRUCTOR_ID = 0xaeb00b34
    SUBCLASS_OF_ID = 0x225a5109

    chat_id: int
    def __init__(self, chat_id: int):
        object.__setattr__(self, 'chat_id', chat_id)

    def _bytes(self):
        return b''.join((
            b'4\x0b\xb0\xae',
            struct.pack('<q', self.chat_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat_id = reader.read_long()
        return cls(chat_id=_chat_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetGameHighScores(TLRequest):
    """
    :returns messages.HighScores: Instance of HighScores.
    """
    __slots__ = ('peer', 'id', 'user_id',)
    CONSTRUCTOR_ID = 0xe822649d
    SUBCLASS_OF_ID = 0x6ccd95fd

    peer: 'TypeInputPeer'
    id: int
    user_id: 'TypeInputUser'
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int, user_id: 'TypeInputUser'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'user_id', user_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x9dd"\xe8',
            self.peer._bytes(),
            struct.pack('<i', self.id),
            self.user_id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _id = reader.read_int()
        _user_id = reader.tgread_object()
        return cls(peer=_peer, id=_id, user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetHistory(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('peer', 'offset_id', 'offset_date', 'add_offset', 'limit', 'max_id', 'min_id', 'hash',)
    CONSTRUCTOR_ID = 0x4423e6c5
    SUBCLASS_OF_ID = 0xd4b40b5e

    peer: 'TypeInputPeer'
    offset_id: int
    offset_date: Optional[datetime]
    add_offset: int
    limit: int
    max_id: int
    min_id: int
    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', offset_id: int, offset_date: Optional[datetime], add_offset: int, limit: int, max_id: int, min_id: int, hash: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'offset_id', offset_id)
        object.__setattr__(self, 'offset_date', offset_date)
        object.__setattr__(self, 'add_offset', add_offset)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'max_id', max_id)
        object.__setattr__(self, 'min_id', min_id)
        object.__setattr__(self, 'hash', hash)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xc5\xe6#D',
            self.peer._bytes(),
            struct.pack('<i', self.offset_id),
            self._serialize_datetime(self.offset_date),
            struct.pack('<i', self.add_offset),
            struct.pack('<i', self.limit),
            struct.pack('<i', self.max_id),
            struct.pack('<i', self.min_id),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _offset_id = reader.read_int()
        _offset_date = reader.tgread_date()
        _add_offset = reader.read_int()
        _limit = reader.read_int()
        _max_id = reader.read_int()
        _min_id = reader.read_int()
        _hash = reader.read_long()
        return cls(peer=_peer, offset_id=_offset_id, offset_date=_offset_date, add_offset=_add_offset, limit=_limit, max_id=_max_id, min_id=_min_id, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetInlineBotResults(TLRequest):
    """
    :returns messages.BotResults: Instance of BotResults.
    """
    __slots__ = ('bot', 'peer', 'query', 'offset', 'geo_point',)
    CONSTRUCTOR_ID = 0x514e999d
    SUBCLASS_OF_ID = 0x3ed4d9c9

    bot: 'TypeInputUser'
    peer: 'TypeInputPeer'
    query: str
    offset: str
    geo_point: Optional['TypeInputGeoPoint']
    def __init__(self, bot: 'TypeInputUser', peer: 'TypeInputPeer', query: str, offset: str, geo_point: Optional['TypeInputGeoPoint']=None):
        object.__setattr__(self, 'bot', bot)
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'query', query)
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'geo_point', geo_point)

    async def _resolve(self, client, utils):
        r = {}
        r['bot'] = utils.get_input_user(await client._get_input_peer(self.bot))
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x9d\x99NQ',
            struct.pack('<I', (0 if self.geo_point is None or self.geo_point is False else 1)),
            self.bot._bytes(),
            self.peer._bytes(),
            b'' if self.geo_point is None or self.geo_point is False else (self.geo_point._bytes()),
            self._serialize_bytes(self.query),
            self._serialize_bytes(self.offset),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _bot = reader.tgread_object()
        _peer = reader.tgread_object()
        if flags & 1:
            _geo_point = reader.tgread_object()
        else:
            _geo_point = None
        _query = reader.tgread_string()
        _offset = reader.tgread_string()
        return cls(bot=_bot, peer=_peer, query=_query, offset=_offset, geo_point=_geo_point)


@dataclasses.dataclass(init=False, frozen=True)
class GetInlineGameHighScores(TLRequest):
    """
    :returns messages.HighScores: Instance of HighScores.
    """
    __slots__ = ('id', 'user_id',)
    CONSTRUCTOR_ID = 0xf635e1b
    SUBCLASS_OF_ID = 0x6ccd95fd

    id: 'TypeInputBotInlineMessageID'
    user_id: 'TypeInputUser'
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputBotInlineMessageID', user_id: 'TypeInputUser'):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'user_id', user_id)

    async def _resolve(self, client, utils):
        r = {}
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x1b^c\x0f',
            self.id._bytes(),
            self.user_id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_object()
        _user_id = reader.tgread_object()
        return cls(id=_id, user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetMaskStickers(TLRequest):
    """
    :returns messages.AllStickers: Instance of either AllStickersNotModified, AllStickers.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0x640f82b8
    SUBCLASS_OF_ID = 0x45834829

    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\xb8\x82\x0fd',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetMessageEditData(TLRequest):
    """
    :returns messages.MessageEditData: Instance of MessageEditData.
    """
    __slots__ = ('peer', 'id',)
    CONSTRUCTOR_ID = 0xfda68d36
    SUBCLASS_OF_ID = 0xfb47949d

    peer: 'TypeInputPeer'
    id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'6\x8d\xa6\xfd',
            self.peer._bytes(),
            struct.pack('<i', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _id = reader.read_int()
        return cls(peer=_peer, id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetMessageReactionsList(TLRequest):
    """
    :returns messages.MessageReactionsList: Instance of MessageReactionsList.
    """
    __slots__ = ('peer', 'id', 'limit', 'reaction', 'offset',)
    CONSTRUCTOR_ID = 0xe0ee6b77
    SUBCLASS_OF_ID = 0x60fce5e6

    peer: 'TypeInputPeer'
    id: int
    limit: int
    reaction: Optional[str]
    offset: Optional[str]
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int, limit: int, reaction: Optional[str]=None, offset: Optional[str]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'reaction', reaction)
        object.__setattr__(self, 'offset', offset)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'wk\xee\xe0',
            struct.pack('<I', (0 if self.reaction is None or self.reaction is False else 1) | (0 if self.offset is None or self.offset is False else 2)),
            self.peer._bytes(),
            struct.pack('<i', self.id),
            b'' if self.reaction is None or self.reaction is False else (self._serialize_bytes(self.reaction)),
            b'' if self.offset is None or self.offset is False else (self._serialize_bytes(self.offset)),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _peer = reader.tgread_object()
        _id = reader.read_int()
        if flags & 1:
            _reaction = reader.tgread_string()
        else:
            _reaction = None
        if flags & 2:
            _offset = reader.tgread_string()
        else:
            _offset = None
        _limit = reader.read_int()
        return cls(peer=_peer, id=_id, limit=_limit, reaction=_reaction, offset=_offset)


@dataclasses.dataclass(init=False, frozen=True)
class GetMessageReadParticipants(TLRequest):
    """
    :returns Vector<long>: This type has no constructors.
    """
    __slots__ = ('peer', 'msg_id',)
    CONSTRUCTOR_ID = 0x2c6f97b7
    SUBCLASS_OF_ID = 0x8918e168

    peer: 'TypeInputPeer'
    msg_id: int
    def __init__(self, peer: 'TypeInputPeer', msg_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xb7\x97o,',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id)

    @staticmethod
    def _read_result(reader):
        reader.read_int()  # Vector ID
        return [reader.read_long() for _ in range(reader.read_int())]


@dataclasses.dataclass(init=False, frozen=True)
class GetMessages(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x63c66506
    SUBCLASS_OF_ID = 0xd4b40b5e

    id: List['TypeInputMessage']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: List['TypeInputMessage']):
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['id'] = []
        for x in self.id:
            r['id'].append(utils.get_input_message(x))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x06e\xc6c',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(x._bytes() for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _id.append(_x)

        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetMessagesReactions(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'id',)
    CONSTRUCTOR_ID = 0x8bba90e6
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    id: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: List[int]):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xe6\x90\xba\x8b',
            self.peer._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(peer=_peer, id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetMessagesViews(TLRequest):
    """
    :returns messages.MessageViews: Instance of MessageViews.
    """
    __slots__ = ('peer', 'id', 'increment',)
    CONSTRUCTOR_ID = 0x5784d3e1
    SUBCLASS_OF_ID = 0xafb5eb9c

    peer: 'TypeInputPeer'
    id: List[int]
    increment: bool
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: List[int], increment: bool):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'increment', increment)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xe1\xd3\x84W',
            self.peer._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
            b'\xb5ur\x99' if self.increment else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        _increment = reader.tgread_bool()
        return cls(peer=_peer, id=_id, increment=_increment)


@dataclasses.dataclass(init=False, frozen=True)
class GetOldFeaturedStickers(TLRequest):
    """
    :returns messages.FeaturedStickers: Instance of either FeaturedStickersNotModified, FeaturedStickers.
    """
    __slots__ = ('offset', 'limit', 'hash',)
    CONSTRUCTOR_ID = 0x7ed094a1
    SUBCLASS_OF_ID = 0x2614b722

    offset: int
    limit: int
    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, offset: int, limit: int, hash: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\xa1\x94\xd0~',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.limit),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _limit = reader.read_int()
        _hash = reader.read_long()
        return cls(offset=_offset, limit=_limit, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetOnlines(TLRequest):
    """
    :returns ChatOnlines: Instance of ChatOnlines.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0x6e2be050
    SUBCLASS_OF_ID = 0x8c81903a

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'P\xe0+n',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class GetPeerDialogs(TLRequest):
    """
    :returns messages.PeerDialogs: Instance of PeerDialogs.
    """
    __slots__ = ('peers',)
    CONSTRUCTOR_ID = 0xe470bcfd
    SUBCLASS_OF_ID = 0x3ac70132

    peers: List['TypeInputDialogPeer']
    def __init__(self, peers: List['TypeInputDialogPeer']):
        object.__setattr__(self, 'peers', peers)

    async def _resolve(self, client, utils):
        r = {}
        r['peers'] = []
        for x in self.peers:
            r['peers'].append(await client._get_input_dialog(x))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xfd\xbcp\xe4',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.peers)),b''.join(x._bytes() for x in self.peers),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _peers.append(_x)

        return cls(peers=_peers)


@dataclasses.dataclass(init=False, frozen=True)
class GetPeerSettings(TLRequest):
    """
    :returns messages.PeerSettings: Instance of PeerSettings.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0xefd9a6a2
    SUBCLASS_OF_ID = 0x65a2f7a1

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xa2\xa6\xd9\xef',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class GetPinnedDialogs(TLRequest):
    """
    :returns messages.PeerDialogs: Instance of PeerDialogs.
    """
    __slots__ = ('folder_id',)
    CONSTRUCTOR_ID = 0xd6b94df2
    SUBCLASS_OF_ID = 0x3ac70132

    folder_id: int
    def __init__(self, folder_id: int):
        object.__setattr__(self, 'folder_id', folder_id)

    def _bytes(self):
        return b''.join((
            b'\xf2M\xb9\xd6',
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _folder_id = reader.read_int()
        return cls(folder_id=_folder_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetPollResults(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'msg_id',)
    CONSTRUCTOR_ID = 0x73bb643b
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    msg_id: int
    def __init__(self, peer: 'TypeInputPeer', msg_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b';d\xbbs',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetPollVotes(TLRequest):
    """
    :returns messages.VotesList: Instance of VotesList.
    """
    __slots__ = ('peer', 'id', 'limit', 'option', 'offset',)
    CONSTRUCTOR_ID = 0xb86e380e
    SUBCLASS_OF_ID = 0xc2199885

    peer: 'TypeInputPeer'
    id: int
    limit: int
    option: Optional[bytes]
    offset: Optional[str]
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int, limit: int, option: Optional[bytes]=None, offset: Optional[str]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'option', option)
        object.__setattr__(self, 'offset', offset)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x0e8n\xb8',
            struct.pack('<I', (0 if self.option is None or self.option is False else 1) | (0 if self.offset is None or self.offset is False else 2)),
            self.peer._bytes(),
            struct.pack('<i', self.id),
            b'' if self.option is None or self.option is False else (self._serialize_bytes(self.option)),
            b'' if self.offset is None or self.offset is False else (self._serialize_bytes(self.offset)),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _peer = reader.tgread_object()
        _id = reader.read_int()
        if flags & 1:
            _option = reader.tgread_bytes()
        else:
            _option = None
        if flags & 2:
            _offset = reader.tgread_string()
        else:
            _offset = None
        _limit = reader.read_int()
        return cls(peer=_peer, id=_id, limit=_limit, option=_option, offset=_offset)


@dataclasses.dataclass(init=False, frozen=True)
class GetRecentLocations(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('peer', 'limit', 'hash',)
    CONSTRUCTOR_ID = 0x702a40e0
    SUBCLASS_OF_ID = 0xd4b40b5e

    peer: 'TypeInputPeer'
    limit: int
    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', limit: int, hash: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'hash', hash)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xe0@*p',
            self.peer._bytes(),
            struct.pack('<i', self.limit),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _limit = reader.read_int()
        _hash = reader.read_long()
        return cls(peer=_peer, limit=_limit, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetRecentStickers(TLRequest):
    """
    :returns messages.RecentStickers: Instance of either RecentStickersNotModified, RecentStickers.
    """
    __slots__ = ('hash', 'attached',)
    CONSTRUCTOR_ID = 0x9da9403b
    SUBCLASS_OF_ID = 0xf76f8683

    hash: int
    attached: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, attached: Optional[bool]=None):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'attached', attached)

    def _bytes(self):
        return b''.join((
            b';@\xa9\x9d',
            struct.pack('<I', (0 if self.attached is None or self.attached is False else 1)),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _attached = bool(flags & 1)
        _hash = reader.read_long()
        return cls(hash=_hash, attached=_attached)


@dataclasses.dataclass(init=False, frozen=True)
class GetReplies(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('peer', 'msg_id', 'offset_id', 'offset_date', 'add_offset', 'limit', 'max_id', 'min_id', 'hash',)
    CONSTRUCTOR_ID = 0x22ddd30c
    SUBCLASS_OF_ID = 0xd4b40b5e

    peer: 'TypeInputPeer'
    msg_id: int
    offset_id: int
    offset_date: Optional[datetime]
    add_offset: int
    limit: int
    max_id: int
    min_id: int
    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', msg_id: int, offset_id: int, offset_date: Optional[datetime], add_offset: int, limit: int, max_id: int, min_id: int, hash: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'offset_id', offset_id)
        object.__setattr__(self, 'offset_date', offset_date)
        object.__setattr__(self, 'add_offset', add_offset)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'max_id', max_id)
        object.__setattr__(self, 'min_id', min_id)
        object.__setattr__(self, 'hash', hash)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x0c\xd3\xdd"',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            struct.pack('<i', self.offset_id),
            self._serialize_datetime(self.offset_date),
            struct.pack('<i', self.add_offset),
            struct.pack('<i', self.limit),
            struct.pack('<i', self.max_id),
            struct.pack('<i', self.min_id),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _offset_id = reader.read_int()
        _offset_date = reader.tgread_date()
        _add_offset = reader.read_int()
        _limit = reader.read_int()
        _max_id = reader.read_int()
        _min_id = reader.read_int()
        _hash = reader.read_long()
        return cls(peer=_peer, msg_id=_msg_id, offset_id=_offset_id, offset_date=_offset_date, add_offset=_add_offset, limit=_limit, max_id=_max_id, min_id=_min_id, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetSavedGifs(TLRequest):
    """
    :returns messages.SavedGifs: Instance of either SavedGifsNotModified, SavedGifs.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0x5cf09635
    SUBCLASS_OF_ID = 0xa68b61f5

    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'5\x96\xf0\\',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetScheduledHistory(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('peer', 'hash',)
    CONSTRUCTOR_ID = 0xf516760b
    SUBCLASS_OF_ID = 0xd4b40b5e

    peer: 'TypeInputPeer'
    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', hash: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'hash', hash)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x0bv\x16\xf5',
            self.peer._bytes(),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _hash = reader.read_long()
        return cls(peer=_peer, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetScheduledMessages(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('peer', 'id',)
    CONSTRUCTOR_ID = 0xbdbb0464
    SUBCLASS_OF_ID = 0xd4b40b5e

    peer: 'TypeInputPeer'
    id: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: List[int]):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'd\x04\xbb\xbd',
            self.peer._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(peer=_peer, id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetSearchCounters(TLRequest):
    """
    :returns Vector<messages.SearchCounter>: This type has no constructors.
    """
    __slots__ = ('peer', 'filters',)
    CONSTRUCTOR_ID = 0x732eef00
    SUBCLASS_OF_ID = 0x6bde3c6e

    peer: 'TypeInputPeer'
    filters: List['TypeMessagesFilter']
    def __init__(self, peer: 'TypeInputPeer', filters: List['TypeMessagesFilter']):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'filters', filters)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x00\xef.s',
            self.peer._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.filters)),b''.join(x._bytes() for x in self.filters),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _filters = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _filters.append(_x)

        return cls(peer=_peer, filters=_filters)


@dataclasses.dataclass(init=False, frozen=True)
class GetSearchResultsCalendar(TLRequest):
    """
    :returns messages.SearchResultsCalendar: Instance of SearchResultsCalendar.
    """
    __slots__ = ('peer', 'filter', 'offset_id', 'offset_date',)
    CONSTRUCTOR_ID = 0x49f0bde9
    SUBCLASS_OF_ID = 0x92c5640f

    peer: 'TypeInputPeer'
    filter: 'TypeMessagesFilter'
    offset_id: int
    offset_date: Optional[datetime]
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', filter: 'TypeMessagesFilter', offset_id: int, offset_date: Optional[datetime]):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'filter', filter)
        object.__setattr__(self, 'offset_id', offset_id)
        object.__setattr__(self, 'offset_date', offset_date)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xe9\xbd\xf0I',
            self.peer._bytes(),
            self.filter._bytes(),
            struct.pack('<i', self.offset_id),
            self._serialize_datetime(self.offset_date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _filter = reader.tgread_object()
        _offset_id = reader.read_int()
        _offset_date = reader.tgread_date()
        return cls(peer=_peer, filter=_filter, offset_id=_offset_id, offset_date=_offset_date)


@dataclasses.dataclass(init=False, frozen=True)
class GetSearchResultsPositions(TLRequest):
    """
    :returns messages.SearchResultsPositions: Instance of SearchResultsPositions.
    """
    __slots__ = ('peer', 'filter', 'offset_id', 'limit',)
    CONSTRUCTOR_ID = 0x6e9583a3
    SUBCLASS_OF_ID = 0xd963708d

    peer: 'TypeInputPeer'
    filter: 'TypeMessagesFilter'
    offset_id: int
    limit: int
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', filter: 'TypeMessagesFilter', offset_id: int, limit: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'filter', filter)
        object.__setattr__(self, 'offset_id', offset_id)
        object.__setattr__(self, 'limit', limit)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xa3\x83\x95n',
            self.peer._bytes(),
            self.filter._bytes(),
            struct.pack('<i', self.offset_id),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _filter = reader.tgread_object()
        _offset_id = reader.read_int()
        _limit = reader.read_int()
        return cls(peer=_peer, filter=_filter, offset_id=_offset_id, limit=_limit)


@dataclasses.dataclass(init=False, frozen=True)
class GetSplitRanges(TLRequest):
    """
    :returns Vector<MessageRange>: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x1cff7e08
    SUBCLASS_OF_ID = 0x5ba52504

    def _bytes(self):
        return b''.join((
            b'\x08~\xff\x1c',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetStickerSet(TLRequest):
    """
    :returns messages.StickerSet: Instance of either StickerSet, StickerSetNotModified.
    """
    __slots__ = ('stickerset', 'hash',)
    CONSTRUCTOR_ID = 0xc8a0ec74
    SUBCLASS_OF_ID = 0x9b704a5a

    stickerset: 'TypeInputStickerSet'
    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, stickerset: 'TypeInputStickerSet', hash: int):
        object.__setattr__(self, 'stickerset', stickerset)
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b't\xec\xa0\xc8',
            self.stickerset._bytes(),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        _hash = reader.read_int()
        return cls(stickerset=_stickerset, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetStickers(TLRequest):
    """
    :returns messages.Stickers: Instance of either StickersNotModified, Stickers.
    """
    __slots__ = ('emoticon', 'hash',)
    CONSTRUCTOR_ID = 0xd5a5d3a1
    SUBCLASS_OF_ID = 0xd73bb9de

    emoticon: str
    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, emoticon: str, hash: int):
        object.__setattr__(self, 'emoticon', emoticon)
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\xa1\xd3\xa5\xd5',
            self._serialize_bytes(self.emoticon),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _emoticon = reader.tgread_string()
        _hash = reader.read_long()
        return cls(emoticon=_emoticon, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetSuggestedDialogFilters(TLRequest):
    """
    :returns Vector<DialogFilterSuggested>: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xa29cd42c
    SUBCLASS_OF_ID = 0x7b296c39

    def _bytes(self):
        return b''.join((
            b',\xd4\x9c\xa2',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetUnreadMentions(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('peer', 'offset_id', 'add_offset', 'limit', 'max_id', 'min_id',)
    CONSTRUCTOR_ID = 0x46578472
    SUBCLASS_OF_ID = 0xd4b40b5e

    peer: 'TypeInputPeer'
    offset_id: int
    add_offset: int
    limit: int
    max_id: int
    min_id: int
    def __init__(self, peer: 'TypeInputPeer', offset_id: int, add_offset: int, limit: int, max_id: int, min_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'offset_id', offset_id)
        object.__setattr__(self, 'add_offset', add_offset)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'max_id', max_id)
        object.__setattr__(self, 'min_id', min_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'r\x84WF',
            self.peer._bytes(),
            struct.pack('<i', self.offset_id),
            struct.pack('<i', self.add_offset),
            struct.pack('<i', self.limit),
            struct.pack('<i', self.max_id),
            struct.pack('<i', self.min_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _offset_id = reader.read_int()
        _add_offset = reader.read_int()
        _limit = reader.read_int()
        _max_id = reader.read_int()
        _min_id = reader.read_int()
        return cls(peer=_peer, offset_id=_offset_id, add_offset=_add_offset, limit=_limit, max_id=_max_id, min_id=_min_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetUnreadReactions(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('peer', 'offset_id', 'add_offset', 'limit', 'max_id', 'min_id',)
    CONSTRUCTOR_ID = 0xe85bae1a
    SUBCLASS_OF_ID = 0xd4b40b5e

    peer: 'TypeInputPeer'
    offset_id: int
    add_offset: int
    limit: int
    max_id: int
    min_id: int
    def __init__(self, peer: 'TypeInputPeer', offset_id: int, add_offset: int, limit: int, max_id: int, min_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'offset_id', offset_id)
        object.__setattr__(self, 'add_offset', add_offset)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'max_id', max_id)
        object.__setattr__(self, 'min_id', min_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x1a\xae[\xe8',
            self.peer._bytes(),
            struct.pack('<i', self.offset_id),
            struct.pack('<i', self.add_offset),
            struct.pack('<i', self.limit),
            struct.pack('<i', self.max_id),
            struct.pack('<i', self.min_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _offset_id = reader.read_int()
        _add_offset = reader.read_int()
        _limit = reader.read_int()
        _max_id = reader.read_int()
        _min_id = reader.read_int()
        return cls(peer=_peer, offset_id=_offset_id, add_offset=_add_offset, limit=_limit, max_id=_max_id, min_id=_min_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetWebPage(TLRequest):
    """
    :returns WebPage: Instance of either WebPageEmpty, WebPagePending, WebPage, WebPageNotModified.
    """
    __slots__ = ('url', 'hash',)
    CONSTRUCTOR_ID = 0x32ca8f91
    SUBCLASS_OF_ID = 0x55a97481

    url: str
    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, url: str, hash: int):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\x91\x8f\xca2',
            self._serialize_bytes(self.url),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _url = reader.tgread_string()
        _hash = reader.read_int()
        return cls(url=_url, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetWebPagePreview(TLRequest):
    """
    :returns MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('message', 'entities',)
    CONSTRUCTOR_ID = 0x8b68b0cc
    SUBCLASS_OF_ID = 0x476cbe32

    message: str
    entities: Optional[List['TypeMessageEntity']]
    def __init__(self, message: str, entities: Optional[List['TypeMessageEntity']]=None):
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'entities', entities)

    def _bytes(self):
        return b''.join((
            b'\xcc\xb0h\x8b',
            struct.pack('<I', (0 if self.entities is None or self.entities is False else 8)),
            self._serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _message = reader.tgread_string()
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(message=_message, entities=_entities)


@dataclasses.dataclass(init=False, frozen=True)
class HideAllChatJoinRequests(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'approved', 'link',)
    CONSTRUCTOR_ID = 0xe085f4ea
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    approved: Optional[bool]
    link: Optional[str]
    def __init__(self, peer: 'TypeInputPeer', approved: Optional[bool]=None, link: Optional[str]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'approved', approved)
        object.__setattr__(self, 'link', link)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xea\xf4\x85\xe0',
            struct.pack('<I', (0 if self.approved is None or self.approved is False else 1) | (0 if self.link is None or self.link is False else 2)),
            self.peer._bytes(),
            b'' if self.link is None or self.link is False else (self._serialize_bytes(self.link)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _approved = bool(flags & 1)
        _peer = reader.tgread_object()
        if flags & 2:
            _link = reader.tgread_string()
        else:
            _link = None
        return cls(peer=_peer, approved=_approved, link=_link)


@dataclasses.dataclass(init=False, frozen=True)
class HideChatJoinRequest(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'user_id', 'approved',)
    CONSTRUCTOR_ID = 0x7fe7e815
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    user_id: 'TypeInputUser'
    approved: Optional[bool]
    def __init__(self, peer: 'TypeInputPeer', user_id: 'TypeInputUser', approved: Optional[bool]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'approved', approved)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x15\xe8\xe7\x7f',
            struct.pack('<I', (0 if self.approved is None or self.approved is False else 1)),
            self.peer._bytes(),
            self.user_id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _approved = bool(flags & 1)
        _peer = reader.tgread_object()
        _user_id = reader.tgread_object()
        return cls(peer=_peer, user_id=_user_id, approved=_approved)


@dataclasses.dataclass(init=False, frozen=True)
class HidePeerSettingsBar(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0x4facb138
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'8\xb1\xacO',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class ImportChatInvite(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0x6c50051c
    SUBCLASS_OF_ID = 0x8af52aac

    hash: str
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: str):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\x1c\x05Pl',
            self._serialize_bytes(self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.tgread_string()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InitHistoryImport(TLRequest):
    """
    :returns messages.HistoryImport: Instance of HistoryImport.
    """
    __slots__ = ('peer', 'file', 'media_count',)
    CONSTRUCTOR_ID = 0x34090c3b
    SUBCLASS_OF_ID = 0xb18bb50a

    peer: 'TypeInputPeer'
    file: 'TypeInputFile'
    media_count: int
    def __init__(self, peer: 'TypeInputPeer', file: 'TypeInputFile', media_count: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'file', file)
        object.__setattr__(self, 'media_count', media_count)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b';\x0c\t4',
            self.peer._bytes(),
            self.file._bytes(),
            struct.pack('<i', self.media_count),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _file = reader.tgread_object()
        _media_count = reader.read_int()
        return cls(peer=_peer, file=_file, media_count=_media_count)


@dataclasses.dataclass(init=False, frozen=True)
class InstallStickerSet(TLRequest):
    """
    :returns messages.StickerSetInstallResult: Instance of either StickerSetInstallResultSuccess, StickerSetInstallResultArchive.
    """
    __slots__ = ('stickerset', 'archived',)
    CONSTRUCTOR_ID = 0xc78fe460
    SUBCLASS_OF_ID = 0x67cb3fe8

    stickerset: 'TypeInputStickerSet'
    archived: bool
    def __init__(self, stickerset: 'TypeInputStickerSet', archived: bool):
        object.__setattr__(self, 'stickerset', stickerset)
        object.__setattr__(self, 'archived', archived)

    def _bytes(self):
        return b''.join((
            b'`\xe4\x8f\xc7',
            self.stickerset._bytes(),
            b'\xb5ur\x99' if self.archived else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        _archived = reader.tgread_bool()
        return cls(stickerset=_stickerset, archived=_archived)


@dataclasses.dataclass(init=False, frozen=True)
class MarkDialogUnread(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'unread',)
    CONSTRUCTOR_ID = 0xc286d98f
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputDialogPeer'
    unread: Optional[bool]
    def __init__(self, peer: 'TypeInputDialogPeer', unread: Optional[bool]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'unread', unread)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = await client._get_input_dialog(self.peer)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x8f\xd9\x86\xc2',
            struct.pack('<I', (0 if self.unread is None or self.unread is False else 1)),
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _unread = bool(flags & 1)
        _peer = reader.tgread_object()
        return cls(peer=_peer, unread=_unread)


@dataclasses.dataclass(init=False, frozen=True)
class MigrateChat(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('chat_id',)
    CONSTRUCTOR_ID = 0xa2875319
    SUBCLASS_OF_ID = 0x8af52aac

    chat_id: int
    def __init__(self, chat_id: int):
        object.__setattr__(self, 'chat_id', chat_id)

    def _bytes(self):
        return b''.join((
            b'\x19S\x87\xa2',
            struct.pack('<q', self.chat_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat_id = reader.read_long()
        return cls(chat_id=_chat_id)


@dataclasses.dataclass(init=False, frozen=True)
class ReadDiscussion(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'msg_id', 'read_max_id',)
    CONSTRUCTOR_ID = 0xf731a9f4
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    msg_id: int
    read_max_id: int
    def __init__(self, peer: 'TypeInputPeer', msg_id: int, read_max_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'read_max_id', read_max_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xf4\xa91\xf7',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            struct.pack('<i', self.read_max_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _read_max_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id, read_max_id=_read_max_id)


@dataclasses.dataclass(init=False, frozen=True)
class ReadEncryptedHistory(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'max_date',)
    CONSTRUCTOR_ID = 0x7f4b690a
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputEncryptedChat'
    max_date: Optional[datetime]
    def __init__(self, peer: 'TypeInputEncryptedChat', max_date: Optional[datetime]):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'max_date', max_date)

    def _bytes(self):
        return b''.join((
            b'\niK\x7f',
            self.peer._bytes(),
            self._serialize_datetime(self.max_date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _max_date = reader.tgread_date()
        return cls(peer=_peer, max_date=_max_date)


@dataclasses.dataclass(init=False, frozen=True)
class ReadFeaturedStickers(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x5b118126
    SUBCLASS_OF_ID = 0xf5b399ac

    id: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: List[int]):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'&\x81\x11[',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<q', x) for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _id.append(_x)

        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class ReadHistory(TLRequest):
    """
    :returns messages.AffectedMessages: Instance of AffectedMessages.
    """
    __slots__ = ('peer', 'max_id',)
    CONSTRUCTOR_ID = 0xe306d3a
    SUBCLASS_OF_ID = 0xced3c06e

    peer: 'TypeInputPeer'
    max_id: int
    def __init__(self, peer: 'TypeInputPeer', max_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'max_id', max_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b':m0\x0e',
            self.peer._bytes(),
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _max_id = reader.read_int()
        return cls(peer=_peer, max_id=_max_id)


@dataclasses.dataclass(init=False, frozen=True)
class ReadMentions(TLRequest):
    """
    :returns messages.AffectedHistory: Instance of AffectedHistory.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0xf0189d3
    SUBCLASS_OF_ID = 0x2c49c116

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xd3\x89\x01\x0f',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class ReadMessageContents(TLRequest):
    """
    :returns messages.AffectedMessages: Instance of AffectedMessages.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x36a73f77
    SUBCLASS_OF_ID = 0xced3c06e

    id: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: List[int]):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'w?\xa76',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class ReadReactions(TLRequest):
    """
    :returns messages.AffectedHistory: Instance of AffectedHistory.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0x82e251d7
    SUBCLASS_OF_ID = 0x2c49c116

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xd7Q\xe2\x82',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class ReceivedMessages(TLRequest):
    """
    :returns Vector<ReceivedNotifyMessage>: This type has no constructors.
    """
    __slots__ = ('max_id',)
    CONSTRUCTOR_ID = 0x5a954c0
    SUBCLASS_OF_ID = 0x8565f897

    max_id: int
    def __init__(self, max_id: int):
        object.__setattr__(self, 'max_id', max_id)

    def _bytes(self):
        return b''.join((
            b'\xc0T\xa9\x05',
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _max_id = reader.read_int()
        return cls(max_id=_max_id)


@dataclasses.dataclass(init=False, frozen=True)
class ReceivedQueue(TLRequest):
    """
    :returns Vector<long>: This type has no constructors.
    """
    __slots__ = ('max_qts',)
    CONSTRUCTOR_ID = 0x55a5bb66
    SUBCLASS_OF_ID = 0x8918e168

    max_qts: int
    def __init__(self, max_qts: int):
        object.__setattr__(self, 'max_qts', max_qts)

    def _bytes(self):
        return b''.join((
            b'f\xbb\xa5U',
            struct.pack('<i', self.max_qts),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _max_qts = reader.read_int()
        return cls(max_qts=_max_qts)

    @staticmethod
    def _read_result(reader):
        reader.read_int()  # Vector ID
        return [reader.read_long() for _ in range(reader.read_int())]


@dataclasses.dataclass(init=False, frozen=True)
class ReorderPinnedDialogs(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('folder_id', 'order', 'force',)
    CONSTRUCTOR_ID = 0x3b1adf37
    SUBCLASS_OF_ID = 0xf5b399ac

    folder_id: int
    order: List['TypeInputDialogPeer']
    force: Optional[bool]
    def __init__(self, folder_id: int, order: List['TypeInputDialogPeer'], force: Optional[bool]=None):
        object.__setattr__(self, 'folder_id', folder_id)
        object.__setattr__(self, 'order', order)
        object.__setattr__(self, 'force', force)

    async def _resolve(self, client, utils):
        r = {}
        r['order'] = []
        for x in self.order:
            r['order'].append(await client._get_input_dialog(x))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'7\xdf\x1a;',
            struct.pack('<I', (0 if self.force is None or self.force is False else 1)),
            struct.pack('<i', self.folder_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.order)),b''.join(x._bytes() for x in self.order),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _force = bool(flags & 1)
        _folder_id = reader.read_int()
        reader.read_int()
        _order = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _order.append(_x)

        return cls(folder_id=_folder_id, order=_order, force=_force)


@dataclasses.dataclass(init=False, frozen=True)
class ReorderStickerSets(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('order', 'masks',)
    CONSTRUCTOR_ID = 0x78337739
    SUBCLASS_OF_ID = 0xf5b399ac

    order: List[int]
    masks: Optional[bool]
    def __init__(self, order: List[int], masks: Optional[bool]=None):
        object.__setattr__(self, 'order', order)
        object.__setattr__(self, 'masks', masks)

    def _bytes(self):
        return b''.join((
            b'9w3x',
            struct.pack('<I', (0 if self.masks is None or self.masks is False else 1)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.order)),b''.join(struct.pack('<q', x) for x in self.order),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _masks = bool(flags & 1)
        reader.read_int()
        _order = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _order.append(_x)

        return cls(order=_order, masks=_masks)


@dataclasses.dataclass(init=False, frozen=True)
class Report(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'id', 'reason', 'message',)
    CONSTRUCTOR_ID = 0x8953ab4e
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    id: List[int]
    reason: 'TypeReportReason'
    message: str
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: List[int], reason: 'TypeReportReason', message: str):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'reason', reason)
        object.__setattr__(self, 'message', message)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'N\xabS\x89',
            self.peer._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
            self.reason._bytes(),
            self._serialize_bytes(self.message),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        _reason = reader.tgread_object()
        _message = reader.tgread_string()
        return cls(peer=_peer, id=_id, reason=_reason, message=_message)


@dataclasses.dataclass(init=False, frozen=True)
class ReportEncryptedSpam(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0x4b0c8c0f
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputEncryptedChat'
    def __init__(self, peer: 'TypeInputEncryptedChat'):
        object.__setattr__(self, 'peer', peer)

    def _bytes(self):
        return b''.join((
            b'\x0f\x8c\x0cK',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class ReportSpam(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0xcf1592db
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xdb\x92\x15\xcf',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class RequestEncryption(TLRequest):
    """
    :returns EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
    """
    __slots__ = ('user_id', 'g_a', 'random_id',)
    CONSTRUCTOR_ID = 0xf64daf43
    SUBCLASS_OF_ID = 0x6d28a37a

    user_id: 'TypeInputUser'
    g_a: bytes
    random_id: int
    def __init__(self, user_id: 'TypeInputUser', g_a: bytes, random_id: int=None):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'g_a', g_a)
        object.__setattr__(self, 'random_id', random_id)

    async def _resolve(self, client, utils):
        r = {}
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        if self.random_id is None:
            r['random_id'] = int.from_bytes(os.urandom(4), 'big', signed=True)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'C\xafM\xf6',
            self.user_id._bytes(),
            struct.pack('<i', self.random_id),
            self._serialize_bytes(self.g_a),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.tgread_object()
        _random_id = reader.read_int()
        _g_a = reader.tgread_bytes()
        return cls(user_id=_user_id, g_a=_g_a, random_id=_random_id)


@dataclasses.dataclass(init=False, frozen=True)
class RequestUrlAuth(TLRequest):
    """
    :returns UrlAuthResult: Instance of either UrlAuthResultRequest, UrlAuthResultAccepted, UrlAuthResultDefault.
    """
    __slots__ = ('peer', 'msg_id', 'button_id', 'url',)
    CONSTRUCTOR_ID = 0x198fb446
    SUBCLASS_OF_ID = 0x7765cb1e

    peer: Optional['TypeInputPeer']
    msg_id: Optional[int]
    button_id: Optional[int]
    url: Optional[str]
    def __init__(self, peer: Optional['TypeInputPeer']=None, msg_id: Optional[int]=None, button_id: Optional[int]=None, url: Optional[str]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'button_id', button_id)
        object.__setattr__(self, 'url', url)

    async def _resolve(self, client, utils):
        r = {}
        if self.peer:
            r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        assert ((self.peer or self.peer is not None) and (self.msg_id or self.msg_id is not None) and (self.button_id or self.button_id is not None)) or ((self.peer is None or self.peer is False) and (self.msg_id is None or self.msg_id is False) and (self.button_id is None or self.button_id is False)), 'peer, msg_id, button_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'F\xb4\x8f\x19',
            struct.pack('<I', (0 if self.peer is None or self.peer is False else 2) | (0 if self.msg_id is None or self.msg_id is False else 2) | (0 if self.button_id is None or self.button_id is False else 2) | (0 if self.url is None or self.url is False else 4)),
            b'' if self.peer is None or self.peer is False else (self.peer._bytes()),
            b'' if self.msg_id is None or self.msg_id is False else (struct.pack('<i', self.msg_id)),
            b'' if self.button_id is None or self.button_id is False else (struct.pack('<i', self.button_id)),
            b'' if self.url is None or self.url is False else (self._serialize_bytes(self.url)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 2:
            _peer = reader.tgread_object()
        else:
            _peer = None
        if flags & 2:
            _msg_id = reader.read_int()
        else:
            _msg_id = None
        if flags & 2:
            _button_id = reader.read_int()
        else:
            _button_id = None
        if flags & 4:
            _url = reader.tgread_string()
        else:
            _url = None
        return cls(peer=_peer, msg_id=_msg_id, button_id=_button_id, url=_url)


@dataclasses.dataclass(init=False, frozen=True)
class SaveDefaultSendAs(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'send_as',)
    CONSTRUCTOR_ID = 0xccfddf96
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    send_as: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer', send_as: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'send_as', send_as)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        r['send_as'] = utils.get_input_peer(await client._get_input_peer(self.send_as))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x96\xdf\xfd\xcc',
            self.peer._bytes(),
            self.send_as._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _send_as = reader.tgread_object()
        return cls(peer=_peer, send_as=_send_as)


@dataclasses.dataclass(init=False, frozen=True)
class SaveDraft(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'message', 'no_webpage', 'reply_to_msg_id', 'entities',)
    CONSTRUCTOR_ID = 0xbc39e14b
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    message: str
    no_webpage: Optional[bool]
    reply_to_msg_id: Optional[int]
    entities: Optional[List['TypeMessageEntity']]
    def __init__(self, peer: 'TypeInputPeer', message: str, no_webpage: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, entities: Optional[List['TypeMessageEntity']]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'no_webpage', no_webpage)
        object.__setattr__(self, 'reply_to_msg_id', reply_to_msg_id)
        object.__setattr__(self, 'entities', entities)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'K\xe19\xbc',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 2) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 1) | (0 if self.entities is None or self.entities is False else 8)),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            self.peer._bytes(),
            self._serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 2)
        if flags & 1:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        _peer = reader.tgread_object()
        _message = reader.tgread_string()
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(peer=_peer, message=_message, no_webpage=_no_webpage, reply_to_msg_id=_reply_to_msg_id, entities=_entities)


@dataclasses.dataclass(init=False, frozen=True)
class SaveGif(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('id', 'unsave',)
    CONSTRUCTOR_ID = 0x327a30cb
    SUBCLASS_OF_ID = 0xf5b399ac

    id: 'TypeInputDocument'
    unsave: bool
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputDocument', unsave: bool):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'unsave', unsave)

    async def _resolve(self, client, utils):
        r = {}
        r['id'] = utils.get_input_document(self.id)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xcb0z2',
            self.id._bytes(),
            b'\xb5ur\x99' if self.unsave else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_object()
        _unsave = reader.tgread_bool()
        return cls(id=_id, unsave=_unsave)


@dataclasses.dataclass(init=False, frozen=True)
class SaveRecentSticker(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('id', 'unsave', 'attached',)
    CONSTRUCTOR_ID = 0x392718f8
    SUBCLASS_OF_ID = 0xf5b399ac

    id: 'TypeInputDocument'
    unsave: bool
    attached: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputDocument', unsave: bool, attached: Optional[bool]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'unsave', unsave)
        object.__setattr__(self, 'attached', attached)

    async def _resolve(self, client, utils):
        r = {}
        r['id'] = utils.get_input_document(self.id)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b"\xf8\x18'9",
            struct.pack('<I', (0 if self.attached is None or self.attached is False else 1)),
            self.id._bytes(),
            b'\xb5ur\x99' if self.unsave else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _attached = bool(flags & 1)
        _id = reader.tgread_object()
        _unsave = reader.tgread_bool()
        return cls(id=_id, unsave=_unsave, attached=_attached)


@dataclasses.dataclass(init=False, frozen=True)
class Search(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('peer', 'q', 'filter', 'min_date', 'max_date', 'offset_id', 'add_offset', 'limit', 'max_id', 'min_id', 'hash', 'from_id', 'top_msg_id',)
    CONSTRUCTOR_ID = 0xa0fda762
    SUBCLASS_OF_ID = 0xd4b40b5e

    peer: 'TypeInputPeer'
    q: str
    filter: 'TypeMessagesFilter'
    min_date: Optional[datetime]
    max_date: Optional[datetime]
    offset_id: int
    add_offset: int
    limit: int
    max_id: int
    min_id: int
    hash: int
    from_id: Optional['TypeInputPeer']
    top_msg_id: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', q: str, filter: 'TypeMessagesFilter', min_date: Optional[datetime], max_date: Optional[datetime], offset_id: int, add_offset: int, limit: int, max_id: int, min_id: int, hash: int, from_id: Optional['TypeInputPeer']=None, top_msg_id: Optional[int]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'q', q)
        object.__setattr__(self, 'filter', filter)
        object.__setattr__(self, 'min_date', min_date)
        object.__setattr__(self, 'max_date', max_date)
        object.__setattr__(self, 'offset_id', offset_id)
        object.__setattr__(self, 'add_offset', add_offset)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'max_id', max_id)
        object.__setattr__(self, 'min_id', min_id)
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'from_id', from_id)
        object.__setattr__(self, 'top_msg_id', top_msg_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        if self.from_id:
            r['from_id'] = utils.get_input_peer(await client._get_input_peer(self.from_id))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'b\xa7\xfd\xa0',
            struct.pack('<I', (0 if self.from_id is None or self.from_id is False else 1) | (0 if self.top_msg_id is None or self.top_msg_id is False else 2)),
            self.peer._bytes(),
            self._serialize_bytes(self.q),
            b'' if self.from_id is None or self.from_id is False else (self.from_id._bytes()),
            b'' if self.top_msg_id is None or self.top_msg_id is False else (struct.pack('<i', self.top_msg_id)),
            self.filter._bytes(),
            self._serialize_datetime(self.min_date),
            self._serialize_datetime(self.max_date),
            struct.pack('<i', self.offset_id),
            struct.pack('<i', self.add_offset),
            struct.pack('<i', self.limit),
            struct.pack('<i', self.max_id),
            struct.pack('<i', self.min_id),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _peer = reader.tgread_object()
        _q = reader.tgread_string()
        if flags & 1:
            _from_id = reader.tgread_object()
        else:
            _from_id = None
        if flags & 2:
            _top_msg_id = reader.read_int()
        else:
            _top_msg_id = None
        _filter = reader.tgread_object()
        _min_date = reader.tgread_date()
        _max_date = reader.tgread_date()
        _offset_id = reader.read_int()
        _add_offset = reader.read_int()
        _limit = reader.read_int()
        _max_id = reader.read_int()
        _min_id = reader.read_int()
        _hash = reader.read_long()
        return cls(peer=_peer, q=_q, filter=_filter, min_date=_min_date, max_date=_max_date, offset_id=_offset_id, add_offset=_add_offset, limit=_limit, max_id=_max_id, min_id=_min_id, hash=_hash, from_id=_from_id, top_msg_id=_top_msg_id)


@dataclasses.dataclass(init=False, frozen=True)
class SearchGlobal(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('q', 'filter', 'min_date', 'max_date', 'offset_rate', 'offset_peer', 'offset_id', 'limit', 'folder_id',)
    CONSTRUCTOR_ID = 0x4bc6589a
    SUBCLASS_OF_ID = 0xd4b40b5e

    q: str
    filter: 'TypeMessagesFilter'
    min_date: Optional[datetime]
    max_date: Optional[datetime]
    offset_rate: int
    offset_peer: 'TypeInputPeer'
    offset_id: int
    limit: int
    folder_id: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, q: str, filter: 'TypeMessagesFilter', min_date: Optional[datetime], max_date: Optional[datetime], offset_rate: int, offset_peer: 'TypeInputPeer', offset_id: int, limit: int, folder_id: Optional[int]=None):
        object.__setattr__(self, 'q', q)
        object.__setattr__(self, 'filter', filter)
        object.__setattr__(self, 'min_date', min_date)
        object.__setattr__(self, 'max_date', max_date)
        object.__setattr__(self, 'offset_rate', offset_rate)
        object.__setattr__(self, 'offset_peer', offset_peer)
        object.__setattr__(self, 'offset_id', offset_id)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'folder_id', folder_id)

    async def _resolve(self, client, utils):
        r = {}
        r['offset_peer'] = utils.get_input_peer(await client._get_input_peer(self.offset_peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x9aX\xc6K',
            struct.pack('<I', (0 if self.folder_id is None or self.folder_id is False else 1)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            self._serialize_bytes(self.q),
            self.filter._bytes(),
            self._serialize_datetime(self.min_date),
            self._serialize_datetime(self.max_date),
            struct.pack('<i', self.offset_rate),
            self.offset_peer._bytes(),
            struct.pack('<i', self.offset_id),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        _q = reader.tgread_string()
        _filter = reader.tgread_object()
        _min_date = reader.tgread_date()
        _max_date = reader.tgread_date()
        _offset_rate = reader.read_int()
        _offset_peer = reader.tgread_object()
        _offset_id = reader.read_int()
        _limit = reader.read_int()
        return cls(q=_q, filter=_filter, min_date=_min_date, max_date=_max_date, offset_rate=_offset_rate, offset_peer=_offset_peer, offset_id=_offset_id, limit=_limit, folder_id=_folder_id)


@dataclasses.dataclass(init=False, frozen=True)
class SearchSentMedia(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('q', 'filter', 'limit',)
    CONSTRUCTOR_ID = 0x107e31a0
    SUBCLASS_OF_ID = 0xd4b40b5e

    q: str
    filter: 'TypeMessagesFilter'
    limit: int
    # noinspection PyShadowingBuiltins
    def __init__(self, q: str, filter: 'TypeMessagesFilter', limit: int):
        object.__setattr__(self, 'q', q)
        object.__setattr__(self, 'filter', filter)
        object.__setattr__(self, 'limit', limit)

    def _bytes(self):
        return b''.join((
            b'\xa01~\x10',
            self._serialize_bytes(self.q),
            self.filter._bytes(),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _q = reader.tgread_string()
        _filter = reader.tgread_object()
        _limit = reader.read_int()
        return cls(q=_q, filter=_filter, limit=_limit)


@dataclasses.dataclass(init=False, frozen=True)
class SearchStickerSets(TLRequest):
    """
    :returns messages.FoundStickerSets: Instance of either FoundStickerSetsNotModified, FoundStickerSets.
    """
    __slots__ = ('q', 'hash', 'exclude_featured',)
    CONSTRUCTOR_ID = 0x35705b8a
    SUBCLASS_OF_ID = 0x40df361

    q: str
    hash: int
    exclude_featured: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, q: str, hash: int, exclude_featured: Optional[bool]=None):
        object.__setattr__(self, 'q', q)
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'exclude_featured', exclude_featured)

    def _bytes(self):
        return b''.join((
            b'\x8a[p5',
            struct.pack('<I', (0 if self.exclude_featured is None or self.exclude_featured is False else 1)),
            self._serialize_bytes(self.q),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _exclude_featured = bool(flags & 1)
        _q = reader.tgread_string()
        _hash = reader.read_long()
        return cls(q=_q, hash=_hash, exclude_featured=_exclude_featured)


@dataclasses.dataclass(init=False, frozen=True)
class SendEncrypted(TLRequest):
    """
    :returns messages.SentEncryptedMessage: Instance of either SentEncryptedMessage, SentEncryptedFile.
    """
    __slots__ = ('peer', 'data', 'silent', 'random_id',)
    CONSTRUCTOR_ID = 0x44fa7a15
    SUBCLASS_OF_ID = 0xc99e3e50

    peer: 'TypeInputEncryptedChat'
    data: bytes
    silent: Optional[bool]
    random_id: int
    def __init__(self, peer: 'TypeInputEncryptedChat', data: bytes, silent: Optional[bool]=None, random_id: int=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'data', data)
        object.__setattr__(self, 'silent', silent)
        object.__setattr__(self, 'random_id', random_id)

    async def _resolve(self, client, utils):
        r = {}
        if self.random_id is None:
            r['random_id'] = int.from_bytes(os.urandom(8), 'big', signed=True)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x15z\xfaD',
            struct.pack('<I', (0 if self.silent is None or self.silent is False else 1)),
            self.peer._bytes(),
            struct.pack('<q', self.random_id),
            self._serialize_bytes(self.data),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _silent = bool(flags & 1)
        _peer = reader.tgread_object()
        _random_id = reader.read_long()
        _data = reader.tgread_bytes()
        return cls(peer=_peer, data=_data, silent=_silent, random_id=_random_id)


@dataclasses.dataclass(init=False, frozen=True)
class SendEncryptedFile(TLRequest):
    """
    :returns messages.SentEncryptedMessage: Instance of either SentEncryptedMessage, SentEncryptedFile.
    """
    __slots__ = ('peer', 'data', 'file', 'silent', 'random_id',)
    CONSTRUCTOR_ID = 0x5559481d
    SUBCLASS_OF_ID = 0xc99e3e50

    peer: 'TypeInputEncryptedChat'
    data: bytes
    file: 'TypeInputEncryptedFile'
    silent: Optional[bool]
    random_id: int
    def __init__(self, peer: 'TypeInputEncryptedChat', data: bytes, file: 'TypeInputEncryptedFile', silent: Optional[bool]=None, random_id: int=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'data', data)
        object.__setattr__(self, 'file', file)
        object.__setattr__(self, 'silent', silent)
        object.__setattr__(self, 'random_id', random_id)

    async def _resolve(self, client, utils):
        r = {}
        if self.random_id is None:
            r['random_id'] = int.from_bytes(os.urandom(8), 'big', signed=True)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x1dHYU',
            struct.pack('<I', (0 if self.silent is None or self.silent is False else 1)),
            self.peer._bytes(),
            struct.pack('<q', self.random_id),
            self._serialize_bytes(self.data),
            self.file._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _silent = bool(flags & 1)
        _peer = reader.tgread_object()
        _random_id = reader.read_long()
        _data = reader.tgread_bytes()
        _file = reader.tgread_object()
        return cls(peer=_peer, data=_data, file=_file, silent=_silent, random_id=_random_id)


@dataclasses.dataclass(init=False, frozen=True)
class SendEncryptedService(TLRequest):
    """
    :returns messages.SentEncryptedMessage: Instance of either SentEncryptedMessage, SentEncryptedFile.
    """
    __slots__ = ('peer', 'data', 'random_id',)
    CONSTRUCTOR_ID = 0x32d439a4
    SUBCLASS_OF_ID = 0xc99e3e50

    peer: 'TypeInputEncryptedChat'
    data: bytes
    random_id: int
    def __init__(self, peer: 'TypeInputEncryptedChat', data: bytes, random_id: int=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'data', data)
        object.__setattr__(self, 'random_id', random_id)

    async def _resolve(self, client, utils):
        r = {}
        if self.random_id is None:
            r['random_id'] = int.from_bytes(os.urandom(8), 'big', signed=True)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xa49\xd42',
            self.peer._bytes(),
            struct.pack('<q', self.random_id),
            self._serialize_bytes(self.data),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _random_id = reader.read_long()
        _data = reader.tgread_bytes()
        return cls(peer=_peer, data=_data, random_id=_random_id)


@dataclasses.dataclass(init=False, frozen=True)
class SendInlineBotResult(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'query_id', 'id', 'silent', 'background', 'clear_draft', 'hide_via', 'reply_to_msg_id', 'random_id', 'schedule_date', 'send_as',)
    CONSTRUCTOR_ID = 0x7aa11297
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    query_id: int
    id: str
    silent: Optional[bool]
    background: Optional[bool]
    clear_draft: Optional[bool]
    hide_via: Optional[bool]
    reply_to_msg_id: Optional[int]
    random_id: int
    schedule_date: Optional[datetime]
    send_as: Optional['TypeInputPeer']
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', query_id: int, id: str, silent: Optional[bool]=None, background: Optional[bool]=None, clear_draft: Optional[bool]=None, hide_via: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, random_id: int=None, schedule_date: Optional[datetime]=None, send_as: Optional['TypeInputPeer']=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'query_id', query_id)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'silent', silent)
        object.__setattr__(self, 'background', background)
        object.__setattr__(self, 'clear_draft', clear_draft)
        object.__setattr__(self, 'hide_via', hide_via)
        object.__setattr__(self, 'reply_to_msg_id', reply_to_msg_id)
        object.__setattr__(self, 'random_id', random_id)
        object.__setattr__(self, 'schedule_date', schedule_date)
        object.__setattr__(self, 'send_as', send_as)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        if self.random_id is None:
            r['random_id'] = int.from_bytes(os.urandom(8), 'big', signed=True)

        if self.send_as:
            r['send_as'] = utils.get_input_peer(await client._get_input_peer(self.send_as))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x97\x12\xa1z',
            struct.pack('<I', (0 if self.silent is None or self.silent is False else 32) | (0 if self.background is None or self.background is False else 64) | (0 if self.clear_draft is None or self.clear_draft is False else 128) | (0 if self.hide_via is None or self.hide_via is False else 2048) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 1) | (0 if self.schedule_date is None or self.schedule_date is False else 1024) | (0 if self.send_as is None or self.send_as is False else 8192)),
            self.peer._bytes(),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            struct.pack('<q', self.random_id),
            struct.pack('<q', self.query_id),
            self._serialize_bytes(self.id),
            b'' if self.schedule_date is None or self.schedule_date is False else (self._serialize_datetime(self.schedule_date)),
            b'' if self.send_as is None or self.send_as is False else (self.send_as._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _silent = bool(flags & 32)
        _background = bool(flags & 64)
        _clear_draft = bool(flags & 128)
        _hide_via = bool(flags & 2048)
        _peer = reader.tgread_object()
        if flags & 1:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        _random_id = reader.read_long()
        _query_id = reader.read_long()
        _id = reader.tgread_string()
        if flags & 1024:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        if flags & 8192:
            _send_as = reader.tgread_object()
        else:
            _send_as = None
        return cls(peer=_peer, query_id=_query_id, id=_id, silent=_silent, background=_background, clear_draft=_clear_draft, hide_via=_hide_via, reply_to_msg_id=_reply_to_msg_id, random_id=_random_id, schedule_date=_schedule_date, send_as=_send_as)


@dataclasses.dataclass(init=False, frozen=True)
class SendMedia(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'media', 'message', 'silent', 'background', 'clear_draft', 'noforwards', 'reply_to_msg_id', 'random_id', 'reply_markup', 'entities', 'schedule_date', 'send_as',)
    CONSTRUCTOR_ID = 0xe25ff8e0
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    media: 'TypeInputMedia'
    message: str
    silent: Optional[bool]
    background: Optional[bool]
    clear_draft: Optional[bool]
    noforwards: Optional[bool]
    reply_to_msg_id: Optional[int]
    random_id: int
    reply_markup: Optional['TypeReplyMarkup']
    entities: Optional[List['TypeMessageEntity']]
    schedule_date: Optional[datetime]
    send_as: Optional['TypeInputPeer']
    def __init__(self, peer: 'TypeInputPeer', media: 'TypeInputMedia', message: str, silent: Optional[bool]=None, background: Optional[bool]=None, clear_draft: Optional[bool]=None, noforwards: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, random_id: int=None, reply_markup: Optional['TypeReplyMarkup']=None, entities: Optional[List['TypeMessageEntity']]=None, schedule_date: Optional[datetime]=None, send_as: Optional['TypeInputPeer']=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'media', media)
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'silent', silent)
        object.__setattr__(self, 'background', background)
        object.__setattr__(self, 'clear_draft', clear_draft)
        object.__setattr__(self, 'noforwards', noforwards)
        object.__setattr__(self, 'reply_to_msg_id', reply_to_msg_id)
        object.__setattr__(self, 'random_id', random_id)
        object.__setattr__(self, 'reply_markup', reply_markup)
        object.__setattr__(self, 'entities', entities)
        object.__setattr__(self, 'schedule_date', schedule_date)
        object.__setattr__(self, 'send_as', send_as)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        r['media'] = utils.get_input_media(self.media)
        if self.random_id is None:
            r['random_id'] = int.from_bytes(os.urandom(8), 'big', signed=True)

        if self.send_as:
            r['send_as'] = utils.get_input_peer(await client._get_input_peer(self.send_as))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xe0\xf8_\xe2',
            struct.pack('<I', (0 if self.silent is None or self.silent is False else 32) | (0 if self.background is None or self.background is False else 64) | (0 if self.clear_draft is None or self.clear_draft is False else 128) | (0 if self.noforwards is None or self.noforwards is False else 16384) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 1) | (0 if self.reply_markup is None or self.reply_markup is False else 4) | (0 if self.entities is None or self.entities is False else 8) | (0 if self.schedule_date is None or self.schedule_date is False else 1024) | (0 if self.send_as is None or self.send_as is False else 8192)),
            self.peer._bytes(),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            self.media._bytes(),
            self._serialize_bytes(self.message),
            struct.pack('<q', self.random_id),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.schedule_date is None or self.schedule_date is False else (self._serialize_datetime(self.schedule_date)),
            b'' if self.send_as is None or self.send_as is False else (self.send_as._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _silent = bool(flags & 32)
        _background = bool(flags & 64)
        _clear_draft = bool(flags & 128)
        _noforwards = bool(flags & 16384)
        _peer = reader.tgread_object()
        if flags & 1:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        _media = reader.tgread_object()
        _message = reader.tgread_string()
        _random_id = reader.read_long()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 1024:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        if flags & 8192:
            _send_as = reader.tgread_object()
        else:
            _send_as = None
        return cls(peer=_peer, media=_media, message=_message, silent=_silent, background=_background, clear_draft=_clear_draft, noforwards=_noforwards, reply_to_msg_id=_reply_to_msg_id, random_id=_random_id, reply_markup=_reply_markup, entities=_entities, schedule_date=_schedule_date, send_as=_send_as)


@dataclasses.dataclass(init=False, frozen=True)
class SendMessage(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'message', 'no_webpage', 'silent', 'background', 'clear_draft', 'noforwards', 'reply_to_msg_id', 'random_id', 'reply_markup', 'entities', 'schedule_date', 'send_as',)
    CONSTRUCTOR_ID = 0xd9d75a4
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    message: str
    no_webpage: Optional[bool]
    silent: Optional[bool]
    background: Optional[bool]
    clear_draft: Optional[bool]
    noforwards: Optional[bool]
    reply_to_msg_id: Optional[int]
    random_id: int
    reply_markup: Optional['TypeReplyMarkup']
    entities: Optional[List['TypeMessageEntity']]
    schedule_date: Optional[datetime]
    send_as: Optional['TypeInputPeer']
    def __init__(self, peer: 'TypeInputPeer', message: str, no_webpage: Optional[bool]=None, silent: Optional[bool]=None, background: Optional[bool]=None, clear_draft: Optional[bool]=None, noforwards: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, random_id: int=None, reply_markup: Optional['TypeReplyMarkup']=None, entities: Optional[List['TypeMessageEntity']]=None, schedule_date: Optional[datetime]=None, send_as: Optional['TypeInputPeer']=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'no_webpage', no_webpage)
        object.__setattr__(self, 'silent', silent)
        object.__setattr__(self, 'background', background)
        object.__setattr__(self, 'clear_draft', clear_draft)
        object.__setattr__(self, 'noforwards', noforwards)
        object.__setattr__(self, 'reply_to_msg_id', reply_to_msg_id)
        object.__setattr__(self, 'random_id', random_id)
        object.__setattr__(self, 'reply_markup', reply_markup)
        object.__setattr__(self, 'entities', entities)
        object.__setattr__(self, 'schedule_date', schedule_date)
        object.__setattr__(self, 'send_as', send_as)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        if self.random_id is None:
            r['random_id'] = int.from_bytes(os.urandom(8), 'big', signed=True)

        if self.send_as:
            r['send_as'] = utils.get_input_peer(await client._get_input_peer(self.send_as))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xa4u\x9d\r',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 2) | (0 if self.silent is None or self.silent is False else 32) | (0 if self.background is None or self.background is False else 64) | (0 if self.clear_draft is None or self.clear_draft is False else 128) | (0 if self.noforwards is None or self.noforwards is False else 16384) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 1) | (0 if self.reply_markup is None or self.reply_markup is False else 4) | (0 if self.entities is None or self.entities is False else 8) | (0 if self.schedule_date is None or self.schedule_date is False else 1024) | (0 if self.send_as is None or self.send_as is False else 8192)),
            self.peer._bytes(),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            self._serialize_bytes(self.message),
            struct.pack('<q', self.random_id),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.schedule_date is None or self.schedule_date is False else (self._serialize_datetime(self.schedule_date)),
            b'' if self.send_as is None or self.send_as is False else (self.send_as._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 2)
        _silent = bool(flags & 32)
        _background = bool(flags & 64)
        _clear_draft = bool(flags & 128)
        _noforwards = bool(flags & 16384)
        _peer = reader.tgread_object()
        if flags & 1:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        _message = reader.tgread_string()
        _random_id = reader.read_long()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 1024:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        if flags & 8192:
            _send_as = reader.tgread_object()
        else:
            _send_as = None
        return cls(peer=_peer, message=_message, no_webpage=_no_webpage, silent=_silent, background=_background, clear_draft=_clear_draft, noforwards=_noforwards, reply_to_msg_id=_reply_to_msg_id, random_id=_random_id, reply_markup=_reply_markup, entities=_entities, schedule_date=_schedule_date, send_as=_send_as)


@dataclasses.dataclass(init=False, frozen=True)
class SendMultiMedia(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'multi_media', 'silent', 'background', 'clear_draft', 'noforwards', 'reply_to_msg_id', 'schedule_date', 'send_as',)
    CONSTRUCTOR_ID = 0xf803138f
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    multi_media: List['TypeInputSingleMedia']
    silent: Optional[bool]
    background: Optional[bool]
    clear_draft: Optional[bool]
    noforwards: Optional[bool]
    reply_to_msg_id: Optional[int]
    schedule_date: Optional[datetime]
    send_as: Optional['TypeInputPeer']
    def __init__(self, peer: 'TypeInputPeer', multi_media: List['TypeInputSingleMedia'], silent: Optional[bool]=None, background: Optional[bool]=None, clear_draft: Optional[bool]=None, noforwards: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, schedule_date: Optional[datetime]=None, send_as: Optional['TypeInputPeer']=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'multi_media', multi_media)
        object.__setattr__(self, 'silent', silent)
        object.__setattr__(self, 'background', background)
        object.__setattr__(self, 'clear_draft', clear_draft)
        object.__setattr__(self, 'noforwards', noforwards)
        object.__setattr__(self, 'reply_to_msg_id', reply_to_msg_id)
        object.__setattr__(self, 'schedule_date', schedule_date)
        object.__setattr__(self, 'send_as', send_as)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        if self.send_as:
            r['send_as'] = utils.get_input_peer(await client._get_input_peer(self.send_as))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x8f\x13\x03\xf8',
            struct.pack('<I', (0 if self.silent is None or self.silent is False else 32) | (0 if self.background is None or self.background is False else 64) | (0 if self.clear_draft is None or self.clear_draft is False else 128) | (0 if self.noforwards is None or self.noforwards is False else 16384) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 1) | (0 if self.schedule_date is None or self.schedule_date is False else 1024) | (0 if self.send_as is None or self.send_as is False else 8192)),
            self.peer._bytes(),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.multi_media)),b''.join(x._bytes() for x in self.multi_media),
            b'' if self.schedule_date is None or self.schedule_date is False else (self._serialize_datetime(self.schedule_date)),
            b'' if self.send_as is None or self.send_as is False else (self.send_as._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _silent = bool(flags & 32)
        _background = bool(flags & 64)
        _clear_draft = bool(flags & 128)
        _noforwards = bool(flags & 16384)
        _peer = reader.tgread_object()
        if flags & 1:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        reader.read_int()
        _multi_media = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _multi_media.append(_x)

        if flags & 1024:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        if flags & 8192:
            _send_as = reader.tgread_object()
        else:
            _send_as = None
        return cls(peer=_peer, multi_media=_multi_media, silent=_silent, background=_background, clear_draft=_clear_draft, noforwards=_noforwards, reply_to_msg_id=_reply_to_msg_id, schedule_date=_schedule_date, send_as=_send_as)


@dataclasses.dataclass(init=False, frozen=True)
class SendReaction(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'msg_id', 'big', 'reaction',)
    CONSTRUCTOR_ID = 0x25690ce4
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    msg_id: int
    big: Optional[bool]
    reaction: Optional[str]
    def __init__(self, peer: 'TypeInputPeer', msg_id: int, big: Optional[bool]=None, reaction: Optional[str]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'big', big)
        object.__setattr__(self, 'reaction', reaction)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xe4\x0ci%',
            struct.pack('<I', (0 if self.big is None or self.big is False else 2) | (0 if self.reaction is None or self.reaction is False else 1)),
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            b'' if self.reaction is None or self.reaction is False else (self._serialize_bytes(self.reaction)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _big = bool(flags & 2)
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        if flags & 1:
            _reaction = reader.tgread_string()
        else:
            _reaction = None
        return cls(peer=_peer, msg_id=_msg_id, big=_big, reaction=_reaction)


@dataclasses.dataclass(init=False, frozen=True)
class SendScheduledMessages(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'id',)
    CONSTRUCTOR_ID = 0xbd38850a
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    id: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: List[int]):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\n\x858\xbd',
            self.peer._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(peer=_peer, id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class SendScreenshotNotification(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'reply_to_msg_id', 'random_id',)
    CONSTRUCTOR_ID = 0xc97df020
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    reply_to_msg_id: int
    random_id: int
    def __init__(self, peer: 'TypeInputPeer', reply_to_msg_id: int, random_id: int=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'reply_to_msg_id', reply_to_msg_id)
        object.__setattr__(self, 'random_id', random_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        if self.random_id is None:
            r['random_id'] = int.from_bytes(os.urandom(8), 'big', signed=True)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b' \xf0}\xc9',
            self.peer._bytes(),
            struct.pack('<i', self.reply_to_msg_id),
            struct.pack('<q', self.random_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _reply_to_msg_id = reader.read_int()
        _random_id = reader.read_long()
        return cls(peer=_peer, reply_to_msg_id=_reply_to_msg_id, random_id=_random_id)


@dataclasses.dataclass(init=False, frozen=True)
class SendVote(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'msg_id', 'options',)
    CONSTRUCTOR_ID = 0x10ea6184
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    msg_id: int
    options: List[bytes]
    def __init__(self, peer: 'TypeInputPeer', msg_id: int, options: List[bytes]):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'options', options)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x84a\xea\x10',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.options)),b''.join(self._serialize_bytes(x) for x in self.options),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        reader.read_int()
        _options = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_bytes()
            _options.append(_x)

        return cls(peer=_peer, msg_id=_msg_id, options=_options)


@dataclasses.dataclass(init=False, frozen=True)
class SetBotCallbackAnswer(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('query_id', 'cache_time', 'alert', 'message', 'url',)
    CONSTRUCTOR_ID = 0xd58f130a
    SUBCLASS_OF_ID = 0xf5b399ac

    query_id: int
    cache_time: int
    alert: Optional[bool]
    message: Optional[str]
    url: Optional[str]
    def __init__(self, query_id: int, cache_time: int, alert: Optional[bool]=None, message: Optional[str]=None, url: Optional[str]=None):
        object.__setattr__(self, 'query_id', query_id)
        object.__setattr__(self, 'cache_time', cache_time)
        object.__setattr__(self, 'alert', alert)
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'url', url)

    def _bytes(self):
        return b''.join((
            b'\n\x13\x8f\xd5',
            struct.pack('<I', (0 if self.alert is None or self.alert is False else 2) | (0 if self.message is None or self.message is False else 1) | (0 if self.url is None or self.url is False else 4)),
            struct.pack('<q', self.query_id),
            b'' if self.message is None or self.message is False else (self._serialize_bytes(self.message)),
            b'' if self.url is None or self.url is False else (self._serialize_bytes(self.url)),
            struct.pack('<i', self.cache_time),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _alert = bool(flags & 2)
        _query_id = reader.read_long()
        if flags & 1:
            _message = reader.tgread_string()
        else:
            _message = None
        if flags & 4:
            _url = reader.tgread_string()
        else:
            _url = None
        _cache_time = reader.read_int()
        return cls(query_id=_query_id, cache_time=_cache_time, alert=_alert, message=_message, url=_url)


@dataclasses.dataclass(init=False, frozen=True)
class SetBotPrecheckoutResults(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('query_id', 'success', 'error',)
    CONSTRUCTOR_ID = 0x9c2dd95
    SUBCLASS_OF_ID = 0xf5b399ac

    query_id: int
    success: Optional[bool]
    error: Optional[str]
    def __init__(self, query_id: int, success: Optional[bool]=None, error: Optional[str]=None):
        object.__setattr__(self, 'query_id', query_id)
        object.__setattr__(self, 'success', success)
        object.__setattr__(self, 'error', error)

    def _bytes(self):
        return b''.join((
            b'\x95\xdd\xc2\t',
            struct.pack('<I', (0 if self.success is None or self.success is False else 2) | (0 if self.error is None or self.error is False else 1)),
            struct.pack('<q', self.query_id),
            b'' if self.error is None or self.error is False else (self._serialize_bytes(self.error)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _success = bool(flags & 2)
        _query_id = reader.read_long()
        if flags & 1:
            _error = reader.tgread_string()
        else:
            _error = None
        return cls(query_id=_query_id, success=_success, error=_error)


@dataclasses.dataclass(init=False, frozen=True)
class SetBotShippingResults(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('query_id', 'error', 'shipping_options',)
    CONSTRUCTOR_ID = 0xe5f672fa
    SUBCLASS_OF_ID = 0xf5b399ac

    query_id: int
    error: Optional[str]
    shipping_options: Optional[List['TypeShippingOption']]
    def __init__(self, query_id: int, error: Optional[str]=None, shipping_options: Optional[List['TypeShippingOption']]=None):
        object.__setattr__(self, 'query_id', query_id)
        object.__setattr__(self, 'error', error)
        object.__setattr__(self, 'shipping_options', shipping_options)

    def _bytes(self):
        return b''.join((
            b'\xfar\xf6\xe5',
            struct.pack('<I', (0 if self.error is None or self.error is False else 1) | (0 if self.shipping_options is None or self.shipping_options is False else 2)),
            struct.pack('<q', self.query_id),
            b'' if self.error is None or self.error is False else (self._serialize_bytes(self.error)),
            b'' if self.shipping_options is None or self.shipping_options is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.shipping_options)),b''.join(x._bytes() for x in self.shipping_options))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _query_id = reader.read_long()
        if flags & 1:
            _error = reader.tgread_string()
        else:
            _error = None
        if flags & 2:
            reader.read_int()
            _shipping_options = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _shipping_options.append(_x)

        else:
            _shipping_options = None
        return cls(query_id=_query_id, error=_error, shipping_options=_shipping_options)


@dataclasses.dataclass(init=False, frozen=True)
class SetChatAvailableReactions(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'available_reactions',)
    CONSTRUCTOR_ID = 0x14050ea6
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    available_reactions: List[str]
    def __init__(self, peer: 'TypeInputPeer', available_reactions: List[str]):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'available_reactions', available_reactions)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xa6\x0e\x05\x14',
            self.peer._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.available_reactions)),b''.join(self._serialize_bytes(x) for x in self.available_reactions),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _available_reactions = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _available_reactions.append(_x)

        return cls(peer=_peer, available_reactions=_available_reactions)


@dataclasses.dataclass(init=False, frozen=True)
class SetChatTheme(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'emoticon',)
    CONSTRUCTOR_ID = 0xe63be13f
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    emoticon: str
    def __init__(self, peer: 'TypeInputPeer', emoticon: str):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'emoticon', emoticon)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'?\xe1;\xe6',
            self.peer._bytes(),
            self._serialize_bytes(self.emoticon),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _emoticon = reader.tgread_string()
        return cls(peer=_peer, emoticon=_emoticon)


@dataclasses.dataclass(init=False, frozen=True)
class SetDefaultReaction(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('reaction',)
    CONSTRUCTOR_ID = 0xd960c4d4
    SUBCLASS_OF_ID = 0xf5b399ac

    reaction: str
    def __init__(self, reaction: str):
        object.__setattr__(self, 'reaction', reaction)

    def _bytes(self):
        return b''.join((
            b'\xd4\xc4`\xd9',
            self._serialize_bytes(self.reaction),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _reaction = reader.tgread_string()
        return cls(reaction=_reaction)


@dataclasses.dataclass(init=False, frozen=True)
class SetEncryptedTyping(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'typing',)
    CONSTRUCTOR_ID = 0x791451ed
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputEncryptedChat'
    typing: bool
    def __init__(self, peer: 'TypeInputEncryptedChat', typing: bool):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'typing', typing)

    def _bytes(self):
        return b''.join((
            b'\xedQ\x14y',
            self.peer._bytes(),
            b'\xb5ur\x99' if self.typing else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _typing = reader.tgread_bool()
        return cls(peer=_peer, typing=_typing)


@dataclasses.dataclass(init=False, frozen=True)
class SetGameScore(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'id', 'user_id', 'score', 'edit_message', 'force',)
    CONSTRUCTOR_ID = 0x8ef8ecc0
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    id: int
    user_id: 'TypeInputUser'
    score: int
    edit_message: Optional[bool]
    force: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int, user_id: 'TypeInputUser', score: int, edit_message: Optional[bool]=None, force: Optional[bool]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'score', score)
        object.__setattr__(self, 'edit_message', edit_message)
        object.__setattr__(self, 'force', force)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xc0\xec\xf8\x8e',
            struct.pack('<I', (0 if self.edit_message is None or self.edit_message is False else 1) | (0 if self.force is None or self.force is False else 2)),
            self.peer._bytes(),
            struct.pack('<i', self.id),
            self.user_id._bytes(),
            struct.pack('<i', self.score),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _edit_message = bool(flags & 1)
        _force = bool(flags & 2)
        _peer = reader.tgread_object()
        _id = reader.read_int()
        _user_id = reader.tgread_object()
        _score = reader.read_int()
        return cls(peer=_peer, id=_id, user_id=_user_id, score=_score, edit_message=_edit_message, force=_force)


@dataclasses.dataclass(init=False, frozen=True)
class SetHistoryTTL(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'period',)
    CONSTRUCTOR_ID = 0xb80e5fe4
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    period: int
    def __init__(self, peer: 'TypeInputPeer', period: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'period', period)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xe4_\x0e\xb8',
            self.peer._bytes(),
            struct.pack('<i', self.period),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _period = reader.read_int()
        return cls(peer=_peer, period=_period)


@dataclasses.dataclass(init=False, frozen=True)
class SetInlineBotResults(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('query_id', 'results', 'cache_time', 'gallery', 'private', 'next_offset', 'switch_pm',)
    CONSTRUCTOR_ID = 0xeb5ea206
    SUBCLASS_OF_ID = 0xf5b399ac

    query_id: int
    results: List['TypeInputBotInlineResult']
    cache_time: int
    gallery: Optional[bool]
    private: Optional[bool]
    next_offset: Optional[str]
    switch_pm: Optional['TypeInlineBotSwitchPM']
    def __init__(self, query_id: int, results: List['TypeInputBotInlineResult'], cache_time: int, gallery: Optional[bool]=None, private: Optional[bool]=None, next_offset: Optional[str]=None, switch_pm: Optional['TypeInlineBotSwitchPM']=None):
        object.__setattr__(self, 'query_id', query_id)
        object.__setattr__(self, 'results', results)
        object.__setattr__(self, 'cache_time', cache_time)
        object.__setattr__(self, 'gallery', gallery)
        object.__setattr__(self, 'private', private)
        object.__setattr__(self, 'next_offset', next_offset)
        object.__setattr__(self, 'switch_pm', switch_pm)

    def _bytes(self):
        return b''.join((
            b'\x06\xa2^\xeb',
            struct.pack('<I', (0 if self.gallery is None or self.gallery is False else 1) | (0 if self.private is None or self.private is False else 2) | (0 if self.next_offset is None or self.next_offset is False else 4) | (0 if self.switch_pm is None or self.switch_pm is False else 8)),
            struct.pack('<q', self.query_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.results)),b''.join(x._bytes() for x in self.results),
            struct.pack('<i', self.cache_time),
            b'' if self.next_offset is None or self.next_offset is False else (self._serialize_bytes(self.next_offset)),
            b'' if self.switch_pm is None or self.switch_pm is False else (self.switch_pm._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _gallery = bool(flags & 1)
        _private = bool(flags & 2)
        _query_id = reader.read_long()
        reader.read_int()
        _results = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _results.append(_x)

        _cache_time = reader.read_int()
        if flags & 4:
            _next_offset = reader.tgread_string()
        else:
            _next_offset = None
        if flags & 8:
            _switch_pm = reader.tgread_object()
        else:
            _switch_pm = None
        return cls(query_id=_query_id, results=_results, cache_time=_cache_time, gallery=_gallery, private=_private, next_offset=_next_offset, switch_pm=_switch_pm)


@dataclasses.dataclass(init=False, frozen=True)
class SetInlineGameScore(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('id', 'user_id', 'score', 'edit_message', 'force',)
    CONSTRUCTOR_ID = 0x15ad9f64
    SUBCLASS_OF_ID = 0xf5b399ac

    id: 'TypeInputBotInlineMessageID'
    user_id: 'TypeInputUser'
    score: int
    edit_message: Optional[bool]
    force: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputBotInlineMessageID', user_id: 'TypeInputUser', score: int, edit_message: Optional[bool]=None, force: Optional[bool]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'score', score)
        object.__setattr__(self, 'edit_message', edit_message)
        object.__setattr__(self, 'force', force)

    async def _resolve(self, client, utils):
        r = {}
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'd\x9f\xad\x15',
            struct.pack('<I', (0 if self.edit_message is None or self.edit_message is False else 1) | (0 if self.force is None or self.force is False else 2)),
            self.id._bytes(),
            self.user_id._bytes(),
            struct.pack('<i', self.score),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _edit_message = bool(flags & 1)
        _force = bool(flags & 2)
        _id = reader.tgread_object()
        _user_id = reader.tgread_object()
        _score = reader.read_int()
        return cls(id=_id, user_id=_user_id, score=_score, edit_message=_edit_message, force=_force)


@dataclasses.dataclass(init=False, frozen=True)
class SetTyping(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'action', 'top_msg_id',)
    CONSTRUCTOR_ID = 0x58943ee2
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    action: 'TypeSendMessageAction'
    top_msg_id: Optional[int]
    def __init__(self, peer: 'TypeInputPeer', action: 'TypeSendMessageAction', top_msg_id: Optional[int]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'action', action)
        object.__setattr__(self, 'top_msg_id', top_msg_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xe2>\x94X',
            struct.pack('<I', (0 if self.top_msg_id is None or self.top_msg_id is False else 1)),
            self.peer._bytes(),
            b'' if self.top_msg_id is None or self.top_msg_id is False else (struct.pack('<i', self.top_msg_id)),
            self.action._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _peer = reader.tgread_object()
        if flags & 1:
            _top_msg_id = reader.read_int()
        else:
            _top_msg_id = None
        _action = reader.tgread_object()
        return cls(peer=_peer, action=_action, top_msg_id=_top_msg_id)


@dataclasses.dataclass(init=False, frozen=True)
class StartBot(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('bot', 'peer', 'start_param', 'random_id',)
    CONSTRUCTOR_ID = 0xe6df7378
    SUBCLASS_OF_ID = 0x8af52aac

    bot: 'TypeInputUser'
    peer: 'TypeInputPeer'
    start_param: str
    random_id: int
    def __init__(self, bot: 'TypeInputUser', peer: 'TypeInputPeer', start_param: str, random_id: int=None):
        object.__setattr__(self, 'bot', bot)
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'start_param', start_param)
        object.__setattr__(self, 'random_id', random_id)

    async def _resolve(self, client, utils):
        r = {}
        r['bot'] = utils.get_input_user(await client._get_input_peer(self.bot))
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        if self.random_id is None:
            r['random_id'] = int.from_bytes(os.urandom(8), 'big', signed=True)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'xs\xdf\xe6',
            self.bot._bytes(),
            self.peer._bytes(),
            struct.pack('<q', self.random_id),
            self._serialize_bytes(self.start_param),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _bot = reader.tgread_object()
        _peer = reader.tgread_object()
        _random_id = reader.read_long()
        _start_param = reader.tgread_string()
        return cls(bot=_bot, peer=_peer, start_param=_start_param, random_id=_random_id)


@dataclasses.dataclass(init=False, frozen=True)
class StartHistoryImport(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'import_id',)
    CONSTRUCTOR_ID = 0xb43df344
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    import_id: int
    def __init__(self, peer: 'TypeInputPeer', import_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'import_id', import_id)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'D\xf3=\xb4',
            self.peer._bytes(),
            struct.pack('<q', self.import_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _import_id = reader.read_long()
        return cls(peer=_peer, import_id=_import_id)


@dataclasses.dataclass(init=False, frozen=True)
class ToggleDialogPin(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'pinned',)
    CONSTRUCTOR_ID = 0xa731e257
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputDialogPeer'
    pinned: Optional[bool]
    def __init__(self, peer: 'TypeInputDialogPeer', pinned: Optional[bool]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'pinned', pinned)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = await client._get_input_dialog(self.peer)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'W\xe21\xa7',
            struct.pack('<I', (0 if self.pinned is None or self.pinned is False else 1)),
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _pinned = bool(flags & 1)
        _peer = reader.tgread_object()
        return cls(peer=_peer, pinned=_pinned)


@dataclasses.dataclass(init=False, frozen=True)
class ToggleNoForwards(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'enabled',)
    CONSTRUCTOR_ID = 0xb11eafa2
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    enabled: bool
    def __init__(self, peer: 'TypeInputPeer', enabled: bool):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'enabled', enabled)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xa2\xaf\x1e\xb1',
            self.peer._bytes(),
            b'\xb5ur\x99' if self.enabled else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _enabled = reader.tgread_bool()
        return cls(peer=_peer, enabled=_enabled)


@dataclasses.dataclass(init=False, frozen=True)
class ToggleStickerSets(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('stickersets', 'uninstall', 'archive', 'unarchive',)
    CONSTRUCTOR_ID = 0xb5052fea
    SUBCLASS_OF_ID = 0xf5b399ac

    stickersets: List['TypeInputStickerSet']
    uninstall: Optional[bool]
    archive: Optional[bool]
    unarchive: Optional[bool]
    def __init__(self, stickersets: List['TypeInputStickerSet'], uninstall: Optional[bool]=None, archive: Optional[bool]=None, unarchive: Optional[bool]=None):
        object.__setattr__(self, 'stickersets', stickersets)
        object.__setattr__(self, 'uninstall', uninstall)
        object.__setattr__(self, 'archive', archive)
        object.__setattr__(self, 'unarchive', unarchive)

    def _bytes(self):
        return b''.join((
            b'\xea/\x05\xb5',
            struct.pack('<I', (0 if self.uninstall is None or self.uninstall is False else 1) | (0 if self.archive is None or self.archive is False else 2) | (0 if self.unarchive is None or self.unarchive is False else 4)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickersets)),b''.join(x._bytes() for x in self.stickersets),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _uninstall = bool(flags & 1)
        _archive = bool(flags & 2)
        _unarchive = bool(flags & 4)
        reader.read_int()
        _stickersets = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _stickersets.append(_x)

        return cls(stickersets=_stickersets, uninstall=_uninstall, archive=_archive, unarchive=_unarchive)


@dataclasses.dataclass(init=False, frozen=True)
class TranslateText(TLRequest):
    """
    :returns messages.TranslatedText: Instance of either TranslateNoResult, TranslateResultText.
    """
    __slots__ = ('to_lang', 'peer', 'msg_id', 'text', 'from_lang',)
    CONSTRUCTOR_ID = 0x24ce6dee
    SUBCLASS_OF_ID = 0x24243e8

    to_lang: str
    peer: Optional['TypeInputPeer']
    msg_id: Optional[int]
    text: Optional[str]
    from_lang: Optional[str]
    def __init__(self, to_lang: str, peer: Optional['TypeInputPeer']=None, msg_id: Optional[int]=None, text: Optional[str]=None, from_lang: Optional[str]=None):
        object.__setattr__(self, 'to_lang', to_lang)
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'from_lang', from_lang)

    async def _resolve(self, client, utils):
        r = {}
        if self.peer:
            r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        assert ((self.peer or self.peer is not None) and (self.msg_id or self.msg_id is not None)) or ((self.peer is None or self.peer is False) and (self.msg_id is None or self.msg_id is False)), 'peer, msg_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xeem\xce$',
            struct.pack('<I', (0 if self.peer is None or self.peer is False else 1) | (0 if self.msg_id is None or self.msg_id is False else 1) | (0 if self.text is None or self.text is False else 2) | (0 if self.from_lang is None or self.from_lang is False else 4)),
            b'' if self.peer is None or self.peer is False else (self.peer._bytes()),
            b'' if self.msg_id is None or self.msg_id is False else (struct.pack('<i', self.msg_id)),
            b'' if self.text is None or self.text is False else (self._serialize_bytes(self.text)),
            b'' if self.from_lang is None or self.from_lang is False else (self._serialize_bytes(self.from_lang)),
            self._serialize_bytes(self.to_lang),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _peer = reader.tgread_object()
        else:
            _peer = None
        if flags & 1:
            _msg_id = reader.read_int()
        else:
            _msg_id = None
        if flags & 2:
            _text = reader.tgread_string()
        else:
            _text = None
        if flags & 4:
            _from_lang = reader.tgread_string()
        else:
            _from_lang = None
        _to_lang = reader.tgread_string()
        return cls(to_lang=_to_lang, peer=_peer, msg_id=_msg_id, text=_text, from_lang=_from_lang)


@dataclasses.dataclass(init=False, frozen=True)
class UninstallStickerSet(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('stickerset',)
    CONSTRUCTOR_ID = 0xf96e55de
    SUBCLASS_OF_ID = 0xf5b399ac

    stickerset: 'TypeInputStickerSet'
    def __init__(self, stickerset: 'TypeInputStickerSet'):
        object.__setattr__(self, 'stickerset', stickerset)

    def _bytes(self):
        return b''.join((
            b'\xdeUn\xf9',
            self.stickerset._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        return cls(stickerset=_stickerset)


@dataclasses.dataclass(init=False, frozen=True)
class UnpinAllMessages(TLRequest):
    """
    :returns messages.AffectedHistory: Instance of AffectedHistory.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0xf025bc8b
    SUBCLASS_OF_ID = 0x2c49c116

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x8b\xbc%\xf0',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class UpdateDialogFilter(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('id', 'filter',)
    CONSTRUCTOR_ID = 0x1ad4a04a
    SUBCLASS_OF_ID = 0xf5b399ac

    id: int
    filter: Optional['TypeDialogFilter']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, filter: Optional['TypeDialogFilter']=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'filter', filter)

    def _bytes(self):
        return b''.join((
            b'J\xa0\xd4\x1a',
            struct.pack('<I', (0 if self.filter is None or self.filter is False else 1)),
            struct.pack('<i', self.id),
            b'' if self.filter is None or self.filter is False else (self.filter._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.read_int()
        if flags & 1:
            _filter = reader.tgread_object()
        else:
            _filter = None
        return cls(id=_id, filter=_filter)


@dataclasses.dataclass(init=False, frozen=True)
class UpdateDialogFiltersOrder(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('order',)
    CONSTRUCTOR_ID = 0xc563c1e4
    SUBCLASS_OF_ID = 0xf5b399ac

    order: List[int]
    def __init__(self, order: List[int]):
        object.__setattr__(self, 'order', order)

    def _bytes(self):
        return b''.join((
            b'\xe4\xc1c\xc5',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.order)),b''.join(struct.pack('<i', x) for x in self.order),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _order = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _order.append(_x)

        return cls(order=_order)


@dataclasses.dataclass(init=False, frozen=True)
class UpdatePinnedMessage(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('peer', 'id', 'silent', 'unpin', 'pm_oneside',)
    CONSTRUCTOR_ID = 0xd2aaf7ec
    SUBCLASS_OF_ID = 0x8af52aac

    peer: 'TypeInputPeer'
    id: int
    silent: Optional[bool]
    unpin: Optional[bool]
    pm_oneside: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int, silent: Optional[bool]=None, unpin: Optional[bool]=None, pm_oneside: Optional[bool]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'silent', silent)
        object.__setattr__(self, 'unpin', unpin)
        object.__setattr__(self, 'pm_oneside', pm_oneside)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xec\xf7\xaa\xd2',
            struct.pack('<I', (0 if self.silent is None or self.silent is False else 1) | (0 if self.unpin is None or self.unpin is False else 2) | (0 if self.pm_oneside is None or self.pm_oneside is False else 4)),
            self.peer._bytes(),
            struct.pack('<i', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _silent = bool(flags & 1)
        _unpin = bool(flags & 2)
        _pm_oneside = bool(flags & 4)
        _peer = reader.tgread_object()
        _id = reader.read_int()
        return cls(peer=_peer, id=_id, silent=_silent, unpin=_unpin, pm_oneside=_pm_oneside)


@dataclasses.dataclass(init=False, frozen=True)
class UploadEncryptedFile(TLRequest):
    """
    :returns EncryptedFile: Instance of either EncryptedFileEmpty, EncryptedFile.
    """
    __slots__ = ('peer', 'file',)
    CONSTRUCTOR_ID = 0x5057c497
    SUBCLASS_OF_ID = 0x842a67c0

    peer: 'TypeInputEncryptedChat'
    file: 'TypeInputEncryptedFile'
    def __init__(self, peer: 'TypeInputEncryptedChat', file: 'TypeInputEncryptedFile'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'file', file)

    def _bytes(self):
        return b''.join((
            b'\x97\xc4WP',
            self.peer._bytes(),
            self.file._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _file = reader.tgread_object()
        return cls(peer=_peer, file=_file)


@dataclasses.dataclass(init=False, frozen=True)
class UploadImportedMedia(TLRequest):
    """
    :returns MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('peer', 'import_id', 'file_name', 'media',)
    CONSTRUCTOR_ID = 0x2a862092
    SUBCLASS_OF_ID = 0x476cbe32

    peer: 'TypeInputPeer'
    import_id: int
    file_name: str
    media: 'TypeInputMedia'
    def __init__(self, peer: 'TypeInputPeer', import_id: int, file_name: str, media: 'TypeInputMedia'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'import_id', import_id)
        object.__setattr__(self, 'file_name', file_name)
        object.__setattr__(self, 'media', media)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        r['media'] = utils.get_input_media(self.media)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x92 \x86*',
            self.peer._bytes(),
            struct.pack('<q', self.import_id),
            self._serialize_bytes(self.file_name),
            self.media._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _import_id = reader.read_long()
        _file_name = reader.tgread_string()
        _media = reader.tgread_object()
        return cls(peer=_peer, import_id=_import_id, file_name=_file_name, media=_media)


@dataclasses.dataclass(init=False, frozen=True)
class UploadMedia(TLRequest):
    """
    :returns MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('peer', 'media',)
    CONSTRUCTOR_ID = 0x519bc2b1
    SUBCLASS_OF_ID = 0x476cbe32

    peer: 'TypeInputPeer'
    media: 'TypeInputMedia'
    def __init__(self, peer: 'TypeInputPeer', media: 'TypeInputMedia'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'media', media)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        r['media'] = utils.get_input_media(self.media)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xb1\xc2\x9bQ',
            self.peer._bytes(),
            self.media._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _media = reader.tgread_object()
        return cls(peer=_peer, media=_media)

