"""File generated by TLObjects' generator. All changes will be ERASED"""
from ..._misc.tlobject import TLObject, TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from .. import TypeInputContact, TypeInputGeoPoint, TypeInputPeer, TypeInputUser, TypeTopPeerCategory



@dataclasses.dataclass(init=False, frozen=True)
class AcceptContact(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0xf831a20f
    SUBCLASS_OF_ID = 0x8af52aac

    id: 'TypeInputUser'
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputUser'):
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['id'] = utils.get_input_user(await client._get_input_peer(self.id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x0f\xa21\xf8',
            self.id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class AddContact(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('id', 'first_name', 'last_name', 'phone', 'add_phone_privacy_exception',)
    CONSTRUCTOR_ID = 0xe8f463d0
    SUBCLASS_OF_ID = 0x8af52aac

    id: 'TypeInputUser'
    first_name: str
    last_name: str
    phone: str
    add_phone_privacy_exception: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputUser', first_name: str, last_name: str, phone: str, add_phone_privacy_exception: Optional[bool]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'first_name', first_name)
        object.__setattr__(self, 'last_name', last_name)
        object.__setattr__(self, 'phone', phone)
        object.__setattr__(self, 'add_phone_privacy_exception', add_phone_privacy_exception)

    async def _resolve(self, client, utils):
        r = {}
        r['id'] = utils.get_input_user(await client._get_input_peer(self.id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xd0c\xf4\xe8',
            struct.pack('<I', (0 if self.add_phone_privacy_exception is None or self.add_phone_privacy_exception is False else 1)),
            self.id._bytes(),
            self._serialize_bytes(self.first_name),
            self._serialize_bytes(self.last_name),
            self._serialize_bytes(self.phone),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _add_phone_privacy_exception = bool(flags & 1)
        _id = reader.tgread_object()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _phone = reader.tgread_string()
        return cls(id=_id, first_name=_first_name, last_name=_last_name, phone=_phone, add_phone_privacy_exception=_add_phone_privacy_exception)


@dataclasses.dataclass(init=False, frozen=True)
class Block(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x68cc1411
    SUBCLASS_OF_ID = 0xf5b399ac

    id: 'TypeInputPeer'
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputPeer'):
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['id'] = utils.get_input_peer(await client._get_input_peer(self.id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x11\x14\xcch',
            self.id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class BlockFromReplies(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('msg_id', 'delete_message', 'delete_history', 'report_spam',)
    CONSTRUCTOR_ID = 0x29a8962c
    SUBCLASS_OF_ID = 0x8af52aac

    msg_id: int
    delete_message: Optional[bool]
    delete_history: Optional[bool]
    report_spam: Optional[bool]
    def __init__(self, msg_id: int, delete_message: Optional[bool]=None, delete_history: Optional[bool]=None, report_spam: Optional[bool]=None):
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'delete_message', delete_message)
        object.__setattr__(self, 'delete_history', delete_history)
        object.__setattr__(self, 'report_spam', report_spam)

    def _bytes(self):
        return b''.join((
            b',\x96\xa8)',
            struct.pack('<I', (0 if self.delete_message is None or self.delete_message is False else 1) | (0 if self.delete_history is None or self.delete_history is False else 2) | (0 if self.report_spam is None or self.report_spam is False else 4)),
            struct.pack('<i', self.msg_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _delete_message = bool(flags & 1)
        _delete_history = bool(flags & 2)
        _report_spam = bool(flags & 4)
        _msg_id = reader.read_int()
        return cls(msg_id=_msg_id, delete_message=_delete_message, delete_history=_delete_history, report_spam=_report_spam)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteByPhones(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('phones',)
    CONSTRUCTOR_ID = 0x1013fd9e
    SUBCLASS_OF_ID = 0xf5b399ac

    phones: List[str]
    def __init__(self, phones: List[str]):
        object.__setattr__(self, 'phones', phones)

    def _bytes(self):
        return b''.join((
            b'\x9e\xfd\x13\x10',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.phones)),b''.join(self._serialize_bytes(x) for x in self.phones),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _phones = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _phones.append(_x)

        return cls(phones=_phones)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteContacts(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x96a0e00
    SUBCLASS_OF_ID = 0x8af52aac

    id: List['TypeInputUser']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: List['TypeInputUser']):
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['id'] = []
        for x in self.id:
            r['id'].append(utils.get_input_user(await client._get_input_peer(x)))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x00\x0ej\t',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(x._bytes() for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _id.append(_x)

        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetBlocked(TLRequest):
    """
    :returns contacts.Blocked: Instance of either Blocked, BlockedSlice.
    """
    __slots__ = ('offset', 'limit',)
    CONSTRUCTOR_ID = 0xf57c350f
    SUBCLASS_OF_ID = 0xffba4f4f

    offset: int
    limit: int
    def __init__(self, offset: int, limit: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'limit', limit)

    def _bytes(self):
        return b''.join((
            b'\x0f5|\xf5',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _limit = reader.read_int()
        return cls(offset=_offset, limit=_limit)


@dataclasses.dataclass(init=False, frozen=True)
class GetContactIDs(TLRequest):
    """
    :returns Vector<int>: This type has no constructors.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0x7adc669d
    SUBCLASS_OF_ID = 0x5026710f

    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\x9df\xdcz',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)

    @staticmethod
    def _read_result(reader):
        reader.read_int()  # Vector ID
        return [reader.read_int() for _ in range(reader.read_int())]


@dataclasses.dataclass(init=False, frozen=True)
class GetContacts(TLRequest):
    """
    :returns contacts.Contacts: Instance of either ContactsNotModified, Contacts.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0x5dd69e12
    SUBCLASS_OF_ID = 0x38be25f6

    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\x12\x9e\xd6]',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetLocated(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('geo_point', 'background', 'self_expires',)
    CONSTRUCTOR_ID = 0xd348bc44
    SUBCLASS_OF_ID = 0x8af52aac

    geo_point: 'TypeInputGeoPoint'
    background: Optional[bool]
    self_expires: Optional[int]
    def __init__(self, geo_point: 'TypeInputGeoPoint', background: Optional[bool]=None, self_expires: Optional[int]=None):
        object.__setattr__(self, 'geo_point', geo_point)
        object.__setattr__(self, 'background', background)
        object.__setattr__(self, 'self_expires', self_expires)

    def _bytes(self):
        return b''.join((
            b'D\xbcH\xd3',
            struct.pack('<I', (0 if self.background is None or self.background is False else 2) | (0 if self.self_expires is None or self.self_expires is False else 1)),
            self.geo_point._bytes(),
            b'' if self.self_expires is None or self.self_expires is False else (struct.pack('<i', self.self_expires)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _background = bool(flags & 2)
        _geo_point = reader.tgread_object()
        if flags & 1:
            _self_expires = reader.read_int()
        else:
            _self_expires = None
        return cls(geo_point=_geo_point, background=_background, self_expires=_self_expires)


@dataclasses.dataclass(init=False, frozen=True)
class GetSaved(TLRequest):
    """
    :returns Vector<SavedContact>: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x82f1e39f
    SUBCLASS_OF_ID = 0x975dbef

    def _bytes(self):
        return b''.join((
            b'\x9f\xe3\xf1\x82',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetStatuses(TLRequest):
    """
    :returns Vector<ContactStatus>: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xc4a353ee
    SUBCLASS_OF_ID = 0xdf815c90

    def _bytes(self):
        return b''.join((
            b'\xeeS\xa3\xc4',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetTopPeers(TLRequest):
    """
    :returns contacts.TopPeers: Instance of either TopPeersNotModified, TopPeers, TopPeersDisabled.
    """
    __slots__ = ('offset', 'limit', 'hash', 'correspondents', 'bots_pm', 'bots_inline', 'phone_calls', 'forward_users', 'forward_chats', 'groups', 'channels',)
    CONSTRUCTOR_ID = 0x973478b6
    SUBCLASS_OF_ID = 0x9ee8bb88

    offset: int
    limit: int
    hash: int
    correspondents: Optional[bool]
    bots_pm: Optional[bool]
    bots_inline: Optional[bool]
    phone_calls: Optional[bool]
    forward_users: Optional[bool]
    forward_chats: Optional[bool]
    groups: Optional[bool]
    channels: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, offset: int, limit: int, hash: int, correspondents: Optional[bool]=None, bots_pm: Optional[bool]=None, bots_inline: Optional[bool]=None, phone_calls: Optional[bool]=None, forward_users: Optional[bool]=None, forward_chats: Optional[bool]=None, groups: Optional[bool]=None, channels: Optional[bool]=None):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'correspondents', correspondents)
        object.__setattr__(self, 'bots_pm', bots_pm)
        object.__setattr__(self, 'bots_inline', bots_inline)
        object.__setattr__(self, 'phone_calls', phone_calls)
        object.__setattr__(self, 'forward_users', forward_users)
        object.__setattr__(self, 'forward_chats', forward_chats)
        object.__setattr__(self, 'groups', groups)
        object.__setattr__(self, 'channels', channels)

    def _bytes(self):
        return b''.join((
            b'\xb6x4\x97',
            struct.pack('<I', (0 if self.correspondents is None or self.correspondents is False else 1) | (0 if self.bots_pm is None or self.bots_pm is False else 2) | (0 if self.bots_inline is None or self.bots_inline is False else 4) | (0 if self.phone_calls is None or self.phone_calls is False else 8) | (0 if self.forward_users is None or self.forward_users is False else 16) | (0 if self.forward_chats is None or self.forward_chats is False else 32) | (0 if self.groups is None or self.groups is False else 1024) | (0 if self.channels is None or self.channels is False else 32768)),
            struct.pack('<i', self.offset),
            struct.pack('<i', self.limit),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _correspondents = bool(flags & 1)
        _bots_pm = bool(flags & 2)
        _bots_inline = bool(flags & 4)
        _phone_calls = bool(flags & 8)
        _forward_users = bool(flags & 16)
        _forward_chats = bool(flags & 32)
        _groups = bool(flags & 1024)
        _channels = bool(flags & 32768)
        _offset = reader.read_int()
        _limit = reader.read_int()
        _hash = reader.read_long()
        return cls(offset=_offset, limit=_limit, hash=_hash, correspondents=_correspondents, bots_pm=_bots_pm, bots_inline=_bots_inline, phone_calls=_phone_calls, forward_users=_forward_users, forward_chats=_forward_chats, groups=_groups, channels=_channels)


@dataclasses.dataclass(init=False, frozen=True)
class ImportContacts(TLRequest):
    """
    :returns contacts.ImportedContacts: Instance of ImportedContacts.
    """
    __slots__ = ('contacts',)
    CONSTRUCTOR_ID = 0x2c800be5
    SUBCLASS_OF_ID = 0x8172ad93

    contacts: List['TypeInputContact']
    def __init__(self, contacts: List['TypeInputContact']):
        object.__setattr__(self, 'contacts', contacts)

    def _bytes(self):
        return b''.join((
            b'\xe5\x0b\x80,',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.contacts)),b''.join(x._bytes() for x in self.contacts),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _contacts = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _contacts.append(_x)

        return cls(contacts=_contacts)


@dataclasses.dataclass(init=False, frozen=True)
class ResetSaved(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x879537f1
    SUBCLASS_OF_ID = 0xf5b399ac

    def _bytes(self):
        return b''.join((
            b'\xf17\x95\x87',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ResetTopPeerRating(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('category', 'peer',)
    CONSTRUCTOR_ID = 0x1ae373ac
    SUBCLASS_OF_ID = 0xf5b399ac

    category: 'TypeTopPeerCategory'
    peer: 'TypeInputPeer'
    def __init__(self, category: 'TypeTopPeerCategory', peer: 'TypeInputPeer'):
        object.__setattr__(self, 'category', category)
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xacs\xe3\x1a',
            self.category._bytes(),
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _category = reader.tgread_object()
        _peer = reader.tgread_object()
        return cls(category=_category, peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class ResolvePhone(TLRequest):
    """
    :returns contacts.ResolvedPeer: Instance of ResolvedPeer.
    """
    __slots__ = ('phone',)
    CONSTRUCTOR_ID = 0x8af94344
    SUBCLASS_OF_ID = 0xf065b3a8

    phone: str
    def __init__(self, phone: str):
        object.__setattr__(self, 'phone', phone)

    def _bytes(self):
        return b''.join((
            b'DC\xf9\x8a',
            self._serialize_bytes(self.phone),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone = reader.tgread_string()
        return cls(phone=_phone)


@dataclasses.dataclass(init=False, frozen=True)
class ResolveUsername(TLRequest):
    """
    :returns contacts.ResolvedPeer: Instance of ResolvedPeer.
    """
    __slots__ = ('username',)
    CONSTRUCTOR_ID = 0xf93ccba3
    SUBCLASS_OF_ID = 0xf065b3a8

    username: str
    def __init__(self, username: str):
        object.__setattr__(self, 'username', username)

    def _bytes(self):
        return b''.join((
            b'\xa3\xcb<\xf9',
            self._serialize_bytes(self.username),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _username = reader.tgread_string()
        return cls(username=_username)


@dataclasses.dataclass(init=False, frozen=True)
class Search(TLRequest):
    """
    :returns contacts.Found: Instance of Found.
    """
    __slots__ = ('q', 'limit',)
    CONSTRUCTOR_ID = 0x11f812d8
    SUBCLASS_OF_ID = 0x4386a2e3

    q: str
    limit: int
    def __init__(self, q: str, limit: int):
        object.__setattr__(self, 'q', q)
        object.__setattr__(self, 'limit', limit)

    def _bytes(self):
        return b''.join((
            b'\xd8\x12\xf8\x11',
            self._serialize_bytes(self.q),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _q = reader.tgread_string()
        _limit = reader.read_int()
        return cls(q=_q, limit=_limit)


@dataclasses.dataclass(init=False, frozen=True)
class ToggleTopPeers(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('enabled',)
    CONSTRUCTOR_ID = 0x8514bdda
    SUBCLASS_OF_ID = 0xf5b399ac

    enabled: bool
    def __init__(self, enabled: bool):
        object.__setattr__(self, 'enabled', enabled)

    def _bytes(self):
        return b''.join((
            b'\xda\xbd\x14\x85',
            b'\xb5ur\x99' if self.enabled else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _enabled = reader.tgread_bool()
        return cls(enabled=_enabled)


@dataclasses.dataclass(init=False, frozen=True)
class Unblock(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0xbea65d50
    SUBCLASS_OF_ID = 0xf5b399ac

    id: 'TypeInputPeer'
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputPeer'):
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['id'] = utils.get_input_peer(await client._get_input_peer(self.id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'P]\xa6\xbe',
            self.id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)

