"""File generated by TLObjects' generator. All changes will be ERASED"""
from ..._misc.tlobject import TLObject, TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from .. import TypeChannelAdminLogEventsFilter, TypeChannelParticipantsFilter, TypeChatAdminRights, TypeChatBannedRights, TypeInputChannel, TypeInputChatPhoto, TypeInputCheckPasswordSRP, TypeInputGeoPoint, TypeInputMessage, TypeInputPeer, TypeInputStickerSet, TypeInputUser



@dataclasses.dataclass(init=False, frozen=True)
class CheckUsername(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('channel', 'username',)
    CONSTRUCTOR_ID = 0x10e6bd2c
    SUBCLASS_OF_ID = 0xf5b399ac

    channel: 'TypeInputChannel'
    username: str
    def __init__(self, channel: 'TypeInputChannel', username: str):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'username', username)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b',\xbd\xe6\x10',
            self.channel._bytes(),
            self._serialize_bytes(self.username),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _username = reader.tgread_string()
        return cls(channel=_channel, username=_username)


@dataclasses.dataclass(init=False, frozen=True)
class ConvertToGigagroup(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel',)
    CONSTRUCTOR_ID = 0xb290c69
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    def __init__(self, channel: 'TypeInputChannel'):
        object.__setattr__(self, 'channel', channel)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'i\x0c)\x0b',
            self.channel._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


@dataclasses.dataclass(init=False, frozen=True)
class CreateChannel(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('title', 'about', 'broadcast', 'megagroup', 'for_import', 'geo_point', 'address',)
    CONSTRUCTOR_ID = 0x3d5fb10f
    SUBCLASS_OF_ID = 0x8af52aac

    title: str
    about: str
    broadcast: Optional[bool]
    megagroup: Optional[bool]
    for_import: Optional[bool]
    geo_point: Optional['TypeInputGeoPoint']
    address: Optional[str]
    def __init__(self, title: str, about: str, broadcast: Optional[bool]=None, megagroup: Optional[bool]=None, for_import: Optional[bool]=None, geo_point: Optional['TypeInputGeoPoint']=None, address: Optional[str]=None):
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'about', about)
        object.__setattr__(self, 'broadcast', broadcast)
        object.__setattr__(self, 'megagroup', megagroup)
        object.__setattr__(self, 'for_import', for_import)
        object.__setattr__(self, 'geo_point', geo_point)
        object.__setattr__(self, 'address', address)

    def _bytes(self):
        assert ((self.geo_point or self.geo_point is not None) and (self.address or self.address is not None)) or ((self.geo_point is None or self.geo_point is False) and (self.address is None or self.address is False)), 'geo_point, address parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\x0f\xb1_=',
            struct.pack('<I', (0 if self.broadcast is None or self.broadcast is False else 1) | (0 if self.megagroup is None or self.megagroup is False else 2) | (0 if self.for_import is None or self.for_import is False else 8) | (0 if self.geo_point is None or self.geo_point is False else 4) | (0 if self.address is None or self.address is False else 4)),
            self._serialize_bytes(self.title),
            self._serialize_bytes(self.about),
            b'' if self.geo_point is None or self.geo_point is False else (self.geo_point._bytes()),
            b'' if self.address is None or self.address is False else (self._serialize_bytes(self.address)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _broadcast = bool(flags & 1)
        _megagroup = bool(flags & 2)
        _for_import = bool(flags & 8)
        _title = reader.tgread_string()
        _about = reader.tgread_string()
        if flags & 4:
            _geo_point = reader.tgread_object()
        else:
            _geo_point = None
        if flags & 4:
            _address = reader.tgread_string()
        else:
            _address = None
        return cls(title=_title, about=_about, broadcast=_broadcast, megagroup=_megagroup, for_import=_for_import, geo_point=_geo_point, address=_address)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteChannel(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel',)
    CONSTRUCTOR_ID = 0xc0111fe3
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    def __init__(self, channel: 'TypeInputChannel'):
        object.__setattr__(self, 'channel', channel)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xe3\x1f\x11\xc0',
            self.channel._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteHistory(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('channel', 'max_id',)
    CONSTRUCTOR_ID = 0xaf369d42
    SUBCLASS_OF_ID = 0xf5b399ac

    channel: 'TypeInputChannel'
    max_id: int
    def __init__(self, channel: 'TypeInputChannel', max_id: int):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'max_id', max_id)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'B\x9d6\xaf',
            self.channel._bytes(),
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _max_id = reader.read_int()
        return cls(channel=_channel, max_id=_max_id)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteMessages(TLRequest):
    """
    :returns messages.AffectedMessages: Instance of AffectedMessages.
    """
    __slots__ = ('channel', 'id',)
    CONSTRUCTOR_ID = 0x84c1fd4e
    SUBCLASS_OF_ID = 0xced3c06e

    channel: 'TypeInputChannel'
    id: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', id: List[int]):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'N\xfd\xc1\x84',
            self.channel._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(channel=_channel, id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteParticipantHistory(TLRequest):
    """
    :returns messages.AffectedHistory: Instance of AffectedHistory.
    """
    __slots__ = ('channel', 'participant',)
    CONSTRUCTOR_ID = 0x367544db
    SUBCLASS_OF_ID = 0x2c49c116

    channel: 'TypeInputChannel'
    participant: 'TypeInputPeer'
    def __init__(self, channel: 'TypeInputChannel', participant: 'TypeInputPeer'):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'participant', participant)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        r['participant'] = utils.get_input_peer(await client._get_input_peer(self.participant))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xdbDu6',
            self.channel._bytes(),
            self.participant._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _participant = reader.tgread_object()
        return cls(channel=_channel, participant=_participant)


@dataclasses.dataclass(init=False, frozen=True)
class EditAdmin(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel', 'user_id', 'admin_rights', 'rank',)
    CONSTRUCTOR_ID = 0xd33c8902
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    user_id: 'TypeInputUser'
    admin_rights: 'TypeChatAdminRights'
    rank: str
    def __init__(self, channel: 'TypeInputChannel', user_id: 'TypeInputUser', admin_rights: 'TypeChatAdminRights', rank: str):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'admin_rights', admin_rights)
        object.__setattr__(self, 'rank', rank)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x02\x89<\xd3',
            self.channel._bytes(),
            self.user_id._bytes(),
            self.admin_rights._bytes(),
            self._serialize_bytes(self.rank),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _user_id = reader.tgread_object()
        _admin_rights = reader.tgread_object()
        _rank = reader.tgread_string()
        return cls(channel=_channel, user_id=_user_id, admin_rights=_admin_rights, rank=_rank)


@dataclasses.dataclass(init=False, frozen=True)
class EditBanned(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel', 'participant', 'banned_rights',)
    CONSTRUCTOR_ID = 0x96e6cd81
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    participant: 'TypeInputPeer'
    banned_rights: 'TypeChatBannedRights'
    def __init__(self, channel: 'TypeInputChannel', participant: 'TypeInputPeer', banned_rights: 'TypeChatBannedRights'):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'participant', participant)
        object.__setattr__(self, 'banned_rights', banned_rights)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        r['participant'] = utils.get_input_peer(await client._get_input_peer(self.participant))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x81\xcd\xe6\x96',
            self.channel._bytes(),
            self.participant._bytes(),
            self.banned_rights._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _participant = reader.tgread_object()
        _banned_rights = reader.tgread_object()
        return cls(channel=_channel, participant=_participant, banned_rights=_banned_rights)


@dataclasses.dataclass(init=False, frozen=True)
class EditCreator(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel', 'user_id', 'password',)
    CONSTRUCTOR_ID = 0x8f38cd1f
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    user_id: 'TypeInputUser'
    password: 'TypeInputCheckPasswordSRP'
    def __init__(self, channel: 'TypeInputChannel', user_id: 'TypeInputUser', password: 'TypeInputCheckPasswordSRP'):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'password', password)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        r['user_id'] = utils.get_input_user(await client._get_input_peer(self.user_id))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x1f\xcd8\x8f',
            self.channel._bytes(),
            self.user_id._bytes(),
            self.password._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _user_id = reader.tgread_object()
        _password = reader.tgread_object()
        return cls(channel=_channel, user_id=_user_id, password=_password)


@dataclasses.dataclass(init=False, frozen=True)
class EditLocation(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('channel', 'geo_point', 'address',)
    CONSTRUCTOR_ID = 0x58e63f6d
    SUBCLASS_OF_ID = 0xf5b399ac

    channel: 'TypeInputChannel'
    geo_point: 'TypeInputGeoPoint'
    address: str
    def __init__(self, channel: 'TypeInputChannel', geo_point: 'TypeInputGeoPoint', address: str):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'geo_point', geo_point)
        object.__setattr__(self, 'address', address)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'm?\xe6X',
            self.channel._bytes(),
            self.geo_point._bytes(),
            self._serialize_bytes(self.address),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _geo_point = reader.tgread_object()
        _address = reader.tgread_string()
        return cls(channel=_channel, geo_point=_geo_point, address=_address)


@dataclasses.dataclass(init=False, frozen=True)
class EditPhoto(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel', 'photo',)
    CONSTRUCTOR_ID = 0xf12e57c9
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    photo: 'TypeInputChatPhoto'
    def __init__(self, channel: 'TypeInputChannel', photo: 'TypeInputChatPhoto'):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'photo', photo)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        r['photo'] = utils.get_input_chat_photo(self.photo)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xc9W.\xf1',
            self.channel._bytes(),
            self.photo._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _photo = reader.tgread_object()
        return cls(channel=_channel, photo=_photo)


@dataclasses.dataclass(init=False, frozen=True)
class EditTitle(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel', 'title',)
    CONSTRUCTOR_ID = 0x566decd0
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    title: str
    def __init__(self, channel: 'TypeInputChannel', title: str):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'title', title)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xd0\xecmV',
            self.channel._bytes(),
            self._serialize_bytes(self.title),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _title = reader.tgread_string()
        return cls(channel=_channel, title=_title)


@dataclasses.dataclass(init=False, frozen=True)
class ExportMessageLink(TLRequest):
    """
    :returns ExportedMessageLink: Instance of ExportedMessageLink.
    """
    __slots__ = ('channel', 'id', 'grouped', 'thread',)
    CONSTRUCTOR_ID = 0xe63fadeb
    SUBCLASS_OF_ID = 0xdee644cc

    channel: 'TypeInputChannel'
    id: int
    grouped: Optional[bool]
    thread: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', id: int, grouped: Optional[bool]=None, thread: Optional[bool]=None):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'grouped', grouped)
        object.__setattr__(self, 'thread', thread)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xeb\xad?\xe6',
            struct.pack('<I', (0 if self.grouped is None or self.grouped is False else 1) | (0 if self.thread is None or self.thread is False else 2)),
            self.channel._bytes(),
            struct.pack('<i', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _grouped = bool(flags & 1)
        _thread = bool(flags & 2)
        _channel = reader.tgread_object()
        _id = reader.read_int()
        return cls(channel=_channel, id=_id, grouped=_grouped, thread=_thread)


@dataclasses.dataclass(init=False, frozen=True)
class GetAdminLog(TLRequest):
    """
    :returns channels.AdminLogResults: Instance of AdminLogResults.
    """
    __slots__ = ('channel', 'q', 'max_id', 'min_id', 'limit', 'events_filter', 'admins',)
    CONSTRUCTOR_ID = 0x33ddf480
    SUBCLASS_OF_ID = 0x51f076bc

    channel: 'TypeInputChannel'
    q: str
    max_id: int
    min_id: int
    limit: int
    events_filter: Optional['TypeChannelAdminLogEventsFilter']
    admins: Optional[List['TypeInputUser']]
    def __init__(self, channel: 'TypeInputChannel', q: str, max_id: int, min_id: int, limit: int, events_filter: Optional['TypeChannelAdminLogEventsFilter']=None, admins: Optional[List['TypeInputUser']]=None):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'q', q)
        object.__setattr__(self, 'max_id', max_id)
        object.__setattr__(self, 'min_id', min_id)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'events_filter', events_filter)
        object.__setattr__(self, 'admins', admins)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        if self.admins:
            r['admins'] = []
            for x in self.admins:
                r['admins'].append(utils.get_input_user(await client._get_input_peer(x)))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x80\xf4\xdd3',
            struct.pack('<I', (0 if self.events_filter is None or self.events_filter is False else 1) | (0 if self.admins is None or self.admins is False else 2)),
            self.channel._bytes(),
            self._serialize_bytes(self.q),
            b'' if self.events_filter is None or self.events_filter is False else (self.events_filter._bytes()),
            b'' if self.admins is None or self.admins is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.admins)),b''.join(x._bytes() for x in self.admins))),
            struct.pack('<q', self.max_id),
            struct.pack('<q', self.min_id),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _channel = reader.tgread_object()
        _q = reader.tgread_string()
        if flags & 1:
            _events_filter = reader.tgread_object()
        else:
            _events_filter = None
        if flags & 2:
            reader.read_int()
            _admins = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _admins.append(_x)

        else:
            _admins = None
        _max_id = reader.read_long()
        _min_id = reader.read_long()
        _limit = reader.read_int()
        return cls(channel=_channel, q=_q, max_id=_max_id, min_id=_min_id, limit=_limit, events_filter=_events_filter, admins=_admins)


@dataclasses.dataclass(init=False, frozen=True)
class GetAdminedPublicChannels(TLRequest):
    """
    :returns messages.Chats: Instance of either Chats, ChatsSlice.
    """
    __slots__ = ('by_location', 'check_limit',)
    CONSTRUCTOR_ID = 0xf8b036af
    SUBCLASS_OF_ID = 0x99d5cb14

    by_location: Optional[bool]
    check_limit: Optional[bool]
    def __init__(self, by_location: Optional[bool]=None, check_limit: Optional[bool]=None):
        object.__setattr__(self, 'by_location', by_location)
        object.__setattr__(self, 'check_limit', check_limit)

    def _bytes(self):
        return b''.join((
            b'\xaf6\xb0\xf8',
            struct.pack('<I', (0 if self.by_location is None or self.by_location is False else 1) | (0 if self.check_limit is None or self.check_limit is False else 2)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _by_location = bool(flags & 1)
        _check_limit = bool(flags & 2)
        return cls(by_location=_by_location, check_limit=_check_limit)


@dataclasses.dataclass(init=False, frozen=True)
class GetChannels(TLRequest):
    """
    :returns messages.Chats: Instance of either Chats, ChatsSlice.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0xa7f6bbb
    SUBCLASS_OF_ID = 0x99d5cb14

    id: List['TypeInputChannel']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: List['TypeInputChannel']):
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['id'] = []
        for x in self.id:
            r['id'].append(utils.get_input_channel(await client._get_input_peer(x)))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xbbk\x7f\n',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(x._bytes() for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _id.append(_x)

        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetFullChannel(TLRequest):
    """
    :returns messages.ChatFull: Instance of ChatFull.
    """
    __slots__ = ('channel',)
    CONSTRUCTOR_ID = 0x8736a09
    SUBCLASS_OF_ID = 0x225a5109

    channel: 'TypeInputChannel'
    def __init__(self, channel: 'TypeInputChannel'):
        object.__setattr__(self, 'channel', channel)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\tjs\x08',
            self.channel._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


@dataclasses.dataclass(init=False, frozen=True)
class GetGroupsForDiscussion(TLRequest):
    """
    :returns messages.Chats: Instance of either Chats, ChatsSlice.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xf5dad378
    SUBCLASS_OF_ID = 0x99d5cb14

    def _bytes(self):
        return b''.join((
            b'x\xd3\xda\xf5',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetInactiveChannels(TLRequest):
    """
    :returns messages.InactiveChats: Instance of InactiveChats.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x11e831ee
    SUBCLASS_OF_ID = 0x8bf3d7d4

    def _bytes(self):
        return b''.join((
            b'\xee1\xe8\x11',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetLeftChannels(TLRequest):
    """
    :returns messages.Chats: Instance of either Chats, ChatsSlice.
    """
    __slots__ = ('offset',)
    CONSTRUCTOR_ID = 0x8341ecc0
    SUBCLASS_OF_ID = 0x99d5cb14

    offset: int
    def __init__(self, offset: int):
        object.__setattr__(self, 'offset', offset)

    def _bytes(self):
        return b''.join((
            b'\xc0\xecA\x83',
            struct.pack('<i', self.offset),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        return cls(offset=_offset)


@dataclasses.dataclass(init=False, frozen=True)
class GetMessages(TLRequest):
    """
    :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
    """
    __slots__ = ('channel', 'id',)
    CONSTRUCTOR_ID = 0xad8c9a23
    SUBCLASS_OF_ID = 0xd4b40b5e

    channel: 'TypeInputChannel'
    id: List['TypeInputMessage']
    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', id: List['TypeInputMessage']):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        r['id'] = []
        for x in self.id:
            r['id'].append(utils.get_input_message(x))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'#\x9a\x8c\xad',
            self.channel._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(x._bytes() for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _id.append(_x)

        return cls(channel=_channel, id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetParticipant(TLRequest):
    """
    :returns channels.ChannelParticipant: Instance of ChannelParticipant.
    """
    __slots__ = ('channel', 'participant',)
    CONSTRUCTOR_ID = 0xa0ab6cc6
    SUBCLASS_OF_ID = 0x6658151a

    channel: 'TypeInputChannel'
    participant: 'TypeInputPeer'
    def __init__(self, channel: 'TypeInputChannel', participant: 'TypeInputPeer'):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'participant', participant)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        r['participant'] = utils.get_input_peer(await client._get_input_peer(self.participant))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xc6l\xab\xa0',
            self.channel._bytes(),
            self.participant._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _participant = reader.tgread_object()
        return cls(channel=_channel, participant=_participant)


@dataclasses.dataclass(init=False, frozen=True)
class GetParticipants(TLRequest):
    """
    :returns channels.ChannelParticipants: Instance of either ChannelParticipants, ChannelParticipantsNotModified.
    """
    __slots__ = ('channel', 'filter', 'offset', 'limit', 'hash',)
    CONSTRUCTOR_ID = 0x77ced9d0
    SUBCLASS_OF_ID = 0xe60a6e64

    channel: 'TypeInputChannel'
    filter: 'TypeChannelParticipantsFilter'
    offset: int
    limit: int
    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', filter: 'TypeChannelParticipantsFilter', offset: int, limit: int, hash: int):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'filter', filter)
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'hash', hash)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xd0\xd9\xcew',
            self.channel._bytes(),
            self.filter._bytes(),
            struct.pack('<i', self.offset),
            struct.pack('<i', self.limit),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _filter = reader.tgread_object()
        _offset = reader.read_int()
        _limit = reader.read_int()
        _hash = reader.read_long()
        return cls(channel=_channel, filter=_filter, offset=_offset, limit=_limit, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetSendAs(TLRequest):
    """
    :returns channels.SendAsPeers: Instance of SendAsPeers.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0xdc770ee
    SUBCLASS_OF_ID = 0x38cb8d21

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xeep\xc7\r',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class GetSponsoredMessages(TLRequest):
    """
    :returns messages.SponsoredMessages: Instance of SponsoredMessages.
    """
    __slots__ = ('channel',)
    CONSTRUCTOR_ID = 0xec210fbf
    SUBCLASS_OF_ID = 0x7f4169e0

    channel: 'TypeInputChannel'
    def __init__(self, channel: 'TypeInputChannel'):
        object.__setattr__(self, 'channel', channel)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xbf\x0f!\xec',
            self.channel._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


@dataclasses.dataclass(init=False, frozen=True)
class InviteToChannel(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel', 'users',)
    CONSTRUCTOR_ID = 0x199f3a6c
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    users: List['TypeInputUser']
    def __init__(self, channel: 'TypeInputChannel', users: List['TypeInputUser']):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'users', users)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        r['users'] = []
        for x in self.users:
            r['users'].append(utils.get_input_user(await client._get_input_peer(x)))

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'l:\x9f\x19',
            self.channel._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(channel=_channel, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class JoinChannel(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel',)
    CONSTRUCTOR_ID = 0x24b524c5
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    def __init__(self, channel: 'TypeInputChannel'):
        object.__setattr__(self, 'channel', channel)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xc5$\xb5$',
            self.channel._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


@dataclasses.dataclass(init=False, frozen=True)
class LeaveChannel(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel',)
    CONSTRUCTOR_ID = 0xf836aa95
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    def __init__(self, channel: 'TypeInputChannel'):
        object.__setattr__(self, 'channel', channel)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x95\xaa6\xf8',
            self.channel._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


@dataclasses.dataclass(init=False, frozen=True)
class ReadHistory(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('channel', 'max_id',)
    CONSTRUCTOR_ID = 0xcc104937
    SUBCLASS_OF_ID = 0xf5b399ac

    channel: 'TypeInputChannel'
    max_id: int
    def __init__(self, channel: 'TypeInputChannel', max_id: int):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'max_id', max_id)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'7I\x10\xcc',
            self.channel._bytes(),
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _max_id = reader.read_int()
        return cls(channel=_channel, max_id=_max_id)


@dataclasses.dataclass(init=False, frozen=True)
class ReadMessageContents(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('channel', 'id',)
    CONSTRUCTOR_ID = 0xeab5dc38
    SUBCLASS_OF_ID = 0xf5b399ac

    channel: 'TypeInputChannel'
    id: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', id: List[int]):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'8\xdc\xb5\xea',
            self.channel._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(channel=_channel, id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class ReportSpam(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('channel', 'participant', 'id',)
    CONSTRUCTOR_ID = 0xf44a8315
    SUBCLASS_OF_ID = 0xf5b399ac

    channel: 'TypeInputChannel'
    participant: 'TypeInputPeer'
    id: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, channel: 'TypeInputChannel', participant: 'TypeInputPeer', id: List[int]):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'participant', participant)
        object.__setattr__(self, 'id', id)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        r['participant'] = utils.get_input_peer(await client._get_input_peer(self.participant))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x15\x83J\xf4',
            self.channel._bytes(),
            self.participant._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _participant = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(channel=_channel, participant=_participant, id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class SetDiscussionGroup(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('broadcast', 'group',)
    CONSTRUCTOR_ID = 0x40582bb2
    SUBCLASS_OF_ID = 0xf5b399ac

    broadcast: 'TypeInputChannel'
    group: 'TypeInputChannel'
    def __init__(self, broadcast: 'TypeInputChannel', group: 'TypeInputChannel'):
        object.__setattr__(self, 'broadcast', broadcast)
        object.__setattr__(self, 'group', group)

    async def _resolve(self, client, utils):
        r = {}
        r['broadcast'] = utils.get_input_channel(await client._get_input_peer(self.broadcast))
        r['group'] = utils.get_input_channel(await client._get_input_peer(self.group))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xb2+X@',
            self.broadcast._bytes(),
            self.group._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _broadcast = reader.tgread_object()
        _group = reader.tgread_object()
        return cls(broadcast=_broadcast, group=_group)


@dataclasses.dataclass(init=False, frozen=True)
class SetStickers(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('channel', 'stickerset',)
    CONSTRUCTOR_ID = 0xea8ca4f9
    SUBCLASS_OF_ID = 0xf5b399ac

    channel: 'TypeInputChannel'
    stickerset: 'TypeInputStickerSet'
    def __init__(self, channel: 'TypeInputChannel', stickerset: 'TypeInputStickerSet'):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'stickerset', stickerset)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xf9\xa4\x8c\xea',
            self.channel._bytes(),
            self.stickerset._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _stickerset = reader.tgread_object()
        return cls(channel=_channel, stickerset=_stickerset)


@dataclasses.dataclass(init=False, frozen=True)
class TogglePreHistoryHidden(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel', 'enabled',)
    CONSTRUCTOR_ID = 0xeabbb94c
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    enabled: bool
    def __init__(self, channel: 'TypeInputChannel', enabled: bool):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'enabled', enabled)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'L\xb9\xbb\xea',
            self.channel._bytes(),
            b'\xb5ur\x99' if self.enabled else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _enabled = reader.tgread_bool()
        return cls(channel=_channel, enabled=_enabled)


@dataclasses.dataclass(init=False, frozen=True)
class ToggleSignatures(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel', 'enabled',)
    CONSTRUCTOR_ID = 0x1f69b606
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    enabled: bool
    def __init__(self, channel: 'TypeInputChannel', enabled: bool):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'enabled', enabled)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x06\xb6i\x1f',
            self.channel._bytes(),
            b'\xb5ur\x99' if self.enabled else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _enabled = reader.tgread_bool()
        return cls(channel=_channel, enabled=_enabled)


@dataclasses.dataclass(init=False, frozen=True)
class ToggleSlowMode(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('channel', 'seconds',)
    CONSTRUCTOR_ID = 0xedd49ef0
    SUBCLASS_OF_ID = 0x8af52aac

    channel: 'TypeInputChannel'
    seconds: int
    def __init__(self, channel: 'TypeInputChannel', seconds: int):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'seconds', seconds)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xf0\x9e\xd4\xed',
            self.channel._bytes(),
            struct.pack('<i', self.seconds),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _seconds = reader.read_int()
        return cls(channel=_channel, seconds=_seconds)


@dataclasses.dataclass(init=False, frozen=True)
class UpdateUsername(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('channel', 'username',)
    CONSTRUCTOR_ID = 0x3514b3de
    SUBCLASS_OF_ID = 0xf5b399ac

    channel: 'TypeInputChannel'
    username: str
    def __init__(self, channel: 'TypeInputChannel', username: str):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'username', username)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xde\xb3\x145',
            self.channel._bytes(),
            self._serialize_bytes(self.username),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _username = reader.tgread_string()
        return cls(channel=_channel, username=_username)


@dataclasses.dataclass(init=False, frozen=True)
class ViewSponsoredMessage(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('channel', 'random_id',)
    CONSTRUCTOR_ID = 0xbeaedb94
    SUBCLASS_OF_ID = 0xf5b399ac

    channel: 'TypeInputChannel'
    random_id: bytes
    def __init__(self, channel: 'TypeInputChannel', random_id: bytes=None):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'random_id', random_id)

    async def _resolve(self, client, utils):
        r = {}
        r['channel'] = utils.get_input_channel(await client._get_input_peer(self.channel))
        if self.random_id is None:
            r['random_id'] = int.from_bytes(os.urandom(4), 'big', signed=True)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x94\xdb\xae\xbe',
            self.channel._bytes(),
            self._serialize_bytes(self.random_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        _random_id = reader.tgread_bytes()
        return cls(channel=_channel, random_id=_random_id)

