"""File generated by TLObjects' generator. All changes will be ERASED"""
from ..._misc.tlobject import TLObject, TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from .. import TypeCodeSettings, TypeInputCheckPasswordSRP
    from ...account import TypePasswordInputSettings



@dataclasses.dataclass(init=False, frozen=True)
class AcceptLoginToken(TLRequest):
    """
    :returns Authorization: Instance of Authorization.
    """
    __slots__ = ('token',)
    CONSTRUCTOR_ID = 0xe894ad4d
    SUBCLASS_OF_ID = 0xc913c01a

    token: bytes
    def __init__(self, token: bytes):
        object.__setattr__(self, 'token', token)

    def _bytes(self):
        return b''.join((
            b'M\xad\x94\xe8',
            self._serialize_bytes(self.token),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _token = reader.tgread_bytes()
        return cls(token=_token)


@dataclasses.dataclass(init=False, frozen=True)
class BindTempAuthKey(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('perm_auth_key_id', 'nonce', 'expires_at', 'encrypted_message',)
    CONSTRUCTOR_ID = 0xcdd42a05
    SUBCLASS_OF_ID = 0xf5b399ac

    perm_auth_key_id: int
    nonce: int
    expires_at: Optional[datetime]
    encrypted_message: bytes
    def __init__(self, perm_auth_key_id: int, nonce: int, expires_at: Optional[datetime], encrypted_message: bytes):
        object.__setattr__(self, 'perm_auth_key_id', perm_auth_key_id)
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'expires_at', expires_at)
        object.__setattr__(self, 'encrypted_message', encrypted_message)

    def _bytes(self):
        return b''.join((
            b'\x05*\xd4\xcd',
            struct.pack('<q', self.perm_auth_key_id),
            struct.pack('<q', self.nonce),
            self._serialize_datetime(self.expires_at),
            self._serialize_bytes(self.encrypted_message),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _perm_auth_key_id = reader.read_long()
        _nonce = reader.read_long()
        _expires_at = reader.tgread_date()
        _encrypted_message = reader.tgread_bytes()
        return cls(perm_auth_key_id=_perm_auth_key_id, nonce=_nonce, expires_at=_expires_at, encrypted_message=_encrypted_message)


@dataclasses.dataclass(init=False, frozen=True)
class CancelCode(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('phone_number', 'phone_code_hash',)
    CONSTRUCTOR_ID = 0x1f040578
    SUBCLASS_OF_ID = 0xf5b399ac

    phone_number: str
    phone_code_hash: str
    def __init__(self, phone_number: str, phone_code_hash: str):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'phone_code_hash', phone_code_hash)

    def _bytes(self):
        return b''.join((
            b'x\x05\x04\x1f',
            self._serialize_bytes(self.phone_number),
            self._serialize_bytes(self.phone_code_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _phone_code_hash = reader.tgread_string()
        return cls(phone_number=_phone_number, phone_code_hash=_phone_code_hash)


@dataclasses.dataclass(init=False, frozen=True)
class CheckPassword(TLRequest):
    """
    :returns auth.Authorization: Instance of either Authorization, AuthorizationSignUpRequired.
    """
    __slots__ = ('password',)
    CONSTRUCTOR_ID = 0xd18b4d16
    SUBCLASS_OF_ID = 0xb9e04e39

    password: 'TypeInputCheckPasswordSRP'
    def __init__(self, password: 'TypeInputCheckPasswordSRP'):
        object.__setattr__(self, 'password', password)

    def _bytes(self):
        return b''.join((
            b'\x16M\x8b\xd1',
            self.password._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _password = reader.tgread_object()
        return cls(password=_password)


@dataclasses.dataclass(init=False, frozen=True)
class CheckRecoveryPassword(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('code',)
    CONSTRUCTOR_ID = 0xd36bf79
    SUBCLASS_OF_ID = 0xf5b399ac

    code: str
    def __init__(self, code: str):
        object.__setattr__(self, 'code', code)

    def _bytes(self):
        return b''.join((
            b'y\xbf6\r',
            self._serialize_bytes(self.code),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _code = reader.tgread_string()
        return cls(code=_code)


@dataclasses.dataclass(init=False, frozen=True)
class DropTempAuthKeys(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('except_auth_keys',)
    CONSTRUCTOR_ID = 0x8e48a188
    SUBCLASS_OF_ID = 0xf5b399ac

    except_auth_keys: List[int]
    def __init__(self, except_auth_keys: List[int]):
        object.__setattr__(self, 'except_auth_keys', except_auth_keys)

    def _bytes(self):
        return b''.join((
            b'\x88\xa1H\x8e',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.except_auth_keys)),b''.join(struct.pack('<q', x) for x in self.except_auth_keys),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _except_auth_keys = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _except_auth_keys.append(_x)

        return cls(except_auth_keys=_except_auth_keys)


@dataclasses.dataclass(init=False, frozen=True)
class ExportAuthorization(TLRequest):
    """
    :returns auth.ExportedAuthorization: Instance of ExportedAuthorization.
    """
    __slots__ = ('dc_id',)
    CONSTRUCTOR_ID = 0xe5bfffcd
    SUBCLASS_OF_ID = 0x5fd1ec51

    dc_id: int
    def __init__(self, dc_id: int):
        object.__setattr__(self, 'dc_id', dc_id)

    def _bytes(self):
        return b''.join((
            b'\xcd\xff\xbf\xe5',
            struct.pack('<i', self.dc_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _dc_id = reader.read_int()
        return cls(dc_id=_dc_id)


@dataclasses.dataclass(init=False, frozen=True)
class ExportLoginToken(TLRequest):
    """
    :returns auth.LoginToken: Instance of either LoginToken, LoginTokenMigrateTo, LoginTokenSuccess.
    """
    __slots__ = ('api_id', 'api_hash', 'except_ids',)
    CONSTRUCTOR_ID = 0xb7e085fe
    SUBCLASS_OF_ID = 0x6b55f636

    api_id: int
    api_hash: str
    except_ids: List[int]
    def __init__(self, api_id: int, api_hash: str, except_ids: List[int]):
        object.__setattr__(self, 'api_id', api_id)
        object.__setattr__(self, 'api_hash', api_hash)
        object.__setattr__(self, 'except_ids', except_ids)

    def _bytes(self):
        return b''.join((
            b'\xfe\x85\xe0\xb7',
            struct.pack('<i', self.api_id),
            self._serialize_bytes(self.api_hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.except_ids)),b''.join(struct.pack('<q', x) for x in self.except_ids),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _api_id = reader.read_int()
        _api_hash = reader.tgread_string()
        reader.read_int()
        _except_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _except_ids.append(_x)

        return cls(api_id=_api_id, api_hash=_api_hash, except_ids=_except_ids)


@dataclasses.dataclass(init=False, frozen=True)
class ImportAuthorization(TLRequest):
    """
    :returns auth.Authorization: Instance of either Authorization, AuthorizationSignUpRequired.
    """
    __slots__ = ('id', 'bytes',)
    CONSTRUCTOR_ID = 0xa57a7dad
    SUBCLASS_OF_ID = 0xb9e04e39

    id: int
    bytes: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, bytes: bytes):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'bytes', bytes)

    def _bytes(self):
        return b''.join((
            b'\xad}z\xa5',
            struct.pack('<q', self.id),
            self._serialize_bytes(self.bytes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _bytes = reader.tgread_bytes()
        return cls(id=_id, bytes=_bytes)


@dataclasses.dataclass(init=False, frozen=True)
class ImportBotAuthorization(TLRequest):
    """
    :returns auth.Authorization: Instance of either Authorization, AuthorizationSignUpRequired.
    """
    __slots__ = ('flags', 'api_id', 'api_hash', 'bot_auth_token',)
    CONSTRUCTOR_ID = 0x67a3ff2c
    SUBCLASS_OF_ID = 0xb9e04e39

    flags: int
    api_id: int
    api_hash: str
    bot_auth_token: str
    def __init__(self, flags: int, api_id: int, api_hash: str, bot_auth_token: str):
        object.__setattr__(self, 'flags', flags)
        object.__setattr__(self, 'api_id', api_id)
        object.__setattr__(self, 'api_hash', api_hash)
        object.__setattr__(self, 'bot_auth_token', bot_auth_token)

    def _bytes(self):
        return b''.join((
            b',\xff\xa3g',
            struct.pack('<i', self.flags),
            struct.pack('<i', self.api_id),
            self._serialize_bytes(self.api_hash),
            self._serialize_bytes(self.bot_auth_token),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _flags = reader.read_int()
        _api_id = reader.read_int()
        _api_hash = reader.tgread_string()
        _bot_auth_token = reader.tgread_string()
        return cls(flags=_flags, api_id=_api_id, api_hash=_api_hash, bot_auth_token=_bot_auth_token)


@dataclasses.dataclass(init=False, frozen=True)
class ImportLoginToken(TLRequest):
    """
    :returns auth.LoginToken: Instance of either LoginToken, LoginTokenMigrateTo, LoginTokenSuccess.
    """
    __slots__ = ('token',)
    CONSTRUCTOR_ID = 0x95ac5ce4
    SUBCLASS_OF_ID = 0x6b55f636

    token: bytes
    def __init__(self, token: bytes):
        object.__setattr__(self, 'token', token)

    def _bytes(self):
        return b''.join((
            b'\xe4\\\xac\x95',
            self._serialize_bytes(self.token),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _token = reader.tgread_bytes()
        return cls(token=_token)


@dataclasses.dataclass(init=False, frozen=True)
class LogOut(TLRequest):
    """
    :returns auth.LoggedOut: Instance of LoggedOut.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x3e72ba19
    SUBCLASS_OF_ID = 0xa804315

    def _bytes(self):
        return b''.join((
            b'\x19\xbar>',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class RecoverPassword(TLRequest):
    """
    :returns auth.Authorization: Instance of either Authorization, AuthorizationSignUpRequired.
    """
    __slots__ = ('code', 'new_settings',)
    CONSTRUCTOR_ID = 0x37096c70
    SUBCLASS_OF_ID = 0xb9e04e39

    code: str
    new_settings: Optional['TypePasswordInputSettings']
    def __init__(self, code: str, new_settings: Optional['TypePasswordInputSettings']=None):
        object.__setattr__(self, 'code', code)
        object.__setattr__(self, 'new_settings', new_settings)

    def _bytes(self):
        return b''.join((
            b'pl\t7',
            struct.pack('<I', (0 if self.new_settings is None or self.new_settings is False else 1)),
            self._serialize_bytes(self.code),
            b'' if self.new_settings is None or self.new_settings is False else (self.new_settings._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _code = reader.tgread_string()
        if flags & 1:
            _new_settings = reader.tgread_object()
        else:
            _new_settings = None
        return cls(code=_code, new_settings=_new_settings)


@dataclasses.dataclass(init=False, frozen=True)
class RequestPasswordRecovery(TLRequest):
    """
    :returns auth.PasswordRecovery: Instance of PasswordRecovery.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd897bc66
    SUBCLASS_OF_ID = 0xfa72d43a

    def _bytes(self):
        return b''.join((
            b'f\xbc\x97\xd8',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ResendCode(TLRequest):
    """
    :returns auth.SentCode: Instance of SentCode.
    """
    __slots__ = ('phone_number', 'phone_code_hash',)
    CONSTRUCTOR_ID = 0x3ef1a9bf
    SUBCLASS_OF_ID = 0x6ce87081

    phone_number: str
    phone_code_hash: str
    def __init__(self, phone_number: str, phone_code_hash: str):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'phone_code_hash', phone_code_hash)

    def _bytes(self):
        return b''.join((
            b'\xbf\xa9\xf1>',
            self._serialize_bytes(self.phone_number),
            self._serialize_bytes(self.phone_code_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _phone_code_hash = reader.tgread_string()
        return cls(phone_number=_phone_number, phone_code_hash=_phone_code_hash)


@dataclasses.dataclass(init=False, frozen=True)
class ResetAuthorizations(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9fab0d1a
    SUBCLASS_OF_ID = 0xf5b399ac

    def _bytes(self):
        return b''.join((
            b'\x1a\r\xab\x9f',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SendCode(TLRequest):
    """
    :returns auth.SentCode: Instance of SentCode.
    """
    __slots__ = ('phone_number', 'api_id', 'api_hash', 'settings',)
    CONSTRUCTOR_ID = 0xa677244f
    SUBCLASS_OF_ID = 0x6ce87081

    phone_number: str
    api_id: int
    api_hash: str
    settings: 'TypeCodeSettings'
    def __init__(self, phone_number: str, api_id: int, api_hash: str, settings: 'TypeCodeSettings'):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'api_id', api_id)
        object.__setattr__(self, 'api_hash', api_hash)
        object.__setattr__(self, 'settings', settings)

    def _bytes(self):
        return b''.join((
            b'O$w\xa6',
            self._serialize_bytes(self.phone_number),
            struct.pack('<i', self.api_id),
            self._serialize_bytes(self.api_hash),
            self.settings._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _api_id = reader.read_int()
        _api_hash = reader.tgread_string()
        _settings = reader.tgread_object()
        return cls(phone_number=_phone_number, api_id=_api_id, api_hash=_api_hash, settings=_settings)


@dataclasses.dataclass(init=False, frozen=True)
class SignIn(TLRequest):
    """
    :returns auth.Authorization: Instance of either Authorization, AuthorizationSignUpRequired.
    """
    __slots__ = ('phone_number', 'phone_code_hash', 'phone_code',)
    CONSTRUCTOR_ID = 0xbcd51581
    SUBCLASS_OF_ID = 0xb9e04e39

    phone_number: str
    phone_code_hash: str
    phone_code: str
    def __init__(self, phone_number: str, phone_code_hash: str, phone_code: str):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'phone_code_hash', phone_code_hash)
        object.__setattr__(self, 'phone_code', phone_code)

    def _bytes(self):
        return b''.join((
            b'\x81\x15\xd5\xbc',
            self._serialize_bytes(self.phone_number),
            self._serialize_bytes(self.phone_code_hash),
            self._serialize_bytes(self.phone_code),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _phone_code_hash = reader.tgread_string()
        _phone_code = reader.tgread_string()
        return cls(phone_number=_phone_number, phone_code_hash=_phone_code_hash, phone_code=_phone_code)


@dataclasses.dataclass(init=False, frozen=True)
class SignUp(TLRequest):
    """
    :returns auth.Authorization: Instance of either Authorization, AuthorizationSignUpRequired.
    """
    __slots__ = ('phone_number', 'phone_code_hash', 'first_name', 'last_name',)
    CONSTRUCTOR_ID = 0x80eee427
    SUBCLASS_OF_ID = 0xb9e04e39

    phone_number: str
    phone_code_hash: str
    first_name: str
    last_name: str
    def __init__(self, phone_number: str, phone_code_hash: str, first_name: str, last_name: str):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'phone_code_hash', phone_code_hash)
        object.__setattr__(self, 'first_name', first_name)
        object.__setattr__(self, 'last_name', last_name)

    def _bytes(self):
        return b''.join((
            b"'\xe4\xee\x80",
            self._serialize_bytes(self.phone_number),
            self._serialize_bytes(self.phone_code_hash),
            self._serialize_bytes(self.first_name),
            self._serialize_bytes(self.last_name),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _phone_code_hash = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        return cls(phone_number=_phone_number, phone_code_hash=_phone_code_hash, first_name=_first_name, last_name=_last_name)

