"""File generated by TLObjects' generator. All changes will be ERASED"""
from ..._misc.tlobject import TLObject, TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from .. import TypeAccountDaysTTL, TypeAutoDownloadSettings, TypeBaseTheme, TypeCodeSettings, TypeGlobalPrivacySettings, TypeInputCheckPasswordSRP, TypeInputDocument, TypeInputFile, TypeInputNotifyPeer, TypeInputPeer, TypeInputPeerNotifySettings, TypeInputPhoto, TypeInputPrivacyKey, TypeInputPrivacyRule, TypeInputSecureValue, TypeInputTheme, TypeInputThemeSettings, TypeInputWallPaper, TypeReportReason, TypeSecureCredentialsEncrypted, TypeSecureValueHash, TypeSecureValueType, TypeWallPaperSettings
    from ...account import TypePasswordInputSettings



@dataclasses.dataclass(init=False, frozen=True)
class AcceptAuthorization(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('bot_id', 'scope', 'public_key', 'value_hashes', 'credentials',)
    CONSTRUCTOR_ID = 0xf3ed4c73
    SUBCLASS_OF_ID = 0xf5b399ac

    bot_id: int
    scope: str
    public_key: str
    value_hashes: List['TypeSecureValueHash']
    credentials: 'TypeSecureCredentialsEncrypted'
    def __init__(self, bot_id: int, scope: str, public_key: str, value_hashes: List['TypeSecureValueHash'], credentials: 'TypeSecureCredentialsEncrypted'):
        object.__setattr__(self, 'bot_id', bot_id)
        object.__setattr__(self, 'scope', scope)
        object.__setattr__(self, 'public_key', public_key)
        object.__setattr__(self, 'value_hashes', value_hashes)
        object.__setattr__(self, 'credentials', credentials)

    def _bytes(self):
        return b''.join((
            b'sL\xed\xf3',
            struct.pack('<q', self.bot_id),
            self._serialize_bytes(self.scope),
            self._serialize_bytes(self.public_key),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.value_hashes)),b''.join(x._bytes() for x in self.value_hashes),
            self.credentials._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _bot_id = reader.read_long()
        _scope = reader.tgread_string()
        _public_key = reader.tgread_string()
        reader.read_int()
        _value_hashes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _value_hashes.append(_x)

        _credentials = reader.tgread_object()
        return cls(bot_id=_bot_id, scope=_scope, public_key=_public_key, value_hashes=_value_hashes, credentials=_credentials)


@dataclasses.dataclass(init=False, frozen=True)
class CancelPasswordEmail(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xc1cbd5b6
    SUBCLASS_OF_ID = 0xf5b399ac

    def _bytes(self):
        return b''.join((
            b'\xb6\xd5\xcb\xc1',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ChangeAuthorizationSettings(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('hash', 'encrypted_requests_disabled', 'call_requests_disabled',)
    CONSTRUCTOR_ID = 0x40f48462
    SUBCLASS_OF_ID = 0xf5b399ac

    hash: int
    encrypted_requests_disabled: Optional[bool]
    call_requests_disabled: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, encrypted_requests_disabled: Optional[bool]=None, call_requests_disabled: Optional[bool]=None):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'encrypted_requests_disabled', encrypted_requests_disabled)
        object.__setattr__(self, 'call_requests_disabled', call_requests_disabled)

    def _bytes(self):
        return b''.join((
            b'b\x84\xf4@',
            struct.pack('<I', (0 if self.encrypted_requests_disabled is None else 1) | (0 if self.call_requests_disabled is None else 2)),
            struct.pack('<q', self.hash),
            b'' if self.encrypted_requests_disabled is None else (b'\xb5ur\x99' if self.encrypted_requests_disabled else b'7\x97y\xbc'),
            b'' if self.call_requests_disabled is None else (b'\xb5ur\x99' if self.call_requests_disabled else b'7\x97y\xbc'),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _hash = reader.read_long()
        if flags & 1:
            _encrypted_requests_disabled = reader.tgread_bool()
        else:
            _encrypted_requests_disabled = None
        if flags & 2:
            _call_requests_disabled = reader.tgread_bool()
        else:
            _call_requests_disabled = None
        return cls(hash=_hash, encrypted_requests_disabled=_encrypted_requests_disabled, call_requests_disabled=_call_requests_disabled)


@dataclasses.dataclass(init=False, frozen=True)
class ChangePhone(TLRequest):
    """
    :returns User: Instance of either UserEmpty, User.
    """
    __slots__ = ('phone_number', 'phone_code_hash', 'phone_code',)
    CONSTRUCTOR_ID = 0x70c32edb
    SUBCLASS_OF_ID = 0x2da17977

    phone_number: str
    phone_code_hash: str
    phone_code: str
    def __init__(self, phone_number: str, phone_code_hash: str, phone_code: str):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'phone_code_hash', phone_code_hash)
        object.__setattr__(self, 'phone_code', phone_code)

    def _bytes(self):
        return b''.join((
            b'\xdb.\xc3p',
            self._serialize_bytes(self.phone_number),
            self._serialize_bytes(self.phone_code_hash),
            self._serialize_bytes(self.phone_code),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _phone_code_hash = reader.tgread_string()
        _phone_code = reader.tgread_string()
        return cls(phone_number=_phone_number, phone_code_hash=_phone_code_hash, phone_code=_phone_code)


@dataclasses.dataclass(init=False, frozen=True)
class CheckUsername(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('username',)
    CONSTRUCTOR_ID = 0x2714d86c
    SUBCLASS_OF_ID = 0xf5b399ac

    username: str
    def __init__(self, username: str):
        object.__setattr__(self, 'username', username)

    def _bytes(self):
        return b''.join((
            b"l\xd8\x14'",
            self._serialize_bytes(self.username),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _username = reader.tgread_string()
        return cls(username=_username)


@dataclasses.dataclass(init=False, frozen=True)
class ConfirmPasswordEmail(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('code',)
    CONSTRUCTOR_ID = 0x8fdf1920
    SUBCLASS_OF_ID = 0xf5b399ac

    code: str
    def __init__(self, code: str):
        object.__setattr__(self, 'code', code)

    def _bytes(self):
        return b''.join((
            b' \x19\xdf\x8f',
            self._serialize_bytes(self.code),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _code = reader.tgread_string()
        return cls(code=_code)


@dataclasses.dataclass(init=False, frozen=True)
class ConfirmPhone(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('phone_code_hash', 'phone_code',)
    CONSTRUCTOR_ID = 0x5f2178c3
    SUBCLASS_OF_ID = 0xf5b399ac

    phone_code_hash: str
    phone_code: str
    def __init__(self, phone_code_hash: str, phone_code: str):
        object.__setattr__(self, 'phone_code_hash', phone_code_hash)
        object.__setattr__(self, 'phone_code', phone_code)

    def _bytes(self):
        return b''.join((
            b'\xc3x!_',
            self._serialize_bytes(self.phone_code_hash),
            self._serialize_bytes(self.phone_code),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_code_hash = reader.tgread_string()
        _phone_code = reader.tgread_string()
        return cls(phone_code_hash=_phone_code_hash, phone_code=_phone_code)


@dataclasses.dataclass(init=False, frozen=True)
class CreateTheme(TLRequest):
    """
    :returns Theme: Instance of Theme.
    """
    __slots__ = ('slug', 'title', 'document', 'settings',)
    CONSTRUCTOR_ID = 0x652e4400
    SUBCLASS_OF_ID = 0x56b4c80c

    slug: str
    title: str
    document: Optional['TypeInputDocument']
    settings: Optional[List['TypeInputThemeSettings']]
    def __init__(self, slug: str, title: str, document: Optional['TypeInputDocument']=None, settings: Optional[List['TypeInputThemeSettings']]=None):
        object.__setattr__(self, 'slug', slug)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'document', document)
        object.__setattr__(self, 'settings', settings)

    async def _resolve(self, client, utils):
        r = {}
        if self.document:
            r['document'] = utils.get_input_document(self.document)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x00D.e',
            struct.pack('<I', (0 if self.document is None or self.document is False else 4) | (0 if self.settings is None or self.settings is False else 8)),
            self._serialize_bytes(self.slug),
            self._serialize_bytes(self.title),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
            b'' if self.settings is None or self.settings is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.settings)),b''.join(x._bytes() for x in self.settings))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _slug = reader.tgread_string()
        _title = reader.tgread_string()
        if flags & 4:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 8:
            reader.read_int()
            _settings = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _settings.append(_x)

        else:
            _settings = None
        return cls(slug=_slug, title=_title, document=_document, settings=_settings)


@dataclasses.dataclass(init=False, frozen=True)
class DeclinePasswordReset(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x4c9409f6
    SUBCLASS_OF_ID = 0xf5b399ac

    def _bytes(self):
        return b''.join((
            b'\xf6\t\x94L',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class DeleteAccount(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('reason',)
    CONSTRUCTOR_ID = 0x418d4e0b
    SUBCLASS_OF_ID = 0xf5b399ac

    reason: str
    def __init__(self, reason: str):
        object.__setattr__(self, 'reason', reason)

    def _bytes(self):
        return b''.join((
            b'\x0bN\x8dA',
            self._serialize_bytes(self.reason),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _reason = reader.tgread_string()
        return cls(reason=_reason)


@dataclasses.dataclass(init=False, frozen=True)
class DeleteSecureValue(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('types',)
    CONSTRUCTOR_ID = 0xb880bc4b
    SUBCLASS_OF_ID = 0xf5b399ac

    types: List['TypeSecureValueType']
    def __init__(self, types: List['TypeSecureValueType']):
        object.__setattr__(self, 'types', types)

    def _bytes(self):
        return b''.join((
            b'K\xbc\x80\xb8',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.types)),b''.join(x._bytes() for x in self.types),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _types = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _types.append(_x)

        return cls(types=_types)


@dataclasses.dataclass(init=False, frozen=True)
class FinishTakeoutSession(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('success',)
    CONSTRUCTOR_ID = 0x1d2652ee
    SUBCLASS_OF_ID = 0xf5b399ac

    success: Optional[bool]
    def __init__(self, success: Optional[bool]=None):
        object.__setattr__(self, 'success', success)

    def _bytes(self):
        return b''.join((
            b'\xeeR&\x1d',
            struct.pack('<I', (0 if self.success is None or self.success is False else 1)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _success = bool(flags & 1)
        return cls(success=_success)


@dataclasses.dataclass(init=False, frozen=True)
class GetAccountTTL(TLRequest):
    """
    :returns AccountDaysTTL: Instance of AccountDaysTTL.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x8fc711d
    SUBCLASS_OF_ID = 0xbaa39d88

    def _bytes(self):
        return b''.join((
            b'\x1dq\xfc\x08',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetAllSecureValues(TLRequest):
    """
    :returns Vector<SecureValue>: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb288bc7d
    SUBCLASS_OF_ID = 0xe82e4121

    def _bytes(self):
        return b''.join((
            b'}\xbc\x88\xb2',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetAuthorizationForm(TLRequest):
    """
    :returns account.AuthorizationForm: Instance of AuthorizationForm.
    """
    __slots__ = ('bot_id', 'scope', 'public_key',)
    CONSTRUCTOR_ID = 0xa929597a
    SUBCLASS_OF_ID = 0x78049a94

    bot_id: int
    scope: str
    public_key: str
    def __init__(self, bot_id: int, scope: str, public_key: str):
        object.__setattr__(self, 'bot_id', bot_id)
        object.__setattr__(self, 'scope', scope)
        object.__setattr__(self, 'public_key', public_key)

    def _bytes(self):
        return b''.join((
            b'zY)\xa9',
            struct.pack('<q', self.bot_id),
            self._serialize_bytes(self.scope),
            self._serialize_bytes(self.public_key),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _bot_id = reader.read_long()
        _scope = reader.tgread_string()
        _public_key = reader.tgread_string()
        return cls(bot_id=_bot_id, scope=_scope, public_key=_public_key)


@dataclasses.dataclass(init=False, frozen=True)
class GetAuthorizations(TLRequest):
    """
    :returns account.Authorizations: Instance of Authorizations.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xe320c158
    SUBCLASS_OF_ID = 0xbf5e0ff

    def _bytes(self):
        return b''.join((
            b'X\xc1 \xe3',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetAutoDownloadSettings(TLRequest):
    """
    :returns account.AutoDownloadSettings: Instance of AutoDownloadSettings.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x56da0b3f
    SUBCLASS_OF_ID = 0x2fb85921

    def _bytes(self):
        return b''.join((
            b'?\x0b\xdaV',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetChatThemes(TLRequest):
    """
    :returns account.Themes: Instance of either ThemesNotModified, Themes.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0xd638de89
    SUBCLASS_OF_ID = 0x7fc52204

    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\x89\xde8\xd6',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetContactSignUpNotification(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9f07c728
    SUBCLASS_OF_ID = 0xf5b399ac

    def _bytes(self):
        return b''.join((
            b'(\xc7\x07\x9f',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetContentSettings(TLRequest):
    """
    :returns account.ContentSettings: Instance of ContentSettings.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x8b9b4dae
    SUBCLASS_OF_ID = 0xae3ff891

    def _bytes(self):
        return b''.join((
            b'\xaeM\x9b\x8b',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetGlobalPrivacySettings(TLRequest):
    """
    :returns GlobalPrivacySettings: Instance of GlobalPrivacySettings.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xeb2b4cf6
    SUBCLASS_OF_ID = 0xc90e5770

    def _bytes(self):
        return b''.join((
            b'\xf6L+\xeb',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetMultiWallPapers(TLRequest):
    """
    :returns Vector<WallPaper>: This type has no constructors.
    """
    __slots__ = ('wallpapers',)
    CONSTRUCTOR_ID = 0x65ad71dc
    SUBCLASS_OF_ID = 0x8ec35283

    wallpapers: List['TypeInputWallPaper']
    def __init__(self, wallpapers: List['TypeInputWallPaper']):
        object.__setattr__(self, 'wallpapers', wallpapers)

    def _bytes(self):
        return b''.join((
            b'\xdcq\xade',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.wallpapers)),b''.join(x._bytes() for x in self.wallpapers),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _wallpapers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _wallpapers.append(_x)

        return cls(wallpapers=_wallpapers)


@dataclasses.dataclass(init=False, frozen=True)
class GetNotifyExceptions(TLRequest):
    """
    :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
    """
    __slots__ = ('compare_sound', 'peer',)
    CONSTRUCTOR_ID = 0x53577479
    SUBCLASS_OF_ID = 0x8af52aac

    compare_sound: Optional[bool]
    peer: Optional['TypeInputNotifyPeer']
    def __init__(self, compare_sound: Optional[bool]=None, peer: Optional['TypeInputNotifyPeer']=None):
        object.__setattr__(self, 'compare_sound', compare_sound)
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        if self.peer:
            r['peer'] = await client._get_input_notify(self.peer)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'ytWS',
            struct.pack('<I', (0 if self.compare_sound is None or self.compare_sound is False else 2) | (0 if self.peer is None or self.peer is False else 1)),
            b'' if self.peer is None or self.peer is False else (self.peer._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _compare_sound = bool(flags & 2)
        if flags & 1:
            _peer = reader.tgread_object()
        else:
            _peer = None
        return cls(compare_sound=_compare_sound, peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class GetNotifySettings(TLRequest):
    """
    :returns PeerNotifySettings: Instance of PeerNotifySettings.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0x12b3ad31
    SUBCLASS_OF_ID = 0xcf20c074

    peer: 'TypeInputNotifyPeer'
    def __init__(self, peer: 'TypeInputNotifyPeer'):
        object.__setattr__(self, 'peer', peer)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = await client._get_input_notify(self.peer)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'1\xad\xb3\x12',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class GetPassword(TLRequest):
    """
    :returns account.Password: Instance of Password.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x548a30f5
    SUBCLASS_OF_ID = 0x53a211a3

    def _bytes(self):
        return b''.join((
            b'\xf50\x8aT',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GetPasswordSettings(TLRequest):
    """
    :returns account.PasswordSettings: Instance of PasswordSettings.
    """
    __slots__ = ('password',)
    CONSTRUCTOR_ID = 0x9cd4eaf9
    SUBCLASS_OF_ID = 0xd23fb078

    password: 'TypeInputCheckPasswordSRP'
    def __init__(self, password: 'TypeInputCheckPasswordSRP'):
        object.__setattr__(self, 'password', password)

    def _bytes(self):
        return b''.join((
            b'\xf9\xea\xd4\x9c',
            self.password._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _password = reader.tgread_object()
        return cls(password=_password)


@dataclasses.dataclass(init=False, frozen=True)
class GetPrivacy(TLRequest):
    """
    :returns account.PrivacyRules: Instance of PrivacyRules.
    """
    __slots__ = ('key',)
    CONSTRUCTOR_ID = 0xdadbc950
    SUBCLASS_OF_ID = 0xb55aba82

    key: 'TypeInputPrivacyKey'
    def __init__(self, key: 'TypeInputPrivacyKey'):
        object.__setattr__(self, 'key', key)

    def _bytes(self):
        return b''.join((
            b'P\xc9\xdb\xda',
            self.key._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _key = reader.tgread_object()
        return cls(key=_key)


@dataclasses.dataclass(init=False, frozen=True)
class GetSecureValue(TLRequest):
    """
    :returns Vector<SecureValue>: This type has no constructors.
    """
    __slots__ = ('types',)
    CONSTRUCTOR_ID = 0x73665bc2
    SUBCLASS_OF_ID = 0xe82e4121

    types: List['TypeSecureValueType']
    def __init__(self, types: List['TypeSecureValueType']):
        object.__setattr__(self, 'types', types)

    def _bytes(self):
        return b''.join((
            b'\xc2[fs',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.types)),b''.join(x._bytes() for x in self.types),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _types = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _types.append(_x)

        return cls(types=_types)


@dataclasses.dataclass(init=False, frozen=True)
class GetTheme(TLRequest):
    """
    :returns Theme: Instance of Theme.
    """
    __slots__ = ('format', 'theme', 'document_id',)
    CONSTRUCTOR_ID = 0x8d9d742b
    SUBCLASS_OF_ID = 0x56b4c80c

    format: str
    theme: 'TypeInputTheme'
    document_id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, format: str, theme: 'TypeInputTheme', document_id: int):
        object.__setattr__(self, 'format', format)
        object.__setattr__(self, 'theme', theme)
        object.__setattr__(self, 'document_id', document_id)

    def _bytes(self):
        return b''.join((
            b'+t\x9d\x8d',
            self._serialize_bytes(self.format),
            self.theme._bytes(),
            struct.pack('<q', self.document_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _format = reader.tgread_string()
        _theme = reader.tgread_object()
        _document_id = reader.read_long()
        return cls(format=_format, theme=_theme, document_id=_document_id)


@dataclasses.dataclass(init=False, frozen=True)
class GetThemes(TLRequest):
    """
    :returns account.Themes: Instance of either ThemesNotModified, Themes.
    """
    __slots__ = ('format', 'hash',)
    CONSTRUCTOR_ID = 0x7206e458
    SUBCLASS_OF_ID = 0x7fc52204

    format: str
    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, format: str, hash: int):
        object.__setattr__(self, 'format', format)
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'X\xe4\x06r',
            self._serialize_bytes(self.format),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _format = reader.tgread_string()
        _hash = reader.read_long()
        return cls(format=_format, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetTmpPassword(TLRequest):
    """
    :returns account.TmpPassword: Instance of TmpPassword.
    """
    __slots__ = ('password', 'period',)
    CONSTRUCTOR_ID = 0x449e0b51
    SUBCLASS_OF_ID = 0xb064992d

    password: 'TypeInputCheckPasswordSRP'
    period: int
    def __init__(self, password: 'TypeInputCheckPasswordSRP', period: int):
        object.__setattr__(self, 'password', password)
        object.__setattr__(self, 'period', period)

    def _bytes(self):
        return b''.join((
            b'Q\x0b\x9eD',
            self.password._bytes(),
            struct.pack('<i', self.period),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _password = reader.tgread_object()
        _period = reader.read_int()
        return cls(password=_password, period=_period)


@dataclasses.dataclass(init=False, frozen=True)
class GetWallPaper(TLRequest):
    """
    :returns WallPaper: Instance of either WallPaper, WallPaperNoFile.
    """
    __slots__ = ('wallpaper',)
    CONSTRUCTOR_ID = 0xfc8ddbea
    SUBCLASS_OF_ID = 0x96a2c98b

    wallpaper: 'TypeInputWallPaper'
    def __init__(self, wallpaper: 'TypeInputWallPaper'):
        object.__setattr__(self, 'wallpaper', wallpaper)

    def _bytes(self):
        return b''.join((
            b'\xea\xdb\x8d\xfc',
            self.wallpaper._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _wallpaper = reader.tgread_object()
        return cls(wallpaper=_wallpaper)


@dataclasses.dataclass(init=False, frozen=True)
class GetWallPapers(TLRequest):
    """
    :returns account.WallPapers: Instance of either WallPapersNotModified, WallPapers.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0x7967d36
    SUBCLASS_OF_ID = 0xa2c548fd

    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'6}\x96\x07',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class GetWebAuthorizations(TLRequest):
    """
    :returns account.WebAuthorizations: Instance of WebAuthorizations.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x182e6d6f
    SUBCLASS_OF_ID = 0x9a365b32

    def _bytes(self):
        return b''.join((
            b'om.\x18',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InitTakeoutSession(TLRequest):
    """
    :returns account.Takeout: Instance of Takeout.
    """
    __slots__ = ('contacts', 'message_users', 'message_chats', 'message_megagroups', 'message_channels', 'files', 'file_max_size',)
    CONSTRUCTOR_ID = 0xf05b4804
    SUBCLASS_OF_ID = 0x843ebe85

    contacts: Optional[bool]
    message_users: Optional[bool]
    message_chats: Optional[bool]
    message_megagroups: Optional[bool]
    message_channels: Optional[bool]
    files: Optional[bool]
    file_max_size: Optional[int]
    def __init__(self, contacts: Optional[bool]=None, message_users: Optional[bool]=None, message_chats: Optional[bool]=None, message_megagroups: Optional[bool]=None, message_channels: Optional[bool]=None, files: Optional[bool]=None, file_max_size: Optional[int]=None):
        object.__setattr__(self, 'contacts', contacts)
        object.__setattr__(self, 'message_users', message_users)
        object.__setattr__(self, 'message_chats', message_chats)
        object.__setattr__(self, 'message_megagroups', message_megagroups)
        object.__setattr__(self, 'message_channels', message_channels)
        object.__setattr__(self, 'files', files)
        object.__setattr__(self, 'file_max_size', file_max_size)

    def _bytes(self):
        assert ((self.files or self.files is not None) and (self.file_max_size or self.file_max_size is not None)) or ((self.files is None or self.files is False) and (self.file_max_size is None or self.file_max_size is False)), 'files, file_max_size parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\x04H[\xf0',
            struct.pack('<I', (0 if self.contacts is None or self.contacts is False else 1) | (0 if self.message_users is None or self.message_users is False else 2) | (0 if self.message_chats is None or self.message_chats is False else 4) | (0 if self.message_megagroups is None or self.message_megagroups is False else 8) | (0 if self.message_channels is None or self.message_channels is False else 16) | (0 if self.files is None or self.files is False else 32) | (0 if self.file_max_size is None or self.file_max_size is False else 32)),
            b'' if self.file_max_size is None or self.file_max_size is False else (struct.pack('<i', self.file_max_size)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _contacts = bool(flags & 1)
        _message_users = bool(flags & 2)
        _message_chats = bool(flags & 4)
        _message_megagroups = bool(flags & 8)
        _message_channels = bool(flags & 16)
        _files = bool(flags & 32)
        if flags & 32:
            _file_max_size = reader.read_int()
        else:
            _file_max_size = None
        return cls(contacts=_contacts, message_users=_message_users, message_chats=_message_chats, message_megagroups=_message_megagroups, message_channels=_message_channels, files=_files, file_max_size=_file_max_size)


@dataclasses.dataclass(init=False, frozen=True)
class InstallTheme(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('dark', 'theme', 'format', 'base_theme',)
    CONSTRUCTOR_ID = 0xc727bb3b
    SUBCLASS_OF_ID = 0xf5b399ac

    dark: Optional[bool]
    theme: Optional['TypeInputTheme']
    format: Optional[str]
    base_theme: Optional['TypeBaseTheme']
    # noinspection PyShadowingBuiltins
    def __init__(self, dark: Optional[bool]=None, theme: Optional['TypeInputTheme']=None, format: Optional[str]=None, base_theme: Optional['TypeBaseTheme']=None):
        object.__setattr__(self, 'dark', dark)
        object.__setattr__(self, 'theme', theme)
        object.__setattr__(self, 'format', format)
        object.__setattr__(self, 'base_theme', base_theme)

    def _bytes(self):
        return b''.join((
            b";\xbb'\xc7",
            struct.pack('<I', (0 if self.dark is None or self.dark is False else 1) | (0 if self.theme is None or self.theme is False else 2) | (0 if self.format is None or self.format is False else 4) | (0 if self.base_theme is None or self.base_theme is False else 8)),
            b'' if self.theme is None or self.theme is False else (self.theme._bytes()),
            b'' if self.format is None or self.format is False else (self._serialize_bytes(self.format)),
            b'' if self.base_theme is None or self.base_theme is False else (self.base_theme._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _dark = bool(flags & 1)
        if flags & 2:
            _theme = reader.tgread_object()
        else:
            _theme = None
        if flags & 4:
            _format = reader.tgread_string()
        else:
            _format = None
        if flags & 8:
            _base_theme = reader.tgread_object()
        else:
            _base_theme = None
        return cls(dark=_dark, theme=_theme, format=_format, base_theme=_base_theme)


@dataclasses.dataclass(init=False, frozen=True)
class InstallWallPaper(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('wallpaper', 'settings',)
    CONSTRUCTOR_ID = 0xfeed5769
    SUBCLASS_OF_ID = 0xf5b399ac

    wallpaper: 'TypeInputWallPaper'
    settings: 'TypeWallPaperSettings'
    def __init__(self, wallpaper: 'TypeInputWallPaper', settings: 'TypeWallPaperSettings'):
        object.__setattr__(self, 'wallpaper', wallpaper)
        object.__setattr__(self, 'settings', settings)

    def _bytes(self):
        return b''.join((
            b'iW\xed\xfe',
            self.wallpaper._bytes(),
            self.settings._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _wallpaper = reader.tgread_object()
        _settings = reader.tgread_object()
        return cls(wallpaper=_wallpaper, settings=_settings)


@dataclasses.dataclass(init=False, frozen=True)
class RegisterDevice(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('token_type', 'token', 'app_sandbox', 'secret', 'other_uids', 'no_muted',)
    CONSTRUCTOR_ID = 0xec86017a
    SUBCLASS_OF_ID = 0xf5b399ac

    token_type: int
    token: str
    app_sandbox: bool
    secret: bytes
    other_uids: List[int]
    no_muted: Optional[bool]
    def __init__(self, token_type: int, token: str, app_sandbox: bool, secret: bytes, other_uids: List[int], no_muted: Optional[bool]=None):
        object.__setattr__(self, 'token_type', token_type)
        object.__setattr__(self, 'token', token)
        object.__setattr__(self, 'app_sandbox', app_sandbox)
        object.__setattr__(self, 'secret', secret)
        object.__setattr__(self, 'other_uids', other_uids)
        object.__setattr__(self, 'no_muted', no_muted)

    def _bytes(self):
        return b''.join((
            b'z\x01\x86\xec',
            struct.pack('<I', (0 if self.no_muted is None or self.no_muted is False else 1)),
            struct.pack('<i', self.token_type),
            self._serialize_bytes(self.token),
            b'\xb5ur\x99' if self.app_sandbox else b'7\x97y\xbc',
            self._serialize_bytes(self.secret),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.other_uids)),b''.join(struct.pack('<q', x) for x in self.other_uids),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _no_muted = bool(flags & 1)
        _token_type = reader.read_int()
        _token = reader.tgread_string()
        _app_sandbox = reader.tgread_bool()
        _secret = reader.tgread_bytes()
        reader.read_int()
        _other_uids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _other_uids.append(_x)

        return cls(token_type=_token_type, token=_token, app_sandbox=_app_sandbox, secret=_secret, other_uids=_other_uids, no_muted=_no_muted)


@dataclasses.dataclass(init=False, frozen=True)
class ReportPeer(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'reason', 'message',)
    CONSTRUCTOR_ID = 0xc5ba3d86
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    reason: 'TypeReportReason'
    message: str
    def __init__(self, peer: 'TypeInputPeer', reason: 'TypeReportReason', message: str):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'reason', reason)
        object.__setattr__(self, 'message', message)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x86=\xba\xc5',
            self.peer._bytes(),
            self.reason._bytes(),
            self._serialize_bytes(self.message),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _reason = reader.tgread_object()
        _message = reader.tgread_string()
        return cls(peer=_peer, reason=_reason, message=_message)


@dataclasses.dataclass(init=False, frozen=True)
class ReportProfilePhoto(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'photo_id', 'reason', 'message',)
    CONSTRUCTOR_ID = 0xfa8cc6f5
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputPeer'
    photo_id: 'TypeInputPhoto'
    reason: 'TypeReportReason'
    message: str
    def __init__(self, peer: 'TypeInputPeer', photo_id: 'TypeInputPhoto', reason: 'TypeReportReason', message: str):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'photo_id', photo_id)
        object.__setattr__(self, 'reason', reason)
        object.__setattr__(self, 'message', message)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = utils.get_input_peer(await client._get_input_peer(self.peer))
        r['photo_id'] = utils.get_input_photo(self.photo_id)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xf5\xc6\x8c\xfa',
            self.peer._bytes(),
            self.photo_id._bytes(),
            self.reason._bytes(),
            self._serialize_bytes(self.message),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _photo_id = reader.tgread_object()
        _reason = reader.tgread_object()
        _message = reader.tgread_string()
        return cls(peer=_peer, photo_id=_photo_id, reason=_reason, message=_message)


@dataclasses.dataclass(init=False, frozen=True)
class ResendPasswordEmail(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x7a7f2a15
    SUBCLASS_OF_ID = 0xf5b399ac

    def _bytes(self):
        return b''.join((
            b'\x15*\x7fz',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ResetAuthorization(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0xdf77f3bc
    SUBCLASS_OF_ID = 0xf5b399ac

    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\xbc\xf3w\xdf',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class ResetNotifySettings(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xdb7e1747
    SUBCLASS_OF_ID = 0xf5b399ac

    def _bytes(self):
        return b''.join((
            b'G\x17~\xdb',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ResetPassword(TLRequest):
    """
    :returns account.ResetPasswordResult: Instance of either ResetPasswordFailedWait, ResetPasswordRequestedWait, ResetPasswordOk.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9308ce1b
    SUBCLASS_OF_ID = 0x49507416

    def _bytes(self):
        return b''.join((
            b'\x1b\xce\x08\x93',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ResetWallPapers(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xbb3b9804
    SUBCLASS_OF_ID = 0xf5b399ac

    def _bytes(self):
        return b''.join((
            b'\x04\x98;\xbb',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ResetWebAuthorization(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('hash',)
    CONSTRUCTOR_ID = 0x2d01b9ef
    SUBCLASS_OF_ID = 0xf5b399ac

    hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\xef\xb9\x01-',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class ResetWebAuthorizations(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x682d2594
    SUBCLASS_OF_ID = 0xf5b399ac

    def _bytes(self):
        return b''.join((
            b'\x94%-h',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SaveAutoDownloadSettings(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('settings', 'low', 'high',)
    CONSTRUCTOR_ID = 0x76f36233
    SUBCLASS_OF_ID = 0xf5b399ac

    settings: 'TypeAutoDownloadSettings'
    low: Optional[bool]
    high: Optional[bool]
    def __init__(self, settings: 'TypeAutoDownloadSettings', low: Optional[bool]=None, high: Optional[bool]=None):
        object.__setattr__(self, 'settings', settings)
        object.__setattr__(self, 'low', low)
        object.__setattr__(self, 'high', high)

    def _bytes(self):
        return b''.join((
            b'3b\xf3v',
            struct.pack('<I', (0 if self.low is None or self.low is False else 1) | (0 if self.high is None or self.high is False else 2)),
            self.settings._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _low = bool(flags & 1)
        _high = bool(flags & 2)
        _settings = reader.tgread_object()
        return cls(settings=_settings, low=_low, high=_high)


@dataclasses.dataclass(init=False, frozen=True)
class SaveSecureValue(TLRequest):
    """
    :returns SecureValue: Instance of SecureValue.
    """
    __slots__ = ('value', 'secure_secret_id',)
    CONSTRUCTOR_ID = 0x899fe31d
    SUBCLASS_OF_ID = 0x51138ae

    value: 'TypeInputSecureValue'
    secure_secret_id: int
    def __init__(self, value: 'TypeInputSecureValue', secure_secret_id: int):
        object.__setattr__(self, 'value', value)
        object.__setattr__(self, 'secure_secret_id', secure_secret_id)

    def _bytes(self):
        return b''.join((
            b'\x1d\xe3\x9f\x89',
            self.value._bytes(),
            struct.pack('<q', self.secure_secret_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _value = reader.tgread_object()
        _secure_secret_id = reader.read_long()
        return cls(value=_value, secure_secret_id=_secure_secret_id)


@dataclasses.dataclass(init=False, frozen=True)
class SaveTheme(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('theme', 'unsave',)
    CONSTRUCTOR_ID = 0xf257106c
    SUBCLASS_OF_ID = 0xf5b399ac

    theme: 'TypeInputTheme'
    unsave: bool
    def __init__(self, theme: 'TypeInputTheme', unsave: bool):
        object.__setattr__(self, 'theme', theme)
        object.__setattr__(self, 'unsave', unsave)

    def _bytes(self):
        return b''.join((
            b'l\x10W\xf2',
            self.theme._bytes(),
            b'\xb5ur\x99' if self.unsave else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _theme = reader.tgread_object()
        _unsave = reader.tgread_bool()
        return cls(theme=_theme, unsave=_unsave)


@dataclasses.dataclass(init=False, frozen=True)
class SaveWallPaper(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('wallpaper', 'unsave', 'settings',)
    CONSTRUCTOR_ID = 0x6c5a5b37
    SUBCLASS_OF_ID = 0xf5b399ac

    wallpaper: 'TypeInputWallPaper'
    unsave: bool
    settings: 'TypeWallPaperSettings'
    def __init__(self, wallpaper: 'TypeInputWallPaper', unsave: bool, settings: 'TypeWallPaperSettings'):
        object.__setattr__(self, 'wallpaper', wallpaper)
        object.__setattr__(self, 'unsave', unsave)
        object.__setattr__(self, 'settings', settings)

    def _bytes(self):
        return b''.join((
            b'7[Zl',
            self.wallpaper._bytes(),
            b'\xb5ur\x99' if self.unsave else b'7\x97y\xbc',
            self.settings._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _wallpaper = reader.tgread_object()
        _unsave = reader.tgread_bool()
        _settings = reader.tgread_object()
        return cls(wallpaper=_wallpaper, unsave=_unsave, settings=_settings)


@dataclasses.dataclass(init=False, frozen=True)
class SendChangePhoneCode(TLRequest):
    """
    :returns auth.SentCode: Instance of SentCode.
    """
    __slots__ = ('phone_number', 'settings',)
    CONSTRUCTOR_ID = 0x82574ae5
    SUBCLASS_OF_ID = 0x6ce87081

    phone_number: str
    settings: 'TypeCodeSettings'
    def __init__(self, phone_number: str, settings: 'TypeCodeSettings'):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'settings', settings)

    def _bytes(self):
        return b''.join((
            b'\xe5JW\x82',
            self._serialize_bytes(self.phone_number),
            self.settings._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _settings = reader.tgread_object()
        return cls(phone_number=_phone_number, settings=_settings)


@dataclasses.dataclass(init=False, frozen=True)
class SendConfirmPhoneCode(TLRequest):
    """
    :returns auth.SentCode: Instance of SentCode.
    """
    __slots__ = ('hash', 'settings',)
    CONSTRUCTOR_ID = 0x1b3faa88
    SUBCLASS_OF_ID = 0x6ce87081

    hash: str
    settings: 'TypeCodeSettings'
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: str, settings: 'TypeCodeSettings'):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'settings', settings)

    def _bytes(self):
        return b''.join((
            b'\x88\xaa?\x1b',
            self._serialize_bytes(self.hash),
            self.settings._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.tgread_string()
        _settings = reader.tgread_object()
        return cls(hash=_hash, settings=_settings)


@dataclasses.dataclass(init=False, frozen=True)
class SendVerifyEmailCode(TLRequest):
    """
    :returns account.SentEmailCode: Instance of SentEmailCode.
    """
    __slots__ = ('email',)
    CONSTRUCTOR_ID = 0x7011509f
    SUBCLASS_OF_ID = 0x69f3c06e

    email: str
    def __init__(self, email: str):
        object.__setattr__(self, 'email', email)

    def _bytes(self):
        return b''.join((
            b'\x9fP\x11p',
            self._serialize_bytes(self.email),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _email = reader.tgread_string()
        return cls(email=_email)


@dataclasses.dataclass(init=False, frozen=True)
class SendVerifyPhoneCode(TLRequest):
    """
    :returns auth.SentCode: Instance of SentCode.
    """
    __slots__ = ('phone_number', 'settings',)
    CONSTRUCTOR_ID = 0xa5a356f9
    SUBCLASS_OF_ID = 0x6ce87081

    phone_number: str
    settings: 'TypeCodeSettings'
    def __init__(self, phone_number: str, settings: 'TypeCodeSettings'):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'settings', settings)

    def _bytes(self):
        return b''.join((
            b'\xf9V\xa3\xa5',
            self._serialize_bytes(self.phone_number),
            self.settings._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _settings = reader.tgread_object()
        return cls(phone_number=_phone_number, settings=_settings)


@dataclasses.dataclass(init=False, frozen=True)
class SetAccountTTL(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('ttl',)
    CONSTRUCTOR_ID = 0x2442485e
    SUBCLASS_OF_ID = 0xf5b399ac

    ttl: 'TypeAccountDaysTTL'
    def __init__(self, ttl: 'TypeAccountDaysTTL'):
        object.__setattr__(self, 'ttl', ttl)

    def _bytes(self):
        return b''.join((
            b'^HB$',
            self.ttl._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _ttl = reader.tgread_object()
        return cls(ttl=_ttl)


@dataclasses.dataclass(init=False, frozen=True)
class SetAuthorizationTTL(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('authorization_ttl_days',)
    CONSTRUCTOR_ID = 0xbf899aa0
    SUBCLASS_OF_ID = 0xf5b399ac

    authorization_ttl_days: int
    def __init__(self, authorization_ttl_days: int):
        object.__setattr__(self, 'authorization_ttl_days', authorization_ttl_days)

    def _bytes(self):
        return b''.join((
            b'\xa0\x9a\x89\xbf',
            struct.pack('<i', self.authorization_ttl_days),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _authorization_ttl_days = reader.read_int()
        return cls(authorization_ttl_days=_authorization_ttl_days)


@dataclasses.dataclass(init=False, frozen=True)
class SetContactSignUpNotification(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('silent',)
    CONSTRUCTOR_ID = 0xcff43f61
    SUBCLASS_OF_ID = 0xf5b399ac

    silent: bool
    def __init__(self, silent: bool):
        object.__setattr__(self, 'silent', silent)

    def _bytes(self):
        return b''.join((
            b'a?\xf4\xcf',
            b'\xb5ur\x99' if self.silent else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _silent = reader.tgread_bool()
        return cls(silent=_silent)


@dataclasses.dataclass(init=False, frozen=True)
class SetContentSettings(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('sensitive_enabled',)
    CONSTRUCTOR_ID = 0xb574b16b
    SUBCLASS_OF_ID = 0xf5b399ac

    sensitive_enabled: Optional[bool]
    def __init__(self, sensitive_enabled: Optional[bool]=None):
        object.__setattr__(self, 'sensitive_enabled', sensitive_enabled)

    def _bytes(self):
        return b''.join((
            b'k\xb1t\xb5',
            struct.pack('<I', (0 if self.sensitive_enabled is None or self.sensitive_enabled is False else 1)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _sensitive_enabled = bool(flags & 1)
        return cls(sensitive_enabled=_sensitive_enabled)


@dataclasses.dataclass(init=False, frozen=True)
class SetGlobalPrivacySettings(TLRequest):
    """
    :returns GlobalPrivacySettings: Instance of GlobalPrivacySettings.
    """
    __slots__ = ('settings',)
    CONSTRUCTOR_ID = 0x1edaaac2
    SUBCLASS_OF_ID = 0xc90e5770

    settings: 'TypeGlobalPrivacySettings'
    def __init__(self, settings: 'TypeGlobalPrivacySettings'):
        object.__setattr__(self, 'settings', settings)

    def _bytes(self):
        return b''.join((
            b'\xc2\xaa\xda\x1e',
            self.settings._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _settings = reader.tgread_object()
        return cls(settings=_settings)


@dataclasses.dataclass(init=False, frozen=True)
class SetPrivacy(TLRequest):
    """
    :returns account.PrivacyRules: Instance of PrivacyRules.
    """
    __slots__ = ('key', 'rules',)
    CONSTRUCTOR_ID = 0xc9f81ce8
    SUBCLASS_OF_ID = 0xb55aba82

    key: 'TypeInputPrivacyKey'
    rules: List['TypeInputPrivacyRule']
    def __init__(self, key: 'TypeInputPrivacyKey', rules: List['TypeInputPrivacyRule']):
        object.__setattr__(self, 'key', key)
        object.__setattr__(self, 'rules', rules)

    def _bytes(self):
        return b''.join((
            b'\xe8\x1c\xf8\xc9',
            self.key._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.rules)),b''.join(x._bytes() for x in self.rules),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _key = reader.tgread_object()
        reader.read_int()
        _rules = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _rules.append(_x)

        return cls(key=_key, rules=_rules)


@dataclasses.dataclass(init=False, frozen=True)
class UnregisterDevice(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('token_type', 'token', 'other_uids',)
    CONSTRUCTOR_ID = 0x6a0d3206
    SUBCLASS_OF_ID = 0xf5b399ac

    token_type: int
    token: str
    other_uids: List[int]
    def __init__(self, token_type: int, token: str, other_uids: List[int]):
        object.__setattr__(self, 'token_type', token_type)
        object.__setattr__(self, 'token', token)
        object.__setattr__(self, 'other_uids', other_uids)

    def _bytes(self):
        return b''.join((
            b'\x062\rj',
            struct.pack('<i', self.token_type),
            self._serialize_bytes(self.token),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.other_uids)),b''.join(struct.pack('<q', x) for x in self.other_uids),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _token_type = reader.read_int()
        _token = reader.tgread_string()
        reader.read_int()
        _other_uids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _other_uids.append(_x)

        return cls(token_type=_token_type, token=_token, other_uids=_other_uids)


@dataclasses.dataclass(init=False, frozen=True)
class UpdateDeviceLocked(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('period',)
    CONSTRUCTOR_ID = 0x38df3532
    SUBCLASS_OF_ID = 0xf5b399ac

    period: int
    def __init__(self, period: int):
        object.__setattr__(self, 'period', period)

    def _bytes(self):
        return b''.join((
            b'25\xdf8',
            struct.pack('<i', self.period),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _period = reader.read_int()
        return cls(period=_period)


@dataclasses.dataclass(init=False, frozen=True)
class UpdateNotifySettings(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('peer', 'settings',)
    CONSTRUCTOR_ID = 0x84be5b93
    SUBCLASS_OF_ID = 0xf5b399ac

    peer: 'TypeInputNotifyPeer'
    settings: 'TypeInputPeerNotifySettings'
    def __init__(self, peer: 'TypeInputNotifyPeer', settings: 'TypeInputPeerNotifySettings'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'settings', settings)

    async def _resolve(self, client, utils):
        r = {}
        r['peer'] = await client._get_input_notify(self.peer)
        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\x93[\xbe\x84',
            self.peer._bytes(),
            self.settings._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _settings = reader.tgread_object()
        return cls(peer=_peer, settings=_settings)


@dataclasses.dataclass(init=False, frozen=True)
class UpdatePasswordSettings(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('password', 'new_settings',)
    CONSTRUCTOR_ID = 0xa59b102f
    SUBCLASS_OF_ID = 0xf5b399ac

    password: 'TypeInputCheckPasswordSRP'
    new_settings: 'TypePasswordInputSettings'
    def __init__(self, password: 'TypeInputCheckPasswordSRP', new_settings: 'TypePasswordInputSettings'):
        object.__setattr__(self, 'password', password)
        object.__setattr__(self, 'new_settings', new_settings)

    def _bytes(self):
        return b''.join((
            b'/\x10\x9b\xa5',
            self.password._bytes(),
            self.new_settings._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _password = reader.tgread_object()
        _new_settings = reader.tgread_object()
        return cls(password=_password, new_settings=_new_settings)


@dataclasses.dataclass(init=False, frozen=True)
class UpdateProfile(TLRequest):
    """
    :returns User: Instance of either UserEmpty, User.
    """
    __slots__ = ('first_name', 'last_name', 'about',)
    CONSTRUCTOR_ID = 0x78515775
    SUBCLASS_OF_ID = 0x2da17977

    first_name: Optional[str]
    last_name: Optional[str]
    about: Optional[str]
    def __init__(self, first_name: Optional[str]=None, last_name: Optional[str]=None, about: Optional[str]=None):
        object.__setattr__(self, 'first_name', first_name)
        object.__setattr__(self, 'last_name', last_name)
        object.__setattr__(self, 'about', about)

    def _bytes(self):
        return b''.join((
            b'uWQx',
            struct.pack('<I', (0 if self.first_name is None or self.first_name is False else 1) | (0 if self.last_name is None or self.last_name is False else 2) | (0 if self.about is None or self.about is False else 4)),
            b'' if self.first_name is None or self.first_name is False else (self._serialize_bytes(self.first_name)),
            b'' if self.last_name is None or self.last_name is False else (self._serialize_bytes(self.last_name)),
            b'' if self.about is None or self.about is False else (self._serialize_bytes(self.about)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _first_name = reader.tgread_string()
        else:
            _first_name = None
        if flags & 2:
            _last_name = reader.tgread_string()
        else:
            _last_name = None
        if flags & 4:
            _about = reader.tgread_string()
        else:
            _about = None
        return cls(first_name=_first_name, last_name=_last_name, about=_about)


@dataclasses.dataclass(init=False, frozen=True)
class UpdateStatus(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('offline',)
    CONSTRUCTOR_ID = 0x6628562c
    SUBCLASS_OF_ID = 0xf5b399ac

    offline: bool
    def __init__(self, offline: bool):
        object.__setattr__(self, 'offline', offline)

    def _bytes(self):
        return b''.join((
            b',V(f',
            b'\xb5ur\x99' if self.offline else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offline = reader.tgread_bool()
        return cls(offline=_offline)


@dataclasses.dataclass(init=False, frozen=True)
class UpdateTheme(TLRequest):
    """
    :returns Theme: Instance of Theme.
    """
    __slots__ = ('format', 'theme', 'slug', 'title', 'document', 'settings',)
    CONSTRUCTOR_ID = 0x2bf40ccc
    SUBCLASS_OF_ID = 0x56b4c80c

    format: str
    theme: 'TypeInputTheme'
    slug: Optional[str]
    title: Optional[str]
    document: Optional['TypeInputDocument']
    settings: Optional[List['TypeInputThemeSettings']]
    # noinspection PyShadowingBuiltins
    def __init__(self, format: str, theme: 'TypeInputTheme', slug: Optional[str]=None, title: Optional[str]=None, document: Optional['TypeInputDocument']=None, settings: Optional[List['TypeInputThemeSettings']]=None):
        object.__setattr__(self, 'format', format)
        object.__setattr__(self, 'theme', theme)
        object.__setattr__(self, 'slug', slug)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'document', document)
        object.__setattr__(self, 'settings', settings)

    async def _resolve(self, client, utils):
        r = {}
        if self.document:
            r['document'] = utils.get_input_document(self.document)

        return dataclasses.replace(self, **r)

    def _bytes(self):
        return b''.join((
            b'\xcc\x0c\xf4+',
            struct.pack('<I', (0 if self.slug is None or self.slug is False else 1) | (0 if self.title is None or self.title is False else 2) | (0 if self.document is None or self.document is False else 4) | (0 if self.settings is None or self.settings is False else 8)),
            self._serialize_bytes(self.format),
            self.theme._bytes(),
            b'' if self.slug is None or self.slug is False else (self._serialize_bytes(self.slug)),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
            b'' if self.settings is None or self.settings is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.settings)),b''.join(x._bytes() for x in self.settings))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _format = reader.tgread_string()
        _theme = reader.tgread_object()
        if flags & 1:
            _slug = reader.tgread_string()
        else:
            _slug = None
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 4:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 8:
            reader.read_int()
            _settings = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _settings.append(_x)

        else:
            _settings = None
        return cls(format=_format, theme=_theme, slug=_slug, title=_title, document=_document, settings=_settings)


@dataclasses.dataclass(init=False, frozen=True)
class UpdateUsername(TLRequest):
    """
    :returns User: Instance of either UserEmpty, User.
    """
    __slots__ = ('username',)
    CONSTRUCTOR_ID = 0x3e0bdd7c
    SUBCLASS_OF_ID = 0x2da17977

    username: str
    def __init__(self, username: str):
        object.__setattr__(self, 'username', username)

    def _bytes(self):
        return b''.join((
            b'|\xdd\x0b>',
            self._serialize_bytes(self.username),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _username = reader.tgread_string()
        return cls(username=_username)


@dataclasses.dataclass(init=False, frozen=True)
class UploadTheme(TLRequest):
    """
    :returns Document: Instance of either DocumentEmpty, Document.
    """
    __slots__ = ('file', 'file_name', 'mime_type', 'thumb',)
    CONSTRUCTOR_ID = 0x1c3db333
    SUBCLASS_OF_ID = 0x211fe820

    file: 'TypeInputFile'
    file_name: str
    mime_type: str
    thumb: Optional['TypeInputFile']
    def __init__(self, file: 'TypeInputFile', file_name: str, mime_type: str, thumb: Optional['TypeInputFile']=None):
        object.__setattr__(self, 'file', file)
        object.__setattr__(self, 'file_name', file_name)
        object.__setattr__(self, 'mime_type', mime_type)
        object.__setattr__(self, 'thumb', thumb)

    def _bytes(self):
        return b''.join((
            b'3\xb3=\x1c',
            struct.pack('<I', (0 if self.thumb is None or self.thumb is False else 1)),
            self.file._bytes(),
            b'' if self.thumb is None or self.thumb is False else (self.thumb._bytes()),
            self._serialize_bytes(self.file_name),
            self._serialize_bytes(self.mime_type),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _file = reader.tgread_object()
        if flags & 1:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        _file_name = reader.tgread_string()
        _mime_type = reader.tgread_string()
        return cls(file=_file, file_name=_file_name, mime_type=_mime_type, thumb=_thumb)


@dataclasses.dataclass(init=False, frozen=True)
class UploadWallPaper(TLRequest):
    """
    :returns WallPaper: Instance of either WallPaper, WallPaperNoFile.
    """
    __slots__ = ('file', 'mime_type', 'settings',)
    CONSTRUCTOR_ID = 0xdd853661
    SUBCLASS_OF_ID = 0x96a2c98b

    file: 'TypeInputFile'
    mime_type: str
    settings: 'TypeWallPaperSettings'
    def __init__(self, file: 'TypeInputFile', mime_type: str, settings: 'TypeWallPaperSettings'):
        object.__setattr__(self, 'file', file)
        object.__setattr__(self, 'mime_type', mime_type)
        object.__setattr__(self, 'settings', settings)

    def _bytes(self):
        return b''.join((
            b'a6\x85\xdd',
            self.file._bytes(),
            self._serialize_bytes(self.mime_type),
            self.settings._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _file = reader.tgread_object()
        _mime_type = reader.tgread_string()
        _settings = reader.tgread_object()
        return cls(file=_file, mime_type=_mime_type, settings=_settings)


@dataclasses.dataclass(init=False, frozen=True)
class VerifyEmail(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('email', 'code',)
    CONSTRUCTOR_ID = 0xecba39db
    SUBCLASS_OF_ID = 0xf5b399ac

    email: str
    code: str
    def __init__(self, email: str, code: str):
        object.__setattr__(self, 'email', email)
        object.__setattr__(self, 'code', code)

    def _bytes(self):
        return b''.join((
            b'\xdb9\xba\xec',
            self._serialize_bytes(self.email),
            self._serialize_bytes(self.code),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _email = reader.tgread_string()
        _code = reader.tgread_string()
        return cls(email=_email, code=_code)


@dataclasses.dataclass(init=False, frozen=True)
class VerifyPhone(TLRequest):
    """
    :returns Bool: This type has no constructors.
    """
    __slots__ = ('phone_number', 'phone_code_hash', 'phone_code',)
    CONSTRUCTOR_ID = 0x4dd3a7f6
    SUBCLASS_OF_ID = 0xf5b399ac

    phone_number: str
    phone_code_hash: str
    phone_code: str
    def __init__(self, phone_number: str, phone_code_hash: str, phone_code: str):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'phone_code_hash', phone_code_hash)
        object.__setattr__(self, 'phone_code', phone_code)

    def _bytes(self):
        return b''.join((
            b'\xf6\xa7\xd3M',
            self._serialize_bytes(self.phone_number),
            self._serialize_bytes(self.phone_code_hash),
            self._serialize_bytes(self.phone_code),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _phone_code_hash = reader.tgread_string()
        _phone_code = reader.tgread_string()
        return cls(phone_number=_phone_number, phone_code_hash=_phone_code_hash, phone_code=_phone_code)

