"""File generated by TLObjects' generator. All changes will be ERASED"""
from .._misc.tlobject import TLObject, TLRequest
from . import fn
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from . import TypeUser
    from ..help import TypeTermsOfService
    from ..auth import TypeAuthorization, TypeCodeType, TypeSentCodeType



@dataclasses.dataclass(init=False, frozen=True)
class Authorization(TLObject):
    """
    Constructor for auth.Authorization: Instance of either Authorization, AuthorizationSignUpRequired.
    """
    __slots__ = ('user', 'setup_password_required', 'otherwise_relogin_days', 'tmp_sessions',)
    CONSTRUCTOR_ID = 0x33fb7bb8
    SUBCLASS_OF_ID = 0xb9e04e39

    user: 'TypeUser'
    setup_password_required: Optional[bool]
    otherwise_relogin_days: Optional[int]
    tmp_sessions: Optional[int]
    def __init__(self, user: 'TypeUser', setup_password_required: Optional[bool]=None, otherwise_relogin_days: Optional[int]=None, tmp_sessions: Optional[int]=None):
        object.__setattr__(self, 'user', user)
        object.__setattr__(self, 'setup_password_required', setup_password_required)
        object.__setattr__(self, 'otherwise_relogin_days', otherwise_relogin_days)
        object.__setattr__(self, 'tmp_sessions', tmp_sessions)

    def _bytes(self):
        assert ((self.setup_password_required or self.setup_password_required is not None) and (self.otherwise_relogin_days or self.otherwise_relogin_days is not None)) or ((self.setup_password_required is None or self.setup_password_required is False) and (self.otherwise_relogin_days is None or self.otherwise_relogin_days is False)), 'setup_password_required, otherwise_relogin_days parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xb8{\xfb3',
            struct.pack('<I', (0 if self.setup_password_required is None or self.setup_password_required is False else 2) | (0 if self.otherwise_relogin_days is None or self.otherwise_relogin_days is False else 2) | (0 if self.tmp_sessions is None or self.tmp_sessions is False else 1)),
            b'' if self.otherwise_relogin_days is None or self.otherwise_relogin_days is False else (struct.pack('<i', self.otherwise_relogin_days)),
            b'' if self.tmp_sessions is None or self.tmp_sessions is False else (struct.pack('<i', self.tmp_sessions)),
            self.user._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _setup_password_required = bool(flags & 2)
        if flags & 2:
            _otherwise_relogin_days = reader.read_int()
        else:
            _otherwise_relogin_days = None
        if flags & 1:
            _tmp_sessions = reader.read_int()
        else:
            _tmp_sessions = None
        _user = reader.tgread_object()
        return cls(user=_user, setup_password_required=_setup_password_required, otherwise_relogin_days=_otherwise_relogin_days, tmp_sessions=_tmp_sessions)


@dataclasses.dataclass(init=False, frozen=True)
class AuthorizationSignUpRequired(TLObject):
    """
    Constructor for auth.Authorization: Instance of either Authorization, AuthorizationSignUpRequired.
    """
    __slots__ = ('terms_of_service',)
    CONSTRUCTOR_ID = 0x44747e9a
    SUBCLASS_OF_ID = 0xb9e04e39

    terms_of_service: Optional['TypeTermsOfService']
    def __init__(self, terms_of_service: Optional['TypeTermsOfService']=None):
        object.__setattr__(self, 'terms_of_service', terms_of_service)

    def _bytes(self):
        return b''.join((
            b'\x9a~tD',
            struct.pack('<I', (0 if self.terms_of_service is None or self.terms_of_service is False else 1)),
            b'' if self.terms_of_service is None or self.terms_of_service is False else (self.terms_of_service._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _terms_of_service = reader.tgread_object()
        else:
            _terms_of_service = None
        return cls(terms_of_service=_terms_of_service)


@dataclasses.dataclass(init=False, frozen=True)
class CodeTypeCall(TLObject):
    """
    Constructor for auth.CodeType: Instance of either CodeTypeSms, CodeTypeCall, CodeTypeFlashCall, CodeTypeMissedCall.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x741cd3e3
    SUBCLASS_OF_ID = 0xb3f3e401

    def _bytes(self):
        return b''.join((
            b'\xe3\xd3\x1ct',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class CodeTypeFlashCall(TLObject):
    """
    Constructor for auth.CodeType: Instance of either CodeTypeSms, CodeTypeCall, CodeTypeFlashCall, CodeTypeMissedCall.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x226ccefb
    SUBCLASS_OF_ID = 0xb3f3e401

    def _bytes(self):
        return b''.join((
            b'\xfb\xcel"',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class CodeTypeMissedCall(TLObject):
    """
    Constructor for auth.CodeType: Instance of either CodeTypeSms, CodeTypeCall, CodeTypeFlashCall, CodeTypeMissedCall.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd61ad6ee
    SUBCLASS_OF_ID = 0xb3f3e401

    def _bytes(self):
        return b''.join((
            b'\xee\xd6\x1a\xd6',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class CodeTypeSms(TLObject):
    """
    Constructor for auth.CodeType: Instance of either CodeTypeSms, CodeTypeCall, CodeTypeFlashCall, CodeTypeMissedCall.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x72a3158c
    SUBCLASS_OF_ID = 0xb3f3e401

    def _bytes(self):
        return b''.join((
            b'\x8c\x15\xa3r',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ExportedAuthorization(TLObject):
    """
    Constructor for auth.ExportedAuthorization: Instance of ExportedAuthorization.
    """
    __slots__ = ('id', 'bytes',)
    CONSTRUCTOR_ID = 0xb434e2b8
    SUBCLASS_OF_ID = 0x5fd1ec51

    id: int
    bytes: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, bytes: bytes):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'bytes', bytes)

    def _bytes(self):
        return b''.join((
            b'\xb8\xe24\xb4',
            struct.pack('<q', self.id),
            self._serialize_bytes(self.bytes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _bytes = reader.tgread_bytes()
        return cls(id=_id, bytes=_bytes)


@dataclasses.dataclass(init=False, frozen=True)
class LoggedOut(TLObject):
    """
    Constructor for auth.LoggedOut: Instance of LoggedOut.
    """
    __slots__ = ('future_auth_token',)
    CONSTRUCTOR_ID = 0xc3a2835f
    SUBCLASS_OF_ID = 0xa804315

    future_auth_token: Optional[bytes]
    def __init__(self, future_auth_token: Optional[bytes]=None):
        object.__setattr__(self, 'future_auth_token', future_auth_token)

    def _bytes(self):
        return b''.join((
            b'_\x83\xa2\xc3',
            struct.pack('<I', (0 if self.future_auth_token is None or self.future_auth_token is False else 1)),
            b'' if self.future_auth_token is None or self.future_auth_token is False else (self._serialize_bytes(self.future_auth_token)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _future_auth_token = reader.tgread_bytes()
        else:
            _future_auth_token = None
        return cls(future_auth_token=_future_auth_token)


@dataclasses.dataclass(init=False, frozen=True)
class LoginToken(TLObject):
    """
    Constructor for auth.LoginToken: Instance of either LoginToken, LoginTokenMigrateTo, LoginTokenSuccess.
    """
    __slots__ = ('expires', 'token',)
    CONSTRUCTOR_ID = 0x629f1980
    SUBCLASS_OF_ID = 0x6b55f636

    expires: Optional[datetime]
    token: bytes
    def __init__(self, expires: Optional[datetime], token: bytes):
        object.__setattr__(self, 'expires', expires)
        object.__setattr__(self, 'token', token)

    def _bytes(self):
        return b''.join((
            b'\x80\x19\x9fb',
            self._serialize_datetime(self.expires),
            self._serialize_bytes(self.token),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _expires = reader.tgread_date()
        _token = reader.tgread_bytes()
        return cls(expires=_expires, token=_token)


@dataclasses.dataclass(init=False, frozen=True)
class LoginTokenMigrateTo(TLObject):
    """
    Constructor for auth.LoginToken: Instance of either LoginToken, LoginTokenMigrateTo, LoginTokenSuccess.
    """
    __slots__ = ('dc_id', 'token',)
    CONSTRUCTOR_ID = 0x68e9916
    SUBCLASS_OF_ID = 0x6b55f636

    dc_id: int
    token: bytes
    def __init__(self, dc_id: int, token: bytes):
        object.__setattr__(self, 'dc_id', dc_id)
        object.__setattr__(self, 'token', token)

    def _bytes(self):
        return b''.join((
            b'\x16\x99\x8e\x06',
            struct.pack('<i', self.dc_id),
            self._serialize_bytes(self.token),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _dc_id = reader.read_int()
        _token = reader.tgread_bytes()
        return cls(dc_id=_dc_id, token=_token)


@dataclasses.dataclass(init=False, frozen=True)
class LoginTokenSuccess(TLObject):
    """
    Constructor for auth.LoginToken: Instance of either LoginToken, LoginTokenMigrateTo, LoginTokenSuccess.
    """
    __slots__ = ('authorization',)
    CONSTRUCTOR_ID = 0x390d5c5e
    SUBCLASS_OF_ID = 0x6b55f636

    authorization: 'TypeAuthorization'
    def __init__(self, authorization: 'TypeAuthorization'):
        object.__setattr__(self, 'authorization', authorization)

    def _bytes(self):
        return b''.join((
            b'^\\\r9',
            self.authorization._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _authorization = reader.tgread_object()
        return cls(authorization=_authorization)


@dataclasses.dataclass(init=False, frozen=True)
class PasswordRecovery(TLObject):
    """
    Constructor for auth.PasswordRecovery: Instance of PasswordRecovery.
    """
    __slots__ = ('email_pattern',)
    CONSTRUCTOR_ID = 0x137948a5
    SUBCLASS_OF_ID = 0xfa72d43a

    email_pattern: str
    def __init__(self, email_pattern: str):
        object.__setattr__(self, 'email_pattern', email_pattern)

    def _bytes(self):
        return b''.join((
            b'\xa5Hy\x13',
            self._serialize_bytes(self.email_pattern),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _email_pattern = reader.tgread_string()
        return cls(email_pattern=_email_pattern)


@dataclasses.dataclass(init=False, frozen=True)
class SentCode(TLObject):
    """
    Constructor for auth.SentCode: Instance of SentCode.
    """
    __slots__ = ('type', 'phone_code_hash', 'next_type', 'timeout',)
    CONSTRUCTOR_ID = 0x5e002502
    SUBCLASS_OF_ID = 0x6ce87081

    type: 'TypeSentCodeType'
    phone_code_hash: str
    next_type: Optional['TypeCodeType']
    timeout: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSentCodeType', phone_code_hash: str, next_type: Optional['TypeCodeType']=None, timeout: Optional[int]=None):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'phone_code_hash', phone_code_hash)
        object.__setattr__(self, 'next_type', next_type)
        object.__setattr__(self, 'timeout', timeout)

    def _bytes(self):
        return b''.join((
            b'\x02%\x00^',
            struct.pack('<I', (0 if self.next_type is None or self.next_type is False else 2) | (0 if self.timeout is None or self.timeout is False else 4)),
            self.type._bytes(),
            self._serialize_bytes(self.phone_code_hash),
            b'' if self.next_type is None or self.next_type is False else (self.next_type._bytes()),
            b'' if self.timeout is None or self.timeout is False else (struct.pack('<i', self.timeout)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _type = reader.tgread_object()
        _phone_code_hash = reader.tgread_string()
        if flags & 2:
            _next_type = reader.tgread_object()
        else:
            _next_type = None
        if flags & 4:
            _timeout = reader.read_int()
        else:
            _timeout = None
        return cls(type=_type, phone_code_hash=_phone_code_hash, next_type=_next_type, timeout=_timeout)


@dataclasses.dataclass(init=False, frozen=True)
class SentCodeTypeApp(TLObject):
    """
    Constructor for auth.SentCodeType: Instance of either SentCodeTypeApp, SentCodeTypeSms, SentCodeTypeCall, SentCodeTypeFlashCall, SentCodeTypeMissedCall.
    """
    __slots__ = ('length',)
    CONSTRUCTOR_ID = 0x3dbb5986
    SUBCLASS_OF_ID = 0xff5b158e

    length: int
    def __init__(self, length: int):
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\x86Y\xbb=',
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _length = reader.read_int()
        return cls(length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class SentCodeTypeCall(TLObject):
    """
    Constructor for auth.SentCodeType: Instance of either SentCodeTypeApp, SentCodeTypeSms, SentCodeTypeCall, SentCodeTypeFlashCall, SentCodeTypeMissedCall.
    """
    __slots__ = ('length',)
    CONSTRUCTOR_ID = 0x5353e5a7
    SUBCLASS_OF_ID = 0xff5b158e

    length: int
    def __init__(self, length: int):
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\xa7\xe5SS',
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _length = reader.read_int()
        return cls(length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class SentCodeTypeFlashCall(TLObject):
    """
    Constructor for auth.SentCodeType: Instance of either SentCodeTypeApp, SentCodeTypeSms, SentCodeTypeCall, SentCodeTypeFlashCall, SentCodeTypeMissedCall.
    """
    __slots__ = ('pattern',)
    CONSTRUCTOR_ID = 0xab03c6d9
    SUBCLASS_OF_ID = 0xff5b158e

    pattern: str
    def __init__(self, pattern: str):
        object.__setattr__(self, 'pattern', pattern)

    def _bytes(self):
        return b''.join((
            b'\xd9\xc6\x03\xab',
            self._serialize_bytes(self.pattern),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _pattern = reader.tgread_string()
        return cls(pattern=_pattern)


@dataclasses.dataclass(init=False, frozen=True)
class SentCodeTypeMissedCall(TLObject):
    """
    Constructor for auth.SentCodeType: Instance of either SentCodeTypeApp, SentCodeTypeSms, SentCodeTypeCall, SentCodeTypeFlashCall, SentCodeTypeMissedCall.
    """
    __slots__ = ('prefix', 'length',)
    CONSTRUCTOR_ID = 0x82006484
    SUBCLASS_OF_ID = 0xff5b158e

    prefix: str
    length: int
    def __init__(self, prefix: str, length: int):
        object.__setattr__(self, 'prefix', prefix)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\x84d\x00\x82',
            self._serialize_bytes(self.prefix),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prefix = reader.tgread_string()
        _length = reader.read_int()
        return cls(prefix=_prefix, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class SentCodeTypeSms(TLObject):
    """
    Constructor for auth.SentCodeType: Instance of either SentCodeTypeApp, SentCodeTypeSms, SentCodeTypeCall, SentCodeTypeFlashCall, SentCodeTypeMissedCall.
    """
    __slots__ = ('length',)
    CONSTRUCTOR_ID = 0xc000bba2
    SUBCLASS_OF_ID = 0xff5b158e

    length: int
    def __init__(self, length: int):
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\xa2\xbb\x00\xc0',
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _length = reader.read_int()
        return cls(length=_length)

