"""File generated by TLObjects' generator. All changes will be ERASED"""
from .._misc.tlobject import TLObject, TLRequest
from . import fn
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from . import TypeAuthorization, TypeAutoDownloadSettings, TypeChat, TypePasswordKdfAlgo, TypePrivacyRule, TypeSecurePasswordKdfAlgo, TypeSecureRequiredType, TypeSecureSecretSettings, TypeSecureValue, TypeSecureValueError, TypeTheme, TypeUser, TypeWallPaper, TypeWebAuthorization



@dataclasses.dataclass(init=False, frozen=True)
class AuthorizationForm(TLObject):
    """
    Constructor for account.AuthorizationForm: Instance of AuthorizationForm.
    """
    __slots__ = ('required_types', 'values', 'errors', 'users', 'privacy_policy_url',)
    CONSTRUCTOR_ID = 0xad2e1cd8
    SUBCLASS_OF_ID = 0x78049a94

    required_types: List['TypeSecureRequiredType']
    values: List['TypeSecureValue']
    errors: List['TypeSecureValueError']
    users: List['TypeUser']
    privacy_policy_url: Optional[str]
    def __init__(self, required_types: List['TypeSecureRequiredType'], values: List['TypeSecureValue'], errors: List['TypeSecureValueError'], users: List['TypeUser'], privacy_policy_url: Optional[str]=None):
        object.__setattr__(self, 'required_types', required_types)
        object.__setattr__(self, 'values', values)
        object.__setattr__(self, 'errors', errors)
        object.__setattr__(self, 'users', users)
        object.__setattr__(self, 'privacy_policy_url', privacy_policy_url)

    def _bytes(self):
        return b''.join((
            b'\xd8\x1c.\xad',
            struct.pack('<I', (0 if self.privacy_policy_url is None or self.privacy_policy_url is False else 1)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.required_types)),b''.join(x._bytes() for x in self.required_types),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.values)),b''.join(x._bytes() for x in self.values),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.errors)),b''.join(x._bytes() for x in self.errors),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
            b'' if self.privacy_policy_url is None or self.privacy_policy_url is False else (self._serialize_bytes(self.privacy_policy_url)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        reader.read_int()
        _required_types = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _required_types.append(_x)

        reader.read_int()
        _values = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _values.append(_x)

        reader.read_int()
        _errors = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _errors.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        if flags & 1:
            _privacy_policy_url = reader.tgread_string()
        else:
            _privacy_policy_url = None
        return cls(required_types=_required_types, values=_values, errors=_errors, users=_users, privacy_policy_url=_privacy_policy_url)


@dataclasses.dataclass(init=False, frozen=True)
class Authorizations(TLObject):
    """
    Constructor for account.Authorizations: Instance of Authorizations.
    """
    __slots__ = ('authorization_ttl_days', 'authorizations',)
    CONSTRUCTOR_ID = 0x4bff8ea0
    SUBCLASS_OF_ID = 0xbf5e0ff

    authorization_ttl_days: int
    authorizations: List['TypeAuthorization']
    def __init__(self, authorization_ttl_days: int, authorizations: List['TypeAuthorization']):
        object.__setattr__(self, 'authorization_ttl_days', authorization_ttl_days)
        object.__setattr__(self, 'authorizations', authorizations)

    def _bytes(self):
        return b''.join((
            b'\xa0\x8e\xffK',
            struct.pack('<i', self.authorization_ttl_days),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.authorizations)),b''.join(x._bytes() for x in self.authorizations),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _authorization_ttl_days = reader.read_int()
        reader.read_int()
        _authorizations = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _authorizations.append(_x)

        return cls(authorization_ttl_days=_authorization_ttl_days, authorizations=_authorizations)


@dataclasses.dataclass(init=False, frozen=True)
class AutoDownloadSettings(TLObject):
    """
    Constructor for account.AutoDownloadSettings: Instance of AutoDownloadSettings.
    """
    __slots__ = ('low', 'medium', 'high',)
    CONSTRUCTOR_ID = 0x63cacf26
    SUBCLASS_OF_ID = 0x2fb85921

    low: 'TypeAutoDownloadSettings'
    medium: 'TypeAutoDownloadSettings'
    high: 'TypeAutoDownloadSettings'
    def __init__(self, low: 'TypeAutoDownloadSettings', medium: 'TypeAutoDownloadSettings', high: 'TypeAutoDownloadSettings'):
        object.__setattr__(self, 'low', low)
        object.__setattr__(self, 'medium', medium)
        object.__setattr__(self, 'high', high)

    def _bytes(self):
        return b''.join((
            b'&\xcf\xcac',
            self.low._bytes(),
            self.medium._bytes(),
            self.high._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _low = reader.tgread_object()
        _medium = reader.tgread_object()
        _high = reader.tgread_object()
        return cls(low=_low, medium=_medium, high=_high)


@dataclasses.dataclass(init=False, frozen=True)
class ContentSettings(TLObject):
    """
    Constructor for account.ContentSettings: Instance of ContentSettings.
    """
    __slots__ = ('sensitive_enabled', 'sensitive_can_change',)
    CONSTRUCTOR_ID = 0x57e28221
    SUBCLASS_OF_ID = 0xae3ff891

    sensitive_enabled: Optional[bool]
    sensitive_can_change: Optional[bool]
    def __init__(self, sensitive_enabled: Optional[bool]=None, sensitive_can_change: Optional[bool]=None):
        object.__setattr__(self, 'sensitive_enabled', sensitive_enabled)
        object.__setattr__(self, 'sensitive_can_change', sensitive_can_change)

    def _bytes(self):
        return b''.join((
            b'!\x82\xe2W',
            struct.pack('<I', (0 if self.sensitive_enabled is None or self.sensitive_enabled is False else 1) | (0 if self.sensitive_can_change is None or self.sensitive_can_change is False else 2)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _sensitive_enabled = bool(flags & 1)
        _sensitive_can_change = bool(flags & 2)
        return cls(sensitive_enabled=_sensitive_enabled, sensitive_can_change=_sensitive_can_change)


@dataclasses.dataclass(init=False, frozen=True)
class Password(TLObject):
    """
    Constructor for account.Password: Instance of Password.
    """
    __slots__ = ('new_algo', 'new_secure_algo', 'secure_random', 'has_recovery', 'has_secure_values', 'has_password', 'current_algo', 'srp_B', 'srp_id', 'hint', 'email_unconfirmed_pattern', 'pending_reset_date',)
    CONSTRUCTOR_ID = 0x185b184f
    SUBCLASS_OF_ID = 0x53a211a3

    new_algo: 'TypePasswordKdfAlgo'
    new_secure_algo: 'TypeSecurePasswordKdfAlgo'
    secure_random: bytes
    has_recovery: Optional[bool]
    has_secure_values: Optional[bool]
    has_password: Optional[bool]
    current_algo: Optional['TypePasswordKdfAlgo']
    srp_B: Optional[bytes]
    srp_id: Optional[int]
    hint: Optional[str]
    email_unconfirmed_pattern: Optional[str]
    pending_reset_date: Optional[datetime]
    def __init__(self, new_algo: 'TypePasswordKdfAlgo', new_secure_algo: 'TypeSecurePasswordKdfAlgo', secure_random: bytes, has_recovery: Optional[bool]=None, has_secure_values: Optional[bool]=None, has_password: Optional[bool]=None, current_algo: Optional['TypePasswordKdfAlgo']=None, srp_B: Optional[bytes]=None, srp_id: Optional[int]=None, hint: Optional[str]=None, email_unconfirmed_pattern: Optional[str]=None, pending_reset_date: Optional[datetime]=None):
        object.__setattr__(self, 'new_algo', new_algo)
        object.__setattr__(self, 'new_secure_algo', new_secure_algo)
        object.__setattr__(self, 'secure_random', secure_random)
        object.__setattr__(self, 'has_recovery', has_recovery)
        object.__setattr__(self, 'has_secure_values', has_secure_values)
        object.__setattr__(self, 'has_password', has_password)
        object.__setattr__(self, 'current_algo', current_algo)
        object.__setattr__(self, 'srp_B', srp_B)
        object.__setattr__(self, 'srp_id', srp_id)
        object.__setattr__(self, 'hint', hint)
        object.__setattr__(self, 'email_unconfirmed_pattern', email_unconfirmed_pattern)
        object.__setattr__(self, 'pending_reset_date', pending_reset_date)

    def _bytes(self):
        assert ((self.has_password or self.has_password is not None) and (self.current_algo or self.current_algo is not None) and (self.srp_B or self.srp_B is not None) and (self.srp_id or self.srp_id is not None)) or ((self.has_password is None or self.has_password is False) and (self.current_algo is None or self.current_algo is False) and (self.srp_B is None or self.srp_B is False) and (self.srp_id is None or self.srp_id is False)), 'has_password, current_algo, srp_B, srp_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'O\x18[\x18',
            struct.pack('<I', (0 if self.has_recovery is None or self.has_recovery is False else 1) | (0 if self.has_secure_values is None or self.has_secure_values is False else 2) | (0 if self.has_password is None or self.has_password is False else 4) | (0 if self.current_algo is None or self.current_algo is False else 4) | (0 if self.srp_B is None or self.srp_B is False else 4) | (0 if self.srp_id is None or self.srp_id is False else 4) | (0 if self.hint is None or self.hint is False else 8) | (0 if self.email_unconfirmed_pattern is None or self.email_unconfirmed_pattern is False else 16) | (0 if self.pending_reset_date is None or self.pending_reset_date is False else 32)),
            b'' if self.current_algo is None or self.current_algo is False else (self.current_algo._bytes()),
            b'' if self.srp_B is None or self.srp_B is False else (self._serialize_bytes(self.srp_B)),
            b'' if self.srp_id is None or self.srp_id is False else (struct.pack('<q', self.srp_id)),
            b'' if self.hint is None or self.hint is False else (self._serialize_bytes(self.hint)),
            b'' if self.email_unconfirmed_pattern is None or self.email_unconfirmed_pattern is False else (self._serialize_bytes(self.email_unconfirmed_pattern)),
            self.new_algo._bytes(),
            self.new_secure_algo._bytes(),
            self._serialize_bytes(self.secure_random),
            b'' if self.pending_reset_date is None or self.pending_reset_date is False else (self._serialize_datetime(self.pending_reset_date)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _has_recovery = bool(flags & 1)
        _has_secure_values = bool(flags & 2)
        _has_password = bool(flags & 4)
        if flags & 4:
            _current_algo = reader.tgread_object()
        else:
            _current_algo = None
        if flags & 4:
            _srp_B = reader.tgread_bytes()
        else:
            _srp_B = None
        if flags & 4:
            _srp_id = reader.read_long()
        else:
            _srp_id = None
        if flags & 8:
            _hint = reader.tgread_string()
        else:
            _hint = None
        if flags & 16:
            _email_unconfirmed_pattern = reader.tgread_string()
        else:
            _email_unconfirmed_pattern = None
        _new_algo = reader.tgread_object()
        _new_secure_algo = reader.tgread_object()
        _secure_random = reader.tgread_bytes()
        if flags & 32:
            _pending_reset_date = reader.tgread_date()
        else:
            _pending_reset_date = None
        return cls(new_algo=_new_algo, new_secure_algo=_new_secure_algo, secure_random=_secure_random, has_recovery=_has_recovery, has_secure_values=_has_secure_values, has_password=_has_password, current_algo=_current_algo, srp_B=_srp_B, srp_id=_srp_id, hint=_hint, email_unconfirmed_pattern=_email_unconfirmed_pattern, pending_reset_date=_pending_reset_date)


@dataclasses.dataclass(init=False, frozen=True)
class PasswordInputSettings(TLObject):
    """
    Constructor for account.PasswordInputSettings: Instance of PasswordInputSettings.
    """
    __slots__ = ('new_algo', 'new_password_hash', 'hint', 'email', 'new_secure_settings',)
    CONSTRUCTOR_ID = 0xc23727c9
    SUBCLASS_OF_ID = 0xc426ca6

    new_algo: Optional['TypePasswordKdfAlgo']
    new_password_hash: Optional[bytes]
    hint: Optional[str]
    email: Optional[str]
    new_secure_settings: Optional['TypeSecureSecretSettings']
    def __init__(self, new_algo: Optional['TypePasswordKdfAlgo']=None, new_password_hash: Optional[bytes]=None, hint: Optional[str]=None, email: Optional[str]=None, new_secure_settings: Optional['TypeSecureSecretSettings']=None):
        object.__setattr__(self, 'new_algo', new_algo)
        object.__setattr__(self, 'new_password_hash', new_password_hash)
        object.__setattr__(self, 'hint', hint)
        object.__setattr__(self, 'email', email)
        object.__setattr__(self, 'new_secure_settings', new_secure_settings)

    def _bytes(self):
        assert ((self.new_algo or self.new_algo is not None) and (self.new_password_hash or self.new_password_hash is not None) and (self.hint or self.hint is not None)) or ((self.new_algo is None or self.new_algo is False) and (self.new_password_hash is None or self.new_password_hash is False) and (self.hint is None or self.hint is False)), 'new_algo, new_password_hash, hint parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b"\xc9'7\xc2",
            struct.pack('<I', (0 if self.new_algo is None or self.new_algo is False else 1) | (0 if self.new_password_hash is None or self.new_password_hash is False else 1) | (0 if self.hint is None or self.hint is False else 1) | (0 if self.email is None or self.email is False else 2) | (0 if self.new_secure_settings is None or self.new_secure_settings is False else 4)),
            b'' if self.new_algo is None or self.new_algo is False else (self.new_algo._bytes()),
            b'' if self.new_password_hash is None or self.new_password_hash is False else (self._serialize_bytes(self.new_password_hash)),
            b'' if self.hint is None or self.hint is False else (self._serialize_bytes(self.hint)),
            b'' if self.email is None or self.email is False else (self._serialize_bytes(self.email)),
            b'' if self.new_secure_settings is None or self.new_secure_settings is False else (self.new_secure_settings._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _new_algo = reader.tgread_object()
        else:
            _new_algo = None
        if flags & 1:
            _new_password_hash = reader.tgread_bytes()
        else:
            _new_password_hash = None
        if flags & 1:
            _hint = reader.tgread_string()
        else:
            _hint = None
        if flags & 2:
            _email = reader.tgread_string()
        else:
            _email = None
        if flags & 4:
            _new_secure_settings = reader.tgread_object()
        else:
            _new_secure_settings = None
        return cls(new_algo=_new_algo, new_password_hash=_new_password_hash, hint=_hint, email=_email, new_secure_settings=_new_secure_settings)


@dataclasses.dataclass(init=False, frozen=True)
class PasswordSettings(TLObject):
    """
    Constructor for account.PasswordSettings: Instance of PasswordSettings.
    """
    __slots__ = ('email', 'secure_settings',)
    CONSTRUCTOR_ID = 0x9a5c33e5
    SUBCLASS_OF_ID = 0xd23fb078

    email: Optional[str]
    secure_settings: Optional['TypeSecureSecretSettings']
    def __init__(self, email: Optional[str]=None, secure_settings: Optional['TypeSecureSecretSettings']=None):
        object.__setattr__(self, 'email', email)
        object.__setattr__(self, 'secure_settings', secure_settings)

    def _bytes(self):
        return b''.join((
            b'\xe53\\\x9a',
            struct.pack('<I', (0 if self.email is None or self.email is False else 1) | (0 if self.secure_settings is None or self.secure_settings is False else 2)),
            b'' if self.email is None or self.email is False else (self._serialize_bytes(self.email)),
            b'' if self.secure_settings is None or self.secure_settings is False else (self.secure_settings._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _email = reader.tgread_string()
        else:
            _email = None
        if flags & 2:
            _secure_settings = reader.tgread_object()
        else:
            _secure_settings = None
        return cls(email=_email, secure_settings=_secure_settings)


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyRules(TLObject):
    """
    Constructor for account.PrivacyRules: Instance of PrivacyRules.
    """
    __slots__ = ('rules', 'chats', 'users',)
    CONSTRUCTOR_ID = 0x50a04e45
    SUBCLASS_OF_ID = 0xb55aba82

    rules: List['TypePrivacyRule']
    chats: List['TypeChat']
    users: List['TypeUser']
    def __init__(self, rules: List['TypePrivacyRule'], chats: List['TypeChat'], users: List['TypeUser']):
        object.__setattr__(self, 'rules', rules)
        object.__setattr__(self, 'chats', chats)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'EN\xa0P',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.rules)),b''.join(x._bytes() for x in self.rules),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _rules = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _rules.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(rules=_rules, chats=_chats, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class ResetPasswordFailedWait(TLObject):
    """
    Constructor for account.ResetPasswordResult: Instance of either ResetPasswordFailedWait, ResetPasswordRequestedWait, ResetPasswordOk.
    """
    __slots__ = ('retry_date',)
    CONSTRUCTOR_ID = 0xe3779861
    SUBCLASS_OF_ID = 0x49507416

    retry_date: Optional[datetime]
    def __init__(self, retry_date: Optional[datetime]):
        object.__setattr__(self, 'retry_date', retry_date)

    def _bytes(self):
        return b''.join((
            b'a\x98w\xe3',
            self._serialize_datetime(self.retry_date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _retry_date = reader.tgread_date()
        return cls(retry_date=_retry_date)


@dataclasses.dataclass(init=False, frozen=True)
class ResetPasswordOk(TLObject):
    """
    Constructor for account.ResetPasswordResult: Instance of either ResetPasswordFailedWait, ResetPasswordRequestedWait, ResetPasswordOk.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xe926d63e
    SUBCLASS_OF_ID = 0x49507416

    def _bytes(self):
        return b''.join((
            b'>\xd6&\xe9',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ResetPasswordRequestedWait(TLObject):
    """
    Constructor for account.ResetPasswordResult: Instance of either ResetPasswordFailedWait, ResetPasswordRequestedWait, ResetPasswordOk.
    """
    __slots__ = ('until_date',)
    CONSTRUCTOR_ID = 0xe9effc7d
    SUBCLASS_OF_ID = 0x49507416

    until_date: Optional[datetime]
    def __init__(self, until_date: Optional[datetime]):
        object.__setattr__(self, 'until_date', until_date)

    def _bytes(self):
        return b''.join((
            b'}\xfc\xef\xe9',
            self._serialize_datetime(self.until_date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _until_date = reader.tgread_date()
        return cls(until_date=_until_date)


@dataclasses.dataclass(init=False, frozen=True)
class SentEmailCode(TLObject):
    """
    Constructor for account.SentEmailCode: Instance of SentEmailCode.
    """
    __slots__ = ('email_pattern', 'length',)
    CONSTRUCTOR_ID = 0x811f854f
    SUBCLASS_OF_ID = 0x69f3c06e

    email_pattern: str
    length: int
    def __init__(self, email_pattern: str, length: int):
        object.__setattr__(self, 'email_pattern', email_pattern)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'O\x85\x1f\x81',
            self._serialize_bytes(self.email_pattern),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _email_pattern = reader.tgread_string()
        _length = reader.read_int()
        return cls(email_pattern=_email_pattern, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class Takeout(TLObject):
    """
    Constructor for account.Takeout: Instance of Takeout.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x4dba4501
    SUBCLASS_OF_ID = 0x843ebe85

    id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'\x01E\xbaM',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class Themes(TLObject):
    """
    Constructor for account.Themes: Instance of either ThemesNotModified, Themes.
    """
    __slots__ = ('hash', 'themes',)
    CONSTRUCTOR_ID = 0x9a3d8c6d
    SUBCLASS_OF_ID = 0x7fc52204

    hash: int
    themes: List['TypeTheme']
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, themes: List['TypeTheme']):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'themes', themes)

    def _bytes(self):
        return b''.join((
            b'm\x8c=\x9a',
            struct.pack('<q', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.themes)),b''.join(x._bytes() for x in self.themes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        reader.read_int()
        _themes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _themes.append(_x)

        return cls(hash=_hash, themes=_themes)


@dataclasses.dataclass(init=False, frozen=True)
class ThemesNotModified(TLObject):
    """
    Constructor for account.Themes: Instance of either ThemesNotModified, Themes.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xf41eb622
    SUBCLASS_OF_ID = 0x7fc52204

    def _bytes(self):
        return b''.join((
            b'"\xb6\x1e\xf4',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class TmpPassword(TLObject):
    """
    Constructor for account.TmpPassword: Instance of TmpPassword.
    """
    __slots__ = ('tmp_password', 'valid_until',)
    CONSTRUCTOR_ID = 0xdb64fd34
    SUBCLASS_OF_ID = 0xb064992d

    tmp_password: bytes
    valid_until: Optional[datetime]
    def __init__(self, tmp_password: bytes, valid_until: Optional[datetime]):
        object.__setattr__(self, 'tmp_password', tmp_password)
        object.__setattr__(self, 'valid_until', valid_until)

    def _bytes(self):
        return b''.join((
            b'4\xfdd\xdb',
            self._serialize_bytes(self.tmp_password),
            self._serialize_datetime(self.valid_until),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _tmp_password = reader.tgread_bytes()
        _valid_until = reader.tgread_date()
        return cls(tmp_password=_tmp_password, valid_until=_valid_until)


@dataclasses.dataclass(init=False, frozen=True)
class WallPapers(TLObject):
    """
    Constructor for account.WallPapers: Instance of either WallPapersNotModified, WallPapers.
    """
    __slots__ = ('hash', 'wallpapers',)
    CONSTRUCTOR_ID = 0xcdc3858c
    SUBCLASS_OF_ID = 0xa2c548fd

    hash: int
    wallpapers: List['TypeWallPaper']
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, wallpapers: List['TypeWallPaper']):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'wallpapers', wallpapers)

    def _bytes(self):
        return b''.join((
            b'\x8c\x85\xc3\xcd',
            struct.pack('<q', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.wallpapers)),b''.join(x._bytes() for x in self.wallpapers),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _hash = reader.read_long()
        reader.read_int()
        _wallpapers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _wallpapers.append(_x)

        return cls(hash=_hash, wallpapers=_wallpapers)


@dataclasses.dataclass(init=False, frozen=True)
class WallPapersNotModified(TLObject):
    """
    Constructor for account.WallPapers: Instance of either WallPapersNotModified, WallPapers.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x1c199183
    SUBCLASS_OF_ID = 0xa2c548fd

    def _bytes(self):
        return b''.join((
            b'\x83\x91\x19\x1c',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class WebAuthorizations(TLObject):
    """
    Constructor for account.WebAuthorizations: Instance of WebAuthorizations.
    """
    __slots__ = ('authorizations', 'users',)
    CONSTRUCTOR_ID = 0xed56c9fc
    SUBCLASS_OF_ID = 0x9a365b32

    authorizations: List['TypeWebAuthorization']
    users: List['TypeUser']
    def __init__(self, authorizations: List['TypeWebAuthorization'], users: List['TypeUser']):
        object.__setattr__(self, 'authorizations', authorizations)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\xfc\xc9V\xed',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.authorizations)),b''.join(x._bytes() for x in self.authorizations),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _authorizations = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _authorizations.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(authorizations=_authorizations, users=_users)

