"""File generated by TLObjects' generator. All changes will be ERASED"""
from .._misc.tlobject import TLObject, TLRequest
from . import fn
from typing import Optional, List, Union, TYPE_CHECKING
from . import account, auth, channels, contacts, help, messages, payments, phone, photos, stats, stickers, storage, updates, upload, users
import os
import struct
import dataclasses
from datetime import datetime
if TYPE_CHECKING:
    from . import Typefuture_salt



@dataclasses.dataclass(init=False, frozen=True)
class AccessPointRule(TLObject):
    """
    Constructor for AccessPointRule: Instance of AccessPointRule.
    """
    __slots__ = ('phone_prefix_rules', 'dc_id', 'ips',)
    CONSTRUCTOR_ID = 0x4679b65f
    SUBCLASS_OF_ID = 0xb1aca0fd

    phone_prefix_rules: str
    dc_id: int
    ips: List['TypeIpPort']
    def __init__(self, phone_prefix_rules: str, dc_id: int, ips: List['TypeIpPort']):
        object.__setattr__(self, 'phone_prefix_rules', phone_prefix_rules)
        object.__setattr__(self, 'dc_id', dc_id)
        object.__setattr__(self, 'ips', ips)

    def _bytes(self):
        return b''.join((
            b'_\xb6yF',
            self._serialize_bytes(self.phone_prefix_rules),
            struct.pack('<i', self.dc_id),
            struct.pack('<i', len(self.ips)),b''.join(x._bytes() for x in self.ips),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_prefix_rules = reader.tgread_string()
        _dc_id = reader.read_int()
        _ips = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _ips.append(_x)

        return cls(phone_prefix_rules=_phone_prefix_rules, dc_id=_dc_id, ips=_ips)


@dataclasses.dataclass(init=False, frozen=True)
class AccountDaysTTL(TLObject):
    """
    Constructor for AccountDaysTTL: Instance of AccountDaysTTL.
    """
    __slots__ = ('days',)
    CONSTRUCTOR_ID = 0xb8d0afdf
    SUBCLASS_OF_ID = 0xbaa39d88

    days: int
    def __init__(self, days: int):
        object.__setattr__(self, 'days', days)

    def _bytes(self):
        return b''.join((
            b'\xdf\xaf\xd0\xb8',
            struct.pack('<i', self.days),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _days = reader.read_int()
        return cls(days=_days)


@dataclasses.dataclass(init=False, frozen=True)
class Authorization(TLObject):
    """
    Constructor for Authorization: Instance of Authorization.
    """
    __slots__ = ('hash', 'device_model', 'platform', 'system_version', 'api_id', 'app_name', 'app_version', 'date_created', 'date_active', 'ip', 'country', 'region', 'current', 'official_app', 'password_pending', 'encrypted_requests_disabled', 'call_requests_disabled',)
    CONSTRUCTOR_ID = 0xad01d61d
    SUBCLASS_OF_ID = 0xc913c01a

    hash: int
    device_model: str
    platform: str
    system_version: str
    api_id: int
    app_name: str
    app_version: str
    date_created: Optional[datetime]
    date_active: Optional[datetime]
    ip: str
    country: str
    region: str
    current: Optional[bool]
    official_app: Optional[bool]
    password_pending: Optional[bool]
    encrypted_requests_disabled: Optional[bool]
    call_requests_disabled: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, device_model: str, platform: str, system_version: str, api_id: int, app_name: str, app_version: str, date_created: Optional[datetime], date_active: Optional[datetime], ip: str, country: str, region: str, current: Optional[bool]=None, official_app: Optional[bool]=None, password_pending: Optional[bool]=None, encrypted_requests_disabled: Optional[bool]=None, call_requests_disabled: Optional[bool]=None):
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'device_model', device_model)
        object.__setattr__(self, 'platform', platform)
        object.__setattr__(self, 'system_version', system_version)
        object.__setattr__(self, 'api_id', api_id)
        object.__setattr__(self, 'app_name', app_name)
        object.__setattr__(self, 'app_version', app_version)
        object.__setattr__(self, 'date_created', date_created)
        object.__setattr__(self, 'date_active', date_active)
        object.__setattr__(self, 'ip', ip)
        object.__setattr__(self, 'country', country)
        object.__setattr__(self, 'region', region)
        object.__setattr__(self, 'current', current)
        object.__setattr__(self, 'official_app', official_app)
        object.__setattr__(self, 'password_pending', password_pending)
        object.__setattr__(self, 'encrypted_requests_disabled', encrypted_requests_disabled)
        object.__setattr__(self, 'call_requests_disabled', call_requests_disabled)

    def _bytes(self):
        return b''.join((
            b'\x1d\xd6\x01\xad',
            struct.pack('<I', (0 if self.current is None or self.current is False else 1) | (0 if self.official_app is None or self.official_app is False else 2) | (0 if self.password_pending is None or self.password_pending is False else 4) | (0 if self.encrypted_requests_disabled is None or self.encrypted_requests_disabled is False else 8) | (0 if self.call_requests_disabled is None or self.call_requests_disabled is False else 16)),
            struct.pack('<q', self.hash),
            self._serialize_bytes(self.device_model),
            self._serialize_bytes(self.platform),
            self._serialize_bytes(self.system_version),
            struct.pack('<i', self.api_id),
            self._serialize_bytes(self.app_name),
            self._serialize_bytes(self.app_version),
            self._serialize_datetime(self.date_created),
            self._serialize_datetime(self.date_active),
            self._serialize_bytes(self.ip),
            self._serialize_bytes(self.country),
            self._serialize_bytes(self.region),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _current = bool(flags & 1)
        _official_app = bool(flags & 2)
        _password_pending = bool(flags & 4)
        _encrypted_requests_disabled = bool(flags & 8)
        _call_requests_disabled = bool(flags & 16)
        _hash = reader.read_long()
        _device_model = reader.tgread_string()
        _platform = reader.tgread_string()
        _system_version = reader.tgread_string()
        _api_id = reader.read_int()
        _app_name = reader.tgread_string()
        _app_version = reader.tgread_string()
        _date_created = reader.tgread_date()
        _date_active = reader.tgread_date()
        _ip = reader.tgread_string()
        _country = reader.tgread_string()
        _region = reader.tgread_string()
        return cls(hash=_hash, device_model=_device_model, platform=_platform, system_version=_system_version, api_id=_api_id, app_name=_app_name, app_version=_app_version, date_created=_date_created, date_active=_date_active, ip=_ip, country=_country, region=_region, current=_current, official_app=_official_app, password_pending=_password_pending, encrypted_requests_disabled=_encrypted_requests_disabled, call_requests_disabled=_call_requests_disabled)


@dataclasses.dataclass(init=False, frozen=True)
class AutoDownloadSettings(TLObject):
    """
    Constructor for AutoDownloadSettings: Instance of AutoDownloadSettings.
    """
    __slots__ = ('photo_size_max', 'video_size_max', 'file_size_max', 'video_upload_maxbitrate', 'disabled', 'video_preload_large', 'audio_preload_next', 'phonecalls_less_data',)
    CONSTRUCTOR_ID = 0xe04232f3
    SUBCLASS_OF_ID = 0x512819c7

    photo_size_max: int
    video_size_max: int
    file_size_max: int
    video_upload_maxbitrate: int
    disabled: Optional[bool]
    video_preload_large: Optional[bool]
    audio_preload_next: Optional[bool]
    phonecalls_less_data: Optional[bool]
    def __init__(self, photo_size_max: int, video_size_max: int, file_size_max: int, video_upload_maxbitrate: int, disabled: Optional[bool]=None, video_preload_large: Optional[bool]=None, audio_preload_next: Optional[bool]=None, phonecalls_less_data: Optional[bool]=None):
        object.__setattr__(self, 'photo_size_max', photo_size_max)
        object.__setattr__(self, 'video_size_max', video_size_max)
        object.__setattr__(self, 'file_size_max', file_size_max)
        object.__setattr__(self, 'video_upload_maxbitrate', video_upload_maxbitrate)
        object.__setattr__(self, 'disabled', disabled)
        object.__setattr__(self, 'video_preload_large', video_preload_large)
        object.__setattr__(self, 'audio_preload_next', audio_preload_next)
        object.__setattr__(self, 'phonecalls_less_data', phonecalls_less_data)

    def _bytes(self):
        return b''.join((
            b'\xf32B\xe0',
            struct.pack('<I', (0 if self.disabled is None or self.disabled is False else 1) | (0 if self.video_preload_large is None or self.video_preload_large is False else 2) | (0 if self.audio_preload_next is None or self.audio_preload_next is False else 4) | (0 if self.phonecalls_less_data is None or self.phonecalls_less_data is False else 8)),
            struct.pack('<i', self.photo_size_max),
            struct.pack('<i', self.video_size_max),
            struct.pack('<i', self.file_size_max),
            struct.pack('<i', self.video_upload_maxbitrate),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _disabled = bool(flags & 1)
        _video_preload_large = bool(flags & 2)
        _audio_preload_next = bool(flags & 4)
        _phonecalls_less_data = bool(flags & 8)
        _photo_size_max = reader.read_int()
        _video_size_max = reader.read_int()
        _file_size_max = reader.read_int()
        _video_upload_maxbitrate = reader.read_int()
        return cls(photo_size_max=_photo_size_max, video_size_max=_video_size_max, file_size_max=_file_size_max, video_upload_maxbitrate=_video_upload_maxbitrate, disabled=_disabled, video_preload_large=_video_preload_large, audio_preload_next=_audio_preload_next, phonecalls_less_data=_phonecalls_less_data)


@dataclasses.dataclass(init=False, frozen=True)
class AvailableReaction(TLObject):
    """
    Constructor for AvailableReaction: Instance of AvailableReaction.
    """
    __slots__ = ('reaction', 'title', 'static_icon', 'appear_animation', 'select_animation', 'activate_animation', 'effect_animation', 'inactive', 'around_animation', 'center_icon',)
    CONSTRUCTOR_ID = 0xc077ec01
    SUBCLASS_OF_ID = 0x8c1c9d73

    reaction: str
    title: str
    static_icon: 'TypeDocument'
    appear_animation: 'TypeDocument'
    select_animation: 'TypeDocument'
    activate_animation: 'TypeDocument'
    effect_animation: 'TypeDocument'
    inactive: Optional[bool]
    around_animation: Optional['TypeDocument']
    center_icon: Optional['TypeDocument']
    def __init__(self, reaction: str, title: str, static_icon: 'TypeDocument', appear_animation: 'TypeDocument', select_animation: 'TypeDocument', activate_animation: 'TypeDocument', effect_animation: 'TypeDocument', inactive: Optional[bool]=None, around_animation: Optional['TypeDocument']=None, center_icon: Optional['TypeDocument']=None):
        object.__setattr__(self, 'reaction', reaction)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'static_icon', static_icon)
        object.__setattr__(self, 'appear_animation', appear_animation)
        object.__setattr__(self, 'select_animation', select_animation)
        object.__setattr__(self, 'activate_animation', activate_animation)
        object.__setattr__(self, 'effect_animation', effect_animation)
        object.__setattr__(self, 'inactive', inactive)
        object.__setattr__(self, 'around_animation', around_animation)
        object.__setattr__(self, 'center_icon', center_icon)

    def _bytes(self):
        assert ((self.around_animation or self.around_animation is not None) and (self.center_icon or self.center_icon is not None)) or ((self.around_animation is None or self.around_animation is False) and (self.center_icon is None or self.center_icon is False)), 'around_animation, center_icon parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\x01\xecw\xc0',
            struct.pack('<I', (0 if self.inactive is None or self.inactive is False else 1) | (0 if self.around_animation is None or self.around_animation is False else 2) | (0 if self.center_icon is None or self.center_icon is False else 2)),
            self._serialize_bytes(self.reaction),
            self._serialize_bytes(self.title),
            self.static_icon._bytes(),
            self.appear_animation._bytes(),
            self.select_animation._bytes(),
            self.activate_animation._bytes(),
            self.effect_animation._bytes(),
            b'' if self.around_animation is None or self.around_animation is False else (self.around_animation._bytes()),
            b'' if self.center_icon is None or self.center_icon is False else (self.center_icon._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _inactive = bool(flags & 1)
        _reaction = reader.tgread_string()
        _title = reader.tgread_string()
        _static_icon = reader.tgread_object()
        _appear_animation = reader.tgread_object()
        _select_animation = reader.tgread_object()
        _activate_animation = reader.tgread_object()
        _effect_animation = reader.tgread_object()
        if flags & 2:
            _around_animation = reader.tgread_object()
        else:
            _around_animation = None
        if flags & 2:
            _center_icon = reader.tgread_object()
        else:
            _center_icon = None
        return cls(reaction=_reaction, title=_title, static_icon=_static_icon, appear_animation=_appear_animation, select_animation=_select_animation, activate_animation=_activate_animation, effect_animation=_effect_animation, inactive=_inactive, around_animation=_around_animation, center_icon=_center_icon)


@dataclasses.dataclass(init=False, frozen=True)
class BadMsgNotification(TLObject):
    """
    Constructor for BadMsgNotification: Instance of either BadMsgNotification, BadServerSalt.
    """
    __slots__ = ('bad_msg_id', 'bad_msg_seqno', 'error_code',)
    CONSTRUCTOR_ID = 0xa7eff811
    SUBCLASS_OF_ID = 0xcebaa157

    bad_msg_id: int
    bad_msg_seqno: int
    error_code: int
    def __init__(self, bad_msg_id: int, bad_msg_seqno: int, error_code: int):
        object.__setattr__(self, 'bad_msg_id', bad_msg_id)
        object.__setattr__(self, 'bad_msg_seqno', bad_msg_seqno)
        object.__setattr__(self, 'error_code', error_code)

    def _bytes(self):
        return b''.join((
            b'\x11\xf8\xef\xa7',
            struct.pack('<q', self.bad_msg_id),
            struct.pack('<i', self.bad_msg_seqno),
            struct.pack('<i', self.error_code),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _bad_msg_id = reader.read_long()
        _bad_msg_seqno = reader.read_int()
        _error_code = reader.read_int()
        return cls(bad_msg_id=_bad_msg_id, bad_msg_seqno=_bad_msg_seqno, error_code=_error_code)


@dataclasses.dataclass(init=False, frozen=True)
class BadServerSalt(TLObject):
    """
    Constructor for BadMsgNotification: Instance of either BadMsgNotification, BadServerSalt.
    """
    __slots__ = ('bad_msg_id', 'bad_msg_seqno', 'error_code', 'new_server_salt',)
    CONSTRUCTOR_ID = 0xedab447b
    SUBCLASS_OF_ID = 0xcebaa157

    bad_msg_id: int
    bad_msg_seqno: int
    error_code: int
    new_server_salt: int
    def __init__(self, bad_msg_id: int, bad_msg_seqno: int, error_code: int, new_server_salt: int):
        object.__setattr__(self, 'bad_msg_id', bad_msg_id)
        object.__setattr__(self, 'bad_msg_seqno', bad_msg_seqno)
        object.__setattr__(self, 'error_code', error_code)
        object.__setattr__(self, 'new_server_salt', new_server_salt)

    def _bytes(self):
        return b''.join((
            b'{D\xab\xed',
            struct.pack('<q', self.bad_msg_id),
            struct.pack('<i', self.bad_msg_seqno),
            struct.pack('<i', self.error_code),
            struct.pack('<q', self.new_server_salt),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _bad_msg_id = reader.read_long()
        _bad_msg_seqno = reader.read_int()
        _error_code = reader.read_int()
        _new_server_salt = reader.read_long()
        return cls(bad_msg_id=_bad_msg_id, bad_msg_seqno=_bad_msg_seqno, error_code=_error_code, new_server_salt=_new_server_salt)


@dataclasses.dataclass(init=False, frozen=True)
class BankCardOpenUrl(TLObject):
    """
    Constructor for BankCardOpenUrl: Instance of BankCardOpenUrl.
    """
    __slots__ = ('url', 'name',)
    CONSTRUCTOR_ID = 0xf568028a
    SUBCLASS_OF_ID = 0xf2e2460e

    url: str
    name: str
    def __init__(self, url: str, name: str):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'name', name)

    def _bytes(self):
        return b''.join((
            b'\x8a\x02h\xf5',
            self._serialize_bytes(self.url),
            self._serialize_bytes(self.name),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _url = reader.tgread_string()
        _name = reader.tgread_string()
        return cls(url=_url, name=_name)


@dataclasses.dataclass(init=False, frozen=True)
class BaseThemeArctic(TLObject):
    """
    Constructor for BaseTheme: Instance of either BaseThemeClassic, BaseThemeDay, BaseThemeNight, BaseThemeTinted, BaseThemeArctic.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x5b11125a
    SUBCLASS_OF_ID = 0x1f03f444

    def _bytes(self):
        return b''.join((
            b'Z\x12\x11[',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class BaseThemeClassic(TLObject):
    """
    Constructor for BaseTheme: Instance of either BaseThemeClassic, BaseThemeDay, BaseThemeNight, BaseThemeTinted, BaseThemeArctic.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xc3a12462
    SUBCLASS_OF_ID = 0x1f03f444

    def _bytes(self):
        return b''.join((
            b'b$\xa1\xc3',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class BaseThemeDay(TLObject):
    """
    Constructor for BaseTheme: Instance of either BaseThemeClassic, BaseThemeDay, BaseThemeNight, BaseThemeTinted, BaseThemeArctic.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xfbd81688
    SUBCLASS_OF_ID = 0x1f03f444

    def _bytes(self):
        return b''.join((
            b'\x88\x16\xd8\xfb',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class BaseThemeNight(TLObject):
    """
    Constructor for BaseTheme: Instance of either BaseThemeClassic, BaseThemeDay, BaseThemeNight, BaseThemeTinted, BaseThemeArctic.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb7b31ea8
    SUBCLASS_OF_ID = 0x1f03f444

    def _bytes(self):
        return b''.join((
            b'\xa8\x1e\xb3\xb7',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class BaseThemeTinted(TLObject):
    """
    Constructor for BaseTheme: Instance of either BaseThemeClassic, BaseThemeDay, BaseThemeNight, BaseThemeTinted, BaseThemeArctic.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x6d5f77ee
    SUBCLASS_OF_ID = 0x1f03f444

    def _bytes(self):
        return b''.join((
            b'\xeew_m',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class BindAuthKeyInner(TLObject):
    """
    Constructor for BindAuthKeyInner: Instance of BindAuthKeyInner.
    """
    __slots__ = ('nonce', 'temp_auth_key_id', 'perm_auth_key_id', 'temp_session_id', 'expires_at',)
    CONSTRUCTOR_ID = 0x75a3f765
    SUBCLASS_OF_ID = 0x2f099171

    nonce: int
    temp_auth_key_id: int
    perm_auth_key_id: int
    temp_session_id: int
    expires_at: Optional[datetime]
    def __init__(self, nonce: int, temp_auth_key_id: int, perm_auth_key_id: int, temp_session_id: int, expires_at: Optional[datetime]):
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'temp_auth_key_id', temp_auth_key_id)
        object.__setattr__(self, 'perm_auth_key_id', perm_auth_key_id)
        object.__setattr__(self, 'temp_session_id', temp_session_id)
        object.__setattr__(self, 'expires_at', expires_at)

    def _bytes(self):
        return b''.join((
            b'e\xf7\xa3u',
            struct.pack('<q', self.nonce),
            struct.pack('<q', self.temp_auth_key_id),
            struct.pack('<q', self.perm_auth_key_id),
            struct.pack('<q', self.temp_session_id),
            self._serialize_datetime(self.expires_at),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _nonce = reader.read_long()
        _temp_auth_key_id = reader.read_long()
        _perm_auth_key_id = reader.read_long()
        _temp_session_id = reader.read_long()
        _expires_at = reader.tgread_date()
        return cls(nonce=_nonce, temp_auth_key_id=_temp_auth_key_id, perm_auth_key_id=_perm_auth_key_id, temp_session_id=_temp_session_id, expires_at=_expires_at)


@dataclasses.dataclass(init=False, frozen=True)
class BotCommand(TLObject):
    """
    Constructor for BotCommand: Instance of BotCommand.
    """
    __slots__ = ('command', 'description',)
    CONSTRUCTOR_ID = 0xc27ac8c7
    SUBCLASS_OF_ID = 0xe1e62c2

    command: str
    description: str
    def __init__(self, command: str, description: str):
        object.__setattr__(self, 'command', command)
        object.__setattr__(self, 'description', description)

    def _bytes(self):
        return b''.join((
            b'\xc7\xc8z\xc2',
            self._serialize_bytes(self.command),
            self._serialize_bytes(self.description),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _command = reader.tgread_string()
        _description = reader.tgread_string()
        return cls(command=_command, description=_description)


@dataclasses.dataclass(init=False, frozen=True)
class BotCommandScopeChatAdmins(TLObject):
    """
    Constructor for BotCommandScope: Instance of either BotCommandScopeDefault, BotCommandScopeUsers, BotCommandScopeChats, BotCommandScopeChatAdmins, BotCommandScopePeer, BotCommandScopePeerAdmins, BotCommandScopePeerUser.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb9aa606a
    SUBCLASS_OF_ID = 0x4baf5d10

    def _bytes(self):
        return b''.join((
            b'j`\xaa\xb9',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class BotCommandScopeChats(TLObject):
    """
    Constructor for BotCommandScope: Instance of either BotCommandScopeDefault, BotCommandScopeUsers, BotCommandScopeChats, BotCommandScopeChatAdmins, BotCommandScopePeer, BotCommandScopePeerAdmins, BotCommandScopePeerUser.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x6fe1a881
    SUBCLASS_OF_ID = 0x4baf5d10

    def _bytes(self):
        return b''.join((
            b'\x81\xa8\xe1o',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class BotCommandScopeDefault(TLObject):
    """
    Constructor for BotCommandScope: Instance of either BotCommandScopeDefault, BotCommandScopeUsers, BotCommandScopeChats, BotCommandScopeChatAdmins, BotCommandScopePeer, BotCommandScopePeerAdmins, BotCommandScopePeerUser.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x2f6cb2ab
    SUBCLASS_OF_ID = 0x4baf5d10

    def _bytes(self):
        return b''.join((
            b'\xab\xb2l/',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class BotCommandScopePeer(TLObject):
    """
    Constructor for BotCommandScope: Instance of either BotCommandScopeDefault, BotCommandScopeUsers, BotCommandScopeChats, BotCommandScopeChatAdmins, BotCommandScopePeer, BotCommandScopePeerAdmins, BotCommandScopePeerUser.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0xdb9d897d
    SUBCLASS_OF_ID = 0x4baf5d10

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    def _bytes(self):
        return b''.join((
            b'}\x89\x9d\xdb',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class BotCommandScopePeerAdmins(TLObject):
    """
    Constructor for BotCommandScope: Instance of either BotCommandScopeDefault, BotCommandScopeUsers, BotCommandScopeChats, BotCommandScopeChatAdmins, BotCommandScopePeer, BotCommandScopePeerAdmins, BotCommandScopePeerUser.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0x3fd863d1
    SUBCLASS_OF_ID = 0x4baf5d10

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    def _bytes(self):
        return b''.join((
            b'\xd1c\xd8?',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class BotCommandScopePeerUser(TLObject):
    """
    Constructor for BotCommandScope: Instance of either BotCommandScopeDefault, BotCommandScopeUsers, BotCommandScopeChats, BotCommandScopeChatAdmins, BotCommandScopePeer, BotCommandScopePeerAdmins, BotCommandScopePeerUser.
    """
    __slots__ = ('peer', 'user_id',)
    CONSTRUCTOR_ID = 0xa1321f3
    SUBCLASS_OF_ID = 0x4baf5d10

    peer: 'TypeInputPeer'
    user_id: 'TypeInputUser'
    def __init__(self, peer: 'TypeInputPeer', user_id: 'TypeInputUser'):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'user_id', user_id)

    def _bytes(self):
        return b''.join((
            b'\xf3!\x13\n',
            self.peer._bytes(),
            self.user_id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _user_id = reader.tgread_object()
        return cls(peer=_peer, user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class BotCommandScopeUsers(TLObject):
    """
    Constructor for BotCommandScope: Instance of either BotCommandScopeDefault, BotCommandScopeUsers, BotCommandScopeChats, BotCommandScopeChatAdmins, BotCommandScopePeer, BotCommandScopePeerAdmins, BotCommandScopePeerUser.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x3c4f04d8
    SUBCLASS_OF_ID = 0x4baf5d10

    def _bytes(self):
        return b''.join((
            b'\xd8\x04O<',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class BotInfo(TLObject):
    """
    Constructor for BotInfo: Instance of BotInfo.
    """
    __slots__ = ('user_id', 'description', 'commands',)
    CONSTRUCTOR_ID = 0x1b74b335
    SUBCLASS_OF_ID = 0xf1f701db

    user_id: int
    description: str
    commands: List['TypeBotCommand']
    def __init__(self, user_id: int, description: str, commands: List['TypeBotCommand']):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'description', description)
        object.__setattr__(self, 'commands', commands)

    def _bytes(self):
        return b''.join((
            b'5\xb3t\x1b',
            struct.pack('<q', self.user_id),
            self._serialize_bytes(self.description),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.commands)),b''.join(x._bytes() for x in self.commands),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _description = reader.tgread_string()
        reader.read_int()
        _commands = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _commands.append(_x)

        return cls(user_id=_user_id, description=_description, commands=_commands)


@dataclasses.dataclass(init=False, frozen=True)
class BotInlineMediaResult(TLObject):
    """
    Constructor for BotInlineResult: Instance of either BotInlineResult, BotInlineMediaResult.
    """
    __slots__ = ('id', 'type', 'send_message', 'photo', 'document', 'title', 'description',)
    CONSTRUCTOR_ID = 0x17db940b
    SUBCLASS_OF_ID = 0x3832b3d5

    id: str
    type: str
    send_message: 'TypeBotInlineMessage'
    photo: Optional['TypePhoto']
    document: Optional['TypeDocument']
    title: Optional[str]
    description: Optional[str]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, send_message: 'TypeBotInlineMessage', photo: Optional['TypePhoto']=None, document: Optional['TypeDocument']=None, title: Optional[str]=None, description: Optional[str]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'send_message', send_message)
        object.__setattr__(self, 'photo', photo)
        object.__setattr__(self, 'document', document)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'description', description)

    def _bytes(self):
        return b''.join((
            b'\x0b\x94\xdb\x17',
            struct.pack('<I', (0 if self.photo is None or self.photo is False else 1) | (0 if self.document is None or self.document is False else 2) | (0 if self.title is None or self.title is False else 4) | (0 if self.description is None or self.description is False else 8)),
            self._serialize_bytes(self.id),
            self._serialize_bytes(self.type),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self._serialize_bytes(self.description)),
            self.send_message._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_string()
        _type = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        if flags & 2:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 4:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 8:
            _description = reader.tgread_string()
        else:
            _description = None
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, send_message=_send_message, photo=_photo, document=_document, title=_title, description=_description)


@dataclasses.dataclass(init=False, frozen=True)
class BotInlineMessageMediaAuto(TLObject):
    """
    Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice.
    """
    __slots__ = ('message', 'entities', 'reply_markup',)
    CONSTRUCTOR_ID = 0x764cf810
    SUBCLASS_OF_ID = 0xc4910f88

    message: str
    entities: Optional[List['TypeMessageEntity']]
    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, message: str, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'entities', entities)
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'\x10\xf8Lv',
            struct.pack('<I', (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self._serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, entities=_entities, reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class BotInlineMessageMediaContact(TLObject):
    """
    Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice.
    """
    __slots__ = ('phone_number', 'first_name', 'last_name', 'vcard', 'reply_markup',)
    CONSTRUCTOR_ID = 0x18d1cdc2
    SUBCLASS_OF_ID = 0xc4910f88

    phone_number: str
    first_name: str
    last_name: str
    vcard: str
    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, phone_number: str, first_name: str, last_name: str, vcard: str, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'first_name', first_name)
        object.__setattr__(self, 'last_name', last_name)
        object.__setattr__(self, 'vcard', vcard)
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'\xc2\xcd\xd1\x18',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self._serialize_bytes(self.phone_number),
            self._serialize_bytes(self.first_name),
            self._serialize_bytes(self.last_name),
            self._serialize_bytes(self.vcard),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _phone_number = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _vcard = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(phone_number=_phone_number, first_name=_first_name, last_name=_last_name, vcard=_vcard, reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class BotInlineMessageMediaGeo(TLObject):
    """
    Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice.
    """
    __slots__ = ('geo', 'heading', 'period', 'proximity_notification_radius', 'reply_markup',)
    CONSTRUCTOR_ID = 0x51846fd
    SUBCLASS_OF_ID = 0xc4910f88

    geo: 'TypeGeoPoint'
    heading: Optional[int]
    period: Optional[int]
    proximity_notification_radius: Optional[int]
    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, geo: 'TypeGeoPoint', heading: Optional[int]=None, period: Optional[int]=None, proximity_notification_radius: Optional[int]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'geo', geo)
        object.__setattr__(self, 'heading', heading)
        object.__setattr__(self, 'period', period)
        object.__setattr__(self, 'proximity_notification_radius', proximity_notification_radius)
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'\xfdF\x18\x05',
            struct.pack('<I', (0 if self.heading is None or self.heading is False else 1) | (0 if self.period is None or self.period is False else 2) | (0 if self.proximity_notification_radius is None or self.proximity_notification_radius is False else 8) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.geo._bytes(),
            b'' if self.heading is None or self.heading is False else (struct.pack('<i', self.heading)),
            b'' if self.period is None or self.period is False else (struct.pack('<i', self.period)),
            b'' if self.proximity_notification_radius is None or self.proximity_notification_radius is False else (struct.pack('<i', self.proximity_notification_radius)),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _geo = reader.tgread_object()
        if flags & 1:
            _heading = reader.read_int()
        else:
            _heading = None
        if flags & 2:
            _period = reader.read_int()
        else:
            _period = None
        if flags & 8:
            _proximity_notification_radius = reader.read_int()
        else:
            _proximity_notification_radius = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(geo=_geo, heading=_heading, period=_period, proximity_notification_radius=_proximity_notification_radius, reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class BotInlineMessageMediaInvoice(TLObject):
    """
    Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice.
    """
    __slots__ = ('title', 'description', 'currency', 'total_amount', 'shipping_address_requested', 'test', 'photo', 'reply_markup',)
    CONSTRUCTOR_ID = 0x354a9b09
    SUBCLASS_OF_ID = 0xc4910f88

    title: str
    description: str
    currency: str
    total_amount: int
    shipping_address_requested: Optional[bool]
    test: Optional[bool]
    photo: Optional['TypeWebDocument']
    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, title: str, description: str, currency: str, total_amount: int, shipping_address_requested: Optional[bool]=None, test: Optional[bool]=None, photo: Optional['TypeWebDocument']=None, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'description', description)
        object.__setattr__(self, 'currency', currency)
        object.__setattr__(self, 'total_amount', total_amount)
        object.__setattr__(self, 'shipping_address_requested', shipping_address_requested)
        object.__setattr__(self, 'test', test)
        object.__setattr__(self, 'photo', photo)
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'\t\x9bJ5',
            struct.pack('<I', (0 if self.shipping_address_requested is None or self.shipping_address_requested is False else 2) | (0 if self.test is None or self.test is False else 8) | (0 if self.photo is None or self.photo is False else 1) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self._serialize_bytes(self.title),
            self._serialize_bytes(self.description),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
            self._serialize_bytes(self.currency),
            struct.pack('<q', self.total_amount),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _shipping_address_requested = bool(flags & 2)
        _test = bool(flags & 8)
        _title = reader.tgread_string()
        _description = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        _currency = reader.tgread_string()
        _total_amount = reader.read_long()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(title=_title, description=_description, currency=_currency, total_amount=_total_amount, shipping_address_requested=_shipping_address_requested, test=_test, photo=_photo, reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class BotInlineMessageMediaVenue(TLObject):
    """
    Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice.
    """
    __slots__ = ('geo', 'title', 'address', 'provider', 'venue_id', 'venue_type', 'reply_markup',)
    CONSTRUCTOR_ID = 0x8a86659c
    SUBCLASS_OF_ID = 0xc4910f88

    geo: 'TypeGeoPoint'
    title: str
    address: str
    provider: str
    venue_id: str
    venue_type: str
    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, geo: 'TypeGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'geo', geo)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'address', address)
        object.__setattr__(self, 'provider', provider)
        object.__setattr__(self, 'venue_id', venue_id)
        object.__setattr__(self, 'venue_type', venue_type)
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'\x9ce\x86\x8a',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.geo._bytes(),
            self._serialize_bytes(self.title),
            self._serialize_bytes(self.address),
            self._serialize_bytes(self.provider),
            self._serialize_bytes(self.venue_id),
            self._serialize_bytes(self.venue_type),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _geo = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(geo=_geo, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type, reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class BotInlineMessageText(TLObject):
    """
    Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice.
    """
    __slots__ = ('message', 'no_webpage', 'entities', 'reply_markup',)
    CONSTRUCTOR_ID = 0x8c7f65e2
    SUBCLASS_OF_ID = 0xc4910f88

    message: str
    no_webpage: Optional[bool]
    entities: Optional[List['TypeMessageEntity']]
    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, message: str, no_webpage: Optional[bool]=None, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'no_webpage', no_webpage)
        object.__setattr__(self, 'entities', entities)
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'\xe2e\x7f\x8c',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 1) | (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self._serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 1)
        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, no_webpage=_no_webpage, entities=_entities, reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class BotInlineResult(TLObject):
    """
    Constructor for BotInlineResult: Instance of either BotInlineResult, BotInlineMediaResult.
    """
    __slots__ = ('id', 'type', 'send_message', 'title', 'description', 'url', 'thumb', 'content',)
    CONSTRUCTOR_ID = 0x11965f3a
    SUBCLASS_OF_ID = 0x3832b3d5

    id: str
    type: str
    send_message: 'TypeBotInlineMessage'
    title: Optional[str]
    description: Optional[str]
    url: Optional[str]
    thumb: Optional['TypeWebDocument']
    content: Optional['TypeWebDocument']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, send_message: 'TypeBotInlineMessage', title: Optional[str]=None, description: Optional[str]=None, url: Optional[str]=None, thumb: Optional['TypeWebDocument']=None, content: Optional['TypeWebDocument']=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'send_message', send_message)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'description', description)
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'thumb', thumb)
        object.__setattr__(self, 'content', content)

    def _bytes(self):
        return b''.join((
            b':_\x96\x11',
            struct.pack('<I', (0 if self.title is None or self.title is False else 2) | (0 if self.description is None or self.description is False else 4) | (0 if self.url is None or self.url is False else 8) | (0 if self.thumb is None or self.thumb is False else 16) | (0 if self.content is None or self.content is False else 32)),
            self._serialize_bytes(self.id),
            self._serialize_bytes(self.type),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self._serialize_bytes(self.description)),
            b'' if self.url is None or self.url is False else (self._serialize_bytes(self.url)),
            b'' if self.thumb is None or self.thumb is False else (self.thumb._bytes()),
            b'' if self.content is None or self.content is False else (self.content._bytes()),
            self.send_message._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_string()
        _type = reader.tgread_string()
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 4:
            _description = reader.tgread_string()
        else:
            _description = None
        if flags & 8:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 16:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        if flags & 32:
            _content = reader.tgread_object()
        else:
            _content = None
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, send_message=_send_message, title=_title, description=_description, url=_url, thumb=_thumb, content=_content)


@dataclasses.dataclass(init=False, frozen=True)
class CdnConfig(TLObject):
    """
    Constructor for CdnConfig: Instance of CdnConfig.
    """
    __slots__ = ('public_keys',)
    CONSTRUCTOR_ID = 0x5725e40a
    SUBCLASS_OF_ID = 0xecda397c

    public_keys: List['TypeCdnPublicKey']
    def __init__(self, public_keys: List['TypeCdnPublicKey']):
        object.__setattr__(self, 'public_keys', public_keys)

    def _bytes(self):
        return b''.join((
            b'\n\xe4%W',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.public_keys)),b''.join(x._bytes() for x in self.public_keys),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _public_keys = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _public_keys.append(_x)

        return cls(public_keys=_public_keys)


@dataclasses.dataclass(init=False, frozen=True)
class CdnPublicKey(TLObject):
    """
    Constructor for CdnPublicKey: Instance of CdnPublicKey.
    """
    __slots__ = ('dc_id', 'public_key',)
    CONSTRUCTOR_ID = 0xc982eaba
    SUBCLASS_OF_ID = 0x16db47f3

    dc_id: int
    public_key: str
    def __init__(self, dc_id: int, public_key: str):
        object.__setattr__(self, 'dc_id', dc_id)
        object.__setattr__(self, 'public_key', public_key)

    def _bytes(self):
        return b''.join((
            b'\xba\xea\x82\xc9',
            struct.pack('<i', self.dc_id),
            self._serialize_bytes(self.public_key),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _dc_id = reader.read_int()
        _public_key = reader.tgread_string()
        return cls(dc_id=_dc_id, public_key=_public_key)


@dataclasses.dataclass(init=False, frozen=True)
class Channel(TLObject):
    """
    Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
    """
    __slots__ = ('id', 'title', 'photo', 'date', 'creator', 'left', 'broadcast', 'verified', 'megagroup', 'restricted', 'signatures', 'min', 'scam', 'has_link', 'has_geo', 'slowmode_enabled', 'call_active', 'call_not_empty', 'fake', 'gigagroup', 'noforwards', 'access_hash', 'username', 'restriction_reason', 'admin_rights', 'banned_rights', 'default_banned_rights', 'participants_count',)
    CONSTRUCTOR_ID = 0x8261ac61
    SUBCLASS_OF_ID = 0xc5af5d94

    id: int
    title: str
    photo: 'TypeChatPhoto'
    date: Optional[datetime]
    creator: Optional[bool]
    left: Optional[bool]
    broadcast: Optional[bool]
    verified: Optional[bool]
    megagroup: Optional[bool]
    restricted: Optional[bool]
    signatures: Optional[bool]
    min: Optional[bool]
    scam: Optional[bool]
    has_link: Optional[bool]
    has_geo: Optional[bool]
    slowmode_enabled: Optional[bool]
    call_active: Optional[bool]
    call_not_empty: Optional[bool]
    fake: Optional[bool]
    gigagroup: Optional[bool]
    noforwards: Optional[bool]
    access_hash: Optional[int]
    username: Optional[str]
    restriction_reason: Optional[List['TypeRestrictionReason']]
    admin_rights: Optional['TypeChatAdminRights']
    banned_rights: Optional['TypeChatBannedRights']
    default_banned_rights: Optional['TypeChatBannedRights']
    participants_count: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str, photo: 'TypeChatPhoto', date: Optional[datetime], creator: Optional[bool]=None, left: Optional[bool]=None, broadcast: Optional[bool]=None, verified: Optional[bool]=None, megagroup: Optional[bool]=None, restricted: Optional[bool]=None, signatures: Optional[bool]=None, min: Optional[bool]=None, scam: Optional[bool]=None, has_link: Optional[bool]=None, has_geo: Optional[bool]=None, slowmode_enabled: Optional[bool]=None, call_active: Optional[bool]=None, call_not_empty: Optional[bool]=None, fake: Optional[bool]=None, gigagroup: Optional[bool]=None, noforwards: Optional[bool]=None, access_hash: Optional[int]=None, username: Optional[str]=None, restriction_reason: Optional[List['TypeRestrictionReason']]=None, admin_rights: Optional['TypeChatAdminRights']=None, banned_rights: Optional['TypeChatBannedRights']=None, default_banned_rights: Optional['TypeChatBannedRights']=None, participants_count: Optional[int]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'photo', photo)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'creator', creator)
        object.__setattr__(self, 'left', left)
        object.__setattr__(self, 'broadcast', broadcast)
        object.__setattr__(self, 'verified', verified)
        object.__setattr__(self, 'megagroup', megagroup)
        object.__setattr__(self, 'restricted', restricted)
        object.__setattr__(self, 'signatures', signatures)
        object.__setattr__(self, 'min', min)
        object.__setattr__(self, 'scam', scam)
        object.__setattr__(self, 'has_link', has_link)
        object.__setattr__(self, 'has_geo', has_geo)
        object.__setattr__(self, 'slowmode_enabled', slowmode_enabled)
        object.__setattr__(self, 'call_active', call_active)
        object.__setattr__(self, 'call_not_empty', call_not_empty)
        object.__setattr__(self, 'fake', fake)
        object.__setattr__(self, 'gigagroup', gigagroup)
        object.__setattr__(self, 'noforwards', noforwards)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'username', username)
        object.__setattr__(self, 'restriction_reason', restriction_reason)
        object.__setattr__(self, 'admin_rights', admin_rights)
        object.__setattr__(self, 'banned_rights', banned_rights)
        object.__setattr__(self, 'default_banned_rights', default_banned_rights)
        object.__setattr__(self, 'participants_count', participants_count)

    def _bytes(self):
        assert ((self.restricted or self.restricted is not None) and (self.restriction_reason or self.restriction_reason is not None)) or ((self.restricted is None or self.restricted is False) and (self.restriction_reason is None or self.restriction_reason is False)), 'restricted, restriction_reason parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'a\xaca\x82',
            struct.pack('<I', (0 if self.creator is None or self.creator is False else 1) | (0 if self.left is None or self.left is False else 4) | (0 if self.broadcast is None or self.broadcast is False else 32) | (0 if self.verified is None or self.verified is False else 128) | (0 if self.megagroup is None or self.megagroup is False else 256) | (0 if self.restricted is None or self.restricted is False else 512) | (0 if self.signatures is None or self.signatures is False else 2048) | (0 if self.min is None or self.min is False else 4096) | (0 if self.scam is None or self.scam is False else 524288) | (0 if self.has_link is None or self.has_link is False else 1048576) | (0 if self.has_geo is None or self.has_geo is False else 2097152) | (0 if self.slowmode_enabled is None or self.slowmode_enabled is False else 4194304) | (0 if self.call_active is None or self.call_active is False else 8388608) | (0 if self.call_not_empty is None or self.call_not_empty is False else 16777216) | (0 if self.fake is None or self.fake is False else 33554432) | (0 if self.gigagroup is None or self.gigagroup is False else 67108864) | (0 if self.noforwards is None or self.noforwards is False else 134217728) | (0 if self.access_hash is None or self.access_hash is False else 8192) | (0 if self.username is None or self.username is False else 64) | (0 if self.restriction_reason is None or self.restriction_reason is False else 512) | (0 if self.admin_rights is None or self.admin_rights is False else 16384) | (0 if self.banned_rights is None or self.banned_rights is False else 32768) | (0 if self.default_banned_rights is None or self.default_banned_rights is False else 262144) | (0 if self.participants_count is None or self.participants_count is False else 131072)),
            struct.pack('<q', self.id),
            b'' if self.access_hash is None or self.access_hash is False else (struct.pack('<q', self.access_hash)),
            self._serialize_bytes(self.title),
            b'' if self.username is None or self.username is False else (self._serialize_bytes(self.username)),
            self.photo._bytes(),
            self._serialize_datetime(self.date),
            b'' if self.restriction_reason is None or self.restriction_reason is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.restriction_reason)),b''.join(x._bytes() for x in self.restriction_reason))),
            b'' if self.admin_rights is None or self.admin_rights is False else (self.admin_rights._bytes()),
            b'' if self.banned_rights is None or self.banned_rights is False else (self.banned_rights._bytes()),
            b'' if self.default_banned_rights is None or self.default_banned_rights is False else (self.default_banned_rights._bytes()),
            b'' if self.participants_count is None or self.participants_count is False else (struct.pack('<i', self.participants_count)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _creator = bool(flags & 1)
        _left = bool(flags & 4)
        _broadcast = bool(flags & 32)
        _verified = bool(flags & 128)
        _megagroup = bool(flags & 256)
        _restricted = bool(flags & 512)
        _signatures = bool(flags & 2048)
        _min = bool(flags & 4096)
        _scam = bool(flags & 524288)
        _has_link = bool(flags & 1048576)
        _has_geo = bool(flags & 2097152)
        _slowmode_enabled = bool(flags & 4194304)
        _call_active = bool(flags & 8388608)
        _call_not_empty = bool(flags & 16777216)
        _fake = bool(flags & 33554432)
        _gigagroup = bool(flags & 67108864)
        _noforwards = bool(flags & 134217728)
        _id = reader.read_long()
        if flags & 8192:
            _access_hash = reader.read_long()
        else:
            _access_hash = None
        _title = reader.tgread_string()
        if flags & 64:
            _username = reader.tgread_string()
        else:
            _username = None
        _photo = reader.tgread_object()
        _date = reader.tgread_date()
        if flags & 512:
            reader.read_int()
            _restriction_reason = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _restriction_reason.append(_x)

        else:
            _restriction_reason = None
        if flags & 16384:
            _admin_rights = reader.tgread_object()
        else:
            _admin_rights = None
        if flags & 32768:
            _banned_rights = reader.tgread_object()
        else:
            _banned_rights = None
        if flags & 262144:
            _default_banned_rights = reader.tgread_object()
        else:
            _default_banned_rights = None
        if flags & 131072:
            _participants_count = reader.read_int()
        else:
            _participants_count = None
        return cls(id=_id, title=_title, photo=_photo, date=_date, creator=_creator, left=_left, broadcast=_broadcast, verified=_verified, megagroup=_megagroup, restricted=_restricted, signatures=_signatures, min=_min, scam=_scam, has_link=_has_link, has_geo=_has_geo, slowmode_enabled=_slowmode_enabled, call_active=_call_active, call_not_empty=_call_not_empty, fake=_fake, gigagroup=_gigagroup, noforwards=_noforwards, access_hash=_access_hash, username=_username, restriction_reason=_restriction_reason, admin_rights=_admin_rights, banned_rights=_banned_rights, default_banned_rights=_default_banned_rights, participants_count=_participants_count)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEvent(TLObject):
    """
    Constructor for ChannelAdminLogEvent: Instance of ChannelAdminLogEvent.
    """
    __slots__ = ('id', 'date', 'user_id', 'action',)
    CONSTRUCTOR_ID = 0x1fad68cd
    SUBCLASS_OF_ID = 0x408f0999

    id: int
    date: Optional[datetime]
    user_id: int
    action: 'TypeChannelAdminLogEventAction'
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, date: Optional[datetime], user_id: int, action: 'TypeChannelAdminLogEventAction'):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'action', action)

    def _bytes(self):
        return b''.join((
            b'\xcdh\xad\x1f',
            struct.pack('<q', self.id),
            self._serialize_datetime(self.date),
            struct.pack('<q', self.user_id),
            self.action._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _date = reader.tgread_date()
        _user_id = reader.read_long()
        _action = reader.tgread_object()
        return cls(id=_id, date=_date, user_id=_user_id, action=_action)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionChangeAbout(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_value', 'new_value',)
    CONSTRUCTOR_ID = 0x55188a2e
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_value: str
    new_value: str
    def __init__(self, prev_value: str, new_value: str):
        object.__setattr__(self, 'prev_value', prev_value)
        object.__setattr__(self, 'new_value', new_value)

    def _bytes(self):
        return b''.join((
            b'.\x8a\x18U',
            self._serialize_bytes(self.prev_value),
            self._serialize_bytes(self.new_value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_value = reader.tgread_string()
        _new_value = reader.tgread_string()
        return cls(prev_value=_prev_value, new_value=_new_value)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionChangeAvailableReactions(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_value', 'new_value',)
    CONSTRUCTOR_ID = 0x9cf7f76a
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_value: List[str]
    new_value: List[str]
    def __init__(self, prev_value: List[str], new_value: List[str]):
        object.__setattr__(self, 'prev_value', prev_value)
        object.__setattr__(self, 'new_value', new_value)

    def _bytes(self):
        return b''.join((
            b'j\xf7\xf7\x9c',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.prev_value)),b''.join(self._serialize_bytes(x) for x in self.prev_value),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.new_value)),b''.join(self._serialize_bytes(x) for x in self.new_value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _prev_value = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _prev_value.append(_x)

        reader.read_int()
        _new_value = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _new_value.append(_x)

        return cls(prev_value=_prev_value, new_value=_new_value)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionChangeHistoryTTL(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_value', 'new_value',)
    CONSTRUCTOR_ID = 0x6e941a38
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_value: int
    new_value: int
    def __init__(self, prev_value: int, new_value: int):
        object.__setattr__(self, 'prev_value', prev_value)
        object.__setattr__(self, 'new_value', new_value)

    def _bytes(self):
        return b''.join((
            b'8\x1a\x94n',
            struct.pack('<i', self.prev_value),
            struct.pack('<i', self.new_value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_value = reader.read_int()
        _new_value = reader.read_int()
        return cls(prev_value=_prev_value, new_value=_new_value)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionChangeLinkedChat(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_value', 'new_value',)
    CONSTRUCTOR_ID = 0x50c7ac8
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_value: int
    new_value: int
    def __init__(self, prev_value: int, new_value: int):
        object.__setattr__(self, 'prev_value', prev_value)
        object.__setattr__(self, 'new_value', new_value)

    def _bytes(self):
        return b''.join((
            b'\xc8z\x0c\x05',
            struct.pack('<q', self.prev_value),
            struct.pack('<q', self.new_value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_value = reader.read_long()
        _new_value = reader.read_long()
        return cls(prev_value=_prev_value, new_value=_new_value)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionChangeLocation(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_value', 'new_value',)
    CONSTRUCTOR_ID = 0xe6b76ae
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_value: 'TypeChannelLocation'
    new_value: 'TypeChannelLocation'
    def __init__(self, prev_value: 'TypeChannelLocation', new_value: 'TypeChannelLocation'):
        object.__setattr__(self, 'prev_value', prev_value)
        object.__setattr__(self, 'new_value', new_value)

    def _bytes(self):
        return b''.join((
            b'\xaevk\x0e',
            self.prev_value._bytes(),
            self.new_value._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_value = reader.tgread_object()
        _new_value = reader.tgread_object()
        return cls(prev_value=_prev_value, new_value=_new_value)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionChangePhoto(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_photo', 'new_photo',)
    CONSTRUCTOR_ID = 0x434bd2af
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_photo: 'TypePhoto'
    new_photo: 'TypePhoto'
    def __init__(self, prev_photo: 'TypePhoto', new_photo: 'TypePhoto'):
        object.__setattr__(self, 'prev_photo', prev_photo)
        object.__setattr__(self, 'new_photo', new_photo)

    def _bytes(self):
        return b''.join((
            b'\xaf\xd2KC',
            self.prev_photo._bytes(),
            self.new_photo._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_photo = reader.tgread_object()
        _new_photo = reader.tgread_object()
        return cls(prev_photo=_prev_photo, new_photo=_new_photo)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionChangeStickerSet(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_stickerset', 'new_stickerset',)
    CONSTRUCTOR_ID = 0xb1c3caa7
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_stickerset: 'TypeInputStickerSet'
    new_stickerset: 'TypeInputStickerSet'
    def __init__(self, prev_stickerset: 'TypeInputStickerSet', new_stickerset: 'TypeInputStickerSet'):
        object.__setattr__(self, 'prev_stickerset', prev_stickerset)
        object.__setattr__(self, 'new_stickerset', new_stickerset)

    def _bytes(self):
        return b''.join((
            b'\xa7\xca\xc3\xb1',
            self.prev_stickerset._bytes(),
            self.new_stickerset._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_stickerset = reader.tgread_object()
        _new_stickerset = reader.tgread_object()
        return cls(prev_stickerset=_prev_stickerset, new_stickerset=_new_stickerset)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionChangeTitle(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_value', 'new_value',)
    CONSTRUCTOR_ID = 0xe6dfb825
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_value: str
    new_value: str
    def __init__(self, prev_value: str, new_value: str):
        object.__setattr__(self, 'prev_value', prev_value)
        object.__setattr__(self, 'new_value', new_value)

    def _bytes(self):
        return b''.join((
            b'%\xb8\xdf\xe6',
            self._serialize_bytes(self.prev_value),
            self._serialize_bytes(self.new_value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_value = reader.tgread_string()
        _new_value = reader.tgread_string()
        return cls(prev_value=_prev_value, new_value=_new_value)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionChangeUsername(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_value', 'new_value',)
    CONSTRUCTOR_ID = 0x6a4afc38
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_value: str
    new_value: str
    def __init__(self, prev_value: str, new_value: str):
        object.__setattr__(self, 'prev_value', prev_value)
        object.__setattr__(self, 'new_value', new_value)

    def _bytes(self):
        return b''.join((
            b'8\xfcJj',
            self._serialize_bytes(self.prev_value),
            self._serialize_bytes(self.new_value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_value = reader.tgread_string()
        _new_value = reader.tgread_string()
        return cls(prev_value=_prev_value, new_value=_new_value)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionDefaultBannedRights(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_banned_rights', 'new_banned_rights',)
    CONSTRUCTOR_ID = 0x2df5fc0a
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_banned_rights: 'TypeChatBannedRights'
    new_banned_rights: 'TypeChatBannedRights'
    def __init__(self, prev_banned_rights: 'TypeChatBannedRights', new_banned_rights: 'TypeChatBannedRights'):
        object.__setattr__(self, 'prev_banned_rights', prev_banned_rights)
        object.__setattr__(self, 'new_banned_rights', new_banned_rights)

    def _bytes(self):
        return b''.join((
            b'\n\xfc\xf5-',
            self.prev_banned_rights._bytes(),
            self.new_banned_rights._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_banned_rights = reader.tgread_object()
        _new_banned_rights = reader.tgread_object()
        return cls(prev_banned_rights=_prev_banned_rights, new_banned_rights=_new_banned_rights)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionDeleteMessage(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('message',)
    CONSTRUCTOR_ID = 0x42e047bb
    SUBCLASS_OF_ID = 0xb2b987f3

    message: 'TypeMessage'
    def __init__(self, message: 'TypeMessage'):
        object.__setattr__(self, 'message', message)

    def _bytes(self):
        return b''.join((
            b'\xbbG\xe0B',
            self.message._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _message = reader.tgread_object()
        return cls(message=_message)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionDiscardGroupCall(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('call',)
    CONSTRUCTOR_ID = 0xdb9f9140
    SUBCLASS_OF_ID = 0xb2b987f3

    call: 'TypeInputGroupCall'
    def __init__(self, call: 'TypeInputGroupCall'):
        object.__setattr__(self, 'call', call)

    def _bytes(self):
        return b''.join((
            b'@\x91\x9f\xdb',
            self.call._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        return cls(call=_call)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionEditMessage(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_message', 'new_message',)
    CONSTRUCTOR_ID = 0x709b2405
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_message: 'TypeMessage'
    new_message: 'TypeMessage'
    def __init__(self, prev_message: 'TypeMessage', new_message: 'TypeMessage'):
        object.__setattr__(self, 'prev_message', prev_message)
        object.__setattr__(self, 'new_message', new_message)

    def _bytes(self):
        return b''.join((
            b'\x05$\x9bp',
            self.prev_message._bytes(),
            self.new_message._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_message = reader.tgread_object()
        _new_message = reader.tgread_object()
        return cls(prev_message=_prev_message, new_message=_new_message)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionExportedInviteDelete(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('invite',)
    CONSTRUCTOR_ID = 0x5a50fca4
    SUBCLASS_OF_ID = 0xb2b987f3

    invite: 'TypeExportedChatInvite'
    def __init__(self, invite: 'TypeExportedChatInvite'):
        object.__setattr__(self, 'invite', invite)

    def _bytes(self):
        return b''.join((
            b'\xa4\xfcPZ',
            self.invite._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _invite = reader.tgread_object()
        return cls(invite=_invite)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionExportedInviteEdit(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_invite', 'new_invite',)
    CONSTRUCTOR_ID = 0xe90ebb59
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_invite: 'TypeExportedChatInvite'
    new_invite: 'TypeExportedChatInvite'
    def __init__(self, prev_invite: 'TypeExportedChatInvite', new_invite: 'TypeExportedChatInvite'):
        object.__setattr__(self, 'prev_invite', prev_invite)
        object.__setattr__(self, 'new_invite', new_invite)

    def _bytes(self):
        return b''.join((
            b'Y\xbb\x0e\xe9',
            self.prev_invite._bytes(),
            self.new_invite._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_invite = reader.tgread_object()
        _new_invite = reader.tgread_object()
        return cls(prev_invite=_prev_invite, new_invite=_new_invite)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionExportedInviteRevoke(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('invite',)
    CONSTRUCTOR_ID = 0x410a134e
    SUBCLASS_OF_ID = 0xb2b987f3

    invite: 'TypeExportedChatInvite'
    def __init__(self, invite: 'TypeExportedChatInvite'):
        object.__setattr__(self, 'invite', invite)

    def _bytes(self):
        return b''.join((
            b'N\x13\nA',
            self.invite._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _invite = reader.tgread_object()
        return cls(invite=_invite)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionParticipantInvite(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('participant',)
    CONSTRUCTOR_ID = 0xe31c34d8
    SUBCLASS_OF_ID = 0xb2b987f3

    participant: 'TypeChannelParticipant'
    def __init__(self, participant: 'TypeChannelParticipant'):
        object.__setattr__(self, 'participant', participant)

    def _bytes(self):
        return b''.join((
            b'\xd84\x1c\xe3',
            self.participant._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _participant = reader.tgread_object()
        return cls(participant=_participant)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionParticipantJoin(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x183040d3
    SUBCLASS_OF_ID = 0xb2b987f3

    def _bytes(self):
        return b''.join((
            b'\xd3@0\x18',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionParticipantJoinByInvite(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('invite',)
    CONSTRUCTOR_ID = 0x5cdada77
    SUBCLASS_OF_ID = 0xb2b987f3

    invite: 'TypeExportedChatInvite'
    def __init__(self, invite: 'TypeExportedChatInvite'):
        object.__setattr__(self, 'invite', invite)

    def _bytes(self):
        return b''.join((
            b'w\xda\xda\\',
            self.invite._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _invite = reader.tgread_object()
        return cls(invite=_invite)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionParticipantJoinByRequest(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('invite', 'approved_by',)
    CONSTRUCTOR_ID = 0xafb6144a
    SUBCLASS_OF_ID = 0xb2b987f3

    invite: 'TypeExportedChatInvite'
    approved_by: int
    def __init__(self, invite: 'TypeExportedChatInvite', approved_by: int):
        object.__setattr__(self, 'invite', invite)
        object.__setattr__(self, 'approved_by', approved_by)

    def _bytes(self):
        return b''.join((
            b'J\x14\xb6\xaf',
            self.invite._bytes(),
            struct.pack('<q', self.approved_by),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _invite = reader.tgread_object()
        _approved_by = reader.read_long()
        return cls(invite=_invite, approved_by=_approved_by)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionParticipantLeave(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xf89777f2
    SUBCLASS_OF_ID = 0xb2b987f3

    def _bytes(self):
        return b''.join((
            b'\xf2w\x97\xf8',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionParticipantMute(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('participant',)
    CONSTRUCTOR_ID = 0xf92424d2
    SUBCLASS_OF_ID = 0xb2b987f3

    participant: 'TypeGroupCallParticipant'
    def __init__(self, participant: 'TypeGroupCallParticipant'):
        object.__setattr__(self, 'participant', participant)

    def _bytes(self):
        return b''.join((
            b'\xd2$$\xf9',
            self.participant._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _participant = reader.tgread_object()
        return cls(participant=_participant)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionParticipantToggleAdmin(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_participant', 'new_participant',)
    CONSTRUCTOR_ID = 0xd5676710
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_participant: 'TypeChannelParticipant'
    new_participant: 'TypeChannelParticipant'
    def __init__(self, prev_participant: 'TypeChannelParticipant', new_participant: 'TypeChannelParticipant'):
        object.__setattr__(self, 'prev_participant', prev_participant)
        object.__setattr__(self, 'new_participant', new_participant)

    def _bytes(self):
        return b''.join((
            b'\x10gg\xd5',
            self.prev_participant._bytes(),
            self.new_participant._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_participant = reader.tgread_object()
        _new_participant = reader.tgread_object()
        return cls(prev_participant=_prev_participant, new_participant=_new_participant)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionParticipantToggleBan(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_participant', 'new_participant',)
    CONSTRUCTOR_ID = 0xe6d83d7e
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_participant: 'TypeChannelParticipant'
    new_participant: 'TypeChannelParticipant'
    def __init__(self, prev_participant: 'TypeChannelParticipant', new_participant: 'TypeChannelParticipant'):
        object.__setattr__(self, 'prev_participant', prev_participant)
        object.__setattr__(self, 'new_participant', new_participant)

    def _bytes(self):
        return b''.join((
            b'~=\xd8\xe6',
            self.prev_participant._bytes(),
            self.new_participant._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_participant = reader.tgread_object()
        _new_participant = reader.tgread_object()
        return cls(prev_participant=_prev_participant, new_participant=_new_participant)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionParticipantUnmute(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('participant',)
    CONSTRUCTOR_ID = 0xe64429c0
    SUBCLASS_OF_ID = 0xb2b987f3

    participant: 'TypeGroupCallParticipant'
    def __init__(self, participant: 'TypeGroupCallParticipant'):
        object.__setattr__(self, 'participant', participant)

    def _bytes(self):
        return b''.join((
            b'\xc0)D\xe6',
            self.participant._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _participant = reader.tgread_object()
        return cls(participant=_participant)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionParticipantVolume(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('participant',)
    CONSTRUCTOR_ID = 0x3e7f6847
    SUBCLASS_OF_ID = 0xb2b987f3

    participant: 'TypeGroupCallParticipant'
    def __init__(self, participant: 'TypeGroupCallParticipant'):
        object.__setattr__(self, 'participant', participant)

    def _bytes(self):
        return b''.join((
            b'Gh\x7f>',
            self.participant._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _participant = reader.tgread_object()
        return cls(participant=_participant)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionSendMessage(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('message',)
    CONSTRUCTOR_ID = 0x278f2868
    SUBCLASS_OF_ID = 0xb2b987f3

    message: 'TypeMessage'
    def __init__(self, message: 'TypeMessage'):
        object.__setattr__(self, 'message', message)

    def _bytes(self):
        return b''.join((
            b"h(\x8f'",
            self.message._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _message = reader.tgread_object()
        return cls(message=_message)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionStartGroupCall(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('call',)
    CONSTRUCTOR_ID = 0x23209745
    SUBCLASS_OF_ID = 0xb2b987f3

    call: 'TypeInputGroupCall'
    def __init__(self, call: 'TypeInputGroupCall'):
        object.__setattr__(self, 'call', call)

    def _bytes(self):
        return b''.join((
            b'E\x97 #',
            self.call._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        return cls(call=_call)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionStopPoll(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('message',)
    CONSTRUCTOR_ID = 0x8f079643
    SUBCLASS_OF_ID = 0xb2b987f3

    message: 'TypeMessage'
    def __init__(self, message: 'TypeMessage'):
        object.__setattr__(self, 'message', message)

    def _bytes(self):
        return b''.join((
            b'C\x96\x07\x8f',
            self.message._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _message = reader.tgread_object()
        return cls(message=_message)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionToggleGroupCallSetting(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('join_muted',)
    CONSTRUCTOR_ID = 0x56d6a247
    SUBCLASS_OF_ID = 0xb2b987f3

    join_muted: bool
    def __init__(self, join_muted: bool):
        object.__setattr__(self, 'join_muted', join_muted)

    def _bytes(self):
        return b''.join((
            b'G\xa2\xd6V',
            b'\xb5ur\x99' if self.join_muted else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _join_muted = reader.tgread_bool()
        return cls(join_muted=_join_muted)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionToggleInvites(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('new_value',)
    CONSTRUCTOR_ID = 0x1b7907ae
    SUBCLASS_OF_ID = 0xb2b987f3

    new_value: bool
    def __init__(self, new_value: bool):
        object.__setattr__(self, 'new_value', new_value)

    def _bytes(self):
        return b''.join((
            b'\xae\x07y\x1b',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionToggleNoForwards(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('new_value',)
    CONSTRUCTOR_ID = 0xcb2ac766
    SUBCLASS_OF_ID = 0xb2b987f3

    new_value: bool
    def __init__(self, new_value: bool):
        object.__setattr__(self, 'new_value', new_value)

    def _bytes(self):
        return b''.join((
            b'f\xc7*\xcb',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionTogglePreHistoryHidden(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('new_value',)
    CONSTRUCTOR_ID = 0x5f5c95f1
    SUBCLASS_OF_ID = 0xb2b987f3

    new_value: bool
    def __init__(self, new_value: bool):
        object.__setattr__(self, 'new_value', new_value)

    def _bytes(self):
        return b''.join((
            b'\xf1\x95\\_',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionToggleSignatures(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('new_value',)
    CONSTRUCTOR_ID = 0x26ae0971
    SUBCLASS_OF_ID = 0xb2b987f3

    new_value: bool
    def __init__(self, new_value: bool):
        object.__setattr__(self, 'new_value', new_value)

    def _bytes(self):
        return b''.join((
            b'q\t\xae&',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionToggleSlowMode(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('prev_value', 'new_value',)
    CONSTRUCTOR_ID = 0x53909779
    SUBCLASS_OF_ID = 0xb2b987f3

    prev_value: int
    new_value: int
    def __init__(self, prev_value: int, new_value: int):
        object.__setattr__(self, 'prev_value', prev_value)
        object.__setattr__(self, 'new_value', new_value)

    def _bytes(self):
        return b''.join((
            b'y\x97\x90S',
            struct.pack('<i', self.prev_value),
            struct.pack('<i', self.new_value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _prev_value = reader.read_int()
        _new_value = reader.read_int()
        return cls(prev_value=_prev_value, new_value=_new_value)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventActionUpdatePinned(TLObject):
    """
    Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions.
    """
    __slots__ = ('message',)
    CONSTRUCTOR_ID = 0xe9e82c18
    SUBCLASS_OF_ID = 0xb2b987f3

    message: 'TypeMessage'
    def __init__(self, message: 'TypeMessage'):
        object.__setattr__(self, 'message', message)

    def _bytes(self):
        return b''.join((
            b'\x18,\xe8\xe9',
            self.message._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _message = reader.tgread_object()
        return cls(message=_message)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelAdminLogEventsFilter(TLObject):
    """
    Constructor for ChannelAdminLogEventsFilter: Instance of ChannelAdminLogEventsFilter.
    """
    __slots__ = ('join', 'leave', 'invite', 'ban', 'unban', 'kick', 'unkick', 'promote', 'demote', 'info', 'settings', 'pinned', 'edit', 'delete', 'group_call', 'invites', 'send',)
    CONSTRUCTOR_ID = 0xea107ae4
    SUBCLASS_OF_ID = 0x7cbbf319

    join: Optional[bool]
    leave: Optional[bool]
    invite: Optional[bool]
    ban: Optional[bool]
    unban: Optional[bool]
    kick: Optional[bool]
    unkick: Optional[bool]
    promote: Optional[bool]
    demote: Optional[bool]
    info: Optional[bool]
    settings: Optional[bool]
    pinned: Optional[bool]
    edit: Optional[bool]
    delete: Optional[bool]
    group_call: Optional[bool]
    invites: Optional[bool]
    send: Optional[bool]
    def __init__(self, join: Optional[bool]=None, leave: Optional[bool]=None, invite: Optional[bool]=None, ban: Optional[bool]=None, unban: Optional[bool]=None, kick: Optional[bool]=None, unkick: Optional[bool]=None, promote: Optional[bool]=None, demote: Optional[bool]=None, info: Optional[bool]=None, settings: Optional[bool]=None, pinned: Optional[bool]=None, edit: Optional[bool]=None, delete: Optional[bool]=None, group_call: Optional[bool]=None, invites: Optional[bool]=None, send: Optional[bool]=None):
        object.__setattr__(self, 'join', join)
        object.__setattr__(self, 'leave', leave)
        object.__setattr__(self, 'invite', invite)
        object.__setattr__(self, 'ban', ban)
        object.__setattr__(self, 'unban', unban)
        object.__setattr__(self, 'kick', kick)
        object.__setattr__(self, 'unkick', unkick)
        object.__setattr__(self, 'promote', promote)
        object.__setattr__(self, 'demote', demote)
        object.__setattr__(self, 'info', info)
        object.__setattr__(self, 'settings', settings)
        object.__setattr__(self, 'pinned', pinned)
        object.__setattr__(self, 'edit', edit)
        object.__setattr__(self, 'delete', delete)
        object.__setattr__(self, 'group_call', group_call)
        object.__setattr__(self, 'invites', invites)
        object.__setattr__(self, 'send', send)

    def _bytes(self):
        return b''.join((
            b'\xe4z\x10\xea',
            struct.pack('<I', (0 if self.join is None or self.join is False else 1) | (0 if self.leave is None or self.leave is False else 2) | (0 if self.invite is None or self.invite is False else 4) | (0 if self.ban is None or self.ban is False else 8) | (0 if self.unban is None or self.unban is False else 16) | (0 if self.kick is None or self.kick is False else 32) | (0 if self.unkick is None or self.unkick is False else 64) | (0 if self.promote is None or self.promote is False else 128) | (0 if self.demote is None or self.demote is False else 256) | (0 if self.info is None or self.info is False else 512) | (0 if self.settings is None or self.settings is False else 1024) | (0 if self.pinned is None or self.pinned is False else 2048) | (0 if self.edit is None or self.edit is False else 4096) | (0 if self.delete is None or self.delete is False else 8192) | (0 if self.group_call is None or self.group_call is False else 16384) | (0 if self.invites is None or self.invites is False else 32768) | (0 if self.send is None or self.send is False else 65536)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _join = bool(flags & 1)
        _leave = bool(flags & 2)
        _invite = bool(flags & 4)
        _ban = bool(flags & 8)
        _unban = bool(flags & 16)
        _kick = bool(flags & 32)
        _unkick = bool(flags & 64)
        _promote = bool(flags & 128)
        _demote = bool(flags & 256)
        _info = bool(flags & 512)
        _settings = bool(flags & 1024)
        _pinned = bool(flags & 2048)
        _edit = bool(flags & 4096)
        _delete = bool(flags & 8192)
        _group_call = bool(flags & 16384)
        _invites = bool(flags & 32768)
        _send = bool(flags & 65536)
        return cls(join=_join, leave=_leave, invite=_invite, ban=_ban, unban=_unban, kick=_kick, unkick=_unkick, promote=_promote, demote=_demote, info=_info, settings=_settings, pinned=_pinned, edit=_edit, delete=_delete, group_call=_group_call, invites=_invites, send=_send)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelForbidden(TLObject):
    """
    Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
    """
    __slots__ = ('id', 'access_hash', 'title', 'broadcast', 'megagroup', 'until_date',)
    CONSTRUCTOR_ID = 0x17d493d5
    SUBCLASS_OF_ID = 0xc5af5d94

    id: int
    access_hash: int
    title: str
    broadcast: Optional[bool]
    megagroup: Optional[bool]
    until_date: Optional[datetime]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, title: str, broadcast: Optional[bool]=None, megagroup: Optional[bool]=None, until_date: Optional[datetime]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'broadcast', broadcast)
        object.__setattr__(self, 'megagroup', megagroup)
        object.__setattr__(self, 'until_date', until_date)

    def _bytes(self):
        return b''.join((
            b'\xd5\x93\xd4\x17',
            struct.pack('<I', (0 if self.broadcast is None or self.broadcast is False else 32) | (0 if self.megagroup is None or self.megagroup is False else 256) | (0 if self.until_date is None or self.until_date is False else 65536)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_bytes(self.title),
            b'' if self.until_date is None or self.until_date is False else (self._serialize_datetime(self.until_date)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _broadcast = bool(flags & 32)
        _megagroup = bool(flags & 256)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _title = reader.tgread_string()
        if flags & 65536:
            _until_date = reader.tgread_date()
        else:
            _until_date = None
        return cls(id=_id, access_hash=_access_hash, title=_title, broadcast=_broadcast, megagroup=_megagroup, until_date=_until_date)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelFull(TLObject):
    """
    Constructor for ChatFull: Instance of either ChatFull, ChannelFull.
    """
    __slots__ = ('id', 'about', 'read_inbox_max_id', 'read_outbox_max_id', 'unread_count', 'chat_photo', 'notify_settings', 'bot_info', 'pts', 'can_view_participants', 'can_set_username', 'can_set_stickers', 'hidden_prehistory', 'can_set_location', 'has_scheduled', 'can_view_stats', 'blocked', 'participants_count', 'admins_count', 'kicked_count', 'banned_count', 'online_count', 'exported_invite', 'migrated_from_chat_id', 'migrated_from_max_id', 'pinned_msg_id', 'stickerset', 'available_min_id', 'folder_id', 'linked_chat_id', 'location', 'slowmode_seconds', 'slowmode_next_send_date', 'stats_dc', 'call', 'ttl_period', 'pending_suggestions', 'groupcall_default_join_as', 'theme_emoticon', 'requests_pending', 'recent_requesters', 'default_send_as', 'available_reactions',)
    CONSTRUCTOR_ID = 0xe13c3d20
    SUBCLASS_OF_ID = 0xd49a2697

    id: int
    about: str
    read_inbox_max_id: int
    read_outbox_max_id: int
    unread_count: int
    chat_photo: 'TypePhoto'
    notify_settings: 'TypePeerNotifySettings'
    bot_info: List['TypeBotInfo']
    pts: int
    can_view_participants: Optional[bool]
    can_set_username: Optional[bool]
    can_set_stickers: Optional[bool]
    hidden_prehistory: Optional[bool]
    can_set_location: Optional[bool]
    has_scheduled: Optional[bool]
    can_view_stats: Optional[bool]
    blocked: Optional[bool]
    participants_count: Optional[int]
    admins_count: Optional[int]
    kicked_count: Optional[int]
    banned_count: Optional[int]
    online_count: Optional[int]
    exported_invite: Optional['TypeExportedChatInvite']
    migrated_from_chat_id: Optional[int]
    migrated_from_max_id: Optional[int]
    pinned_msg_id: Optional[int]
    stickerset: Optional['TypeStickerSet']
    available_min_id: Optional[int]
    folder_id: Optional[int]
    linked_chat_id: Optional[int]
    location: Optional['TypeChannelLocation']
    slowmode_seconds: Optional[int]
    slowmode_next_send_date: Optional[datetime]
    stats_dc: Optional[int]
    call: Optional['TypeInputGroupCall']
    ttl_period: Optional[int]
    pending_suggestions: Optional[List[str]]
    groupcall_default_join_as: Optional['TypePeer']
    theme_emoticon: Optional[str]
    requests_pending: Optional[int]
    recent_requesters: Optional[List[int]]
    default_send_as: Optional['TypePeer']
    available_reactions: Optional[List[str]]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, about: str, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, chat_photo: 'TypePhoto', notify_settings: 'TypePeerNotifySettings', bot_info: List['TypeBotInfo'], pts: int, can_view_participants: Optional[bool]=None, can_set_username: Optional[bool]=None, can_set_stickers: Optional[bool]=None, hidden_prehistory: Optional[bool]=None, can_set_location: Optional[bool]=None, has_scheduled: Optional[bool]=None, can_view_stats: Optional[bool]=None, blocked: Optional[bool]=None, participants_count: Optional[int]=None, admins_count: Optional[int]=None, kicked_count: Optional[int]=None, banned_count: Optional[int]=None, online_count: Optional[int]=None, exported_invite: Optional['TypeExportedChatInvite']=None, migrated_from_chat_id: Optional[int]=None, migrated_from_max_id: Optional[int]=None, pinned_msg_id: Optional[int]=None, stickerset: Optional['TypeStickerSet']=None, available_min_id: Optional[int]=None, folder_id: Optional[int]=None, linked_chat_id: Optional[int]=None, location: Optional['TypeChannelLocation']=None, slowmode_seconds: Optional[int]=None, slowmode_next_send_date: Optional[datetime]=None, stats_dc: Optional[int]=None, call: Optional['TypeInputGroupCall']=None, ttl_period: Optional[int]=None, pending_suggestions: Optional[List[str]]=None, groupcall_default_join_as: Optional['TypePeer']=None, theme_emoticon: Optional[str]=None, requests_pending: Optional[int]=None, recent_requesters: Optional[List[int]]=None, default_send_as: Optional['TypePeer']=None, available_reactions: Optional[List[str]]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'about', about)
        object.__setattr__(self, 'read_inbox_max_id', read_inbox_max_id)
        object.__setattr__(self, 'read_outbox_max_id', read_outbox_max_id)
        object.__setattr__(self, 'unread_count', unread_count)
        object.__setattr__(self, 'chat_photo', chat_photo)
        object.__setattr__(self, 'notify_settings', notify_settings)
        object.__setattr__(self, 'bot_info', bot_info)
        object.__setattr__(self, 'pts', pts)
        object.__setattr__(self, 'can_view_participants', can_view_participants)
        object.__setattr__(self, 'can_set_username', can_set_username)
        object.__setattr__(self, 'can_set_stickers', can_set_stickers)
        object.__setattr__(self, 'hidden_prehistory', hidden_prehistory)
        object.__setattr__(self, 'can_set_location', can_set_location)
        object.__setattr__(self, 'has_scheduled', has_scheduled)
        object.__setattr__(self, 'can_view_stats', can_view_stats)
        object.__setattr__(self, 'blocked', blocked)
        object.__setattr__(self, 'participants_count', participants_count)
        object.__setattr__(self, 'admins_count', admins_count)
        object.__setattr__(self, 'kicked_count', kicked_count)
        object.__setattr__(self, 'banned_count', banned_count)
        object.__setattr__(self, 'online_count', online_count)
        object.__setattr__(self, 'exported_invite', exported_invite)
        object.__setattr__(self, 'migrated_from_chat_id', migrated_from_chat_id)
        object.__setattr__(self, 'migrated_from_max_id', migrated_from_max_id)
        object.__setattr__(self, 'pinned_msg_id', pinned_msg_id)
        object.__setattr__(self, 'stickerset', stickerset)
        object.__setattr__(self, 'available_min_id', available_min_id)
        object.__setattr__(self, 'folder_id', folder_id)
        object.__setattr__(self, 'linked_chat_id', linked_chat_id)
        object.__setattr__(self, 'location', location)
        object.__setattr__(self, 'slowmode_seconds', slowmode_seconds)
        object.__setattr__(self, 'slowmode_next_send_date', slowmode_next_send_date)
        object.__setattr__(self, 'stats_dc', stats_dc)
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'ttl_period', ttl_period)
        object.__setattr__(self, 'pending_suggestions', pending_suggestions)
        object.__setattr__(self, 'groupcall_default_join_as', groupcall_default_join_as)
        object.__setattr__(self, 'theme_emoticon', theme_emoticon)
        object.__setattr__(self, 'requests_pending', requests_pending)
        object.__setattr__(self, 'recent_requesters', recent_requesters)
        object.__setattr__(self, 'default_send_as', default_send_as)
        object.__setattr__(self, 'available_reactions', available_reactions)

    def _bytes(self):
        assert ((self.kicked_count or self.kicked_count is not None) and (self.banned_count or self.banned_count is not None)) or ((self.kicked_count is None or self.kicked_count is False) and (self.banned_count is None or self.banned_count is False)), 'kicked_count, banned_count parameters must all be False-y (like None) or all me True-y'
        assert ((self.migrated_from_chat_id or self.migrated_from_chat_id is not None) and (self.migrated_from_max_id or self.migrated_from_max_id is not None)) or ((self.migrated_from_chat_id is None or self.migrated_from_chat_id is False) and (self.migrated_from_max_id is None or self.migrated_from_max_id is False)), 'migrated_from_chat_id, migrated_from_max_id parameters must all be False-y (like None) or all me True-y'
        assert ((self.requests_pending or self.requests_pending is not None) and (self.recent_requesters or self.recent_requesters is not None)) or ((self.requests_pending is None or self.requests_pending is False) and (self.recent_requesters is None or self.recent_requesters is False)), 'requests_pending, recent_requesters parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b' =<\xe1',
            struct.pack('<I', (0 if self.can_view_participants is None or self.can_view_participants is False else 8) | (0 if self.can_set_username is None or self.can_set_username is False else 64) | (0 if self.can_set_stickers is None or self.can_set_stickers is False else 128) | (0 if self.hidden_prehistory is None or self.hidden_prehistory is False else 1024) | (0 if self.can_set_location is None or self.can_set_location is False else 65536) | (0 if self.has_scheduled is None or self.has_scheduled is False else 524288) | (0 if self.can_view_stats is None or self.can_view_stats is False else 1048576) | (0 if self.blocked is None or self.blocked is False else 4194304) | (0 if self.participants_count is None or self.participants_count is False else 1) | (0 if self.admins_count is None or self.admins_count is False else 2) | (0 if self.kicked_count is None or self.kicked_count is False else 4) | (0 if self.banned_count is None or self.banned_count is False else 4) | (0 if self.online_count is None or self.online_count is False else 8192) | (0 if self.exported_invite is None or self.exported_invite is False else 8388608) | (0 if self.migrated_from_chat_id is None or self.migrated_from_chat_id is False else 16) | (0 if self.migrated_from_max_id is None or self.migrated_from_max_id is False else 16) | (0 if self.pinned_msg_id is None or self.pinned_msg_id is False else 32) | (0 if self.stickerset is None or self.stickerset is False else 256) | (0 if self.available_min_id is None or self.available_min_id is False else 512) | (0 if self.folder_id is None or self.folder_id is False else 2048) | (0 if self.linked_chat_id is None or self.linked_chat_id is False else 16384) | (0 if self.location is None or self.location is False else 32768) | (0 if self.slowmode_seconds is None or self.slowmode_seconds is False else 131072) | (0 if self.slowmode_next_send_date is None or self.slowmode_next_send_date is False else 262144) | (0 if self.stats_dc is None or self.stats_dc is False else 4096) | (0 if self.call is None or self.call is False else 2097152) | (0 if self.ttl_period is None or self.ttl_period is False else 16777216) | (0 if self.pending_suggestions is None or self.pending_suggestions is False else 33554432) | (0 if self.groupcall_default_join_as is None or self.groupcall_default_join_as is False else 67108864) | (0 if self.theme_emoticon is None or self.theme_emoticon is False else 134217728) | (0 if self.requests_pending is None or self.requests_pending is False else 268435456) | (0 if self.recent_requesters is None or self.recent_requesters is False else 268435456) | (0 if self.default_send_as is None or self.default_send_as is False else 536870912) | (0 if self.available_reactions is None or self.available_reactions is False else 1073741824)),
            struct.pack('<q', self.id),
            self._serialize_bytes(self.about),
            b'' if self.participants_count is None or self.participants_count is False else (struct.pack('<i', self.participants_count)),
            b'' if self.admins_count is None or self.admins_count is False else (struct.pack('<i', self.admins_count)),
            b'' if self.kicked_count is None or self.kicked_count is False else (struct.pack('<i', self.kicked_count)),
            b'' if self.banned_count is None or self.banned_count is False else (struct.pack('<i', self.banned_count)),
            b'' if self.online_count is None or self.online_count is False else (struct.pack('<i', self.online_count)),
            struct.pack('<i', self.read_inbox_max_id),
            struct.pack('<i', self.read_outbox_max_id),
            struct.pack('<i', self.unread_count),
            self.chat_photo._bytes(),
            self.notify_settings._bytes(),
            b'' if self.exported_invite is None or self.exported_invite is False else (self.exported_invite._bytes()),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.bot_info)),b''.join(x._bytes() for x in self.bot_info),
            b'' if self.migrated_from_chat_id is None or self.migrated_from_chat_id is False else (struct.pack('<q', self.migrated_from_chat_id)),
            b'' if self.migrated_from_max_id is None or self.migrated_from_max_id is False else (struct.pack('<i', self.migrated_from_max_id)),
            b'' if self.pinned_msg_id is None or self.pinned_msg_id is False else (struct.pack('<i', self.pinned_msg_id)),
            b'' if self.stickerset is None or self.stickerset is False else (self.stickerset._bytes()),
            b'' if self.available_min_id is None or self.available_min_id is False else (struct.pack('<i', self.available_min_id)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            b'' if self.linked_chat_id is None or self.linked_chat_id is False else (struct.pack('<q', self.linked_chat_id)),
            b'' if self.location is None or self.location is False else (self.location._bytes()),
            b'' if self.slowmode_seconds is None or self.slowmode_seconds is False else (struct.pack('<i', self.slowmode_seconds)),
            b'' if self.slowmode_next_send_date is None or self.slowmode_next_send_date is False else (self._serialize_datetime(self.slowmode_next_send_date)),
            b'' if self.stats_dc is None or self.stats_dc is False else (struct.pack('<i', self.stats_dc)),
            struct.pack('<i', self.pts),
            b'' if self.call is None or self.call is False else (self.call._bytes()),
            b'' if self.ttl_period is None or self.ttl_period is False else (struct.pack('<i', self.ttl_period)),
            b'' if self.pending_suggestions is None or self.pending_suggestions is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.pending_suggestions)),b''.join(self._serialize_bytes(x) for x in self.pending_suggestions))),
            b'' if self.groupcall_default_join_as is None or self.groupcall_default_join_as is False else (self.groupcall_default_join_as._bytes()),
            b'' if self.theme_emoticon is None or self.theme_emoticon is False else (self._serialize_bytes(self.theme_emoticon)),
            b'' if self.requests_pending is None or self.requests_pending is False else (struct.pack('<i', self.requests_pending)),
            b'' if self.recent_requesters is None or self.recent_requesters is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.recent_requesters)),b''.join(struct.pack('<q', x) for x in self.recent_requesters))),
            b'' if self.default_send_as is None or self.default_send_as is False else (self.default_send_as._bytes()),
            b'' if self.available_reactions is None or self.available_reactions is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.available_reactions)),b''.join(self._serialize_bytes(x) for x in self.available_reactions))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _can_view_participants = bool(flags & 8)
        _can_set_username = bool(flags & 64)
        _can_set_stickers = bool(flags & 128)
        _hidden_prehistory = bool(flags & 1024)
        _can_set_location = bool(flags & 65536)
        _has_scheduled = bool(flags & 524288)
        _can_view_stats = bool(flags & 1048576)
        _blocked = bool(flags & 4194304)
        _id = reader.read_long()
        _about = reader.tgread_string()
        if flags & 1:
            _participants_count = reader.read_int()
        else:
            _participants_count = None
        if flags & 2:
            _admins_count = reader.read_int()
        else:
            _admins_count = None
        if flags & 4:
            _kicked_count = reader.read_int()
        else:
            _kicked_count = None
        if flags & 4:
            _banned_count = reader.read_int()
        else:
            _banned_count = None
        if flags & 8192:
            _online_count = reader.read_int()
        else:
            _online_count = None
        _read_inbox_max_id = reader.read_int()
        _read_outbox_max_id = reader.read_int()
        _unread_count = reader.read_int()
        _chat_photo = reader.tgread_object()
        _notify_settings = reader.tgread_object()
        if flags & 8388608:
            _exported_invite = reader.tgread_object()
        else:
            _exported_invite = None
        reader.read_int()
        _bot_info = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _bot_info.append(_x)

        if flags & 16:
            _migrated_from_chat_id = reader.read_long()
        else:
            _migrated_from_chat_id = None
        if flags & 16:
            _migrated_from_max_id = reader.read_int()
        else:
            _migrated_from_max_id = None
        if flags & 32:
            _pinned_msg_id = reader.read_int()
        else:
            _pinned_msg_id = None
        if flags & 256:
            _stickerset = reader.tgread_object()
        else:
            _stickerset = None
        if flags & 512:
            _available_min_id = reader.read_int()
        else:
            _available_min_id = None
        if flags & 2048:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        if flags & 16384:
            _linked_chat_id = reader.read_long()
        else:
            _linked_chat_id = None
        if flags & 32768:
            _location = reader.tgread_object()
        else:
            _location = None
        if flags & 131072:
            _slowmode_seconds = reader.read_int()
        else:
            _slowmode_seconds = None
        if flags & 262144:
            _slowmode_next_send_date = reader.tgread_date()
        else:
            _slowmode_next_send_date = None
        if flags & 4096:
            _stats_dc = reader.read_int()
        else:
            _stats_dc = None
        _pts = reader.read_int()
        if flags & 2097152:
            _call = reader.tgread_object()
        else:
            _call = None
        if flags & 16777216:
            _ttl_period = reader.read_int()
        else:
            _ttl_period = None
        if flags & 33554432:
            reader.read_int()
            _pending_suggestions = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_string()
                _pending_suggestions.append(_x)

        else:
            _pending_suggestions = None
        if flags & 67108864:
            _groupcall_default_join_as = reader.tgread_object()
        else:
            _groupcall_default_join_as = None
        if flags & 134217728:
            _theme_emoticon = reader.tgread_string()
        else:
            _theme_emoticon = None
        if flags & 268435456:
            _requests_pending = reader.read_int()
        else:
            _requests_pending = None
        if flags & 268435456:
            reader.read_int()
            _recent_requesters = []
            for _ in range(reader.read_int()):
                _x = reader.read_long()
                _recent_requesters.append(_x)

        else:
            _recent_requesters = None
        if flags & 536870912:
            _default_send_as = reader.tgread_object()
        else:
            _default_send_as = None
        if flags & 1073741824:
            reader.read_int()
            _available_reactions = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_string()
                _available_reactions.append(_x)

        else:
            _available_reactions = None
        return cls(id=_id, about=_about, read_inbox_max_id=_read_inbox_max_id, read_outbox_max_id=_read_outbox_max_id, unread_count=_unread_count, chat_photo=_chat_photo, notify_settings=_notify_settings, bot_info=_bot_info, pts=_pts, can_view_participants=_can_view_participants, can_set_username=_can_set_username, can_set_stickers=_can_set_stickers, hidden_prehistory=_hidden_prehistory, can_set_location=_can_set_location, has_scheduled=_has_scheduled, can_view_stats=_can_view_stats, blocked=_blocked, participants_count=_participants_count, admins_count=_admins_count, kicked_count=_kicked_count, banned_count=_banned_count, online_count=_online_count, exported_invite=_exported_invite, migrated_from_chat_id=_migrated_from_chat_id, migrated_from_max_id=_migrated_from_max_id, pinned_msg_id=_pinned_msg_id, stickerset=_stickerset, available_min_id=_available_min_id, folder_id=_folder_id, linked_chat_id=_linked_chat_id, location=_location, slowmode_seconds=_slowmode_seconds, slowmode_next_send_date=_slowmode_next_send_date, stats_dc=_stats_dc, call=_call, ttl_period=_ttl_period, pending_suggestions=_pending_suggestions, groupcall_default_join_as=_groupcall_default_join_as, theme_emoticon=_theme_emoticon, requests_pending=_requests_pending, recent_requesters=_recent_requesters, default_send_as=_default_send_as, available_reactions=_available_reactions)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelLocation(TLObject):
    """
    Constructor for ChannelLocation: Instance of either ChannelLocationEmpty, ChannelLocation.
    """
    __slots__ = ('geo_point', 'address',)
    CONSTRUCTOR_ID = 0x209b82db
    SUBCLASS_OF_ID = 0xec260b7f

    geo_point: 'TypeGeoPoint'
    address: str
    def __init__(self, geo_point: 'TypeGeoPoint', address: str):
        object.__setattr__(self, 'geo_point', geo_point)
        object.__setattr__(self, 'address', address)

    def _bytes(self):
        return b''.join((
            b'\xdb\x82\x9b ',
            self.geo_point._bytes(),
            self._serialize_bytes(self.address),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _geo_point = reader.tgread_object()
        _address = reader.tgread_string()
        return cls(geo_point=_geo_point, address=_address)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelLocationEmpty(TLObject):
    """
    Constructor for ChannelLocation: Instance of either ChannelLocationEmpty, ChannelLocation.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xbfb5ad8b
    SUBCLASS_OF_ID = 0xec260b7f

    def _bytes(self):
        return b''.join((
            b'\x8b\xad\xb5\xbf',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ChannelMessagesFilter(TLObject):
    """
    Constructor for ChannelMessagesFilter: Instance of either ChannelMessagesFilterEmpty, ChannelMessagesFilter.
    """
    __slots__ = ('ranges', 'exclude_new_messages',)
    CONSTRUCTOR_ID = 0xcd77d957
    SUBCLASS_OF_ID = 0x13336a56

    ranges: List['TypeMessageRange']
    exclude_new_messages: Optional[bool]
    def __init__(self, ranges: List['TypeMessageRange'], exclude_new_messages: Optional[bool]=None):
        object.__setattr__(self, 'ranges', ranges)
        object.__setattr__(self, 'exclude_new_messages', exclude_new_messages)

    def _bytes(self):
        return b''.join((
            b'W\xd9w\xcd',
            struct.pack('<I', (0 if self.exclude_new_messages is None or self.exclude_new_messages is False else 2)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.ranges)),b''.join(x._bytes() for x in self.ranges),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _exclude_new_messages = bool(flags & 2)
        reader.read_int()
        _ranges = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _ranges.append(_x)

        return cls(ranges=_ranges, exclude_new_messages=_exclude_new_messages)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelMessagesFilterEmpty(TLObject):
    """
    Constructor for ChannelMessagesFilter: Instance of either ChannelMessagesFilterEmpty, ChannelMessagesFilter.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x94d42ee7
    SUBCLASS_OF_ID = 0x13336a56

    def _bytes(self):
        return b''.join((
            b'\xe7.\xd4\x94',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipant(TLObject):
    """
    Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned, ChannelParticipantLeft.
    """
    __slots__ = ('user_id', 'date',)
    CONSTRUCTOR_ID = 0xc00c07c0
    SUBCLASS_OF_ID = 0xd9c7fc18

    user_id: int
    date: Optional[datetime]
    def __init__(self, user_id: int, date: Optional[datetime]):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'date', date)

    def _bytes(self):
        return b''.join((
            b'\xc0\x07\x0c\xc0',
            struct.pack('<q', self.user_id),
            self._serialize_datetime(self.date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, date=_date)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantAdmin(TLObject):
    """
    Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned, ChannelParticipantLeft.
    """
    __slots__ = ('user_id', 'promoted_by', 'date', 'admin_rights', 'can_edit', 'is_self', 'inviter_id', 'rank',)
    CONSTRUCTOR_ID = 0x34c3bb53
    SUBCLASS_OF_ID = 0xd9c7fc18

    user_id: int
    promoted_by: int
    date: Optional[datetime]
    admin_rights: 'TypeChatAdminRights'
    can_edit: Optional[bool]
    is_self: Optional[bool]
    inviter_id: Optional[int]
    rank: Optional[str]
    def __init__(self, user_id: int, promoted_by: int, date: Optional[datetime], admin_rights: 'TypeChatAdminRights', can_edit: Optional[bool]=None, is_self: Optional[bool]=None, inviter_id: Optional[int]=None, rank: Optional[str]=None):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'promoted_by', promoted_by)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'admin_rights', admin_rights)
        object.__setattr__(self, 'can_edit', can_edit)
        object.__setattr__(self, 'is_self', is_self)
        object.__setattr__(self, 'inviter_id', inviter_id)
        object.__setattr__(self, 'rank', rank)

    def _bytes(self):
        assert ((self.is_self or self.is_self is not None) and (self.inviter_id or self.inviter_id is not None)) or ((self.is_self is None or self.is_self is False) and (self.inviter_id is None or self.inviter_id is False)), 'is_self, inviter_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'S\xbb\xc34',
            struct.pack('<I', (0 if self.can_edit is None or self.can_edit is False else 1) | (0 if self.is_self is None or self.is_self is False else 2) | (0 if self.inviter_id is None or self.inviter_id is False else 2) | (0 if self.rank is None or self.rank is False else 4)),
            struct.pack('<q', self.user_id),
            b'' if self.inviter_id is None or self.inviter_id is False else (struct.pack('<q', self.inviter_id)),
            struct.pack('<q', self.promoted_by),
            self._serialize_datetime(self.date),
            self.admin_rights._bytes(),
            b'' if self.rank is None or self.rank is False else (self._serialize_bytes(self.rank)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _can_edit = bool(flags & 1)
        _is_self = bool(flags & 2)
        _user_id = reader.read_long()
        if flags & 2:
            _inviter_id = reader.read_long()
        else:
            _inviter_id = None
        _promoted_by = reader.read_long()
        _date = reader.tgread_date()
        _admin_rights = reader.tgread_object()
        if flags & 4:
            _rank = reader.tgread_string()
        else:
            _rank = None
        return cls(user_id=_user_id, promoted_by=_promoted_by, date=_date, admin_rights=_admin_rights, can_edit=_can_edit, is_self=_is_self, inviter_id=_inviter_id, rank=_rank)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantBanned(TLObject):
    """
    Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned, ChannelParticipantLeft.
    """
    __slots__ = ('peer', 'kicked_by', 'date', 'banned_rights', 'left',)
    CONSTRUCTOR_ID = 0x6df8014e
    SUBCLASS_OF_ID = 0xd9c7fc18

    peer: 'TypePeer'
    kicked_by: int
    date: Optional[datetime]
    banned_rights: 'TypeChatBannedRights'
    left: Optional[bool]
    def __init__(self, peer: 'TypePeer', kicked_by: int, date: Optional[datetime], banned_rights: 'TypeChatBannedRights', left: Optional[bool]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'kicked_by', kicked_by)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'banned_rights', banned_rights)
        object.__setattr__(self, 'left', left)

    def _bytes(self):
        return b''.join((
            b'N\x01\xf8m',
            struct.pack('<I', (0 if self.left is None or self.left is False else 1)),
            self.peer._bytes(),
            struct.pack('<q', self.kicked_by),
            self._serialize_datetime(self.date),
            self.banned_rights._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _left = bool(flags & 1)
        _peer = reader.tgread_object()
        _kicked_by = reader.read_long()
        _date = reader.tgread_date()
        _banned_rights = reader.tgread_object()
        return cls(peer=_peer, kicked_by=_kicked_by, date=_date, banned_rights=_banned_rights, left=_left)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantCreator(TLObject):
    """
    Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned, ChannelParticipantLeft.
    """
    __slots__ = ('user_id', 'admin_rights', 'rank',)
    CONSTRUCTOR_ID = 0x2fe601d3
    SUBCLASS_OF_ID = 0xd9c7fc18

    user_id: int
    admin_rights: 'TypeChatAdminRights'
    rank: Optional[str]
    def __init__(self, user_id: int, admin_rights: 'TypeChatAdminRights', rank: Optional[str]=None):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'admin_rights', admin_rights)
        object.__setattr__(self, 'rank', rank)

    def _bytes(self):
        return b''.join((
            b'\xd3\x01\xe6/',
            struct.pack('<I', (0 if self.rank is None or self.rank is False else 1)),
            struct.pack('<q', self.user_id),
            self.admin_rights._bytes(),
            b'' if self.rank is None or self.rank is False else (self._serialize_bytes(self.rank)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _user_id = reader.read_long()
        _admin_rights = reader.tgread_object()
        if flags & 1:
            _rank = reader.tgread_string()
        else:
            _rank = None
        return cls(user_id=_user_id, admin_rights=_admin_rights, rank=_rank)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantLeft(TLObject):
    """
    Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned, ChannelParticipantLeft.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0x1b03f006
    SUBCLASS_OF_ID = 0xd9c7fc18

    peer: 'TypePeer'
    def __init__(self, peer: 'TypePeer'):
        object.__setattr__(self, 'peer', peer)

    def _bytes(self):
        return b''.join((
            b'\x06\xf0\x03\x1b',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantSelf(TLObject):
    """
    Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned, ChannelParticipantLeft.
    """
    __slots__ = ('user_id', 'inviter_id', 'date', 'via_request',)
    CONSTRUCTOR_ID = 0x35a8bfa7
    SUBCLASS_OF_ID = 0xd9c7fc18

    user_id: int
    inviter_id: int
    date: Optional[datetime]
    via_request: Optional[bool]
    def __init__(self, user_id: int, inviter_id: int, date: Optional[datetime], via_request: Optional[bool]=None):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'inviter_id', inviter_id)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'via_request', via_request)

    def _bytes(self):
        return b''.join((
            b'\xa7\xbf\xa85',
            struct.pack('<I', (0 if self.via_request is None or self.via_request is False else 1)),
            struct.pack('<q', self.user_id),
            struct.pack('<q', self.inviter_id),
            self._serialize_datetime(self.date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _via_request = bool(flags & 1)
        _user_id = reader.read_long()
        _inviter_id = reader.read_long()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, inviter_id=_inviter_id, date=_date, via_request=_via_request)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantsAdmins(TLObject):
    """
    Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb4608969
    SUBCLASS_OF_ID = 0xbf4e2753

    def _bytes(self):
        return b''.join((
            b'i\x89`\xb4',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantsBanned(TLObject):
    """
    Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
    """
    __slots__ = ('q',)
    CONSTRUCTOR_ID = 0x1427a5e1
    SUBCLASS_OF_ID = 0xbf4e2753

    q: str
    def __init__(self, q: str):
        object.__setattr__(self, 'q', q)

    def _bytes(self):
        return b''.join((
            b"\xe1\xa5'\x14",
            self._serialize_bytes(self.q),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _q = reader.tgread_string()
        return cls(q=_q)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantsBots(TLObject):
    """
    Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb0d1865b
    SUBCLASS_OF_ID = 0xbf4e2753

    def _bytes(self):
        return b''.join((
            b'[\x86\xd1\xb0',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantsContacts(TLObject):
    """
    Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
    """
    __slots__ = ('q',)
    CONSTRUCTOR_ID = 0xbb6ae88d
    SUBCLASS_OF_ID = 0xbf4e2753

    q: str
    def __init__(self, q: str):
        object.__setattr__(self, 'q', q)

    def _bytes(self):
        return b''.join((
            b'\x8d\xe8j\xbb',
            self._serialize_bytes(self.q),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _q = reader.tgread_string()
        return cls(q=_q)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantsKicked(TLObject):
    """
    Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
    """
    __slots__ = ('q',)
    CONSTRUCTOR_ID = 0xa3b54985
    SUBCLASS_OF_ID = 0xbf4e2753

    q: str
    def __init__(self, q: str):
        object.__setattr__(self, 'q', q)

    def _bytes(self):
        return b''.join((
            b'\x85I\xb5\xa3',
            self._serialize_bytes(self.q),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _q = reader.tgread_string()
        return cls(q=_q)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantsMentions(TLObject):
    """
    Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
    """
    __slots__ = ('q', 'top_msg_id',)
    CONSTRUCTOR_ID = 0xe04b5ceb
    SUBCLASS_OF_ID = 0xbf4e2753

    q: Optional[str]
    top_msg_id: Optional[int]
    def __init__(self, q: Optional[str]=None, top_msg_id: Optional[int]=None):
        object.__setattr__(self, 'q', q)
        object.__setattr__(self, 'top_msg_id', top_msg_id)

    def _bytes(self):
        return b''.join((
            b'\xeb\\K\xe0',
            struct.pack('<I', (0 if self.q is None or self.q is False else 1) | (0 if self.top_msg_id is None or self.top_msg_id is False else 2)),
            b'' if self.q is None or self.q is False else (self._serialize_bytes(self.q)),
            b'' if self.top_msg_id is None or self.top_msg_id is False else (struct.pack('<i', self.top_msg_id)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _q = reader.tgread_string()
        else:
            _q = None
        if flags & 2:
            _top_msg_id = reader.read_int()
        else:
            _top_msg_id = None
        return cls(q=_q, top_msg_id=_top_msg_id)


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantsRecent(TLObject):
    """
    Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xde3f3c79
    SUBCLASS_OF_ID = 0xbf4e2753

    def _bytes(self):
        return b''.join((
            b'y<?\xde',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ChannelParticipantsSearch(TLObject):
    """
    Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
    """
    __slots__ = ('q',)
    CONSTRUCTOR_ID = 0x656ac4b
    SUBCLASS_OF_ID = 0xbf4e2753

    q: str
    def __init__(self, q: str):
        object.__setattr__(self, 'q', q)

    def _bytes(self):
        return b''.join((
            b'K\xacV\x06',
            self._serialize_bytes(self.q),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _q = reader.tgread_string()
        return cls(q=_q)


@dataclasses.dataclass(init=False, frozen=True)
class Chat(TLObject):
    """
    Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
    """
    __slots__ = ('id', 'title', 'photo', 'participants_count', 'date', 'version', 'creator', 'kicked', 'left', 'deactivated', 'call_active', 'call_not_empty', 'noforwards', 'migrated_to', 'admin_rights', 'default_banned_rights',)
    CONSTRUCTOR_ID = 0x41cbf256
    SUBCLASS_OF_ID = 0xc5af5d94

    id: int
    title: str
    photo: 'TypeChatPhoto'
    participants_count: int
    date: Optional[datetime]
    version: int
    creator: Optional[bool]
    kicked: Optional[bool]
    left: Optional[bool]
    deactivated: Optional[bool]
    call_active: Optional[bool]
    call_not_empty: Optional[bool]
    noforwards: Optional[bool]
    migrated_to: Optional['TypeInputChannel']
    admin_rights: Optional['TypeChatAdminRights']
    default_banned_rights: Optional['TypeChatBannedRights']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str, photo: 'TypeChatPhoto', participants_count: int, date: Optional[datetime], version: int, creator: Optional[bool]=None, kicked: Optional[bool]=None, left: Optional[bool]=None, deactivated: Optional[bool]=None, call_active: Optional[bool]=None, call_not_empty: Optional[bool]=None, noforwards: Optional[bool]=None, migrated_to: Optional['TypeInputChannel']=None, admin_rights: Optional['TypeChatAdminRights']=None, default_banned_rights: Optional['TypeChatBannedRights']=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'photo', photo)
        object.__setattr__(self, 'participants_count', participants_count)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'version', version)
        object.__setattr__(self, 'creator', creator)
        object.__setattr__(self, 'kicked', kicked)
        object.__setattr__(self, 'left', left)
        object.__setattr__(self, 'deactivated', deactivated)
        object.__setattr__(self, 'call_active', call_active)
        object.__setattr__(self, 'call_not_empty', call_not_empty)
        object.__setattr__(self, 'noforwards', noforwards)
        object.__setattr__(self, 'migrated_to', migrated_to)
        object.__setattr__(self, 'admin_rights', admin_rights)
        object.__setattr__(self, 'default_banned_rights', default_banned_rights)

    def _bytes(self):
        return b''.join((
            b'V\xf2\xcbA',
            struct.pack('<I', (0 if self.creator is None or self.creator is False else 1) | (0 if self.kicked is None or self.kicked is False else 2) | (0 if self.left is None or self.left is False else 4) | (0 if self.deactivated is None or self.deactivated is False else 32) | (0 if self.call_active is None or self.call_active is False else 8388608) | (0 if self.call_not_empty is None or self.call_not_empty is False else 16777216) | (0 if self.noforwards is None or self.noforwards is False else 33554432) | (0 if self.migrated_to is None or self.migrated_to is False else 64) | (0 if self.admin_rights is None or self.admin_rights is False else 16384) | (0 if self.default_banned_rights is None or self.default_banned_rights is False else 262144)),
            struct.pack('<q', self.id),
            self._serialize_bytes(self.title),
            self.photo._bytes(),
            struct.pack('<i', self.participants_count),
            self._serialize_datetime(self.date),
            struct.pack('<i', self.version),
            b'' if self.migrated_to is None or self.migrated_to is False else (self.migrated_to._bytes()),
            b'' if self.admin_rights is None or self.admin_rights is False else (self.admin_rights._bytes()),
            b'' if self.default_banned_rights is None or self.default_banned_rights is False else (self.default_banned_rights._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _creator = bool(flags & 1)
        _kicked = bool(flags & 2)
        _left = bool(flags & 4)
        _deactivated = bool(flags & 32)
        _call_active = bool(flags & 8388608)
        _call_not_empty = bool(flags & 16777216)
        _noforwards = bool(flags & 33554432)
        _id = reader.read_long()
        _title = reader.tgread_string()
        _photo = reader.tgread_object()
        _participants_count = reader.read_int()
        _date = reader.tgread_date()
        _version = reader.read_int()
        if flags & 64:
            _migrated_to = reader.tgread_object()
        else:
            _migrated_to = None
        if flags & 16384:
            _admin_rights = reader.tgread_object()
        else:
            _admin_rights = None
        if flags & 262144:
            _default_banned_rights = reader.tgread_object()
        else:
            _default_banned_rights = None
        return cls(id=_id, title=_title, photo=_photo, participants_count=_participants_count, date=_date, version=_version, creator=_creator, kicked=_kicked, left=_left, deactivated=_deactivated, call_active=_call_active, call_not_empty=_call_not_empty, noforwards=_noforwards, migrated_to=_migrated_to, admin_rights=_admin_rights, default_banned_rights=_default_banned_rights)


@dataclasses.dataclass(init=False, frozen=True)
class ChatAdminRights(TLObject):
    """
    Constructor for ChatAdminRights: Instance of ChatAdminRights.
    """
    __slots__ = ('change_info', 'post_messages', 'edit_messages', 'delete_messages', 'ban_users', 'invite_users', 'pin_messages', 'add_admins', 'anonymous', 'manage_call', 'other',)
    CONSTRUCTOR_ID = 0x5fb224d5
    SUBCLASS_OF_ID = 0x863dc7c4

    change_info: Optional[bool]
    post_messages: Optional[bool]
    edit_messages: Optional[bool]
    delete_messages: Optional[bool]
    ban_users: Optional[bool]
    invite_users: Optional[bool]
    pin_messages: Optional[bool]
    add_admins: Optional[bool]
    anonymous: Optional[bool]
    manage_call: Optional[bool]
    other: Optional[bool]
    def __init__(self, change_info: Optional[bool]=None, post_messages: Optional[bool]=None, edit_messages: Optional[bool]=None, delete_messages: Optional[bool]=None, ban_users: Optional[bool]=None, invite_users: Optional[bool]=None, pin_messages: Optional[bool]=None, add_admins: Optional[bool]=None, anonymous: Optional[bool]=None, manage_call: Optional[bool]=None, other: Optional[bool]=None):
        object.__setattr__(self, 'change_info', change_info)
        object.__setattr__(self, 'post_messages', post_messages)
        object.__setattr__(self, 'edit_messages', edit_messages)
        object.__setattr__(self, 'delete_messages', delete_messages)
        object.__setattr__(self, 'ban_users', ban_users)
        object.__setattr__(self, 'invite_users', invite_users)
        object.__setattr__(self, 'pin_messages', pin_messages)
        object.__setattr__(self, 'add_admins', add_admins)
        object.__setattr__(self, 'anonymous', anonymous)
        object.__setattr__(self, 'manage_call', manage_call)
        object.__setattr__(self, 'other', other)

    def _bytes(self):
        return b''.join((
            b'\xd5$\xb2_',
            struct.pack('<I', (0 if self.change_info is None or self.change_info is False else 1) | (0 if self.post_messages is None or self.post_messages is False else 2) | (0 if self.edit_messages is None or self.edit_messages is False else 4) | (0 if self.delete_messages is None or self.delete_messages is False else 8) | (0 if self.ban_users is None or self.ban_users is False else 16) | (0 if self.invite_users is None or self.invite_users is False else 32) | (0 if self.pin_messages is None or self.pin_messages is False else 128) | (0 if self.add_admins is None or self.add_admins is False else 512) | (0 if self.anonymous is None or self.anonymous is False else 1024) | (0 if self.manage_call is None or self.manage_call is False else 2048) | (0 if self.other is None or self.other is False else 4096)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _change_info = bool(flags & 1)
        _post_messages = bool(flags & 2)
        _edit_messages = bool(flags & 4)
        _delete_messages = bool(flags & 8)
        _ban_users = bool(flags & 16)
        _invite_users = bool(flags & 32)
        _pin_messages = bool(flags & 128)
        _add_admins = bool(flags & 512)
        _anonymous = bool(flags & 1024)
        _manage_call = bool(flags & 2048)
        _other = bool(flags & 4096)
        return cls(change_info=_change_info, post_messages=_post_messages, edit_messages=_edit_messages, delete_messages=_delete_messages, ban_users=_ban_users, invite_users=_invite_users, pin_messages=_pin_messages, add_admins=_add_admins, anonymous=_anonymous, manage_call=_manage_call, other=_other)


@dataclasses.dataclass(init=False, frozen=True)
class ChatAdminWithInvites(TLObject):
    """
    Constructor for ChatAdminWithInvites: Instance of ChatAdminWithInvites.
    """
    __slots__ = ('admin_id', 'invites_count', 'revoked_invites_count',)
    CONSTRUCTOR_ID = 0xf2ecef23
    SUBCLASS_OF_ID = 0x5063f398

    admin_id: int
    invites_count: int
    revoked_invites_count: int
    def __init__(self, admin_id: int, invites_count: int, revoked_invites_count: int):
        object.__setattr__(self, 'admin_id', admin_id)
        object.__setattr__(self, 'invites_count', invites_count)
        object.__setattr__(self, 'revoked_invites_count', revoked_invites_count)

    def _bytes(self):
        return b''.join((
            b'#\xef\xec\xf2',
            struct.pack('<q', self.admin_id),
            struct.pack('<i', self.invites_count),
            struct.pack('<i', self.revoked_invites_count),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _admin_id = reader.read_long()
        _invites_count = reader.read_int()
        _revoked_invites_count = reader.read_int()
        return cls(admin_id=_admin_id, invites_count=_invites_count, revoked_invites_count=_revoked_invites_count)


@dataclasses.dataclass(init=False, frozen=True)
class ChatBannedRights(TLObject):
    """
    Constructor for ChatBannedRights: Instance of ChatBannedRights.
    """
    __slots__ = ('until_date', 'view_messages', 'send_messages', 'send_media', 'send_stickers', 'send_gifs', 'send_games', 'send_inline', 'embed_links', 'send_polls', 'change_info', 'invite_users', 'pin_messages',)
    CONSTRUCTOR_ID = 0x9f120418
    SUBCLASS_OF_ID = 0x4b5445a9

    until_date: Optional[datetime]
    view_messages: Optional[bool]
    send_messages: Optional[bool]
    send_media: Optional[bool]
    send_stickers: Optional[bool]
    send_gifs: Optional[bool]
    send_games: Optional[bool]
    send_inline: Optional[bool]
    embed_links: Optional[bool]
    send_polls: Optional[bool]
    change_info: Optional[bool]
    invite_users: Optional[bool]
    pin_messages: Optional[bool]
    def __init__(self, until_date: Optional[datetime], view_messages: Optional[bool]=None, send_messages: Optional[bool]=None, send_media: Optional[bool]=None, send_stickers: Optional[bool]=None, send_gifs: Optional[bool]=None, send_games: Optional[bool]=None, send_inline: Optional[bool]=None, embed_links: Optional[bool]=None, send_polls: Optional[bool]=None, change_info: Optional[bool]=None, invite_users: Optional[bool]=None, pin_messages: Optional[bool]=None):
        object.__setattr__(self, 'until_date', until_date)
        object.__setattr__(self, 'view_messages', view_messages)
        object.__setattr__(self, 'send_messages', send_messages)
        object.__setattr__(self, 'send_media', send_media)
        object.__setattr__(self, 'send_stickers', send_stickers)
        object.__setattr__(self, 'send_gifs', send_gifs)
        object.__setattr__(self, 'send_games', send_games)
        object.__setattr__(self, 'send_inline', send_inline)
        object.__setattr__(self, 'embed_links', embed_links)
        object.__setattr__(self, 'send_polls', send_polls)
        object.__setattr__(self, 'change_info', change_info)
        object.__setattr__(self, 'invite_users', invite_users)
        object.__setattr__(self, 'pin_messages', pin_messages)

    def _bytes(self):
        return b''.join((
            b'\x18\x04\x12\x9f',
            struct.pack('<I', (0 if self.view_messages is None or self.view_messages is False else 1) | (0 if self.send_messages is None or self.send_messages is False else 2) | (0 if self.send_media is None or self.send_media is False else 4) | (0 if self.send_stickers is None or self.send_stickers is False else 8) | (0 if self.send_gifs is None or self.send_gifs is False else 16) | (0 if self.send_games is None or self.send_games is False else 32) | (0 if self.send_inline is None or self.send_inline is False else 64) | (0 if self.embed_links is None or self.embed_links is False else 128) | (0 if self.send_polls is None or self.send_polls is False else 256) | (0 if self.change_info is None or self.change_info is False else 1024) | (0 if self.invite_users is None or self.invite_users is False else 32768) | (0 if self.pin_messages is None or self.pin_messages is False else 131072)),
            self._serialize_datetime(self.until_date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _view_messages = bool(flags & 1)
        _send_messages = bool(flags & 2)
        _send_media = bool(flags & 4)
        _send_stickers = bool(flags & 8)
        _send_gifs = bool(flags & 16)
        _send_games = bool(flags & 32)
        _send_inline = bool(flags & 64)
        _embed_links = bool(flags & 128)
        _send_polls = bool(flags & 256)
        _change_info = bool(flags & 1024)
        _invite_users = bool(flags & 32768)
        _pin_messages = bool(flags & 131072)
        _until_date = reader.tgread_date()
        return cls(until_date=_until_date, view_messages=_view_messages, send_messages=_send_messages, send_media=_send_media, send_stickers=_send_stickers, send_gifs=_send_gifs, send_games=_send_games, send_inline=_send_inline, embed_links=_embed_links, send_polls=_send_polls, change_info=_change_info, invite_users=_invite_users, pin_messages=_pin_messages)


@dataclasses.dataclass(init=False, frozen=True)
class ChatEmpty(TLObject):
    """
    Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x29562865
    SUBCLASS_OF_ID = 0xc5af5d94

    id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'e(V)',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class ChatForbidden(TLObject):
    """
    Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
    """
    __slots__ = ('id', 'title',)
    CONSTRUCTOR_ID = 0x6592a1a7
    SUBCLASS_OF_ID = 0xc5af5d94

    id: int
    title: str
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'title', title)

    def _bytes(self):
        return b''.join((
            b'\xa7\xa1\x92e',
            struct.pack('<q', self.id),
            self._serialize_bytes(self.title),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _title = reader.tgread_string()
        return cls(id=_id, title=_title)


@dataclasses.dataclass(init=False, frozen=True)
class ChatFull(TLObject):
    """
    Constructor for ChatFull: Instance of either ChatFull, ChannelFull.
    """
    __slots__ = ('id', 'about', 'participants', 'notify_settings', 'can_set_username', 'has_scheduled', 'chat_photo', 'exported_invite', 'bot_info', 'pinned_msg_id', 'folder_id', 'call', 'ttl_period', 'groupcall_default_join_as', 'theme_emoticon', 'requests_pending', 'recent_requesters', 'available_reactions',)
    CONSTRUCTOR_ID = 0xd18ee226
    SUBCLASS_OF_ID = 0xd49a2697

    id: int
    about: str
    participants: 'TypeChatParticipants'
    notify_settings: 'TypePeerNotifySettings'
    can_set_username: Optional[bool]
    has_scheduled: Optional[bool]
    chat_photo: Optional['TypePhoto']
    exported_invite: Optional['TypeExportedChatInvite']
    bot_info: Optional[List['TypeBotInfo']]
    pinned_msg_id: Optional[int]
    folder_id: Optional[int]
    call: Optional['TypeInputGroupCall']
    ttl_period: Optional[int]
    groupcall_default_join_as: Optional['TypePeer']
    theme_emoticon: Optional[str]
    requests_pending: Optional[int]
    recent_requesters: Optional[List[int]]
    available_reactions: Optional[List[str]]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, about: str, participants: 'TypeChatParticipants', notify_settings: 'TypePeerNotifySettings', can_set_username: Optional[bool]=None, has_scheduled: Optional[bool]=None, chat_photo: Optional['TypePhoto']=None, exported_invite: Optional['TypeExportedChatInvite']=None, bot_info: Optional[List['TypeBotInfo']]=None, pinned_msg_id: Optional[int]=None, folder_id: Optional[int]=None, call: Optional['TypeInputGroupCall']=None, ttl_period: Optional[int]=None, groupcall_default_join_as: Optional['TypePeer']=None, theme_emoticon: Optional[str]=None, requests_pending: Optional[int]=None, recent_requesters: Optional[List[int]]=None, available_reactions: Optional[List[str]]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'about', about)
        object.__setattr__(self, 'participants', participants)
        object.__setattr__(self, 'notify_settings', notify_settings)
        object.__setattr__(self, 'can_set_username', can_set_username)
        object.__setattr__(self, 'has_scheduled', has_scheduled)
        object.__setattr__(self, 'chat_photo', chat_photo)
        object.__setattr__(self, 'exported_invite', exported_invite)
        object.__setattr__(self, 'bot_info', bot_info)
        object.__setattr__(self, 'pinned_msg_id', pinned_msg_id)
        object.__setattr__(self, 'folder_id', folder_id)
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'ttl_period', ttl_period)
        object.__setattr__(self, 'groupcall_default_join_as', groupcall_default_join_as)
        object.__setattr__(self, 'theme_emoticon', theme_emoticon)
        object.__setattr__(self, 'requests_pending', requests_pending)
        object.__setattr__(self, 'recent_requesters', recent_requesters)
        object.__setattr__(self, 'available_reactions', available_reactions)

    def _bytes(self):
        assert ((self.requests_pending or self.requests_pending is not None) and (self.recent_requesters or self.recent_requesters is not None)) or ((self.requests_pending is None or self.requests_pending is False) and (self.recent_requesters is None or self.recent_requesters is False)), 'requests_pending, recent_requesters parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'&\xe2\x8e\xd1',
            struct.pack('<I', (0 if self.can_set_username is None or self.can_set_username is False else 128) | (0 if self.has_scheduled is None or self.has_scheduled is False else 256) | (0 if self.chat_photo is None or self.chat_photo is False else 4) | (0 if self.exported_invite is None or self.exported_invite is False else 8192) | (0 if self.bot_info is None or self.bot_info is False else 8) | (0 if self.pinned_msg_id is None or self.pinned_msg_id is False else 64) | (0 if self.folder_id is None or self.folder_id is False else 2048) | (0 if self.call is None or self.call is False else 4096) | (0 if self.ttl_period is None or self.ttl_period is False else 16384) | (0 if self.groupcall_default_join_as is None or self.groupcall_default_join_as is False else 32768) | (0 if self.theme_emoticon is None or self.theme_emoticon is False else 65536) | (0 if self.requests_pending is None or self.requests_pending is False else 131072) | (0 if self.recent_requesters is None or self.recent_requesters is False else 131072) | (0 if self.available_reactions is None or self.available_reactions is False else 262144)),
            struct.pack('<q', self.id),
            self._serialize_bytes(self.about),
            self.participants._bytes(),
            b'' if self.chat_photo is None or self.chat_photo is False else (self.chat_photo._bytes()),
            self.notify_settings._bytes(),
            b'' if self.exported_invite is None or self.exported_invite is False else (self.exported_invite._bytes()),
            b'' if self.bot_info is None or self.bot_info is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.bot_info)),b''.join(x._bytes() for x in self.bot_info))),
            b'' if self.pinned_msg_id is None or self.pinned_msg_id is False else (struct.pack('<i', self.pinned_msg_id)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            b'' if self.call is None or self.call is False else (self.call._bytes()),
            b'' if self.ttl_period is None or self.ttl_period is False else (struct.pack('<i', self.ttl_period)),
            b'' if self.groupcall_default_join_as is None or self.groupcall_default_join_as is False else (self.groupcall_default_join_as._bytes()),
            b'' if self.theme_emoticon is None or self.theme_emoticon is False else (self._serialize_bytes(self.theme_emoticon)),
            b'' if self.requests_pending is None or self.requests_pending is False else (struct.pack('<i', self.requests_pending)),
            b'' if self.recent_requesters is None or self.recent_requesters is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.recent_requesters)),b''.join(struct.pack('<q', x) for x in self.recent_requesters))),
            b'' if self.available_reactions is None or self.available_reactions is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.available_reactions)),b''.join(self._serialize_bytes(x) for x in self.available_reactions))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _can_set_username = bool(flags & 128)
        _has_scheduled = bool(flags & 256)
        _id = reader.read_long()
        _about = reader.tgread_string()
        _participants = reader.tgread_object()
        if flags & 4:
            _chat_photo = reader.tgread_object()
        else:
            _chat_photo = None
        _notify_settings = reader.tgread_object()
        if flags & 8192:
            _exported_invite = reader.tgread_object()
        else:
            _exported_invite = None
        if flags & 8:
            reader.read_int()
            _bot_info = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _bot_info.append(_x)

        else:
            _bot_info = None
        if flags & 64:
            _pinned_msg_id = reader.read_int()
        else:
            _pinned_msg_id = None
        if flags & 2048:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        if flags & 4096:
            _call = reader.tgread_object()
        else:
            _call = None
        if flags & 16384:
            _ttl_period = reader.read_int()
        else:
            _ttl_period = None
        if flags & 32768:
            _groupcall_default_join_as = reader.tgread_object()
        else:
            _groupcall_default_join_as = None
        if flags & 65536:
            _theme_emoticon = reader.tgread_string()
        else:
            _theme_emoticon = None
        if flags & 131072:
            _requests_pending = reader.read_int()
        else:
            _requests_pending = None
        if flags & 131072:
            reader.read_int()
            _recent_requesters = []
            for _ in range(reader.read_int()):
                _x = reader.read_long()
                _recent_requesters.append(_x)

        else:
            _recent_requesters = None
        if flags & 262144:
            reader.read_int()
            _available_reactions = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_string()
                _available_reactions.append(_x)

        else:
            _available_reactions = None
        return cls(id=_id, about=_about, participants=_participants, notify_settings=_notify_settings, can_set_username=_can_set_username, has_scheduled=_has_scheduled, chat_photo=_chat_photo, exported_invite=_exported_invite, bot_info=_bot_info, pinned_msg_id=_pinned_msg_id, folder_id=_folder_id, call=_call, ttl_period=_ttl_period, groupcall_default_join_as=_groupcall_default_join_as, theme_emoticon=_theme_emoticon, requests_pending=_requests_pending, recent_requesters=_recent_requesters, available_reactions=_available_reactions)


@dataclasses.dataclass(init=False, frozen=True)
class ChatInvite(TLObject):
    """
    Constructor for ChatInvite: Instance of either ChatInviteAlready, ChatInvite, ChatInvitePeek.
    """
    __slots__ = ('title', 'photo', 'participants_count', 'channel', 'broadcast', 'public', 'megagroup', 'request_needed', 'about', 'participants',)
    CONSTRUCTOR_ID = 0x300c44c1
    SUBCLASS_OF_ID = 0x4561736

    title: str
    photo: 'TypePhoto'
    participants_count: int
    channel: Optional[bool]
    broadcast: Optional[bool]
    public: Optional[bool]
    megagroup: Optional[bool]
    request_needed: Optional[bool]
    about: Optional[str]
    participants: Optional[List['TypeUser']]
    def __init__(self, title: str, photo: 'TypePhoto', participants_count: int, channel: Optional[bool]=None, broadcast: Optional[bool]=None, public: Optional[bool]=None, megagroup: Optional[bool]=None, request_needed: Optional[bool]=None, about: Optional[str]=None, participants: Optional[List['TypeUser']]=None):
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'photo', photo)
        object.__setattr__(self, 'participants_count', participants_count)
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'broadcast', broadcast)
        object.__setattr__(self, 'public', public)
        object.__setattr__(self, 'megagroup', megagroup)
        object.__setattr__(self, 'request_needed', request_needed)
        object.__setattr__(self, 'about', about)
        object.__setattr__(self, 'participants', participants)

    def _bytes(self):
        return b''.join((
            b'\xc1D\x0c0',
            struct.pack('<I', (0 if self.channel is None or self.channel is False else 1) | (0 if self.broadcast is None or self.broadcast is False else 2) | (0 if self.public is None or self.public is False else 4) | (0 if self.megagroup is None or self.megagroup is False else 8) | (0 if self.request_needed is None or self.request_needed is False else 64) | (0 if self.about is None or self.about is False else 32) | (0 if self.participants is None or self.participants is False else 16)),
            self._serialize_bytes(self.title),
            b'' if self.about is None or self.about is False else (self._serialize_bytes(self.about)),
            self.photo._bytes(),
            struct.pack('<i', self.participants_count),
            b'' if self.participants is None or self.participants is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.participants)),b''.join(x._bytes() for x in self.participants))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _channel = bool(flags & 1)
        _broadcast = bool(flags & 2)
        _public = bool(flags & 4)
        _megagroup = bool(flags & 8)
        _request_needed = bool(flags & 64)
        _title = reader.tgread_string()
        if flags & 32:
            _about = reader.tgread_string()
        else:
            _about = None
        _photo = reader.tgread_object()
        _participants_count = reader.read_int()
        if flags & 16:
            reader.read_int()
            _participants = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _participants.append(_x)

        else:
            _participants = None
        return cls(title=_title, photo=_photo, participants_count=_participants_count, channel=_channel, broadcast=_broadcast, public=_public, megagroup=_megagroup, request_needed=_request_needed, about=_about, participants=_participants)


@dataclasses.dataclass(init=False, frozen=True)
class ChatInviteAlready(TLObject):
    """
    Constructor for ChatInvite: Instance of either ChatInviteAlready, ChatInvite, ChatInvitePeek.
    """
    __slots__ = ('chat',)
    CONSTRUCTOR_ID = 0x5a686d7c
    SUBCLASS_OF_ID = 0x4561736

    chat: 'TypeChat'
    def __init__(self, chat: 'TypeChat'):
        object.__setattr__(self, 'chat', chat)

    def _bytes(self):
        return b''.join((
            b'|mhZ',
            self.chat._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat = reader.tgread_object()
        return cls(chat=_chat)


@dataclasses.dataclass(init=False, frozen=True)
class ChatInviteExported(TLObject):
    """
    Constructor for ExportedChatInvite: Instance of ChatInviteExported.
    """
    __slots__ = ('link', 'admin_id', 'date', 'revoked', 'permanent', 'request_needed', 'start_date', 'expire_date', 'usage_limit', 'usage', 'requested', 'title',)
    CONSTRUCTOR_ID = 0xab4a819
    SUBCLASS_OF_ID = 0xb4748a58

    link: str
    admin_id: int
    date: Optional[datetime]
    revoked: Optional[bool]
    permanent: Optional[bool]
    request_needed: Optional[bool]
    start_date: Optional[datetime]
    expire_date: Optional[datetime]
    usage_limit: Optional[int]
    usage: Optional[int]
    requested: Optional[int]
    title: Optional[str]
    def __init__(self, link: str, admin_id: int, date: Optional[datetime], revoked: Optional[bool]=None, permanent: Optional[bool]=None, request_needed: Optional[bool]=None, start_date: Optional[datetime]=None, expire_date: Optional[datetime]=None, usage_limit: Optional[int]=None, usage: Optional[int]=None, requested: Optional[int]=None, title: Optional[str]=None):
        object.__setattr__(self, 'link', link)
        object.__setattr__(self, 'admin_id', admin_id)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'revoked', revoked)
        object.__setattr__(self, 'permanent', permanent)
        object.__setattr__(self, 'request_needed', request_needed)
        object.__setattr__(self, 'start_date', start_date)
        object.__setattr__(self, 'expire_date', expire_date)
        object.__setattr__(self, 'usage_limit', usage_limit)
        object.__setattr__(self, 'usage', usage)
        object.__setattr__(self, 'requested', requested)
        object.__setattr__(self, 'title', title)

    def _bytes(self):
        return b''.join((
            b'\x19\xa8\xb4\n',
            struct.pack('<I', (0 if self.revoked is None or self.revoked is False else 1) | (0 if self.permanent is None or self.permanent is False else 32) | (0 if self.request_needed is None or self.request_needed is False else 64) | (0 if self.start_date is None or self.start_date is False else 16) | (0 if self.expire_date is None or self.expire_date is False else 2) | (0 if self.usage_limit is None or self.usage_limit is False else 4) | (0 if self.usage is None or self.usage is False else 8) | (0 if self.requested is None or self.requested is False else 128) | (0 if self.title is None or self.title is False else 256)),
            self._serialize_bytes(self.link),
            struct.pack('<q', self.admin_id),
            self._serialize_datetime(self.date),
            b'' if self.start_date is None or self.start_date is False else (self._serialize_datetime(self.start_date)),
            b'' if self.expire_date is None or self.expire_date is False else (self._serialize_datetime(self.expire_date)),
            b'' if self.usage_limit is None or self.usage_limit is False else (struct.pack('<i', self.usage_limit)),
            b'' if self.usage is None or self.usage is False else (struct.pack('<i', self.usage)),
            b'' if self.requested is None or self.requested is False else (struct.pack('<i', self.requested)),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _revoked = bool(flags & 1)
        _permanent = bool(flags & 32)
        _request_needed = bool(flags & 64)
        _link = reader.tgread_string()
        _admin_id = reader.read_long()
        _date = reader.tgread_date()
        if flags & 16:
            _start_date = reader.tgread_date()
        else:
            _start_date = None
        if flags & 2:
            _expire_date = reader.tgread_date()
        else:
            _expire_date = None
        if flags & 4:
            _usage_limit = reader.read_int()
        else:
            _usage_limit = None
        if flags & 8:
            _usage = reader.read_int()
        else:
            _usage = None
        if flags & 128:
            _requested = reader.read_int()
        else:
            _requested = None
        if flags & 256:
            _title = reader.tgread_string()
        else:
            _title = None
        return cls(link=_link, admin_id=_admin_id, date=_date, revoked=_revoked, permanent=_permanent, request_needed=_request_needed, start_date=_start_date, expire_date=_expire_date, usage_limit=_usage_limit, usage=_usage, requested=_requested, title=_title)


@dataclasses.dataclass(init=False, frozen=True)
class ChatInviteImporter(TLObject):
    """
    Constructor for ChatInviteImporter: Instance of ChatInviteImporter.
    """
    __slots__ = ('user_id', 'date', 'requested', 'about', 'approved_by',)
    CONSTRUCTOR_ID = 0x8c5adfd9
    SUBCLASS_OF_ID = 0x5312542e

    user_id: int
    date: Optional[datetime]
    requested: Optional[bool]
    about: Optional[str]
    approved_by: Optional[int]
    def __init__(self, user_id: int, date: Optional[datetime], requested: Optional[bool]=None, about: Optional[str]=None, approved_by: Optional[int]=None):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'requested', requested)
        object.__setattr__(self, 'about', about)
        object.__setattr__(self, 'approved_by', approved_by)

    def _bytes(self):
        return b''.join((
            b'\xd9\xdfZ\x8c',
            struct.pack('<I', (0 if self.requested is None or self.requested is False else 1) | (0 if self.about is None or self.about is False else 4) | (0 if self.approved_by is None or self.approved_by is False else 2)),
            struct.pack('<q', self.user_id),
            self._serialize_datetime(self.date),
            b'' if self.about is None or self.about is False else (self._serialize_bytes(self.about)),
            b'' if self.approved_by is None or self.approved_by is False else (struct.pack('<q', self.approved_by)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _requested = bool(flags & 1)
        _user_id = reader.read_long()
        _date = reader.tgread_date()
        if flags & 4:
            _about = reader.tgread_string()
        else:
            _about = None
        if flags & 2:
            _approved_by = reader.read_long()
        else:
            _approved_by = None
        return cls(user_id=_user_id, date=_date, requested=_requested, about=_about, approved_by=_approved_by)


@dataclasses.dataclass(init=False, frozen=True)
class ChatInvitePeek(TLObject):
    """
    Constructor for ChatInvite: Instance of either ChatInviteAlready, ChatInvite, ChatInvitePeek.
    """
    __slots__ = ('chat', 'expires',)
    CONSTRUCTOR_ID = 0x61695cb0
    SUBCLASS_OF_ID = 0x4561736

    chat: 'TypeChat'
    expires: Optional[datetime]
    def __init__(self, chat: 'TypeChat', expires: Optional[datetime]):
        object.__setattr__(self, 'chat', chat)
        object.__setattr__(self, 'expires', expires)

    def _bytes(self):
        return b''.join((
            b'\xb0\\ia',
            self.chat._bytes(),
            self._serialize_datetime(self.expires),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat = reader.tgread_object()
        _expires = reader.tgread_date()
        return cls(chat=_chat, expires=_expires)


@dataclasses.dataclass(init=False, frozen=True)
class ChatOnlines(TLObject):
    """
    Constructor for ChatOnlines: Instance of ChatOnlines.
    """
    __slots__ = ('onlines',)
    CONSTRUCTOR_ID = 0xf041e250
    SUBCLASS_OF_ID = 0x8c81903a

    onlines: int
    def __init__(self, onlines: int):
        object.__setattr__(self, 'onlines', onlines)

    def _bytes(self):
        return b''.join((
            b'P\xe2A\xf0',
            struct.pack('<i', self.onlines),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _onlines = reader.read_int()
        return cls(onlines=_onlines)


@dataclasses.dataclass(init=False, frozen=True)
class ChatParticipant(TLObject):
    """
    Constructor for ChatParticipant: Instance of either ChatParticipant, ChatParticipantCreator, ChatParticipantAdmin.
    """
    __slots__ = ('user_id', 'inviter_id', 'date',)
    CONSTRUCTOR_ID = 0xc02d4007
    SUBCLASS_OF_ID = 0x7d7c6f86

    user_id: int
    inviter_id: int
    date: Optional[datetime]
    def __init__(self, user_id: int, inviter_id: int, date: Optional[datetime]):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'inviter_id', inviter_id)
        object.__setattr__(self, 'date', date)

    def _bytes(self):
        return b''.join((
            b'\x07@-\xc0',
            struct.pack('<q', self.user_id),
            struct.pack('<q', self.inviter_id),
            self._serialize_datetime(self.date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _inviter_id = reader.read_long()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, inviter_id=_inviter_id, date=_date)


@dataclasses.dataclass(init=False, frozen=True)
class ChatParticipantAdmin(TLObject):
    """
    Constructor for ChatParticipant: Instance of either ChatParticipant, ChatParticipantCreator, ChatParticipantAdmin.
    """
    __slots__ = ('user_id', 'inviter_id', 'date',)
    CONSTRUCTOR_ID = 0xa0933f5b
    SUBCLASS_OF_ID = 0x7d7c6f86

    user_id: int
    inviter_id: int
    date: Optional[datetime]
    def __init__(self, user_id: int, inviter_id: int, date: Optional[datetime]):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'inviter_id', inviter_id)
        object.__setattr__(self, 'date', date)

    def _bytes(self):
        return b''.join((
            b'[?\x93\xa0',
            struct.pack('<q', self.user_id),
            struct.pack('<q', self.inviter_id),
            self._serialize_datetime(self.date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _inviter_id = reader.read_long()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, inviter_id=_inviter_id, date=_date)


@dataclasses.dataclass(init=False, frozen=True)
class ChatParticipantCreator(TLObject):
    """
    Constructor for ChatParticipant: Instance of either ChatParticipant, ChatParticipantCreator, ChatParticipantAdmin.
    """
    __slots__ = ('user_id',)
    CONSTRUCTOR_ID = 0xe46bcee4
    SUBCLASS_OF_ID = 0x7d7c6f86

    user_id: int
    def __init__(self, user_id: int):
        object.__setattr__(self, 'user_id', user_id)

    def _bytes(self):
        return b''.join((
            b'\xe4\xcek\xe4',
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        return cls(user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class ChatParticipants(TLObject):
    """
    Constructor for ChatParticipants: Instance of either ChatParticipantsForbidden, ChatParticipants.
    """
    __slots__ = ('chat_id', 'participants', 'version',)
    CONSTRUCTOR_ID = 0x3cbc93f8
    SUBCLASS_OF_ID = 0x1fa89571

    chat_id: int
    participants: List['TypeChatParticipant']
    version: int
    def __init__(self, chat_id: int, participants: List['TypeChatParticipant'], version: int):
        object.__setattr__(self, 'chat_id', chat_id)
        object.__setattr__(self, 'participants', participants)
        object.__setattr__(self, 'version', version)

    def _bytes(self):
        return b''.join((
            b'\xf8\x93\xbc<',
            struct.pack('<q', self.chat_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.participants)),b''.join(x._bytes() for x in self.participants),
            struct.pack('<i', self.version),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat_id = reader.read_long()
        reader.read_int()
        _participants = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _participants.append(_x)

        _version = reader.read_int()
        return cls(chat_id=_chat_id, participants=_participants, version=_version)


@dataclasses.dataclass(init=False, frozen=True)
class ChatParticipantsForbidden(TLObject):
    """
    Constructor for ChatParticipants: Instance of either ChatParticipantsForbidden, ChatParticipants.
    """
    __slots__ = ('chat_id', 'self_participant',)
    CONSTRUCTOR_ID = 0x8763d3e1
    SUBCLASS_OF_ID = 0x1fa89571

    chat_id: int
    self_participant: Optional['TypeChatParticipant']
    def __init__(self, chat_id: int, self_participant: Optional['TypeChatParticipant']=None):
        object.__setattr__(self, 'chat_id', chat_id)
        object.__setattr__(self, 'self_participant', self_participant)

    def _bytes(self):
        return b''.join((
            b'\xe1\xd3c\x87',
            struct.pack('<I', (0 if self.self_participant is None or self.self_participant is False else 1)),
            struct.pack('<q', self.chat_id),
            b'' if self.self_participant is None or self.self_participant is False else (self.self_participant._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _chat_id = reader.read_long()
        if flags & 1:
            _self_participant = reader.tgread_object()
        else:
            _self_participant = None
        return cls(chat_id=_chat_id, self_participant=_self_participant)


@dataclasses.dataclass(init=False, frozen=True)
class ChatPhoto(TLObject):
    """
    Constructor for ChatPhoto: Instance of either ChatPhotoEmpty, ChatPhoto.
    """
    __slots__ = ('photo_id', 'dc_id', 'has_video', 'stripped_thumb',)
    CONSTRUCTOR_ID = 0x1c6e1c11
    SUBCLASS_OF_ID = 0xac3ec4e5

    photo_id: int
    dc_id: int
    has_video: Optional[bool]
    stripped_thumb: Optional[bytes]
    def __init__(self, photo_id: int, dc_id: int, has_video: Optional[bool]=None, stripped_thumb: Optional[bytes]=None):
        object.__setattr__(self, 'photo_id', photo_id)
        object.__setattr__(self, 'dc_id', dc_id)
        object.__setattr__(self, 'has_video', has_video)
        object.__setattr__(self, 'stripped_thumb', stripped_thumb)

    def _bytes(self):
        return b''.join((
            b'\x11\x1cn\x1c',
            struct.pack('<I', (0 if self.has_video is None or self.has_video is False else 1) | (0 if self.stripped_thumb is None or self.stripped_thumb is False else 2)),
            struct.pack('<q', self.photo_id),
            b'' if self.stripped_thumb is None or self.stripped_thumb is False else (self._serialize_bytes(self.stripped_thumb)),
            struct.pack('<i', self.dc_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _has_video = bool(flags & 1)
        _photo_id = reader.read_long()
        if flags & 2:
            _stripped_thumb = reader.tgread_bytes()
        else:
            _stripped_thumb = None
        _dc_id = reader.read_int()
        return cls(photo_id=_photo_id, dc_id=_dc_id, has_video=_has_video, stripped_thumb=_stripped_thumb)


@dataclasses.dataclass(init=False, frozen=True)
class ChatPhotoEmpty(TLObject):
    """
    Constructor for ChatPhoto: Instance of either ChatPhotoEmpty, ChatPhoto.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x37c1011c
    SUBCLASS_OF_ID = 0xac3ec4e5

    def _bytes(self):
        return b''.join((
            b'\x1c\x01\xc17',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class ClientDHInnerData(TLObject):
    """
    Constructor for Client_DH_Inner_Data: Instance of ClientDHInnerData.
    """
    __slots__ = ('nonce', 'server_nonce', 'retry_id', 'g_b',)
    CONSTRUCTOR_ID = 0x6643b654
    SUBCLASS_OF_ID = 0xf8eeef6a

    nonce: int
    server_nonce: int
    retry_id: int
    g_b: bytes
    def __init__(self, nonce: int, server_nonce: int, retry_id: int, g_b: bytes):
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'server_nonce', server_nonce)
        object.__setattr__(self, 'retry_id', retry_id)
        object.__setattr__(self, 'g_b', g_b)

    def _bytes(self):
        return b''.join((
            b'T\xb6Cf',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            struct.pack('<q', self.retry_id),
            self._serialize_bytes(self.g_b),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _retry_id = reader.read_long()
        _g_b = reader.tgread_bytes()
        return cls(nonce=_nonce, server_nonce=_server_nonce, retry_id=_retry_id, g_b=_g_b)


@dataclasses.dataclass(init=False, frozen=True)
class CodeSettings(TLObject):
    """
    Constructor for CodeSettings: Instance of CodeSettings.
    """
    __slots__ = ('allow_flashcall', 'current_number', 'allow_app_hash', 'allow_missed_call', 'logout_tokens',)
    CONSTRUCTOR_ID = 0x8a6469c2
    SUBCLASS_OF_ID = 0x48edbc8a

    allow_flashcall: Optional[bool]
    current_number: Optional[bool]
    allow_app_hash: Optional[bool]
    allow_missed_call: Optional[bool]
    logout_tokens: Optional[List[bytes]]
    def __init__(self, allow_flashcall: Optional[bool]=None, current_number: Optional[bool]=None, allow_app_hash: Optional[bool]=None, allow_missed_call: Optional[bool]=None, logout_tokens: Optional[List[bytes]]=None):
        object.__setattr__(self, 'allow_flashcall', allow_flashcall)
        object.__setattr__(self, 'current_number', current_number)
        object.__setattr__(self, 'allow_app_hash', allow_app_hash)
        object.__setattr__(self, 'allow_missed_call', allow_missed_call)
        object.__setattr__(self, 'logout_tokens', logout_tokens)

    def _bytes(self):
        return b''.join((
            b'\xc2id\x8a',
            struct.pack('<I', (0 if self.allow_flashcall is None or self.allow_flashcall is False else 1) | (0 if self.current_number is None or self.current_number is False else 2) | (0 if self.allow_app_hash is None or self.allow_app_hash is False else 16) | (0 if self.allow_missed_call is None or self.allow_missed_call is False else 32) | (0 if self.logout_tokens is None or self.logout_tokens is False else 64)),
            b'' if self.logout_tokens is None or self.logout_tokens is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.logout_tokens)),b''.join(self._serialize_bytes(x) for x in self.logout_tokens))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _allow_flashcall = bool(flags & 1)
        _current_number = bool(flags & 2)
        _allow_app_hash = bool(flags & 16)
        _allow_missed_call = bool(flags & 32)
        if flags & 64:
            reader.read_int()
            _logout_tokens = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_bytes()
                _logout_tokens.append(_x)

        else:
            _logout_tokens = None
        return cls(allow_flashcall=_allow_flashcall, current_number=_current_number, allow_app_hash=_allow_app_hash, allow_missed_call=_allow_missed_call, logout_tokens=_logout_tokens)


@dataclasses.dataclass(init=False, frozen=True)
class Config(TLObject):
    """
    Constructor for Config: Instance of Config.
    """
    __slots__ = ('date', 'expires', 'test_mode', 'this_dc', 'dc_options', 'dc_txt_domain_name', 'chat_size_max', 'megagroup_size_max', 'forwarded_count_max', 'online_update_period_ms', 'offline_blur_timeout_ms', 'offline_idle_timeout_ms', 'online_cloud_timeout_ms', 'notify_cloud_delay_ms', 'notify_default_delay_ms', 'push_chat_period_ms', 'push_chat_limit', 'saved_gifs_limit', 'edit_time_limit', 'revoke_time_limit', 'revoke_pm_time_limit', 'rating_e_decay', 'stickers_recent_limit', 'stickers_faved_limit', 'channels_read_media_period', 'pinned_dialogs_count_max', 'pinned_infolder_count_max', 'call_receive_timeout_ms', 'call_ring_timeout_ms', 'call_connect_timeout_ms', 'call_packet_timeout_ms', 'me_url_prefix', 'caption_length_max', 'message_length_max', 'webfile_dc_id', 'phonecalls_enabled', 'default_p2p_contacts', 'preload_featured_stickers', 'ignore_phone_entities', 'revoke_pm_inbox', 'blocked_mode', 'pfs_enabled', 'tmp_sessions', 'autoupdate_url_prefix', 'gif_search_username', 'venue_search_username', 'img_search_username', 'static_maps_provider', 'suggested_lang_code', 'lang_pack_version', 'base_lang_pack_version',)
    CONSTRUCTOR_ID = 0x330b4067
    SUBCLASS_OF_ID = 0xd3262a4a

    date: Optional[datetime]
    expires: Optional[datetime]
    test_mode: bool
    this_dc: int
    dc_options: List['TypeDcOption']
    dc_txt_domain_name: str
    chat_size_max: int
    megagroup_size_max: int
    forwarded_count_max: int
    online_update_period_ms: int
    offline_blur_timeout_ms: int
    offline_idle_timeout_ms: int
    online_cloud_timeout_ms: int
    notify_cloud_delay_ms: int
    notify_default_delay_ms: int
    push_chat_period_ms: int
    push_chat_limit: int
    saved_gifs_limit: int
    edit_time_limit: int
    revoke_time_limit: int
    revoke_pm_time_limit: int
    rating_e_decay: int
    stickers_recent_limit: int
    stickers_faved_limit: int
    channels_read_media_period: int
    pinned_dialogs_count_max: int
    pinned_infolder_count_max: int
    call_receive_timeout_ms: int
    call_ring_timeout_ms: int
    call_connect_timeout_ms: int
    call_packet_timeout_ms: int
    me_url_prefix: str
    caption_length_max: int
    message_length_max: int
    webfile_dc_id: int
    phonecalls_enabled: Optional[bool]
    default_p2p_contacts: Optional[bool]
    preload_featured_stickers: Optional[bool]
    ignore_phone_entities: Optional[bool]
    revoke_pm_inbox: Optional[bool]
    blocked_mode: Optional[bool]
    pfs_enabled: Optional[bool]
    tmp_sessions: Optional[int]
    autoupdate_url_prefix: Optional[str]
    gif_search_username: Optional[str]
    venue_search_username: Optional[str]
    img_search_username: Optional[str]
    static_maps_provider: Optional[str]
    suggested_lang_code: Optional[str]
    lang_pack_version: Optional[int]
    base_lang_pack_version: Optional[int]
    def __init__(self, date: Optional[datetime], expires: Optional[datetime], test_mode: bool, this_dc: int, dc_options: List['TypeDcOption'], dc_txt_domain_name: str, chat_size_max: int, megagroup_size_max: int, forwarded_count_max: int, online_update_period_ms: int, offline_blur_timeout_ms: int, offline_idle_timeout_ms: int, online_cloud_timeout_ms: int, notify_cloud_delay_ms: int, notify_default_delay_ms: int, push_chat_period_ms: int, push_chat_limit: int, saved_gifs_limit: int, edit_time_limit: int, revoke_time_limit: int, revoke_pm_time_limit: int, rating_e_decay: int, stickers_recent_limit: int, stickers_faved_limit: int, channels_read_media_period: int, pinned_dialogs_count_max: int, pinned_infolder_count_max: int, call_receive_timeout_ms: int, call_ring_timeout_ms: int, call_connect_timeout_ms: int, call_packet_timeout_ms: int, me_url_prefix: str, caption_length_max: int, message_length_max: int, webfile_dc_id: int, phonecalls_enabled: Optional[bool]=None, default_p2p_contacts: Optional[bool]=None, preload_featured_stickers: Optional[bool]=None, ignore_phone_entities: Optional[bool]=None, revoke_pm_inbox: Optional[bool]=None, blocked_mode: Optional[bool]=None, pfs_enabled: Optional[bool]=None, tmp_sessions: Optional[int]=None, autoupdate_url_prefix: Optional[str]=None, gif_search_username: Optional[str]=None, venue_search_username: Optional[str]=None, img_search_username: Optional[str]=None, static_maps_provider: Optional[str]=None, suggested_lang_code: Optional[str]=None, lang_pack_version: Optional[int]=None, base_lang_pack_version: Optional[int]=None):
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'expires', expires)
        object.__setattr__(self, 'test_mode', test_mode)
        object.__setattr__(self, 'this_dc', this_dc)
        object.__setattr__(self, 'dc_options', dc_options)
        object.__setattr__(self, 'dc_txt_domain_name', dc_txt_domain_name)
        object.__setattr__(self, 'chat_size_max', chat_size_max)
        object.__setattr__(self, 'megagroup_size_max', megagroup_size_max)
        object.__setattr__(self, 'forwarded_count_max', forwarded_count_max)
        object.__setattr__(self, 'online_update_period_ms', online_update_period_ms)
        object.__setattr__(self, 'offline_blur_timeout_ms', offline_blur_timeout_ms)
        object.__setattr__(self, 'offline_idle_timeout_ms', offline_idle_timeout_ms)
        object.__setattr__(self, 'online_cloud_timeout_ms', online_cloud_timeout_ms)
        object.__setattr__(self, 'notify_cloud_delay_ms', notify_cloud_delay_ms)
        object.__setattr__(self, 'notify_default_delay_ms', notify_default_delay_ms)
        object.__setattr__(self, 'push_chat_period_ms', push_chat_period_ms)
        object.__setattr__(self, 'push_chat_limit', push_chat_limit)
        object.__setattr__(self, 'saved_gifs_limit', saved_gifs_limit)
        object.__setattr__(self, 'edit_time_limit', edit_time_limit)
        object.__setattr__(self, 'revoke_time_limit', revoke_time_limit)
        object.__setattr__(self, 'revoke_pm_time_limit', revoke_pm_time_limit)
        object.__setattr__(self, 'rating_e_decay', rating_e_decay)
        object.__setattr__(self, 'stickers_recent_limit', stickers_recent_limit)
        object.__setattr__(self, 'stickers_faved_limit', stickers_faved_limit)
        object.__setattr__(self, 'channels_read_media_period', channels_read_media_period)
        object.__setattr__(self, 'pinned_dialogs_count_max', pinned_dialogs_count_max)
        object.__setattr__(self, 'pinned_infolder_count_max', pinned_infolder_count_max)
        object.__setattr__(self, 'call_receive_timeout_ms', call_receive_timeout_ms)
        object.__setattr__(self, 'call_ring_timeout_ms', call_ring_timeout_ms)
        object.__setattr__(self, 'call_connect_timeout_ms', call_connect_timeout_ms)
        object.__setattr__(self, 'call_packet_timeout_ms', call_packet_timeout_ms)
        object.__setattr__(self, 'me_url_prefix', me_url_prefix)
        object.__setattr__(self, 'caption_length_max', caption_length_max)
        object.__setattr__(self, 'message_length_max', message_length_max)
        object.__setattr__(self, 'webfile_dc_id', webfile_dc_id)
        object.__setattr__(self, 'phonecalls_enabled', phonecalls_enabled)
        object.__setattr__(self, 'default_p2p_contacts', default_p2p_contacts)
        object.__setattr__(self, 'preload_featured_stickers', preload_featured_stickers)
        object.__setattr__(self, 'ignore_phone_entities', ignore_phone_entities)
        object.__setattr__(self, 'revoke_pm_inbox', revoke_pm_inbox)
        object.__setattr__(self, 'blocked_mode', blocked_mode)
        object.__setattr__(self, 'pfs_enabled', pfs_enabled)
        object.__setattr__(self, 'tmp_sessions', tmp_sessions)
        object.__setattr__(self, 'autoupdate_url_prefix', autoupdate_url_prefix)
        object.__setattr__(self, 'gif_search_username', gif_search_username)
        object.__setattr__(self, 'venue_search_username', venue_search_username)
        object.__setattr__(self, 'img_search_username', img_search_username)
        object.__setattr__(self, 'static_maps_provider', static_maps_provider)
        object.__setattr__(self, 'suggested_lang_code', suggested_lang_code)
        object.__setattr__(self, 'lang_pack_version', lang_pack_version)
        object.__setattr__(self, 'base_lang_pack_version', base_lang_pack_version)

    def _bytes(self):
        assert ((self.suggested_lang_code or self.suggested_lang_code is not None) and (self.lang_pack_version or self.lang_pack_version is not None) and (self.base_lang_pack_version or self.base_lang_pack_version is not None)) or ((self.suggested_lang_code is None or self.suggested_lang_code is False) and (self.lang_pack_version is None or self.lang_pack_version is False) and (self.base_lang_pack_version is None or self.base_lang_pack_version is False)), 'suggested_lang_code, lang_pack_version, base_lang_pack_version parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'g@\x0b3',
            struct.pack('<I', (0 if self.phonecalls_enabled is None or self.phonecalls_enabled is False else 2) | (0 if self.default_p2p_contacts is None or self.default_p2p_contacts is False else 8) | (0 if self.preload_featured_stickers is None or self.preload_featured_stickers is False else 16) | (0 if self.ignore_phone_entities is None or self.ignore_phone_entities is False else 32) | (0 if self.revoke_pm_inbox is None or self.revoke_pm_inbox is False else 64) | (0 if self.blocked_mode is None or self.blocked_mode is False else 256) | (0 if self.pfs_enabled is None or self.pfs_enabled is False else 8192) | (0 if self.tmp_sessions is None or self.tmp_sessions is False else 1) | (0 if self.autoupdate_url_prefix is None or self.autoupdate_url_prefix is False else 128) | (0 if self.gif_search_username is None or self.gif_search_username is False else 512) | (0 if self.venue_search_username is None or self.venue_search_username is False else 1024) | (0 if self.img_search_username is None or self.img_search_username is False else 2048) | (0 if self.static_maps_provider is None or self.static_maps_provider is False else 4096) | (0 if self.suggested_lang_code is None or self.suggested_lang_code is False else 4) | (0 if self.lang_pack_version is None or self.lang_pack_version is False else 4) | (0 if self.base_lang_pack_version is None or self.base_lang_pack_version is False else 4)),
            self._serialize_datetime(self.date),
            self._serialize_datetime(self.expires),
            b'\xb5ur\x99' if self.test_mode else b'7\x97y\xbc',
            struct.pack('<i', self.this_dc),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dc_options)),b''.join(x._bytes() for x in self.dc_options),
            self._serialize_bytes(self.dc_txt_domain_name),
            struct.pack('<i', self.chat_size_max),
            struct.pack('<i', self.megagroup_size_max),
            struct.pack('<i', self.forwarded_count_max),
            struct.pack('<i', self.online_update_period_ms),
            struct.pack('<i', self.offline_blur_timeout_ms),
            struct.pack('<i', self.offline_idle_timeout_ms),
            struct.pack('<i', self.online_cloud_timeout_ms),
            struct.pack('<i', self.notify_cloud_delay_ms),
            struct.pack('<i', self.notify_default_delay_ms),
            struct.pack('<i', self.push_chat_period_ms),
            struct.pack('<i', self.push_chat_limit),
            struct.pack('<i', self.saved_gifs_limit),
            struct.pack('<i', self.edit_time_limit),
            struct.pack('<i', self.revoke_time_limit),
            struct.pack('<i', self.revoke_pm_time_limit),
            struct.pack('<i', self.rating_e_decay),
            struct.pack('<i', self.stickers_recent_limit),
            struct.pack('<i', self.stickers_faved_limit),
            struct.pack('<i', self.channels_read_media_period),
            b'' if self.tmp_sessions is None or self.tmp_sessions is False else (struct.pack('<i', self.tmp_sessions)),
            struct.pack('<i', self.pinned_dialogs_count_max),
            struct.pack('<i', self.pinned_infolder_count_max),
            struct.pack('<i', self.call_receive_timeout_ms),
            struct.pack('<i', self.call_ring_timeout_ms),
            struct.pack('<i', self.call_connect_timeout_ms),
            struct.pack('<i', self.call_packet_timeout_ms),
            self._serialize_bytes(self.me_url_prefix),
            b'' if self.autoupdate_url_prefix is None or self.autoupdate_url_prefix is False else (self._serialize_bytes(self.autoupdate_url_prefix)),
            b'' if self.gif_search_username is None or self.gif_search_username is False else (self._serialize_bytes(self.gif_search_username)),
            b'' if self.venue_search_username is None or self.venue_search_username is False else (self._serialize_bytes(self.venue_search_username)),
            b'' if self.img_search_username is None or self.img_search_username is False else (self._serialize_bytes(self.img_search_username)),
            b'' if self.static_maps_provider is None or self.static_maps_provider is False else (self._serialize_bytes(self.static_maps_provider)),
            struct.pack('<i', self.caption_length_max),
            struct.pack('<i', self.message_length_max),
            struct.pack('<i', self.webfile_dc_id),
            b'' if self.suggested_lang_code is None or self.suggested_lang_code is False else (self._serialize_bytes(self.suggested_lang_code)),
            b'' if self.lang_pack_version is None or self.lang_pack_version is False else (struct.pack('<i', self.lang_pack_version)),
            b'' if self.base_lang_pack_version is None or self.base_lang_pack_version is False else (struct.pack('<i', self.base_lang_pack_version)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _phonecalls_enabled = bool(flags & 2)
        _default_p2p_contacts = bool(flags & 8)
        _preload_featured_stickers = bool(flags & 16)
        _ignore_phone_entities = bool(flags & 32)
        _revoke_pm_inbox = bool(flags & 64)
        _blocked_mode = bool(flags & 256)
        _pfs_enabled = bool(flags & 8192)
        _date = reader.tgread_date()
        _expires = reader.tgread_date()
        _test_mode = reader.tgread_bool()
        _this_dc = reader.read_int()
        reader.read_int()
        _dc_options = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _dc_options.append(_x)

        _dc_txt_domain_name = reader.tgread_string()
        _chat_size_max = reader.read_int()
        _megagroup_size_max = reader.read_int()
        _forwarded_count_max = reader.read_int()
        _online_update_period_ms = reader.read_int()
        _offline_blur_timeout_ms = reader.read_int()
        _offline_idle_timeout_ms = reader.read_int()
        _online_cloud_timeout_ms = reader.read_int()
        _notify_cloud_delay_ms = reader.read_int()
        _notify_default_delay_ms = reader.read_int()
        _push_chat_period_ms = reader.read_int()
        _push_chat_limit = reader.read_int()
        _saved_gifs_limit = reader.read_int()
        _edit_time_limit = reader.read_int()
        _revoke_time_limit = reader.read_int()
        _revoke_pm_time_limit = reader.read_int()
        _rating_e_decay = reader.read_int()
        _stickers_recent_limit = reader.read_int()
        _stickers_faved_limit = reader.read_int()
        _channels_read_media_period = reader.read_int()
        if flags & 1:
            _tmp_sessions = reader.read_int()
        else:
            _tmp_sessions = None
        _pinned_dialogs_count_max = reader.read_int()
        _pinned_infolder_count_max = reader.read_int()
        _call_receive_timeout_ms = reader.read_int()
        _call_ring_timeout_ms = reader.read_int()
        _call_connect_timeout_ms = reader.read_int()
        _call_packet_timeout_ms = reader.read_int()
        _me_url_prefix = reader.tgread_string()
        if flags & 128:
            _autoupdate_url_prefix = reader.tgread_string()
        else:
            _autoupdate_url_prefix = None
        if flags & 512:
            _gif_search_username = reader.tgread_string()
        else:
            _gif_search_username = None
        if flags & 1024:
            _venue_search_username = reader.tgread_string()
        else:
            _venue_search_username = None
        if flags & 2048:
            _img_search_username = reader.tgread_string()
        else:
            _img_search_username = None
        if flags & 4096:
            _static_maps_provider = reader.tgread_string()
        else:
            _static_maps_provider = None
        _caption_length_max = reader.read_int()
        _message_length_max = reader.read_int()
        _webfile_dc_id = reader.read_int()
        if flags & 4:
            _suggested_lang_code = reader.tgread_string()
        else:
            _suggested_lang_code = None
        if flags & 4:
            _lang_pack_version = reader.read_int()
        else:
            _lang_pack_version = None
        if flags & 4:
            _base_lang_pack_version = reader.read_int()
        else:
            _base_lang_pack_version = None
        return cls(date=_date, expires=_expires, test_mode=_test_mode, this_dc=_this_dc, dc_options=_dc_options, dc_txt_domain_name=_dc_txt_domain_name, chat_size_max=_chat_size_max, megagroup_size_max=_megagroup_size_max, forwarded_count_max=_forwarded_count_max, online_update_period_ms=_online_update_period_ms, offline_blur_timeout_ms=_offline_blur_timeout_ms, offline_idle_timeout_ms=_offline_idle_timeout_ms, online_cloud_timeout_ms=_online_cloud_timeout_ms, notify_cloud_delay_ms=_notify_cloud_delay_ms, notify_default_delay_ms=_notify_default_delay_ms, push_chat_period_ms=_push_chat_period_ms, push_chat_limit=_push_chat_limit, saved_gifs_limit=_saved_gifs_limit, edit_time_limit=_edit_time_limit, revoke_time_limit=_revoke_time_limit, revoke_pm_time_limit=_revoke_pm_time_limit, rating_e_decay=_rating_e_decay, stickers_recent_limit=_stickers_recent_limit, stickers_faved_limit=_stickers_faved_limit, channels_read_media_period=_channels_read_media_period, pinned_dialogs_count_max=_pinned_dialogs_count_max, pinned_infolder_count_max=_pinned_infolder_count_max, call_receive_timeout_ms=_call_receive_timeout_ms, call_ring_timeout_ms=_call_ring_timeout_ms, call_connect_timeout_ms=_call_connect_timeout_ms, call_packet_timeout_ms=_call_packet_timeout_ms, me_url_prefix=_me_url_prefix, caption_length_max=_caption_length_max, message_length_max=_message_length_max, webfile_dc_id=_webfile_dc_id, phonecalls_enabled=_phonecalls_enabled, default_p2p_contacts=_default_p2p_contacts, preload_featured_stickers=_preload_featured_stickers, ignore_phone_entities=_ignore_phone_entities, revoke_pm_inbox=_revoke_pm_inbox, blocked_mode=_blocked_mode, pfs_enabled=_pfs_enabled, tmp_sessions=_tmp_sessions, autoupdate_url_prefix=_autoupdate_url_prefix, gif_search_username=_gif_search_username, venue_search_username=_venue_search_username, img_search_username=_img_search_username, static_maps_provider=_static_maps_provider, suggested_lang_code=_suggested_lang_code, lang_pack_version=_lang_pack_version, base_lang_pack_version=_base_lang_pack_version)


@dataclasses.dataclass(init=False, frozen=True)
class Contact(TLObject):
    """
    Constructor for Contact: Instance of Contact.
    """
    __slots__ = ('user_id', 'mutual',)
    CONSTRUCTOR_ID = 0x145ade0b
    SUBCLASS_OF_ID = 0x83dfdfa4

    user_id: int
    mutual: bool
    def __init__(self, user_id: int, mutual: bool):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'mutual', mutual)

    def _bytes(self):
        return b''.join((
            b'\x0b\xdeZ\x14',
            struct.pack('<q', self.user_id),
            b'\xb5ur\x99' if self.mutual else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _mutual = reader.tgread_bool()
        return cls(user_id=_user_id, mutual=_mutual)


@dataclasses.dataclass(init=False, frozen=True)
class ContactStatus(TLObject):
    """
    Constructor for ContactStatus: Instance of ContactStatus.
    """
    __slots__ = ('user_id', 'status',)
    CONSTRUCTOR_ID = 0x16d9703b
    SUBCLASS_OF_ID = 0x68c0d74c

    user_id: int
    status: 'TypeUserStatus'
    def __init__(self, user_id: int, status: 'TypeUserStatus'):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'status', status)

    def _bytes(self):
        return b''.join((
            b';p\xd9\x16',
            struct.pack('<q', self.user_id),
            self.status._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _status = reader.tgread_object()
        return cls(user_id=_user_id, status=_status)


@dataclasses.dataclass(init=False, frozen=True)
class DataJSON(TLObject):
    """
    Constructor for DataJSON: Instance of DataJSON.
    """
    __slots__ = ('data',)
    CONSTRUCTOR_ID = 0x7d748d04
    SUBCLASS_OF_ID = 0xad0352e8

    data: str
    def __init__(self, data: str):
        object.__setattr__(self, 'data', data)

    def _bytes(self):
        return b''.join((
            b'\x04\x8dt}',
            self._serialize_bytes(self.data),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _data = reader.tgread_string()
        return cls(data=_data)


@dataclasses.dataclass(init=False, frozen=True)
class DcOption(TLObject):
    """
    Constructor for DcOption: Instance of DcOption.
    """
    __slots__ = ('id', 'ip_address', 'port', 'ipv6', 'media_only', 'tcpo_only', 'cdn', 'static', 'secret',)
    CONSTRUCTOR_ID = 0x18b7a10d
    SUBCLASS_OF_ID = 0x9e43e123

    id: int
    ip_address: str
    port: int
    ipv6: Optional[bool]
    media_only: Optional[bool]
    tcpo_only: Optional[bool]
    cdn: Optional[bool]
    static: Optional[bool]
    secret: Optional[bytes]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, ip_address: str, port: int, ipv6: Optional[bool]=None, media_only: Optional[bool]=None, tcpo_only: Optional[bool]=None, cdn: Optional[bool]=None, static: Optional[bool]=None, secret: Optional[bytes]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'ip_address', ip_address)
        object.__setattr__(self, 'port', port)
        object.__setattr__(self, 'ipv6', ipv6)
        object.__setattr__(self, 'media_only', media_only)
        object.__setattr__(self, 'tcpo_only', tcpo_only)
        object.__setattr__(self, 'cdn', cdn)
        object.__setattr__(self, 'static', static)
        object.__setattr__(self, 'secret', secret)

    def _bytes(self):
        return b''.join((
            b'\r\xa1\xb7\x18',
            struct.pack('<I', (0 if self.ipv6 is None or self.ipv6 is False else 1) | (0 if self.media_only is None or self.media_only is False else 2) | (0 if self.tcpo_only is None or self.tcpo_only is False else 4) | (0 if self.cdn is None or self.cdn is False else 8) | (0 if self.static is None or self.static is False else 16) | (0 if self.secret is None or self.secret is False else 1024)),
            struct.pack('<i', self.id),
            self._serialize_bytes(self.ip_address),
            struct.pack('<i', self.port),
            b'' if self.secret is None or self.secret is False else (self._serialize_bytes(self.secret)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _ipv6 = bool(flags & 1)
        _media_only = bool(flags & 2)
        _tcpo_only = bool(flags & 4)
        _cdn = bool(flags & 8)
        _static = bool(flags & 16)
        _id = reader.read_int()
        _ip_address = reader.tgread_string()
        _port = reader.read_int()
        if flags & 1024:
            _secret = reader.tgread_bytes()
        else:
            _secret = None
        return cls(id=_id, ip_address=_ip_address, port=_port, ipv6=_ipv6, media_only=_media_only, tcpo_only=_tcpo_only, cdn=_cdn, static=_static, secret=_secret)


@dataclasses.dataclass(init=False, frozen=True)
class DestroyAuthKeyFail(TLObject):
    """
    Constructor for DestroyAuthKeyRes: Instance of either DestroyAuthKeyOk, DestroyAuthKeyNone, DestroyAuthKeyFail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xea109b13
    SUBCLASS_OF_ID = 0x8291e68e

    def _bytes(self):
        return b''.join((
            b'\x13\x9b\x10\xea',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class DestroyAuthKeyNone(TLObject):
    """
    Constructor for DestroyAuthKeyRes: Instance of either DestroyAuthKeyOk, DestroyAuthKeyNone, DestroyAuthKeyFail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xa9f2259
    SUBCLASS_OF_ID = 0x8291e68e

    def _bytes(self):
        return b''.join((
            b'Y"\x9f\n',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class DestroyAuthKeyOk(TLObject):
    """
    Constructor for DestroyAuthKeyRes: Instance of either DestroyAuthKeyOk, DestroyAuthKeyNone, DestroyAuthKeyFail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xf660e1d4
    SUBCLASS_OF_ID = 0x8291e68e

    def _bytes(self):
        return b''.join((
            b'\xd4\xe1`\xf6',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class DestroySessionNone(TLObject):
    """
    Constructor for DestroySessionRes: Instance of either DestroySessionOk, DestroySessionNone.
    """
    __slots__ = ('session_id',)
    CONSTRUCTOR_ID = 0x62d350c9
    SUBCLASS_OF_ID = 0xaf0ce7bd

    session_id: int
    def __init__(self, session_id: int):
        object.__setattr__(self, 'session_id', session_id)

    def _bytes(self):
        return b''.join((
            b'\xc9P\xd3b',
            struct.pack('<q', self.session_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _session_id = reader.read_long()
        return cls(session_id=_session_id)


@dataclasses.dataclass(init=False, frozen=True)
class DestroySessionOk(TLObject):
    """
    Constructor for DestroySessionRes: Instance of either DestroySessionOk, DestroySessionNone.
    """
    __slots__ = ('session_id',)
    CONSTRUCTOR_ID = 0xe22045fc
    SUBCLASS_OF_ID = 0xaf0ce7bd

    session_id: int
    def __init__(self, session_id: int):
        object.__setattr__(self, 'session_id', session_id)

    def _bytes(self):
        return b''.join((
            b'\xfcE \xe2',
            struct.pack('<q', self.session_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _session_id = reader.read_long()
        return cls(session_id=_session_id)


@dataclasses.dataclass(init=False, frozen=True)
class DhGenFail(TLObject):
    """
    Constructor for Set_client_DH_params_answer: Instance of either DhGenOk, DhGenRetry, DhGenFail.
    """
    __slots__ = ('nonce', 'server_nonce', 'new_nonce_hash3',)
    CONSTRUCTOR_ID = 0xa69dae02
    SUBCLASS_OF_ID = 0x55dd6cdb

    nonce: int
    server_nonce: int
    new_nonce_hash3: int
    def __init__(self, nonce: int, server_nonce: int, new_nonce_hash3: int):
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'server_nonce', server_nonce)
        object.__setattr__(self, 'new_nonce_hash3', new_nonce_hash3)

    def _bytes(self):
        return b''.join((
            b'\x02\xae\x9d\xa6',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce_hash3.to_bytes(16, 'little', signed=True),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce_hash3 = reader.read_large_int(bits=128)
        return cls(nonce=_nonce, server_nonce=_server_nonce, new_nonce_hash3=_new_nonce_hash3)


@dataclasses.dataclass(init=False, frozen=True)
class DhGenOk(TLObject):
    """
    Constructor for Set_client_DH_params_answer: Instance of either DhGenOk, DhGenRetry, DhGenFail.
    """
    __slots__ = ('nonce', 'server_nonce', 'new_nonce_hash1',)
    CONSTRUCTOR_ID = 0x3bcbf734
    SUBCLASS_OF_ID = 0x55dd6cdb

    nonce: int
    server_nonce: int
    new_nonce_hash1: int
    def __init__(self, nonce: int, server_nonce: int, new_nonce_hash1: int):
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'server_nonce', server_nonce)
        object.__setattr__(self, 'new_nonce_hash1', new_nonce_hash1)

    def _bytes(self):
        return b''.join((
            b'4\xf7\xcb;',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce_hash1.to_bytes(16, 'little', signed=True),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce_hash1 = reader.read_large_int(bits=128)
        return cls(nonce=_nonce, server_nonce=_server_nonce, new_nonce_hash1=_new_nonce_hash1)


@dataclasses.dataclass(init=False, frozen=True)
class DhGenRetry(TLObject):
    """
    Constructor for Set_client_DH_params_answer: Instance of either DhGenOk, DhGenRetry, DhGenFail.
    """
    __slots__ = ('nonce', 'server_nonce', 'new_nonce_hash2',)
    CONSTRUCTOR_ID = 0x46dc1fb9
    SUBCLASS_OF_ID = 0x55dd6cdb

    nonce: int
    server_nonce: int
    new_nonce_hash2: int
    def __init__(self, nonce: int, server_nonce: int, new_nonce_hash2: int):
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'server_nonce', server_nonce)
        object.__setattr__(self, 'new_nonce_hash2', new_nonce_hash2)

    def _bytes(self):
        return b''.join((
            b'\xb9\x1f\xdcF',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce_hash2.to_bytes(16, 'little', signed=True),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce_hash2 = reader.read_large_int(bits=128)
        return cls(nonce=_nonce, server_nonce=_server_nonce, new_nonce_hash2=_new_nonce_hash2)


@dataclasses.dataclass(init=False, frozen=True)
class Dialog(TLObject):
    """
    Constructor for Dialog: Instance of either Dialog, DialogFolder.
    """
    __slots__ = ('peer', 'top_message', 'read_inbox_max_id', 'read_outbox_max_id', 'unread_count', 'unread_mentions_count', 'unread_reactions_count', 'notify_settings', 'pinned', 'unread_mark', 'pts', 'draft', 'folder_id',)
    CONSTRUCTOR_ID = 0xa8edd0f5
    SUBCLASS_OF_ID = 0x42cddd54

    peer: 'TypePeer'
    top_message: int
    read_inbox_max_id: int
    read_outbox_max_id: int
    unread_count: int
    unread_mentions_count: int
    unread_reactions_count: int
    notify_settings: 'TypePeerNotifySettings'
    pinned: Optional[bool]
    unread_mark: Optional[bool]
    pts: Optional[int]
    draft: Optional['TypeDraftMessage']
    folder_id: Optional[int]
    def __init__(self, peer: 'TypePeer', top_message: int, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, unread_mentions_count: int, unread_reactions_count: int, notify_settings: 'TypePeerNotifySettings', pinned: Optional[bool]=None, unread_mark: Optional[bool]=None, pts: Optional[int]=None, draft: Optional['TypeDraftMessage']=None, folder_id: Optional[int]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'top_message', top_message)
        object.__setattr__(self, 'read_inbox_max_id', read_inbox_max_id)
        object.__setattr__(self, 'read_outbox_max_id', read_outbox_max_id)
        object.__setattr__(self, 'unread_count', unread_count)
        object.__setattr__(self, 'unread_mentions_count', unread_mentions_count)
        object.__setattr__(self, 'unread_reactions_count', unread_reactions_count)
        object.__setattr__(self, 'notify_settings', notify_settings)
        object.__setattr__(self, 'pinned', pinned)
        object.__setattr__(self, 'unread_mark', unread_mark)
        object.__setattr__(self, 'pts', pts)
        object.__setattr__(self, 'draft', draft)
        object.__setattr__(self, 'folder_id', folder_id)

    def _bytes(self):
        return b''.join((
            b'\xf5\xd0\xed\xa8',
            struct.pack('<I', (0 if self.pinned is None or self.pinned is False else 4) | (0 if self.unread_mark is None or self.unread_mark is False else 8) | (0 if self.pts is None or self.pts is False else 1) | (0 if self.draft is None or self.draft is False else 2) | (0 if self.folder_id is None or self.folder_id is False else 16)),
            self.peer._bytes(),
            struct.pack('<i', self.top_message),
            struct.pack('<i', self.read_inbox_max_id),
            struct.pack('<i', self.read_outbox_max_id),
            struct.pack('<i', self.unread_count),
            struct.pack('<i', self.unread_mentions_count),
            struct.pack('<i', self.unread_reactions_count),
            self.notify_settings._bytes(),
            b'' if self.pts is None or self.pts is False else (struct.pack('<i', self.pts)),
            b'' if self.draft is None or self.draft is False else (self.draft._bytes()),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _pinned = bool(flags & 4)
        _unread_mark = bool(flags & 8)
        _peer = reader.tgread_object()
        _top_message = reader.read_int()
        _read_inbox_max_id = reader.read_int()
        _read_outbox_max_id = reader.read_int()
        _unread_count = reader.read_int()
        _unread_mentions_count = reader.read_int()
        _unread_reactions_count = reader.read_int()
        _notify_settings = reader.tgread_object()
        if flags & 1:
            _pts = reader.read_int()
        else:
            _pts = None
        if flags & 2:
            _draft = reader.tgread_object()
        else:
            _draft = None
        if flags & 16:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        return cls(peer=_peer, top_message=_top_message, read_inbox_max_id=_read_inbox_max_id, read_outbox_max_id=_read_outbox_max_id, unread_count=_unread_count, unread_mentions_count=_unread_mentions_count, unread_reactions_count=_unread_reactions_count, notify_settings=_notify_settings, pinned=_pinned, unread_mark=_unread_mark, pts=_pts, draft=_draft, folder_id=_folder_id)


@dataclasses.dataclass(init=False, frozen=True)
class DialogFilter(TLObject):
    """
    Constructor for DialogFilter: Instance of DialogFilter.
    """
    __slots__ = ('id', 'title', 'pinned_peers', 'include_peers', 'exclude_peers', 'contacts', 'non_contacts', 'groups', 'broadcasts', 'bots', 'exclude_muted', 'exclude_read', 'exclude_archived', 'emoticon',)
    CONSTRUCTOR_ID = 0x7438f7e8
    SUBCLASS_OF_ID = 0x692bc457

    id: int
    title: str
    pinned_peers: List['TypeInputPeer']
    include_peers: List['TypeInputPeer']
    exclude_peers: List['TypeInputPeer']
    contacts: Optional[bool]
    non_contacts: Optional[bool]
    groups: Optional[bool]
    broadcasts: Optional[bool]
    bots: Optional[bool]
    exclude_muted: Optional[bool]
    exclude_read: Optional[bool]
    exclude_archived: Optional[bool]
    emoticon: Optional[str]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str, pinned_peers: List['TypeInputPeer'], include_peers: List['TypeInputPeer'], exclude_peers: List['TypeInputPeer'], contacts: Optional[bool]=None, non_contacts: Optional[bool]=None, groups: Optional[bool]=None, broadcasts: Optional[bool]=None, bots: Optional[bool]=None, exclude_muted: Optional[bool]=None, exclude_read: Optional[bool]=None, exclude_archived: Optional[bool]=None, emoticon: Optional[str]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'pinned_peers', pinned_peers)
        object.__setattr__(self, 'include_peers', include_peers)
        object.__setattr__(self, 'exclude_peers', exclude_peers)
        object.__setattr__(self, 'contacts', contacts)
        object.__setattr__(self, 'non_contacts', non_contacts)
        object.__setattr__(self, 'groups', groups)
        object.__setattr__(self, 'broadcasts', broadcasts)
        object.__setattr__(self, 'bots', bots)
        object.__setattr__(self, 'exclude_muted', exclude_muted)
        object.__setattr__(self, 'exclude_read', exclude_read)
        object.__setattr__(self, 'exclude_archived', exclude_archived)
        object.__setattr__(self, 'emoticon', emoticon)

    def _bytes(self):
        return b''.join((
            b'\xe8\xf78t',
            struct.pack('<I', (0 if self.contacts is None or self.contacts is False else 1) | (0 if self.non_contacts is None or self.non_contacts is False else 2) | (0 if self.groups is None or self.groups is False else 4) | (0 if self.broadcasts is None or self.broadcasts is False else 8) | (0 if self.bots is None or self.bots is False else 16) | (0 if self.exclude_muted is None or self.exclude_muted is False else 2048) | (0 if self.exclude_read is None or self.exclude_read is False else 4096) | (0 if self.exclude_archived is None or self.exclude_archived is False else 8192) | (0 if self.emoticon is None or self.emoticon is False else 33554432)),
            struct.pack('<i', self.id),
            self._serialize_bytes(self.title),
            b'' if self.emoticon is None or self.emoticon is False else (self._serialize_bytes(self.emoticon)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.pinned_peers)),b''.join(x._bytes() for x in self.pinned_peers),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.include_peers)),b''.join(x._bytes() for x in self.include_peers),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.exclude_peers)),b''.join(x._bytes() for x in self.exclude_peers),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _contacts = bool(flags & 1)
        _non_contacts = bool(flags & 2)
        _groups = bool(flags & 4)
        _broadcasts = bool(flags & 8)
        _bots = bool(flags & 16)
        _exclude_muted = bool(flags & 2048)
        _exclude_read = bool(flags & 4096)
        _exclude_archived = bool(flags & 8192)
        _id = reader.read_int()
        _title = reader.tgread_string()
        if flags & 33554432:
            _emoticon = reader.tgread_string()
        else:
            _emoticon = None
        reader.read_int()
        _pinned_peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _pinned_peers.append(_x)

        reader.read_int()
        _include_peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _include_peers.append(_x)

        reader.read_int()
        _exclude_peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _exclude_peers.append(_x)

        return cls(id=_id, title=_title, pinned_peers=_pinned_peers, include_peers=_include_peers, exclude_peers=_exclude_peers, contacts=_contacts, non_contacts=_non_contacts, groups=_groups, broadcasts=_broadcasts, bots=_bots, exclude_muted=_exclude_muted, exclude_read=_exclude_read, exclude_archived=_exclude_archived, emoticon=_emoticon)


@dataclasses.dataclass(init=False, frozen=True)
class DialogFilterSuggested(TLObject):
    """
    Constructor for DialogFilterSuggested: Instance of DialogFilterSuggested.
    """
    __slots__ = ('filter', 'description',)
    CONSTRUCTOR_ID = 0x77744d4a
    SUBCLASS_OF_ID = 0x31ede086

    filter: 'TypeDialogFilter'
    description: str
    # noinspection PyShadowingBuiltins
    def __init__(self, filter: 'TypeDialogFilter', description: str):
        object.__setattr__(self, 'filter', filter)
        object.__setattr__(self, 'description', description)

    def _bytes(self):
        return b''.join((
            b'JMtw',
            self.filter._bytes(),
            self._serialize_bytes(self.description),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _filter = reader.tgread_object()
        _description = reader.tgread_string()
        return cls(filter=_filter, description=_description)


@dataclasses.dataclass(init=False, frozen=True)
class DialogFolder(TLObject):
    """
    Constructor for Dialog: Instance of either Dialog, DialogFolder.
    """
    __slots__ = ('folder', 'peer', 'top_message', 'unread_muted_peers_count', 'unread_unmuted_peers_count', 'unread_muted_messages_count', 'unread_unmuted_messages_count', 'pinned',)
    CONSTRUCTOR_ID = 0x71bd134c
    SUBCLASS_OF_ID = 0x42cddd54

    folder: 'TypeFolder'
    peer: 'TypePeer'
    top_message: int
    unread_muted_peers_count: int
    unread_unmuted_peers_count: int
    unread_muted_messages_count: int
    unread_unmuted_messages_count: int
    pinned: Optional[bool]
    def __init__(self, folder: 'TypeFolder', peer: 'TypePeer', top_message: int, unread_muted_peers_count: int, unread_unmuted_peers_count: int, unread_muted_messages_count: int, unread_unmuted_messages_count: int, pinned: Optional[bool]=None):
        object.__setattr__(self, 'folder', folder)
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'top_message', top_message)
        object.__setattr__(self, 'unread_muted_peers_count', unread_muted_peers_count)
        object.__setattr__(self, 'unread_unmuted_peers_count', unread_unmuted_peers_count)
        object.__setattr__(self, 'unread_muted_messages_count', unread_muted_messages_count)
        object.__setattr__(self, 'unread_unmuted_messages_count', unread_unmuted_messages_count)
        object.__setattr__(self, 'pinned', pinned)

    def _bytes(self):
        return b''.join((
            b'L\x13\xbdq',
            struct.pack('<I', (0 if self.pinned is None or self.pinned is False else 4)),
            self.folder._bytes(),
            self.peer._bytes(),
            struct.pack('<i', self.top_message),
            struct.pack('<i', self.unread_muted_peers_count),
            struct.pack('<i', self.unread_unmuted_peers_count),
            struct.pack('<i', self.unread_muted_messages_count),
            struct.pack('<i', self.unread_unmuted_messages_count),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _pinned = bool(flags & 4)
        _folder = reader.tgread_object()
        _peer = reader.tgread_object()
        _top_message = reader.read_int()
        _unread_muted_peers_count = reader.read_int()
        _unread_unmuted_peers_count = reader.read_int()
        _unread_muted_messages_count = reader.read_int()
        _unread_unmuted_messages_count = reader.read_int()
        return cls(folder=_folder, peer=_peer, top_message=_top_message, unread_muted_peers_count=_unread_muted_peers_count, unread_unmuted_peers_count=_unread_unmuted_peers_count, unread_muted_messages_count=_unread_muted_messages_count, unread_unmuted_messages_count=_unread_unmuted_messages_count, pinned=_pinned)


@dataclasses.dataclass(init=False, frozen=True)
class DialogPeer(TLObject):
    """
    Constructor for DialogPeer: Instance of either DialogPeer, DialogPeerFolder.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0xe56dbf05
    SUBCLASS_OF_ID = 0x256ce1ae

    peer: 'TypePeer'
    def __init__(self, peer: 'TypePeer'):
        object.__setattr__(self, 'peer', peer)

    def _bytes(self):
        return b''.join((
            b'\x05\xbfm\xe5',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class DialogPeerFolder(TLObject):
    """
    Constructor for DialogPeer: Instance of either DialogPeer, DialogPeerFolder.
    """
    __slots__ = ('folder_id',)
    CONSTRUCTOR_ID = 0x514519e2
    SUBCLASS_OF_ID = 0x256ce1ae

    folder_id: int
    def __init__(self, folder_id: int):
        object.__setattr__(self, 'folder_id', folder_id)

    def _bytes(self):
        return b''.join((
            b'\xe2\x19EQ',
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _folder_id = reader.read_int()
        return cls(folder_id=_folder_id)


@dataclasses.dataclass(init=False, frozen=True)
class Document(TLObject):
    """
    Constructor for Document: Instance of either DocumentEmpty, Document.
    """
    __slots__ = ('id', 'access_hash', 'file_reference', 'date', 'mime_type', 'size', 'dc_id', 'attributes', 'thumbs', 'video_thumbs',)
    CONSTRUCTOR_ID = 0x1e87342b
    SUBCLASS_OF_ID = 0x211fe820

    id: int
    access_hash: int
    file_reference: bytes
    date: Optional[datetime]
    mime_type: str
    size: int
    dc_id: int
    attributes: List['TypeDocumentAttribute']
    thumbs: Optional[List['TypePhotoSize']]
    video_thumbs: Optional[List['TypeVideoSize']]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, date: Optional[datetime], mime_type: str, size: int, dc_id: int, attributes: List['TypeDocumentAttribute'], thumbs: Optional[List['TypePhotoSize']]=None, video_thumbs: Optional[List['TypeVideoSize']]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'file_reference', file_reference)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'mime_type', mime_type)
        object.__setattr__(self, 'size', size)
        object.__setattr__(self, 'dc_id', dc_id)
        object.__setattr__(self, 'attributes', attributes)
        object.__setattr__(self, 'thumbs', thumbs)
        object.__setattr__(self, 'video_thumbs', video_thumbs)

    def _bytes(self):
        return b''.join((
            b'+4\x87\x1e',
            struct.pack('<I', (0 if self.thumbs is None or self.thumbs is False else 1) | (0 if self.video_thumbs is None or self.video_thumbs is False else 2)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_bytes(self.file_reference),
            self._serialize_datetime(self.date),
            self._serialize_bytes(self.mime_type),
            struct.pack('<i', self.size),
            b'' if self.thumbs is None or self.thumbs is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.thumbs)),b''.join(x._bytes() for x in self.thumbs))),
            b'' if self.video_thumbs is None or self.video_thumbs is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.video_thumbs)),b''.join(x._bytes() for x in self.video_thumbs))),
            struct.pack('<i', self.dc_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.attributes)),b''.join(x._bytes() for x in self.attributes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _date = reader.tgread_date()
        _mime_type = reader.tgread_string()
        _size = reader.read_int()
        if flags & 1:
            reader.read_int()
            _thumbs = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _thumbs.append(_x)

        else:
            _thumbs = None
        if flags & 2:
            reader.read_int()
            _video_thumbs = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _video_thumbs.append(_x)

        else:
            _video_thumbs = None
        _dc_id = reader.read_int()
        reader.read_int()
        _attributes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _attributes.append(_x)

        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, date=_date, mime_type=_mime_type, size=_size, dc_id=_dc_id, attributes=_attributes, thumbs=_thumbs, video_thumbs=_video_thumbs)


@dataclasses.dataclass(init=False, frozen=True)
class DocumentAttributeAnimated(TLObject):
    """
    Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x11b58939
    SUBCLASS_OF_ID = 0xf729eb9b

    def _bytes(self):
        return b''.join((
            b'9\x89\xb5\x11',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class DocumentAttributeAudio(TLObject):
    """
    Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers.
    """
    __slots__ = ('duration', 'voice', 'title', 'performer', 'waveform',)
    CONSTRUCTOR_ID = 0x9852f9c6
    SUBCLASS_OF_ID = 0xf729eb9b

    duration: int
    voice: Optional[bool]
    title: Optional[str]
    performer: Optional[str]
    waveform: Optional[bytes]
    def __init__(self, duration: int, voice: Optional[bool]=None, title: Optional[str]=None, performer: Optional[str]=None, waveform: Optional[bytes]=None):
        object.__setattr__(self, 'duration', duration)
        object.__setattr__(self, 'voice', voice)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'performer', performer)
        object.__setattr__(self, 'waveform', waveform)

    def _bytes(self):
        return b''.join((
            b'\xc6\xf9R\x98',
            struct.pack('<I', (0 if self.voice is None or self.voice is False else 1024) | (0 if self.title is None or self.title is False else 1) | (0 if self.performer is None or self.performer is False else 2) | (0 if self.waveform is None or self.waveform is False else 4)),
            struct.pack('<i', self.duration),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
            b'' if self.performer is None or self.performer is False else (self._serialize_bytes(self.performer)),
            b'' if self.waveform is None or self.waveform is False else (self._serialize_bytes(self.waveform)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _voice = bool(flags & 1024)
        _duration = reader.read_int()
        if flags & 1:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 2:
            _performer = reader.tgread_string()
        else:
            _performer = None
        if flags & 4:
            _waveform = reader.tgread_bytes()
        else:
            _waveform = None
        return cls(duration=_duration, voice=_voice, title=_title, performer=_performer, waveform=_waveform)


@dataclasses.dataclass(init=False, frozen=True)
class DocumentAttributeFilename(TLObject):
    """
    Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers.
    """
    __slots__ = ('file_name',)
    CONSTRUCTOR_ID = 0x15590068
    SUBCLASS_OF_ID = 0xf729eb9b

    file_name: str
    def __init__(self, file_name: str):
        object.__setattr__(self, 'file_name', file_name)

    def _bytes(self):
        return b''.join((
            b'h\x00Y\x15',
            self._serialize_bytes(self.file_name),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _file_name = reader.tgread_string()
        return cls(file_name=_file_name)


@dataclasses.dataclass(init=False, frozen=True)
class DocumentAttributeHasStickers(TLObject):
    """
    Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9801d2f7
    SUBCLASS_OF_ID = 0xf729eb9b

    def _bytes(self):
        return b''.join((
            b'\xf7\xd2\x01\x98',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class DocumentAttributeImageSize(TLObject):
    """
    Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers.
    """
    __slots__ = ('w', 'h',)
    CONSTRUCTOR_ID = 0x6c37c15c
    SUBCLASS_OF_ID = 0xf729eb9b

    w: int
    h: int
    def __init__(self, w: int, h: int):
        object.__setattr__(self, 'w', w)
        object.__setattr__(self, 'h', h)

    def _bytes(self):
        return b''.join((
            b'\\\xc17l',
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _w = reader.read_int()
        _h = reader.read_int()
        return cls(w=_w, h=_h)


@dataclasses.dataclass(init=False, frozen=True)
class DocumentAttributeSticker(TLObject):
    """
    Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers.
    """
    __slots__ = ('alt', 'stickerset', 'mask', 'mask_coords',)
    CONSTRUCTOR_ID = 0x6319d612
    SUBCLASS_OF_ID = 0xf729eb9b

    alt: str
    stickerset: 'TypeInputStickerSet'
    mask: Optional[bool]
    mask_coords: Optional['TypeMaskCoords']
    def __init__(self, alt: str, stickerset: 'TypeInputStickerSet', mask: Optional[bool]=None, mask_coords: Optional['TypeMaskCoords']=None):
        object.__setattr__(self, 'alt', alt)
        object.__setattr__(self, 'stickerset', stickerset)
        object.__setattr__(self, 'mask', mask)
        object.__setattr__(self, 'mask_coords', mask_coords)

    def _bytes(self):
        return b''.join((
            b'\x12\xd6\x19c',
            struct.pack('<I', (0 if self.mask is None or self.mask is False else 2) | (0 if self.mask_coords is None or self.mask_coords is False else 1)),
            self._serialize_bytes(self.alt),
            self.stickerset._bytes(),
            b'' if self.mask_coords is None or self.mask_coords is False else (self.mask_coords._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _mask = bool(flags & 2)
        _alt = reader.tgread_string()
        _stickerset = reader.tgread_object()
        if flags & 1:
            _mask_coords = reader.tgread_object()
        else:
            _mask_coords = None
        return cls(alt=_alt, stickerset=_stickerset, mask=_mask, mask_coords=_mask_coords)


@dataclasses.dataclass(init=False, frozen=True)
class DocumentAttributeVideo(TLObject):
    """
    Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers.
    """
    __slots__ = ('duration', 'w', 'h', 'round_message', 'supports_streaming',)
    CONSTRUCTOR_ID = 0xef02ce6
    SUBCLASS_OF_ID = 0xf729eb9b

    duration: int
    w: int
    h: int
    round_message: Optional[bool]
    supports_streaming: Optional[bool]
    def __init__(self, duration: int, w: int, h: int, round_message: Optional[bool]=None, supports_streaming: Optional[bool]=None):
        object.__setattr__(self, 'duration', duration)
        object.__setattr__(self, 'w', w)
        object.__setattr__(self, 'h', h)
        object.__setattr__(self, 'round_message', round_message)
        object.__setattr__(self, 'supports_streaming', supports_streaming)

    def _bytes(self):
        return b''.join((
            b'\xe6,\xf0\x0e',
            struct.pack('<I', (0 if self.round_message is None or self.round_message is False else 1) | (0 if self.supports_streaming is None or self.supports_streaming is False else 2)),
            struct.pack('<i', self.duration),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _round_message = bool(flags & 1)
        _supports_streaming = bool(flags & 2)
        _duration = reader.read_int()
        _w = reader.read_int()
        _h = reader.read_int()
        return cls(duration=_duration, w=_w, h=_h, round_message=_round_message, supports_streaming=_supports_streaming)


@dataclasses.dataclass(init=False, frozen=True)
class DocumentEmpty(TLObject):
    """
    Constructor for Document: Instance of either DocumentEmpty, Document.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x36f8c871
    SUBCLASS_OF_ID = 0x211fe820

    id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'q\xc8\xf86',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class DraftMessage(TLObject):
    """
    Constructor for DraftMessage: Instance of either DraftMessageEmpty, DraftMessage.
    """
    __slots__ = ('message', 'date', 'no_webpage', 'reply_to_msg_id', 'entities',)
    CONSTRUCTOR_ID = 0xfd8e711f
    SUBCLASS_OF_ID = 0x33d47f45

    message: str
    date: Optional[datetime]
    no_webpage: Optional[bool]
    reply_to_msg_id: Optional[int]
    entities: Optional[List['TypeMessageEntity']]
    def __init__(self, message: str, date: Optional[datetime], no_webpage: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, entities: Optional[List['TypeMessageEntity']]=None):
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'no_webpage', no_webpage)
        object.__setattr__(self, 'reply_to_msg_id', reply_to_msg_id)
        object.__setattr__(self, 'entities', entities)

    def _bytes(self):
        return b''.join((
            b'\x1fq\x8e\xfd',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 2) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 1) | (0 if self.entities is None or self.entities is False else 8)),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            self._serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            self._serialize_datetime(self.date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 2)
        if flags & 1:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        _message = reader.tgread_string()
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        _date = reader.tgread_date()
        return cls(message=_message, date=_date, no_webpage=_no_webpage, reply_to_msg_id=_reply_to_msg_id, entities=_entities)


@dataclasses.dataclass(init=False, frozen=True)
class DraftMessageEmpty(TLObject):
    """
    Constructor for DraftMessage: Instance of either DraftMessageEmpty, DraftMessage.
    """
    __slots__ = ('date',)
    CONSTRUCTOR_ID = 0x1b0c841a
    SUBCLASS_OF_ID = 0x33d47f45

    date: Optional[datetime]
    def __init__(self, date: Optional[datetime]=None):
        object.__setattr__(self, 'date', date)

    def _bytes(self):
        return b''.join((
            b'\x1a\x84\x0c\x1b',
            struct.pack('<I', (0 if self.date is None or self.date is False else 1)),
            b'' if self.date is None or self.date is False else (self._serialize_datetime(self.date)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _date = reader.tgread_date()
        else:
            _date = None
        return cls(date=_date)


@dataclasses.dataclass(init=False, frozen=True)
class EmojiKeyword(TLObject):
    """
    Constructor for EmojiKeyword: Instance of either EmojiKeyword, EmojiKeywordDeleted.
    """
    __slots__ = ('keyword', 'emoticons',)
    CONSTRUCTOR_ID = 0xd5b3b9f9
    SUBCLASS_OF_ID = 0x6612a53e

    keyword: str
    emoticons: List[str]
    def __init__(self, keyword: str, emoticons: List[str]):
        object.__setattr__(self, 'keyword', keyword)
        object.__setattr__(self, 'emoticons', emoticons)

    def _bytes(self):
        return b''.join((
            b'\xf9\xb9\xb3\xd5',
            self._serialize_bytes(self.keyword),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.emoticons)),b''.join(self._serialize_bytes(x) for x in self.emoticons),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _keyword = reader.tgread_string()
        reader.read_int()
        _emoticons = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _emoticons.append(_x)

        return cls(keyword=_keyword, emoticons=_emoticons)


@dataclasses.dataclass(init=False, frozen=True)
class EmojiKeywordDeleted(TLObject):
    """
    Constructor for EmojiKeyword: Instance of either EmojiKeyword, EmojiKeywordDeleted.
    """
    __slots__ = ('keyword', 'emoticons',)
    CONSTRUCTOR_ID = 0x236df622
    SUBCLASS_OF_ID = 0x6612a53e

    keyword: str
    emoticons: List[str]
    def __init__(self, keyword: str, emoticons: List[str]):
        object.__setattr__(self, 'keyword', keyword)
        object.__setattr__(self, 'emoticons', emoticons)

    def _bytes(self):
        return b''.join((
            b'"\xf6m#',
            self._serialize_bytes(self.keyword),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.emoticons)),b''.join(self._serialize_bytes(x) for x in self.emoticons),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _keyword = reader.tgread_string()
        reader.read_int()
        _emoticons = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _emoticons.append(_x)

        return cls(keyword=_keyword, emoticons=_emoticons)


@dataclasses.dataclass(init=False, frozen=True)
class EmojiKeywordsDifference(TLObject):
    """
    Constructor for EmojiKeywordsDifference: Instance of EmojiKeywordsDifference.
    """
    __slots__ = ('lang_code', 'from_version', 'version', 'keywords',)
    CONSTRUCTOR_ID = 0x5cc761bd
    SUBCLASS_OF_ID = 0xd279c672

    lang_code: str
    from_version: int
    version: int
    keywords: List['TypeEmojiKeyword']
    def __init__(self, lang_code: str, from_version: int, version: int, keywords: List['TypeEmojiKeyword']):
        object.__setattr__(self, 'lang_code', lang_code)
        object.__setattr__(self, 'from_version', from_version)
        object.__setattr__(self, 'version', version)
        object.__setattr__(self, 'keywords', keywords)

    def _bytes(self):
        return b''.join((
            b'\xbda\xc7\\',
            self._serialize_bytes(self.lang_code),
            struct.pack('<i', self.from_version),
            struct.pack('<i', self.version),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.keywords)),b''.join(x._bytes() for x in self.keywords),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        _from_version = reader.read_int()
        _version = reader.read_int()
        reader.read_int()
        _keywords = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _keywords.append(_x)

        return cls(lang_code=_lang_code, from_version=_from_version, version=_version, keywords=_keywords)


@dataclasses.dataclass(init=False, frozen=True)
class EmojiLanguage(TLObject):
    """
    Constructor for EmojiLanguage: Instance of EmojiLanguage.
    """
    __slots__ = ('lang_code',)
    CONSTRUCTOR_ID = 0xb3fb5361
    SUBCLASS_OF_ID = 0xa48d04ee

    lang_code: str
    def __init__(self, lang_code: str):
        object.__setattr__(self, 'lang_code', lang_code)

    def _bytes(self):
        return b''.join((
            b'aS\xfb\xb3',
            self._serialize_bytes(self.lang_code),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        return cls(lang_code=_lang_code)


@dataclasses.dataclass(init=False, frozen=True)
class EmojiURL(TLObject):
    """
    Constructor for EmojiURL: Instance of EmojiURL.
    """
    __slots__ = ('url',)
    CONSTRUCTOR_ID = 0xa575739d
    SUBCLASS_OF_ID = 0x1fa08a19

    url: str
    def __init__(self, url: str):
        object.__setattr__(self, 'url', url)

    def _bytes(self):
        return b''.join((
            b'\x9dsu\xa5',
            self._serialize_bytes(self.url),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _url = reader.tgread_string()
        return cls(url=_url)


@dataclasses.dataclass(init=False, frozen=True)
class EncryptedChat(TLObject):
    """
    Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
    """
    __slots__ = ('id', 'access_hash', 'date', 'admin_id', 'participant_id', 'g_a_or_b', 'key_fingerprint',)
    CONSTRUCTOR_ID = 0x61f0d4c7
    SUBCLASS_OF_ID = 0x6d28a37a

    id: int
    access_hash: int
    date: Optional[datetime]
    admin_id: int
    participant_id: int
    g_a_or_b: bytes
    key_fingerprint: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, g_a_or_b: bytes, key_fingerprint: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'admin_id', admin_id)
        object.__setattr__(self, 'participant_id', participant_id)
        object.__setattr__(self, 'g_a_or_b', g_a_or_b)
        object.__setattr__(self, 'key_fingerprint', key_fingerprint)

    def _bytes(self):
        return b''.join((
            b'\xc7\xd4\xf0a',
            struct.pack('<i', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_datetime(self.date),
            struct.pack('<q', self.admin_id),
            struct.pack('<q', self.participant_id),
            self._serialize_bytes(self.g_a_or_b),
            struct.pack('<q', self.key_fingerprint),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_int()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_long()
        _participant_id = reader.read_long()
        _g_a_or_b = reader.tgread_bytes()
        _key_fingerprint = reader.read_long()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, g_a_or_b=_g_a_or_b, key_fingerprint=_key_fingerprint)


@dataclasses.dataclass(init=False, frozen=True)
class EncryptedChatDiscarded(TLObject):
    """
    Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
    """
    __slots__ = ('id', 'history_deleted',)
    CONSTRUCTOR_ID = 0x1e1c7c45
    SUBCLASS_OF_ID = 0x6d28a37a

    id: int
    history_deleted: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, history_deleted: Optional[bool]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'history_deleted', history_deleted)

    def _bytes(self):
        return b''.join((
            b'E|\x1c\x1e',
            struct.pack('<I', (0 if self.history_deleted is None or self.history_deleted is False else 1)),
            struct.pack('<i', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _history_deleted = bool(flags & 1)
        _id = reader.read_int()
        return cls(id=_id, history_deleted=_history_deleted)


@dataclasses.dataclass(init=False, frozen=True)
class EncryptedChatEmpty(TLObject):
    """
    Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0xab7ec0a0
    SUBCLASS_OF_ID = 0x6d28a37a

    id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'\xa0\xc0~\xab',
            struct.pack('<i', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class EncryptedChatRequested(TLObject):
    """
    Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
    """
    __slots__ = ('id', 'access_hash', 'date', 'admin_id', 'participant_id', 'g_a', 'folder_id',)
    CONSTRUCTOR_ID = 0x48f1d94c
    SUBCLASS_OF_ID = 0x6d28a37a

    id: int
    access_hash: int
    date: Optional[datetime]
    admin_id: int
    participant_id: int
    g_a: bytes
    folder_id: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, g_a: bytes, folder_id: Optional[int]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'admin_id', admin_id)
        object.__setattr__(self, 'participant_id', participant_id)
        object.__setattr__(self, 'g_a', g_a)
        object.__setattr__(self, 'folder_id', folder_id)

    def _bytes(self):
        return b''.join((
            b'L\xd9\xf1H',
            struct.pack('<I', (0 if self.folder_id is None or self.folder_id is False else 1)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            struct.pack('<i', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_datetime(self.date),
            struct.pack('<q', self.admin_id),
            struct.pack('<q', self.participant_id),
            self._serialize_bytes(self.g_a),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        _id = reader.read_int()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_long()
        _participant_id = reader.read_long()
        _g_a = reader.tgread_bytes()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, g_a=_g_a, folder_id=_folder_id)


@dataclasses.dataclass(init=False, frozen=True)
class EncryptedChatWaiting(TLObject):
    """
    Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
    """
    __slots__ = ('id', 'access_hash', 'date', 'admin_id', 'participant_id',)
    CONSTRUCTOR_ID = 0x66b25953
    SUBCLASS_OF_ID = 0x6d28a37a

    id: int
    access_hash: int
    date: Optional[datetime]
    admin_id: int
    participant_id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'admin_id', admin_id)
        object.__setattr__(self, 'participant_id', participant_id)

    def _bytes(self):
        return b''.join((
            b'SY\xb2f',
            struct.pack('<i', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_datetime(self.date),
            struct.pack('<q', self.admin_id),
            struct.pack('<q', self.participant_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_int()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_long()
        _participant_id = reader.read_long()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id)


@dataclasses.dataclass(init=False, frozen=True)
class EncryptedFile(TLObject):
    """
    Constructor for EncryptedFile: Instance of either EncryptedFileEmpty, EncryptedFile.
    """
    __slots__ = ('id', 'access_hash', 'size', 'dc_id', 'key_fingerprint',)
    CONSTRUCTOR_ID = 0x4a70994c
    SUBCLASS_OF_ID = 0x842a67c0

    id: int
    access_hash: int
    size: int
    dc_id: int
    key_fingerprint: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, size: int, dc_id: int, key_fingerprint: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'size', size)
        object.__setattr__(self, 'dc_id', dc_id)
        object.__setattr__(self, 'key_fingerprint', key_fingerprint)

    def _bytes(self):
        return b''.join((
            b'L\x99pJ',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            struct.pack('<i', self.size),
            struct.pack('<i', self.dc_id),
            struct.pack('<i', self.key_fingerprint),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _size = reader.read_int()
        _dc_id = reader.read_int()
        _key_fingerprint = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, size=_size, dc_id=_dc_id, key_fingerprint=_key_fingerprint)


@dataclasses.dataclass(init=False, frozen=True)
class EncryptedFileEmpty(TLObject):
    """
    Constructor for EncryptedFile: Instance of either EncryptedFileEmpty, EncryptedFile.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xc21f497e
    SUBCLASS_OF_ID = 0x842a67c0

    def _bytes(self):
        return b''.join((
            b'~I\x1f\xc2',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class EncryptedMessage(TLObject):
    """
    Constructor for EncryptedMessage: Instance of either EncryptedMessage, EncryptedMessageService.
    """
    __slots__ = ('chat_id', 'date', 'bytes', 'file', 'random_id',)
    CONSTRUCTOR_ID = 0xed18c118
    SUBCLASS_OF_ID = 0x239f2e51

    chat_id: int
    date: Optional[datetime]
    bytes: bytes
    file: 'TypeEncryptedFile'
    random_id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, chat_id: int, date: Optional[datetime], bytes: bytes, file: 'TypeEncryptedFile', random_id: int=None):
        object.__setattr__(self, 'chat_id', chat_id)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'bytes', bytes)
        object.__setattr__(self, 'file', file)
        object.__setattr__(self, 'random_id', random_id)

    def _bytes(self):
        return b''.join((
            b'\x18\xc1\x18\xed',
            struct.pack('<q', self.random_id),
            struct.pack('<i', self.chat_id),
            self._serialize_datetime(self.date),
            self._serialize_bytes(self.bytes),
            self.file._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _random_id = reader.read_long()
        _chat_id = reader.read_int()
        _date = reader.tgread_date()
        _bytes = reader.tgread_bytes()
        _file = reader.tgread_object()
        return cls(chat_id=_chat_id, date=_date, bytes=_bytes, file=_file, random_id=_random_id)


@dataclasses.dataclass(init=False, frozen=True)
class EncryptedMessageService(TLObject):
    """
    Constructor for EncryptedMessage: Instance of either EncryptedMessage, EncryptedMessageService.
    """
    __slots__ = ('chat_id', 'date', 'bytes', 'random_id',)
    CONSTRUCTOR_ID = 0x23734b06
    SUBCLASS_OF_ID = 0x239f2e51

    chat_id: int
    date: Optional[datetime]
    bytes: bytes
    random_id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, chat_id: int, date: Optional[datetime], bytes: bytes, random_id: int=None):
        object.__setattr__(self, 'chat_id', chat_id)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'bytes', bytes)
        object.__setattr__(self, 'random_id', random_id)

    def _bytes(self):
        return b''.join((
            b'\x06Ks#',
            struct.pack('<q', self.random_id),
            struct.pack('<i', self.chat_id),
            self._serialize_datetime(self.date),
            self._serialize_bytes(self.bytes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _random_id = reader.read_long()
        _chat_id = reader.read_int()
        _date = reader.tgread_date()
        _bytes = reader.tgread_bytes()
        return cls(chat_id=_chat_id, date=_date, bytes=_bytes, random_id=_random_id)


@dataclasses.dataclass(init=False, frozen=True)
class ExportedMessageLink(TLObject):
    """
    Constructor for ExportedMessageLink: Instance of ExportedMessageLink.
    """
    __slots__ = ('link', 'html',)
    CONSTRUCTOR_ID = 0x5dab1af4
    SUBCLASS_OF_ID = 0xdee644cc

    link: str
    html: str
    def __init__(self, link: str, html: str):
        object.__setattr__(self, 'link', link)
        object.__setattr__(self, 'html', html)

    def _bytes(self):
        return b''.join((
            b'\xf4\x1a\xab]',
            self._serialize_bytes(self.link),
            self._serialize_bytes(self.html),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _link = reader.tgread_string()
        _html = reader.tgread_string()
        return cls(link=_link, html=_html)


@dataclasses.dataclass(init=False, frozen=True)
class FileHash(TLObject):
    """
    Constructor for FileHash: Instance of FileHash.
    """
    __slots__ = ('offset', 'limit', 'hash',)
    CONSTRUCTOR_ID = 0x6242c773
    SUBCLASS_OF_ID = 0xead438b3

    offset: int
    limit: int
    hash: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, offset: int, limit: int, hash: bytes):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'limit', limit)
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b's\xc7Bb',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.limit),
            self._serialize_bytes(self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _limit = reader.read_int()
        _hash = reader.tgread_bytes()
        return cls(offset=_offset, limit=_limit, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class Folder(TLObject):
    """
    Constructor for Folder: Instance of Folder.
    """
    __slots__ = ('id', 'title', 'autofill_new_broadcasts', 'autofill_public_groups', 'autofill_new_correspondents', 'photo',)
    CONSTRUCTOR_ID = 0xff544e65
    SUBCLASS_OF_ID = 0xeb0e0cfb

    id: int
    title: str
    autofill_new_broadcasts: Optional[bool]
    autofill_public_groups: Optional[bool]
    autofill_new_correspondents: Optional[bool]
    photo: Optional['TypeChatPhoto']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str, autofill_new_broadcasts: Optional[bool]=None, autofill_public_groups: Optional[bool]=None, autofill_new_correspondents: Optional[bool]=None, photo: Optional['TypeChatPhoto']=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'autofill_new_broadcasts', autofill_new_broadcasts)
        object.__setattr__(self, 'autofill_public_groups', autofill_public_groups)
        object.__setattr__(self, 'autofill_new_correspondents', autofill_new_correspondents)
        object.__setattr__(self, 'photo', photo)

    def _bytes(self):
        return b''.join((
            b'eNT\xff',
            struct.pack('<I', (0 if self.autofill_new_broadcasts is None or self.autofill_new_broadcasts is False else 1) | (0 if self.autofill_public_groups is None or self.autofill_public_groups is False else 2) | (0 if self.autofill_new_correspondents is None or self.autofill_new_correspondents is False else 4) | (0 if self.photo is None or self.photo is False else 8)),
            struct.pack('<i', self.id),
            self._serialize_bytes(self.title),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _autofill_new_broadcasts = bool(flags & 1)
        _autofill_public_groups = bool(flags & 2)
        _autofill_new_correspondents = bool(flags & 4)
        _id = reader.read_int()
        _title = reader.tgread_string()
        if flags & 8:
            _photo = reader.tgread_object()
        else:
            _photo = None
        return cls(id=_id, title=_title, autofill_new_broadcasts=_autofill_new_broadcasts, autofill_public_groups=_autofill_public_groups, autofill_new_correspondents=_autofill_new_correspondents, photo=_photo)


@dataclasses.dataclass(init=False, frozen=True)
class FolderPeer(TLObject):
    """
    Constructor for FolderPeer: Instance of FolderPeer.
    """
    __slots__ = ('peer', 'folder_id',)
    CONSTRUCTOR_ID = 0xe9baa668
    SUBCLASS_OF_ID = 0xf3f2283b

    peer: 'TypePeer'
    folder_id: int
    def __init__(self, peer: 'TypePeer', folder_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'folder_id', folder_id)

    def _bytes(self):
        return b''.join((
            b'h\xa6\xba\xe9',
            self.peer._bytes(),
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _folder_id = reader.read_int()
        return cls(peer=_peer, folder_id=_folder_id)


@dataclasses.dataclass(init=False, frozen=True)
class FutureSalt(TLObject):
    """
    Constructor for FutureSalt: Instance of FutureSalt.
    """
    __slots__ = ('valid_since', 'valid_until', 'salt',)
    CONSTRUCTOR_ID = 0x949d9dc
    SUBCLASS_OF_ID = 0x45e53dcf

    valid_since: Optional[datetime]
    valid_until: Optional[datetime]
    salt: int
    def __init__(self, valid_since: Optional[datetime], valid_until: Optional[datetime], salt: int):
        object.__setattr__(self, 'valid_since', valid_since)
        object.__setattr__(self, 'valid_until', valid_until)
        object.__setattr__(self, 'salt', salt)

    def _bytes(self):
        return b''.join((
            b'\xdc\xd9I\t',
            self._serialize_datetime(self.valid_since),
            self._serialize_datetime(self.valid_until),
            struct.pack('<q', self.salt),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _valid_since = reader.tgread_date()
        _valid_until = reader.tgread_date()
        _salt = reader.read_long()
        return cls(valid_since=_valid_since, valid_until=_valid_until, salt=_salt)


@dataclasses.dataclass(init=False, frozen=True)
class FutureSalts(TLObject):
    """
    Constructor for FutureSalts: Instance of FutureSalts.
    """
    __slots__ = ('req_msg_id', 'now', 'salts',)
    CONSTRUCTOR_ID = 0xae500895
    SUBCLASS_OF_ID = 0x1090f517

    req_msg_id: int
    now: int
    salts: List['Typefuture_salt']
    def __init__(self, req_msg_id: int, now: int, salts: List['Typefuture_salt']):
        object.__setattr__(self, 'req_msg_id', req_msg_id)
        object.__setattr__(self, 'now', now)
        object.__setattr__(self, 'salts', salts)

    def _bytes(self):
        return b''.join((
            b'\x95\x08P\xae',
            struct.pack('<q', self.req_msg_id),
            struct.pack('<i', self.now),
            struct.pack('<i', len(self.salts)),b''.join(x._bytes()[4:] for x in self.salts),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _req_msg_id = reader.read_long()
        _now = reader.read_int()
        _salts = []
        for _ in range(reader.read_int()):
            from . import FutureSalt
            _x = FutureSalt._from_reader(reader)
            _salts.append(_x)

        return cls(req_msg_id=_req_msg_id, now=_now, salts=_salts)


@dataclasses.dataclass(init=False, frozen=True)
class Game(TLObject):
    """
    Constructor for Game: Instance of Game.
    """
    __slots__ = ('id', 'access_hash', 'short_name', 'title', 'description', 'photo', 'document',)
    CONSTRUCTOR_ID = 0xbdf9653b
    SUBCLASS_OF_ID = 0x83199eb2

    id: int
    access_hash: int
    short_name: str
    title: str
    description: str
    photo: 'TypePhoto'
    document: Optional['TypeDocument']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, short_name: str, title: str, description: str, photo: 'TypePhoto', document: Optional['TypeDocument']=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'short_name', short_name)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'description', description)
        object.__setattr__(self, 'photo', photo)
        object.__setattr__(self, 'document', document)

    def _bytes(self):
        return b''.join((
            b';e\xf9\xbd',
            struct.pack('<I', (0 if self.document is None or self.document is False else 1)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_bytes(self.short_name),
            self._serialize_bytes(self.title),
            self._serialize_bytes(self.description),
            self.photo._bytes(),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.read_long()
        _access_hash = reader.read_long()
        _short_name = reader.tgread_string()
        _title = reader.tgread_string()
        _description = reader.tgread_string()
        _photo = reader.tgread_object()
        if flags & 1:
            _document = reader.tgread_object()
        else:
            _document = None
        return cls(id=_id, access_hash=_access_hash, short_name=_short_name, title=_title, description=_description, photo=_photo, document=_document)


@dataclasses.dataclass(init=False, frozen=True)
class GeoPoint(TLObject):
    """
    Constructor for GeoPoint: Instance of either GeoPointEmpty, GeoPoint.
    """
    __slots__ = ('long', 'lat', 'access_hash', 'accuracy_radius',)
    CONSTRUCTOR_ID = 0xb2a2f663
    SUBCLASS_OF_ID = 0xd610e16d

    long: float
    lat: float
    access_hash: int
    accuracy_radius: Optional[int]
    def __init__(self, long: float, lat: float, access_hash: int, accuracy_radius: Optional[int]=None):
        object.__setattr__(self, 'long', long)
        object.__setattr__(self, 'lat', lat)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'accuracy_radius', accuracy_radius)

    def _bytes(self):
        return b''.join((
            b'c\xf6\xa2\xb2',
            struct.pack('<I', (0 if self.accuracy_radius is None or self.accuracy_radius is False else 1)),
            struct.pack('<d', self.long),
            struct.pack('<d', self.lat),
            struct.pack('<q', self.access_hash),
            b'' if self.accuracy_radius is None or self.accuracy_radius is False else (struct.pack('<i', self.accuracy_radius)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _long = reader.read_double()
        _lat = reader.read_double()
        _access_hash = reader.read_long()
        if flags & 1:
            _accuracy_radius = reader.read_int()
        else:
            _accuracy_radius = None
        return cls(long=_long, lat=_lat, access_hash=_access_hash, accuracy_radius=_accuracy_radius)


@dataclasses.dataclass(init=False, frozen=True)
class GeoPointEmpty(TLObject):
    """
    Constructor for GeoPoint: Instance of either GeoPointEmpty, GeoPoint.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x1117dd5f
    SUBCLASS_OF_ID = 0xd610e16d

    def _bytes(self):
        return b''.join((
            b'_\xdd\x17\x11',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class GlobalPrivacySettings(TLObject):
    """
    Constructor for GlobalPrivacySettings: Instance of GlobalPrivacySettings.
    """
    __slots__ = ('archive_and_mute_new_noncontact_peers',)
    CONSTRUCTOR_ID = 0xbea2f424
    SUBCLASS_OF_ID = 0xc90e5770

    archive_and_mute_new_noncontact_peers: Optional[bool]
    def __init__(self, archive_and_mute_new_noncontact_peers: Optional[bool]=None):
        object.__setattr__(self, 'archive_and_mute_new_noncontact_peers', archive_and_mute_new_noncontact_peers)

    def _bytes(self):
        return b''.join((
            b'$\xf4\xa2\xbe',
            struct.pack('<I', (0 if self.archive_and_mute_new_noncontact_peers is None else 1)),
            b'' if self.archive_and_mute_new_noncontact_peers is None else (b'\xb5ur\x99' if self.archive_and_mute_new_noncontact_peers else b'7\x97y\xbc'),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _archive_and_mute_new_noncontact_peers = reader.tgread_bool()
        else:
            _archive_and_mute_new_noncontact_peers = None
        return cls(archive_and_mute_new_noncontact_peers=_archive_and_mute_new_noncontact_peers)


@dataclasses.dataclass(init=False, frozen=True)
class GroupCall(TLObject):
    """
    Constructor for GroupCall: Instance of either GroupCallDiscarded, GroupCall.
    """
    __slots__ = ('id', 'access_hash', 'participants_count', 'unmuted_video_limit', 'version', 'join_muted', 'can_change_join_muted', 'join_date_asc', 'schedule_start_subscribed', 'can_start_video', 'record_video_active', 'rtmp_stream', 'listeners_hidden', 'title', 'stream_dc_id', 'record_start_date', 'schedule_date', 'unmuted_video_count',)
    CONSTRUCTOR_ID = 0xd597650c
    SUBCLASS_OF_ID = 0x20b4f320

    id: int
    access_hash: int
    participants_count: int
    unmuted_video_limit: int
    version: int
    join_muted: Optional[bool]
    can_change_join_muted: Optional[bool]
    join_date_asc: Optional[bool]
    schedule_start_subscribed: Optional[bool]
    can_start_video: Optional[bool]
    record_video_active: Optional[bool]
    rtmp_stream: Optional[bool]
    listeners_hidden: Optional[bool]
    title: Optional[str]
    stream_dc_id: Optional[int]
    record_start_date: Optional[datetime]
    schedule_date: Optional[datetime]
    unmuted_video_count: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, participants_count: int, unmuted_video_limit: int, version: int, join_muted: Optional[bool]=None, can_change_join_muted: Optional[bool]=None, join_date_asc: Optional[bool]=None, schedule_start_subscribed: Optional[bool]=None, can_start_video: Optional[bool]=None, record_video_active: Optional[bool]=None, rtmp_stream: Optional[bool]=None, listeners_hidden: Optional[bool]=None, title: Optional[str]=None, stream_dc_id: Optional[int]=None, record_start_date: Optional[datetime]=None, schedule_date: Optional[datetime]=None, unmuted_video_count: Optional[int]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'participants_count', participants_count)
        object.__setattr__(self, 'unmuted_video_limit', unmuted_video_limit)
        object.__setattr__(self, 'version', version)
        object.__setattr__(self, 'join_muted', join_muted)
        object.__setattr__(self, 'can_change_join_muted', can_change_join_muted)
        object.__setattr__(self, 'join_date_asc', join_date_asc)
        object.__setattr__(self, 'schedule_start_subscribed', schedule_start_subscribed)
        object.__setattr__(self, 'can_start_video', can_start_video)
        object.__setattr__(self, 'record_video_active', record_video_active)
        object.__setattr__(self, 'rtmp_stream', rtmp_stream)
        object.__setattr__(self, 'listeners_hidden', listeners_hidden)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'stream_dc_id', stream_dc_id)
        object.__setattr__(self, 'record_start_date', record_start_date)
        object.__setattr__(self, 'schedule_date', schedule_date)
        object.__setattr__(self, 'unmuted_video_count', unmuted_video_count)

    def _bytes(self):
        return b''.join((
            b'\x0ce\x97\xd5',
            struct.pack('<I', (0 if self.join_muted is None or self.join_muted is False else 2) | (0 if self.can_change_join_muted is None or self.can_change_join_muted is False else 4) | (0 if self.join_date_asc is None or self.join_date_asc is False else 64) | (0 if self.schedule_start_subscribed is None or self.schedule_start_subscribed is False else 256) | (0 if self.can_start_video is None or self.can_start_video is False else 512) | (0 if self.record_video_active is None or self.record_video_active is False else 2048) | (0 if self.rtmp_stream is None or self.rtmp_stream is False else 4096) | (0 if self.listeners_hidden is None or self.listeners_hidden is False else 8192) | (0 if self.title is None or self.title is False else 8) | (0 if self.stream_dc_id is None or self.stream_dc_id is False else 16) | (0 if self.record_start_date is None or self.record_start_date is False else 32) | (0 if self.schedule_date is None or self.schedule_date is False else 128) | (0 if self.unmuted_video_count is None or self.unmuted_video_count is False else 1024)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            struct.pack('<i', self.participants_count),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
            b'' if self.stream_dc_id is None or self.stream_dc_id is False else (struct.pack('<i', self.stream_dc_id)),
            b'' if self.record_start_date is None or self.record_start_date is False else (self._serialize_datetime(self.record_start_date)),
            b'' if self.schedule_date is None or self.schedule_date is False else (self._serialize_datetime(self.schedule_date)),
            b'' if self.unmuted_video_count is None or self.unmuted_video_count is False else (struct.pack('<i', self.unmuted_video_count)),
            struct.pack('<i', self.unmuted_video_limit),
            struct.pack('<i', self.version),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _join_muted = bool(flags & 2)
        _can_change_join_muted = bool(flags & 4)
        _join_date_asc = bool(flags & 64)
        _schedule_start_subscribed = bool(flags & 256)
        _can_start_video = bool(flags & 512)
        _record_video_active = bool(flags & 2048)
        _rtmp_stream = bool(flags & 4096)
        _listeners_hidden = bool(flags & 8192)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _participants_count = reader.read_int()
        if flags & 8:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 16:
            _stream_dc_id = reader.read_int()
        else:
            _stream_dc_id = None
        if flags & 32:
            _record_start_date = reader.tgread_date()
        else:
            _record_start_date = None
        if flags & 128:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        if flags & 1024:
            _unmuted_video_count = reader.read_int()
        else:
            _unmuted_video_count = None
        _unmuted_video_limit = reader.read_int()
        _version = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, participants_count=_participants_count, unmuted_video_limit=_unmuted_video_limit, version=_version, join_muted=_join_muted, can_change_join_muted=_can_change_join_muted, join_date_asc=_join_date_asc, schedule_start_subscribed=_schedule_start_subscribed, can_start_video=_can_start_video, record_video_active=_record_video_active, rtmp_stream=_rtmp_stream, listeners_hidden=_listeners_hidden, title=_title, stream_dc_id=_stream_dc_id, record_start_date=_record_start_date, schedule_date=_schedule_date, unmuted_video_count=_unmuted_video_count)


@dataclasses.dataclass(init=False, frozen=True)
class GroupCallDiscarded(TLObject):
    """
    Constructor for GroupCall: Instance of either GroupCallDiscarded, GroupCall.
    """
    __slots__ = ('id', 'access_hash', 'duration',)
    CONSTRUCTOR_ID = 0x7780bcb4
    SUBCLASS_OF_ID = 0x20b4f320

    id: int
    access_hash: int
    duration: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, duration: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'duration', duration)

    def _bytes(self):
        return b''.join((
            b'\xb4\xbc\x80w',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            struct.pack('<i', self.duration),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _duration = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, duration=_duration)


@dataclasses.dataclass(init=False, frozen=True)
class GroupCallParticipant(TLObject):
    """
    Constructor for GroupCallParticipant: Instance of GroupCallParticipant.
    """
    __slots__ = ('peer', 'date', 'source', 'muted', 'left', 'can_self_unmute', 'just_joined', 'versioned', 'min', 'muted_by_you', 'volume_by_admin', 'is_self', 'video_joined', 'active_date', 'volume', 'about', 'raise_hand_rating', 'video', 'presentation',)
    CONSTRUCTOR_ID = 0xeba636fe
    SUBCLASS_OF_ID = 0xc01aaf4c

    peer: 'TypePeer'
    date: Optional[datetime]
    source: int
    muted: Optional[bool]
    left: Optional[bool]
    can_self_unmute: Optional[bool]
    just_joined: Optional[bool]
    versioned: Optional[bool]
    min: Optional[bool]
    muted_by_you: Optional[bool]
    volume_by_admin: Optional[bool]
    is_self: Optional[bool]
    video_joined: Optional[bool]
    active_date: Optional[datetime]
    volume: Optional[int]
    about: Optional[str]
    raise_hand_rating: Optional[int]
    video: Optional['TypeGroupCallParticipantVideo']
    presentation: Optional['TypeGroupCallParticipantVideo']
    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypePeer', date: Optional[datetime], source: int, muted: Optional[bool]=None, left: Optional[bool]=None, can_self_unmute: Optional[bool]=None, just_joined: Optional[bool]=None, versioned: Optional[bool]=None, min: Optional[bool]=None, muted_by_you: Optional[bool]=None, volume_by_admin: Optional[bool]=None, is_self: Optional[bool]=None, video_joined: Optional[bool]=None, active_date: Optional[datetime]=None, volume: Optional[int]=None, about: Optional[str]=None, raise_hand_rating: Optional[int]=None, video: Optional['TypeGroupCallParticipantVideo']=None, presentation: Optional['TypeGroupCallParticipantVideo']=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'source', source)
        object.__setattr__(self, 'muted', muted)
        object.__setattr__(self, 'left', left)
        object.__setattr__(self, 'can_self_unmute', can_self_unmute)
        object.__setattr__(self, 'just_joined', just_joined)
        object.__setattr__(self, 'versioned', versioned)
        object.__setattr__(self, 'min', min)
        object.__setattr__(self, 'muted_by_you', muted_by_you)
        object.__setattr__(self, 'volume_by_admin', volume_by_admin)
        object.__setattr__(self, 'is_self', is_self)
        object.__setattr__(self, 'video_joined', video_joined)
        object.__setattr__(self, 'active_date', active_date)
        object.__setattr__(self, 'volume', volume)
        object.__setattr__(self, 'about', about)
        object.__setattr__(self, 'raise_hand_rating', raise_hand_rating)
        object.__setattr__(self, 'video', video)
        object.__setattr__(self, 'presentation', presentation)

    def _bytes(self):
        return b''.join((
            b'\xfe6\xa6\xeb',
            struct.pack('<I', (0 if self.muted is None or self.muted is False else 1) | (0 if self.left is None or self.left is False else 2) | (0 if self.can_self_unmute is None or self.can_self_unmute is False else 4) | (0 if self.just_joined is None or self.just_joined is False else 16) | (0 if self.versioned is None or self.versioned is False else 32) | (0 if self.min is None or self.min is False else 256) | (0 if self.muted_by_you is None or self.muted_by_you is False else 512) | (0 if self.volume_by_admin is None or self.volume_by_admin is False else 1024) | (0 if self.is_self is None or self.is_self is False else 4096) | (0 if self.video_joined is None or self.video_joined is False else 32768) | (0 if self.active_date is None or self.active_date is False else 8) | (0 if self.volume is None or self.volume is False else 128) | (0 if self.about is None or self.about is False else 2048) | (0 if self.raise_hand_rating is None or self.raise_hand_rating is False else 8192) | (0 if self.video is None or self.video is False else 64) | (0 if self.presentation is None or self.presentation is False else 16384)),
            self.peer._bytes(),
            self._serialize_datetime(self.date),
            b'' if self.active_date is None or self.active_date is False else (self._serialize_datetime(self.active_date)),
            struct.pack('<i', self.source),
            b'' if self.volume is None or self.volume is False else (struct.pack('<i', self.volume)),
            b'' if self.about is None or self.about is False else (self._serialize_bytes(self.about)),
            b'' if self.raise_hand_rating is None or self.raise_hand_rating is False else (struct.pack('<q', self.raise_hand_rating)),
            b'' if self.video is None or self.video is False else (self.video._bytes()),
            b'' if self.presentation is None or self.presentation is False else (self.presentation._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _muted = bool(flags & 1)
        _left = bool(flags & 2)
        _can_self_unmute = bool(flags & 4)
        _just_joined = bool(flags & 16)
        _versioned = bool(flags & 32)
        _min = bool(flags & 256)
        _muted_by_you = bool(flags & 512)
        _volume_by_admin = bool(flags & 1024)
        _is_self = bool(flags & 4096)
        _video_joined = bool(flags & 32768)
        _peer = reader.tgread_object()
        _date = reader.tgread_date()
        if flags & 8:
            _active_date = reader.tgread_date()
        else:
            _active_date = None
        _source = reader.read_int()
        if flags & 128:
            _volume = reader.read_int()
        else:
            _volume = None
        if flags & 2048:
            _about = reader.tgread_string()
        else:
            _about = None
        if flags & 8192:
            _raise_hand_rating = reader.read_long()
        else:
            _raise_hand_rating = None
        if flags & 64:
            _video = reader.tgread_object()
        else:
            _video = None
        if flags & 16384:
            _presentation = reader.tgread_object()
        else:
            _presentation = None
        return cls(peer=_peer, date=_date, source=_source, muted=_muted, left=_left, can_self_unmute=_can_self_unmute, just_joined=_just_joined, versioned=_versioned, min=_min, muted_by_you=_muted_by_you, volume_by_admin=_volume_by_admin, is_self=_is_self, video_joined=_video_joined, active_date=_active_date, volume=_volume, about=_about, raise_hand_rating=_raise_hand_rating, video=_video, presentation=_presentation)


@dataclasses.dataclass(init=False, frozen=True)
class GroupCallParticipantVideo(TLObject):
    """
    Constructor for GroupCallParticipantVideo: Instance of GroupCallParticipantVideo.
    """
    __slots__ = ('endpoint', 'source_groups', 'paused', 'audio_source',)
    CONSTRUCTOR_ID = 0x67753ac8
    SUBCLASS_OF_ID = 0xef46b8db

    endpoint: str
    source_groups: List['TypeGroupCallParticipantVideoSourceGroup']
    paused: Optional[bool]
    audio_source: Optional[int]
    def __init__(self, endpoint: str, source_groups: List['TypeGroupCallParticipantVideoSourceGroup'], paused: Optional[bool]=None, audio_source: Optional[int]=None):
        object.__setattr__(self, 'endpoint', endpoint)
        object.__setattr__(self, 'source_groups', source_groups)
        object.__setattr__(self, 'paused', paused)
        object.__setattr__(self, 'audio_source', audio_source)

    def _bytes(self):
        return b''.join((
            b'\xc8:ug',
            struct.pack('<I', (0 if self.paused is None or self.paused is False else 1) | (0 if self.audio_source is None or self.audio_source is False else 2)),
            self._serialize_bytes(self.endpoint),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.source_groups)),b''.join(x._bytes() for x in self.source_groups),
            b'' if self.audio_source is None or self.audio_source is False else (struct.pack('<i', self.audio_source)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _paused = bool(flags & 1)
        _endpoint = reader.tgread_string()
        reader.read_int()
        _source_groups = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _source_groups.append(_x)

        if flags & 2:
            _audio_source = reader.read_int()
        else:
            _audio_source = None
        return cls(endpoint=_endpoint, source_groups=_source_groups, paused=_paused, audio_source=_audio_source)


@dataclasses.dataclass(init=False, frozen=True)
class GroupCallParticipantVideoSourceGroup(TLObject):
    """
    Constructor for GroupCallParticipantVideoSourceGroup: Instance of GroupCallParticipantVideoSourceGroup.
    """
    __slots__ = ('semantics', 'sources',)
    CONSTRUCTOR_ID = 0xdcb118b7
    SUBCLASS_OF_ID = 0x3015f87c

    semantics: str
    sources: List[int]
    def __init__(self, semantics: str, sources: List[int]):
        object.__setattr__(self, 'semantics', semantics)
        object.__setattr__(self, 'sources', sources)

    def _bytes(self):
        return b''.join((
            b'\xb7\x18\xb1\xdc',
            self._serialize_bytes(self.semantics),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sources)),b''.join(struct.pack('<i', x) for x in self.sources),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _semantics = reader.tgread_string()
        reader.read_int()
        _sources = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _sources.append(_x)

        return cls(semantics=_semantics, sources=_sources)


@dataclasses.dataclass(init=False, frozen=True)
class GroupCallStreamChannel(TLObject):
    """
    Constructor for GroupCallStreamChannel: Instance of GroupCallStreamChannel.
    """
    __slots__ = ('channel', 'scale', 'last_timestamp_ms',)
    CONSTRUCTOR_ID = 0x80eb48af
    SUBCLASS_OF_ID = 0xdd44b258

    channel: int
    scale: int
    last_timestamp_ms: int
    def __init__(self, channel: int, scale: int, last_timestamp_ms: int):
        object.__setattr__(self, 'channel', channel)
        object.__setattr__(self, 'scale', scale)
        object.__setattr__(self, 'last_timestamp_ms', last_timestamp_ms)

    def _bytes(self):
        return b''.join((
            b'\xafH\xeb\x80',
            struct.pack('<i', self.channel),
            struct.pack('<i', self.scale),
            struct.pack('<q', self.last_timestamp_ms),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.read_int()
        _scale = reader.read_int()
        _last_timestamp_ms = reader.read_long()
        return cls(channel=_channel, scale=_scale, last_timestamp_ms=_last_timestamp_ms)


@dataclasses.dataclass(init=False, frozen=True)
class HighScore(TLObject):
    """
    Constructor for HighScore: Instance of HighScore.
    """
    __slots__ = ('pos', 'user_id', 'score',)
    CONSTRUCTOR_ID = 0x73a379eb
    SUBCLASS_OF_ID = 0xd32b1e35

    pos: int
    user_id: int
    score: int
    def __init__(self, pos: int, user_id: int, score: int):
        object.__setattr__(self, 'pos', pos)
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'score', score)

    def _bytes(self):
        return b''.join((
            b'\xeby\xa3s',
            struct.pack('<i', self.pos),
            struct.pack('<q', self.user_id),
            struct.pack('<i', self.score),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _pos = reader.read_int()
        _user_id = reader.read_long()
        _score = reader.read_int()
        return cls(pos=_pos, user_id=_user_id, score=_score)


@dataclasses.dataclass(init=False, frozen=True)
class HttpWait(TLObject):
    """
    Constructor for HttpWait: Instance of HttpWait.
    """
    __slots__ = ('max_delay', 'wait_after', 'max_wait',)
    CONSTRUCTOR_ID = 0x9299359f
    SUBCLASS_OF_ID = 0x1284aed6

    max_delay: int
    wait_after: int
    max_wait: int
    def __init__(self, max_delay: int, wait_after: int, max_wait: int):
        object.__setattr__(self, 'max_delay', max_delay)
        object.__setattr__(self, 'wait_after', wait_after)
        object.__setattr__(self, 'max_wait', max_wait)

    def _bytes(self):
        return b''.join((
            b'\x9f5\x99\x92',
            struct.pack('<i', self.max_delay),
            struct.pack('<i', self.wait_after),
            struct.pack('<i', self.max_wait),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _max_delay = reader.read_int()
        _wait_after = reader.read_int()
        _max_wait = reader.read_int()
        return cls(max_delay=_max_delay, wait_after=_wait_after, max_wait=_max_wait)


@dataclasses.dataclass(init=False, frozen=True)
class ImportedContact(TLObject):
    """
    Constructor for ImportedContact: Instance of ImportedContact.
    """
    __slots__ = ('user_id', 'client_id',)
    CONSTRUCTOR_ID = 0xc13e3c50
    SUBCLASS_OF_ID = 0xb545bbda

    user_id: int
    client_id: int
    def __init__(self, user_id: int, client_id: int):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'client_id', client_id)

    def _bytes(self):
        return b''.join((
            b'P<>\xc1',
            struct.pack('<q', self.user_id),
            struct.pack('<q', self.client_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _client_id = reader.read_long()
        return cls(user_id=_user_id, client_id=_client_id)


@dataclasses.dataclass(init=False, frozen=True)
class InlineBotSwitchPM(TLObject):
    """
    Constructor for InlineBotSwitchPM: Instance of InlineBotSwitchPM.
    """
    __slots__ = ('text', 'start_param',)
    CONSTRUCTOR_ID = 0x3c20629f
    SUBCLASS_OF_ID = 0x82b1f73b

    text: str
    start_param: str
    def __init__(self, text: str, start_param: str):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'start_param', start_param)

    def _bytes(self):
        return b''.join((
            b'\x9fb <',
            self._serialize_bytes(self.text),
            self._serialize_bytes(self.start_param),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_string()
        _start_param = reader.tgread_string()
        return cls(text=_text, start_param=_start_param)


@dataclasses.dataclass(init=False, frozen=True)
class InlineQueryPeerTypeBroadcast(TLObject):
    """
    Constructor for InlineQueryPeerType: Instance of either InlineQueryPeerTypeSameBotPM, InlineQueryPeerTypePM, InlineQueryPeerTypeChat, InlineQueryPeerTypeMegagroup, InlineQueryPeerTypeBroadcast.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x6334ee9a
    SUBCLASS_OF_ID = 0xafb0fa1f

    def _bytes(self):
        return b''.join((
            b'\x9a\xee4c',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InlineQueryPeerTypeChat(TLObject):
    """
    Constructor for InlineQueryPeerType: Instance of either InlineQueryPeerTypeSameBotPM, InlineQueryPeerTypePM, InlineQueryPeerTypeChat, InlineQueryPeerTypeMegagroup, InlineQueryPeerTypeBroadcast.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd766c50a
    SUBCLASS_OF_ID = 0xafb0fa1f

    def _bytes(self):
        return b''.join((
            b'\n\xc5f\xd7',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InlineQueryPeerTypeMegagroup(TLObject):
    """
    Constructor for InlineQueryPeerType: Instance of either InlineQueryPeerTypeSameBotPM, InlineQueryPeerTypePM, InlineQueryPeerTypeChat, InlineQueryPeerTypeMegagroup, InlineQueryPeerTypeBroadcast.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x5ec4be43
    SUBCLASS_OF_ID = 0xafb0fa1f

    def _bytes(self):
        return b''.join((
            b'C\xbe\xc4^',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InlineQueryPeerTypePM(TLObject):
    """
    Constructor for InlineQueryPeerType: Instance of either InlineQueryPeerTypeSameBotPM, InlineQueryPeerTypePM, InlineQueryPeerTypeChat, InlineQueryPeerTypeMegagroup, InlineQueryPeerTypeBroadcast.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x833c0fac
    SUBCLASS_OF_ID = 0xafb0fa1f

    def _bytes(self):
        return b''.join((
            b'\xac\x0f<\x83',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InlineQueryPeerTypeSameBotPM(TLObject):
    """
    Constructor for InlineQueryPeerType: Instance of either InlineQueryPeerTypeSameBotPM, InlineQueryPeerTypePM, InlineQueryPeerTypeChat, InlineQueryPeerTypeMegagroup, InlineQueryPeerTypeBroadcast.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x3081ed9d
    SUBCLASS_OF_ID = 0xafb0fa1f

    def _bytes(self):
        return b''.join((
            b'\x9d\xed\x810',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputAppEvent(TLObject):
    """
    Constructor for InputAppEvent: Instance of InputAppEvent.
    """
    __slots__ = ('time', 'type', 'peer', 'data',)
    CONSTRUCTOR_ID = 0x1d1b1245
    SUBCLASS_OF_ID = 0x89322106

    time: float
    type: str
    peer: int
    data: 'TypeJSONValue'
    # noinspection PyShadowingBuiltins
    def __init__(self, time: float, type: str, peer: int, data: 'TypeJSONValue'):
        object.__setattr__(self, 'time', time)
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'data', data)

    def _bytes(self):
        return b''.join((
            b'E\x12\x1b\x1d',
            struct.pack('<d', self.time),
            self._serialize_bytes(self.type),
            struct.pack('<q', self.peer),
            self.data._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _time = reader.read_double()
        _type = reader.tgread_string()
        _peer = reader.read_long()
        _data = reader.tgread_object()
        return cls(time=_time, type=_type, peer=_peer, data=_data)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineMessageGame(TLObject):
    """
    Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice.
    """
    __slots__ = ('reply_markup',)
    CONSTRUCTOR_ID = 0x4b425864
    SUBCLASS_OF_ID = 0x53fb4010

    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'dXBK',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineMessageID(TLObject):
    """
    Constructor for InputBotInlineMessageID: Instance of either InputBotInlineMessageID, InputBotInlineMessageID64.
    """
    __slots__ = ('dc_id', 'id', 'access_hash',)
    CONSTRUCTOR_ID = 0x890c3d89
    SUBCLASS_OF_ID = 0x2dcd6300

    dc_id: int
    id: int
    access_hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, dc_id: int, id: int, access_hash: int):
        object.__setattr__(self, 'dc_id', dc_id)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'\x89=\x0c\x89',
            struct.pack('<i', self.dc_id),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _dc_id = reader.read_int()
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(dc_id=_dc_id, id=_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineMessageID64(TLObject):
    """
    Constructor for InputBotInlineMessageID: Instance of either InputBotInlineMessageID, InputBotInlineMessageID64.
    """
    __slots__ = ('dc_id', 'owner_id', 'id', 'access_hash',)
    CONSTRUCTOR_ID = 0xb6d915d7
    SUBCLASS_OF_ID = 0x2dcd6300

    dc_id: int
    owner_id: int
    id: int
    access_hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, dc_id: int, owner_id: int, id: int, access_hash: int):
        object.__setattr__(self, 'dc_id', dc_id)
        object.__setattr__(self, 'owner_id', owner_id)
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'\xd7\x15\xd9\xb6',
            struct.pack('<i', self.dc_id),
            struct.pack('<q', self.owner_id),
            struct.pack('<i', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _dc_id = reader.read_int()
        _owner_id = reader.read_long()
        _id = reader.read_int()
        _access_hash = reader.read_long()
        return cls(dc_id=_dc_id, owner_id=_owner_id, id=_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineMessageMediaAuto(TLObject):
    """
    Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice.
    """
    __slots__ = ('message', 'entities', 'reply_markup',)
    CONSTRUCTOR_ID = 0x3380c786
    SUBCLASS_OF_ID = 0x53fb4010

    message: str
    entities: Optional[List['TypeMessageEntity']]
    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, message: str, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'entities', entities)
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'\x86\xc7\x803',
            struct.pack('<I', (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self._serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, entities=_entities, reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineMessageMediaContact(TLObject):
    """
    Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice.
    """
    __slots__ = ('phone_number', 'first_name', 'last_name', 'vcard', 'reply_markup',)
    CONSTRUCTOR_ID = 0xa6edbffd
    SUBCLASS_OF_ID = 0x53fb4010

    phone_number: str
    first_name: str
    last_name: str
    vcard: str
    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, phone_number: str, first_name: str, last_name: str, vcard: str, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'first_name', first_name)
        object.__setattr__(self, 'last_name', last_name)
        object.__setattr__(self, 'vcard', vcard)
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'\xfd\xbf\xed\xa6',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self._serialize_bytes(self.phone_number),
            self._serialize_bytes(self.first_name),
            self._serialize_bytes(self.last_name),
            self._serialize_bytes(self.vcard),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _phone_number = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _vcard = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(phone_number=_phone_number, first_name=_first_name, last_name=_last_name, vcard=_vcard, reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineMessageMediaGeo(TLObject):
    """
    Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice.
    """
    __slots__ = ('geo_point', 'heading', 'period', 'proximity_notification_radius', 'reply_markup',)
    CONSTRUCTOR_ID = 0x96929a85
    SUBCLASS_OF_ID = 0x53fb4010

    geo_point: 'TypeInputGeoPoint'
    heading: Optional[int]
    period: Optional[int]
    proximity_notification_radius: Optional[int]
    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, geo_point: 'TypeInputGeoPoint', heading: Optional[int]=None, period: Optional[int]=None, proximity_notification_radius: Optional[int]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'geo_point', geo_point)
        object.__setattr__(self, 'heading', heading)
        object.__setattr__(self, 'period', period)
        object.__setattr__(self, 'proximity_notification_radius', proximity_notification_radius)
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'\x85\x9a\x92\x96',
            struct.pack('<I', (0 if self.heading is None or self.heading is False else 1) | (0 if self.period is None or self.period is False else 2) | (0 if self.proximity_notification_radius is None or self.proximity_notification_radius is False else 8) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.geo_point._bytes(),
            b'' if self.heading is None or self.heading is False else (struct.pack('<i', self.heading)),
            b'' if self.period is None or self.period is False else (struct.pack('<i', self.period)),
            b'' if self.proximity_notification_radius is None or self.proximity_notification_radius is False else (struct.pack('<i', self.proximity_notification_radius)),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _geo_point = reader.tgread_object()
        if flags & 1:
            _heading = reader.read_int()
        else:
            _heading = None
        if flags & 2:
            _period = reader.read_int()
        else:
            _period = None
        if flags & 8:
            _proximity_notification_radius = reader.read_int()
        else:
            _proximity_notification_radius = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(geo_point=_geo_point, heading=_heading, period=_period, proximity_notification_radius=_proximity_notification_radius, reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineMessageMediaInvoice(TLObject):
    """
    Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice.
    """
    __slots__ = ('title', 'description', 'invoice', 'payload', 'provider', 'provider_data', 'photo', 'reply_markup',)
    CONSTRUCTOR_ID = 0xd7e78225
    SUBCLASS_OF_ID = 0x53fb4010

    title: str
    description: str
    invoice: 'TypeInvoice'
    payload: bytes
    provider: str
    provider_data: 'TypeDataJSON'
    photo: Optional['TypeInputWebDocument']
    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, title: str, description: str, invoice: 'TypeInvoice', payload: bytes, provider: str, provider_data: 'TypeDataJSON', photo: Optional['TypeInputWebDocument']=None, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'description', description)
        object.__setattr__(self, 'invoice', invoice)
        object.__setattr__(self, 'payload', payload)
        object.__setattr__(self, 'provider', provider)
        object.__setattr__(self, 'provider_data', provider_data)
        object.__setattr__(self, 'photo', photo)
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'%\x82\xe7\xd7',
            struct.pack('<I', (0 if self.photo is None or self.photo is False else 1) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self._serialize_bytes(self.title),
            self._serialize_bytes(self.description),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
            self.invoice._bytes(),
            self._serialize_bytes(self.payload),
            self._serialize_bytes(self.provider),
            self.provider_data._bytes(),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _title = reader.tgread_string()
        _description = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        _invoice = reader.tgread_object()
        _payload = reader.tgread_bytes()
        _provider = reader.tgread_string()
        _provider_data = reader.tgread_object()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(title=_title, description=_description, invoice=_invoice, payload=_payload, provider=_provider, provider_data=_provider_data, photo=_photo, reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineMessageMediaVenue(TLObject):
    """
    Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice.
    """
    __slots__ = ('geo_point', 'title', 'address', 'provider', 'venue_id', 'venue_type', 'reply_markup',)
    CONSTRUCTOR_ID = 0x417bbf11
    SUBCLASS_OF_ID = 0x53fb4010

    geo_point: 'TypeInputGeoPoint'
    title: str
    address: str
    provider: str
    venue_id: str
    venue_type: str
    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, geo_point: 'TypeInputGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'geo_point', geo_point)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'address', address)
        object.__setattr__(self, 'provider', provider)
        object.__setattr__(self, 'venue_id', venue_id)
        object.__setattr__(self, 'venue_type', venue_type)
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'\x11\xbf{A',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.geo_point._bytes(),
            self._serialize_bytes(self.title),
            self._serialize_bytes(self.address),
            self._serialize_bytes(self.provider),
            self._serialize_bytes(self.venue_id),
            self._serialize_bytes(self.venue_type),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _geo_point = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(geo_point=_geo_point, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type, reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineMessageText(TLObject):
    """
    Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice.
    """
    __slots__ = ('message', 'no_webpage', 'entities', 'reply_markup',)
    CONSTRUCTOR_ID = 0x3dcd7a87
    SUBCLASS_OF_ID = 0x53fb4010

    message: str
    no_webpage: Optional[bool]
    entities: Optional[List['TypeMessageEntity']]
    reply_markup: Optional['TypeReplyMarkup']
    def __init__(self, message: str, no_webpage: Optional[bool]=None, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'no_webpage', no_webpage)
        object.__setattr__(self, 'entities', entities)
        object.__setattr__(self, 'reply_markup', reply_markup)

    def _bytes(self):
        return b''.join((
            b'\x87z\xcd=',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 1) | (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self._serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 1)
        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, no_webpage=_no_webpage, entities=_entities, reply_markup=_reply_markup)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineResult(TLObject):
    """
    Constructor for InputBotInlineResult: Instance of either InputBotInlineResult, InputBotInlineResultPhoto, InputBotInlineResultDocument, InputBotInlineResultGame.
    """
    __slots__ = ('id', 'type', 'send_message', 'title', 'description', 'url', 'thumb', 'content',)
    CONSTRUCTOR_ID = 0x88bf9319
    SUBCLASS_OF_ID = 0x80a4a3de

    id: str
    type: str
    send_message: 'TypeInputBotInlineMessage'
    title: Optional[str]
    description: Optional[str]
    url: Optional[str]
    thumb: Optional['TypeInputWebDocument']
    content: Optional['TypeInputWebDocument']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, send_message: 'TypeInputBotInlineMessage', title: Optional[str]=None, description: Optional[str]=None, url: Optional[str]=None, thumb: Optional['TypeInputWebDocument']=None, content: Optional['TypeInputWebDocument']=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'send_message', send_message)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'description', description)
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'thumb', thumb)
        object.__setattr__(self, 'content', content)

    def _bytes(self):
        return b''.join((
            b'\x19\x93\xbf\x88',
            struct.pack('<I', (0 if self.title is None or self.title is False else 2) | (0 if self.description is None or self.description is False else 4) | (0 if self.url is None or self.url is False else 8) | (0 if self.thumb is None or self.thumb is False else 16) | (0 if self.content is None or self.content is False else 32)),
            self._serialize_bytes(self.id),
            self._serialize_bytes(self.type),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self._serialize_bytes(self.description)),
            b'' if self.url is None or self.url is False else (self._serialize_bytes(self.url)),
            b'' if self.thumb is None or self.thumb is False else (self.thumb._bytes()),
            b'' if self.content is None or self.content is False else (self.content._bytes()),
            self.send_message._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_string()
        _type = reader.tgread_string()
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 4:
            _description = reader.tgread_string()
        else:
            _description = None
        if flags & 8:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 16:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        if flags & 32:
            _content = reader.tgread_object()
        else:
            _content = None
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, send_message=_send_message, title=_title, description=_description, url=_url, thumb=_thumb, content=_content)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineResultDocument(TLObject):
    """
    Constructor for InputBotInlineResult: Instance of either InputBotInlineResult, InputBotInlineResultPhoto, InputBotInlineResultDocument, InputBotInlineResultGame.
    """
    __slots__ = ('id', 'type', 'document', 'send_message', 'title', 'description',)
    CONSTRUCTOR_ID = 0xfff8fdc4
    SUBCLASS_OF_ID = 0x80a4a3de

    id: str
    type: str
    document: 'TypeInputDocument'
    send_message: 'TypeInputBotInlineMessage'
    title: Optional[str]
    description: Optional[str]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, document: 'TypeInputDocument', send_message: 'TypeInputBotInlineMessage', title: Optional[str]=None, description: Optional[str]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'document', document)
        object.__setattr__(self, 'send_message', send_message)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'description', description)

    def _bytes(self):
        return b''.join((
            b'\xc4\xfd\xf8\xff',
            struct.pack('<I', (0 if self.title is None or self.title is False else 2) | (0 if self.description is None or self.description is False else 4)),
            self._serialize_bytes(self.id),
            self._serialize_bytes(self.type),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self._serialize_bytes(self.description)),
            self.document._bytes(),
            self.send_message._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_string()
        _type = reader.tgread_string()
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 4:
            _description = reader.tgread_string()
        else:
            _description = None
        _document = reader.tgread_object()
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, document=_document, send_message=_send_message, title=_title, description=_description)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineResultGame(TLObject):
    """
    Constructor for InputBotInlineResult: Instance of either InputBotInlineResult, InputBotInlineResultPhoto, InputBotInlineResultDocument, InputBotInlineResultGame.
    """
    __slots__ = ('id', 'short_name', 'send_message',)
    CONSTRUCTOR_ID = 0x4fa417f2
    SUBCLASS_OF_ID = 0x80a4a3de

    id: str
    short_name: str
    send_message: 'TypeInputBotInlineMessage'
    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, short_name: str, send_message: 'TypeInputBotInlineMessage'):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'short_name', short_name)
        object.__setattr__(self, 'send_message', send_message)

    def _bytes(self):
        return b''.join((
            b'\xf2\x17\xa4O',
            self._serialize_bytes(self.id),
            self._serialize_bytes(self.short_name),
            self.send_message._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_string()
        _short_name = reader.tgread_string()
        _send_message = reader.tgread_object()
        return cls(id=_id, short_name=_short_name, send_message=_send_message)


@dataclasses.dataclass(init=False, frozen=True)
class InputBotInlineResultPhoto(TLObject):
    """
    Constructor for InputBotInlineResult: Instance of either InputBotInlineResult, InputBotInlineResultPhoto, InputBotInlineResultDocument, InputBotInlineResultGame.
    """
    __slots__ = ('id', 'type', 'photo', 'send_message',)
    CONSTRUCTOR_ID = 0xa8d864a7
    SUBCLASS_OF_ID = 0x80a4a3de

    id: str
    type: str
    photo: 'TypeInputPhoto'
    send_message: 'TypeInputBotInlineMessage'
    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, photo: 'TypeInputPhoto', send_message: 'TypeInputBotInlineMessage'):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'photo', photo)
        object.__setattr__(self, 'send_message', send_message)

    def _bytes(self):
        return b''.join((
            b'\xa7d\xd8\xa8',
            self._serialize_bytes(self.id),
            self._serialize_bytes(self.type),
            self.photo._bytes(),
            self.send_message._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_string()
        _type = reader.tgread_string()
        _photo = reader.tgread_object()
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, photo=_photo, send_message=_send_message)


@dataclasses.dataclass(init=False, frozen=True)
class InputChannel(TLObject):
    """
    Constructor for InputChannel: Instance of either InputChannelEmpty, InputChannel, InputChannelFromMessage.
    """
    __slots__ = ('channel_id', 'access_hash',)
    CONSTRUCTOR_ID = 0xf35aec28
    SUBCLASS_OF_ID = 0x40f202fd

    channel_id: int
    access_hash: int
    def __init__(self, channel_id: int, access_hash: int):
        object.__setattr__(self, 'channel_id', channel_id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'(\xecZ\xf3',
            struct.pack('<q', self.channel_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel_id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(channel_id=_channel_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputChannelEmpty(TLObject):
    """
    Constructor for InputChannel: Instance of either InputChannelEmpty, InputChannel, InputChannelFromMessage.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xee8c1e86
    SUBCLASS_OF_ID = 0x40f202fd

    def _bytes(self):
        return b''.join((
            b'\x86\x1e\x8c\xee',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputChannelFromMessage(TLObject):
    """
    Constructor for InputChannel: Instance of either InputChannelEmpty, InputChannel, InputChannelFromMessage.
    """
    __slots__ = ('peer', 'msg_id', 'channel_id',)
    CONSTRUCTOR_ID = 0x5b934f9d
    SUBCLASS_OF_ID = 0x40f202fd

    peer: 'TypeInputPeer'
    msg_id: int
    channel_id: int
    def __init__(self, peer: 'TypeInputPeer', msg_id: int, channel_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'channel_id', channel_id)

    def _bytes(self):
        return b''.join((
            b'\x9dO\x93[',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            struct.pack('<q', self.channel_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _channel_id = reader.read_long()
        return cls(peer=_peer, msg_id=_msg_id, channel_id=_channel_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputChatPhoto(TLObject):
    """
    Constructor for InputChatPhoto: Instance of either InputChatPhotoEmpty, InputChatUploadedPhoto, InputChatPhoto.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x8953ad37
    SUBCLASS_OF_ID = 0xd4eb2d74

    id: 'TypeInputPhoto'
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputPhoto'):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'7\xadS\x89',
            self.id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputChatPhotoEmpty(TLObject):
    """
    Constructor for InputChatPhoto: Instance of either InputChatPhotoEmpty, InputChatUploadedPhoto, InputChatPhoto.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x1ca48f57
    SUBCLASS_OF_ID = 0xd4eb2d74

    def _bytes(self):
        return b''.join((
            b'W\x8f\xa4\x1c',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputChatUploadedPhoto(TLObject):
    """
    Constructor for InputChatPhoto: Instance of either InputChatPhotoEmpty, InputChatUploadedPhoto, InputChatPhoto.
    """
    __slots__ = ('file', 'video', 'video_start_ts',)
    CONSTRUCTOR_ID = 0xc642724e
    SUBCLASS_OF_ID = 0xd4eb2d74

    file: Optional['TypeInputFile']
    video: Optional['TypeInputFile']
    video_start_ts: Optional[float]
    def __init__(self, file: Optional['TypeInputFile']=None, video: Optional['TypeInputFile']=None, video_start_ts: Optional[float]=None):
        object.__setattr__(self, 'file', file)
        object.__setattr__(self, 'video', video)
        object.__setattr__(self, 'video_start_ts', video_start_ts)

    def _bytes(self):
        return b''.join((
            b'NrB\xc6',
            struct.pack('<I', (0 if self.file is None or self.file is False else 1) | (0 if self.video is None or self.video is False else 2) | (0 if self.video_start_ts is None or self.video_start_ts is False else 4)),
            b'' if self.file is None or self.file is False else (self.file._bytes()),
            b'' if self.video is None or self.video is False else (self.video._bytes()),
            b'' if self.video_start_ts is None or self.video_start_ts is False else (struct.pack('<d', self.video_start_ts)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _file = reader.tgread_object()
        else:
            _file = None
        if flags & 2:
            _video = reader.tgread_object()
        else:
            _video = None
        if flags & 4:
            _video_start_ts = reader.read_double()
        else:
            _video_start_ts = None
        return cls(file=_file, video=_video, video_start_ts=_video_start_ts)


@dataclasses.dataclass(init=False, frozen=True)
class InputCheckPasswordEmpty(TLObject):
    """
    Constructor for InputCheckPasswordSRP: Instance of either InputCheckPasswordEmpty, InputCheckPasswordSRP.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9880f658
    SUBCLASS_OF_ID = 0xd41af560

    def _bytes(self):
        return b''.join((
            b'X\xf6\x80\x98',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputCheckPasswordSRP(TLObject):
    """
    Constructor for InputCheckPasswordSRP: Instance of either InputCheckPasswordEmpty, InputCheckPasswordSRP.
    """
    __slots__ = ('srp_id', 'A', 'M1',)
    CONSTRUCTOR_ID = 0xd27ff082
    SUBCLASS_OF_ID = 0xd41af560

    srp_id: int
    A: bytes
    M1: bytes
    def __init__(self, srp_id: int, A: bytes, M1: bytes):
        object.__setattr__(self, 'srp_id', srp_id)
        object.__setattr__(self, 'A', A)
        object.__setattr__(self, 'M1', M1)

    def _bytes(self):
        return b''.join((
            b'\x82\xf0\x7f\xd2',
            struct.pack('<q', self.srp_id),
            self._serialize_bytes(self.A),
            self._serialize_bytes(self.M1),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _srp_id = reader.read_long()
        _A = reader.tgread_bytes()
        _M1 = reader.tgread_bytes()
        return cls(srp_id=_srp_id, A=_A, M1=_M1)


@dataclasses.dataclass(init=False, frozen=True)
class InputClientProxy(TLObject):
    """
    Constructor for InputClientProxy: Instance of InputClientProxy.
    """
    __slots__ = ('address', 'port',)
    CONSTRUCTOR_ID = 0x75588b3f
    SUBCLASS_OF_ID = 0x91a4346

    address: str
    port: int
    def __init__(self, address: str, port: int):
        object.__setattr__(self, 'address', address)
        object.__setattr__(self, 'port', port)

    def _bytes(self):
        return b''.join((
            b'?\x8bXu',
            self._serialize_bytes(self.address),
            struct.pack('<i', self.port),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _address = reader.tgread_string()
        _port = reader.read_int()
        return cls(address=_address, port=_port)


@dataclasses.dataclass(init=False, frozen=True)
class InputDialogPeer(TLObject):
    """
    Constructor for InputDialogPeer: Instance of either InputDialogPeer, InputDialogPeerFolder.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0xfcaafeb7
    SUBCLASS_OF_ID = 0xa21c9795

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    def _bytes(self):
        return b''.join((
            b'\xb7\xfe\xaa\xfc',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class InputDialogPeerFolder(TLObject):
    """
    Constructor for InputDialogPeer: Instance of either InputDialogPeer, InputDialogPeerFolder.
    """
    __slots__ = ('folder_id',)
    CONSTRUCTOR_ID = 0x64600527
    SUBCLASS_OF_ID = 0xa21c9795

    folder_id: int
    def __init__(self, folder_id: int):
        object.__setattr__(self, 'folder_id', folder_id)

    def _bytes(self):
        return b''.join((
            b"'\x05`d",
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _folder_id = reader.read_int()
        return cls(folder_id=_folder_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputDocument(TLObject):
    """
    Constructor for InputDocument: Instance of either InputDocumentEmpty, InputDocument.
    """
    __slots__ = ('id', 'access_hash', 'file_reference',)
    CONSTRUCTOR_ID = 0x1abfb575
    SUBCLASS_OF_ID = 0xf33fdb68

    id: int
    access_hash: int
    file_reference: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'file_reference', file_reference)

    def _bytes(self):
        return b''.join((
            b'u\xb5\xbf\x1a',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_bytes(self.file_reference),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference)


@dataclasses.dataclass(init=False, frozen=True)
class InputDocumentEmpty(TLObject):
    """
    Constructor for InputDocument: Instance of either InputDocumentEmpty, InputDocument.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x72f0eaae
    SUBCLASS_OF_ID = 0xf33fdb68

    def _bytes(self):
        return b''.join((
            b'\xae\xea\xf0r',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputDocumentFileLocation(TLObject):
    """
    Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
    """
    __slots__ = ('id', 'access_hash', 'file_reference', 'thumb_size',)
    CONSTRUCTOR_ID = 0xbad07584
    SUBCLASS_OF_ID = 0x1523d462

    id: int
    access_hash: int
    file_reference: bytes
    thumb_size: str
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, thumb_size: str):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'file_reference', file_reference)
        object.__setattr__(self, 'thumb_size', thumb_size)

    def _bytes(self):
        return b''.join((
            b'\x84u\xd0\xba',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_bytes(self.file_reference),
            self._serialize_bytes(self.thumb_size),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _thumb_size = reader.tgread_string()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, thumb_size=_thumb_size)


@dataclasses.dataclass(init=False, frozen=True)
class InputEncryptedChat(TLObject):
    """
    Constructor for InputEncryptedChat: Instance of InputEncryptedChat.
    """
    __slots__ = ('chat_id', 'access_hash',)
    CONSTRUCTOR_ID = 0xf141b5e1
    SUBCLASS_OF_ID = 0x6c7606c0

    chat_id: int
    access_hash: int
    def __init__(self, chat_id: int, access_hash: int):
        object.__setattr__(self, 'chat_id', chat_id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'\xe1\xb5A\xf1',
            struct.pack('<i', self.chat_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat_id = reader.read_int()
        _access_hash = reader.read_long()
        return cls(chat_id=_chat_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputEncryptedFile(TLObject):
    """
    Constructor for InputEncryptedFile: Instance of either InputEncryptedFileEmpty, InputEncryptedFileUploaded, InputEncryptedFile, InputEncryptedFileBigUploaded.
    """
    __slots__ = ('id', 'access_hash',)
    CONSTRUCTOR_ID = 0x5a17b5e5
    SUBCLASS_OF_ID = 0x8574c27a

    id: int
    access_hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'\xe5\xb5\x17Z',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputEncryptedFileBigUploaded(TLObject):
    """
    Constructor for InputEncryptedFile: Instance of either InputEncryptedFileEmpty, InputEncryptedFileUploaded, InputEncryptedFile, InputEncryptedFileBigUploaded.
    """
    __slots__ = ('id', 'parts', 'key_fingerprint',)
    CONSTRUCTOR_ID = 0x2dc173c8
    SUBCLASS_OF_ID = 0x8574c27a

    id: int
    parts: int
    key_fingerprint: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, key_fingerprint: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'parts', parts)
        object.__setattr__(self, 'key_fingerprint', key_fingerprint)

    def _bytes(self):
        return b''.join((
            b'\xc8s\xc1-',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            struct.pack('<i', self.key_fingerprint),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _key_fingerprint = reader.read_int()
        return cls(id=_id, parts=_parts, key_fingerprint=_key_fingerprint)


@dataclasses.dataclass(init=False, frozen=True)
class InputEncryptedFileEmpty(TLObject):
    """
    Constructor for InputEncryptedFile: Instance of either InputEncryptedFileEmpty, InputEncryptedFileUploaded, InputEncryptedFile, InputEncryptedFileBigUploaded.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x1837c364
    SUBCLASS_OF_ID = 0x8574c27a

    def _bytes(self):
        return b''.join((
            b'd\xc37\x18',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputEncryptedFileLocation(TLObject):
    """
    Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
    """
    __slots__ = ('id', 'access_hash',)
    CONSTRUCTOR_ID = 0xf5235d55
    SUBCLASS_OF_ID = 0x1523d462

    id: int
    access_hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'U]#\xf5',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputEncryptedFileUploaded(TLObject):
    """
    Constructor for InputEncryptedFile: Instance of either InputEncryptedFileEmpty, InputEncryptedFileUploaded, InputEncryptedFile, InputEncryptedFileBigUploaded.
    """
    __slots__ = ('id', 'parts', 'md5_checksum', 'key_fingerprint',)
    CONSTRUCTOR_ID = 0x64bd0306
    SUBCLASS_OF_ID = 0x8574c27a

    id: int
    parts: int
    md5_checksum: str
    key_fingerprint: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, md5_checksum: str, key_fingerprint: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'parts', parts)
        object.__setattr__(self, 'md5_checksum', md5_checksum)
        object.__setattr__(self, 'key_fingerprint', key_fingerprint)

    def _bytes(self):
        return b''.join((
            b'\x06\x03\xbdd',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            self._serialize_bytes(self.md5_checksum),
            struct.pack('<i', self.key_fingerprint),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _md5_checksum = reader.tgread_string()
        _key_fingerprint = reader.read_int()
        return cls(id=_id, parts=_parts, md5_checksum=_md5_checksum, key_fingerprint=_key_fingerprint)


@dataclasses.dataclass(init=False, frozen=True)
class InputFile(TLObject):
    """
    Constructor for InputFile: Instance of either InputFile, InputFileBig.
    """
    __slots__ = ('id', 'parts', 'name', 'md5_checksum',)
    CONSTRUCTOR_ID = 0xf52ff27f
    SUBCLASS_OF_ID = 0xe7655f1f

    id: int
    parts: int
    name: str
    md5_checksum: str
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, name: str, md5_checksum: str):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'parts', parts)
        object.__setattr__(self, 'name', name)
        object.__setattr__(self, 'md5_checksum', md5_checksum)

    def _bytes(self):
        return b''.join((
            b'\x7f\xf2/\xf5',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            self._serialize_bytes(self.name),
            self._serialize_bytes(self.md5_checksum),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _name = reader.tgread_string()
        _md5_checksum = reader.tgread_string()
        return cls(id=_id, parts=_parts, name=_name, md5_checksum=_md5_checksum)


@dataclasses.dataclass(init=False, frozen=True)
class InputFileBig(TLObject):
    """
    Constructor for InputFile: Instance of either InputFile, InputFileBig.
    """
    __slots__ = ('id', 'parts', 'name',)
    CONSTRUCTOR_ID = 0xfa4f0bb5
    SUBCLASS_OF_ID = 0xe7655f1f

    id: int
    parts: int
    name: str
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, name: str):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'parts', parts)
        object.__setattr__(self, 'name', name)

    def _bytes(self):
        return b''.join((
            b'\xb5\x0bO\xfa',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            self._serialize_bytes(self.name),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _name = reader.tgread_string()
        return cls(id=_id, parts=_parts, name=_name)


@dataclasses.dataclass(init=False, frozen=True)
class InputFileLocation(TLObject):
    """
    Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
    """
    __slots__ = ('volume_id', 'local_id', 'secret', 'file_reference',)
    CONSTRUCTOR_ID = 0xdfdaabe1
    SUBCLASS_OF_ID = 0x1523d462

    volume_id: int
    local_id: int
    secret: int
    file_reference: bytes
    def __init__(self, volume_id: int, local_id: int, secret: int, file_reference: bytes):
        object.__setattr__(self, 'volume_id', volume_id)
        object.__setattr__(self, 'local_id', local_id)
        object.__setattr__(self, 'secret', secret)
        object.__setattr__(self, 'file_reference', file_reference)

    def _bytes(self):
        return b''.join((
            b'\xe1\xab\xda\xdf',
            struct.pack('<q', self.volume_id),
            struct.pack('<i', self.local_id),
            struct.pack('<q', self.secret),
            self._serialize_bytes(self.file_reference),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _volume_id = reader.read_long()
        _local_id = reader.read_int()
        _secret = reader.read_long()
        _file_reference = reader.tgread_bytes()
        return cls(volume_id=_volume_id, local_id=_local_id, secret=_secret, file_reference=_file_reference)


@dataclasses.dataclass(init=False, frozen=True)
class InputFolderPeer(TLObject):
    """
    Constructor for InputFolderPeer: Instance of InputFolderPeer.
    """
    __slots__ = ('peer', 'folder_id',)
    CONSTRUCTOR_ID = 0xfbd2c296
    SUBCLASS_OF_ID = 0x74825e00

    peer: 'TypeInputPeer'
    folder_id: int
    def __init__(self, peer: 'TypeInputPeer', folder_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'folder_id', folder_id)

    def _bytes(self):
        return b''.join((
            b'\x96\xc2\xd2\xfb',
            self.peer._bytes(),
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _folder_id = reader.read_int()
        return cls(peer=_peer, folder_id=_folder_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputGameID(TLObject):
    """
    Constructor for InputGame: Instance of either InputGameID, InputGameShortName.
    """
    __slots__ = ('id', 'access_hash',)
    CONSTRUCTOR_ID = 0x32c3e77
    SUBCLASS_OF_ID = 0x48d15883

    id: int
    access_hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'w>,\x03',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputGameShortName(TLObject):
    """
    Constructor for InputGame: Instance of either InputGameID, InputGameShortName.
    """
    __slots__ = ('bot_id', 'short_name',)
    CONSTRUCTOR_ID = 0xc331e80a
    SUBCLASS_OF_ID = 0x48d15883

    bot_id: 'TypeInputUser'
    short_name: str
    def __init__(self, bot_id: 'TypeInputUser', short_name: str):
        object.__setattr__(self, 'bot_id', bot_id)
        object.__setattr__(self, 'short_name', short_name)

    def _bytes(self):
        return b''.join((
            b'\n\xe81\xc3',
            self.bot_id._bytes(),
            self._serialize_bytes(self.short_name),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _bot_id = reader.tgread_object()
        _short_name = reader.tgread_string()
        return cls(bot_id=_bot_id, short_name=_short_name)


@dataclasses.dataclass(init=False, frozen=True)
class InputGeoPoint(TLObject):
    """
    Constructor for InputGeoPoint: Instance of either InputGeoPointEmpty, InputGeoPoint.
    """
    __slots__ = ('lat', 'long', 'accuracy_radius',)
    CONSTRUCTOR_ID = 0x48222faf
    SUBCLASS_OF_ID = 0x430d225

    lat: float
    long: float
    accuracy_radius: Optional[int]
    def __init__(self, lat: float, long: float, accuracy_radius: Optional[int]=None):
        object.__setattr__(self, 'lat', lat)
        object.__setattr__(self, 'long', long)
        object.__setattr__(self, 'accuracy_radius', accuracy_radius)

    def _bytes(self):
        return b''.join((
            b'\xaf/"H',
            struct.pack('<I', (0 if self.accuracy_radius is None or self.accuracy_radius is False else 1)),
            struct.pack('<d', self.lat),
            struct.pack('<d', self.long),
            b'' if self.accuracy_radius is None or self.accuracy_radius is False else (struct.pack('<i', self.accuracy_radius)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _lat = reader.read_double()
        _long = reader.read_double()
        if flags & 1:
            _accuracy_radius = reader.read_int()
        else:
            _accuracy_radius = None
        return cls(lat=_lat, long=_long, accuracy_radius=_accuracy_radius)


@dataclasses.dataclass(init=False, frozen=True)
class InputGeoPointEmpty(TLObject):
    """
    Constructor for InputGeoPoint: Instance of either InputGeoPointEmpty, InputGeoPoint.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xe4c123d6
    SUBCLASS_OF_ID = 0x430d225

    def _bytes(self):
        return b''.join((
            b'\xd6#\xc1\xe4',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputGroupCall(TLObject):
    """
    Constructor for InputGroupCall: Instance of InputGroupCall.
    """
    __slots__ = ('id', 'access_hash',)
    CONSTRUCTOR_ID = 0xd8aa840f
    SUBCLASS_OF_ID = 0x58611ab1

    id: int
    access_hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'\x0f\x84\xaa\xd8',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputGroupCallStream(TLObject):
    """
    Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
    """
    __slots__ = ('call', 'time_ms', 'scale', 'video_channel', 'video_quality',)
    CONSTRUCTOR_ID = 0x598a92a
    SUBCLASS_OF_ID = 0x1523d462

    call: 'TypeInputGroupCall'
    time_ms: int
    scale: int
    video_channel: Optional[int]
    video_quality: Optional[int]
    def __init__(self, call: 'TypeInputGroupCall', time_ms: int, scale: int, video_channel: Optional[int]=None, video_quality: Optional[int]=None):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'time_ms', time_ms)
        object.__setattr__(self, 'scale', scale)
        object.__setattr__(self, 'video_channel', video_channel)
        object.__setattr__(self, 'video_quality', video_quality)

    def _bytes(self):
        assert ((self.video_channel or self.video_channel is not None) and (self.video_quality or self.video_quality is not None)) or ((self.video_channel is None or self.video_channel is False) and (self.video_quality is None or self.video_quality is False)), 'video_channel, video_quality parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'*\xa9\x98\x05',
            struct.pack('<I', (0 if self.video_channel is None or self.video_channel is False else 1) | (0 if self.video_quality is None or self.video_quality is False else 1)),
            self.call._bytes(),
            struct.pack('<q', self.time_ms),
            struct.pack('<i', self.scale),
            b'' if self.video_channel is None or self.video_channel is False else (struct.pack('<i', self.video_channel)),
            b'' if self.video_quality is None or self.video_quality is False else (struct.pack('<i', self.video_quality)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _call = reader.tgread_object()
        _time_ms = reader.read_long()
        _scale = reader.read_int()
        if flags & 1:
            _video_channel = reader.read_int()
        else:
            _video_channel = None
        if flags & 1:
            _video_quality = reader.read_int()
        else:
            _video_quality = None
        return cls(call=_call, time_ms=_time_ms, scale=_scale, video_channel=_video_channel, video_quality=_video_quality)


@dataclasses.dataclass(init=False, frozen=True)
class InputKeyboardButtonUrlAuth(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text', 'url', 'bot', 'request_write_access', 'fwd_text',)
    CONSTRUCTOR_ID = 0xd02e7fd4
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    url: str
    bot: 'TypeInputUser'
    request_write_access: Optional[bool]
    fwd_text: Optional[str]
    def __init__(self, text: str, url: str, bot: 'TypeInputUser', request_write_access: Optional[bool]=None, fwd_text: Optional[str]=None):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'bot', bot)
        object.__setattr__(self, 'request_write_access', request_write_access)
        object.__setattr__(self, 'fwd_text', fwd_text)

    def _bytes(self):
        return b''.join((
            b'\xd4\x7f.\xd0',
            struct.pack('<I', (0 if self.request_write_access is None or self.request_write_access is False else 1) | (0 if self.fwd_text is None or self.fwd_text is False else 2)),
            self._serialize_bytes(self.text),
            b'' if self.fwd_text is None or self.fwd_text is False else (self._serialize_bytes(self.fwd_text)),
            self._serialize_bytes(self.url),
            self.bot._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _request_write_access = bool(flags & 1)
        _text = reader.tgread_string()
        if flags & 2:
            _fwd_text = reader.tgread_string()
        else:
            _fwd_text = None
        _url = reader.tgread_string()
        _bot = reader.tgread_object()
        return cls(text=_text, url=_url, bot=_bot, request_write_access=_request_write_access, fwd_text=_fwd_text)


@dataclasses.dataclass(init=False, frozen=True)
class InputKeyboardButtonUserProfile(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text', 'user_id',)
    CONSTRUCTOR_ID = 0xe988037b
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    user_id: 'TypeInputUser'
    def __init__(self, text: str, user_id: 'TypeInputUser'):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'user_id', user_id)

    def _bytes(self):
        return b''.join((
            b'{\x03\x88\xe9',
            self._serialize_bytes(self.text),
            self.user_id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_string()
        _user_id = reader.tgread_object()
        return cls(text=_text, user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaContact(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('phone_number', 'first_name', 'last_name', 'vcard',)
    CONSTRUCTOR_ID = 0xf8ab7dfb
    SUBCLASS_OF_ID = 0xfaf846f4

    phone_number: str
    first_name: str
    last_name: str
    vcard: str
    def __init__(self, phone_number: str, first_name: str, last_name: str, vcard: str):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'first_name', first_name)
        object.__setattr__(self, 'last_name', last_name)
        object.__setattr__(self, 'vcard', vcard)

    def _bytes(self):
        return b''.join((
            b'\xfb}\xab\xf8',
            self._serialize_bytes(self.phone_number),
            self._serialize_bytes(self.first_name),
            self._serialize_bytes(self.last_name),
            self._serialize_bytes(self.vcard),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _vcard = reader.tgread_string()
        return cls(phone_number=_phone_number, first_name=_first_name, last_name=_last_name, vcard=_vcard)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaDice(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('emoticon',)
    CONSTRUCTOR_ID = 0xe66fbf7b
    SUBCLASS_OF_ID = 0xfaf846f4

    emoticon: str
    def __init__(self, emoticon: str):
        object.__setattr__(self, 'emoticon', emoticon)

    def _bytes(self):
        return b''.join((
            b'{\xbfo\xe6',
            self._serialize_bytes(self.emoticon),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _emoticon = reader.tgread_string()
        return cls(emoticon=_emoticon)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaDocument(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('id', 'ttl_seconds', 'query',)
    CONSTRUCTOR_ID = 0x33473058
    SUBCLASS_OF_ID = 0xfaf846f4

    id: 'TypeInputDocument'
    ttl_seconds: Optional[int]
    query: Optional[str]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputDocument', ttl_seconds: Optional[int]=None, query: Optional[str]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'ttl_seconds', ttl_seconds)
        object.__setattr__(self, 'query', query)

    def _bytes(self):
        return b''.join((
            b'X0G3',
            struct.pack('<I', (0 if self.ttl_seconds is None or self.ttl_seconds is False else 1) | (0 if self.query is None or self.query is False else 2)),
            self.id._bytes(),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
            b'' if self.query is None or self.query is False else (self._serialize_bytes(self.query)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_object()
        if flags & 1:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        if flags & 2:
            _query = reader.tgread_string()
        else:
            _query = None
        return cls(id=_id, ttl_seconds=_ttl_seconds, query=_query)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaDocumentExternal(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('url', 'ttl_seconds',)
    CONSTRUCTOR_ID = 0xfb52dc99
    SUBCLASS_OF_ID = 0xfaf846f4

    url: str
    ttl_seconds: Optional[int]
    def __init__(self, url: str, ttl_seconds: Optional[int]=None):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'ttl_seconds', ttl_seconds)

    def _bytes(self):
        return b''.join((
            b'\x99\xdcR\xfb',
            struct.pack('<I', (0 if self.ttl_seconds is None or self.ttl_seconds is False else 1)),
            self._serialize_bytes(self.url),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _url = reader.tgread_string()
        if flags & 1:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(url=_url, ttl_seconds=_ttl_seconds)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaEmpty(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9664f57f
    SUBCLASS_OF_ID = 0xfaf846f4

    def _bytes(self):
        return b''.join((
            b'\x7f\xf5d\x96',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaGame(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0xd33f43f3
    SUBCLASS_OF_ID = 0xfaf846f4

    id: 'TypeInputGame'
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputGame'):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'\xf3C?\xd3',
            self.id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaGeoLive(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('geo_point', 'stopped', 'heading', 'period', 'proximity_notification_radius',)
    CONSTRUCTOR_ID = 0x971fa843
    SUBCLASS_OF_ID = 0xfaf846f4

    geo_point: 'TypeInputGeoPoint'
    stopped: Optional[bool]
    heading: Optional[int]
    period: Optional[int]
    proximity_notification_radius: Optional[int]
    def __init__(self, geo_point: 'TypeInputGeoPoint', stopped: Optional[bool]=None, heading: Optional[int]=None, period: Optional[int]=None, proximity_notification_radius: Optional[int]=None):
        object.__setattr__(self, 'geo_point', geo_point)
        object.__setattr__(self, 'stopped', stopped)
        object.__setattr__(self, 'heading', heading)
        object.__setattr__(self, 'period', period)
        object.__setattr__(self, 'proximity_notification_radius', proximity_notification_radius)

    def _bytes(self):
        return b''.join((
            b'C\xa8\x1f\x97',
            struct.pack('<I', (0 if self.stopped is None or self.stopped is False else 1) | (0 if self.heading is None or self.heading is False else 4) | (0 if self.period is None or self.period is False else 2) | (0 if self.proximity_notification_radius is None or self.proximity_notification_radius is False else 8)),
            self.geo_point._bytes(),
            b'' if self.heading is None or self.heading is False else (struct.pack('<i', self.heading)),
            b'' if self.period is None or self.period is False else (struct.pack('<i', self.period)),
            b'' if self.proximity_notification_radius is None or self.proximity_notification_radius is False else (struct.pack('<i', self.proximity_notification_radius)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _stopped = bool(flags & 1)
        _geo_point = reader.tgread_object()
        if flags & 4:
            _heading = reader.read_int()
        else:
            _heading = None
        if flags & 2:
            _period = reader.read_int()
        else:
            _period = None
        if flags & 8:
            _proximity_notification_radius = reader.read_int()
        else:
            _proximity_notification_radius = None
        return cls(geo_point=_geo_point, stopped=_stopped, heading=_heading, period=_period, proximity_notification_radius=_proximity_notification_radius)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaGeoPoint(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('geo_point',)
    CONSTRUCTOR_ID = 0xf9c44144
    SUBCLASS_OF_ID = 0xfaf846f4

    geo_point: 'TypeInputGeoPoint'
    def __init__(self, geo_point: 'TypeInputGeoPoint'):
        object.__setattr__(self, 'geo_point', geo_point)

    def _bytes(self):
        return b''.join((
            b'DA\xc4\xf9',
            self.geo_point._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _geo_point = reader.tgread_object()
        return cls(geo_point=_geo_point)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaInvoice(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('title', 'description', 'invoice', 'payload', 'provider', 'provider_data', 'photo', 'start_param',)
    CONSTRUCTOR_ID = 0xd9799874
    SUBCLASS_OF_ID = 0xfaf846f4

    title: str
    description: str
    invoice: 'TypeInvoice'
    payload: bytes
    provider: str
    provider_data: 'TypeDataJSON'
    photo: Optional['TypeInputWebDocument']
    start_param: Optional[str]
    def __init__(self, title: str, description: str, invoice: 'TypeInvoice', payload: bytes, provider: str, provider_data: 'TypeDataJSON', photo: Optional['TypeInputWebDocument']=None, start_param: Optional[str]=None):
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'description', description)
        object.__setattr__(self, 'invoice', invoice)
        object.__setattr__(self, 'payload', payload)
        object.__setattr__(self, 'provider', provider)
        object.__setattr__(self, 'provider_data', provider_data)
        object.__setattr__(self, 'photo', photo)
        object.__setattr__(self, 'start_param', start_param)

    def _bytes(self):
        return b''.join((
            b't\x98y\xd9',
            struct.pack('<I', (0 if self.photo is None or self.photo is False else 1) | (0 if self.start_param is None or self.start_param is False else 2)),
            self._serialize_bytes(self.title),
            self._serialize_bytes(self.description),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
            self.invoice._bytes(),
            self._serialize_bytes(self.payload),
            self._serialize_bytes(self.provider),
            self.provider_data._bytes(),
            b'' if self.start_param is None or self.start_param is False else (self._serialize_bytes(self.start_param)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _title = reader.tgread_string()
        _description = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        _invoice = reader.tgread_object()
        _payload = reader.tgread_bytes()
        _provider = reader.tgread_string()
        _provider_data = reader.tgread_object()
        if flags & 2:
            _start_param = reader.tgread_string()
        else:
            _start_param = None
        return cls(title=_title, description=_description, invoice=_invoice, payload=_payload, provider=_provider, provider_data=_provider_data, photo=_photo, start_param=_start_param)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaPhoto(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('id', 'ttl_seconds',)
    CONSTRUCTOR_ID = 0xb3ba0635
    SUBCLASS_OF_ID = 0xfaf846f4

    id: 'TypeInputPhoto'
    ttl_seconds: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputPhoto', ttl_seconds: Optional[int]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'ttl_seconds', ttl_seconds)

    def _bytes(self):
        return b''.join((
            b'5\x06\xba\xb3',
            struct.pack('<I', (0 if self.ttl_seconds is None or self.ttl_seconds is False else 1)),
            self.id._bytes(),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_object()
        if flags & 1:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(id=_id, ttl_seconds=_ttl_seconds)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaPhotoExternal(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('url', 'ttl_seconds',)
    CONSTRUCTOR_ID = 0xe5bbfe1a
    SUBCLASS_OF_ID = 0xfaf846f4

    url: str
    ttl_seconds: Optional[int]
    def __init__(self, url: str, ttl_seconds: Optional[int]=None):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'ttl_seconds', ttl_seconds)

    def _bytes(self):
        return b''.join((
            b'\x1a\xfe\xbb\xe5',
            struct.pack('<I', (0 if self.ttl_seconds is None or self.ttl_seconds is False else 1)),
            self._serialize_bytes(self.url),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _url = reader.tgread_string()
        if flags & 1:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(url=_url, ttl_seconds=_ttl_seconds)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaPoll(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('poll', 'correct_answers', 'solution', 'solution_entities',)
    CONSTRUCTOR_ID = 0xf94e5f1
    SUBCLASS_OF_ID = 0xfaf846f4

    poll: 'TypePoll'
    correct_answers: Optional[List[bytes]]
    solution: Optional[str]
    solution_entities: Optional[List['TypeMessageEntity']]
    def __init__(self, poll: 'TypePoll', correct_answers: Optional[List[bytes]]=None, solution: Optional[str]=None, solution_entities: Optional[List['TypeMessageEntity']]=None):
        object.__setattr__(self, 'poll', poll)
        object.__setattr__(self, 'correct_answers', correct_answers)
        object.__setattr__(self, 'solution', solution)
        object.__setattr__(self, 'solution_entities', solution_entities)

    def _bytes(self):
        assert ((self.solution or self.solution is not None) and (self.solution_entities or self.solution_entities is not None)) or ((self.solution is None or self.solution is False) and (self.solution_entities is None or self.solution_entities is False)), 'solution, solution_entities parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xf1\xe5\x94\x0f',
            struct.pack('<I', (0 if self.correct_answers is None or self.correct_answers is False else 1) | (0 if self.solution is None or self.solution is False else 2) | (0 if self.solution_entities is None or self.solution_entities is False else 2)),
            self.poll._bytes(),
            b'' if self.correct_answers is None or self.correct_answers is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.correct_answers)),b''.join(self._serialize_bytes(x) for x in self.correct_answers))),
            b'' if self.solution is None or self.solution is False else (self._serialize_bytes(self.solution)),
            b'' if self.solution_entities is None or self.solution_entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.solution_entities)),b''.join(x._bytes() for x in self.solution_entities))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _poll = reader.tgread_object()
        if flags & 1:
            reader.read_int()
            _correct_answers = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_bytes()
                _correct_answers.append(_x)

        else:
            _correct_answers = None
        if flags & 2:
            _solution = reader.tgread_string()
        else:
            _solution = None
        if flags & 2:
            reader.read_int()
            _solution_entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _solution_entities.append(_x)

        else:
            _solution_entities = None
        return cls(poll=_poll, correct_answers=_correct_answers, solution=_solution, solution_entities=_solution_entities)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaUploadedDocument(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('file', 'mime_type', 'attributes', 'nosound_video', 'force_file', 'thumb', 'stickers', 'ttl_seconds',)
    CONSTRUCTOR_ID = 0x5b38c6c1
    SUBCLASS_OF_ID = 0xfaf846f4

    file: 'TypeInputFile'
    mime_type: str
    attributes: List['TypeDocumentAttribute']
    nosound_video: Optional[bool]
    force_file: Optional[bool]
    thumb: Optional['TypeInputFile']
    stickers: Optional[List['TypeInputDocument']]
    ttl_seconds: Optional[int]
    def __init__(self, file: 'TypeInputFile', mime_type: str, attributes: List['TypeDocumentAttribute'], nosound_video: Optional[bool]=None, force_file: Optional[bool]=None, thumb: Optional['TypeInputFile']=None, stickers: Optional[List['TypeInputDocument']]=None, ttl_seconds: Optional[int]=None):
        object.__setattr__(self, 'file', file)
        object.__setattr__(self, 'mime_type', mime_type)
        object.__setattr__(self, 'attributes', attributes)
        object.__setattr__(self, 'nosound_video', nosound_video)
        object.__setattr__(self, 'force_file', force_file)
        object.__setattr__(self, 'thumb', thumb)
        object.__setattr__(self, 'stickers', stickers)
        object.__setattr__(self, 'ttl_seconds', ttl_seconds)

    def _bytes(self):
        return b''.join((
            b'\xc1\xc68[',
            struct.pack('<I', (0 if self.nosound_video is None or self.nosound_video is False else 8) | (0 if self.force_file is None or self.force_file is False else 16) | (0 if self.thumb is None or self.thumb is False else 4) | (0 if self.stickers is None or self.stickers is False else 1) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 2)),
            self.file._bytes(),
            b'' if self.thumb is None or self.thumb is False else (self.thumb._bytes()),
            self._serialize_bytes(self.mime_type),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.attributes)),b''.join(x._bytes() for x in self.attributes),
            b'' if self.stickers is None or self.stickers is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(x._bytes() for x in self.stickers))),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _nosound_video = bool(flags & 8)
        _force_file = bool(flags & 16)
        _file = reader.tgread_object()
        if flags & 4:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        _mime_type = reader.tgread_string()
        reader.read_int()
        _attributes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _attributes.append(_x)

        if flags & 1:
            reader.read_int()
            _stickers = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _stickers.append(_x)

        else:
            _stickers = None
        if flags & 2:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(file=_file, mime_type=_mime_type, attributes=_attributes, nosound_video=_nosound_video, force_file=_force_file, thumb=_thumb, stickers=_stickers, ttl_seconds=_ttl_seconds)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaUploadedPhoto(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('file', 'stickers', 'ttl_seconds',)
    CONSTRUCTOR_ID = 0x1e287d04
    SUBCLASS_OF_ID = 0xfaf846f4

    file: 'TypeInputFile'
    stickers: Optional[List['TypeInputDocument']]
    ttl_seconds: Optional[int]
    def __init__(self, file: 'TypeInputFile', stickers: Optional[List['TypeInputDocument']]=None, ttl_seconds: Optional[int]=None):
        object.__setattr__(self, 'file', file)
        object.__setattr__(self, 'stickers', stickers)
        object.__setattr__(self, 'ttl_seconds', ttl_seconds)

    def _bytes(self):
        return b''.join((
            b'\x04}(\x1e',
            struct.pack('<I', (0 if self.stickers is None or self.stickers is False else 1) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 2)),
            self.file._bytes(),
            b'' if self.stickers is None or self.stickers is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(x._bytes() for x in self.stickers))),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _file = reader.tgread_object()
        if flags & 1:
            reader.read_int()
            _stickers = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _stickers.append(_x)

        else:
            _stickers = None
        if flags & 2:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(file=_file, stickers=_stickers, ttl_seconds=_ttl_seconds)


@dataclasses.dataclass(init=False, frozen=True)
class InputMediaVenue(TLObject):
    """
    Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice.
    """
    __slots__ = ('geo_point', 'title', 'address', 'provider', 'venue_id', 'venue_type',)
    CONSTRUCTOR_ID = 0xc13d1c11
    SUBCLASS_OF_ID = 0xfaf846f4

    geo_point: 'TypeInputGeoPoint'
    title: str
    address: str
    provider: str
    venue_id: str
    venue_type: str
    def __init__(self, geo_point: 'TypeInputGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str):
        object.__setattr__(self, 'geo_point', geo_point)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'address', address)
        object.__setattr__(self, 'provider', provider)
        object.__setattr__(self, 'venue_id', venue_id)
        object.__setattr__(self, 'venue_type', venue_type)

    def _bytes(self):
        return b''.join((
            b'\x11\x1c=\xc1',
            self.geo_point._bytes(),
            self._serialize_bytes(self.title),
            self._serialize_bytes(self.address),
            self._serialize_bytes(self.provider),
            self._serialize_bytes(self.venue_id),
            self._serialize_bytes(self.venue_type),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _geo_point = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        return cls(geo_point=_geo_point, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type)


@dataclasses.dataclass(init=False, frozen=True)
class InputMessageCallbackQuery(TLObject):
    """
    Constructor for InputMessage: Instance of either InputMessageID, InputMessageReplyTo, InputMessagePinned, InputMessageCallbackQuery.
    """
    __slots__ = ('id', 'query_id',)
    CONSTRUCTOR_ID = 0xacfa1a7e
    SUBCLASS_OF_ID = 0x54b6bcc5

    id: int
    query_id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, query_id: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'query_id', query_id)

    def _bytes(self):
        return b''.join((
            b'~\x1a\xfa\xac',
            struct.pack('<i', self.id),
            struct.pack('<q', self.query_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_int()
        _query_id = reader.read_long()
        return cls(id=_id, query_id=_query_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputMessageEntityMentionName(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length', 'user_id',)
    CONSTRUCTOR_ID = 0x208e68c9
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    user_id: 'TypeInputUser'
    def __init__(self, offset: int, length: int, user_id: 'TypeInputUser'):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)
        object.__setattr__(self, 'user_id', user_id)

    def _bytes(self):
        return b''.join((
            b'\xc9h\x8e ',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            self.user_id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _user_id = reader.tgread_object()
        return cls(offset=_offset, length=_length, user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputMessageID(TLObject):
    """
    Constructor for InputMessage: Instance of either InputMessageID, InputMessageReplyTo, InputMessagePinned, InputMessageCallbackQuery.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0xa676a322
    SUBCLASS_OF_ID = 0x54b6bcc5

    id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'"\xa3v\xa6',
            struct.pack('<i', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagePinned(TLObject):
    """
    Constructor for InputMessage: Instance of either InputMessageID, InputMessageReplyTo, InputMessagePinned, InputMessageCallbackQuery.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x86872538
    SUBCLASS_OF_ID = 0x54b6bcc5

    def _bytes(self):
        return b''.join((
            b'8%\x87\x86',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessageReplyTo(TLObject):
    """
    Constructor for InputMessage: Instance of either InputMessageID, InputMessageReplyTo, InputMessagePinned, InputMessageCallbackQuery.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0xbad88395
    SUBCLASS_OF_ID = 0x54b6bcc5

    id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'\x95\x83\xd8\xba',
            struct.pack('<i', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterChatPhotos(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x3a20ecb8
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'\xb8\xec :',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterContacts(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xe062db83
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'\x83\xdbb\xe0',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterDocument(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9eddf188
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'\x88\xf1\xdd\x9e',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterEmpty(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x57e2f66c
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'l\xf6\xe2W',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterGeo(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xe7026d0d
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'\rm\x02\xe7',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterGif(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xffc86587
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'\x87e\xc8\xff',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterMusic(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x3751b49e
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'\x9e\xb4Q7',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterMyMentions(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xc1f8e69a
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'\x9a\xe6\xf8\xc1',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterPhoneCalls(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ('missed',)
    CONSTRUCTOR_ID = 0x80c99768
    SUBCLASS_OF_ID = 0x8a36ec14

    missed: Optional[bool]
    def __init__(self, missed: Optional[bool]=None):
        object.__setattr__(self, 'missed', missed)

    def _bytes(self):
        return b''.join((
            b'h\x97\xc9\x80',
            struct.pack('<I', (0 if self.missed is None or self.missed is False else 1)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _missed = bool(flags & 1)
        return cls(missed=_missed)


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterPhotoVideo(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x56e9f0e4
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'\xe4\xf0\xe9V',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterPhotos(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9609a51c
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'\x1c\xa5\t\x96',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterPinned(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x1bb00451
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'Q\x04\xb0\x1b',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterRoundVideo(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb549da53
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'S\xdaI\xb5',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterRoundVoice(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x7a7c17a4
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'\xa4\x17|z',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterUrl(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x7ef0dd87
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'\x87\xdd\xf0~',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterVideo(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9fc00e65
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'e\x0e\xc0\x9f',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputMessagesFilterVoice(TLObject):
    """
    Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x50f5c392
    SUBCLASS_OF_ID = 0x8a36ec14

    def _bytes(self):
        return b''.join((
            b'\x92\xc3\xf5P',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputNotifyBroadcasts(TLObject):
    """
    Constructor for InputNotifyPeer: Instance of either InputNotifyPeer, InputNotifyUsers, InputNotifyChats, InputNotifyBroadcasts.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb1db7c7e
    SUBCLASS_OF_ID = 0x58981615

    def _bytes(self):
        return b''.join((
            b'~|\xdb\xb1',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputNotifyChats(TLObject):
    """
    Constructor for InputNotifyPeer: Instance of either InputNotifyPeer, InputNotifyUsers, InputNotifyChats, InputNotifyBroadcasts.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x4a95e84e
    SUBCLASS_OF_ID = 0x58981615

    def _bytes(self):
        return b''.join((
            b'N\xe8\x95J',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputNotifyPeer(TLObject):
    """
    Constructor for InputNotifyPeer: Instance of either InputNotifyPeer, InputNotifyUsers, InputNotifyChats, InputNotifyBroadcasts.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0xb8bc5b0c
    SUBCLASS_OF_ID = 0x58981615

    peer: 'TypeInputPeer'
    def __init__(self, peer: 'TypeInputPeer'):
        object.__setattr__(self, 'peer', peer)

    def _bytes(self):
        return b''.join((
            b'\x0c[\xbc\xb8',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class InputNotifyUsers(TLObject):
    """
    Constructor for InputNotifyPeer: Instance of either InputNotifyPeer, InputNotifyUsers, InputNotifyChats, InputNotifyBroadcasts.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x193b4417
    SUBCLASS_OF_ID = 0x58981615

    def _bytes(self):
        return b''.join((
            b'\x17D;\x19',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPaymentCredentials(TLObject):
    """
    Constructor for InputPaymentCredentials: Instance of either InputPaymentCredentialsSaved, InputPaymentCredentials, InputPaymentCredentialsApplePay, InputPaymentCredentialsGooglePay.
    """
    __slots__ = ('data', 'save',)
    CONSTRUCTOR_ID = 0x3417d728
    SUBCLASS_OF_ID = 0x2899a53d

    data: 'TypeDataJSON'
    save: Optional[bool]
    def __init__(self, data: 'TypeDataJSON', save: Optional[bool]=None):
        object.__setattr__(self, 'data', data)
        object.__setattr__(self, 'save', save)

    def _bytes(self):
        return b''.join((
            b'(\xd7\x174',
            struct.pack('<I', (0 if self.save is None or self.save is False else 1)),
            self.data._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _save = bool(flags & 1)
        _data = reader.tgread_object()
        return cls(data=_data, save=_save)


@dataclasses.dataclass(init=False, frozen=True)
class InputPaymentCredentialsApplePay(TLObject):
    """
    Constructor for InputPaymentCredentials: Instance of either InputPaymentCredentialsSaved, InputPaymentCredentials, InputPaymentCredentialsApplePay, InputPaymentCredentialsGooglePay.
    """
    __slots__ = ('payment_data',)
    CONSTRUCTOR_ID = 0xaa1c39f
    SUBCLASS_OF_ID = 0x2899a53d

    payment_data: 'TypeDataJSON'
    def __init__(self, payment_data: 'TypeDataJSON'):
        object.__setattr__(self, 'payment_data', payment_data)

    def _bytes(self):
        return b''.join((
            b'\x9f\xc3\xa1\n',
            self.payment_data._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _payment_data = reader.tgread_object()
        return cls(payment_data=_payment_data)


@dataclasses.dataclass(init=False, frozen=True)
class InputPaymentCredentialsGooglePay(TLObject):
    """
    Constructor for InputPaymentCredentials: Instance of either InputPaymentCredentialsSaved, InputPaymentCredentials, InputPaymentCredentialsApplePay, InputPaymentCredentialsGooglePay.
    """
    __slots__ = ('payment_token',)
    CONSTRUCTOR_ID = 0x8ac32801
    SUBCLASS_OF_ID = 0x2899a53d

    payment_token: 'TypeDataJSON'
    def __init__(self, payment_token: 'TypeDataJSON'):
        object.__setattr__(self, 'payment_token', payment_token)

    def _bytes(self):
        return b''.join((
            b'\x01(\xc3\x8a',
            self.payment_token._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _payment_token = reader.tgread_object()
        return cls(payment_token=_payment_token)


@dataclasses.dataclass(init=False, frozen=True)
class InputPaymentCredentialsSaved(TLObject):
    """
    Constructor for InputPaymentCredentials: Instance of either InputPaymentCredentialsSaved, InputPaymentCredentials, InputPaymentCredentialsApplePay, InputPaymentCredentialsGooglePay.
    """
    __slots__ = ('id', 'tmp_password',)
    CONSTRUCTOR_ID = 0xc10eb2cf
    SUBCLASS_OF_ID = 0x2899a53d

    id: str
    tmp_password: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, tmp_password: bytes):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'tmp_password', tmp_password)

    def _bytes(self):
        return b''.join((
            b'\xcf\xb2\x0e\xc1',
            self._serialize_bytes(self.id),
            self._serialize_bytes(self.tmp_password),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_string()
        _tmp_password = reader.tgread_bytes()
        return cls(id=_id, tmp_password=_tmp_password)


@dataclasses.dataclass(init=False, frozen=True)
class InputPeerChannel(TLObject):
    """
    Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
    """
    __slots__ = ('channel_id', 'access_hash',)
    CONSTRUCTOR_ID = 0x27bcbbfc
    SUBCLASS_OF_ID = 0xc91c90b6

    channel_id: int
    access_hash: int
    def __init__(self, channel_id: int, access_hash: int):
        object.__setattr__(self, 'channel_id', channel_id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b"\xfc\xbb\xbc'",
            struct.pack('<q', self.channel_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel_id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(channel_id=_channel_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputPeerChannelFromMessage(TLObject):
    """
    Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
    """
    __slots__ = ('peer', 'msg_id', 'channel_id',)
    CONSTRUCTOR_ID = 0xbd2a0840
    SUBCLASS_OF_ID = 0xc91c90b6

    peer: 'TypeInputPeer'
    msg_id: int
    channel_id: int
    def __init__(self, peer: 'TypeInputPeer', msg_id: int, channel_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'channel_id', channel_id)

    def _bytes(self):
        return b''.join((
            b'@\x08*\xbd',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            struct.pack('<q', self.channel_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _channel_id = reader.read_long()
        return cls(peer=_peer, msg_id=_msg_id, channel_id=_channel_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputPeerChat(TLObject):
    """
    Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
    """
    __slots__ = ('chat_id',)
    CONSTRUCTOR_ID = 0x35a95cb9
    SUBCLASS_OF_ID = 0xc91c90b6

    chat_id: int
    def __init__(self, chat_id: int):
        object.__setattr__(self, 'chat_id', chat_id)

    def _bytes(self):
        return b''.join((
            b'\xb9\\\xa95',
            struct.pack('<q', self.chat_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat_id = reader.read_long()
        return cls(chat_id=_chat_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputPeerEmpty(TLObject):
    """
    Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x7f3b18ea
    SUBCLASS_OF_ID = 0xc91c90b6

    def _bytes(self):
        return b''.join((
            b'\xea\x18;\x7f',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPeerNotifySettings(TLObject):
    """
    Constructor for InputPeerNotifySettings: Instance of InputPeerNotifySettings.
    """
    __slots__ = ('show_previews', 'silent', 'mute_until', 'sound',)
    CONSTRUCTOR_ID = 0x9c3d198e
    SUBCLASS_OF_ID = 0x90db0b0d

    show_previews: Optional[bool]
    silent: Optional[bool]
    mute_until: Optional[datetime]
    sound: Optional[str]
    def __init__(self, show_previews: Optional[bool]=None, silent: Optional[bool]=None, mute_until: Optional[datetime]=None, sound: Optional[str]=None):
        object.__setattr__(self, 'show_previews', show_previews)
        object.__setattr__(self, 'silent', silent)
        object.__setattr__(self, 'mute_until', mute_until)
        object.__setattr__(self, 'sound', sound)

    def _bytes(self):
        return b''.join((
            b'\x8e\x19=\x9c',
            struct.pack('<I', (0 if self.show_previews is None else 1) | (0 if self.silent is None else 2) | (0 if self.mute_until is None or self.mute_until is False else 4) | (0 if self.sound is None or self.sound is False else 8)),
            b'' if self.show_previews is None else (b'\xb5ur\x99' if self.show_previews else b'7\x97y\xbc'),
            b'' if self.silent is None else (b'\xb5ur\x99' if self.silent else b'7\x97y\xbc'),
            b'' if self.mute_until is None or self.mute_until is False else (self._serialize_datetime(self.mute_until)),
            b'' if self.sound is None or self.sound is False else (self._serialize_bytes(self.sound)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _show_previews = reader.tgread_bool()
        else:
            _show_previews = None
        if flags & 2:
            _silent = reader.tgread_bool()
        else:
            _silent = None
        if flags & 4:
            _mute_until = reader.tgread_date()
        else:
            _mute_until = None
        if flags & 8:
            _sound = reader.tgread_string()
        else:
            _sound = None
        return cls(show_previews=_show_previews, silent=_silent, mute_until=_mute_until, sound=_sound)


@dataclasses.dataclass(init=False, frozen=True)
class InputPeerPhotoFileLocation(TLObject):
    """
    Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
    """
    __slots__ = ('peer', 'photo_id', 'big',)
    CONSTRUCTOR_ID = 0x37257e99
    SUBCLASS_OF_ID = 0x1523d462

    peer: 'TypeInputPeer'
    photo_id: int
    big: Optional[bool]
    def __init__(self, peer: 'TypeInputPeer', photo_id: int, big: Optional[bool]=None):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'photo_id', photo_id)
        object.__setattr__(self, 'big', big)

    def _bytes(self):
        return b''.join((
            b'\x99~%7',
            struct.pack('<I', (0 if self.big is None or self.big is False else 1)),
            self.peer._bytes(),
            struct.pack('<q', self.photo_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _big = bool(flags & 1)
        _peer = reader.tgread_object()
        _photo_id = reader.read_long()
        return cls(peer=_peer, photo_id=_photo_id, big=_big)


@dataclasses.dataclass(init=False, frozen=True)
class InputPeerSelf(TLObject):
    """
    Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x7da07ec9
    SUBCLASS_OF_ID = 0xc91c90b6

    def _bytes(self):
        return b''.join((
            b'\xc9~\xa0}',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPeerUser(TLObject):
    """
    Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
    """
    __slots__ = ('user_id', 'access_hash',)
    CONSTRUCTOR_ID = 0xdde8a54c
    SUBCLASS_OF_ID = 0xc91c90b6

    user_id: int
    access_hash: int
    def __init__(self, user_id: int, access_hash: int):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'L\xa5\xe8\xdd',
            struct.pack('<q', self.user_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(user_id=_user_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputPeerUserFromMessage(TLObject):
    """
    Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
    """
    __slots__ = ('peer', 'msg_id', 'user_id',)
    CONSTRUCTOR_ID = 0xa87b0a1c
    SUBCLASS_OF_ID = 0xc91c90b6

    peer: 'TypeInputPeer'
    msg_id: int
    user_id: int
    def __init__(self, peer: 'TypeInputPeer', msg_id: int, user_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'user_id', user_id)

    def _bytes(self):
        return b''.join((
            b'\x1c\n{\xa8',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _user_id = reader.read_long()
        return cls(peer=_peer, msg_id=_msg_id, user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputPhoneCall(TLObject):
    """
    Constructor for InputPhoneCall: Instance of InputPhoneCall.
    """
    __slots__ = ('id', 'access_hash',)
    CONSTRUCTOR_ID = 0x1e36fded
    SUBCLASS_OF_ID = 0xbcaaf240

    id: int
    access_hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'\xed\xfd6\x1e',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputPhoneContact(TLObject):
    """
    Constructor for InputContact: Instance of InputPhoneContact.
    """
    __slots__ = ('client_id', 'phone', 'first_name', 'last_name',)
    CONSTRUCTOR_ID = 0xf392b7f4
    SUBCLASS_OF_ID = 0xae696a82

    client_id: int
    phone: str
    first_name: str
    last_name: str
    def __init__(self, client_id: int, phone: str, first_name: str, last_name: str):
        object.__setattr__(self, 'client_id', client_id)
        object.__setattr__(self, 'phone', phone)
        object.__setattr__(self, 'first_name', first_name)
        object.__setattr__(self, 'last_name', last_name)

    def _bytes(self):
        return b''.join((
            b'\xf4\xb7\x92\xf3',
            struct.pack('<q', self.client_id),
            self._serialize_bytes(self.phone),
            self._serialize_bytes(self.first_name),
            self._serialize_bytes(self.last_name),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _client_id = reader.read_long()
        _phone = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        return cls(client_id=_client_id, phone=_phone, first_name=_first_name, last_name=_last_name)


@dataclasses.dataclass(init=False, frozen=True)
class InputPhoto(TLObject):
    """
    Constructor for InputPhoto: Instance of either InputPhotoEmpty, InputPhoto.
    """
    __slots__ = ('id', 'access_hash', 'file_reference',)
    CONSTRUCTOR_ID = 0x3bb3b94a
    SUBCLASS_OF_ID = 0x846363e0

    id: int
    access_hash: int
    file_reference: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'file_reference', file_reference)

    def _bytes(self):
        return b''.join((
            b'J\xb9\xb3;',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_bytes(self.file_reference),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference)


@dataclasses.dataclass(init=False, frozen=True)
class InputPhotoEmpty(TLObject):
    """
    Constructor for InputPhoto: Instance of either InputPhotoEmpty, InputPhoto.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x1cd7bf0d
    SUBCLASS_OF_ID = 0x846363e0

    def _bytes(self):
        return b''.join((
            b'\r\xbf\xd7\x1c',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPhotoFileLocation(TLObject):
    """
    Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
    """
    __slots__ = ('id', 'access_hash', 'file_reference', 'thumb_size',)
    CONSTRUCTOR_ID = 0x40181ffe
    SUBCLASS_OF_ID = 0x1523d462

    id: int
    access_hash: int
    file_reference: bytes
    thumb_size: str
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, thumb_size: str):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'file_reference', file_reference)
        object.__setattr__(self, 'thumb_size', thumb_size)

    def _bytes(self):
        return b''.join((
            b'\xfe\x1f\x18@',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_bytes(self.file_reference),
            self._serialize_bytes(self.thumb_size),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _thumb_size = reader.tgread_string()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, thumb_size=_thumb_size)


@dataclasses.dataclass(init=False, frozen=True)
class InputPhotoLegacyFileLocation(TLObject):
    """
    Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
    """
    __slots__ = ('id', 'access_hash', 'file_reference', 'volume_id', 'local_id', 'secret',)
    CONSTRUCTOR_ID = 0xd83466f3
    SUBCLASS_OF_ID = 0x1523d462

    id: int
    access_hash: int
    file_reference: bytes
    volume_id: int
    local_id: int
    secret: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, volume_id: int, local_id: int, secret: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'file_reference', file_reference)
        object.__setattr__(self, 'volume_id', volume_id)
        object.__setattr__(self, 'local_id', local_id)
        object.__setattr__(self, 'secret', secret)

    def _bytes(self):
        return b''.join((
            b'\xf3f4\xd8',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_bytes(self.file_reference),
            struct.pack('<q', self.volume_id),
            struct.pack('<i', self.local_id),
            struct.pack('<q', self.secret),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _volume_id = reader.read_long()
        _local_id = reader.read_int()
        _secret = reader.read_long()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, volume_id=_volume_id, local_id=_local_id, secret=_secret)


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyKeyAddedByPhone(TLObject):
    """
    Constructor for InputPrivacyKey: Instance of either InputPrivacyKeyStatusTimestamp, InputPrivacyKeyChatInvite, InputPrivacyKeyPhoneCall, InputPrivacyKeyPhoneP2P, InputPrivacyKeyForwards, InputPrivacyKeyProfilePhoto, InputPrivacyKeyPhoneNumber, InputPrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd1219bdd
    SUBCLASS_OF_ID = 0x53627f8

    def _bytes(self):
        return b''.join((
            b'\xdd\x9b!\xd1',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyKeyChatInvite(TLObject):
    """
    Constructor for InputPrivacyKey: Instance of either InputPrivacyKeyStatusTimestamp, InputPrivacyKeyChatInvite, InputPrivacyKeyPhoneCall, InputPrivacyKeyPhoneP2P, InputPrivacyKeyForwards, InputPrivacyKeyProfilePhoto, InputPrivacyKeyPhoneNumber, InputPrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xbdfb0426
    SUBCLASS_OF_ID = 0x53627f8

    def _bytes(self):
        return b''.join((
            b'&\x04\xfb\xbd',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyKeyForwards(TLObject):
    """
    Constructor for InputPrivacyKey: Instance of either InputPrivacyKeyStatusTimestamp, InputPrivacyKeyChatInvite, InputPrivacyKeyPhoneCall, InputPrivacyKeyPhoneP2P, InputPrivacyKeyForwards, InputPrivacyKeyProfilePhoto, InputPrivacyKeyPhoneNumber, InputPrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xa4dd4c08
    SUBCLASS_OF_ID = 0x53627f8

    def _bytes(self):
        return b''.join((
            b'\x08L\xdd\xa4',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyKeyPhoneCall(TLObject):
    """
    Constructor for InputPrivacyKey: Instance of either InputPrivacyKeyStatusTimestamp, InputPrivacyKeyChatInvite, InputPrivacyKeyPhoneCall, InputPrivacyKeyPhoneP2P, InputPrivacyKeyForwards, InputPrivacyKeyProfilePhoto, InputPrivacyKeyPhoneNumber, InputPrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xfabadc5f
    SUBCLASS_OF_ID = 0x53627f8

    def _bytes(self):
        return b''.join((
            b'_\xdc\xba\xfa',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyKeyPhoneNumber(TLObject):
    """
    Constructor for InputPrivacyKey: Instance of either InputPrivacyKeyStatusTimestamp, InputPrivacyKeyChatInvite, InputPrivacyKeyPhoneCall, InputPrivacyKeyPhoneP2P, InputPrivacyKeyForwards, InputPrivacyKeyProfilePhoto, InputPrivacyKeyPhoneNumber, InputPrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x352dafa
    SUBCLASS_OF_ID = 0x53627f8

    def _bytes(self):
        return b''.join((
            b'\xfa\xdaR\x03',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyKeyPhoneP2P(TLObject):
    """
    Constructor for InputPrivacyKey: Instance of either InputPrivacyKeyStatusTimestamp, InputPrivacyKeyChatInvite, InputPrivacyKeyPhoneCall, InputPrivacyKeyPhoneP2P, InputPrivacyKeyForwards, InputPrivacyKeyProfilePhoto, InputPrivacyKeyPhoneNumber, InputPrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xdb9e70d2
    SUBCLASS_OF_ID = 0x53627f8

    def _bytes(self):
        return b''.join((
            b'\xd2p\x9e\xdb',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyKeyProfilePhoto(TLObject):
    """
    Constructor for InputPrivacyKey: Instance of either InputPrivacyKeyStatusTimestamp, InputPrivacyKeyChatInvite, InputPrivacyKeyPhoneCall, InputPrivacyKeyPhoneP2P, InputPrivacyKeyForwards, InputPrivacyKeyProfilePhoto, InputPrivacyKeyPhoneNumber, InputPrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x5719bacc
    SUBCLASS_OF_ID = 0x53627f8

    def _bytes(self):
        return b''.join((
            b'\xcc\xba\x19W',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyKeyStatusTimestamp(TLObject):
    """
    Constructor for InputPrivacyKey: Instance of either InputPrivacyKeyStatusTimestamp, InputPrivacyKeyChatInvite, InputPrivacyKeyPhoneCall, InputPrivacyKeyPhoneP2P, InputPrivacyKeyForwards, InputPrivacyKeyProfilePhoto, InputPrivacyKeyPhoneNumber, InputPrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x4f96cb18
    SUBCLASS_OF_ID = 0x53627f8

    def _bytes(self):
        return b''.join((
            b'\x18\xcb\x96O',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyValueAllowAll(TLObject):
    """
    Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x184b35ce
    SUBCLASS_OF_ID = 0x5a3b6b22

    def _bytes(self):
        return b''.join((
            b'\xce5K\x18',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyValueAllowChatParticipants(TLObject):
    """
    Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants.
    """
    __slots__ = ('chats',)
    CONSTRUCTOR_ID = 0x840649cf
    SUBCLASS_OF_ID = 0x5a3b6b22

    chats: List[int]
    def __init__(self, chats: List[int]):
        object.__setattr__(self, 'chats', chats)

    def _bytes(self):
        return b''.join((
            b'\xcfI\x06\x84',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(struct.pack('<q', x) for x in self.chats),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _chats.append(_x)

        return cls(chats=_chats)


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyValueAllowContacts(TLObject):
    """
    Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd09e07b
    SUBCLASS_OF_ID = 0x5a3b6b22

    def _bytes(self):
        return b''.join((
            b'{\xe0\t\r',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyValueAllowUsers(TLObject):
    """
    Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants.
    """
    __slots__ = ('users',)
    CONSTRUCTOR_ID = 0x131cc67f
    SUBCLASS_OF_ID = 0x5a3b6b22

    users: List['TypeInputUser']
    def __init__(self, users: List['TypeInputUser']):
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\x7f\xc6\x1c\x13',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyValueDisallowAll(TLObject):
    """
    Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd66b66c9
    SUBCLASS_OF_ID = 0x5a3b6b22

    def _bytes(self):
        return b''.join((
            b'\xc9fk\xd6',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyValueDisallowChatParticipants(TLObject):
    """
    Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants.
    """
    __slots__ = ('chats',)
    CONSTRUCTOR_ID = 0xe94f0f86
    SUBCLASS_OF_ID = 0x5a3b6b22

    chats: List[int]
    def __init__(self, chats: List[int]):
        object.__setattr__(self, 'chats', chats)

    def _bytes(self):
        return b''.join((
            b'\x86\x0fO\xe9',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(struct.pack('<q', x) for x in self.chats),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _chats.append(_x)

        return cls(chats=_chats)


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyValueDisallowContacts(TLObject):
    """
    Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xba52007
    SUBCLASS_OF_ID = 0x5a3b6b22

    def _bytes(self):
        return b''.join((
            b'\x07 \xa5\x0b',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputPrivacyValueDisallowUsers(TLObject):
    """
    Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants.
    """
    __slots__ = ('users',)
    CONSTRUCTOR_ID = 0x90110467
    SUBCLASS_OF_ID = 0x5a3b6b22

    users: List['TypeInputUser']
    def __init__(self, users: List['TypeInputUser']):
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'g\x04\x11\x90',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class InputReportReasonChildAbuse(TLObject):
    """
    Constructor for ReportReason: Instance of either InputReportReasonSpam, InputReportReasonViolence, InputReportReasonPornography, InputReportReasonChildAbuse, InputReportReasonOther, InputReportReasonCopyright, InputReportReasonGeoIrrelevant, InputReportReasonFake, InputReportReasonIllegalDrugs, InputReportReasonPersonalDetails.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xadf44ee3
    SUBCLASS_OF_ID = 0x8401bd27

    def _bytes(self):
        return b''.join((
            b'\xe3N\xf4\xad',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputReportReasonCopyright(TLObject):
    """
    Constructor for ReportReason: Instance of either InputReportReasonSpam, InputReportReasonViolence, InputReportReasonPornography, InputReportReasonChildAbuse, InputReportReasonOther, InputReportReasonCopyright, InputReportReasonGeoIrrelevant, InputReportReasonFake, InputReportReasonIllegalDrugs, InputReportReasonPersonalDetails.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9b89f93a
    SUBCLASS_OF_ID = 0x8401bd27

    def _bytes(self):
        return b''.join((
            b':\xf9\x89\x9b',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputReportReasonFake(TLObject):
    """
    Constructor for ReportReason: Instance of either InputReportReasonSpam, InputReportReasonViolence, InputReportReasonPornography, InputReportReasonChildAbuse, InputReportReasonOther, InputReportReasonCopyright, InputReportReasonGeoIrrelevant, InputReportReasonFake, InputReportReasonIllegalDrugs, InputReportReasonPersonalDetails.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xf5ddd6e7
    SUBCLASS_OF_ID = 0x8401bd27

    def _bytes(self):
        return b''.join((
            b'\xe7\xd6\xdd\xf5',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputReportReasonGeoIrrelevant(TLObject):
    """
    Constructor for ReportReason: Instance of either InputReportReasonSpam, InputReportReasonViolence, InputReportReasonPornography, InputReportReasonChildAbuse, InputReportReasonOther, InputReportReasonCopyright, InputReportReasonGeoIrrelevant, InputReportReasonFake, InputReportReasonIllegalDrugs, InputReportReasonPersonalDetails.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xdbd4feed
    SUBCLASS_OF_ID = 0x8401bd27

    def _bytes(self):
        return b''.join((
            b'\xed\xfe\xd4\xdb',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputReportReasonIllegalDrugs(TLObject):
    """
    Constructor for ReportReason: Instance of either InputReportReasonSpam, InputReportReasonViolence, InputReportReasonPornography, InputReportReasonChildAbuse, InputReportReasonOther, InputReportReasonCopyright, InputReportReasonGeoIrrelevant, InputReportReasonFake, InputReportReasonIllegalDrugs, InputReportReasonPersonalDetails.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xa8eb2be
    SUBCLASS_OF_ID = 0x8401bd27

    def _bytes(self):
        return b''.join((
            b'\xbe\xb2\x8e\n',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputReportReasonOther(TLObject):
    """
    Constructor for ReportReason: Instance of either InputReportReasonSpam, InputReportReasonViolence, InputReportReasonPornography, InputReportReasonChildAbuse, InputReportReasonOther, InputReportReasonCopyright, InputReportReasonGeoIrrelevant, InputReportReasonFake, InputReportReasonIllegalDrugs, InputReportReasonPersonalDetails.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xc1e4a2b1
    SUBCLASS_OF_ID = 0x8401bd27

    def _bytes(self):
        return b''.join((
            b'\xb1\xa2\xe4\xc1',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputReportReasonPersonalDetails(TLObject):
    """
    Constructor for ReportReason: Instance of either InputReportReasonSpam, InputReportReasonViolence, InputReportReasonPornography, InputReportReasonChildAbuse, InputReportReasonOther, InputReportReasonCopyright, InputReportReasonGeoIrrelevant, InputReportReasonFake, InputReportReasonIllegalDrugs, InputReportReasonPersonalDetails.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9ec7863d
    SUBCLASS_OF_ID = 0x8401bd27

    def _bytes(self):
        return b''.join((
            b'=\x86\xc7\x9e',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputReportReasonPornography(TLObject):
    """
    Constructor for ReportReason: Instance of either InputReportReasonSpam, InputReportReasonViolence, InputReportReasonPornography, InputReportReasonChildAbuse, InputReportReasonOther, InputReportReasonCopyright, InputReportReasonGeoIrrelevant, InputReportReasonFake, InputReportReasonIllegalDrugs, InputReportReasonPersonalDetails.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x2e59d922
    SUBCLASS_OF_ID = 0x8401bd27

    def _bytes(self):
        return b''.join((
            b'"\xd9Y.',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputReportReasonSpam(TLObject):
    """
    Constructor for ReportReason: Instance of either InputReportReasonSpam, InputReportReasonViolence, InputReportReasonPornography, InputReportReasonChildAbuse, InputReportReasonOther, InputReportReasonCopyright, InputReportReasonGeoIrrelevant, InputReportReasonFake, InputReportReasonIllegalDrugs, InputReportReasonPersonalDetails.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x58dbcab8
    SUBCLASS_OF_ID = 0x8401bd27

    def _bytes(self):
        return b''.join((
            b'\xb8\xca\xdbX',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputReportReasonViolence(TLObject):
    """
    Constructor for ReportReason: Instance of either InputReportReasonSpam, InputReportReasonViolence, InputReportReasonPornography, InputReportReasonChildAbuse, InputReportReasonOther, InputReportReasonCopyright, InputReportReasonGeoIrrelevant, InputReportReasonFake, InputReportReasonIllegalDrugs, InputReportReasonPersonalDetails.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x1e22c78d
    SUBCLASS_OF_ID = 0x8401bd27

    def _bytes(self):
        return b''.join((
            b'\x8d\xc7"\x1e',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputSecureFile(TLObject):
    """
    Constructor for InputSecureFile: Instance of either InputSecureFileUploaded, InputSecureFile.
    """
    __slots__ = ('id', 'access_hash',)
    CONSTRUCTOR_ID = 0x5367e5be
    SUBCLASS_OF_ID = 0xdac8adfc

    id: int
    access_hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'\xbe\xe5gS',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputSecureFileLocation(TLObject):
    """
    Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
    """
    __slots__ = ('id', 'access_hash',)
    CONSTRUCTOR_ID = 0xcbc7ee28
    SUBCLASS_OF_ID = 0x1523d462

    id: int
    access_hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'(\xee\xc7\xcb',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputSecureFileUploaded(TLObject):
    """
    Constructor for InputSecureFile: Instance of either InputSecureFileUploaded, InputSecureFile.
    """
    __slots__ = ('id', 'parts', 'md5_checksum', 'file_hash', 'secret',)
    CONSTRUCTOR_ID = 0x3334b0f0
    SUBCLASS_OF_ID = 0xdac8adfc

    id: int
    parts: int
    md5_checksum: str
    file_hash: bytes
    secret: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, md5_checksum: str, file_hash: bytes, secret: bytes):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'parts', parts)
        object.__setattr__(self, 'md5_checksum', md5_checksum)
        object.__setattr__(self, 'file_hash', file_hash)
        object.__setattr__(self, 'secret', secret)

    def _bytes(self):
        return b''.join((
            b'\xf0\xb043',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            self._serialize_bytes(self.md5_checksum),
            self._serialize_bytes(self.file_hash),
            self._serialize_bytes(self.secret),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _md5_checksum = reader.tgread_string()
        _file_hash = reader.tgread_bytes()
        _secret = reader.tgread_bytes()
        return cls(id=_id, parts=_parts, md5_checksum=_md5_checksum, file_hash=_file_hash, secret=_secret)


@dataclasses.dataclass(init=False, frozen=True)
class InputSecureValue(TLObject):
    """
    Constructor for InputSecureValue: Instance of InputSecureValue.
    """
    __slots__ = ('type', 'data', 'front_side', 'reverse_side', 'selfie', 'translation', 'files', 'plain_data',)
    CONSTRUCTOR_ID = 0xdb21d0a7
    SUBCLASS_OF_ID = 0xb49da1fc

    type: 'TypeSecureValueType'
    data: Optional['TypeSecureData']
    front_side: Optional['TypeInputSecureFile']
    reverse_side: Optional['TypeInputSecureFile']
    selfie: Optional['TypeInputSecureFile']
    translation: Optional[List['TypeInputSecureFile']]
    files: Optional[List['TypeInputSecureFile']]
    plain_data: Optional['TypeSecurePlainData']
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', data: Optional['TypeSecureData']=None, front_side: Optional['TypeInputSecureFile']=None, reverse_side: Optional['TypeInputSecureFile']=None, selfie: Optional['TypeInputSecureFile']=None, translation: Optional[List['TypeInputSecureFile']]=None, files: Optional[List['TypeInputSecureFile']]=None, plain_data: Optional['TypeSecurePlainData']=None):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'data', data)
        object.__setattr__(self, 'front_side', front_side)
        object.__setattr__(self, 'reverse_side', reverse_side)
        object.__setattr__(self, 'selfie', selfie)
        object.__setattr__(self, 'translation', translation)
        object.__setattr__(self, 'files', files)
        object.__setattr__(self, 'plain_data', plain_data)

    def _bytes(self):
        return b''.join((
            b'\xa7\xd0!\xdb',
            struct.pack('<I', (0 if self.data is None or self.data is False else 1) | (0 if self.front_side is None or self.front_side is False else 2) | (0 if self.reverse_side is None or self.reverse_side is False else 4) | (0 if self.selfie is None or self.selfie is False else 8) | (0 if self.translation is None or self.translation is False else 64) | (0 if self.files is None or self.files is False else 16) | (0 if self.plain_data is None or self.plain_data is False else 32)),
            self.type._bytes(),
            b'' if self.data is None or self.data is False else (self.data._bytes()),
            b'' if self.front_side is None or self.front_side is False else (self.front_side._bytes()),
            b'' if self.reverse_side is None or self.reverse_side is False else (self.reverse_side._bytes()),
            b'' if self.selfie is None or self.selfie is False else (self.selfie._bytes()),
            b'' if self.translation is None or self.translation is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.translation)),b''.join(x._bytes() for x in self.translation))),
            b'' if self.files is None or self.files is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.files)),b''.join(x._bytes() for x in self.files))),
            b'' if self.plain_data is None or self.plain_data is False else (self.plain_data._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _type = reader.tgread_object()
        if flags & 1:
            _data = reader.tgread_object()
        else:
            _data = None
        if flags & 2:
            _front_side = reader.tgread_object()
        else:
            _front_side = None
        if flags & 4:
            _reverse_side = reader.tgread_object()
        else:
            _reverse_side = None
        if flags & 8:
            _selfie = reader.tgread_object()
        else:
            _selfie = None
        if flags & 64:
            reader.read_int()
            _translation = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _translation.append(_x)

        else:
            _translation = None
        if flags & 16:
            reader.read_int()
            _files = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _files.append(_x)

        else:
            _files = None
        if flags & 32:
            _plain_data = reader.tgread_object()
        else:
            _plain_data = None
        return cls(type=_type, data=_data, front_side=_front_side, reverse_side=_reverse_side, selfie=_selfie, translation=_translation, files=_files, plain_data=_plain_data)


@dataclasses.dataclass(init=False, frozen=True)
class InputSingleMedia(TLObject):
    """
    Constructor for InputSingleMedia: Instance of InputSingleMedia.
    """
    __slots__ = ('media', 'message', 'random_id', 'entities',)
    CONSTRUCTOR_ID = 0x1cc6e91f
    SUBCLASS_OF_ID = 0x21ca8ed8

    media: 'TypeInputMedia'
    message: str
    random_id: int
    entities: Optional[List['TypeMessageEntity']]
    def __init__(self, media: 'TypeInputMedia', message: str, random_id: int=None, entities: Optional[List['TypeMessageEntity']]=None):
        object.__setattr__(self, 'media', media)
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'random_id', random_id)
        object.__setattr__(self, 'entities', entities)

    def _bytes(self):
        return b''.join((
            b'\x1f\xe9\xc6\x1c',
            struct.pack('<I', (0 if self.entities is None or self.entities is False else 1)),
            self.media._bytes(),
            struct.pack('<q', self.random_id),
            self._serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _media = reader.tgread_object()
        _random_id = reader.read_long()
        _message = reader.tgread_string()
        if flags & 1:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(media=_media, message=_message, random_id=_random_id, entities=_entities)


@dataclasses.dataclass(init=False, frozen=True)
class InputStickerSetAnimatedEmoji(TLObject):
    """
    Constructor for InputStickerSet: Instance of either InputStickerSetEmpty, InputStickerSetID, InputStickerSetShortName, InputStickerSetAnimatedEmoji, InputStickerSetDice, InputStickerSetAnimatedEmojiAnimations.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x28703c8
    SUBCLASS_OF_ID = 0x3da389aa

    def _bytes(self):
        return b''.join((
            b'\xc8\x03\x87\x02',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputStickerSetAnimatedEmojiAnimations(TLObject):
    """
    Constructor for InputStickerSet: Instance of either InputStickerSetEmpty, InputStickerSetID, InputStickerSetShortName, InputStickerSetAnimatedEmoji, InputStickerSetDice, InputStickerSetAnimatedEmojiAnimations.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xcde3739
    SUBCLASS_OF_ID = 0x3da389aa

    def _bytes(self):
        return b''.join((
            b'97\xde\x0c',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputStickerSetDice(TLObject):
    """
    Constructor for InputStickerSet: Instance of either InputStickerSetEmpty, InputStickerSetID, InputStickerSetShortName, InputStickerSetAnimatedEmoji, InputStickerSetDice, InputStickerSetAnimatedEmojiAnimations.
    """
    __slots__ = ('emoticon',)
    CONSTRUCTOR_ID = 0xe67f520e
    SUBCLASS_OF_ID = 0x3da389aa

    emoticon: str
    def __init__(self, emoticon: str):
        object.__setattr__(self, 'emoticon', emoticon)

    def _bytes(self):
        return b''.join((
            b'\x0eR\x7f\xe6',
            self._serialize_bytes(self.emoticon),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _emoticon = reader.tgread_string()
        return cls(emoticon=_emoticon)


@dataclasses.dataclass(init=False, frozen=True)
class InputStickerSetEmpty(TLObject):
    """
    Constructor for InputStickerSet: Instance of either InputStickerSetEmpty, InputStickerSetID, InputStickerSetShortName, InputStickerSetAnimatedEmoji, InputStickerSetDice, InputStickerSetAnimatedEmojiAnimations.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xffb62b95
    SUBCLASS_OF_ID = 0x3da389aa

    def _bytes(self):
        return b''.join((
            b'\x95+\xb6\xff',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputStickerSetID(TLObject):
    """
    Constructor for InputStickerSet: Instance of either InputStickerSetEmpty, InputStickerSetID, InputStickerSetShortName, InputStickerSetAnimatedEmoji, InputStickerSetDice, InputStickerSetAnimatedEmojiAnimations.
    """
    __slots__ = ('id', 'access_hash',)
    CONSTRUCTOR_ID = 0x9de7a269
    SUBCLASS_OF_ID = 0x3da389aa

    id: int
    access_hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'i\xa2\xe7\x9d',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputStickerSetItem(TLObject):
    """
    Constructor for InputStickerSetItem: Instance of InputStickerSetItem.
    """
    __slots__ = ('document', 'emoji', 'mask_coords',)
    CONSTRUCTOR_ID = 0xffa0a496
    SUBCLASS_OF_ID = 0xae59f075

    document: 'TypeInputDocument'
    emoji: str
    mask_coords: Optional['TypeMaskCoords']
    def __init__(self, document: 'TypeInputDocument', emoji: str, mask_coords: Optional['TypeMaskCoords']=None):
        object.__setattr__(self, 'document', document)
        object.__setattr__(self, 'emoji', emoji)
        object.__setattr__(self, 'mask_coords', mask_coords)

    def _bytes(self):
        return b''.join((
            b'\x96\xa4\xa0\xff',
            struct.pack('<I', (0 if self.mask_coords is None or self.mask_coords is False else 1)),
            self.document._bytes(),
            self._serialize_bytes(self.emoji),
            b'' if self.mask_coords is None or self.mask_coords is False else (self.mask_coords._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _document = reader.tgread_object()
        _emoji = reader.tgread_string()
        if flags & 1:
            _mask_coords = reader.tgread_object()
        else:
            _mask_coords = None
        return cls(document=_document, emoji=_emoji, mask_coords=_mask_coords)


@dataclasses.dataclass(init=False, frozen=True)
class InputStickerSetShortName(TLObject):
    """
    Constructor for InputStickerSet: Instance of either InputStickerSetEmpty, InputStickerSetID, InputStickerSetShortName, InputStickerSetAnimatedEmoji, InputStickerSetDice, InputStickerSetAnimatedEmojiAnimations.
    """
    __slots__ = ('short_name',)
    CONSTRUCTOR_ID = 0x861cc8a0
    SUBCLASS_OF_ID = 0x3da389aa

    short_name: str
    def __init__(self, short_name: str):
        object.__setattr__(self, 'short_name', short_name)

    def _bytes(self):
        return b''.join((
            b'\xa0\xc8\x1c\x86',
            self._serialize_bytes(self.short_name),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _short_name = reader.tgread_string()
        return cls(short_name=_short_name)


@dataclasses.dataclass(init=False, frozen=True)
class InputStickerSetThumb(TLObject):
    """
    Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
    """
    __slots__ = ('stickerset', 'thumb_version',)
    CONSTRUCTOR_ID = 0x9d84f3db
    SUBCLASS_OF_ID = 0x1523d462

    stickerset: 'TypeInputStickerSet'
    thumb_version: int
    def __init__(self, stickerset: 'TypeInputStickerSet', thumb_version: int):
        object.__setattr__(self, 'stickerset', stickerset)
        object.__setattr__(self, 'thumb_version', thumb_version)

    def _bytes(self):
        return b''.join((
            b'\xdb\xf3\x84\x9d',
            self.stickerset._bytes(),
            struct.pack('<i', self.thumb_version),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        _thumb_version = reader.read_int()
        return cls(stickerset=_stickerset, thumb_version=_thumb_version)


@dataclasses.dataclass(init=False, frozen=True)
class InputStickeredMediaDocument(TLObject):
    """
    Constructor for InputStickeredMedia: Instance of either InputStickeredMediaPhoto, InputStickeredMediaDocument.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x438865b
    SUBCLASS_OF_ID = 0x5146d99e

    id: 'TypeInputDocument'
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputDocument'):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'[\x868\x04',
            self.id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputStickeredMediaPhoto(TLObject):
    """
    Constructor for InputStickeredMedia: Instance of either InputStickeredMediaPhoto, InputStickeredMediaDocument.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x4a992157
    SUBCLASS_OF_ID = 0x5146d99e

    id: 'TypeInputPhoto'
    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputPhoto'):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'W!\x99J',
            self.id._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputTakeoutFileLocation(TLObject):
    """
    Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x29be5899
    SUBCLASS_OF_ID = 0x1523d462

    def _bytes(self):
        return b''.join((
            b'\x99X\xbe)',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputTheme(TLObject):
    """
    Constructor for InputTheme: Instance of either InputTheme, InputThemeSlug.
    """
    __slots__ = ('id', 'access_hash',)
    CONSTRUCTOR_ID = 0x3c5693e9
    SUBCLASS_OF_ID = 0x7a100f0

    id: int
    access_hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'\xe9\x93V<',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputThemeSettings(TLObject):
    """
    Constructor for InputThemeSettings: Instance of InputThemeSettings.
    """
    __slots__ = ('base_theme', 'accent_color', 'message_colors_animated', 'outbox_accent_color', 'message_colors', 'wallpaper', 'wallpaper_settings',)
    CONSTRUCTOR_ID = 0x8fde504f
    SUBCLASS_OF_ID = 0x8338c882

    base_theme: 'TypeBaseTheme'
    accent_color: int
    message_colors_animated: Optional[bool]
    outbox_accent_color: Optional[int]
    message_colors: Optional[List[int]]
    wallpaper: Optional['TypeInputWallPaper']
    wallpaper_settings: Optional['TypeWallPaperSettings']
    def __init__(self, base_theme: 'TypeBaseTheme', accent_color: int, message_colors_animated: Optional[bool]=None, outbox_accent_color: Optional[int]=None, message_colors: Optional[List[int]]=None, wallpaper: Optional['TypeInputWallPaper']=None, wallpaper_settings: Optional['TypeWallPaperSettings']=None):
        object.__setattr__(self, 'base_theme', base_theme)
        object.__setattr__(self, 'accent_color', accent_color)
        object.__setattr__(self, 'message_colors_animated', message_colors_animated)
        object.__setattr__(self, 'outbox_accent_color', outbox_accent_color)
        object.__setattr__(self, 'message_colors', message_colors)
        object.__setattr__(self, 'wallpaper', wallpaper)
        object.__setattr__(self, 'wallpaper_settings', wallpaper_settings)

    def _bytes(self):
        assert ((self.wallpaper or self.wallpaper is not None) and (self.wallpaper_settings or self.wallpaper_settings is not None)) or ((self.wallpaper is None or self.wallpaper is False) and (self.wallpaper_settings is None or self.wallpaper_settings is False)), 'wallpaper, wallpaper_settings parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'OP\xde\x8f',
            struct.pack('<I', (0 if self.message_colors_animated is None or self.message_colors_animated is False else 4) | (0 if self.outbox_accent_color is None or self.outbox_accent_color is False else 8) | (0 if self.message_colors is None or self.message_colors is False else 1) | (0 if self.wallpaper is None or self.wallpaper is False else 2) | (0 if self.wallpaper_settings is None or self.wallpaper_settings is False else 2)),
            self.base_theme._bytes(),
            struct.pack('<i', self.accent_color),
            b'' if self.outbox_accent_color is None or self.outbox_accent_color is False else (struct.pack('<i', self.outbox_accent_color)),
            b'' if self.message_colors is None or self.message_colors is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.message_colors)),b''.join(struct.pack('<i', x) for x in self.message_colors))),
            b'' if self.wallpaper is None or self.wallpaper is False else (self.wallpaper._bytes()),
            b'' if self.wallpaper_settings is None or self.wallpaper_settings is False else (self.wallpaper_settings._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _message_colors_animated = bool(flags & 4)
        _base_theme = reader.tgread_object()
        _accent_color = reader.read_int()
        if flags & 8:
            _outbox_accent_color = reader.read_int()
        else:
            _outbox_accent_color = None
        if flags & 1:
            reader.read_int()
            _message_colors = []
            for _ in range(reader.read_int()):
                _x = reader.read_int()
                _message_colors.append(_x)

        else:
            _message_colors = None
        if flags & 2:
            _wallpaper = reader.tgread_object()
        else:
            _wallpaper = None
        if flags & 2:
            _wallpaper_settings = reader.tgread_object()
        else:
            _wallpaper_settings = None
        return cls(base_theme=_base_theme, accent_color=_accent_color, message_colors_animated=_message_colors_animated, outbox_accent_color=_outbox_accent_color, message_colors=_message_colors, wallpaper=_wallpaper, wallpaper_settings=_wallpaper_settings)


@dataclasses.dataclass(init=False, frozen=True)
class InputThemeSlug(TLObject):
    """
    Constructor for InputTheme: Instance of either InputTheme, InputThemeSlug.
    """
    __slots__ = ('slug',)
    CONSTRUCTOR_ID = 0xf5890df1
    SUBCLASS_OF_ID = 0x7a100f0

    slug: str
    def __init__(self, slug: str):
        object.__setattr__(self, 'slug', slug)

    def _bytes(self):
        return b''.join((
            b'\xf1\r\x89\xf5',
            self._serialize_bytes(self.slug),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _slug = reader.tgread_string()
        return cls(slug=_slug)


@dataclasses.dataclass(init=False, frozen=True)
class InputUser(TLObject):
    """
    Constructor for InputUser: Instance of either InputUserEmpty, InputUserSelf, InputUser, InputUserFromMessage.
    """
    __slots__ = ('user_id', 'access_hash',)
    CONSTRUCTOR_ID = 0xf21158c6
    SUBCLASS_OF_ID = 0xe669bf46

    user_id: int
    access_hash: int
    def __init__(self, user_id: int, access_hash: int):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'\xc6X\x11\xf2',
            struct.pack('<q', self.user_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(user_id=_user_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputUserEmpty(TLObject):
    """
    Constructor for InputUser: Instance of either InputUserEmpty, InputUserSelf, InputUser, InputUserFromMessage.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb98886cf
    SUBCLASS_OF_ID = 0xe669bf46

    def _bytes(self):
        return b''.join((
            b'\xcf\x86\x88\xb9',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputUserFromMessage(TLObject):
    """
    Constructor for InputUser: Instance of either InputUserEmpty, InputUserSelf, InputUser, InputUserFromMessage.
    """
    __slots__ = ('peer', 'msg_id', 'user_id',)
    CONSTRUCTOR_ID = 0x1da448e2
    SUBCLASS_OF_ID = 0xe669bf46

    peer: 'TypeInputPeer'
    msg_id: int
    user_id: int
    def __init__(self, peer: 'TypeInputPeer', msg_id: int, user_id: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'user_id', user_id)

    def _bytes(self):
        return b''.join((
            b'\xe2H\xa4\x1d',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _user_id = reader.read_long()
        return cls(peer=_peer, msg_id=_msg_id, user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputUserSelf(TLObject):
    """
    Constructor for InputUser: Instance of either InputUserEmpty, InputUserSelf, InputUser, InputUserFromMessage.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xf7c1b13f
    SUBCLASS_OF_ID = 0xe669bf46

    def _bytes(self):
        return b''.join((
            b'?\xb1\xc1\xf7',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class InputWallPaper(TLObject):
    """
    Constructor for InputWallPaper: Instance of either InputWallPaper, InputWallPaperSlug, InputWallPaperNoFile.
    """
    __slots__ = ('id', 'access_hash',)
    CONSTRUCTOR_ID = 0xe630b979
    SUBCLASS_OF_ID = 0xee77201a

    id: int
    access_hash: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'y\xb90\xe6',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class InputWallPaperNoFile(TLObject):
    """
    Constructor for InputWallPaper: Instance of either InputWallPaper, InputWallPaperSlug, InputWallPaperNoFile.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x967a462e
    SUBCLASS_OF_ID = 0xee77201a

    id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'.Fz\x96',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class InputWallPaperSlug(TLObject):
    """
    Constructor for InputWallPaper: Instance of either InputWallPaper, InputWallPaperSlug, InputWallPaperNoFile.
    """
    __slots__ = ('slug',)
    CONSTRUCTOR_ID = 0x72091c80
    SUBCLASS_OF_ID = 0xee77201a

    slug: str
    def __init__(self, slug: str):
        object.__setattr__(self, 'slug', slug)

    def _bytes(self):
        return b''.join((
            b'\x80\x1c\tr',
            self._serialize_bytes(self.slug),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _slug = reader.tgread_string()
        return cls(slug=_slug)


@dataclasses.dataclass(init=False, frozen=True)
class InputWebDocument(TLObject):
    """
    Constructor for InputWebDocument: Instance of InputWebDocument.
    """
    __slots__ = ('url', 'size', 'mime_type', 'attributes',)
    CONSTRUCTOR_ID = 0x9bed434d
    SUBCLASS_OF_ID = 0x8ae8b146

    url: str
    size: int
    mime_type: str
    attributes: List['TypeDocumentAttribute']
    def __init__(self, url: str, size: int, mime_type: str, attributes: List['TypeDocumentAttribute']):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'size', size)
        object.__setattr__(self, 'mime_type', mime_type)
        object.__setattr__(self, 'attributes', attributes)

    def _bytes(self):
        return b''.join((
            b'MC\xed\x9b',
            self._serialize_bytes(self.url),
            struct.pack('<i', self.size),
            self._serialize_bytes(self.mime_type),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.attributes)),b''.join(x._bytes() for x in self.attributes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _url = reader.tgread_string()
        _size = reader.read_int()
        _mime_type = reader.tgread_string()
        reader.read_int()
        _attributes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _attributes.append(_x)

        return cls(url=_url, size=_size, mime_type=_mime_type, attributes=_attributes)


@dataclasses.dataclass(init=False, frozen=True)
class InputWebFileGeoPointLocation(TLObject):
    """
    Constructor for InputWebFileLocation: Instance of either InputWebFileLocation, InputWebFileGeoPointLocation.
    """
    __slots__ = ('geo_point', 'access_hash', 'w', 'h', 'zoom', 'scale',)
    CONSTRUCTOR_ID = 0x9f2221c9
    SUBCLASS_OF_ID = 0xf72ed8d9

    geo_point: 'TypeInputGeoPoint'
    access_hash: int
    w: int
    h: int
    zoom: int
    scale: int
    def __init__(self, geo_point: 'TypeInputGeoPoint', access_hash: int, w: int, h: int, zoom: int, scale: int):
        object.__setattr__(self, 'geo_point', geo_point)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'w', w)
        object.__setattr__(self, 'h', h)
        object.__setattr__(self, 'zoom', zoom)
        object.__setattr__(self, 'scale', scale)

    def _bytes(self):
        return b''.join((
            b'\xc9!"\x9f',
            self.geo_point._bytes(),
            struct.pack('<q', self.access_hash),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
            struct.pack('<i', self.zoom),
            struct.pack('<i', self.scale),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _geo_point = reader.tgread_object()
        _access_hash = reader.read_long()
        _w = reader.read_int()
        _h = reader.read_int()
        _zoom = reader.read_int()
        _scale = reader.read_int()
        return cls(geo_point=_geo_point, access_hash=_access_hash, w=_w, h=_h, zoom=_zoom, scale=_scale)


@dataclasses.dataclass(init=False, frozen=True)
class InputWebFileLocation(TLObject):
    """
    Constructor for InputWebFileLocation: Instance of either InputWebFileLocation, InputWebFileGeoPointLocation.
    """
    __slots__ = ('url', 'access_hash',)
    CONSTRUCTOR_ID = 0xc239d686
    SUBCLASS_OF_ID = 0xf72ed8d9

    url: str
    access_hash: int
    def __init__(self, url: str, access_hash: int):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'access_hash', access_hash)

    def _bytes(self):
        return b''.join((
            b'\x86\xd69\xc2',
            self._serialize_bytes(self.url),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _url = reader.tgread_string()
        _access_hash = reader.read_long()
        return cls(url=_url, access_hash=_access_hash)


@dataclasses.dataclass(init=False, frozen=True)
class Invoice(TLObject):
    """
    Constructor for Invoice: Instance of Invoice.
    """
    __slots__ = ('currency', 'prices', 'test', 'name_requested', 'phone_requested', 'email_requested', 'shipping_address_requested', 'flexible', 'phone_to_provider', 'email_to_provider', 'max_tip_amount', 'suggested_tip_amounts',)
    CONSTRUCTOR_ID = 0xcd886e0
    SUBCLASS_OF_ID = 0x5fd82ed8

    currency: str
    prices: List['TypeLabeledPrice']
    test: Optional[bool]
    name_requested: Optional[bool]
    phone_requested: Optional[bool]
    email_requested: Optional[bool]
    shipping_address_requested: Optional[bool]
    flexible: Optional[bool]
    phone_to_provider: Optional[bool]
    email_to_provider: Optional[bool]
    max_tip_amount: Optional[int]
    suggested_tip_amounts: Optional[List[int]]
    def __init__(self, currency: str, prices: List['TypeLabeledPrice'], test: Optional[bool]=None, name_requested: Optional[bool]=None, phone_requested: Optional[bool]=None, email_requested: Optional[bool]=None, shipping_address_requested: Optional[bool]=None, flexible: Optional[bool]=None, phone_to_provider: Optional[bool]=None, email_to_provider: Optional[bool]=None, max_tip_amount: Optional[int]=None, suggested_tip_amounts: Optional[List[int]]=None):
        object.__setattr__(self, 'currency', currency)
        object.__setattr__(self, 'prices', prices)
        object.__setattr__(self, 'test', test)
        object.__setattr__(self, 'name_requested', name_requested)
        object.__setattr__(self, 'phone_requested', phone_requested)
        object.__setattr__(self, 'email_requested', email_requested)
        object.__setattr__(self, 'shipping_address_requested', shipping_address_requested)
        object.__setattr__(self, 'flexible', flexible)
        object.__setattr__(self, 'phone_to_provider', phone_to_provider)
        object.__setattr__(self, 'email_to_provider', email_to_provider)
        object.__setattr__(self, 'max_tip_amount', max_tip_amount)
        object.__setattr__(self, 'suggested_tip_amounts', suggested_tip_amounts)

    def _bytes(self):
        assert ((self.max_tip_amount or self.max_tip_amount is not None) and (self.suggested_tip_amounts or self.suggested_tip_amounts is not None)) or ((self.max_tip_amount is None or self.max_tip_amount is False) and (self.suggested_tip_amounts is None or self.suggested_tip_amounts is False)), 'max_tip_amount, suggested_tip_amounts parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xe0\x86\xd8\x0c',
            struct.pack('<I', (0 if self.test is None or self.test is False else 1) | (0 if self.name_requested is None or self.name_requested is False else 2) | (0 if self.phone_requested is None or self.phone_requested is False else 4) | (0 if self.email_requested is None or self.email_requested is False else 8) | (0 if self.shipping_address_requested is None or self.shipping_address_requested is False else 16) | (0 if self.flexible is None or self.flexible is False else 32) | (0 if self.phone_to_provider is None or self.phone_to_provider is False else 64) | (0 if self.email_to_provider is None or self.email_to_provider is False else 128) | (0 if self.max_tip_amount is None or self.max_tip_amount is False else 256) | (0 if self.suggested_tip_amounts is None or self.suggested_tip_amounts is False else 256)),
            self._serialize_bytes(self.currency),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.prices)),b''.join(x._bytes() for x in self.prices),
            b'' if self.max_tip_amount is None or self.max_tip_amount is False else (struct.pack('<q', self.max_tip_amount)),
            b'' if self.suggested_tip_amounts is None or self.suggested_tip_amounts is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.suggested_tip_amounts)),b''.join(struct.pack('<q', x) for x in self.suggested_tip_amounts))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _test = bool(flags & 1)
        _name_requested = bool(flags & 2)
        _phone_requested = bool(flags & 4)
        _email_requested = bool(flags & 8)
        _shipping_address_requested = bool(flags & 16)
        _flexible = bool(flags & 32)
        _phone_to_provider = bool(flags & 64)
        _email_to_provider = bool(flags & 128)
        _currency = reader.tgread_string()
        reader.read_int()
        _prices = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _prices.append(_x)

        if flags & 256:
            _max_tip_amount = reader.read_long()
        else:
            _max_tip_amount = None
        if flags & 256:
            reader.read_int()
            _suggested_tip_amounts = []
            for _ in range(reader.read_int()):
                _x = reader.read_long()
                _suggested_tip_amounts.append(_x)

        else:
            _suggested_tip_amounts = None
        return cls(currency=_currency, prices=_prices, test=_test, name_requested=_name_requested, phone_requested=_phone_requested, email_requested=_email_requested, shipping_address_requested=_shipping_address_requested, flexible=_flexible, phone_to_provider=_phone_to_provider, email_to_provider=_email_to_provider, max_tip_amount=_max_tip_amount, suggested_tip_amounts=_suggested_tip_amounts)


@dataclasses.dataclass(init=False, frozen=True)
class IpPort(TLObject):
    """
    Constructor for IpPort: Instance of either IpPort, IpPortSecret.
    """
    __slots__ = ('ipv4', 'port',)
    CONSTRUCTOR_ID = 0xd433ad73
    SUBCLASS_OF_ID = 0xa2a03726

    ipv4: int
    port: int
    def __init__(self, ipv4: int, port: int):
        object.__setattr__(self, 'ipv4', ipv4)
        object.__setattr__(self, 'port', port)

    def _bytes(self):
        return b''.join((
            b's\xad3\xd4',
            struct.pack('<i', self.ipv4),
            struct.pack('<i', self.port),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _ipv4 = reader.read_int()
        _port = reader.read_int()
        return cls(ipv4=_ipv4, port=_port)


@dataclasses.dataclass(init=False, frozen=True)
class IpPortSecret(TLObject):
    """
    Constructor for IpPort: Instance of either IpPort, IpPortSecret.
    """
    __slots__ = ('ipv4', 'port', 'secret',)
    CONSTRUCTOR_ID = 0x37982646
    SUBCLASS_OF_ID = 0xa2a03726

    ipv4: int
    port: int
    secret: bytes
    def __init__(self, ipv4: int, port: int, secret: bytes):
        object.__setattr__(self, 'ipv4', ipv4)
        object.__setattr__(self, 'port', port)
        object.__setattr__(self, 'secret', secret)

    def _bytes(self):
        return b''.join((
            b'F&\x987',
            struct.pack('<i', self.ipv4),
            struct.pack('<i', self.port),
            self._serialize_bytes(self.secret),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _ipv4 = reader.read_int()
        _port = reader.read_int()
        _secret = reader.tgread_bytes()
        return cls(ipv4=_ipv4, port=_port, secret=_secret)


@dataclasses.dataclass(init=False, frozen=True)
class JsonArray(TLObject):
    """
    Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
    """
    __slots__ = ('value',)
    CONSTRUCTOR_ID = 0xf7444763
    SUBCLASS_OF_ID = 0xeb9987b3

    value: List['TypeJSONValue']
    def __init__(self, value: List['TypeJSONValue']):
        object.__setattr__(self, 'value', value)

    def _bytes(self):
        return b''.join((
            b'cGD\xf7',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.value)),b''.join(x._bytes() for x in self.value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _value = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _value.append(_x)

        return cls(value=_value)


@dataclasses.dataclass(init=False, frozen=True)
class JsonBool(TLObject):
    """
    Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
    """
    __slots__ = ('value',)
    CONSTRUCTOR_ID = 0xc7345e6a
    SUBCLASS_OF_ID = 0xeb9987b3

    value: bool
    def __init__(self, value: bool):
        object.__setattr__(self, 'value', value)

    def _bytes(self):
        return b''.join((
            b'j^4\xc7',
            b'\xb5ur\x99' if self.value else b'7\x97y\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        _value = reader.tgread_bool()
        return cls(value=_value)


@dataclasses.dataclass(init=False, frozen=True)
class JsonNull(TLObject):
    """
    Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x3f6d7b68
    SUBCLASS_OF_ID = 0xeb9987b3

    def _bytes(self):
        return b''.join((
            b'h{m?',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class JsonNumber(TLObject):
    """
    Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
    """
    __slots__ = ('value',)
    CONSTRUCTOR_ID = 0x2be0dfa4
    SUBCLASS_OF_ID = 0xeb9987b3

    value: float
    def __init__(self, value: float):
        object.__setattr__(self, 'value', value)

    def _bytes(self):
        return b''.join((
            b'\xa4\xdf\xe0+',
            struct.pack('<d', self.value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _value = reader.read_double()
        return cls(value=_value)


@dataclasses.dataclass(init=False, frozen=True)
class JsonObject(TLObject):
    """
    Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
    """
    __slots__ = ('value',)
    CONSTRUCTOR_ID = 0x99c1d49d
    SUBCLASS_OF_ID = 0xeb9987b3

    value: List['TypeJSONObjectValue']
    def __init__(self, value: List['TypeJSONObjectValue']):
        object.__setattr__(self, 'value', value)

    def _bytes(self):
        return b''.join((
            b'\x9d\xd4\xc1\x99',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.value)),b''.join(x._bytes() for x in self.value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _value = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _value.append(_x)

        return cls(value=_value)


@dataclasses.dataclass(init=False, frozen=True)
class JsonObjectValue(TLObject):
    """
    Constructor for JSONObjectValue: Instance of JsonObjectValue.
    """
    __slots__ = ('key', 'value',)
    CONSTRUCTOR_ID = 0xc0de1bd9
    SUBCLASS_OF_ID = 0x937fceb9

    key: str
    value: 'TypeJSONValue'
    def __init__(self, key: str, value: 'TypeJSONValue'):
        object.__setattr__(self, 'key', key)
        object.__setattr__(self, 'value', value)

    def _bytes(self):
        return b''.join((
            b'\xd9\x1b\xde\xc0',
            self._serialize_bytes(self.key),
            self.value._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _key = reader.tgread_string()
        _value = reader.tgread_object()
        return cls(key=_key, value=_value)


@dataclasses.dataclass(init=False, frozen=True)
class JsonString(TLObject):
    """
    Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
    """
    __slots__ = ('value',)
    CONSTRUCTOR_ID = 0xb71e767a
    SUBCLASS_OF_ID = 0xeb9987b3

    value: str
    def __init__(self, value: str):
        object.__setattr__(self, 'value', value)

    def _bytes(self):
        return b''.join((
            b'zv\x1e\xb7',
            self._serialize_bytes(self.value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _value = reader.tgread_string()
        return cls(value=_value)


@dataclasses.dataclass(init=False, frozen=True)
class KeyboardButton(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0xa2fa4880
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    def __init__(self, text: str):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\x80H\xfa\xa2',
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class KeyboardButtonBuy(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0xafd93fbb
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    def __init__(self, text: str):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xbb?\xd9\xaf',
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class KeyboardButtonCallback(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text', 'data', 'requires_password',)
    CONSTRUCTOR_ID = 0x35bbdb6b
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    data: bytes
    requires_password: Optional[bool]
    def __init__(self, text: str, data: bytes, requires_password: Optional[bool]=None):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'data', data)
        object.__setattr__(self, 'requires_password', requires_password)

    def _bytes(self):
        return b''.join((
            b'k\xdb\xbb5',
            struct.pack('<I', (0 if self.requires_password is None or self.requires_password is False else 1)),
            self._serialize_bytes(self.text),
            self._serialize_bytes(self.data),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _requires_password = bool(flags & 1)
        _text = reader.tgread_string()
        _data = reader.tgread_bytes()
        return cls(text=_text, data=_data, requires_password=_requires_password)


@dataclasses.dataclass(init=False, frozen=True)
class KeyboardButtonGame(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0x50f41ccf
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    def __init__(self, text: str):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xcf\x1c\xf4P',
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class KeyboardButtonRequestGeoLocation(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0xfc796b3f
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    def __init__(self, text: str):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'?ky\xfc',
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class KeyboardButtonRequestPhone(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0xb16a6c29
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    def __init__(self, text: str):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b')lj\xb1',
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class KeyboardButtonRequestPoll(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text', 'quiz',)
    CONSTRUCTOR_ID = 0xbbc7515d
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    quiz: Optional[bool]
    def __init__(self, text: str, quiz: Optional[bool]=None):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'quiz', quiz)

    def _bytes(self):
        return b''.join((
            b']Q\xc7\xbb',
            struct.pack('<I', (0 if self.quiz is None else 1)),
            b'' if self.quiz is None else (b'\xb5ur\x99' if self.quiz else b'7\x97y\xbc'),
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _quiz = reader.tgread_bool()
        else:
            _quiz = None
        _text = reader.tgread_string()
        return cls(text=_text, quiz=_quiz)


@dataclasses.dataclass(init=False, frozen=True)
class KeyboardButtonRow(TLObject):
    """
    Constructor for KeyboardButtonRow: Instance of KeyboardButtonRow.
    """
    __slots__ = ('buttons',)
    CONSTRUCTOR_ID = 0x77608b83
    SUBCLASS_OF_ID = 0x847730ae

    buttons: List['TypeKeyboardButton']
    def __init__(self, buttons: List['TypeKeyboardButton']):
        object.__setattr__(self, 'buttons', buttons)

    def _bytes(self):
        return b''.join((
            b'\x83\x8b`w',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.buttons)),b''.join(x._bytes() for x in self.buttons),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _buttons = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _buttons.append(_x)

        return cls(buttons=_buttons)


@dataclasses.dataclass(init=False, frozen=True)
class KeyboardButtonSwitchInline(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text', 'query', 'same_peer',)
    CONSTRUCTOR_ID = 0x568a748
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    query: str
    same_peer: Optional[bool]
    def __init__(self, text: str, query: str, same_peer: Optional[bool]=None):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'query', query)
        object.__setattr__(self, 'same_peer', same_peer)

    def _bytes(self):
        return b''.join((
            b'H\xa7h\x05',
            struct.pack('<I', (0 if self.same_peer is None or self.same_peer is False else 1)),
            self._serialize_bytes(self.text),
            self._serialize_bytes(self.query),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _same_peer = bool(flags & 1)
        _text = reader.tgread_string()
        _query = reader.tgread_string()
        return cls(text=_text, query=_query, same_peer=_same_peer)


@dataclasses.dataclass(init=False, frozen=True)
class KeyboardButtonUrl(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text', 'url',)
    CONSTRUCTOR_ID = 0x258aff05
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    url: str
    def __init__(self, text: str, url: str):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'url', url)

    def _bytes(self):
        return b''.join((
            b'\x05\xff\x8a%',
            self._serialize_bytes(self.text),
            self._serialize_bytes(self.url),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_string()
        _url = reader.tgread_string()
        return cls(text=_text, url=_url)


@dataclasses.dataclass(init=False, frozen=True)
class KeyboardButtonUrlAuth(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text', 'url', 'button_id', 'fwd_text',)
    CONSTRUCTOR_ID = 0x10b78d29
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    url: str
    button_id: int
    fwd_text: Optional[str]
    def __init__(self, text: str, url: str, button_id: int, fwd_text: Optional[str]=None):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'button_id', button_id)
        object.__setattr__(self, 'fwd_text', fwd_text)

    def _bytes(self):
        return b''.join((
            b')\x8d\xb7\x10',
            struct.pack('<I', (0 if self.fwd_text is None or self.fwd_text is False else 1)),
            self._serialize_bytes(self.text),
            b'' if self.fwd_text is None or self.fwd_text is False else (self._serialize_bytes(self.fwd_text)),
            self._serialize_bytes(self.url),
            struct.pack('<i', self.button_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _text = reader.tgread_string()
        if flags & 1:
            _fwd_text = reader.tgread_string()
        else:
            _fwd_text = None
        _url = reader.tgread_string()
        _button_id = reader.read_int()
        return cls(text=_text, url=_url, button_id=_button_id, fwd_text=_fwd_text)


@dataclasses.dataclass(init=False, frozen=True)
class KeyboardButtonUserProfile(TLObject):
    """
    Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile.
    """
    __slots__ = ('text', 'user_id',)
    CONSTRUCTOR_ID = 0x308660c1
    SUBCLASS_OF_ID = 0xbad74a3

    text: str
    user_id: int
    def __init__(self, text: str, user_id: int):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'user_id', user_id)

    def _bytes(self):
        return b''.join((
            b'\xc1`\x860',
            self._serialize_bytes(self.text),
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_string()
        _user_id = reader.read_long()
        return cls(text=_text, user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class LabeledPrice(TLObject):
    """
    Constructor for LabeledPrice: Instance of LabeledPrice.
    """
    __slots__ = ('label', 'amount',)
    CONSTRUCTOR_ID = 0xcb296bf8
    SUBCLASS_OF_ID = 0x1c84047a

    label: str
    amount: int
    def __init__(self, label: str, amount: int):
        object.__setattr__(self, 'label', label)
        object.__setattr__(self, 'amount', amount)

    def _bytes(self):
        return b''.join((
            b'\xf8k)\xcb',
            self._serialize_bytes(self.label),
            struct.pack('<q', self.amount),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _label = reader.tgread_string()
        _amount = reader.read_long()
        return cls(label=_label, amount=_amount)


@dataclasses.dataclass(init=False, frozen=True)
class LangPackDifference(TLObject):
    """
    Constructor for LangPackDifference: Instance of LangPackDifference.
    """
    __slots__ = ('lang_code', 'from_version', 'version', 'strings',)
    CONSTRUCTOR_ID = 0xf385c1f6
    SUBCLASS_OF_ID = 0x52662d55

    lang_code: str
    from_version: int
    version: int
    strings: List['TypeLangPackString']
    def __init__(self, lang_code: str, from_version: int, version: int, strings: List['TypeLangPackString']):
        object.__setattr__(self, 'lang_code', lang_code)
        object.__setattr__(self, 'from_version', from_version)
        object.__setattr__(self, 'version', version)
        object.__setattr__(self, 'strings', strings)

    def _bytes(self):
        return b''.join((
            b'\xf6\xc1\x85\xf3',
            self._serialize_bytes(self.lang_code),
            struct.pack('<i', self.from_version),
            struct.pack('<i', self.version),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.strings)),b''.join(x._bytes() for x in self.strings),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        _from_version = reader.read_int()
        _version = reader.read_int()
        reader.read_int()
        _strings = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _strings.append(_x)

        return cls(lang_code=_lang_code, from_version=_from_version, version=_version, strings=_strings)


@dataclasses.dataclass(init=False, frozen=True)
class LangPackLanguage(TLObject):
    """
    Constructor for LangPackLanguage: Instance of LangPackLanguage.
    """
    __slots__ = ('name', 'native_name', 'lang_code', 'plural_code', 'strings_count', 'translated_count', 'translations_url', 'official', 'rtl', 'beta', 'base_lang_code',)
    CONSTRUCTOR_ID = 0xeeca5ce3
    SUBCLASS_OF_ID = 0xabac89b7

    name: str
    native_name: str
    lang_code: str
    plural_code: str
    strings_count: int
    translated_count: int
    translations_url: str
    official: Optional[bool]
    rtl: Optional[bool]
    beta: Optional[bool]
    base_lang_code: Optional[str]
    def __init__(self, name: str, native_name: str, lang_code: str, plural_code: str, strings_count: int, translated_count: int, translations_url: str, official: Optional[bool]=None, rtl: Optional[bool]=None, beta: Optional[bool]=None, base_lang_code: Optional[str]=None):
        object.__setattr__(self, 'name', name)
        object.__setattr__(self, 'native_name', native_name)
        object.__setattr__(self, 'lang_code', lang_code)
        object.__setattr__(self, 'plural_code', plural_code)
        object.__setattr__(self, 'strings_count', strings_count)
        object.__setattr__(self, 'translated_count', translated_count)
        object.__setattr__(self, 'translations_url', translations_url)
        object.__setattr__(self, 'official', official)
        object.__setattr__(self, 'rtl', rtl)
        object.__setattr__(self, 'beta', beta)
        object.__setattr__(self, 'base_lang_code', base_lang_code)

    def _bytes(self):
        return b''.join((
            b'\xe3\\\xca\xee',
            struct.pack('<I', (0 if self.official is None or self.official is False else 1) | (0 if self.rtl is None or self.rtl is False else 4) | (0 if self.beta is None or self.beta is False else 8) | (0 if self.base_lang_code is None or self.base_lang_code is False else 2)),
            self._serialize_bytes(self.name),
            self._serialize_bytes(self.native_name),
            self._serialize_bytes(self.lang_code),
            b'' if self.base_lang_code is None or self.base_lang_code is False else (self._serialize_bytes(self.base_lang_code)),
            self._serialize_bytes(self.plural_code),
            struct.pack('<i', self.strings_count),
            struct.pack('<i', self.translated_count),
            self._serialize_bytes(self.translations_url),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _official = bool(flags & 1)
        _rtl = bool(flags & 4)
        _beta = bool(flags & 8)
        _name = reader.tgread_string()
        _native_name = reader.tgread_string()
        _lang_code = reader.tgread_string()
        if flags & 2:
            _base_lang_code = reader.tgread_string()
        else:
            _base_lang_code = None
        _plural_code = reader.tgread_string()
        _strings_count = reader.read_int()
        _translated_count = reader.read_int()
        _translations_url = reader.tgread_string()
        return cls(name=_name, native_name=_native_name, lang_code=_lang_code, plural_code=_plural_code, strings_count=_strings_count, translated_count=_translated_count, translations_url=_translations_url, official=_official, rtl=_rtl, beta=_beta, base_lang_code=_base_lang_code)


@dataclasses.dataclass(init=False, frozen=True)
class LangPackString(TLObject):
    """
    Constructor for LangPackString: Instance of either LangPackString, LangPackStringPluralized, LangPackStringDeleted.
    """
    __slots__ = ('key', 'value',)
    CONSTRUCTOR_ID = 0xcad181f6
    SUBCLASS_OF_ID = 0xdc179ab9

    key: str
    value: str
    def __init__(self, key: str, value: str):
        object.__setattr__(self, 'key', key)
        object.__setattr__(self, 'value', value)

    def _bytes(self):
        return b''.join((
            b'\xf6\x81\xd1\xca',
            self._serialize_bytes(self.key),
            self._serialize_bytes(self.value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _key = reader.tgread_string()
        _value = reader.tgread_string()
        return cls(key=_key, value=_value)


@dataclasses.dataclass(init=False, frozen=True)
class LangPackStringDeleted(TLObject):
    """
    Constructor for LangPackString: Instance of either LangPackString, LangPackStringPluralized, LangPackStringDeleted.
    """
    __slots__ = ('key',)
    CONSTRUCTOR_ID = 0x2979eeb2
    SUBCLASS_OF_ID = 0xdc179ab9

    key: str
    def __init__(self, key: str):
        object.__setattr__(self, 'key', key)

    def _bytes(self):
        return b''.join((
            b'\xb2\xeey)',
            self._serialize_bytes(self.key),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _key = reader.tgread_string()
        return cls(key=_key)


@dataclasses.dataclass(init=False, frozen=True)
class LangPackStringPluralized(TLObject):
    """
    Constructor for LangPackString: Instance of either LangPackString, LangPackStringPluralized, LangPackStringDeleted.
    """
    __slots__ = ('key', 'other_value', 'zero_value', 'one_value', 'two_value', 'few_value', 'many_value',)
    CONSTRUCTOR_ID = 0x6c47ac9f
    SUBCLASS_OF_ID = 0xdc179ab9

    key: str
    other_value: str
    zero_value: Optional[str]
    one_value: Optional[str]
    two_value: Optional[str]
    few_value: Optional[str]
    many_value: Optional[str]
    def __init__(self, key: str, other_value: str, zero_value: Optional[str]=None, one_value: Optional[str]=None, two_value: Optional[str]=None, few_value: Optional[str]=None, many_value: Optional[str]=None):
        object.__setattr__(self, 'key', key)
        object.__setattr__(self, 'other_value', other_value)
        object.__setattr__(self, 'zero_value', zero_value)
        object.__setattr__(self, 'one_value', one_value)
        object.__setattr__(self, 'two_value', two_value)
        object.__setattr__(self, 'few_value', few_value)
        object.__setattr__(self, 'many_value', many_value)

    def _bytes(self):
        return b''.join((
            b'\x9f\xacGl',
            struct.pack('<I', (0 if self.zero_value is None or self.zero_value is False else 1) | (0 if self.one_value is None or self.one_value is False else 2) | (0 if self.two_value is None or self.two_value is False else 4) | (0 if self.few_value is None or self.few_value is False else 8) | (0 if self.many_value is None or self.many_value is False else 16)),
            self._serialize_bytes(self.key),
            b'' if self.zero_value is None or self.zero_value is False else (self._serialize_bytes(self.zero_value)),
            b'' if self.one_value is None or self.one_value is False else (self._serialize_bytes(self.one_value)),
            b'' if self.two_value is None or self.two_value is False else (self._serialize_bytes(self.two_value)),
            b'' if self.few_value is None or self.few_value is False else (self._serialize_bytes(self.few_value)),
            b'' if self.many_value is None or self.many_value is False else (self._serialize_bytes(self.many_value)),
            self._serialize_bytes(self.other_value),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _key = reader.tgread_string()
        if flags & 1:
            _zero_value = reader.tgread_string()
        else:
            _zero_value = None
        if flags & 2:
            _one_value = reader.tgread_string()
        else:
            _one_value = None
        if flags & 4:
            _two_value = reader.tgread_string()
        else:
            _two_value = None
        if flags & 8:
            _few_value = reader.tgread_string()
        else:
            _few_value = None
        if flags & 16:
            _many_value = reader.tgread_string()
        else:
            _many_value = None
        _other_value = reader.tgread_string()
        return cls(key=_key, other_value=_other_value, zero_value=_zero_value, one_value=_one_value, two_value=_two_value, few_value=_few_value, many_value=_many_value)


@dataclasses.dataclass(init=False, frozen=True)
class MaskCoords(TLObject):
    """
    Constructor for MaskCoords: Instance of MaskCoords.
    """
    __slots__ = ('n', 'x', 'y', 'zoom',)
    CONSTRUCTOR_ID = 0xaed6dbb2
    SUBCLASS_OF_ID = 0x6bbb2fd

    n: int
    x: float
    y: float
    zoom: float
    def __init__(self, n: int, x: float, y: float, zoom: float):
        object.__setattr__(self, 'n', n)
        object.__setattr__(self, 'x', x)
        object.__setattr__(self, 'y', y)
        object.__setattr__(self, 'zoom', zoom)

    def _bytes(self):
        return b''.join((
            b'\xb2\xdb\xd6\xae',
            struct.pack('<i', self.n),
            struct.pack('<d', self.x),
            struct.pack('<d', self.y),
            struct.pack('<d', self.zoom),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _n = reader.read_int()
        _x = reader.read_double()
        _y = reader.read_double()
        _zoom = reader.read_double()
        return cls(n=_n, x=_x, y=_y, zoom=_zoom)


@dataclasses.dataclass(init=False, frozen=True)
class Message(TLObject):
    """
    Constructor for Message: Instance of either MessageEmpty, Message, MessageService.
    """
    __slots__ = ('id', 'peer_id', 'date', 'message', 'out', 'mentioned', 'media_unread', 'silent', 'post', 'from_scheduled', 'legacy', 'edit_hide', 'pinned', 'noforwards', 'from_id', 'fwd_from', 'via_bot_id', 'reply_to', 'media', 'reply_markup', 'entities', 'views', 'forwards', 'replies', 'edit_date', 'post_author', 'grouped_id', 'reactions', 'restriction_reason', 'ttl_period',)
    CONSTRUCTOR_ID = 0x38116ee0
    SUBCLASS_OF_ID = 0x790009e3

    id: int
    peer_id: 'TypePeer'
    date: Optional[datetime]
    message: str
    out: Optional[bool]
    mentioned: Optional[bool]
    media_unread: Optional[bool]
    silent: Optional[bool]
    post: Optional[bool]
    from_scheduled: Optional[bool]
    legacy: Optional[bool]
    edit_hide: Optional[bool]
    pinned: Optional[bool]
    noforwards: Optional[bool]
    from_id: Optional['TypePeer']
    fwd_from: Optional['TypeMessageFwdHeader']
    via_bot_id: Optional[int]
    reply_to: Optional['TypeMessageReplyHeader']
    media: Optional['TypeMessageMedia']
    reply_markup: Optional['TypeReplyMarkup']
    entities: Optional[List['TypeMessageEntity']]
    views: Optional[int]
    forwards: Optional[int]
    replies: Optional['TypeMessageReplies']
    edit_date: Optional[datetime]
    post_author: Optional[str]
    grouped_id: Optional[int]
    reactions: Optional['TypeMessageReactions']
    restriction_reason: Optional[List['TypeRestrictionReason']]
    ttl_period: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, peer_id: 'TypePeer', date: Optional[datetime], message: str, out: Optional[bool]=None, mentioned: Optional[bool]=None, media_unread: Optional[bool]=None, silent: Optional[bool]=None, post: Optional[bool]=None, from_scheduled: Optional[bool]=None, legacy: Optional[bool]=None, edit_hide: Optional[bool]=None, pinned: Optional[bool]=None, noforwards: Optional[bool]=None, from_id: Optional['TypePeer']=None, fwd_from: Optional['TypeMessageFwdHeader']=None, via_bot_id: Optional[int]=None, reply_to: Optional['TypeMessageReplyHeader']=None, media: Optional['TypeMessageMedia']=None, reply_markup: Optional['TypeReplyMarkup']=None, entities: Optional[List['TypeMessageEntity']]=None, views: Optional[int]=None, forwards: Optional[int]=None, replies: Optional['TypeMessageReplies']=None, edit_date: Optional[datetime]=None, post_author: Optional[str]=None, grouped_id: Optional[int]=None, reactions: Optional['TypeMessageReactions']=None, restriction_reason: Optional[List['TypeRestrictionReason']]=None, ttl_period: Optional[int]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'peer_id', peer_id)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'out', out)
        object.__setattr__(self, 'mentioned', mentioned)
        object.__setattr__(self, 'media_unread', media_unread)
        object.__setattr__(self, 'silent', silent)
        object.__setattr__(self, 'post', post)
        object.__setattr__(self, 'from_scheduled', from_scheduled)
        object.__setattr__(self, 'legacy', legacy)
        object.__setattr__(self, 'edit_hide', edit_hide)
        object.__setattr__(self, 'pinned', pinned)
        object.__setattr__(self, 'noforwards', noforwards)
        object.__setattr__(self, 'from_id', from_id)
        object.__setattr__(self, 'fwd_from', fwd_from)
        object.__setattr__(self, 'via_bot_id', via_bot_id)
        object.__setattr__(self, 'reply_to', reply_to)
        object.__setattr__(self, 'media', media)
        object.__setattr__(self, 'reply_markup', reply_markup)
        object.__setattr__(self, 'entities', entities)
        object.__setattr__(self, 'views', views)
        object.__setattr__(self, 'forwards', forwards)
        object.__setattr__(self, 'replies', replies)
        object.__setattr__(self, 'edit_date', edit_date)
        object.__setattr__(self, 'post_author', post_author)
        object.__setattr__(self, 'grouped_id', grouped_id)
        object.__setattr__(self, 'reactions', reactions)
        object.__setattr__(self, 'restriction_reason', restriction_reason)
        object.__setattr__(self, 'ttl_period', ttl_period)

    def _bytes(self):
        assert ((self.views or self.views is not None) and (self.forwards or self.forwards is not None)) or ((self.views is None or self.views is False) and (self.forwards is None or self.forwards is False)), 'views, forwards parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xe0n\x118',
            struct.pack('<I', (0 if self.out is None or self.out is False else 2) | (0 if self.mentioned is None or self.mentioned is False else 16) | (0 if self.media_unread is None or self.media_unread is False else 32) | (0 if self.silent is None or self.silent is False else 8192) | (0 if self.post is None or self.post is False else 16384) | (0 if self.from_scheduled is None or self.from_scheduled is False else 262144) | (0 if self.legacy is None or self.legacy is False else 524288) | (0 if self.edit_hide is None or self.edit_hide is False else 2097152) | (0 if self.pinned is None or self.pinned is False else 16777216) | (0 if self.noforwards is None or self.noforwards is False else 67108864) | (0 if self.from_id is None or self.from_id is False else 256) | (0 if self.fwd_from is None or self.fwd_from is False else 4) | (0 if self.via_bot_id is None or self.via_bot_id is False else 2048) | (0 if self.reply_to is None or self.reply_to is False else 8) | (0 if self.media is None or self.media is False else 512) | (0 if self.reply_markup is None or self.reply_markup is False else 64) | (0 if self.entities is None or self.entities is False else 128) | (0 if self.views is None or self.views is False else 1024) | (0 if self.forwards is None or self.forwards is False else 1024) | (0 if self.replies is None or self.replies is False else 8388608) | (0 if self.edit_date is None or self.edit_date is False else 32768) | (0 if self.post_author is None or self.post_author is False else 65536) | (0 if self.grouped_id is None or self.grouped_id is False else 131072) | (0 if self.reactions is None or self.reactions is False else 1048576) | (0 if self.restriction_reason is None or self.restriction_reason is False else 4194304) | (0 if self.ttl_period is None or self.ttl_period is False else 33554432)),
            struct.pack('<i', self.id),
            b'' if self.from_id is None or self.from_id is False else (self.from_id._bytes()),
            self.peer_id._bytes(),
            b'' if self.fwd_from is None or self.fwd_from is False else (self.fwd_from._bytes()),
            b'' if self.via_bot_id is None or self.via_bot_id is False else (struct.pack('<q', self.via_bot_id)),
            b'' if self.reply_to is None or self.reply_to is False else (self.reply_to._bytes()),
            self._serialize_datetime(self.date),
            self._serialize_bytes(self.message),
            b'' if self.media is None or self.media is False else (self.media._bytes()),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.views is None or self.views is False else (struct.pack('<i', self.views)),
            b'' if self.forwards is None or self.forwards is False else (struct.pack('<i', self.forwards)),
            b'' if self.replies is None or self.replies is False else (self.replies._bytes()),
            b'' if self.edit_date is None or self.edit_date is False else (self._serialize_datetime(self.edit_date)),
            b'' if self.post_author is None or self.post_author is False else (self._serialize_bytes(self.post_author)),
            b'' if self.grouped_id is None or self.grouped_id is False else (struct.pack('<q', self.grouped_id)),
            b'' if self.reactions is None or self.reactions is False else (self.reactions._bytes()),
            b'' if self.restriction_reason is None or self.restriction_reason is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.restriction_reason)),b''.join(x._bytes() for x in self.restriction_reason))),
            b'' if self.ttl_period is None or self.ttl_period is False else (struct.pack('<i', self.ttl_period)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _out = bool(flags & 2)
        _mentioned = bool(flags & 16)
        _media_unread = bool(flags & 32)
        _silent = bool(flags & 8192)
        _post = bool(flags & 16384)
        _from_scheduled = bool(flags & 262144)
        _legacy = bool(flags & 524288)
        _edit_hide = bool(flags & 2097152)
        _pinned = bool(flags & 16777216)
        _noforwards = bool(flags & 67108864)
        _id = reader.read_int()
        if flags & 256:
            _from_id = reader.tgread_object()
        else:
            _from_id = None
        _peer_id = reader.tgread_object()
        if flags & 4:
            _fwd_from = reader.tgread_object()
        else:
            _fwd_from = None
        if flags & 2048:
            _via_bot_id = reader.read_long()
        else:
            _via_bot_id = None
        if flags & 8:
            _reply_to = reader.tgread_object()
        else:
            _reply_to = None
        _date = reader.tgread_date()
        _message = reader.tgread_string()
        if flags & 512:
            _media = reader.tgread_object()
        else:
            _media = None
        if flags & 64:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        if flags & 128:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 1024:
            _views = reader.read_int()
        else:
            _views = None
        if flags & 1024:
            _forwards = reader.read_int()
        else:
            _forwards = None
        if flags & 8388608:
            _replies = reader.tgread_object()
        else:
            _replies = None
        if flags & 32768:
            _edit_date = reader.tgread_date()
        else:
            _edit_date = None
        if flags & 65536:
            _post_author = reader.tgread_string()
        else:
            _post_author = None
        if flags & 131072:
            _grouped_id = reader.read_long()
        else:
            _grouped_id = None
        if flags & 1048576:
            _reactions = reader.tgread_object()
        else:
            _reactions = None
        if flags & 4194304:
            reader.read_int()
            _restriction_reason = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _restriction_reason.append(_x)

        else:
            _restriction_reason = None
        if flags & 33554432:
            _ttl_period = reader.read_int()
        else:
            _ttl_period = None
        return cls(id=_id, peer_id=_peer_id, date=_date, message=_message, out=_out, mentioned=_mentioned, media_unread=_media_unread, silent=_silent, post=_post, from_scheduled=_from_scheduled, legacy=_legacy, edit_hide=_edit_hide, pinned=_pinned, noforwards=_noforwards, from_id=_from_id, fwd_from=_fwd_from, via_bot_id=_via_bot_id, reply_to=_reply_to, media=_media, reply_markup=_reply_markup, entities=_entities, views=_views, forwards=_forwards, replies=_replies, edit_date=_edit_date, post_author=_post_author, grouped_id=_grouped_id, reactions=_reactions, restriction_reason=_restriction_reason, ttl_period=_ttl_period)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionBotAllowed(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('domain',)
    CONSTRUCTOR_ID = 0xabe9affe
    SUBCLASS_OF_ID = 0x8680d126

    domain: str
    def __init__(self, domain: str):
        object.__setattr__(self, 'domain', domain)

    def _bytes(self):
        return b''.join((
            b'\xfe\xaf\xe9\xab',
            self._serialize_bytes(self.domain),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _domain = reader.tgread_string()
        return cls(domain=_domain)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionChannelCreate(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('title',)
    CONSTRUCTOR_ID = 0x95d2ac92
    SUBCLASS_OF_ID = 0x8680d126

    title: str
    def __init__(self, title: str):
        object.__setattr__(self, 'title', title)

    def _bytes(self):
        return b''.join((
            b'\x92\xac\xd2\x95',
            self._serialize_bytes(self.title),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _title = reader.tgread_string()
        return cls(title=_title)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionChannelMigrateFrom(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('title', 'chat_id',)
    CONSTRUCTOR_ID = 0xea3948e9
    SUBCLASS_OF_ID = 0x8680d126

    title: str
    chat_id: int
    def __init__(self, title: str, chat_id: int):
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'chat_id', chat_id)

    def _bytes(self):
        return b''.join((
            b'\xe9H9\xea',
            self._serialize_bytes(self.title),
            struct.pack('<q', self.chat_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _title = reader.tgread_string()
        _chat_id = reader.read_long()
        return cls(title=_title, chat_id=_chat_id)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionChatAddUser(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('users',)
    CONSTRUCTOR_ID = 0x15cefd00
    SUBCLASS_OF_ID = 0x8680d126

    users: List[int]
    def __init__(self, users: List[int]):
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\x00\xfd\xce\x15',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(struct.pack('<q', x) for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _users.append(_x)

        return cls(users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionChatCreate(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('title', 'users',)
    CONSTRUCTOR_ID = 0xbd47cbad
    SUBCLASS_OF_ID = 0x8680d126

    title: str
    users: List[int]
    def __init__(self, title: str, users: List[int]):
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\xad\xcbG\xbd',
            self._serialize_bytes(self.title),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(struct.pack('<q', x) for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _title = reader.tgread_string()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _users.append(_x)

        return cls(title=_title, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionChatDeletePhoto(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x95e3fbef
    SUBCLASS_OF_ID = 0x8680d126

    def _bytes(self):
        return b''.join((
            b'\xef\xfb\xe3\x95',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionChatDeleteUser(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('user_id',)
    CONSTRUCTOR_ID = 0xa43f30cc
    SUBCLASS_OF_ID = 0x8680d126

    user_id: int
    def __init__(self, user_id: int):
        object.__setattr__(self, 'user_id', user_id)

    def _bytes(self):
        return b''.join((
            b'\xcc0?\xa4',
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        return cls(user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionChatEditPhoto(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('photo',)
    CONSTRUCTOR_ID = 0x7fcb13a8
    SUBCLASS_OF_ID = 0x8680d126

    photo: 'TypePhoto'
    def __init__(self, photo: 'TypePhoto'):
        object.__setattr__(self, 'photo', photo)

    def _bytes(self):
        return b''.join((
            b'\xa8\x13\xcb\x7f',
            self.photo._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _photo = reader.tgread_object()
        return cls(photo=_photo)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionChatEditTitle(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('title',)
    CONSTRUCTOR_ID = 0xb5a1ce5a
    SUBCLASS_OF_ID = 0x8680d126

    title: str
    def __init__(self, title: str):
        object.__setattr__(self, 'title', title)

    def _bytes(self):
        return b''.join((
            b'Z\xce\xa1\xb5',
            self._serialize_bytes(self.title),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _title = reader.tgread_string()
        return cls(title=_title)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionChatJoinedByLink(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('inviter_id',)
    CONSTRUCTOR_ID = 0x31224c3
    SUBCLASS_OF_ID = 0x8680d126

    inviter_id: int
    def __init__(self, inviter_id: int):
        object.__setattr__(self, 'inviter_id', inviter_id)

    def _bytes(self):
        return b''.join((
            b'\xc3$\x12\x03',
            struct.pack('<q', self.inviter_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _inviter_id = reader.read_long()
        return cls(inviter_id=_inviter_id)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionChatJoinedByRequest(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xebbca3cb
    SUBCLASS_OF_ID = 0x8680d126

    def _bytes(self):
        return b''.join((
            b'\xcb\xa3\xbc\xeb',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionChatMigrateTo(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('channel_id',)
    CONSTRUCTOR_ID = 0xe1037f92
    SUBCLASS_OF_ID = 0x8680d126

    channel_id: int
    def __init__(self, channel_id: int):
        object.__setattr__(self, 'channel_id', channel_id)

    def _bytes(self):
        return b''.join((
            b'\x92\x7f\x03\xe1',
            struct.pack('<q', self.channel_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel_id = reader.read_long()
        return cls(channel_id=_channel_id)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionContactSignUp(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xf3f25f76
    SUBCLASS_OF_ID = 0x8680d126

    def _bytes(self):
        return b''.join((
            b'v_\xf2\xf3',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionCustomAction(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('message',)
    CONSTRUCTOR_ID = 0xfae69f56
    SUBCLASS_OF_ID = 0x8680d126

    message: str
    def __init__(self, message: str):
        object.__setattr__(self, 'message', message)

    def _bytes(self):
        return b''.join((
            b'V\x9f\xe6\xfa',
            self._serialize_bytes(self.message),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _message = reader.tgread_string()
        return cls(message=_message)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionEmpty(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb6aef7b0
    SUBCLASS_OF_ID = 0x8680d126

    def _bytes(self):
        return b''.join((
            b'\xb0\xf7\xae\xb6',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionGameScore(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('game_id', 'score',)
    CONSTRUCTOR_ID = 0x92a72876
    SUBCLASS_OF_ID = 0x8680d126

    game_id: int
    score: int
    def __init__(self, game_id: int, score: int):
        object.__setattr__(self, 'game_id', game_id)
        object.__setattr__(self, 'score', score)

    def _bytes(self):
        return b''.join((
            b'v(\xa7\x92',
            struct.pack('<q', self.game_id),
            struct.pack('<i', self.score),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _game_id = reader.read_long()
        _score = reader.read_int()
        return cls(game_id=_game_id, score=_score)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionGeoProximityReached(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('from_id', 'to_id', 'distance',)
    CONSTRUCTOR_ID = 0x98e0d697
    SUBCLASS_OF_ID = 0x8680d126

    from_id: 'TypePeer'
    to_id: 'TypePeer'
    distance: int
    def __init__(self, from_id: 'TypePeer', to_id: 'TypePeer', distance: int):
        object.__setattr__(self, 'from_id', from_id)
        object.__setattr__(self, 'to_id', to_id)
        object.__setattr__(self, 'distance', distance)

    def _bytes(self):
        return b''.join((
            b'\x97\xd6\xe0\x98',
            self.from_id._bytes(),
            self.to_id._bytes(),
            struct.pack('<i', self.distance),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _from_id = reader.tgread_object()
        _to_id = reader.tgread_object()
        _distance = reader.read_int()
        return cls(from_id=_from_id, to_id=_to_id, distance=_distance)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionGroupCall(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('call', 'duration',)
    CONSTRUCTOR_ID = 0x7a0d7f42
    SUBCLASS_OF_ID = 0x8680d126

    call: 'TypeInputGroupCall'
    duration: Optional[int]
    def __init__(self, call: 'TypeInputGroupCall', duration: Optional[int]=None):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'duration', duration)

    def _bytes(self):
        return b''.join((
            b'B\x7f\rz',
            struct.pack('<I', (0 if self.duration is None or self.duration is False else 1)),
            self.call._bytes(),
            b'' if self.duration is None or self.duration is False else (struct.pack('<i', self.duration)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _call = reader.tgread_object()
        if flags & 1:
            _duration = reader.read_int()
        else:
            _duration = None
        return cls(call=_call, duration=_duration)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionGroupCallScheduled(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('call', 'schedule_date',)
    CONSTRUCTOR_ID = 0xb3a07661
    SUBCLASS_OF_ID = 0x8680d126

    call: 'TypeInputGroupCall'
    schedule_date: Optional[datetime]
    def __init__(self, call: 'TypeInputGroupCall', schedule_date: Optional[datetime]):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'schedule_date', schedule_date)

    def _bytes(self):
        return b''.join((
            b'av\xa0\xb3',
            self.call._bytes(),
            self._serialize_datetime(self.schedule_date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        _schedule_date = reader.tgread_date()
        return cls(call=_call, schedule_date=_schedule_date)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionHistoryClear(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9fbab604
    SUBCLASS_OF_ID = 0x8680d126

    def _bytes(self):
        return b''.join((
            b'\x04\xb6\xba\x9f',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionInviteToGroupCall(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('call', 'users',)
    CONSTRUCTOR_ID = 0x502f92f7
    SUBCLASS_OF_ID = 0x8680d126

    call: 'TypeInputGroupCall'
    users: List[int]
    def __init__(self, call: 'TypeInputGroupCall', users: List[int]):
        object.__setattr__(self, 'call', call)
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\xf7\x92/P',
            self.call._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(struct.pack('<q', x) for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _call = reader.tgread_object()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _users.append(_x)

        return cls(call=_call, users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionPaymentSent(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('currency', 'total_amount',)
    CONSTRUCTOR_ID = 0x40699cd0
    SUBCLASS_OF_ID = 0x8680d126

    currency: str
    total_amount: int
    def __init__(self, currency: str, total_amount: int):
        object.__setattr__(self, 'currency', currency)
        object.__setattr__(self, 'total_amount', total_amount)

    def _bytes(self):
        return b''.join((
            b'\xd0\x9ci@',
            self._serialize_bytes(self.currency),
            struct.pack('<q', self.total_amount),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _currency = reader.tgread_string()
        _total_amount = reader.read_long()
        return cls(currency=_currency, total_amount=_total_amount)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionPaymentSentMe(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('currency', 'total_amount', 'payload', 'charge', 'info', 'shipping_option_id',)
    CONSTRUCTOR_ID = 0x8f31b327
    SUBCLASS_OF_ID = 0x8680d126

    currency: str
    total_amount: int
    payload: bytes
    charge: 'TypePaymentCharge'
    info: Optional['TypePaymentRequestedInfo']
    shipping_option_id: Optional[str]
    def __init__(self, currency: str, total_amount: int, payload: bytes, charge: 'TypePaymentCharge', info: Optional['TypePaymentRequestedInfo']=None, shipping_option_id: Optional[str]=None):
        object.__setattr__(self, 'currency', currency)
        object.__setattr__(self, 'total_amount', total_amount)
        object.__setattr__(self, 'payload', payload)
        object.__setattr__(self, 'charge', charge)
        object.__setattr__(self, 'info', info)
        object.__setattr__(self, 'shipping_option_id', shipping_option_id)

    def _bytes(self):
        return b''.join((
            b"'\xb31\x8f",
            struct.pack('<I', (0 if self.info is None or self.info is False else 1) | (0 if self.shipping_option_id is None or self.shipping_option_id is False else 2)),
            self._serialize_bytes(self.currency),
            struct.pack('<q', self.total_amount),
            self._serialize_bytes(self.payload),
            b'' if self.info is None or self.info is False else (self.info._bytes()),
            b'' if self.shipping_option_id is None or self.shipping_option_id is False else (self._serialize_bytes(self.shipping_option_id)),
            self.charge._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _currency = reader.tgread_string()
        _total_amount = reader.read_long()
        _payload = reader.tgread_bytes()
        if flags & 1:
            _info = reader.tgread_object()
        else:
            _info = None
        if flags & 2:
            _shipping_option_id = reader.tgread_string()
        else:
            _shipping_option_id = None
        _charge = reader.tgread_object()
        return cls(currency=_currency, total_amount=_total_amount, payload=_payload, charge=_charge, info=_info, shipping_option_id=_shipping_option_id)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionPhoneCall(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('call_id', 'video', 'reason', 'duration',)
    CONSTRUCTOR_ID = 0x80e11a7f
    SUBCLASS_OF_ID = 0x8680d126

    call_id: int
    video: Optional[bool]
    reason: Optional['TypePhoneCallDiscardReason']
    duration: Optional[int]
    def __init__(self, call_id: int, video: Optional[bool]=None, reason: Optional['TypePhoneCallDiscardReason']=None, duration: Optional[int]=None):
        object.__setattr__(self, 'call_id', call_id)
        object.__setattr__(self, 'video', video)
        object.__setattr__(self, 'reason', reason)
        object.__setattr__(self, 'duration', duration)

    def _bytes(self):
        return b''.join((
            b'\x7f\x1a\xe1\x80',
            struct.pack('<I', (0 if self.video is None or self.video is False else 4) | (0 if self.reason is None or self.reason is False else 1) | (0 if self.duration is None or self.duration is False else 2)),
            struct.pack('<q', self.call_id),
            b'' if self.reason is None or self.reason is False else (self.reason._bytes()),
            b'' if self.duration is None or self.duration is False else (struct.pack('<i', self.duration)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 4)
        _call_id = reader.read_long()
        if flags & 1:
            _reason = reader.tgread_object()
        else:
            _reason = None
        if flags & 2:
            _duration = reader.read_int()
        else:
            _duration = None
        return cls(call_id=_call_id, video=_video, reason=_reason, duration=_duration)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionPinMessage(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x94bd38ed
    SUBCLASS_OF_ID = 0x8680d126

    def _bytes(self):
        return b''.join((
            b'\xed8\xbd\x94',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionScreenshotTaken(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x4792929b
    SUBCLASS_OF_ID = 0x8680d126

    def _bytes(self):
        return b''.join((
            b'\x9b\x92\x92G',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionSecureValuesSent(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('types',)
    CONSTRUCTOR_ID = 0xd95c6154
    SUBCLASS_OF_ID = 0x8680d126

    types: List['TypeSecureValueType']
    def __init__(self, types: List['TypeSecureValueType']):
        object.__setattr__(self, 'types', types)

    def _bytes(self):
        return b''.join((
            b'Ta\\\xd9',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.types)),b''.join(x._bytes() for x in self.types),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _types = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _types.append(_x)

        return cls(types=_types)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionSecureValuesSentMe(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('values', 'credentials',)
    CONSTRUCTOR_ID = 0x1b287353
    SUBCLASS_OF_ID = 0x8680d126

    values: List['TypeSecureValue']
    credentials: 'TypeSecureCredentialsEncrypted'
    def __init__(self, values: List['TypeSecureValue'], credentials: 'TypeSecureCredentialsEncrypted'):
        object.__setattr__(self, 'values', values)
        object.__setattr__(self, 'credentials', credentials)

    def _bytes(self):
        return b''.join((
            b'Ss(\x1b',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.values)),b''.join(x._bytes() for x in self.values),
            self.credentials._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _values = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _values.append(_x)

        _credentials = reader.tgread_object()
        return cls(values=_values, credentials=_credentials)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionSetChatTheme(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('emoticon',)
    CONSTRUCTOR_ID = 0xaa786345
    SUBCLASS_OF_ID = 0x8680d126

    emoticon: str
    def __init__(self, emoticon: str):
        object.__setattr__(self, 'emoticon', emoticon)

    def _bytes(self):
        return b''.join((
            b'Ecx\xaa',
            self._serialize_bytes(self.emoticon),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _emoticon = reader.tgread_string()
        return cls(emoticon=_emoticon)


@dataclasses.dataclass(init=False, frozen=True)
class MessageActionSetMessagesTTL(TLObject):
    """
    Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest.
    """
    __slots__ = ('period',)
    CONSTRUCTOR_ID = 0xaa1afbfd
    SUBCLASS_OF_ID = 0x8680d126

    period: int
    def __init__(self, period: int):
        object.__setattr__(self, 'period', period)

    def _bytes(self):
        return b''.join((
            b'\xfd\xfb\x1a\xaa',
            struct.pack('<i', self.period),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _period = reader.read_int()
        return cls(period=_period)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEmpty(TLObject):
    """
    Constructor for Message: Instance of either MessageEmpty, Message, MessageService.
    """
    __slots__ = ('id', 'peer_id',)
    CONSTRUCTOR_ID = 0x90a6ca84
    SUBCLASS_OF_ID = 0x790009e3

    id: int
    peer_id: Optional['TypePeer']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, peer_id: Optional['TypePeer']=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'peer_id', peer_id)

    def _bytes(self):
        return b''.join((
            b'\x84\xca\xa6\x90',
            struct.pack('<I', (0 if self.peer_id is None or self.peer_id is False else 1)),
            struct.pack('<i', self.id),
            b'' if self.peer_id is None or self.peer_id is False else (self.peer_id._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.read_int()
        if flags & 1:
            _peer_id = reader.tgread_object()
        else:
            _peer_id = None
        return cls(id=_id, peer_id=_peer_id)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityBankCard(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0x761e6af4
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\xf4j\x1ev',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityBlockquote(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0x20df5d0
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\xd0\xf5\r\x02',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityBold(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0xbd610bc9
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\xc9\x0ba\xbd',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityBotCommand(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0x6cef8ac7
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\xc7\x8a\xefl',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityCashtag(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0x4c4e743f
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'?tNL',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityCode(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0x28a20571
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'q\x05\xa2(',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityEmail(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0x64e475c2
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\xc2u\xe4d',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityHashtag(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0x6f635b0d
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\r[co',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityItalic(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0x826f8b60
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'`\x8bo\x82',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityMention(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0xfa04579d
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\x9dW\x04\xfa',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityMentionName(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length', 'user_id',)
    CONSTRUCTOR_ID = 0xdc7b1140
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    user_id: int
    def __init__(self, offset: int, length: int, user_id: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)
        object.__setattr__(self, 'user_id', user_id)

    def _bytes(self):
        return b''.join((
            b'@\x11{\xdc',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _user_id = reader.read_long()
        return cls(offset=_offset, length=_length, user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityPhone(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0x9b69e34b
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'K\xe3i\x9b',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityPre(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length', 'language',)
    CONSTRUCTOR_ID = 0x73924be0
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    language: str
    def __init__(self, offset: int, length: int, language: str):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)
        object.__setattr__(self, 'language', language)

    def _bytes(self):
        return b''.join((
            b'\xe0K\x92s',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            self._serialize_bytes(self.language),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _language = reader.tgread_string()
        return cls(offset=_offset, length=_length, language=_language)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntitySpoiler(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0x32ca960f
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\x0f\x96\xca2',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityStrike(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0xbf0693d4
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\xd4\x93\x06\xbf',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityTextUrl(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length', 'url',)
    CONSTRUCTOR_ID = 0x76a6d327
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    url: str
    def __init__(self, offset: int, length: int, url: str):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)
        object.__setattr__(self, 'url', url)

    def _bytes(self):
        return b''.join((
            b"'\xd3\xa6v",
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            self._serialize_bytes(self.url),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _url = reader.tgread_string()
        return cls(offset=_offset, length=_length, url=_url)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityUnderline(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0x9c4e7e8b
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\x8b~N\x9c',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityUnknown(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0xbb92ba95
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\x95\xba\x92\xbb',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageEntityUrl(TLObject):
    """
    Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote, MessageEntityBankCard, MessageEntitySpoiler.
    """
    __slots__ = ('offset', 'length',)
    CONSTRUCTOR_ID = 0x6ed02538
    SUBCLASS_OF_ID = 0xcf6419dc

    offset: int
    length: int
    def __init__(self, offset: int, length: int):
        object.__setattr__(self, 'offset', offset)
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'8%\xd0n',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class MessageFwdHeader(TLObject):
    """
    Constructor for MessageFwdHeader: Instance of MessageFwdHeader.
    """
    __slots__ = ('date', 'imported', 'from_id', 'from_name', 'channel_post', 'post_author', 'saved_from_peer', 'saved_from_msg_id', 'psa_type',)
    CONSTRUCTOR_ID = 0x5f777dce
    SUBCLASS_OF_ID = 0x7a286804

    date: Optional[datetime]
    imported: Optional[bool]
    from_id: Optional['TypePeer']
    from_name: Optional[str]
    channel_post: Optional[int]
    post_author: Optional[str]
    saved_from_peer: Optional['TypePeer']
    saved_from_msg_id: Optional[int]
    psa_type: Optional[str]
    def __init__(self, date: Optional[datetime], imported: Optional[bool]=None, from_id: Optional['TypePeer']=None, from_name: Optional[str]=None, channel_post: Optional[int]=None, post_author: Optional[str]=None, saved_from_peer: Optional['TypePeer']=None, saved_from_msg_id: Optional[int]=None, psa_type: Optional[str]=None):
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'imported', imported)
        object.__setattr__(self, 'from_id', from_id)
        object.__setattr__(self, 'from_name', from_name)
        object.__setattr__(self, 'channel_post', channel_post)
        object.__setattr__(self, 'post_author', post_author)
        object.__setattr__(self, 'saved_from_peer', saved_from_peer)
        object.__setattr__(self, 'saved_from_msg_id', saved_from_msg_id)
        object.__setattr__(self, 'psa_type', psa_type)

    def _bytes(self):
        assert ((self.saved_from_peer or self.saved_from_peer is not None) and (self.saved_from_msg_id or self.saved_from_msg_id is not None)) or ((self.saved_from_peer is None or self.saved_from_peer is False) and (self.saved_from_msg_id is None or self.saved_from_msg_id is False)), 'saved_from_peer, saved_from_msg_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xce}w_',
            struct.pack('<I', (0 if self.imported is None or self.imported is False else 128) | (0 if self.from_id is None or self.from_id is False else 1) | (0 if self.from_name is None or self.from_name is False else 32) | (0 if self.channel_post is None or self.channel_post is False else 4) | (0 if self.post_author is None or self.post_author is False else 8) | (0 if self.saved_from_peer is None or self.saved_from_peer is False else 16) | (0 if self.saved_from_msg_id is None or self.saved_from_msg_id is False else 16) | (0 if self.psa_type is None or self.psa_type is False else 64)),
            b'' if self.from_id is None or self.from_id is False else (self.from_id._bytes()),
            b'' if self.from_name is None or self.from_name is False else (self._serialize_bytes(self.from_name)),
            self._serialize_datetime(self.date),
            b'' if self.channel_post is None or self.channel_post is False else (struct.pack('<i', self.channel_post)),
            b'' if self.post_author is None or self.post_author is False else (self._serialize_bytes(self.post_author)),
            b'' if self.saved_from_peer is None or self.saved_from_peer is False else (self.saved_from_peer._bytes()),
            b'' if self.saved_from_msg_id is None or self.saved_from_msg_id is False else (struct.pack('<i', self.saved_from_msg_id)),
            b'' if self.psa_type is None or self.psa_type is False else (self._serialize_bytes(self.psa_type)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _imported = bool(flags & 128)
        if flags & 1:
            _from_id = reader.tgread_object()
        else:
            _from_id = None
        if flags & 32:
            _from_name = reader.tgread_string()
        else:
            _from_name = None
        _date = reader.tgread_date()
        if flags & 4:
            _channel_post = reader.read_int()
        else:
            _channel_post = None
        if flags & 8:
            _post_author = reader.tgread_string()
        else:
            _post_author = None
        if flags & 16:
            _saved_from_peer = reader.tgread_object()
        else:
            _saved_from_peer = None
        if flags & 16:
            _saved_from_msg_id = reader.read_int()
        else:
            _saved_from_msg_id = None
        if flags & 64:
            _psa_type = reader.tgread_string()
        else:
            _psa_type = None
        return cls(date=_date, imported=_imported, from_id=_from_id, from_name=_from_name, channel_post=_channel_post, post_author=_post_author, saved_from_peer=_saved_from_peer, saved_from_msg_id=_saved_from_msg_id, psa_type=_psa_type)


@dataclasses.dataclass(init=False, frozen=True)
class MessageInteractionCounters(TLObject):
    """
    Constructor for MessageInteractionCounters: Instance of MessageInteractionCounters.
    """
    __slots__ = ('msg_id', 'views', 'forwards',)
    CONSTRUCTOR_ID = 0xad4fc9bd
    SUBCLASS_OF_ID = 0x2638b720

    msg_id: int
    views: int
    forwards: int
    def __init__(self, msg_id: int, views: int, forwards: int):
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'views', views)
        object.__setattr__(self, 'forwards', forwards)

    def _bytes(self):
        return b''.join((
            b'\xbd\xc9O\xad',
            struct.pack('<i', self.msg_id),
            struct.pack('<i', self.views),
            struct.pack('<i', self.forwards),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _msg_id = reader.read_int()
        _views = reader.read_int()
        _forwards = reader.read_int()
        return cls(msg_id=_msg_id, views=_views, forwards=_forwards)


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaContact(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('phone_number', 'first_name', 'last_name', 'vcard', 'user_id',)
    CONSTRUCTOR_ID = 0x70322949
    SUBCLASS_OF_ID = 0x476cbe32

    phone_number: str
    first_name: str
    last_name: str
    vcard: str
    user_id: int
    def __init__(self, phone_number: str, first_name: str, last_name: str, vcard: str, user_id: int):
        object.__setattr__(self, 'phone_number', phone_number)
        object.__setattr__(self, 'first_name', first_name)
        object.__setattr__(self, 'last_name', last_name)
        object.__setattr__(self, 'vcard', vcard)
        object.__setattr__(self, 'user_id', user_id)

    def _bytes(self):
        return b''.join((
            b'I)2p',
            self._serialize_bytes(self.phone_number),
            self._serialize_bytes(self.first_name),
            self._serialize_bytes(self.last_name),
            self._serialize_bytes(self.vcard),
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _vcard = reader.tgread_string()
        _user_id = reader.read_long()
        return cls(phone_number=_phone_number, first_name=_first_name, last_name=_last_name, vcard=_vcard, user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaDice(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('value', 'emoticon',)
    CONSTRUCTOR_ID = 0x3f7ee58b
    SUBCLASS_OF_ID = 0x476cbe32

    value: int
    emoticon: str
    def __init__(self, value: int, emoticon: str):
        object.__setattr__(self, 'value', value)
        object.__setattr__(self, 'emoticon', emoticon)

    def _bytes(self):
        return b''.join((
            b'\x8b\xe5~?',
            struct.pack('<i', self.value),
            self._serialize_bytes(self.emoticon),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _value = reader.read_int()
        _emoticon = reader.tgread_string()
        return cls(value=_value, emoticon=_emoticon)


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaDocument(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('document', 'ttl_seconds',)
    CONSTRUCTOR_ID = 0x9cb070d7
    SUBCLASS_OF_ID = 0x476cbe32

    document: Optional['TypeDocument']
    ttl_seconds: Optional[int]
    def __init__(self, document: Optional['TypeDocument']=None, ttl_seconds: Optional[int]=None):
        object.__setattr__(self, 'document', document)
        object.__setattr__(self, 'ttl_seconds', ttl_seconds)

    def _bytes(self):
        return b''.join((
            b'\xd7p\xb0\x9c',
            struct.pack('<I', (0 if self.document is None or self.document is False else 1) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 4)),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 4:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(document=_document, ttl_seconds=_ttl_seconds)


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaEmpty(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x3ded6320
    SUBCLASS_OF_ID = 0x476cbe32

    def _bytes(self):
        return b''.join((
            b' c\xed=',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaGame(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('game',)
    CONSTRUCTOR_ID = 0xfdb19008
    SUBCLASS_OF_ID = 0x476cbe32

    game: 'TypeGame'
    def __init__(self, game: 'TypeGame'):
        object.__setattr__(self, 'game', game)

    def _bytes(self):
        return b''.join((
            b'\x08\x90\xb1\xfd',
            self.game._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _game = reader.tgread_object()
        return cls(game=_game)


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaGeo(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('geo',)
    CONSTRUCTOR_ID = 0x56e0d474
    SUBCLASS_OF_ID = 0x476cbe32

    geo: 'TypeGeoPoint'
    def __init__(self, geo: 'TypeGeoPoint'):
        object.__setattr__(self, 'geo', geo)

    def _bytes(self):
        return b''.join((
            b't\xd4\xe0V',
            self.geo._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _geo = reader.tgread_object()
        return cls(geo=_geo)


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaGeoLive(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('geo', 'period', 'heading', 'proximity_notification_radius',)
    CONSTRUCTOR_ID = 0xb940c666
    SUBCLASS_OF_ID = 0x476cbe32

    geo: 'TypeGeoPoint'
    period: int
    heading: Optional[int]
    proximity_notification_radius: Optional[int]
    def __init__(self, geo: 'TypeGeoPoint', period: int, heading: Optional[int]=None, proximity_notification_radius: Optional[int]=None):
        object.__setattr__(self, 'geo', geo)
        object.__setattr__(self, 'period', period)
        object.__setattr__(self, 'heading', heading)
        object.__setattr__(self, 'proximity_notification_radius', proximity_notification_radius)

    def _bytes(self):
        return b''.join((
            b'f\xc6@\xb9',
            struct.pack('<I', (0 if self.heading is None or self.heading is False else 1) | (0 if self.proximity_notification_radius is None or self.proximity_notification_radius is False else 2)),
            self.geo._bytes(),
            b'' if self.heading is None or self.heading is False else (struct.pack('<i', self.heading)),
            struct.pack('<i', self.period),
            b'' if self.proximity_notification_radius is None or self.proximity_notification_radius is False else (struct.pack('<i', self.proximity_notification_radius)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _geo = reader.tgread_object()
        if flags & 1:
            _heading = reader.read_int()
        else:
            _heading = None
        _period = reader.read_int()
        if flags & 2:
            _proximity_notification_radius = reader.read_int()
        else:
            _proximity_notification_radius = None
        return cls(geo=_geo, period=_period, heading=_heading, proximity_notification_radius=_proximity_notification_radius)


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaInvoice(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('title', 'description', 'currency', 'total_amount', 'start_param', 'shipping_address_requested', 'test', 'photo', 'receipt_msg_id',)
    CONSTRUCTOR_ID = 0x84551347
    SUBCLASS_OF_ID = 0x476cbe32

    title: str
    description: str
    currency: str
    total_amount: int
    start_param: str
    shipping_address_requested: Optional[bool]
    test: Optional[bool]
    photo: Optional['TypeWebDocument']
    receipt_msg_id: Optional[int]
    def __init__(self, title: str, description: str, currency: str, total_amount: int, start_param: str, shipping_address_requested: Optional[bool]=None, test: Optional[bool]=None, photo: Optional['TypeWebDocument']=None, receipt_msg_id: Optional[int]=None):
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'description', description)
        object.__setattr__(self, 'currency', currency)
        object.__setattr__(self, 'total_amount', total_amount)
        object.__setattr__(self, 'start_param', start_param)
        object.__setattr__(self, 'shipping_address_requested', shipping_address_requested)
        object.__setattr__(self, 'test', test)
        object.__setattr__(self, 'photo', photo)
        object.__setattr__(self, 'receipt_msg_id', receipt_msg_id)

    def _bytes(self):
        return b''.join((
            b'G\x13U\x84',
            struct.pack('<I', (0 if self.shipping_address_requested is None or self.shipping_address_requested is False else 2) | (0 if self.test is None or self.test is False else 8) | (0 if self.photo is None or self.photo is False else 1) | (0 if self.receipt_msg_id is None or self.receipt_msg_id is False else 4)),
            self._serialize_bytes(self.title),
            self._serialize_bytes(self.description),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
            b'' if self.receipt_msg_id is None or self.receipt_msg_id is False else (struct.pack('<i', self.receipt_msg_id)),
            self._serialize_bytes(self.currency),
            struct.pack('<q', self.total_amount),
            self._serialize_bytes(self.start_param),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _shipping_address_requested = bool(flags & 2)
        _test = bool(flags & 8)
        _title = reader.tgread_string()
        _description = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        if flags & 4:
            _receipt_msg_id = reader.read_int()
        else:
            _receipt_msg_id = None
        _currency = reader.tgread_string()
        _total_amount = reader.read_long()
        _start_param = reader.tgread_string()
        return cls(title=_title, description=_description, currency=_currency, total_amount=_total_amount, start_param=_start_param, shipping_address_requested=_shipping_address_requested, test=_test, photo=_photo, receipt_msg_id=_receipt_msg_id)


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaPhoto(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('photo', 'ttl_seconds',)
    CONSTRUCTOR_ID = 0x695150d7
    SUBCLASS_OF_ID = 0x476cbe32

    photo: Optional['TypePhoto']
    ttl_seconds: Optional[int]
    def __init__(self, photo: Optional['TypePhoto']=None, ttl_seconds: Optional[int]=None):
        object.__setattr__(self, 'photo', photo)
        object.__setattr__(self, 'ttl_seconds', ttl_seconds)

    def _bytes(self):
        return b''.join((
            b'\xd7PQi',
            struct.pack('<I', (0 if self.photo is None or self.photo is False else 1) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 4)),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        if flags & 4:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(photo=_photo, ttl_seconds=_ttl_seconds)


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaPoll(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('poll', 'results',)
    CONSTRUCTOR_ID = 0x4bd6e798
    SUBCLASS_OF_ID = 0x476cbe32

    poll: 'TypePoll'
    results: 'TypePollResults'
    def __init__(self, poll: 'TypePoll', results: 'TypePollResults'):
        object.__setattr__(self, 'poll', poll)
        object.__setattr__(self, 'results', results)

    def _bytes(self):
        return b''.join((
            b'\x98\xe7\xd6K',
            self.poll._bytes(),
            self.results._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _poll = reader.tgread_object()
        _results = reader.tgread_object()
        return cls(poll=_poll, results=_results)


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaUnsupported(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9f84f49e
    SUBCLASS_OF_ID = 0x476cbe32

    def _bytes(self):
        return b''.join((
            b'\x9e\xf4\x84\x9f',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaVenue(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('geo', 'title', 'address', 'provider', 'venue_id', 'venue_type',)
    CONSTRUCTOR_ID = 0x2ec0533f
    SUBCLASS_OF_ID = 0x476cbe32

    geo: 'TypeGeoPoint'
    title: str
    address: str
    provider: str
    venue_id: str
    venue_type: str
    def __init__(self, geo: 'TypeGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str):
        object.__setattr__(self, 'geo', geo)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'address', address)
        object.__setattr__(self, 'provider', provider)
        object.__setattr__(self, 'venue_id', venue_id)
        object.__setattr__(self, 'venue_type', venue_type)

    def _bytes(self):
        return b''.join((
            b'?S\xc0.',
            self.geo._bytes(),
            self._serialize_bytes(self.title),
            self._serialize_bytes(self.address),
            self._serialize_bytes(self.provider),
            self._serialize_bytes(self.venue_id),
            self._serialize_bytes(self.venue_type),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _geo = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        return cls(geo=_geo, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type)


@dataclasses.dataclass(init=False, frozen=True)
class MessageMediaWebPage(TLObject):
    """
    Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice.
    """
    __slots__ = ('webpage',)
    CONSTRUCTOR_ID = 0xa32dd600
    SUBCLASS_OF_ID = 0x476cbe32

    webpage: 'TypeWebPage'
    def __init__(self, webpage: 'TypeWebPage'):
        object.__setattr__(self, 'webpage', webpage)

    def _bytes(self):
        return b''.join((
            b'\x00\xd6-\xa3',
            self.webpage._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _webpage = reader.tgread_object()
        return cls(webpage=_webpage)


@dataclasses.dataclass(init=False, frozen=True)
class MessagePeerReaction(TLObject):
    """
    Constructor for MessagePeerReaction: Instance of MessagePeerReaction.
    """
    __slots__ = ('peer_id', 'reaction', 'big', 'unread',)
    CONSTRUCTOR_ID = 0x51b67eff
    SUBCLASS_OF_ID = 0xaf73a2a5

    peer_id: 'TypePeer'
    reaction: str
    big: Optional[bool]
    unread: Optional[bool]
    def __init__(self, peer_id: 'TypePeer', reaction: str, big: Optional[bool]=None, unread: Optional[bool]=None):
        object.__setattr__(self, 'peer_id', peer_id)
        object.__setattr__(self, 'reaction', reaction)
        object.__setattr__(self, 'big', big)
        object.__setattr__(self, 'unread', unread)

    def _bytes(self):
        return b''.join((
            b'\xff~\xb6Q',
            struct.pack('<I', (0 if self.big is None or self.big is False else 1) | (0 if self.unread is None or self.unread is False else 2)),
            self.peer_id._bytes(),
            self._serialize_bytes(self.reaction),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _big = bool(flags & 1)
        _unread = bool(flags & 2)
        _peer_id = reader.tgread_object()
        _reaction = reader.tgread_string()
        return cls(peer_id=_peer_id, reaction=_reaction, big=_big, unread=_unread)


@dataclasses.dataclass(init=False, frozen=True)
class MessageRange(TLObject):
    """
    Constructor for MessageRange: Instance of MessageRange.
    """
    __slots__ = ('min_id', 'max_id',)
    CONSTRUCTOR_ID = 0xae30253
    SUBCLASS_OF_ID = 0xbec74577

    min_id: int
    max_id: int
    def __init__(self, min_id: int, max_id: int):
        object.__setattr__(self, 'min_id', min_id)
        object.__setattr__(self, 'max_id', max_id)

    def _bytes(self):
        return b''.join((
            b'S\x02\xe3\n',
            struct.pack('<i', self.min_id),
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _min_id = reader.read_int()
        _max_id = reader.read_int()
        return cls(min_id=_min_id, max_id=_max_id)


@dataclasses.dataclass(init=False, frozen=True)
class MessageReactions(TLObject):
    """
    Constructor for MessageReactions: Instance of MessageReactions.
    """
    __slots__ = ('results', 'min', 'can_see_list', 'recent_reactions',)
    CONSTRUCTOR_ID = 0x4f2b9479
    SUBCLASS_OF_ID = 0x8a5b071c

    results: List['TypeReactionCount']
    min: Optional[bool]
    can_see_list: Optional[bool]
    recent_reactions: Optional[List['TypeMessagePeerReaction']]
    # noinspection PyShadowingBuiltins
    def __init__(self, results: List['TypeReactionCount'], min: Optional[bool]=None, can_see_list: Optional[bool]=None, recent_reactions: Optional[List['TypeMessagePeerReaction']]=None):
        object.__setattr__(self, 'results', results)
        object.__setattr__(self, 'min', min)
        object.__setattr__(self, 'can_see_list', can_see_list)
        object.__setattr__(self, 'recent_reactions', recent_reactions)

    def _bytes(self):
        return b''.join((
            b'y\x94+O',
            struct.pack('<I', (0 if self.min is None or self.min is False else 1) | (0 if self.can_see_list is None or self.can_see_list is False else 4) | (0 if self.recent_reactions is None or self.recent_reactions is False else 2)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.results)),b''.join(x._bytes() for x in self.results),
            b'' if self.recent_reactions is None or self.recent_reactions is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.recent_reactions)),b''.join(x._bytes() for x in self.recent_reactions))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _min = bool(flags & 1)
        _can_see_list = bool(flags & 4)
        reader.read_int()
        _results = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _results.append(_x)

        if flags & 2:
            reader.read_int()
            _recent_reactions = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _recent_reactions.append(_x)

        else:
            _recent_reactions = None
        return cls(results=_results, min=_min, can_see_list=_can_see_list, recent_reactions=_recent_reactions)


@dataclasses.dataclass(init=False, frozen=True)
class MessageReplies(TLObject):
    """
    Constructor for MessageReplies: Instance of MessageReplies.
    """
    __slots__ = ('replies', 'replies_pts', 'comments', 'recent_repliers', 'channel_id', 'max_id', 'read_max_id',)
    CONSTRUCTOR_ID = 0x83d60fc2
    SUBCLASS_OF_ID = 0x6ccd5ce2

    replies: int
    replies_pts: int
    comments: Optional[bool]
    recent_repliers: Optional[List['TypePeer']]
    channel_id: Optional[int]
    max_id: Optional[int]
    read_max_id: Optional[int]
    def __init__(self, replies: int, replies_pts: int, comments: Optional[bool]=None, recent_repliers: Optional[List['TypePeer']]=None, channel_id: Optional[int]=None, max_id: Optional[int]=None, read_max_id: Optional[int]=None):
        object.__setattr__(self, 'replies', replies)
        object.__setattr__(self, 'replies_pts', replies_pts)
        object.__setattr__(self, 'comments', comments)
        object.__setattr__(self, 'recent_repliers', recent_repliers)
        object.__setattr__(self, 'channel_id', channel_id)
        object.__setattr__(self, 'max_id', max_id)
        object.__setattr__(self, 'read_max_id', read_max_id)

    def _bytes(self):
        assert ((self.comments or self.comments is not None) and (self.channel_id or self.channel_id is not None)) or ((self.comments is None or self.comments is False) and (self.channel_id is None or self.channel_id is False)), 'comments, channel_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xc2\x0f\xd6\x83',
            struct.pack('<I', (0 if self.comments is None or self.comments is False else 1) | (0 if self.recent_repliers is None or self.recent_repliers is False else 2) | (0 if self.channel_id is None or self.channel_id is False else 1) | (0 if self.max_id is None or self.max_id is False else 4) | (0 if self.read_max_id is None or self.read_max_id is False else 8)),
            struct.pack('<i', self.replies),
            struct.pack('<i', self.replies_pts),
            b'' if self.recent_repliers is None or self.recent_repliers is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.recent_repliers)),b''.join(x._bytes() for x in self.recent_repliers))),
            b'' if self.channel_id is None or self.channel_id is False else (struct.pack('<q', self.channel_id)),
            b'' if self.max_id is None or self.max_id is False else (struct.pack('<i', self.max_id)),
            b'' if self.read_max_id is None or self.read_max_id is False else (struct.pack('<i', self.read_max_id)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _comments = bool(flags & 1)
        _replies = reader.read_int()
        _replies_pts = reader.read_int()
        if flags & 2:
            reader.read_int()
            _recent_repliers = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _recent_repliers.append(_x)

        else:
            _recent_repliers = None
        if flags & 1:
            _channel_id = reader.read_long()
        else:
            _channel_id = None
        if flags & 4:
            _max_id = reader.read_int()
        else:
            _max_id = None
        if flags & 8:
            _read_max_id = reader.read_int()
        else:
            _read_max_id = None
        return cls(replies=_replies, replies_pts=_replies_pts, comments=_comments, recent_repliers=_recent_repliers, channel_id=_channel_id, max_id=_max_id, read_max_id=_read_max_id)


@dataclasses.dataclass(init=False, frozen=True)
class MessageReplyHeader(TLObject):
    """
    Constructor for MessageReplyHeader: Instance of MessageReplyHeader.
    """
    __slots__ = ('reply_to_msg_id', 'reply_to_peer_id', 'reply_to_top_id',)
    CONSTRUCTOR_ID = 0xa6d57763
    SUBCLASS_OF_ID = 0x5b4d9167

    reply_to_msg_id: int
    reply_to_peer_id: Optional['TypePeer']
    reply_to_top_id: Optional[int]
    def __init__(self, reply_to_msg_id: int, reply_to_peer_id: Optional['TypePeer']=None, reply_to_top_id: Optional[int]=None):
        object.__setattr__(self, 'reply_to_msg_id', reply_to_msg_id)
        object.__setattr__(self, 'reply_to_peer_id', reply_to_peer_id)
        object.__setattr__(self, 'reply_to_top_id', reply_to_top_id)

    def _bytes(self):
        return b''.join((
            b'cw\xd5\xa6',
            struct.pack('<I', (0 if self.reply_to_peer_id is None or self.reply_to_peer_id is False else 1) | (0 if self.reply_to_top_id is None or self.reply_to_top_id is False else 2)),
            struct.pack('<i', self.reply_to_msg_id),
            b'' if self.reply_to_peer_id is None or self.reply_to_peer_id is False else (self.reply_to_peer_id._bytes()),
            b'' if self.reply_to_top_id is None or self.reply_to_top_id is False else (struct.pack('<i', self.reply_to_top_id)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _reply_to_msg_id = reader.read_int()
        if flags & 1:
            _reply_to_peer_id = reader.tgread_object()
        else:
            _reply_to_peer_id = None
        if flags & 2:
            _reply_to_top_id = reader.read_int()
        else:
            _reply_to_top_id = None
        return cls(reply_to_msg_id=_reply_to_msg_id, reply_to_peer_id=_reply_to_peer_id, reply_to_top_id=_reply_to_top_id)


@dataclasses.dataclass(init=False, frozen=True)
class MessageService(TLObject):
    """
    Constructor for Message: Instance of either MessageEmpty, Message, MessageService.
    """
    __slots__ = ('id', 'peer_id', 'date', 'action', 'out', 'mentioned', 'media_unread', 'silent', 'post', 'legacy', 'from_id', 'reply_to', 'ttl_period',)
    CONSTRUCTOR_ID = 0x2b085862
    SUBCLASS_OF_ID = 0x790009e3

    id: int
    peer_id: 'TypePeer'
    date: Optional[datetime]
    action: 'TypeMessageAction'
    out: Optional[bool]
    mentioned: Optional[bool]
    media_unread: Optional[bool]
    silent: Optional[bool]
    post: Optional[bool]
    legacy: Optional[bool]
    from_id: Optional['TypePeer']
    reply_to: Optional['TypeMessageReplyHeader']
    ttl_period: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, peer_id: 'TypePeer', date: Optional[datetime], action: 'TypeMessageAction', out: Optional[bool]=None, mentioned: Optional[bool]=None, media_unread: Optional[bool]=None, silent: Optional[bool]=None, post: Optional[bool]=None, legacy: Optional[bool]=None, from_id: Optional['TypePeer']=None, reply_to: Optional['TypeMessageReplyHeader']=None, ttl_period: Optional[int]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'peer_id', peer_id)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'action', action)
        object.__setattr__(self, 'out', out)
        object.__setattr__(self, 'mentioned', mentioned)
        object.__setattr__(self, 'media_unread', media_unread)
        object.__setattr__(self, 'silent', silent)
        object.__setattr__(self, 'post', post)
        object.__setattr__(self, 'legacy', legacy)
        object.__setattr__(self, 'from_id', from_id)
        object.__setattr__(self, 'reply_to', reply_to)
        object.__setattr__(self, 'ttl_period', ttl_period)

    def _bytes(self):
        return b''.join((
            b'bX\x08+',
            struct.pack('<I', (0 if self.out is None or self.out is False else 2) | (0 if self.mentioned is None or self.mentioned is False else 16) | (0 if self.media_unread is None or self.media_unread is False else 32) | (0 if self.silent is None or self.silent is False else 8192) | (0 if self.post is None or self.post is False else 16384) | (0 if self.legacy is None or self.legacy is False else 524288) | (0 if self.from_id is None or self.from_id is False else 256) | (0 if self.reply_to is None or self.reply_to is False else 8) | (0 if self.ttl_period is None or self.ttl_period is False else 33554432)),
            struct.pack('<i', self.id),
            b'' if self.from_id is None or self.from_id is False else (self.from_id._bytes()),
            self.peer_id._bytes(),
            b'' if self.reply_to is None or self.reply_to is False else (self.reply_to._bytes()),
            self._serialize_datetime(self.date),
            self.action._bytes(),
            b'' if self.ttl_period is None or self.ttl_period is False else (struct.pack('<i', self.ttl_period)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _out = bool(flags & 2)
        _mentioned = bool(flags & 16)
        _media_unread = bool(flags & 32)
        _silent = bool(flags & 8192)
        _post = bool(flags & 16384)
        _legacy = bool(flags & 524288)
        _id = reader.read_int()
        if flags & 256:
            _from_id = reader.tgread_object()
        else:
            _from_id = None
        _peer_id = reader.tgread_object()
        if flags & 8:
            _reply_to = reader.tgread_object()
        else:
            _reply_to = None
        _date = reader.tgread_date()
        _action = reader.tgread_object()
        if flags & 33554432:
            _ttl_period = reader.read_int()
        else:
            _ttl_period = None
        return cls(id=_id, peer_id=_peer_id, date=_date, action=_action, out=_out, mentioned=_mentioned, media_unread=_media_unread, silent=_silent, post=_post, legacy=_legacy, from_id=_from_id, reply_to=_reply_to, ttl_period=_ttl_period)


@dataclasses.dataclass(init=False, frozen=True)
class MessageUserVote(TLObject):
    """
    Constructor for MessageUserVote: Instance of either MessageUserVote, MessageUserVoteInputOption, MessageUserVoteMultiple.
    """
    __slots__ = ('user_id', 'option', 'date',)
    CONSTRUCTOR_ID = 0x34d247b4
    SUBCLASS_OF_ID = 0xc92cd592

    user_id: int
    option: bytes
    date: Optional[datetime]
    def __init__(self, user_id: int, option: bytes, date: Optional[datetime]):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'option', option)
        object.__setattr__(self, 'date', date)

    def _bytes(self):
        return b''.join((
            b'\xb4G\xd24',
            struct.pack('<q', self.user_id),
            self._serialize_bytes(self.option),
            self._serialize_datetime(self.date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _option = reader.tgread_bytes()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, option=_option, date=_date)


@dataclasses.dataclass(init=False, frozen=True)
class MessageUserVoteInputOption(TLObject):
    """
    Constructor for MessageUserVote: Instance of either MessageUserVote, MessageUserVoteInputOption, MessageUserVoteMultiple.
    """
    __slots__ = ('user_id', 'date',)
    CONSTRUCTOR_ID = 0x3ca5b0ec
    SUBCLASS_OF_ID = 0xc92cd592

    user_id: int
    date: Optional[datetime]
    def __init__(self, user_id: int, date: Optional[datetime]):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'date', date)

    def _bytes(self):
        return b''.join((
            b'\xec\xb0\xa5<',
            struct.pack('<q', self.user_id),
            self._serialize_datetime(self.date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, date=_date)


@dataclasses.dataclass(init=False, frozen=True)
class MessageUserVoteMultiple(TLObject):
    """
    Constructor for MessageUserVote: Instance of either MessageUserVote, MessageUserVoteInputOption, MessageUserVoteMultiple.
    """
    __slots__ = ('user_id', 'options', 'date',)
    CONSTRUCTOR_ID = 0x8a65e557
    SUBCLASS_OF_ID = 0xc92cd592

    user_id: int
    options: List[bytes]
    date: Optional[datetime]
    def __init__(self, user_id: int, options: List[bytes], date: Optional[datetime]):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'options', options)
        object.__setattr__(self, 'date', date)

    def _bytes(self):
        return b''.join((
            b'W\xe5e\x8a',
            struct.pack('<q', self.user_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.options)),b''.join(self._serialize_bytes(x) for x in self.options),
            self._serialize_datetime(self.date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        reader.read_int()
        _options = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_bytes()
            _options.append(_x)

        _date = reader.tgread_date()
        return cls(user_id=_user_id, options=_options, date=_date)


@dataclasses.dataclass(init=False, frozen=True)
class MessageViews(TLObject):
    """
    Constructor for MessageViews: Instance of MessageViews.
    """
    __slots__ = ('views', 'forwards', 'replies',)
    CONSTRUCTOR_ID = 0x455b853d
    SUBCLASS_OF_ID = 0x3cb083b9

    views: Optional[int]
    forwards: Optional[int]
    replies: Optional['TypeMessageReplies']
    def __init__(self, views: Optional[int]=None, forwards: Optional[int]=None, replies: Optional['TypeMessageReplies']=None):
        object.__setattr__(self, 'views', views)
        object.__setattr__(self, 'forwards', forwards)
        object.__setattr__(self, 'replies', replies)

    def _bytes(self):
        return b''.join((
            b'=\x85[E',
            struct.pack('<I', (0 if self.views is None or self.views is False else 1) | (0 if self.forwards is None or self.forwards is False else 2) | (0 if self.replies is None or self.replies is False else 4)),
            b'' if self.views is None or self.views is False else (struct.pack('<i', self.views)),
            b'' if self.forwards is None or self.forwards is False else (struct.pack('<i', self.forwards)),
            b'' if self.replies is None or self.replies is False else (self.replies._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _views = reader.read_int()
        else:
            _views = None
        if flags & 2:
            _forwards = reader.read_int()
        else:
            _forwards = None
        if flags & 4:
            _replies = reader.tgread_object()
        else:
            _replies = None
        return cls(views=_views, forwards=_forwards, replies=_replies)


@dataclasses.dataclass(init=False, frozen=True)
class MsgDetailedInfo(TLObject):
    """
    Constructor for MsgDetailedInfo: Instance of either MsgDetailedInfo, MsgNewDetailedInfo.
    """
    __slots__ = ('msg_id', 'answer_msg_id', 'bytes', 'status',)
    CONSTRUCTOR_ID = 0x276d3ec6
    SUBCLASS_OF_ID = 0x5f32d5ee

    msg_id: int
    answer_msg_id: int
    bytes: int
    status: int
    # noinspection PyShadowingBuiltins
    def __init__(self, msg_id: int, answer_msg_id: int, bytes: int, status: int):
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'answer_msg_id', answer_msg_id)
        object.__setattr__(self, 'bytes', bytes)
        object.__setattr__(self, 'status', status)

    def _bytes(self):
        return b''.join((
            b"\xc6>m'",
            struct.pack('<q', self.msg_id),
            struct.pack('<q', self.answer_msg_id),
            struct.pack('<i', self.bytes),
            struct.pack('<i', self.status),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _msg_id = reader.read_long()
        _answer_msg_id = reader.read_long()
        _bytes = reader.read_int()
        _status = reader.read_int()
        return cls(msg_id=_msg_id, answer_msg_id=_answer_msg_id, bytes=_bytes, status=_status)


@dataclasses.dataclass(init=False, frozen=True)
class MsgNewDetailedInfo(TLObject):
    """
    Constructor for MsgDetailedInfo: Instance of either MsgDetailedInfo, MsgNewDetailedInfo.
    """
    __slots__ = ('answer_msg_id', 'bytes', 'status',)
    CONSTRUCTOR_ID = 0x809db6df
    SUBCLASS_OF_ID = 0x5f32d5ee

    answer_msg_id: int
    bytes: int
    status: int
    # noinspection PyShadowingBuiltins
    def __init__(self, answer_msg_id: int, bytes: int, status: int):
        object.__setattr__(self, 'answer_msg_id', answer_msg_id)
        object.__setattr__(self, 'bytes', bytes)
        object.__setattr__(self, 'status', status)

    def _bytes(self):
        return b''.join((
            b'\xdf\xb6\x9d\x80',
            struct.pack('<q', self.answer_msg_id),
            struct.pack('<i', self.bytes),
            struct.pack('<i', self.status),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _answer_msg_id = reader.read_long()
        _bytes = reader.read_int()
        _status = reader.read_int()
        return cls(answer_msg_id=_answer_msg_id, bytes=_bytes, status=_status)


@dataclasses.dataclass(init=False, frozen=True)
class MsgResendReq(TLObject):
    """
    Constructor for MsgResendReq: Instance of MsgResendReq.
    """
    __slots__ = ('msg_ids',)
    CONSTRUCTOR_ID = 0x7d861a08
    SUBCLASS_OF_ID = 0x2024514

    msg_ids: List[int]
    def __init__(self, msg_ids: List[int]):
        object.__setattr__(self, 'msg_ids', msg_ids)

    def _bytes(self):
        return b''.join((
            b'\x08\x1a\x86}',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.msg_ids)),b''.join(struct.pack('<q', x) for x in self.msg_ids),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _msg_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _msg_ids.append(_x)

        return cls(msg_ids=_msg_ids)


@dataclasses.dataclass(init=False, frozen=True)
class MsgsAck(TLObject):
    """
    Constructor for MsgsAck: Instance of MsgsAck.
    """
    __slots__ = ('msg_ids',)
    CONSTRUCTOR_ID = 0x62d6b459
    SUBCLASS_OF_ID = 0x827677c4

    msg_ids: List[int]
    def __init__(self, msg_ids: List[int]):
        object.__setattr__(self, 'msg_ids', msg_ids)

    def _bytes(self):
        return b''.join((
            b'Y\xb4\xd6b',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.msg_ids)),b''.join(struct.pack('<q', x) for x in self.msg_ids),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _msg_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _msg_ids.append(_x)

        return cls(msg_ids=_msg_ids)


@dataclasses.dataclass(init=False, frozen=True)
class MsgsAllInfo(TLObject):
    """
    Constructor for MsgsAllInfo: Instance of MsgsAllInfo.
    """
    __slots__ = ('msg_ids', 'info',)
    CONSTRUCTOR_ID = 0x8cc0d131
    SUBCLASS_OF_ID = 0xfa8fcb54

    msg_ids: List[int]
    info: str
    def __init__(self, msg_ids: List[int], info: str):
        object.__setattr__(self, 'msg_ids', msg_ids)
        object.__setattr__(self, 'info', info)

    def _bytes(self):
        return b''.join((
            b'1\xd1\xc0\x8c',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.msg_ids)),b''.join(struct.pack('<q', x) for x in self.msg_ids),
            self._serialize_bytes(self.info),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _msg_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _msg_ids.append(_x)

        _info = reader.tgread_string()
        return cls(msg_ids=_msg_ids, info=_info)


@dataclasses.dataclass(init=False, frozen=True)
class MsgsStateInfo(TLObject):
    """
    Constructor for MsgsStateInfo: Instance of MsgsStateInfo.
    """
    __slots__ = ('req_msg_id', 'info',)
    CONSTRUCTOR_ID = 0x4deb57d
    SUBCLASS_OF_ID = 0x70a0a64

    req_msg_id: int
    info: str
    def __init__(self, req_msg_id: int, info: str):
        object.__setattr__(self, 'req_msg_id', req_msg_id)
        object.__setattr__(self, 'info', info)

    def _bytes(self):
        return b''.join((
            b'}\xb5\xde\x04',
            struct.pack('<q', self.req_msg_id),
            self._serialize_bytes(self.info),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _req_msg_id = reader.read_long()
        _info = reader.tgread_string()
        return cls(req_msg_id=_req_msg_id, info=_info)


@dataclasses.dataclass(init=False, frozen=True)
class MsgsStateReq(TLObject):
    """
    Constructor for MsgsStateReq: Instance of MsgsStateReq.
    """
    __slots__ = ('msg_ids',)
    CONSTRUCTOR_ID = 0xda69fb52
    SUBCLASS_OF_ID = 0x18f01dd0

    msg_ids: List[int]
    def __init__(self, msg_ids: List[int]):
        object.__setattr__(self, 'msg_ids', msg_ids)

    def _bytes(self):
        return b''.join((
            b'R\xfbi\xda',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.msg_ids)),b''.join(struct.pack('<q', x) for x in self.msg_ids),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _msg_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _msg_ids.append(_x)

        return cls(msg_ids=_msg_ids)


@dataclasses.dataclass(init=False, frozen=True)
class NearestDc(TLObject):
    """
    Constructor for NearestDc: Instance of NearestDc.
    """
    __slots__ = ('country', 'this_dc', 'nearest_dc',)
    CONSTRUCTOR_ID = 0x8e1a1775
    SUBCLASS_OF_ID = 0x3877045f

    country: str
    this_dc: int
    nearest_dc: int
    def __init__(self, country: str, this_dc: int, nearest_dc: int):
        object.__setattr__(self, 'country', country)
        object.__setattr__(self, 'this_dc', this_dc)
        object.__setattr__(self, 'nearest_dc', nearest_dc)

    def _bytes(self):
        return b''.join((
            b'u\x17\x1a\x8e',
            self._serialize_bytes(self.country),
            struct.pack('<i', self.this_dc),
            struct.pack('<i', self.nearest_dc),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _country = reader.tgread_string()
        _this_dc = reader.read_int()
        _nearest_dc = reader.read_int()
        return cls(country=_country, this_dc=_this_dc, nearest_dc=_nearest_dc)


@dataclasses.dataclass(init=False, frozen=True)
class NewSessionCreated(TLObject):
    """
    Constructor for NewSession: Instance of NewSessionCreated.
    """
    __slots__ = ('first_msg_id', 'unique_id', 'server_salt',)
    CONSTRUCTOR_ID = 0x9ec20908
    SUBCLASS_OF_ID = 0x510d3031

    first_msg_id: int
    unique_id: int
    server_salt: int
    def __init__(self, first_msg_id: int, unique_id: int, server_salt: int):
        object.__setattr__(self, 'first_msg_id', first_msg_id)
        object.__setattr__(self, 'unique_id', unique_id)
        object.__setattr__(self, 'server_salt', server_salt)

    def _bytes(self):
        return b''.join((
            b'\x08\t\xc2\x9e',
            struct.pack('<q', self.first_msg_id),
            struct.pack('<q', self.unique_id),
            struct.pack('<q', self.server_salt),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _first_msg_id = reader.read_long()
        _unique_id = reader.read_long()
        _server_salt = reader.read_long()
        return cls(first_msg_id=_first_msg_id, unique_id=_unique_id, server_salt=_server_salt)


@dataclasses.dataclass(init=False, frozen=True)
class NotifyBroadcasts(TLObject):
    """
    Constructor for NotifyPeer: Instance of either NotifyPeer, NotifyUsers, NotifyChats, NotifyBroadcasts.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd612e8ef
    SUBCLASS_OF_ID = 0xdfe8602e

    def _bytes(self):
        return b''.join((
            b'\xef\xe8\x12\xd6',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class NotifyChats(TLObject):
    """
    Constructor for NotifyPeer: Instance of either NotifyPeer, NotifyUsers, NotifyChats, NotifyBroadcasts.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xc007cec3
    SUBCLASS_OF_ID = 0xdfe8602e

    def _bytes(self):
        return b''.join((
            b'\xc3\xce\x07\xc0',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class NotifyPeer(TLObject):
    """
    Constructor for NotifyPeer: Instance of either NotifyPeer, NotifyUsers, NotifyChats, NotifyBroadcasts.
    """
    __slots__ = ('peer',)
    CONSTRUCTOR_ID = 0x9fd40bd8
    SUBCLASS_OF_ID = 0xdfe8602e

    peer: 'TypePeer'
    def __init__(self, peer: 'TypePeer'):
        object.__setattr__(self, 'peer', peer)

    def _bytes(self):
        return b''.join((
            b'\xd8\x0b\xd4\x9f',
            self.peer._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


@dataclasses.dataclass(init=False, frozen=True)
class NotifyUsers(TLObject):
    """
    Constructor for NotifyPeer: Instance of either NotifyPeer, NotifyUsers, NotifyChats, NotifyBroadcasts.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb4c83b4c
    SUBCLASS_OF_ID = 0xdfe8602e

    def _bytes(self):
        return b''.join((
            b'L;\xc8\xb4',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PQInnerData(TLObject):
    """
    Constructor for P_Q_inner_data: Instance of either PQInnerData, PQInnerDataDc, PQInnerDataTemp, PQInnerDataTempDc.
    """
    __slots__ = ('pq', 'p', 'q', 'nonce', 'server_nonce', 'new_nonce',)
    CONSTRUCTOR_ID = 0x83c95aec
    SUBCLASS_OF_ID = 0x41701377

    pq: bytes
    p: bytes
    q: bytes
    nonce: int
    server_nonce: int
    new_nonce: int
    def __init__(self, pq: bytes, p: bytes, q: bytes, nonce: int, server_nonce: int, new_nonce: int):
        object.__setattr__(self, 'pq', pq)
        object.__setattr__(self, 'p', p)
        object.__setattr__(self, 'q', q)
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'server_nonce', server_nonce)
        object.__setattr__(self, 'new_nonce', new_nonce)

    def _bytes(self):
        return b''.join((
            b'\xecZ\xc9\x83',
            self._serialize_bytes(self.pq),
            self._serialize_bytes(self.p),
            self._serialize_bytes(self.q),
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce.to_bytes(32, 'little', signed=True),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _pq = reader.tgread_bytes()
        _p = reader.tgread_bytes()
        _q = reader.tgread_bytes()
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce = reader.read_large_int(bits=256)
        return cls(pq=_pq, p=_p, q=_q, nonce=_nonce, server_nonce=_server_nonce, new_nonce=_new_nonce)


@dataclasses.dataclass(init=False, frozen=True)
class PQInnerDataDc(TLObject):
    """
    Constructor for P_Q_inner_data: Instance of either PQInnerData, PQInnerDataDc, PQInnerDataTemp, PQInnerDataTempDc.
    """
    __slots__ = ('pq', 'p', 'q', 'nonce', 'server_nonce', 'new_nonce', 'dc',)
    CONSTRUCTOR_ID = 0xa9f55f95
    SUBCLASS_OF_ID = 0x41701377

    pq: bytes
    p: bytes
    q: bytes
    nonce: int
    server_nonce: int
    new_nonce: int
    dc: int
    def __init__(self, pq: bytes, p: bytes, q: bytes, nonce: int, server_nonce: int, new_nonce: int, dc: int):
        object.__setattr__(self, 'pq', pq)
        object.__setattr__(self, 'p', p)
        object.__setattr__(self, 'q', q)
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'server_nonce', server_nonce)
        object.__setattr__(self, 'new_nonce', new_nonce)
        object.__setattr__(self, 'dc', dc)

    def _bytes(self):
        return b''.join((
            b'\x95_\xf5\xa9',
            self._serialize_bytes(self.pq),
            self._serialize_bytes(self.p),
            self._serialize_bytes(self.q),
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce.to_bytes(32, 'little', signed=True),
            struct.pack('<i', self.dc),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _pq = reader.tgread_bytes()
        _p = reader.tgread_bytes()
        _q = reader.tgread_bytes()
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce = reader.read_large_int(bits=256)
        _dc = reader.read_int()
        return cls(pq=_pq, p=_p, q=_q, nonce=_nonce, server_nonce=_server_nonce, new_nonce=_new_nonce, dc=_dc)


@dataclasses.dataclass(init=False, frozen=True)
class PQInnerDataTemp(TLObject):
    """
    Constructor for P_Q_inner_data: Instance of either PQInnerData, PQInnerDataDc, PQInnerDataTemp, PQInnerDataTempDc.
    """
    __slots__ = ('pq', 'p', 'q', 'nonce', 'server_nonce', 'new_nonce', 'expires_in',)
    CONSTRUCTOR_ID = 0x3c6a84d4
    SUBCLASS_OF_ID = 0x41701377

    pq: bytes
    p: bytes
    q: bytes
    nonce: int
    server_nonce: int
    new_nonce: int
    expires_in: int
    def __init__(self, pq: bytes, p: bytes, q: bytes, nonce: int, server_nonce: int, new_nonce: int, expires_in: int):
        object.__setattr__(self, 'pq', pq)
        object.__setattr__(self, 'p', p)
        object.__setattr__(self, 'q', q)
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'server_nonce', server_nonce)
        object.__setattr__(self, 'new_nonce', new_nonce)
        object.__setattr__(self, 'expires_in', expires_in)

    def _bytes(self):
        return b''.join((
            b'\xd4\x84j<',
            self._serialize_bytes(self.pq),
            self._serialize_bytes(self.p),
            self._serialize_bytes(self.q),
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce.to_bytes(32, 'little', signed=True),
            struct.pack('<i', self.expires_in),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _pq = reader.tgread_bytes()
        _p = reader.tgread_bytes()
        _q = reader.tgread_bytes()
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce = reader.read_large_int(bits=256)
        _expires_in = reader.read_int()
        return cls(pq=_pq, p=_p, q=_q, nonce=_nonce, server_nonce=_server_nonce, new_nonce=_new_nonce, expires_in=_expires_in)


@dataclasses.dataclass(init=False, frozen=True)
class PQInnerDataTempDc(TLObject):
    """
    Constructor for P_Q_inner_data: Instance of either PQInnerData, PQInnerDataDc, PQInnerDataTemp, PQInnerDataTempDc.
    """
    __slots__ = ('pq', 'p', 'q', 'nonce', 'server_nonce', 'new_nonce', 'dc', 'expires_in',)
    CONSTRUCTOR_ID = 0x56fddf88
    SUBCLASS_OF_ID = 0x41701377

    pq: bytes
    p: bytes
    q: bytes
    nonce: int
    server_nonce: int
    new_nonce: int
    dc: int
    expires_in: int
    def __init__(self, pq: bytes, p: bytes, q: bytes, nonce: int, server_nonce: int, new_nonce: int, dc: int, expires_in: int):
        object.__setattr__(self, 'pq', pq)
        object.__setattr__(self, 'p', p)
        object.__setattr__(self, 'q', q)
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'server_nonce', server_nonce)
        object.__setattr__(self, 'new_nonce', new_nonce)
        object.__setattr__(self, 'dc', dc)
        object.__setattr__(self, 'expires_in', expires_in)

    def _bytes(self):
        return b''.join((
            b'\x88\xdf\xfdV',
            self._serialize_bytes(self.pq),
            self._serialize_bytes(self.p),
            self._serialize_bytes(self.q),
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce.to_bytes(32, 'little', signed=True),
            struct.pack('<i', self.dc),
            struct.pack('<i', self.expires_in),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _pq = reader.tgread_bytes()
        _p = reader.tgread_bytes()
        _q = reader.tgread_bytes()
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce = reader.read_large_int(bits=256)
        _dc = reader.read_int()
        _expires_in = reader.read_int()
        return cls(pq=_pq, p=_p, q=_q, nonce=_nonce, server_nonce=_server_nonce, new_nonce=_new_nonce, dc=_dc, expires_in=_expires_in)


@dataclasses.dataclass(init=False, frozen=True)
class Page(TLObject):
    """
    Constructor for Page: Instance of Page.
    """
    __slots__ = ('url', 'blocks', 'photos', 'documents', 'part', 'rtl', 'v2', 'views',)
    CONSTRUCTOR_ID = 0x98657f0d
    SUBCLASS_OF_ID = 0xb438191e

    url: str
    blocks: List['TypePageBlock']
    photos: List['TypePhoto']
    documents: List['TypeDocument']
    part: Optional[bool]
    rtl: Optional[bool]
    v2: Optional[bool]
    views: Optional[int]
    def __init__(self, url: str, blocks: List['TypePageBlock'], photos: List['TypePhoto'], documents: List['TypeDocument'], part: Optional[bool]=None, rtl: Optional[bool]=None, v2: Optional[bool]=None, views: Optional[int]=None):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'blocks', blocks)
        object.__setattr__(self, 'photos', photos)
        object.__setattr__(self, 'documents', documents)
        object.__setattr__(self, 'part', part)
        object.__setattr__(self, 'rtl', rtl)
        object.__setattr__(self, 'v2', v2)
        object.__setattr__(self, 'views', views)

    def _bytes(self):
        return b''.join((
            b'\r\x7fe\x98',
            struct.pack('<I', (0 if self.part is None or self.part is False else 1) | (0 if self.rtl is None or self.rtl is False else 2) | (0 if self.v2 is None or self.v2 is False else 4) | (0 if self.views is None or self.views is False else 8)),
            self._serialize_bytes(self.url),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(x._bytes() for x in self.blocks),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.photos)),b''.join(x._bytes() for x in self.photos),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.documents)),b''.join(x._bytes() for x in self.documents),
            b'' if self.views is None or self.views is False else (struct.pack('<i', self.views)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _part = bool(flags & 1)
        _rtl = bool(flags & 2)
        _v2 = bool(flags & 4)
        _url = reader.tgread_string()
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        reader.read_int()
        _photos = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _photos.append(_x)

        reader.read_int()
        _documents = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _documents.append(_x)

        if flags & 8:
            _views = reader.read_int()
        else:
            _views = None
        return cls(url=_url, blocks=_blocks, photos=_photos, documents=_documents, part=_part, rtl=_rtl, v2=_v2, views=_views)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockAnchor(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('name',)
    CONSTRUCTOR_ID = 0xce0d37b0
    SUBCLASS_OF_ID = 0x1aca5644

    name: str
    def __init__(self, name: str):
        object.__setattr__(self, 'name', name)

    def _bytes(self):
        return b''.join((
            b'\xb07\r\xce',
            self._serialize_bytes(self.name),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _name = reader.tgread_string()
        return cls(name=_name)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockAudio(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('audio_id', 'caption',)
    CONSTRUCTOR_ID = 0x804361ea
    SUBCLASS_OF_ID = 0x1aca5644

    audio_id: int
    caption: 'TypePageCaption'
    def __init__(self, audio_id: int, caption: 'TypePageCaption'):
        object.__setattr__(self, 'audio_id', audio_id)
        object.__setattr__(self, 'caption', caption)

    def _bytes(self):
        return b''.join((
            b'\xeaaC\x80',
            struct.pack('<q', self.audio_id),
            self.caption._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _audio_id = reader.read_long()
        _caption = reader.tgread_object()
        return cls(audio_id=_audio_id, caption=_caption)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockAuthorDate(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('author', 'published_date',)
    CONSTRUCTOR_ID = 0xbaafe5e0
    SUBCLASS_OF_ID = 0x1aca5644

    author: 'TypeRichText'
    published_date: Optional[datetime]
    def __init__(self, author: 'TypeRichText', published_date: Optional[datetime]):
        object.__setattr__(self, 'author', author)
        object.__setattr__(self, 'published_date', published_date)

    def _bytes(self):
        return b''.join((
            b'\xe0\xe5\xaf\xba',
            self.author._bytes(),
            self._serialize_datetime(self.published_date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _author = reader.tgread_object()
        _published_date = reader.tgread_date()
        return cls(author=_author, published_date=_published_date)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockBlockquote(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('text', 'caption',)
    CONSTRUCTOR_ID = 0x263d7c26
    SUBCLASS_OF_ID = 0x1aca5644

    text: 'TypeRichText'
    caption: 'TypeRichText'
    def __init__(self, text: 'TypeRichText', caption: 'TypeRichText'):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'caption', caption)

    def _bytes(self):
        return b''.join((
            b'&|=&',
            self.text._bytes(),
            self.caption._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        _caption = reader.tgread_object()
        return cls(text=_text, caption=_caption)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockChannel(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('channel',)
    CONSTRUCTOR_ID = 0xef1751b5
    SUBCLASS_OF_ID = 0x1aca5644

    channel: 'TypeChat'
    def __init__(self, channel: 'TypeChat'):
        object.__setattr__(self, 'channel', channel)

    def _bytes(self):
        return b''.join((
            b'\xb5Q\x17\xef',
            self.channel._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockCollage(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('items', 'caption',)
    CONSTRUCTOR_ID = 0x65a0fa4d
    SUBCLASS_OF_ID = 0x1aca5644

    items: List['TypePageBlock']
    caption: 'TypePageCaption'
    def __init__(self, items: List['TypePageBlock'], caption: 'TypePageCaption'):
        object.__setattr__(self, 'items', items)
        object.__setattr__(self, 'caption', caption)

    def _bytes(self):
        return b''.join((
            b'M\xfa\xa0e',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.items)),b''.join(x._bytes() for x in self.items),
            self.caption._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _items = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _items.append(_x)

        _caption = reader.tgread_object()
        return cls(items=_items, caption=_caption)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockCover(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('cover',)
    CONSTRUCTOR_ID = 0x39f23300
    SUBCLASS_OF_ID = 0x1aca5644

    cover: 'TypePageBlock'
    def __init__(self, cover: 'TypePageBlock'):
        object.__setattr__(self, 'cover', cover)

    def _bytes(self):
        return b''.join((
            b'\x003\xf29',
            self.cover._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _cover = reader.tgread_object()
        return cls(cover=_cover)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockDetails(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('blocks', 'title', 'open',)
    CONSTRUCTOR_ID = 0x76768bed
    SUBCLASS_OF_ID = 0x1aca5644

    blocks: List['TypePageBlock']
    title: 'TypeRichText'
    open: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, blocks: List['TypePageBlock'], title: 'TypeRichText', open: Optional[bool]=None):
        object.__setattr__(self, 'blocks', blocks)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'open', open)

    def _bytes(self):
        return b''.join((
            b'\xed\x8bvv',
            struct.pack('<I', (0 if self.open is None or self.open is False else 1)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(x._bytes() for x in self.blocks),
            self.title._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _open = bool(flags & 1)
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        _title = reader.tgread_object()
        return cls(blocks=_blocks, title=_title, open=_open)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockDivider(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xdb20b188
    SUBCLASS_OF_ID = 0x1aca5644

    def _bytes(self):
        return b''.join((
            b'\x88\xb1 \xdb',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockEmbed(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('caption', 'full_width', 'allow_scrolling', 'url', 'html', 'poster_photo_id', 'w', 'h',)
    CONSTRUCTOR_ID = 0xa8718dc5
    SUBCLASS_OF_ID = 0x1aca5644

    caption: 'TypePageCaption'
    full_width: Optional[bool]
    allow_scrolling: Optional[bool]
    url: Optional[str]
    html: Optional[str]
    poster_photo_id: Optional[int]
    w: Optional[int]
    h: Optional[int]
    def __init__(self, caption: 'TypePageCaption', full_width: Optional[bool]=None, allow_scrolling: Optional[bool]=None, url: Optional[str]=None, html: Optional[str]=None, poster_photo_id: Optional[int]=None, w: Optional[int]=None, h: Optional[int]=None):
        object.__setattr__(self, 'caption', caption)
        object.__setattr__(self, 'full_width', full_width)
        object.__setattr__(self, 'allow_scrolling', allow_scrolling)
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'html', html)
        object.__setattr__(self, 'poster_photo_id', poster_photo_id)
        object.__setattr__(self, 'w', w)
        object.__setattr__(self, 'h', h)

    def _bytes(self):
        assert ((self.w or self.w is not None) and (self.h or self.h is not None)) or ((self.w is None or self.w is False) and (self.h is None or self.h is False)), 'w, h parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xc5\x8dq\xa8',
            struct.pack('<I', (0 if self.full_width is None or self.full_width is False else 1) | (0 if self.allow_scrolling is None or self.allow_scrolling is False else 8) | (0 if self.url is None or self.url is False else 2) | (0 if self.html is None or self.html is False else 4) | (0 if self.poster_photo_id is None or self.poster_photo_id is False else 16) | (0 if self.w is None or self.w is False else 32) | (0 if self.h is None or self.h is False else 32)),
            b'' if self.url is None or self.url is False else (self._serialize_bytes(self.url)),
            b'' if self.html is None or self.html is False else (self._serialize_bytes(self.html)),
            b'' if self.poster_photo_id is None or self.poster_photo_id is False else (struct.pack('<q', self.poster_photo_id)),
            b'' if self.w is None or self.w is False else (struct.pack('<i', self.w)),
            b'' if self.h is None or self.h is False else (struct.pack('<i', self.h)),
            self.caption._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _full_width = bool(flags & 1)
        _allow_scrolling = bool(flags & 8)
        if flags & 2:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 4:
            _html = reader.tgread_string()
        else:
            _html = None
        if flags & 16:
            _poster_photo_id = reader.read_long()
        else:
            _poster_photo_id = None
        if flags & 32:
            _w = reader.read_int()
        else:
            _w = None
        if flags & 32:
            _h = reader.read_int()
        else:
            _h = None
        _caption = reader.tgread_object()
        return cls(caption=_caption, full_width=_full_width, allow_scrolling=_allow_scrolling, url=_url, html=_html, poster_photo_id=_poster_photo_id, w=_w, h=_h)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockEmbedPost(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('url', 'webpage_id', 'author_photo_id', 'author', 'date', 'blocks', 'caption',)
    CONSTRUCTOR_ID = 0xf259a80b
    SUBCLASS_OF_ID = 0x1aca5644

    url: str
    webpage_id: int
    author_photo_id: int
    author: str
    date: Optional[datetime]
    blocks: List['TypePageBlock']
    caption: 'TypePageCaption'
    def __init__(self, url: str, webpage_id: int, author_photo_id: int, author: str, date: Optional[datetime], blocks: List['TypePageBlock'], caption: 'TypePageCaption'):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'webpage_id', webpage_id)
        object.__setattr__(self, 'author_photo_id', author_photo_id)
        object.__setattr__(self, 'author', author)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'blocks', blocks)
        object.__setattr__(self, 'caption', caption)

    def _bytes(self):
        return b''.join((
            b'\x0b\xa8Y\xf2',
            self._serialize_bytes(self.url),
            struct.pack('<q', self.webpage_id),
            struct.pack('<q', self.author_photo_id),
            self._serialize_bytes(self.author),
            self._serialize_datetime(self.date),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(x._bytes() for x in self.blocks),
            self.caption._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _url = reader.tgread_string()
        _webpage_id = reader.read_long()
        _author_photo_id = reader.read_long()
        _author = reader.tgread_string()
        _date = reader.tgread_date()
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        _caption = reader.tgread_object()
        return cls(url=_url, webpage_id=_webpage_id, author_photo_id=_author_photo_id, author=_author, date=_date, blocks=_blocks, caption=_caption)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockFooter(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0x48870999
    SUBCLASS_OF_ID = 0x1aca5644

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\x99\t\x87H',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockHeader(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0xbfd064ec
    SUBCLASS_OF_ID = 0x1aca5644

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xecd\xd0\xbf',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockKicker(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0x1e148390
    SUBCLASS_OF_ID = 0x1aca5644

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\x90\x83\x14\x1e',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockList(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('items',)
    CONSTRUCTOR_ID = 0xe4e88011
    SUBCLASS_OF_ID = 0x1aca5644

    items: List['TypePageListItem']
    def __init__(self, items: List['TypePageListItem']):
        object.__setattr__(self, 'items', items)

    def _bytes(self):
        return b''.join((
            b'\x11\x80\xe8\xe4',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.items)),b''.join(x._bytes() for x in self.items),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _items = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _items.append(_x)

        return cls(items=_items)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockMap(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('geo', 'zoom', 'w', 'h', 'caption',)
    CONSTRUCTOR_ID = 0xa44f3ef6
    SUBCLASS_OF_ID = 0x1aca5644

    geo: 'TypeGeoPoint'
    zoom: int
    w: int
    h: int
    caption: 'TypePageCaption'
    def __init__(self, geo: 'TypeGeoPoint', zoom: int, w: int, h: int, caption: 'TypePageCaption'):
        object.__setattr__(self, 'geo', geo)
        object.__setattr__(self, 'zoom', zoom)
        object.__setattr__(self, 'w', w)
        object.__setattr__(self, 'h', h)
        object.__setattr__(self, 'caption', caption)

    def _bytes(self):
        return b''.join((
            b'\xf6>O\xa4',
            self.geo._bytes(),
            struct.pack('<i', self.zoom),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
            self.caption._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _geo = reader.tgread_object()
        _zoom = reader.read_int()
        _w = reader.read_int()
        _h = reader.read_int()
        _caption = reader.tgread_object()
        return cls(geo=_geo, zoom=_zoom, w=_w, h=_h, caption=_caption)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockOrderedList(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('items',)
    CONSTRUCTOR_ID = 0x9a8ae1e1
    SUBCLASS_OF_ID = 0x1aca5644

    items: List['TypePageListOrderedItem']
    def __init__(self, items: List['TypePageListOrderedItem']):
        object.__setattr__(self, 'items', items)

    def _bytes(self):
        return b''.join((
            b'\xe1\xe1\x8a\x9a',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.items)),b''.join(x._bytes() for x in self.items),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _items = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _items.append(_x)

        return cls(items=_items)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockParagraph(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0x467a0766
    SUBCLASS_OF_ID = 0x1aca5644

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'f\x07zF',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockPhoto(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('photo_id', 'caption', 'url', 'webpage_id',)
    CONSTRUCTOR_ID = 0x1759c560
    SUBCLASS_OF_ID = 0x1aca5644

    photo_id: int
    caption: 'TypePageCaption'
    url: Optional[str]
    webpage_id: Optional[int]
    def __init__(self, photo_id: int, caption: 'TypePageCaption', url: Optional[str]=None, webpage_id: Optional[int]=None):
        object.__setattr__(self, 'photo_id', photo_id)
        object.__setattr__(self, 'caption', caption)
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'webpage_id', webpage_id)

    def _bytes(self):
        assert ((self.url or self.url is not None) and (self.webpage_id or self.webpage_id is not None)) or ((self.url is None or self.url is False) and (self.webpage_id is None or self.webpage_id is False)), 'url, webpage_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'`\xc5Y\x17',
            struct.pack('<I', (0 if self.url is None or self.url is False else 1) | (0 if self.webpage_id is None or self.webpage_id is False else 1)),
            struct.pack('<q', self.photo_id),
            self.caption._bytes(),
            b'' if self.url is None or self.url is False else (self._serialize_bytes(self.url)),
            b'' if self.webpage_id is None or self.webpage_id is False else (struct.pack('<q', self.webpage_id)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _photo_id = reader.read_long()
        _caption = reader.tgread_object()
        if flags & 1:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 1:
            _webpage_id = reader.read_long()
        else:
            _webpage_id = None
        return cls(photo_id=_photo_id, caption=_caption, url=_url, webpage_id=_webpage_id)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockPreformatted(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('text', 'language',)
    CONSTRUCTOR_ID = 0xc070d93e
    SUBCLASS_OF_ID = 0x1aca5644

    text: 'TypeRichText'
    language: str
    def __init__(self, text: 'TypeRichText', language: str):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'language', language)

    def _bytes(self):
        return b''.join((
            b'>\xd9p\xc0',
            self.text._bytes(),
            self._serialize_bytes(self.language),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        _language = reader.tgread_string()
        return cls(text=_text, language=_language)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockPullquote(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('text', 'caption',)
    CONSTRUCTOR_ID = 0x4f4456d3
    SUBCLASS_OF_ID = 0x1aca5644

    text: 'TypeRichText'
    caption: 'TypeRichText'
    def __init__(self, text: 'TypeRichText', caption: 'TypeRichText'):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'caption', caption)

    def _bytes(self):
        return b''.join((
            b'\xd3VDO',
            self.text._bytes(),
            self.caption._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        _caption = reader.tgread_object()
        return cls(text=_text, caption=_caption)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockRelatedArticles(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('title', 'articles',)
    CONSTRUCTOR_ID = 0x16115a96
    SUBCLASS_OF_ID = 0x1aca5644

    title: 'TypeRichText'
    articles: List['TypePageRelatedArticle']
    def __init__(self, title: 'TypeRichText', articles: List['TypePageRelatedArticle']):
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'articles', articles)

    def _bytes(self):
        return b''.join((
            b'\x96Z\x11\x16',
            self.title._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.articles)),b''.join(x._bytes() for x in self.articles),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _title = reader.tgread_object()
        reader.read_int()
        _articles = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _articles.append(_x)

        return cls(title=_title, articles=_articles)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockSlideshow(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('items', 'caption',)
    CONSTRUCTOR_ID = 0x31f9590
    SUBCLASS_OF_ID = 0x1aca5644

    items: List['TypePageBlock']
    caption: 'TypePageCaption'
    def __init__(self, items: List['TypePageBlock'], caption: 'TypePageCaption'):
        object.__setattr__(self, 'items', items)
        object.__setattr__(self, 'caption', caption)

    def _bytes(self):
        return b''.join((
            b'\x90\x95\x1f\x03',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.items)),b''.join(x._bytes() for x in self.items),
            self.caption._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _items = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _items.append(_x)

        _caption = reader.tgread_object()
        return cls(items=_items, caption=_caption)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockSubheader(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0xf12bb6e1
    SUBCLASS_OF_ID = 0x1aca5644

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xe1\xb6+\xf1',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockSubtitle(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0x8ffa9a1f
    SUBCLASS_OF_ID = 0x1aca5644

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\x1f\x9a\xfa\x8f',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockTable(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('title', 'rows', 'bordered', 'striped',)
    CONSTRUCTOR_ID = 0xbf4dea82
    SUBCLASS_OF_ID = 0x1aca5644

    title: 'TypeRichText'
    rows: List['TypePageTableRow']
    bordered: Optional[bool]
    striped: Optional[bool]
    def __init__(self, title: 'TypeRichText', rows: List['TypePageTableRow'], bordered: Optional[bool]=None, striped: Optional[bool]=None):
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'rows', rows)
        object.__setattr__(self, 'bordered', bordered)
        object.__setattr__(self, 'striped', striped)

    def _bytes(self):
        return b''.join((
            b'\x82\xeaM\xbf',
            struct.pack('<I', (0 if self.bordered is None or self.bordered is False else 1) | (0 if self.striped is None or self.striped is False else 2)),
            self.title._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.rows)),b''.join(x._bytes() for x in self.rows),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _bordered = bool(flags & 1)
        _striped = bool(flags & 2)
        _title = reader.tgread_object()
        reader.read_int()
        _rows = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _rows.append(_x)

        return cls(title=_title, rows=_rows, bordered=_bordered, striped=_striped)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockTitle(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0x70abc3fd
    SUBCLASS_OF_ID = 0x1aca5644

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xfd\xc3\xabp',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockUnsupported(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x13567e8a
    SUBCLASS_OF_ID = 0x1aca5644

    def _bytes(self):
        return b''.join((
            b'\x8a~V\x13',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PageBlockVideo(TLObject):
    """
    Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
    """
    __slots__ = ('video_id', 'caption', 'autoplay', 'loop',)
    CONSTRUCTOR_ID = 0x7c8fe7b6
    SUBCLASS_OF_ID = 0x1aca5644

    video_id: int
    caption: 'TypePageCaption'
    autoplay: Optional[bool]
    loop: Optional[bool]
    def __init__(self, video_id: int, caption: 'TypePageCaption', autoplay: Optional[bool]=None, loop: Optional[bool]=None):
        object.__setattr__(self, 'video_id', video_id)
        object.__setattr__(self, 'caption', caption)
        object.__setattr__(self, 'autoplay', autoplay)
        object.__setattr__(self, 'loop', loop)

    def _bytes(self):
        return b''.join((
            b'\xb6\xe7\x8f|',
            struct.pack('<I', (0 if self.autoplay is None or self.autoplay is False else 1) | (0 if self.loop is None or self.loop is False else 2)),
            struct.pack('<q', self.video_id),
            self.caption._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _autoplay = bool(flags & 1)
        _loop = bool(flags & 2)
        _video_id = reader.read_long()
        _caption = reader.tgread_object()
        return cls(video_id=_video_id, caption=_caption, autoplay=_autoplay, loop=_loop)


@dataclasses.dataclass(init=False, frozen=True)
class PageCaption(TLObject):
    """
    Constructor for PageCaption: Instance of PageCaption.
    """
    __slots__ = ('text', 'credit',)
    CONSTRUCTOR_ID = 0x6f747657
    SUBCLASS_OF_ID = 0x29b8eeb3

    text: 'TypeRichText'
    credit: 'TypeRichText'
    def __init__(self, text: 'TypeRichText', credit: 'TypeRichText'):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'credit', credit)

    def _bytes(self):
        return b''.join((
            b'Wvto',
            self.text._bytes(),
            self.credit._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        _credit = reader.tgread_object()
        return cls(text=_text, credit=_credit)


@dataclasses.dataclass(init=False, frozen=True)
class PageListItemBlocks(TLObject):
    """
    Constructor for PageListItem: Instance of either PageListItemText, PageListItemBlocks.
    """
    __slots__ = ('blocks',)
    CONSTRUCTOR_ID = 0x25e073fc
    SUBCLASS_OF_ID = 0x8caebcb1

    blocks: List['TypePageBlock']
    def __init__(self, blocks: List['TypePageBlock']):
        object.__setattr__(self, 'blocks', blocks)

    def _bytes(self):
        return b''.join((
            b'\xfcs\xe0%',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(x._bytes() for x in self.blocks),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        return cls(blocks=_blocks)


@dataclasses.dataclass(init=False, frozen=True)
class PageListItemText(TLObject):
    """
    Constructor for PageListItem: Instance of either PageListItemText, PageListItemBlocks.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0xb92fb6cd
    SUBCLASS_OF_ID = 0x8caebcb1

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xcd\xb6/\xb9',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class PageListOrderedItemBlocks(TLObject):
    """
    Constructor for PageListOrderedItem: Instance of either PageListOrderedItemText, PageListOrderedItemBlocks.
    """
    __slots__ = ('num', 'blocks',)
    CONSTRUCTOR_ID = 0x98dd8936
    SUBCLASS_OF_ID = 0xeeda0eb8

    num: str
    blocks: List['TypePageBlock']
    def __init__(self, num: str, blocks: List['TypePageBlock']):
        object.__setattr__(self, 'num', num)
        object.__setattr__(self, 'blocks', blocks)

    def _bytes(self):
        return b''.join((
            b'6\x89\xdd\x98',
            self._serialize_bytes(self.num),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(x._bytes() for x in self.blocks),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _num = reader.tgread_string()
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        return cls(num=_num, blocks=_blocks)


@dataclasses.dataclass(init=False, frozen=True)
class PageListOrderedItemText(TLObject):
    """
    Constructor for PageListOrderedItem: Instance of either PageListOrderedItemText, PageListOrderedItemBlocks.
    """
    __slots__ = ('num', 'text',)
    CONSTRUCTOR_ID = 0x5e068047
    SUBCLASS_OF_ID = 0xeeda0eb8

    num: str
    text: 'TypeRichText'
    def __init__(self, num: str, text: 'TypeRichText'):
        object.__setattr__(self, 'num', num)
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'G\x80\x06^',
            self._serialize_bytes(self.num),
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _num = reader.tgread_string()
        _text = reader.tgread_object()
        return cls(num=_num, text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class PageRelatedArticle(TLObject):
    """
    Constructor for PageRelatedArticle: Instance of PageRelatedArticle.
    """
    __slots__ = ('url', 'webpage_id', 'title', 'description', 'photo_id', 'author', 'published_date',)
    CONSTRUCTOR_ID = 0xb390dc08
    SUBCLASS_OF_ID = 0x36d05822

    url: str
    webpage_id: int
    title: Optional[str]
    description: Optional[str]
    photo_id: Optional[int]
    author: Optional[str]
    published_date: Optional[datetime]
    def __init__(self, url: str, webpage_id: int, title: Optional[str]=None, description: Optional[str]=None, photo_id: Optional[int]=None, author: Optional[str]=None, published_date: Optional[datetime]=None):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'webpage_id', webpage_id)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'description', description)
        object.__setattr__(self, 'photo_id', photo_id)
        object.__setattr__(self, 'author', author)
        object.__setattr__(self, 'published_date', published_date)

    def _bytes(self):
        return b''.join((
            b'\x08\xdc\x90\xb3',
            struct.pack('<I', (0 if self.title is None or self.title is False else 1) | (0 if self.description is None or self.description is False else 2) | (0 if self.photo_id is None or self.photo_id is False else 4) | (0 if self.author is None or self.author is False else 8) | (0 if self.published_date is None or self.published_date is False else 16)),
            self._serialize_bytes(self.url),
            struct.pack('<q', self.webpage_id),
            b'' if self.title is None or self.title is False else (self._serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self._serialize_bytes(self.description)),
            b'' if self.photo_id is None or self.photo_id is False else (struct.pack('<q', self.photo_id)),
            b'' if self.author is None or self.author is False else (self._serialize_bytes(self.author)),
            b'' if self.published_date is None or self.published_date is False else (self._serialize_datetime(self.published_date)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _url = reader.tgread_string()
        _webpage_id = reader.read_long()
        if flags & 1:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 2:
            _description = reader.tgread_string()
        else:
            _description = None
        if flags & 4:
            _photo_id = reader.read_long()
        else:
            _photo_id = None
        if flags & 8:
            _author = reader.tgread_string()
        else:
            _author = None
        if flags & 16:
            _published_date = reader.tgread_date()
        else:
            _published_date = None
        return cls(url=_url, webpage_id=_webpage_id, title=_title, description=_description, photo_id=_photo_id, author=_author, published_date=_published_date)


@dataclasses.dataclass(init=False, frozen=True)
class PageTableCell(TLObject):
    """
    Constructor for PageTableCell: Instance of PageTableCell.
    """
    __slots__ = ('header', 'align_center', 'align_right', 'valign_middle', 'valign_bottom', 'text', 'colspan', 'rowspan',)
    CONSTRUCTOR_ID = 0x34566b6a
    SUBCLASS_OF_ID = 0xb0eb3054

    header: Optional[bool]
    align_center: Optional[bool]
    align_right: Optional[bool]
    valign_middle: Optional[bool]
    valign_bottom: Optional[bool]
    text: Optional['TypeRichText']
    colspan: Optional[int]
    rowspan: Optional[int]
    def __init__(self, header: Optional[bool]=None, align_center: Optional[bool]=None, align_right: Optional[bool]=None, valign_middle: Optional[bool]=None, valign_bottom: Optional[bool]=None, text: Optional['TypeRichText']=None, colspan: Optional[int]=None, rowspan: Optional[int]=None):
        object.__setattr__(self, 'header', header)
        object.__setattr__(self, 'align_center', align_center)
        object.__setattr__(self, 'align_right', align_right)
        object.__setattr__(self, 'valign_middle', valign_middle)
        object.__setattr__(self, 'valign_bottom', valign_bottom)
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'colspan', colspan)
        object.__setattr__(self, 'rowspan', rowspan)

    def _bytes(self):
        return b''.join((
            b'jkV4',
            struct.pack('<I', (0 if self.header is None or self.header is False else 1) | (0 if self.align_center is None or self.align_center is False else 8) | (0 if self.align_right is None or self.align_right is False else 16) | (0 if self.valign_middle is None or self.valign_middle is False else 32) | (0 if self.valign_bottom is None or self.valign_bottom is False else 64) | (0 if self.text is None or self.text is False else 128) | (0 if self.colspan is None or self.colspan is False else 2) | (0 if self.rowspan is None or self.rowspan is False else 4)),
            b'' if self.text is None or self.text is False else (self.text._bytes()),
            b'' if self.colspan is None or self.colspan is False else (struct.pack('<i', self.colspan)),
            b'' if self.rowspan is None or self.rowspan is False else (struct.pack('<i', self.rowspan)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _header = bool(flags & 1)
        _align_center = bool(flags & 8)
        _align_right = bool(flags & 16)
        _valign_middle = bool(flags & 32)
        _valign_bottom = bool(flags & 64)
        if flags & 128:
            _text = reader.tgread_object()
        else:
            _text = None
        if flags & 2:
            _colspan = reader.read_int()
        else:
            _colspan = None
        if flags & 4:
            _rowspan = reader.read_int()
        else:
            _rowspan = None
        return cls(header=_header, align_center=_align_center, align_right=_align_right, valign_middle=_valign_middle, valign_bottom=_valign_bottom, text=_text, colspan=_colspan, rowspan=_rowspan)


@dataclasses.dataclass(init=False, frozen=True)
class PageTableRow(TLObject):
    """
    Constructor for PageTableRow: Instance of PageTableRow.
    """
    __slots__ = ('cells',)
    CONSTRUCTOR_ID = 0xe0c0c5e5
    SUBCLASS_OF_ID = 0x59acee11

    cells: List['TypePageTableCell']
    def __init__(self, cells: List['TypePageTableCell']):
        object.__setattr__(self, 'cells', cells)

    def _bytes(self):
        return b''.join((
            b'\xe5\xc5\xc0\xe0',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.cells)),b''.join(x._bytes() for x in self.cells),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _cells = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _cells.append(_x)

        return cls(cells=_cells)


@dataclasses.dataclass(init=False, frozen=True)
class PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(TLObject):
    """
    Constructor for PasswordKdfAlgo: Instance of either PasswordKdfAlgoUnknown, PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow.
    """
    __slots__ = ('salt1', 'salt2', 'g', 'p',)
    CONSTRUCTOR_ID = 0x3a912d4a
    SUBCLASS_OF_ID = 0x37bcf5cc

    salt1: bytes
    salt2: bytes
    g: int
    p: bytes
    def __init__(self, salt1: bytes, salt2: bytes, g: int, p: bytes):
        object.__setattr__(self, 'salt1', salt1)
        object.__setattr__(self, 'salt2', salt2)
        object.__setattr__(self, 'g', g)
        object.__setattr__(self, 'p', p)

    def _bytes(self):
        return b''.join((
            b'J-\x91:',
            self._serialize_bytes(self.salt1),
            self._serialize_bytes(self.salt2),
            struct.pack('<i', self.g),
            self._serialize_bytes(self.p),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _salt1 = reader.tgread_bytes()
        _salt2 = reader.tgread_bytes()
        _g = reader.read_int()
        _p = reader.tgread_bytes()
        return cls(salt1=_salt1, salt2=_salt2, g=_g, p=_p)


@dataclasses.dataclass(init=False, frozen=True)
class PasswordKdfAlgoUnknown(TLObject):
    """
    Constructor for PasswordKdfAlgo: Instance of either PasswordKdfAlgoUnknown, PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd45ab096
    SUBCLASS_OF_ID = 0x37bcf5cc

    def _bytes(self):
        return b''.join((
            b'\x96\xb0Z\xd4',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PaymentCharge(TLObject):
    """
    Constructor for PaymentCharge: Instance of PaymentCharge.
    """
    __slots__ = ('id', 'provider_charge_id',)
    CONSTRUCTOR_ID = 0xea02c27e
    SUBCLASS_OF_ID = 0x3cc830d9

    id: str
    provider_charge_id: str
    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, provider_charge_id: str):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'provider_charge_id', provider_charge_id)

    def _bytes(self):
        return b''.join((
            b'~\xc2\x02\xea',
            self._serialize_bytes(self.id),
            self._serialize_bytes(self.provider_charge_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_string()
        _provider_charge_id = reader.tgread_string()
        return cls(id=_id, provider_charge_id=_provider_charge_id)


@dataclasses.dataclass(init=False, frozen=True)
class PaymentRequestedInfo(TLObject):
    """
    Constructor for PaymentRequestedInfo: Instance of PaymentRequestedInfo.
    """
    __slots__ = ('name', 'phone', 'email', 'shipping_address',)
    CONSTRUCTOR_ID = 0x909c3f94
    SUBCLASS_OF_ID = 0x8db03146

    name: Optional[str]
    phone: Optional[str]
    email: Optional[str]
    shipping_address: Optional['TypePostAddress']
    def __init__(self, name: Optional[str]=None, phone: Optional[str]=None, email: Optional[str]=None, shipping_address: Optional['TypePostAddress']=None):
        object.__setattr__(self, 'name', name)
        object.__setattr__(self, 'phone', phone)
        object.__setattr__(self, 'email', email)
        object.__setattr__(self, 'shipping_address', shipping_address)

    def _bytes(self):
        return b''.join((
            b'\x94?\x9c\x90',
            struct.pack('<I', (0 if self.name is None or self.name is False else 1) | (0 if self.phone is None or self.phone is False else 2) | (0 if self.email is None or self.email is False else 4) | (0 if self.shipping_address is None or self.shipping_address is False else 8)),
            b'' if self.name is None or self.name is False else (self._serialize_bytes(self.name)),
            b'' if self.phone is None or self.phone is False else (self._serialize_bytes(self.phone)),
            b'' if self.email is None or self.email is False else (self._serialize_bytes(self.email)),
            b'' if self.shipping_address is None or self.shipping_address is False else (self.shipping_address._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _name = reader.tgread_string()
        else:
            _name = None
        if flags & 2:
            _phone = reader.tgread_string()
        else:
            _phone = None
        if flags & 4:
            _email = reader.tgread_string()
        else:
            _email = None
        if flags & 8:
            _shipping_address = reader.tgread_object()
        else:
            _shipping_address = None
        return cls(name=_name, phone=_phone, email=_email, shipping_address=_shipping_address)


@dataclasses.dataclass(init=False, frozen=True)
class PaymentSavedCredentialsCard(TLObject):
    """
    Constructor for PaymentSavedCredentials: Instance of PaymentSavedCredentialsCard.
    """
    __slots__ = ('id', 'title',)
    CONSTRUCTOR_ID = 0xcdc27a1f
    SUBCLASS_OF_ID = 0xb3627ee3

    id: str
    title: str
    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, title: str):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'title', title)

    def _bytes(self):
        return b''.join((
            b'\x1fz\xc2\xcd',
            self._serialize_bytes(self.id),
            self._serialize_bytes(self.title),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_string()
        _title = reader.tgread_string()
        return cls(id=_id, title=_title)


@dataclasses.dataclass(init=False, frozen=True)
class PeerBlocked(TLObject):
    """
    Constructor for PeerBlocked: Instance of PeerBlocked.
    """
    __slots__ = ('peer_id', 'date',)
    CONSTRUCTOR_ID = 0xe8fd8014
    SUBCLASS_OF_ID = 0x54f2fc98

    peer_id: 'TypePeer'
    date: Optional[datetime]
    def __init__(self, peer_id: 'TypePeer', date: Optional[datetime]):
        object.__setattr__(self, 'peer_id', peer_id)
        object.__setattr__(self, 'date', date)

    def _bytes(self):
        return b''.join((
            b'\x14\x80\xfd\xe8',
            self.peer_id._bytes(),
            self._serialize_datetime(self.date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer_id = reader.tgread_object()
        _date = reader.tgread_date()
        return cls(peer_id=_peer_id, date=_date)


@dataclasses.dataclass(init=False, frozen=True)
class PeerChannel(TLObject):
    """
    Constructor for Peer: Instance of either PeerUser, PeerChat, PeerChannel.
    """
    __slots__ = ('channel_id',)
    CONSTRUCTOR_ID = 0xa2a5371e
    SUBCLASS_OF_ID = 0x2d45687

    channel_id: int
    def __init__(self, channel_id: int):
        object.__setattr__(self, 'channel_id', channel_id)

    def _bytes(self):
        return b''.join((
            b'\x1e7\xa5\xa2',
            struct.pack('<q', self.channel_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _channel_id = reader.read_long()
        return cls(channel_id=_channel_id)


@dataclasses.dataclass(init=False, frozen=True)
class PeerChat(TLObject):
    """
    Constructor for Peer: Instance of either PeerUser, PeerChat, PeerChannel.
    """
    __slots__ = ('chat_id',)
    CONSTRUCTOR_ID = 0x36c6019a
    SUBCLASS_OF_ID = 0x2d45687

    chat_id: int
    def __init__(self, chat_id: int):
        object.__setattr__(self, 'chat_id', chat_id)

    def _bytes(self):
        return b''.join((
            b'\x9a\x01\xc66',
            struct.pack('<q', self.chat_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _chat_id = reader.read_long()
        return cls(chat_id=_chat_id)


@dataclasses.dataclass(init=False, frozen=True)
class PeerLocated(TLObject):
    """
    Constructor for PeerLocated: Instance of either PeerLocated, PeerSelfLocated.
    """
    __slots__ = ('peer', 'expires', 'distance',)
    CONSTRUCTOR_ID = 0xca461b5d
    SUBCLASS_OF_ID = 0xfada34ac

    peer: 'TypePeer'
    expires: Optional[datetime]
    distance: int
    def __init__(self, peer: 'TypePeer', expires: Optional[datetime], distance: int):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'expires', expires)
        object.__setattr__(self, 'distance', distance)

    def _bytes(self):
        return b''.join((
            b']\x1bF\xca',
            self.peer._bytes(),
            self._serialize_datetime(self.expires),
            struct.pack('<i', self.distance),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _expires = reader.tgread_date()
        _distance = reader.read_int()
        return cls(peer=_peer, expires=_expires, distance=_distance)


@dataclasses.dataclass(init=False, frozen=True)
class PeerNotifySettings(TLObject):
    """
    Constructor for PeerNotifySettings: Instance of PeerNotifySettings.
    """
    __slots__ = ('show_previews', 'silent', 'mute_until', 'sound',)
    CONSTRUCTOR_ID = 0xaf509d20
    SUBCLASS_OF_ID = 0xcf20c074

    show_previews: Optional[bool]
    silent: Optional[bool]
    mute_until: Optional[datetime]
    sound: Optional[str]
    def __init__(self, show_previews: Optional[bool]=None, silent: Optional[bool]=None, mute_until: Optional[datetime]=None, sound: Optional[str]=None):
        object.__setattr__(self, 'show_previews', show_previews)
        object.__setattr__(self, 'silent', silent)
        object.__setattr__(self, 'mute_until', mute_until)
        object.__setattr__(self, 'sound', sound)

    def _bytes(self):
        return b''.join((
            b' \x9dP\xaf',
            struct.pack('<I', (0 if self.show_previews is None else 1) | (0 if self.silent is None else 2) | (0 if self.mute_until is None or self.mute_until is False else 4) | (0 if self.sound is None or self.sound is False else 8)),
            b'' if self.show_previews is None else (b'\xb5ur\x99' if self.show_previews else b'7\x97y\xbc'),
            b'' if self.silent is None else (b'\xb5ur\x99' if self.silent else b'7\x97y\xbc'),
            b'' if self.mute_until is None or self.mute_until is False else (self._serialize_datetime(self.mute_until)),
            b'' if self.sound is None or self.sound is False else (self._serialize_bytes(self.sound)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _show_previews = reader.tgread_bool()
        else:
            _show_previews = None
        if flags & 2:
            _silent = reader.tgread_bool()
        else:
            _silent = None
        if flags & 4:
            _mute_until = reader.tgread_date()
        else:
            _mute_until = None
        if flags & 8:
            _sound = reader.tgread_string()
        else:
            _sound = None
        return cls(show_previews=_show_previews, silent=_silent, mute_until=_mute_until, sound=_sound)


@dataclasses.dataclass(init=False, frozen=True)
class PeerSelfLocated(TLObject):
    """
    Constructor for PeerLocated: Instance of either PeerLocated, PeerSelfLocated.
    """
    __slots__ = ('expires',)
    CONSTRUCTOR_ID = 0xf8ec284b
    SUBCLASS_OF_ID = 0xfada34ac

    expires: Optional[datetime]
    def __init__(self, expires: Optional[datetime]):
        object.__setattr__(self, 'expires', expires)

    def _bytes(self):
        return b''.join((
            b'K(\xec\xf8',
            self._serialize_datetime(self.expires),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _expires = reader.tgread_date()
        return cls(expires=_expires)


@dataclasses.dataclass(init=False, frozen=True)
class PeerSettings(TLObject):
    """
    Constructor for PeerSettings: Instance of PeerSettings.
    """
    __slots__ = ('report_spam', 'add_contact', 'block_contact', 'share_contact', 'need_contacts_exception', 'report_geo', 'autoarchived', 'invite_members', 'request_chat_broadcast', 'geo_distance', 'request_chat_title', 'request_chat_date',)
    CONSTRUCTOR_ID = 0xa518110d
    SUBCLASS_OF_ID = 0xf6a79f84

    report_spam: Optional[bool]
    add_contact: Optional[bool]
    block_contact: Optional[bool]
    share_contact: Optional[bool]
    need_contacts_exception: Optional[bool]
    report_geo: Optional[bool]
    autoarchived: Optional[bool]
    invite_members: Optional[bool]
    request_chat_broadcast: Optional[bool]
    geo_distance: Optional[int]
    request_chat_title: Optional[str]
    request_chat_date: Optional[datetime]
    def __init__(self, report_spam: Optional[bool]=None, add_contact: Optional[bool]=None, block_contact: Optional[bool]=None, share_contact: Optional[bool]=None, need_contacts_exception: Optional[bool]=None, report_geo: Optional[bool]=None, autoarchived: Optional[bool]=None, invite_members: Optional[bool]=None, request_chat_broadcast: Optional[bool]=None, geo_distance: Optional[int]=None, request_chat_title: Optional[str]=None, request_chat_date: Optional[datetime]=None):
        object.__setattr__(self, 'report_spam', report_spam)
        object.__setattr__(self, 'add_contact', add_contact)
        object.__setattr__(self, 'block_contact', block_contact)
        object.__setattr__(self, 'share_contact', share_contact)
        object.__setattr__(self, 'need_contacts_exception', need_contacts_exception)
        object.__setattr__(self, 'report_geo', report_geo)
        object.__setattr__(self, 'autoarchived', autoarchived)
        object.__setattr__(self, 'invite_members', invite_members)
        object.__setattr__(self, 'request_chat_broadcast', request_chat_broadcast)
        object.__setattr__(self, 'geo_distance', geo_distance)
        object.__setattr__(self, 'request_chat_title', request_chat_title)
        object.__setattr__(self, 'request_chat_date', request_chat_date)

    def _bytes(self):
        assert ((self.request_chat_title or self.request_chat_title is not None) and (self.request_chat_date or self.request_chat_date is not None)) or ((self.request_chat_title is None or self.request_chat_title is False) and (self.request_chat_date is None or self.request_chat_date is False)), 'request_chat_title, request_chat_date parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\r\x11\x18\xa5',
            struct.pack('<I', (0 if self.report_spam is None or self.report_spam is False else 1) | (0 if self.add_contact is None or self.add_contact is False else 2) | (0 if self.block_contact is None or self.block_contact is False else 4) | (0 if self.share_contact is None or self.share_contact is False else 8) | (0 if self.need_contacts_exception is None or self.need_contacts_exception is False else 16) | (0 if self.report_geo is None or self.report_geo is False else 32) | (0 if self.autoarchived is None or self.autoarchived is False else 128) | (0 if self.invite_members is None or self.invite_members is False else 256) | (0 if self.request_chat_broadcast is None or self.request_chat_broadcast is False else 1024) | (0 if self.geo_distance is None or self.geo_distance is False else 64) | (0 if self.request_chat_title is None or self.request_chat_title is False else 512) | (0 if self.request_chat_date is None or self.request_chat_date is False else 512)),
            b'' if self.geo_distance is None or self.geo_distance is False else (struct.pack('<i', self.geo_distance)),
            b'' if self.request_chat_title is None or self.request_chat_title is False else (self._serialize_bytes(self.request_chat_title)),
            b'' if self.request_chat_date is None or self.request_chat_date is False else (self._serialize_datetime(self.request_chat_date)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _report_spam = bool(flags & 1)
        _add_contact = bool(flags & 2)
        _block_contact = bool(flags & 4)
        _share_contact = bool(flags & 8)
        _need_contacts_exception = bool(flags & 16)
        _report_geo = bool(flags & 32)
        _autoarchived = bool(flags & 128)
        _invite_members = bool(flags & 256)
        _request_chat_broadcast = bool(flags & 1024)
        if flags & 64:
            _geo_distance = reader.read_int()
        else:
            _geo_distance = None
        if flags & 512:
            _request_chat_title = reader.tgread_string()
        else:
            _request_chat_title = None
        if flags & 512:
            _request_chat_date = reader.tgread_date()
        else:
            _request_chat_date = None
        return cls(report_spam=_report_spam, add_contact=_add_contact, block_contact=_block_contact, share_contact=_share_contact, need_contacts_exception=_need_contacts_exception, report_geo=_report_geo, autoarchived=_autoarchived, invite_members=_invite_members, request_chat_broadcast=_request_chat_broadcast, geo_distance=_geo_distance, request_chat_title=_request_chat_title, request_chat_date=_request_chat_date)


@dataclasses.dataclass(init=False, frozen=True)
class PeerUser(TLObject):
    """
    Constructor for Peer: Instance of either PeerUser, PeerChat, PeerChannel.
    """
    __slots__ = ('user_id',)
    CONSTRUCTOR_ID = 0x59511722
    SUBCLASS_OF_ID = 0x2d45687

    user_id: int
    def __init__(self, user_id: int):
        object.__setattr__(self, 'user_id', user_id)

    def _bytes(self):
        return b''.join((
            b'"\x17QY',
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        return cls(user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class PhoneCall(TLObject):
    """
    Constructor for PhoneCall: Instance of either PhoneCallEmpty, PhoneCallWaiting, PhoneCallRequested, PhoneCallAccepted, PhoneCall, PhoneCallDiscarded.
    """
    __slots__ = ('id', 'access_hash', 'date', 'admin_id', 'participant_id', 'g_a_or_b', 'key_fingerprint', 'protocol', 'connections', 'start_date', 'p2p_allowed', 'video',)
    CONSTRUCTOR_ID = 0x967f7c67
    SUBCLASS_OF_ID = 0xc47f1bd1

    id: int
    access_hash: int
    date: Optional[datetime]
    admin_id: int
    participant_id: int
    g_a_or_b: bytes
    key_fingerprint: int
    protocol: 'TypePhoneCallProtocol'
    connections: List['TypePhoneConnection']
    start_date: Optional[datetime]
    p2p_allowed: Optional[bool]
    video: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, g_a_or_b: bytes, key_fingerprint: int, protocol: 'TypePhoneCallProtocol', connections: List['TypePhoneConnection'], start_date: Optional[datetime], p2p_allowed: Optional[bool]=None, video: Optional[bool]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'admin_id', admin_id)
        object.__setattr__(self, 'participant_id', participant_id)
        object.__setattr__(self, 'g_a_or_b', g_a_or_b)
        object.__setattr__(self, 'key_fingerprint', key_fingerprint)
        object.__setattr__(self, 'protocol', protocol)
        object.__setattr__(self, 'connections', connections)
        object.__setattr__(self, 'start_date', start_date)
        object.__setattr__(self, 'p2p_allowed', p2p_allowed)
        object.__setattr__(self, 'video', video)

    def _bytes(self):
        return b''.join((
            b'g|\x7f\x96',
            struct.pack('<I', (0 if self.p2p_allowed is None or self.p2p_allowed is False else 32) | (0 if self.video is None or self.video is False else 64)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_datetime(self.date),
            struct.pack('<q', self.admin_id),
            struct.pack('<q', self.participant_id),
            self._serialize_bytes(self.g_a_or_b),
            struct.pack('<q', self.key_fingerprint),
            self.protocol._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.connections)),b''.join(x._bytes() for x in self.connections),
            self._serialize_datetime(self.start_date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _p2p_allowed = bool(flags & 32)
        _video = bool(flags & 64)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_long()
        _participant_id = reader.read_long()
        _g_a_or_b = reader.tgread_bytes()
        _key_fingerprint = reader.read_long()
        _protocol = reader.tgread_object()
        reader.read_int()
        _connections = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _connections.append(_x)

        _start_date = reader.tgread_date()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, g_a_or_b=_g_a_or_b, key_fingerprint=_key_fingerprint, protocol=_protocol, connections=_connections, start_date=_start_date, p2p_allowed=_p2p_allowed, video=_video)


@dataclasses.dataclass(init=False, frozen=True)
class PhoneCallAccepted(TLObject):
    """
    Constructor for PhoneCall: Instance of either PhoneCallEmpty, PhoneCallWaiting, PhoneCallRequested, PhoneCallAccepted, PhoneCall, PhoneCallDiscarded.
    """
    __slots__ = ('id', 'access_hash', 'date', 'admin_id', 'participant_id', 'g_b', 'protocol', 'video',)
    CONSTRUCTOR_ID = 0x3660c311
    SUBCLASS_OF_ID = 0xc47f1bd1

    id: int
    access_hash: int
    date: Optional[datetime]
    admin_id: int
    participant_id: int
    g_b: bytes
    protocol: 'TypePhoneCallProtocol'
    video: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, g_b: bytes, protocol: 'TypePhoneCallProtocol', video: Optional[bool]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'admin_id', admin_id)
        object.__setattr__(self, 'participant_id', participant_id)
        object.__setattr__(self, 'g_b', g_b)
        object.__setattr__(self, 'protocol', protocol)
        object.__setattr__(self, 'video', video)

    def _bytes(self):
        return b''.join((
            b'\x11\xc3`6',
            struct.pack('<I', (0 if self.video is None or self.video is False else 64)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_datetime(self.date),
            struct.pack('<q', self.admin_id),
            struct.pack('<q', self.participant_id),
            self._serialize_bytes(self.g_b),
            self.protocol._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 64)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_long()
        _participant_id = reader.read_long()
        _g_b = reader.tgread_bytes()
        _protocol = reader.tgread_object()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, g_b=_g_b, protocol=_protocol, video=_video)


@dataclasses.dataclass(init=False, frozen=True)
class PhoneCallDiscardReasonBusy(TLObject):
    """
    Constructor for PhoneCallDiscardReason: Instance of either PhoneCallDiscardReasonMissed, PhoneCallDiscardReasonDisconnect, PhoneCallDiscardReasonHangup, PhoneCallDiscardReasonBusy.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xfaf7e8c9
    SUBCLASS_OF_ID = 0xd89bad3d

    def _bytes(self):
        return b''.join((
            b'\xc9\xe8\xf7\xfa',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PhoneCallDiscardReasonDisconnect(TLObject):
    """
    Constructor for PhoneCallDiscardReason: Instance of either PhoneCallDiscardReasonMissed, PhoneCallDiscardReasonDisconnect, PhoneCallDiscardReasonHangup, PhoneCallDiscardReasonBusy.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xe095c1a0
    SUBCLASS_OF_ID = 0xd89bad3d

    def _bytes(self):
        return b''.join((
            b'\xa0\xc1\x95\xe0',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PhoneCallDiscardReasonHangup(TLObject):
    """
    Constructor for PhoneCallDiscardReason: Instance of either PhoneCallDiscardReasonMissed, PhoneCallDiscardReasonDisconnect, PhoneCallDiscardReasonHangup, PhoneCallDiscardReasonBusy.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x57adc690
    SUBCLASS_OF_ID = 0xd89bad3d

    def _bytes(self):
        return b''.join((
            b'\x90\xc6\xadW',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PhoneCallDiscardReasonMissed(TLObject):
    """
    Constructor for PhoneCallDiscardReason: Instance of either PhoneCallDiscardReasonMissed, PhoneCallDiscardReasonDisconnect, PhoneCallDiscardReasonHangup, PhoneCallDiscardReasonBusy.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x85e42301
    SUBCLASS_OF_ID = 0xd89bad3d

    def _bytes(self):
        return b''.join((
            b'\x01#\xe4\x85',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PhoneCallDiscarded(TLObject):
    """
    Constructor for PhoneCall: Instance of either PhoneCallEmpty, PhoneCallWaiting, PhoneCallRequested, PhoneCallAccepted, PhoneCall, PhoneCallDiscarded.
    """
    __slots__ = ('id', 'need_rating', 'need_debug', 'video', 'reason', 'duration',)
    CONSTRUCTOR_ID = 0x50ca4de1
    SUBCLASS_OF_ID = 0xc47f1bd1

    id: int
    need_rating: Optional[bool]
    need_debug: Optional[bool]
    video: Optional[bool]
    reason: Optional['TypePhoneCallDiscardReason']
    duration: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, need_rating: Optional[bool]=None, need_debug: Optional[bool]=None, video: Optional[bool]=None, reason: Optional['TypePhoneCallDiscardReason']=None, duration: Optional[int]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'need_rating', need_rating)
        object.__setattr__(self, 'need_debug', need_debug)
        object.__setattr__(self, 'video', video)
        object.__setattr__(self, 'reason', reason)
        object.__setattr__(self, 'duration', duration)

    def _bytes(self):
        return b''.join((
            b'\xe1M\xcaP',
            struct.pack('<I', (0 if self.need_rating is None or self.need_rating is False else 4) | (0 if self.need_debug is None or self.need_debug is False else 8) | (0 if self.video is None or self.video is False else 64) | (0 if self.reason is None or self.reason is False else 1) | (0 if self.duration is None or self.duration is False else 2)),
            struct.pack('<q', self.id),
            b'' if self.reason is None or self.reason is False else (self.reason._bytes()),
            b'' if self.duration is None or self.duration is False else (struct.pack('<i', self.duration)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _need_rating = bool(flags & 4)
        _need_debug = bool(flags & 8)
        _video = bool(flags & 64)
        _id = reader.read_long()
        if flags & 1:
            _reason = reader.tgread_object()
        else:
            _reason = None
        if flags & 2:
            _duration = reader.read_int()
        else:
            _duration = None
        return cls(id=_id, need_rating=_need_rating, need_debug=_need_debug, video=_video, reason=_reason, duration=_duration)


@dataclasses.dataclass(init=False, frozen=True)
class PhoneCallEmpty(TLObject):
    """
    Constructor for PhoneCall: Instance of either PhoneCallEmpty, PhoneCallWaiting, PhoneCallRequested, PhoneCallAccepted, PhoneCall, PhoneCallDiscarded.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x5366c915
    SUBCLASS_OF_ID = 0xc47f1bd1

    id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'\x15\xc9fS',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class PhoneCallProtocol(TLObject):
    """
    Constructor for PhoneCallProtocol: Instance of PhoneCallProtocol.
    """
    __slots__ = ('min_layer', 'max_layer', 'library_versions', 'udp_p2p', 'udp_reflector',)
    CONSTRUCTOR_ID = 0xfc878fc8
    SUBCLASS_OF_ID = 0x783991a3

    min_layer: int
    max_layer: int
    library_versions: List[str]
    udp_p2p: Optional[bool]
    udp_reflector: Optional[bool]
    def __init__(self, min_layer: int, max_layer: int, library_versions: List[str], udp_p2p: Optional[bool]=None, udp_reflector: Optional[bool]=None):
        object.__setattr__(self, 'min_layer', min_layer)
        object.__setattr__(self, 'max_layer', max_layer)
        object.__setattr__(self, 'library_versions', library_versions)
        object.__setattr__(self, 'udp_p2p', udp_p2p)
        object.__setattr__(self, 'udp_reflector', udp_reflector)

    def _bytes(self):
        return b''.join((
            b'\xc8\x8f\x87\xfc',
            struct.pack('<I', (0 if self.udp_p2p is None or self.udp_p2p is False else 1) | (0 if self.udp_reflector is None or self.udp_reflector is False else 2)),
            struct.pack('<i', self.min_layer),
            struct.pack('<i', self.max_layer),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.library_versions)),b''.join(self._serialize_bytes(x) for x in self.library_versions),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _udp_p2p = bool(flags & 1)
        _udp_reflector = bool(flags & 2)
        _min_layer = reader.read_int()
        _max_layer = reader.read_int()
        reader.read_int()
        _library_versions = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _library_versions.append(_x)

        return cls(min_layer=_min_layer, max_layer=_max_layer, library_versions=_library_versions, udp_p2p=_udp_p2p, udp_reflector=_udp_reflector)


@dataclasses.dataclass(init=False, frozen=True)
class PhoneCallRequested(TLObject):
    """
    Constructor for PhoneCall: Instance of either PhoneCallEmpty, PhoneCallWaiting, PhoneCallRequested, PhoneCallAccepted, PhoneCall, PhoneCallDiscarded.
    """
    __slots__ = ('id', 'access_hash', 'date', 'admin_id', 'participant_id', 'g_a_hash', 'protocol', 'video',)
    CONSTRUCTOR_ID = 0x14b0ed0c
    SUBCLASS_OF_ID = 0xc47f1bd1

    id: int
    access_hash: int
    date: Optional[datetime]
    admin_id: int
    participant_id: int
    g_a_hash: bytes
    protocol: 'TypePhoneCallProtocol'
    video: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, g_a_hash: bytes, protocol: 'TypePhoneCallProtocol', video: Optional[bool]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'admin_id', admin_id)
        object.__setattr__(self, 'participant_id', participant_id)
        object.__setattr__(self, 'g_a_hash', g_a_hash)
        object.__setattr__(self, 'protocol', protocol)
        object.__setattr__(self, 'video', video)

    def _bytes(self):
        return b''.join((
            b'\x0c\xed\xb0\x14',
            struct.pack('<I', (0 if self.video is None or self.video is False else 64)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_datetime(self.date),
            struct.pack('<q', self.admin_id),
            struct.pack('<q', self.participant_id),
            self._serialize_bytes(self.g_a_hash),
            self.protocol._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 64)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_long()
        _participant_id = reader.read_long()
        _g_a_hash = reader.tgread_bytes()
        _protocol = reader.tgread_object()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, g_a_hash=_g_a_hash, protocol=_protocol, video=_video)


@dataclasses.dataclass(init=False, frozen=True)
class PhoneCallWaiting(TLObject):
    """
    Constructor for PhoneCall: Instance of either PhoneCallEmpty, PhoneCallWaiting, PhoneCallRequested, PhoneCallAccepted, PhoneCall, PhoneCallDiscarded.
    """
    __slots__ = ('id', 'access_hash', 'date', 'admin_id', 'participant_id', 'protocol', 'video', 'receive_date',)
    CONSTRUCTOR_ID = 0xc5226f17
    SUBCLASS_OF_ID = 0xc47f1bd1

    id: int
    access_hash: int
    date: Optional[datetime]
    admin_id: int
    participant_id: int
    protocol: 'TypePhoneCallProtocol'
    video: Optional[bool]
    receive_date: Optional[datetime]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, protocol: 'TypePhoneCallProtocol', video: Optional[bool]=None, receive_date: Optional[datetime]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'admin_id', admin_id)
        object.__setattr__(self, 'participant_id', participant_id)
        object.__setattr__(self, 'protocol', protocol)
        object.__setattr__(self, 'video', video)
        object.__setattr__(self, 'receive_date', receive_date)

    def _bytes(self):
        return b''.join((
            b'\x17o"\xc5',
            struct.pack('<I', (0 if self.video is None or self.video is False else 64) | (0 if self.receive_date is None or self.receive_date is False else 1)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_datetime(self.date),
            struct.pack('<q', self.admin_id),
            struct.pack('<q', self.participant_id),
            self.protocol._bytes(),
            b'' if self.receive_date is None or self.receive_date is False else (self._serialize_datetime(self.receive_date)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 64)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_long()
        _participant_id = reader.read_long()
        _protocol = reader.tgread_object()
        if flags & 1:
            _receive_date = reader.tgread_date()
        else:
            _receive_date = None
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, protocol=_protocol, video=_video, receive_date=_receive_date)


@dataclasses.dataclass(init=False, frozen=True)
class PhoneConnection(TLObject):
    """
    Constructor for PhoneConnection: Instance of either PhoneConnection, PhoneConnectionWebrtc.
    """
    __slots__ = ('id', 'ip', 'ipv6', 'port', 'peer_tag',)
    CONSTRUCTOR_ID = 0x9d4c17c0
    SUBCLASS_OF_ID = 0xaa8de40d

    id: int
    ip: str
    ipv6: str
    port: int
    peer_tag: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, ip: str, ipv6: str, port: int, peer_tag: bytes):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'ip', ip)
        object.__setattr__(self, 'ipv6', ipv6)
        object.__setattr__(self, 'port', port)
        object.__setattr__(self, 'peer_tag', peer_tag)

    def _bytes(self):
        return b''.join((
            b'\xc0\x17L\x9d',
            struct.pack('<q', self.id),
            self._serialize_bytes(self.ip),
            self._serialize_bytes(self.ipv6),
            struct.pack('<i', self.port),
            self._serialize_bytes(self.peer_tag),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _ip = reader.tgread_string()
        _ipv6 = reader.tgread_string()
        _port = reader.read_int()
        _peer_tag = reader.tgread_bytes()
        return cls(id=_id, ip=_ip, ipv6=_ipv6, port=_port, peer_tag=_peer_tag)


@dataclasses.dataclass(init=False, frozen=True)
class PhoneConnectionWebrtc(TLObject):
    """
    Constructor for PhoneConnection: Instance of either PhoneConnection, PhoneConnectionWebrtc.
    """
    __slots__ = ('id', 'ip', 'ipv6', 'port', 'username', 'password', 'turn', 'stun',)
    CONSTRUCTOR_ID = 0x635fe375
    SUBCLASS_OF_ID = 0xaa8de40d

    id: int
    ip: str
    ipv6: str
    port: int
    username: str
    password: str
    turn: Optional[bool]
    stun: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, ip: str, ipv6: str, port: int, username: str, password: str, turn: Optional[bool]=None, stun: Optional[bool]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'ip', ip)
        object.__setattr__(self, 'ipv6', ipv6)
        object.__setattr__(self, 'port', port)
        object.__setattr__(self, 'username', username)
        object.__setattr__(self, 'password', password)
        object.__setattr__(self, 'turn', turn)
        object.__setattr__(self, 'stun', stun)

    def _bytes(self):
        return b''.join((
            b'u\xe3_c',
            struct.pack('<I', (0 if self.turn is None or self.turn is False else 1) | (0 if self.stun is None or self.stun is False else 2)),
            struct.pack('<q', self.id),
            self._serialize_bytes(self.ip),
            self._serialize_bytes(self.ipv6),
            struct.pack('<i', self.port),
            self._serialize_bytes(self.username),
            self._serialize_bytes(self.password),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _turn = bool(flags & 1)
        _stun = bool(flags & 2)
        _id = reader.read_long()
        _ip = reader.tgread_string()
        _ipv6 = reader.tgread_string()
        _port = reader.read_int()
        _username = reader.tgread_string()
        _password = reader.tgread_string()
        return cls(id=_id, ip=_ip, ipv6=_ipv6, port=_port, username=_username, password=_password, turn=_turn, stun=_stun)


@dataclasses.dataclass(init=False, frozen=True)
class Photo(TLObject):
    """
    Constructor for Photo: Instance of either PhotoEmpty, Photo.
    """
    __slots__ = ('id', 'access_hash', 'file_reference', 'date', 'sizes', 'dc_id', 'has_stickers', 'video_sizes',)
    CONSTRUCTOR_ID = 0xfb197a65
    SUBCLASS_OF_ID = 0xd576ab1c

    id: int
    access_hash: int
    file_reference: bytes
    date: Optional[datetime]
    sizes: List['TypePhotoSize']
    dc_id: int
    has_stickers: Optional[bool]
    video_sizes: Optional[List['TypeVideoSize']]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, date: Optional[datetime], sizes: List['TypePhotoSize'], dc_id: int, has_stickers: Optional[bool]=None, video_sizes: Optional[List['TypeVideoSize']]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'file_reference', file_reference)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'sizes', sizes)
        object.__setattr__(self, 'dc_id', dc_id)
        object.__setattr__(self, 'has_stickers', has_stickers)
        object.__setattr__(self, 'video_sizes', video_sizes)

    def _bytes(self):
        return b''.join((
            b'ez\x19\xfb',
            struct.pack('<I', (0 if self.has_stickers is None or self.has_stickers is False else 1) | (0 if self.video_sizes is None or self.video_sizes is False else 2)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_bytes(self.file_reference),
            self._serialize_datetime(self.date),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sizes)),b''.join(x._bytes() for x in self.sizes),
            b'' if self.video_sizes is None or self.video_sizes is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.video_sizes)),b''.join(x._bytes() for x in self.video_sizes))),
            struct.pack('<i', self.dc_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _has_stickers = bool(flags & 1)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _date = reader.tgread_date()
        reader.read_int()
        _sizes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _sizes.append(_x)

        if flags & 2:
            reader.read_int()
            _video_sizes = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _video_sizes.append(_x)

        else:
            _video_sizes = None
        _dc_id = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, date=_date, sizes=_sizes, dc_id=_dc_id, has_stickers=_has_stickers, video_sizes=_video_sizes)


@dataclasses.dataclass(init=False, frozen=True)
class PhotoCachedSize(TLObject):
    """
    Constructor for PhotoSize: Instance of either PhotoSizeEmpty, PhotoSize, PhotoCachedSize, PhotoStrippedSize, PhotoSizeProgressive, PhotoPathSize.
    """
    __slots__ = ('type', 'w', 'h', 'bytes',)
    CONSTRUCTOR_ID = 0x21e1ad6
    SUBCLASS_OF_ID = 0x17cc29d9

    type: str
    w: int
    h: int
    bytes: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, type: str, w: int, h: int, bytes: bytes):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'w', w)
        object.__setattr__(self, 'h', h)
        object.__setattr__(self, 'bytes', bytes)

    def _bytes(self):
        return b''.join((
            b'\xd6\x1a\x1e\x02',
            self._serialize_bytes(self.type),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
            self._serialize_bytes(self.bytes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_string()
        _w = reader.read_int()
        _h = reader.read_int()
        _bytes = reader.tgread_bytes()
        return cls(type=_type, w=_w, h=_h, bytes=_bytes)


@dataclasses.dataclass(init=False, frozen=True)
class PhotoEmpty(TLObject):
    """
    Constructor for Photo: Instance of either PhotoEmpty, Photo.
    """
    __slots__ = ('id',)
    CONSTRUCTOR_ID = 0x2331b22d
    SUBCLASS_OF_ID = 0xd576ab1c

    id: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        object.__setattr__(self, 'id', id)

    def _bytes(self):
        return b''.join((
            b'-\xb21#',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


@dataclasses.dataclass(init=False, frozen=True)
class PhotoPathSize(TLObject):
    """
    Constructor for PhotoSize: Instance of either PhotoSizeEmpty, PhotoSize, PhotoCachedSize, PhotoStrippedSize, PhotoSizeProgressive, PhotoPathSize.
    """
    __slots__ = ('type', 'bytes',)
    CONSTRUCTOR_ID = 0xd8214d41
    SUBCLASS_OF_ID = 0x17cc29d9

    type: str
    bytes: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, type: str, bytes: bytes):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'bytes', bytes)

    def _bytes(self):
        return b''.join((
            b'AM!\xd8',
            self._serialize_bytes(self.type),
            self._serialize_bytes(self.bytes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_string()
        _bytes = reader.tgread_bytes()
        return cls(type=_type, bytes=_bytes)


@dataclasses.dataclass(init=False, frozen=True)
class PhotoSize(TLObject):
    """
    Constructor for PhotoSize: Instance of either PhotoSizeEmpty, PhotoSize, PhotoCachedSize, PhotoStrippedSize, PhotoSizeProgressive, PhotoPathSize.
    """
    __slots__ = ('type', 'w', 'h', 'size',)
    CONSTRUCTOR_ID = 0x75c78e60
    SUBCLASS_OF_ID = 0x17cc29d9

    type: str
    w: int
    h: int
    size: int
    # noinspection PyShadowingBuiltins
    def __init__(self, type: str, w: int, h: int, size: int):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'w', w)
        object.__setattr__(self, 'h', h)
        object.__setattr__(self, 'size', size)

    def _bytes(self):
        return b''.join((
            b'`\x8e\xc7u',
            self._serialize_bytes(self.type),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
            struct.pack('<i', self.size),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_string()
        _w = reader.read_int()
        _h = reader.read_int()
        _size = reader.read_int()
        return cls(type=_type, w=_w, h=_h, size=_size)


@dataclasses.dataclass(init=False, frozen=True)
class PhotoSizeEmpty(TLObject):
    """
    Constructor for PhotoSize: Instance of either PhotoSizeEmpty, PhotoSize, PhotoCachedSize, PhotoStrippedSize, PhotoSizeProgressive, PhotoPathSize.
    """
    __slots__ = ('type',)
    CONSTRUCTOR_ID = 0xe17e23c
    SUBCLASS_OF_ID = 0x17cc29d9

    type: str
    # noinspection PyShadowingBuiltins
    def __init__(self, type: str):
        object.__setattr__(self, 'type', type)

    def _bytes(self):
        return b''.join((
            b'<\xe2\x17\x0e',
            self._serialize_bytes(self.type),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_string()
        return cls(type=_type)


@dataclasses.dataclass(init=False, frozen=True)
class PhotoSizeProgressive(TLObject):
    """
    Constructor for PhotoSize: Instance of either PhotoSizeEmpty, PhotoSize, PhotoCachedSize, PhotoStrippedSize, PhotoSizeProgressive, PhotoPathSize.
    """
    __slots__ = ('type', 'w', 'h', 'sizes',)
    CONSTRUCTOR_ID = 0xfa3efb95
    SUBCLASS_OF_ID = 0x17cc29d9

    type: str
    w: int
    h: int
    sizes: List[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, type: str, w: int, h: int, sizes: List[int]):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'w', w)
        object.__setattr__(self, 'h', h)
        object.__setattr__(self, 'sizes', sizes)

    def _bytes(self):
        return b''.join((
            b'\x95\xfb>\xfa',
            self._serialize_bytes(self.type),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sizes)),b''.join(struct.pack('<i', x) for x in self.sizes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_string()
        _w = reader.read_int()
        _h = reader.read_int()
        reader.read_int()
        _sizes = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _sizes.append(_x)

        return cls(type=_type, w=_w, h=_h, sizes=_sizes)


@dataclasses.dataclass(init=False, frozen=True)
class PhotoStrippedSize(TLObject):
    """
    Constructor for PhotoSize: Instance of either PhotoSizeEmpty, PhotoSize, PhotoCachedSize, PhotoStrippedSize, PhotoSizeProgressive, PhotoPathSize.
    """
    __slots__ = ('type', 'bytes',)
    CONSTRUCTOR_ID = 0xe0b0bc2e
    SUBCLASS_OF_ID = 0x17cc29d9

    type: str
    bytes: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, type: str, bytes: bytes):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'bytes', bytes)

    def _bytes(self):
        return b''.join((
            b'.\xbc\xb0\xe0',
            self._serialize_bytes(self.type),
            self._serialize_bytes(self.bytes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_string()
        _bytes = reader.tgread_bytes()
        return cls(type=_type, bytes=_bytes)


@dataclasses.dataclass(init=False, frozen=True)
class Poll(TLObject):
    """
    Constructor for Poll: Instance of Poll.
    """
    __slots__ = ('id', 'question', 'answers', 'closed', 'public_voters', 'multiple_choice', 'quiz', 'close_period', 'close_date',)
    CONSTRUCTOR_ID = 0x86e18161
    SUBCLASS_OF_ID = 0x248e557b

    id: int
    question: str
    answers: List['TypePollAnswer']
    closed: Optional[bool]
    public_voters: Optional[bool]
    multiple_choice: Optional[bool]
    quiz: Optional[bool]
    close_period: Optional[int]
    close_date: Optional[datetime]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, question: str, answers: List['TypePollAnswer'], closed: Optional[bool]=None, public_voters: Optional[bool]=None, multiple_choice: Optional[bool]=None, quiz: Optional[bool]=None, close_period: Optional[int]=None, close_date: Optional[datetime]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'question', question)
        object.__setattr__(self, 'answers', answers)
        object.__setattr__(self, 'closed', closed)
        object.__setattr__(self, 'public_voters', public_voters)
        object.__setattr__(self, 'multiple_choice', multiple_choice)
        object.__setattr__(self, 'quiz', quiz)
        object.__setattr__(self, 'close_period', close_period)
        object.__setattr__(self, 'close_date', close_date)

    def _bytes(self):
        return b''.join((
            b'a\x81\xe1\x86',
            struct.pack('<q', self.id),
            struct.pack('<I', (0 if self.closed is None or self.closed is False else 1) | (0 if self.public_voters is None or self.public_voters is False else 2) | (0 if self.multiple_choice is None or self.multiple_choice is False else 4) | (0 if self.quiz is None or self.quiz is False else 8) | (0 if self.close_period is None or self.close_period is False else 16) | (0 if self.close_date is None or self.close_date is False else 32)),
            self._serialize_bytes(self.question),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.answers)),b''.join(x._bytes() for x in self.answers),
            b'' if self.close_period is None or self.close_period is False else (struct.pack('<i', self.close_period)),
            b'' if self.close_date is None or self.close_date is False else (self._serialize_datetime(self.close_date)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        flags = reader.read_int()

        _closed = bool(flags & 1)
        _public_voters = bool(flags & 2)
        _multiple_choice = bool(flags & 4)
        _quiz = bool(flags & 8)
        _question = reader.tgread_string()
        reader.read_int()
        _answers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _answers.append(_x)

        if flags & 16:
            _close_period = reader.read_int()
        else:
            _close_period = None
        if flags & 32:
            _close_date = reader.tgread_date()
        else:
            _close_date = None
        return cls(id=_id, question=_question, answers=_answers, closed=_closed, public_voters=_public_voters, multiple_choice=_multiple_choice, quiz=_quiz, close_period=_close_period, close_date=_close_date)


@dataclasses.dataclass(init=False, frozen=True)
class PollAnswer(TLObject):
    """
    Constructor for PollAnswer: Instance of PollAnswer.
    """
    __slots__ = ('text', 'option',)
    CONSTRUCTOR_ID = 0x6ca9c2e9
    SUBCLASS_OF_ID = 0x7ea5dd9e

    text: str
    option: bytes
    def __init__(self, text: str, option: bytes):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'option', option)

    def _bytes(self):
        return b''.join((
            b'\xe9\xc2\xa9l',
            self._serialize_bytes(self.text),
            self._serialize_bytes(self.option),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_string()
        _option = reader.tgread_bytes()
        return cls(text=_text, option=_option)


@dataclasses.dataclass(init=False, frozen=True)
class PollAnswerVoters(TLObject):
    """
    Constructor for PollAnswerVoters: Instance of PollAnswerVoters.
    """
    __slots__ = ('option', 'voters', 'chosen', 'correct',)
    CONSTRUCTOR_ID = 0x3b6ddad2
    SUBCLASS_OF_ID = 0x7ce0cf91

    option: bytes
    voters: int
    chosen: Optional[bool]
    correct: Optional[bool]
    def __init__(self, option: bytes, voters: int, chosen: Optional[bool]=None, correct: Optional[bool]=None):
        object.__setattr__(self, 'option', option)
        object.__setattr__(self, 'voters', voters)
        object.__setattr__(self, 'chosen', chosen)
        object.__setattr__(self, 'correct', correct)

    def _bytes(self):
        return b''.join((
            b'\xd2\xdam;',
            struct.pack('<I', (0 if self.chosen is None or self.chosen is False else 1) | (0 if self.correct is None or self.correct is False else 2)),
            self._serialize_bytes(self.option),
            struct.pack('<i', self.voters),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _chosen = bool(flags & 1)
        _correct = bool(flags & 2)
        _option = reader.tgread_bytes()
        _voters = reader.read_int()
        return cls(option=_option, voters=_voters, chosen=_chosen, correct=_correct)


@dataclasses.dataclass(init=False, frozen=True)
class PollResults(TLObject):
    """
    Constructor for PollResults: Instance of PollResults.
    """
    __slots__ = ('min', 'results', 'total_voters', 'recent_voters', 'solution', 'solution_entities',)
    CONSTRUCTOR_ID = 0xdcb82ea3
    SUBCLASS_OF_ID = 0xc3b4f687

    min: Optional[bool]
    results: Optional[List['TypePollAnswerVoters']]
    total_voters: Optional[int]
    recent_voters: Optional[List[int]]
    solution: Optional[str]
    solution_entities: Optional[List['TypeMessageEntity']]
    # noinspection PyShadowingBuiltins
    def __init__(self, min: Optional[bool]=None, results: Optional[List['TypePollAnswerVoters']]=None, total_voters: Optional[int]=None, recent_voters: Optional[List[int]]=None, solution: Optional[str]=None, solution_entities: Optional[List['TypeMessageEntity']]=None):
        object.__setattr__(self, 'min', min)
        object.__setattr__(self, 'results', results)
        object.__setattr__(self, 'total_voters', total_voters)
        object.__setattr__(self, 'recent_voters', recent_voters)
        object.__setattr__(self, 'solution', solution)
        object.__setattr__(self, 'solution_entities', solution_entities)

    def _bytes(self):
        assert ((self.solution or self.solution is not None) and (self.solution_entities or self.solution_entities is not None)) or ((self.solution is None or self.solution is False) and (self.solution_entities is None or self.solution_entities is False)), 'solution, solution_entities parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xa3.\xb8\xdc',
            struct.pack('<I', (0 if self.min is None or self.min is False else 1) | (0 if self.results is None or self.results is False else 2) | (0 if self.total_voters is None or self.total_voters is False else 4) | (0 if self.recent_voters is None or self.recent_voters is False else 8) | (0 if self.solution is None or self.solution is False else 16) | (0 if self.solution_entities is None or self.solution_entities is False else 16)),
            b'' if self.results is None or self.results is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.results)),b''.join(x._bytes() for x in self.results))),
            b'' if self.total_voters is None or self.total_voters is False else (struct.pack('<i', self.total_voters)),
            b'' if self.recent_voters is None or self.recent_voters is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.recent_voters)),b''.join(struct.pack('<q', x) for x in self.recent_voters))),
            b'' if self.solution is None or self.solution is False else (self._serialize_bytes(self.solution)),
            b'' if self.solution_entities is None or self.solution_entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.solution_entities)),b''.join(x._bytes() for x in self.solution_entities))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _min = bool(flags & 1)
        if flags & 2:
            reader.read_int()
            _results = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _results.append(_x)

        else:
            _results = None
        if flags & 4:
            _total_voters = reader.read_int()
        else:
            _total_voters = None
        if flags & 8:
            reader.read_int()
            _recent_voters = []
            for _ in range(reader.read_int()):
                _x = reader.read_long()
                _recent_voters.append(_x)

        else:
            _recent_voters = None
        if flags & 16:
            _solution = reader.tgread_string()
        else:
            _solution = None
        if flags & 16:
            reader.read_int()
            _solution_entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _solution_entities.append(_x)

        else:
            _solution_entities = None
        return cls(min=_min, results=_results, total_voters=_total_voters, recent_voters=_recent_voters, solution=_solution, solution_entities=_solution_entities)


@dataclasses.dataclass(init=False, frozen=True)
class Pong(TLObject):
    """
    Constructor for Pong: Instance of Pong.
    """
    __slots__ = ('msg_id', 'ping_id',)
    CONSTRUCTOR_ID = 0x347773c5
    SUBCLASS_OF_ID = 0x816aee71

    msg_id: int
    ping_id: int
    def __init__(self, msg_id: int, ping_id: int):
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'ping_id', ping_id)

    def _bytes(self):
        return b''.join((
            b'\xc5sw4',
            struct.pack('<q', self.msg_id),
            struct.pack('<q', self.ping_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _msg_id = reader.read_long()
        _ping_id = reader.read_long()
        return cls(msg_id=_msg_id, ping_id=_ping_id)


@dataclasses.dataclass(init=False, frozen=True)
class PopularContact(TLObject):
    """
    Constructor for PopularContact: Instance of PopularContact.
    """
    __slots__ = ('client_id', 'importers',)
    CONSTRUCTOR_ID = 0x5ce14175
    SUBCLASS_OF_ID = 0x409255a

    client_id: int
    importers: int
    def __init__(self, client_id: int, importers: int):
        object.__setattr__(self, 'client_id', client_id)
        object.__setattr__(self, 'importers', importers)

    def _bytes(self):
        return b''.join((
            b'uA\xe1\\',
            struct.pack('<q', self.client_id),
            struct.pack('<i', self.importers),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _client_id = reader.read_long()
        _importers = reader.read_int()
        return cls(client_id=_client_id, importers=_importers)


@dataclasses.dataclass(init=False, frozen=True)
class PostAddress(TLObject):
    """
    Constructor for PostAddress: Instance of PostAddress.
    """
    __slots__ = ('street_line1', 'street_line2', 'city', 'state', 'country_iso2', 'post_code',)
    CONSTRUCTOR_ID = 0x1e8caaeb
    SUBCLASS_OF_ID = 0x8d7eda2c

    street_line1: str
    street_line2: str
    city: str
    state: str
    country_iso2: str
    post_code: str
    def __init__(self, street_line1: str, street_line2: str, city: str, state: str, country_iso2: str, post_code: str):
        object.__setattr__(self, 'street_line1', street_line1)
        object.__setattr__(self, 'street_line2', street_line2)
        object.__setattr__(self, 'city', city)
        object.__setattr__(self, 'state', state)
        object.__setattr__(self, 'country_iso2', country_iso2)
        object.__setattr__(self, 'post_code', post_code)

    def _bytes(self):
        return b''.join((
            b'\xeb\xaa\x8c\x1e',
            self._serialize_bytes(self.street_line1),
            self._serialize_bytes(self.street_line2),
            self._serialize_bytes(self.city),
            self._serialize_bytes(self.state),
            self._serialize_bytes(self.country_iso2),
            self._serialize_bytes(self.post_code),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _street_line1 = reader.tgread_string()
        _street_line2 = reader.tgread_string()
        _city = reader.tgread_string()
        _state = reader.tgread_string()
        _country_iso2 = reader.tgread_string()
        _post_code = reader.tgread_string()
        return cls(street_line1=_street_line1, street_line2=_street_line2, city=_city, state=_state, country_iso2=_country_iso2, post_code=_post_code)


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyKeyAddedByPhone(TLObject):
    """
    Constructor for PrivacyKey: Instance of either PrivacyKeyStatusTimestamp, PrivacyKeyChatInvite, PrivacyKeyPhoneCall, PrivacyKeyPhoneP2P, PrivacyKeyForwards, PrivacyKeyProfilePhoto, PrivacyKeyPhoneNumber, PrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x42ffd42b
    SUBCLASS_OF_ID = 0x824651c3

    def _bytes(self):
        return b''.join((
            b'+\xd4\xffB',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyKeyChatInvite(TLObject):
    """
    Constructor for PrivacyKey: Instance of either PrivacyKeyStatusTimestamp, PrivacyKeyChatInvite, PrivacyKeyPhoneCall, PrivacyKeyPhoneP2P, PrivacyKeyForwards, PrivacyKeyProfilePhoto, PrivacyKeyPhoneNumber, PrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x500e6dfa
    SUBCLASS_OF_ID = 0x824651c3

    def _bytes(self):
        return b''.join((
            b'\xfam\x0eP',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyKeyForwards(TLObject):
    """
    Constructor for PrivacyKey: Instance of either PrivacyKeyStatusTimestamp, PrivacyKeyChatInvite, PrivacyKeyPhoneCall, PrivacyKeyPhoneP2P, PrivacyKeyForwards, PrivacyKeyProfilePhoto, PrivacyKeyPhoneNumber, PrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x69ec56a3
    SUBCLASS_OF_ID = 0x824651c3

    def _bytes(self):
        return b''.join((
            b'\xa3V\xeci',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyKeyPhoneCall(TLObject):
    """
    Constructor for PrivacyKey: Instance of either PrivacyKeyStatusTimestamp, PrivacyKeyChatInvite, PrivacyKeyPhoneCall, PrivacyKeyPhoneP2P, PrivacyKeyForwards, PrivacyKeyProfilePhoto, PrivacyKeyPhoneNumber, PrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x3d662b7b
    SUBCLASS_OF_ID = 0x824651c3

    def _bytes(self):
        return b''.join((
            b'{+f=',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyKeyPhoneNumber(TLObject):
    """
    Constructor for PrivacyKey: Instance of either PrivacyKeyStatusTimestamp, PrivacyKeyChatInvite, PrivacyKeyPhoneCall, PrivacyKeyPhoneP2P, PrivacyKeyForwards, PrivacyKeyProfilePhoto, PrivacyKeyPhoneNumber, PrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd19ae46d
    SUBCLASS_OF_ID = 0x824651c3

    def _bytes(self):
        return b''.join((
            b'm\xe4\x9a\xd1',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyKeyPhoneP2P(TLObject):
    """
    Constructor for PrivacyKey: Instance of either PrivacyKeyStatusTimestamp, PrivacyKeyChatInvite, PrivacyKeyPhoneCall, PrivacyKeyPhoneP2P, PrivacyKeyForwards, PrivacyKeyProfilePhoto, PrivacyKeyPhoneNumber, PrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x39491cc8
    SUBCLASS_OF_ID = 0x824651c3

    def _bytes(self):
        return b''.join((
            b'\xc8\x1cI9',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyKeyProfilePhoto(TLObject):
    """
    Constructor for PrivacyKey: Instance of either PrivacyKeyStatusTimestamp, PrivacyKeyChatInvite, PrivacyKeyPhoneCall, PrivacyKeyPhoneP2P, PrivacyKeyForwards, PrivacyKeyProfilePhoto, PrivacyKeyPhoneNumber, PrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x96151fed
    SUBCLASS_OF_ID = 0x824651c3

    def _bytes(self):
        return b''.join((
            b'\xed\x1f\x15\x96',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyKeyStatusTimestamp(TLObject):
    """
    Constructor for PrivacyKey: Instance of either PrivacyKeyStatusTimestamp, PrivacyKeyChatInvite, PrivacyKeyPhoneCall, PrivacyKeyPhoneP2P, PrivacyKeyForwards, PrivacyKeyProfilePhoto, PrivacyKeyPhoneNumber, PrivacyKeyAddedByPhone.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xbc2eab30
    SUBCLASS_OF_ID = 0x824651c3

    def _bytes(self):
        return b''.join((
            b'0\xab.\xbc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyValueAllowAll(TLObject):
    """
    Constructor for PrivacyRule: Instance of either PrivacyValueAllowContacts, PrivacyValueAllowAll, PrivacyValueAllowUsers, PrivacyValueDisallowContacts, PrivacyValueDisallowAll, PrivacyValueDisallowUsers, PrivacyValueAllowChatParticipants, PrivacyValueDisallowChatParticipants.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x65427b82
    SUBCLASS_OF_ID = 0xebb7f270

    def _bytes(self):
        return b''.join((
            b'\x82{Be',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyValueAllowChatParticipants(TLObject):
    """
    Constructor for PrivacyRule: Instance of either PrivacyValueAllowContacts, PrivacyValueAllowAll, PrivacyValueAllowUsers, PrivacyValueDisallowContacts, PrivacyValueDisallowAll, PrivacyValueDisallowUsers, PrivacyValueAllowChatParticipants, PrivacyValueDisallowChatParticipants.
    """
    __slots__ = ('chats',)
    CONSTRUCTOR_ID = 0x6b134e8e
    SUBCLASS_OF_ID = 0xebb7f270

    chats: List[int]
    def __init__(self, chats: List[int]):
        object.__setattr__(self, 'chats', chats)

    def _bytes(self):
        return b''.join((
            b'\x8eN\x13k',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(struct.pack('<q', x) for x in self.chats),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _chats.append(_x)

        return cls(chats=_chats)


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyValueAllowContacts(TLObject):
    """
    Constructor for PrivacyRule: Instance of either PrivacyValueAllowContacts, PrivacyValueAllowAll, PrivacyValueAllowUsers, PrivacyValueDisallowContacts, PrivacyValueDisallowAll, PrivacyValueDisallowUsers, PrivacyValueAllowChatParticipants, PrivacyValueDisallowChatParticipants.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xfffe1bac
    SUBCLASS_OF_ID = 0xebb7f270

    def _bytes(self):
        return b''.join((
            b'\xac\x1b\xfe\xff',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyValueAllowUsers(TLObject):
    """
    Constructor for PrivacyRule: Instance of either PrivacyValueAllowContacts, PrivacyValueAllowAll, PrivacyValueAllowUsers, PrivacyValueDisallowContacts, PrivacyValueDisallowAll, PrivacyValueDisallowUsers, PrivacyValueAllowChatParticipants, PrivacyValueDisallowChatParticipants.
    """
    __slots__ = ('users',)
    CONSTRUCTOR_ID = 0xb8905fb2
    SUBCLASS_OF_ID = 0xebb7f270

    users: List[int]
    def __init__(self, users: List[int]):
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'\xb2_\x90\xb8',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(struct.pack('<q', x) for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _users.append(_x)

        return cls(users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyValueDisallowAll(TLObject):
    """
    Constructor for PrivacyRule: Instance of either PrivacyValueAllowContacts, PrivacyValueAllowAll, PrivacyValueAllowUsers, PrivacyValueDisallowContacts, PrivacyValueDisallowAll, PrivacyValueDisallowUsers, PrivacyValueAllowChatParticipants, PrivacyValueDisallowChatParticipants.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x8b73e763
    SUBCLASS_OF_ID = 0xebb7f270

    def _bytes(self):
        return b''.join((
            b'c\xe7s\x8b',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyValueDisallowChatParticipants(TLObject):
    """
    Constructor for PrivacyRule: Instance of either PrivacyValueAllowContacts, PrivacyValueAllowAll, PrivacyValueAllowUsers, PrivacyValueDisallowContacts, PrivacyValueDisallowAll, PrivacyValueDisallowUsers, PrivacyValueAllowChatParticipants, PrivacyValueDisallowChatParticipants.
    """
    __slots__ = ('chats',)
    CONSTRUCTOR_ID = 0x41c87565
    SUBCLASS_OF_ID = 0xebb7f270

    chats: List[int]
    def __init__(self, chats: List[int]):
        object.__setattr__(self, 'chats', chats)

    def _bytes(self):
        return b''.join((
            b'eu\xc8A',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(struct.pack('<q', x) for x in self.chats),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _chats.append(_x)

        return cls(chats=_chats)


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyValueDisallowContacts(TLObject):
    """
    Constructor for PrivacyRule: Instance of either PrivacyValueAllowContacts, PrivacyValueAllowAll, PrivacyValueAllowUsers, PrivacyValueDisallowContacts, PrivacyValueDisallowAll, PrivacyValueDisallowUsers, PrivacyValueAllowChatParticipants, PrivacyValueDisallowChatParticipants.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xf888fa1a
    SUBCLASS_OF_ID = 0xebb7f270

    def _bytes(self):
        return b''.join((
            b'\x1a\xfa\x88\xf8',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class PrivacyValueDisallowUsers(TLObject):
    """
    Constructor for PrivacyRule: Instance of either PrivacyValueAllowContacts, PrivacyValueAllowAll, PrivacyValueAllowUsers, PrivacyValueDisallowContacts, PrivacyValueDisallowAll, PrivacyValueDisallowUsers, PrivacyValueAllowChatParticipants, PrivacyValueDisallowChatParticipants.
    """
    __slots__ = ('users',)
    CONSTRUCTOR_ID = 0xe4621141
    SUBCLASS_OF_ID = 0xebb7f270

    users: List[int]
    def __init__(self, users: List[int]):
        object.__setattr__(self, 'users', users)

    def _bytes(self):
        return b''.join((
            b'A\x11b\xe4',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(struct.pack('<q', x) for x in self.users),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _users.append(_x)

        return cls(users=_users)


@dataclasses.dataclass(init=False, frozen=True)
class ReactionCount(TLObject):
    """
    Constructor for ReactionCount: Instance of ReactionCount.
    """
    __slots__ = ('reaction', 'count', 'chosen',)
    CONSTRUCTOR_ID = 0x6fb250d1
    SUBCLASS_OF_ID = 0xd208ce3f

    reaction: str
    count: int
    chosen: Optional[bool]
    def __init__(self, reaction: str, count: int, chosen: Optional[bool]=None):
        object.__setattr__(self, 'reaction', reaction)
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'chosen', chosen)

    def _bytes(self):
        return b''.join((
            b'\xd1P\xb2o',
            struct.pack('<I', (0 if self.chosen is None or self.chosen is False else 1)),
            self._serialize_bytes(self.reaction),
            struct.pack('<i', self.count),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _chosen = bool(flags & 1)
        _reaction = reader.tgread_string()
        _count = reader.read_int()
        return cls(reaction=_reaction, count=_count, chosen=_chosen)


@dataclasses.dataclass(init=False, frozen=True)
class ReceivedNotifyMessage(TLObject):
    """
    Constructor for ReceivedNotifyMessage: Instance of ReceivedNotifyMessage.
    """
    __slots__ = ('id', 'flags',)
    CONSTRUCTOR_ID = 0xa384b779
    SUBCLASS_OF_ID = 0xa962381e

    id: int
    flags: int
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, flags: int):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'flags', flags)

    def _bytes(self):
        return b''.join((
            b'y\xb7\x84\xa3',
            struct.pack('<i', self.id),
            struct.pack('<i', self.flags),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_int()
        _flags = reader.read_int()
        return cls(id=_id, flags=_flags)


@dataclasses.dataclass(init=False, frozen=True)
class RecentMeUrlChat(TLObject):
    """
    Constructor for RecentMeUrl: Instance of either RecentMeUrlUnknown, RecentMeUrlUser, RecentMeUrlChat, RecentMeUrlChatInvite, RecentMeUrlStickerSet.
    """
    __slots__ = ('url', 'chat_id',)
    CONSTRUCTOR_ID = 0xb2da71d2
    SUBCLASS_OF_ID = 0x55a53079

    url: str
    chat_id: int
    def __init__(self, url: str, chat_id: int):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'chat_id', chat_id)

    def _bytes(self):
        return b''.join((
            b'\xd2q\xda\xb2',
            self._serialize_bytes(self.url),
            struct.pack('<q', self.chat_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _url = reader.tgread_string()
        _chat_id = reader.read_long()
        return cls(url=_url, chat_id=_chat_id)


@dataclasses.dataclass(init=False, frozen=True)
class RecentMeUrlChatInvite(TLObject):
    """
    Constructor for RecentMeUrl: Instance of either RecentMeUrlUnknown, RecentMeUrlUser, RecentMeUrlChat, RecentMeUrlChatInvite, RecentMeUrlStickerSet.
    """
    __slots__ = ('url', 'chat_invite',)
    CONSTRUCTOR_ID = 0xeb49081d
    SUBCLASS_OF_ID = 0x55a53079

    url: str
    chat_invite: 'TypeChatInvite'
    def __init__(self, url: str, chat_invite: 'TypeChatInvite'):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'chat_invite', chat_invite)

    def _bytes(self):
        return b''.join((
            b'\x1d\x08I\xeb',
            self._serialize_bytes(self.url),
            self.chat_invite._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _url = reader.tgread_string()
        _chat_invite = reader.tgread_object()
        return cls(url=_url, chat_invite=_chat_invite)


@dataclasses.dataclass(init=False, frozen=True)
class RecentMeUrlStickerSet(TLObject):
    """
    Constructor for RecentMeUrl: Instance of either RecentMeUrlUnknown, RecentMeUrlUser, RecentMeUrlChat, RecentMeUrlChatInvite, RecentMeUrlStickerSet.
    """
    __slots__ = ('url', 'set',)
    CONSTRUCTOR_ID = 0xbc0a57dc
    SUBCLASS_OF_ID = 0x55a53079

    url: str
    set: 'TypeStickerSetCovered'
    # noinspection PyShadowingBuiltins
    def __init__(self, url: str, set: 'TypeStickerSetCovered'):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'set', set)

    def _bytes(self):
        return b''.join((
            b'\xdcW\n\xbc',
            self._serialize_bytes(self.url),
            self.set._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _url = reader.tgread_string()
        _set = reader.tgread_object()
        return cls(url=_url, set=_set)


@dataclasses.dataclass(init=False, frozen=True)
class RecentMeUrlUnknown(TLObject):
    """
    Constructor for RecentMeUrl: Instance of either RecentMeUrlUnknown, RecentMeUrlUser, RecentMeUrlChat, RecentMeUrlChatInvite, RecentMeUrlStickerSet.
    """
    __slots__ = ('url',)
    CONSTRUCTOR_ID = 0x46e1d13d
    SUBCLASS_OF_ID = 0x55a53079

    url: str
    def __init__(self, url: str):
        object.__setattr__(self, 'url', url)

    def _bytes(self):
        return b''.join((
            b'=\xd1\xe1F',
            self._serialize_bytes(self.url),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _url = reader.tgread_string()
        return cls(url=_url)


@dataclasses.dataclass(init=False, frozen=True)
class RecentMeUrlUser(TLObject):
    """
    Constructor for RecentMeUrl: Instance of either RecentMeUrlUnknown, RecentMeUrlUser, RecentMeUrlChat, RecentMeUrlChatInvite, RecentMeUrlStickerSet.
    """
    __slots__ = ('url', 'user_id',)
    CONSTRUCTOR_ID = 0xb92c09e2
    SUBCLASS_OF_ID = 0x55a53079

    url: str
    user_id: int
    def __init__(self, url: str, user_id: int):
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'user_id', user_id)

    def _bytes(self):
        return b''.join((
            b'\xe2\t,\xb9',
            self._serialize_bytes(self.url),
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _url = reader.tgread_string()
        _user_id = reader.read_long()
        return cls(url=_url, user_id=_user_id)


@dataclasses.dataclass(init=False, frozen=True)
class ReplyInlineMarkup(TLObject):
    """
    Constructor for ReplyMarkup: Instance of either ReplyKeyboardHide, ReplyKeyboardForceReply, ReplyKeyboardMarkup, ReplyInlineMarkup.
    """
    __slots__ = ('rows',)
    CONSTRUCTOR_ID = 0x48a30254
    SUBCLASS_OF_ID = 0xe2e10ef2

    rows: List['TypeKeyboardButtonRow']
    def __init__(self, rows: List['TypeKeyboardButtonRow']):
        object.__setattr__(self, 'rows', rows)

    def _bytes(self):
        return b''.join((
            b'T\x02\xa3H',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.rows)),b''.join(x._bytes() for x in self.rows),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _rows = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _rows.append(_x)

        return cls(rows=_rows)


@dataclasses.dataclass(init=False, frozen=True)
class ReplyKeyboardForceReply(TLObject):
    """
    Constructor for ReplyMarkup: Instance of either ReplyKeyboardHide, ReplyKeyboardForceReply, ReplyKeyboardMarkup, ReplyInlineMarkup.
    """
    __slots__ = ('single_use', 'selective', 'placeholder',)
    CONSTRUCTOR_ID = 0x86b40b08
    SUBCLASS_OF_ID = 0xe2e10ef2

    single_use: Optional[bool]
    selective: Optional[bool]
    placeholder: Optional[str]
    def __init__(self, single_use: Optional[bool]=None, selective: Optional[bool]=None, placeholder: Optional[str]=None):
        object.__setattr__(self, 'single_use', single_use)
        object.__setattr__(self, 'selective', selective)
        object.__setattr__(self, 'placeholder', placeholder)

    def _bytes(self):
        return b''.join((
            b'\x08\x0b\xb4\x86',
            struct.pack('<I', (0 if self.single_use is None or self.single_use is False else 2) | (0 if self.selective is None or self.selective is False else 4) | (0 if self.placeholder is None or self.placeholder is False else 8)),
            b'' if self.placeholder is None or self.placeholder is False else (self._serialize_bytes(self.placeholder)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _single_use = bool(flags & 2)
        _selective = bool(flags & 4)
        if flags & 8:
            _placeholder = reader.tgread_string()
        else:
            _placeholder = None
        return cls(single_use=_single_use, selective=_selective, placeholder=_placeholder)


@dataclasses.dataclass(init=False, frozen=True)
class ReplyKeyboardHide(TLObject):
    """
    Constructor for ReplyMarkup: Instance of either ReplyKeyboardHide, ReplyKeyboardForceReply, ReplyKeyboardMarkup, ReplyInlineMarkup.
    """
    __slots__ = ('selective',)
    CONSTRUCTOR_ID = 0xa03e5b85
    SUBCLASS_OF_ID = 0xe2e10ef2

    selective: Optional[bool]
    def __init__(self, selective: Optional[bool]=None):
        object.__setattr__(self, 'selective', selective)

    def _bytes(self):
        return b''.join((
            b'\x85[>\xa0',
            struct.pack('<I', (0 if self.selective is None or self.selective is False else 4)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _selective = bool(flags & 4)
        return cls(selective=_selective)


@dataclasses.dataclass(init=False, frozen=True)
class ReplyKeyboardMarkup(TLObject):
    """
    Constructor for ReplyMarkup: Instance of either ReplyKeyboardHide, ReplyKeyboardForceReply, ReplyKeyboardMarkup, ReplyInlineMarkup.
    """
    __slots__ = ('rows', 'resize', 'single_use', 'selective', 'placeholder',)
    CONSTRUCTOR_ID = 0x85dd99d1
    SUBCLASS_OF_ID = 0xe2e10ef2

    rows: List['TypeKeyboardButtonRow']
    resize: Optional[bool]
    single_use: Optional[bool]
    selective: Optional[bool]
    placeholder: Optional[str]
    def __init__(self, rows: List['TypeKeyboardButtonRow'], resize: Optional[bool]=None, single_use: Optional[bool]=None, selective: Optional[bool]=None, placeholder: Optional[str]=None):
        object.__setattr__(self, 'rows', rows)
        object.__setattr__(self, 'resize', resize)
        object.__setattr__(self, 'single_use', single_use)
        object.__setattr__(self, 'selective', selective)
        object.__setattr__(self, 'placeholder', placeholder)

    def _bytes(self):
        return b''.join((
            b'\xd1\x99\xdd\x85',
            struct.pack('<I', (0 if self.resize is None or self.resize is False else 1) | (0 if self.single_use is None or self.single_use is False else 2) | (0 if self.selective is None or self.selective is False else 4) | (0 if self.placeholder is None or self.placeholder is False else 8)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.rows)),b''.join(x._bytes() for x in self.rows),
            b'' if self.placeholder is None or self.placeholder is False else (self._serialize_bytes(self.placeholder)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _resize = bool(flags & 1)
        _single_use = bool(flags & 2)
        _selective = bool(flags & 4)
        reader.read_int()
        _rows = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _rows.append(_x)

        if flags & 8:
            _placeholder = reader.tgread_string()
        else:
            _placeholder = None
        return cls(rows=_rows, resize=_resize, single_use=_single_use, selective=_selective, placeholder=_placeholder)


@dataclasses.dataclass(init=False, frozen=True)
class ResPQ(TLObject):
    """
    Constructor for ResPQ: Instance of ResPQ.
    """
    __slots__ = ('nonce', 'server_nonce', 'pq', 'server_public_key_fingerprints',)
    CONSTRUCTOR_ID = 0x5162463
    SUBCLASS_OF_ID = 0x786986b8

    nonce: int
    server_nonce: int
    pq: bytes
    server_public_key_fingerprints: List[int]
    def __init__(self, nonce: int, server_nonce: int, pq: bytes, server_public_key_fingerprints: List[int]):
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'server_nonce', server_nonce)
        object.__setattr__(self, 'pq', pq)
        object.__setattr__(self, 'server_public_key_fingerprints', server_public_key_fingerprints)

    def _bytes(self):
        return b''.join((
            b'c$\x16\x05',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self._serialize_bytes(self.pq),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.server_public_key_fingerprints)),b''.join(struct.pack('<q', x) for x in self.server_public_key_fingerprints),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _pq = reader.tgread_bytes()
        reader.read_int()
        _server_public_key_fingerprints = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _server_public_key_fingerprints.append(_x)

        return cls(nonce=_nonce, server_nonce=_server_nonce, pq=_pq, server_public_key_fingerprints=_server_public_key_fingerprints)


@dataclasses.dataclass(init=False, frozen=True)
class RestrictionReason(TLObject):
    """
    Constructor for RestrictionReason: Instance of RestrictionReason.
    """
    __slots__ = ('platform', 'reason', 'text',)
    CONSTRUCTOR_ID = 0xd072acb4
    SUBCLASS_OF_ID = 0x6ad95ad

    platform: str
    reason: str
    text: str
    def __init__(self, platform: str, reason: str, text: str):
        object.__setattr__(self, 'platform', platform)
        object.__setattr__(self, 'reason', reason)
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xb4\xacr\xd0',
            self._serialize_bytes(self.platform),
            self._serialize_bytes(self.reason),
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _platform = reader.tgread_string()
        _reason = reader.tgread_string()
        _text = reader.tgread_string()
        return cls(platform=_platform, reason=_reason, text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class RpcAnswerDropped(TLObject):
    """
    Constructor for RpcDropAnswer: Instance of either RpcAnswerUnknown, RpcAnswerDroppedRunning, RpcAnswerDropped.
    """
    __slots__ = ('msg_id', 'seq_no', 'bytes',)
    CONSTRUCTOR_ID = 0xa43ad8b7
    SUBCLASS_OF_ID = 0x4bca7570

    msg_id: int
    seq_no: int
    bytes: int
    # noinspection PyShadowingBuiltins
    def __init__(self, msg_id: int, seq_no: int, bytes: int):
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'seq_no', seq_no)
        object.__setattr__(self, 'bytes', bytes)

    def _bytes(self):
        return b''.join((
            b'\xb7\xd8:\xa4',
            struct.pack('<q', self.msg_id),
            struct.pack('<i', self.seq_no),
            struct.pack('<i', self.bytes),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _msg_id = reader.read_long()
        _seq_no = reader.read_int()
        _bytes = reader.read_int()
        return cls(msg_id=_msg_id, seq_no=_seq_no, bytes=_bytes)


@dataclasses.dataclass(init=False, frozen=True)
class RpcAnswerDroppedRunning(TLObject):
    """
    Constructor for RpcDropAnswer: Instance of either RpcAnswerUnknown, RpcAnswerDroppedRunning, RpcAnswerDropped.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xcd78e586
    SUBCLASS_OF_ID = 0x4bca7570

    def _bytes(self):
        return b''.join((
            b'\x86\xe5x\xcd',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class RpcAnswerUnknown(TLObject):
    """
    Constructor for RpcDropAnswer: Instance of either RpcAnswerUnknown, RpcAnswerDroppedRunning, RpcAnswerDropped.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x5e2ad36e
    SUBCLASS_OF_ID = 0x4bca7570

    def _bytes(self):
        return b''.join((
            b'n\xd3*^',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class RpcError(TLObject):
    """
    Constructor for RpcError: Instance of RpcError.
    """
    __slots__ = ('error_code', 'error_message',)
    CONSTRUCTOR_ID = 0x2144ca19
    SUBCLASS_OF_ID = 0x4a17e265

    error_code: int
    error_message: str
    def __init__(self, error_code: int, error_message: str):
        object.__setattr__(self, 'error_code', error_code)
        object.__setattr__(self, 'error_message', error_message)

    def _bytes(self):
        return b''.join((
            b'\x19\xcaD!',
            struct.pack('<i', self.error_code),
            self._serialize_bytes(self.error_message),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _error_code = reader.read_int()
        _error_message = reader.tgread_string()
        return cls(error_code=_error_code, error_message=_error_message)


@dataclasses.dataclass(init=False, frozen=True)
class SavedPhoneContact(TLObject):
    """
    Constructor for SavedContact: Instance of SavedPhoneContact.
    """
    __slots__ = ('phone', 'first_name', 'last_name', 'date',)
    CONSTRUCTOR_ID = 0x1142bd56
    SUBCLASS_OF_ID = 0x6db98c4

    phone: str
    first_name: str
    last_name: str
    date: Optional[datetime]
    def __init__(self, phone: str, first_name: str, last_name: str, date: Optional[datetime]):
        object.__setattr__(self, 'phone', phone)
        object.__setattr__(self, 'first_name', first_name)
        object.__setattr__(self, 'last_name', last_name)
        object.__setattr__(self, 'date', date)

    def _bytes(self):
        return b''.join((
            b'V\xbdB\x11',
            self._serialize_bytes(self.phone),
            self._serialize_bytes(self.first_name),
            self._serialize_bytes(self.last_name),
            self._serialize_datetime(self.date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _date = reader.tgread_date()
        return cls(phone=_phone, first_name=_first_name, last_name=_last_name, date=_date)


@dataclasses.dataclass(init=False, frozen=True)
class SearchResultPosition(TLObject):
    """
    Constructor for SearchResultsPosition: Instance of SearchResultPosition.
    """
    __slots__ = ('msg_id', 'date', 'offset',)
    CONSTRUCTOR_ID = 0x7f648b67
    SUBCLASS_OF_ID = 0xb8e21614

    msg_id: int
    date: Optional[datetime]
    offset: int
    def __init__(self, msg_id: int, date: Optional[datetime], offset: int):
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'offset', offset)

    def _bytes(self):
        return b''.join((
            b'g\x8bd\x7f',
            struct.pack('<i', self.msg_id),
            self._serialize_datetime(self.date),
            struct.pack('<i', self.offset),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _msg_id = reader.read_int()
        _date = reader.tgread_date()
        _offset = reader.read_int()
        return cls(msg_id=_msg_id, date=_date, offset=_offset)


@dataclasses.dataclass(init=False, frozen=True)
class SearchResultsCalendarPeriod(TLObject):
    """
    Constructor for SearchResultsCalendarPeriod: Instance of SearchResultsCalendarPeriod.
    """
    __slots__ = ('date', 'min_msg_id', 'max_msg_id', 'count',)
    CONSTRUCTOR_ID = 0xc9b0539f
    SUBCLASS_OF_ID = 0xe25cf8ff

    date: Optional[datetime]
    min_msg_id: int
    max_msg_id: int
    count: int
    def __init__(self, date: Optional[datetime], min_msg_id: int, max_msg_id: int, count: int):
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'min_msg_id', min_msg_id)
        object.__setattr__(self, 'max_msg_id', max_msg_id)
        object.__setattr__(self, 'count', count)

    def _bytes(self):
        return b''.join((
            b'\x9fS\xb0\xc9',
            self._serialize_datetime(self.date),
            struct.pack('<i', self.min_msg_id),
            struct.pack('<i', self.max_msg_id),
            struct.pack('<i', self.count),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _date = reader.tgread_date()
        _min_msg_id = reader.read_int()
        _max_msg_id = reader.read_int()
        _count = reader.read_int()
        return cls(date=_date, min_msg_id=_min_msg_id, max_msg_id=_max_msg_id, count=_count)


@dataclasses.dataclass(init=False, frozen=True)
class SecureCredentialsEncrypted(TLObject):
    """
    Constructor for SecureCredentialsEncrypted: Instance of SecureCredentialsEncrypted.
    """
    __slots__ = ('data', 'hash', 'secret',)
    CONSTRUCTOR_ID = 0x33f0ea47
    SUBCLASS_OF_ID = 0x94dc7633

    data: bytes
    hash: bytes
    secret: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, data: bytes, hash: bytes, secret: bytes):
        object.__setattr__(self, 'data', data)
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'secret', secret)

    def _bytes(self):
        return b''.join((
            b'G\xea\xf03',
            self._serialize_bytes(self.data),
            self._serialize_bytes(self.hash),
            self._serialize_bytes(self.secret),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _data = reader.tgread_bytes()
        _hash = reader.tgread_bytes()
        _secret = reader.tgread_bytes()
        return cls(data=_data, hash=_hash, secret=_secret)


@dataclasses.dataclass(init=False, frozen=True)
class SecureData(TLObject):
    """
    Constructor for SecureData: Instance of SecureData.
    """
    __slots__ = ('data', 'data_hash', 'secret',)
    CONSTRUCTOR_ID = 0x8aeabec3
    SUBCLASS_OF_ID = 0x7cd41eb4

    data: bytes
    data_hash: bytes
    secret: bytes
    def __init__(self, data: bytes, data_hash: bytes, secret: bytes):
        object.__setattr__(self, 'data', data)
        object.__setattr__(self, 'data_hash', data_hash)
        object.__setattr__(self, 'secret', secret)

    def _bytes(self):
        return b''.join((
            b'\xc3\xbe\xea\x8a',
            self._serialize_bytes(self.data),
            self._serialize_bytes(self.data_hash),
            self._serialize_bytes(self.secret),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _data = reader.tgread_bytes()
        _data_hash = reader.tgread_bytes()
        _secret = reader.tgread_bytes()
        return cls(data=_data, data_hash=_data_hash, secret=_secret)


@dataclasses.dataclass(init=False, frozen=True)
class SecureFile(TLObject):
    """
    Constructor for SecureFile: Instance of either SecureFileEmpty, SecureFile.
    """
    __slots__ = ('id', 'access_hash', 'size', 'dc_id', 'date', 'file_hash', 'secret',)
    CONSTRUCTOR_ID = 0xe0277a62
    SUBCLASS_OF_ID = 0x5db8dbc7

    id: int
    access_hash: int
    size: int
    dc_id: int
    date: Optional[datetime]
    file_hash: bytes
    secret: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, size: int, dc_id: int, date: Optional[datetime], file_hash: bytes, secret: bytes):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'size', size)
        object.__setattr__(self, 'dc_id', dc_id)
        object.__setattr__(self, 'date', date)
        object.__setattr__(self, 'file_hash', file_hash)
        object.__setattr__(self, 'secret', secret)

    def _bytes(self):
        return b''.join((
            b"bz'\xe0",
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            struct.pack('<i', self.size),
            struct.pack('<i', self.dc_id),
            self._serialize_datetime(self.date),
            self._serialize_bytes(self.file_hash),
            self._serialize_bytes(self.secret),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _size = reader.read_int()
        _dc_id = reader.read_int()
        _date = reader.tgread_date()
        _file_hash = reader.tgread_bytes()
        _secret = reader.tgread_bytes()
        return cls(id=_id, access_hash=_access_hash, size=_size, dc_id=_dc_id, date=_date, file_hash=_file_hash, secret=_secret)


@dataclasses.dataclass(init=False, frozen=True)
class SecureFileEmpty(TLObject):
    """
    Constructor for SecureFile: Instance of either SecureFileEmpty, SecureFile.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x64199744
    SUBCLASS_OF_ID = 0x5db8dbc7

    def _bytes(self):
        return b''.join((
            b'D\x97\x19d',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000(TLObject):
    """
    Constructor for SecurePasswordKdfAlgo: Instance of either SecurePasswordKdfAlgoUnknown, SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000, SecurePasswordKdfAlgoSHA512.
    """
    __slots__ = ('salt',)
    CONSTRUCTOR_ID = 0xbbf2dda0
    SUBCLASS_OF_ID = 0x77262943

    salt: bytes
    def __init__(self, salt: bytes):
        object.__setattr__(self, 'salt', salt)

    def _bytes(self):
        return b''.join((
            b'\xa0\xdd\xf2\xbb',
            self._serialize_bytes(self.salt),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _salt = reader.tgread_bytes()
        return cls(salt=_salt)


@dataclasses.dataclass(init=False, frozen=True)
class SecurePasswordKdfAlgoSHA512(TLObject):
    """
    Constructor for SecurePasswordKdfAlgo: Instance of either SecurePasswordKdfAlgoUnknown, SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000, SecurePasswordKdfAlgoSHA512.
    """
    __slots__ = ('salt',)
    CONSTRUCTOR_ID = 0x86471d92
    SUBCLASS_OF_ID = 0x77262943

    salt: bytes
    def __init__(self, salt: bytes):
        object.__setattr__(self, 'salt', salt)

    def _bytes(self):
        return b''.join((
            b'\x92\x1dG\x86',
            self._serialize_bytes(self.salt),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _salt = reader.tgread_bytes()
        return cls(salt=_salt)


@dataclasses.dataclass(init=False, frozen=True)
class SecurePasswordKdfAlgoUnknown(TLObject):
    """
    Constructor for SecurePasswordKdfAlgo: Instance of either SecurePasswordKdfAlgoUnknown, SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000, SecurePasswordKdfAlgoSHA512.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x4a8537
    SUBCLASS_OF_ID = 0x77262943

    def _bytes(self):
        return b''.join((
            b'7\x85J\x00',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecurePlainEmail(TLObject):
    """
    Constructor for SecurePlainData: Instance of either SecurePlainPhone, SecurePlainEmail.
    """
    __slots__ = ('email',)
    CONSTRUCTOR_ID = 0x21ec5a5f
    SUBCLASS_OF_ID = 0x23b2afb6

    email: str
    def __init__(self, email: str):
        object.__setattr__(self, 'email', email)

    def _bytes(self):
        return b''.join((
            b'_Z\xec!',
            self._serialize_bytes(self.email),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _email = reader.tgread_string()
        return cls(email=_email)


@dataclasses.dataclass(init=False, frozen=True)
class SecurePlainPhone(TLObject):
    """
    Constructor for SecurePlainData: Instance of either SecurePlainPhone, SecurePlainEmail.
    """
    __slots__ = ('phone',)
    CONSTRUCTOR_ID = 0x7d6099dd
    SUBCLASS_OF_ID = 0x23b2afb6

    phone: str
    def __init__(self, phone: str):
        object.__setattr__(self, 'phone', phone)

    def _bytes(self):
        return b''.join((
            b'\xdd\x99`}',
            self._serialize_bytes(self.phone),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _phone = reader.tgread_string()
        return cls(phone=_phone)


@dataclasses.dataclass(init=False, frozen=True)
class SecureRequiredType(TLObject):
    """
    Constructor for SecureRequiredType: Instance of either SecureRequiredType, SecureRequiredTypeOneOf.
    """
    __slots__ = ('type', 'native_names', 'selfie_required', 'translation_required',)
    CONSTRUCTOR_ID = 0x829d99da
    SUBCLASS_OF_ID = 0x7c7b420a

    type: 'TypeSecureValueType'
    native_names: Optional[bool]
    selfie_required: Optional[bool]
    translation_required: Optional[bool]
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', native_names: Optional[bool]=None, selfie_required: Optional[bool]=None, translation_required: Optional[bool]=None):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'native_names', native_names)
        object.__setattr__(self, 'selfie_required', selfie_required)
        object.__setattr__(self, 'translation_required', translation_required)

    def _bytes(self):
        return b''.join((
            b'\xda\x99\x9d\x82',
            struct.pack('<I', (0 if self.native_names is None or self.native_names is False else 1) | (0 if self.selfie_required is None or self.selfie_required is False else 2) | (0 if self.translation_required is None or self.translation_required is False else 4)),
            self.type._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _native_names = bool(flags & 1)
        _selfie_required = bool(flags & 2)
        _translation_required = bool(flags & 4)
        _type = reader.tgread_object()
        return cls(type=_type, native_names=_native_names, selfie_required=_selfie_required, translation_required=_translation_required)


@dataclasses.dataclass(init=False, frozen=True)
class SecureRequiredTypeOneOf(TLObject):
    """
    Constructor for SecureRequiredType: Instance of either SecureRequiredType, SecureRequiredTypeOneOf.
    """
    __slots__ = ('types',)
    CONSTRUCTOR_ID = 0x27477b4
    SUBCLASS_OF_ID = 0x7c7b420a

    types: List['TypeSecureRequiredType']
    def __init__(self, types: List['TypeSecureRequiredType']):
        object.__setattr__(self, 'types', types)

    def _bytes(self):
        return b''.join((
            b'\xb4wt\x02',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.types)),b''.join(x._bytes() for x in self.types),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _types = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _types.append(_x)

        return cls(types=_types)


@dataclasses.dataclass(init=False, frozen=True)
class SecureSecretSettings(TLObject):
    """
    Constructor for SecureSecretSettings: Instance of SecureSecretSettings.
    """
    __slots__ = ('secure_algo', 'secure_secret', 'secure_secret_id',)
    CONSTRUCTOR_ID = 0x1527bcac
    SUBCLASS_OF_ID = 0xc6c802fb

    secure_algo: 'TypeSecurePasswordKdfAlgo'
    secure_secret: bytes
    secure_secret_id: int
    def __init__(self, secure_algo: 'TypeSecurePasswordKdfAlgo', secure_secret: bytes, secure_secret_id: int):
        object.__setattr__(self, 'secure_algo', secure_algo)
        object.__setattr__(self, 'secure_secret', secure_secret)
        object.__setattr__(self, 'secure_secret_id', secure_secret_id)

    def _bytes(self):
        return b''.join((
            b"\xac\xbc'\x15",
            self.secure_algo._bytes(),
            self._serialize_bytes(self.secure_secret),
            struct.pack('<q', self.secure_secret_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _secure_algo = reader.tgread_object()
        _secure_secret = reader.tgread_bytes()
        _secure_secret_id = reader.read_long()
        return cls(secure_algo=_secure_algo, secure_secret=_secure_secret, secure_secret_id=_secure_secret_id)


@dataclasses.dataclass(init=False, frozen=True)
class SecureValue(TLObject):
    """
    Constructor for SecureValue: Instance of SecureValue.
    """
    __slots__ = ('type', 'hash', 'data', 'front_side', 'reverse_side', 'selfie', 'translation', 'files', 'plain_data',)
    CONSTRUCTOR_ID = 0x187fa0ca
    SUBCLASS_OF_ID = 0x51138ae

    type: 'TypeSecureValueType'
    hash: bytes
    data: Optional['TypeSecureData']
    front_side: Optional['TypeSecureFile']
    reverse_side: Optional['TypeSecureFile']
    selfie: Optional['TypeSecureFile']
    translation: Optional[List['TypeSecureFile']]
    files: Optional[List['TypeSecureFile']]
    plain_data: Optional['TypeSecurePlainData']
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', hash: bytes, data: Optional['TypeSecureData']=None, front_side: Optional['TypeSecureFile']=None, reverse_side: Optional['TypeSecureFile']=None, selfie: Optional['TypeSecureFile']=None, translation: Optional[List['TypeSecureFile']]=None, files: Optional[List['TypeSecureFile']]=None, plain_data: Optional['TypeSecurePlainData']=None):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'data', data)
        object.__setattr__(self, 'front_side', front_side)
        object.__setattr__(self, 'reverse_side', reverse_side)
        object.__setattr__(self, 'selfie', selfie)
        object.__setattr__(self, 'translation', translation)
        object.__setattr__(self, 'files', files)
        object.__setattr__(self, 'plain_data', plain_data)

    def _bytes(self):
        return b''.join((
            b'\xca\xa0\x7f\x18',
            struct.pack('<I', (0 if self.data is None or self.data is False else 1) | (0 if self.front_side is None or self.front_side is False else 2) | (0 if self.reverse_side is None or self.reverse_side is False else 4) | (0 if self.selfie is None or self.selfie is False else 8) | (0 if self.translation is None or self.translation is False else 64) | (0 if self.files is None or self.files is False else 16) | (0 if self.plain_data is None or self.plain_data is False else 32)),
            self.type._bytes(),
            b'' if self.data is None or self.data is False else (self.data._bytes()),
            b'' if self.front_side is None or self.front_side is False else (self.front_side._bytes()),
            b'' if self.reverse_side is None or self.reverse_side is False else (self.reverse_side._bytes()),
            b'' if self.selfie is None or self.selfie is False else (self.selfie._bytes()),
            b'' if self.translation is None or self.translation is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.translation)),b''.join(x._bytes() for x in self.translation))),
            b'' if self.files is None or self.files is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.files)),b''.join(x._bytes() for x in self.files))),
            b'' if self.plain_data is None or self.plain_data is False else (self.plain_data._bytes()),
            self._serialize_bytes(self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _type = reader.tgread_object()
        if flags & 1:
            _data = reader.tgread_object()
        else:
            _data = None
        if flags & 2:
            _front_side = reader.tgread_object()
        else:
            _front_side = None
        if flags & 4:
            _reverse_side = reader.tgread_object()
        else:
            _reverse_side = None
        if flags & 8:
            _selfie = reader.tgread_object()
        else:
            _selfie = None
        if flags & 64:
            reader.read_int()
            _translation = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _translation.append(_x)

        else:
            _translation = None
        if flags & 16:
            reader.read_int()
            _files = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _files.append(_x)

        else:
            _files = None
        if flags & 32:
            _plain_data = reader.tgread_object()
        else:
            _plain_data = None
        _hash = reader.tgread_bytes()
        return cls(type=_type, hash=_hash, data=_data, front_side=_front_side, reverse_side=_reverse_side, selfie=_selfie, translation=_translation, files=_files, plain_data=_plain_data)


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueError(TLObject):
    """
    Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
    """
    __slots__ = ('type', 'hash', 'text',)
    CONSTRUCTOR_ID = 0x869d758f
    SUBCLASS_OF_ID = 0x6075fce

    type: 'TypeSecureValueType'
    hash: bytes
    text: str
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', hash: bytes, text: str):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\x8fu\x9d\x86',
            self.type._bytes(),
            self._serialize_bytes(self.hash),
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_object()
        _hash = reader.tgread_bytes()
        _text = reader.tgread_string()
        return cls(type=_type, hash=_hash, text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueErrorData(TLObject):
    """
    Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
    """
    __slots__ = ('type', 'data_hash', 'field', 'text',)
    CONSTRUCTOR_ID = 0xe8a40bd9
    SUBCLASS_OF_ID = 0x6075fce

    type: 'TypeSecureValueType'
    data_hash: bytes
    field: str
    text: str
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', data_hash: bytes, field: str, text: str):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'data_hash', data_hash)
        object.__setattr__(self, 'field', field)
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xd9\x0b\xa4\xe8',
            self.type._bytes(),
            self._serialize_bytes(self.data_hash),
            self._serialize_bytes(self.field),
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_object()
        _data_hash = reader.tgread_bytes()
        _field = reader.tgread_string()
        _text = reader.tgread_string()
        return cls(type=_type, data_hash=_data_hash, field=_field, text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueErrorFile(TLObject):
    """
    Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
    """
    __slots__ = ('type', 'file_hash', 'text',)
    CONSTRUCTOR_ID = 0x7a700873
    SUBCLASS_OF_ID = 0x6075fce

    type: 'TypeSecureValueType'
    file_hash: bytes
    text: str
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: bytes, text: str):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'file_hash', file_hash)
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b's\x08pz',
            self.type._bytes(),
            self._serialize_bytes(self.file_hash),
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_object()
        _file_hash = reader.tgread_bytes()
        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueErrorFiles(TLObject):
    """
    Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
    """
    __slots__ = ('type', 'file_hash', 'text',)
    CONSTRUCTOR_ID = 0x666220e9
    SUBCLASS_OF_ID = 0x6075fce

    type: 'TypeSecureValueType'
    file_hash: List[bytes]
    text: str
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: List[bytes], text: str):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'file_hash', file_hash)
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xe9 bf',
            self.type._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.file_hash)),b''.join(self._serialize_bytes(x) for x in self.file_hash),
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_object()
        reader.read_int()
        _file_hash = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_bytes()
            _file_hash.append(_x)

        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueErrorFrontSide(TLObject):
    """
    Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
    """
    __slots__ = ('type', 'file_hash', 'text',)
    CONSTRUCTOR_ID = 0xbe3dfa
    SUBCLASS_OF_ID = 0x6075fce

    type: 'TypeSecureValueType'
    file_hash: bytes
    text: str
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: bytes, text: str):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'file_hash', file_hash)
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xfa=\xbe\x00',
            self.type._bytes(),
            self._serialize_bytes(self.file_hash),
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_object()
        _file_hash = reader.tgread_bytes()
        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueErrorReverseSide(TLObject):
    """
    Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
    """
    __slots__ = ('type', 'file_hash', 'text',)
    CONSTRUCTOR_ID = 0x868a2aa5
    SUBCLASS_OF_ID = 0x6075fce

    type: 'TypeSecureValueType'
    file_hash: bytes
    text: str
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: bytes, text: str):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'file_hash', file_hash)
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xa5*\x8a\x86',
            self.type._bytes(),
            self._serialize_bytes(self.file_hash),
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_object()
        _file_hash = reader.tgread_bytes()
        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueErrorSelfie(TLObject):
    """
    Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
    """
    __slots__ = ('type', 'file_hash', 'text',)
    CONSTRUCTOR_ID = 0xe537ced6
    SUBCLASS_OF_ID = 0x6075fce

    type: 'TypeSecureValueType'
    file_hash: bytes
    text: str
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: bytes, text: str):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'file_hash', file_hash)
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xd6\xce7\xe5',
            self.type._bytes(),
            self._serialize_bytes(self.file_hash),
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_object()
        _file_hash = reader.tgread_bytes()
        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueErrorTranslationFile(TLObject):
    """
    Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
    """
    __slots__ = ('type', 'file_hash', 'text',)
    CONSTRUCTOR_ID = 0xa1144770
    SUBCLASS_OF_ID = 0x6075fce

    type: 'TypeSecureValueType'
    file_hash: bytes
    text: str
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: bytes, text: str):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'file_hash', file_hash)
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'pG\x14\xa1',
            self.type._bytes(),
            self._serialize_bytes(self.file_hash),
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_object()
        _file_hash = reader.tgread_bytes()
        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueErrorTranslationFiles(TLObject):
    """
    Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
    """
    __slots__ = ('type', 'file_hash', 'text',)
    CONSTRUCTOR_ID = 0x34636dd8
    SUBCLASS_OF_ID = 0x6075fce

    type: 'TypeSecureValueType'
    file_hash: List[bytes]
    text: str
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: List[bytes], text: str):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'file_hash', file_hash)
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xd8mc4',
            self.type._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.file_hash)),b''.join(self._serialize_bytes(x) for x in self.file_hash),
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_object()
        reader.read_int()
        _file_hash = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_bytes()
            _file_hash.append(_x)

        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueHash(TLObject):
    """
    Constructor for SecureValueHash: Instance of SecureValueHash.
    """
    __slots__ = ('type', 'hash',)
    CONSTRUCTOR_ID = 0xed1ecdb0
    SUBCLASS_OF_ID = 0xd5f5c007

    type: 'TypeSecureValueType'
    hash: bytes
    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', hash: bytes):
        object.__setattr__(self, 'type', type)
        object.__setattr__(self, 'hash', hash)

    def _bytes(self):
        return b''.join((
            b'\xb0\xcd\x1e\xed',
            self.type._bytes(),
            self._serialize_bytes(self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _type = reader.tgread_object()
        _hash = reader.tgread_bytes()
        return cls(type=_type, hash=_hash)


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypeAddress(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xcbe31e26
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'&\x1e\xe3\xcb',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypeBankStatement(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x89137c0d
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'\r|\x13\x89',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypeDriverLicense(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x6e425c4
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'\xc4%\xe4\x06',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypeEmail(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x8e3ca7ee
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'\xee\xa7<\x8e',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypeIdentityCard(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xa0d0744b
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'Kt\xd0\xa0',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypeInternalPassport(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x99a48f23
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'#\x8f\xa4\x99',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypePassport(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x3dac6a00
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'\x00j\xac=',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypePassportRegistration(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x99e3806a
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'j\x80\xe3\x99',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypePersonalDetails(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9d2a81e3
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'\xe3\x81*\x9d',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypePhone(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb320aadb
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'\xdb\xaa \xb3',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypeRentalAgreement(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x8b883488
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'\x884\x88\x8b',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypeTemporaryRegistration(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xea02ec33
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'3\xec\x02\xea',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SecureValueTypeUtilityBill(TLObject):
    """
    Constructor for SecureValueType: Instance of either SecureValueTypePersonalDetails, SecureValueTypePassport, SecureValueTypeDriverLicense, SecureValueTypeIdentityCard, SecureValueTypeInternalPassport, SecureValueTypeAddress, SecureValueTypeUtilityBill, SecureValueTypeBankStatement, SecureValueTypeRentalAgreement, SecureValueTypePassportRegistration, SecureValueTypeTemporaryRegistration, SecureValueTypePhone, SecureValueTypeEmail.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xfc36954e
    SUBCLASS_OF_ID = 0x8893f596

    def _bytes(self):
        return b''.join((
            b'N\x956\xfc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageCancelAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xfd5ec8f5
    SUBCLASS_OF_ID = 0x20b2cc21

    def _bytes(self):
        return b''.join((
            b'\xf5\xc8^\xfd',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageChooseContactAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x628cbc6f
    SUBCLASS_OF_ID = 0x20b2cc21

    def _bytes(self):
        return b''.join((
            b'o\xbc\x8cb',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageChooseStickerAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xb05ac6b1
    SUBCLASS_OF_ID = 0x20b2cc21

    def _bytes(self):
        return b''.join((
            b'\xb1\xc6Z\xb0',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageEmojiInteraction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ('emoticon', 'msg_id', 'interaction',)
    CONSTRUCTOR_ID = 0x25972bcb
    SUBCLASS_OF_ID = 0x20b2cc21

    emoticon: str
    msg_id: int
    interaction: 'TypeDataJSON'
    def __init__(self, emoticon: str, msg_id: int, interaction: 'TypeDataJSON'):
        object.__setattr__(self, 'emoticon', emoticon)
        object.__setattr__(self, 'msg_id', msg_id)
        object.__setattr__(self, 'interaction', interaction)

    def _bytes(self):
        return b''.join((
            b'\xcb+\x97%',
            self._serialize_bytes(self.emoticon),
            struct.pack('<i', self.msg_id),
            self.interaction._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _emoticon = reader.tgread_string()
        _msg_id = reader.read_int()
        _interaction = reader.tgread_object()
        return cls(emoticon=_emoticon, msg_id=_msg_id, interaction=_interaction)


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageEmojiInteractionSeen(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ('emoticon',)
    CONSTRUCTOR_ID = 0xb665902e
    SUBCLASS_OF_ID = 0x20b2cc21

    emoticon: str
    def __init__(self, emoticon: str):
        object.__setattr__(self, 'emoticon', emoticon)

    def _bytes(self):
        return b''.join((
            b'.\x90e\xb6',
            self._serialize_bytes(self.emoticon),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _emoticon = reader.tgread_string()
        return cls(emoticon=_emoticon)


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageGamePlayAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xdd6a8f48
    SUBCLASS_OF_ID = 0x20b2cc21

    def _bytes(self):
        return b''.join((
            b'H\x8fj\xdd',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageGeoLocationAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x176f8ba1
    SUBCLASS_OF_ID = 0x20b2cc21

    def _bytes(self):
        return b''.join((
            b'\xa1\x8bo\x17',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageHistoryImportAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ('progress',)
    CONSTRUCTOR_ID = 0xdbda9246
    SUBCLASS_OF_ID = 0x20b2cc21

    progress: int
    def __init__(self, progress: int):
        object.__setattr__(self, 'progress', progress)

    def _bytes(self):
        return b''.join((
            b'F\x92\xda\xdb',
            struct.pack('<i', self.progress),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _progress = reader.read_int()
        return cls(progress=_progress)


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageRecordAudioAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd52f73f7
    SUBCLASS_OF_ID = 0x20b2cc21

    def _bytes(self):
        return b''.join((
            b'\xf7s/\xd5',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageRecordRoundAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x88f27fbc
    SUBCLASS_OF_ID = 0x20b2cc21

    def _bytes(self):
        return b''.join((
            b'\xbc\x7f\xf2\x88',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageRecordVideoAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xa187d66f
    SUBCLASS_OF_ID = 0x20b2cc21

    def _bytes(self):
        return b''.join((
            b'o\xd6\x87\xa1',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageTypingAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x16bf744e
    SUBCLASS_OF_ID = 0x20b2cc21

    def _bytes(self):
        return b''.join((
            b'Nt\xbf\x16',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageUploadAudioAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ('progress',)
    CONSTRUCTOR_ID = 0xf351d7ab
    SUBCLASS_OF_ID = 0x20b2cc21

    progress: int
    def __init__(self, progress: int):
        object.__setattr__(self, 'progress', progress)

    def _bytes(self):
        return b''.join((
            b'\xab\xd7Q\xf3',
            struct.pack('<i', self.progress),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _progress = reader.read_int()
        return cls(progress=_progress)


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageUploadDocumentAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ('progress',)
    CONSTRUCTOR_ID = 0xaa0cd9e4
    SUBCLASS_OF_ID = 0x20b2cc21

    progress: int
    def __init__(self, progress: int):
        object.__setattr__(self, 'progress', progress)

    def _bytes(self):
        return b''.join((
            b'\xe4\xd9\x0c\xaa',
            struct.pack('<i', self.progress),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _progress = reader.read_int()
        return cls(progress=_progress)


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageUploadPhotoAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ('progress',)
    CONSTRUCTOR_ID = 0xd1d34a26
    SUBCLASS_OF_ID = 0x20b2cc21

    progress: int
    def __init__(self, progress: int):
        object.__setattr__(self, 'progress', progress)

    def _bytes(self):
        return b''.join((
            b'&J\xd3\xd1',
            struct.pack('<i', self.progress),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _progress = reader.read_int()
        return cls(progress=_progress)


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageUploadRoundAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ('progress',)
    CONSTRUCTOR_ID = 0x243e1c66
    SUBCLASS_OF_ID = 0x20b2cc21

    progress: int
    def __init__(self, progress: int):
        object.__setattr__(self, 'progress', progress)

    def _bytes(self):
        return b''.join((
            b'f\x1c>$',
            struct.pack('<i', self.progress),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _progress = reader.read_int()
        return cls(progress=_progress)


@dataclasses.dataclass(init=False, frozen=True)
class SendMessageUploadVideoAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ('progress',)
    CONSTRUCTOR_ID = 0xe9763aec
    SUBCLASS_OF_ID = 0x20b2cc21

    progress: int
    def __init__(self, progress: int):
        object.__setattr__(self, 'progress', progress)

    def _bytes(self):
        return b''.join((
            b'\xec:v\xe9',
            struct.pack('<i', self.progress),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _progress = reader.read_int()
        return cls(progress=_progress)


@dataclasses.dataclass(init=False, frozen=True)
class ServerDHInnerData(TLObject):
    """
    Constructor for Server_DH_inner_data: Instance of ServerDHInnerData.
    """
    __slots__ = ('nonce', 'server_nonce', 'g', 'dh_prime', 'g_a', 'server_time',)
    CONSTRUCTOR_ID = 0xb5890dba
    SUBCLASS_OF_ID = 0xc69a67bc

    nonce: int
    server_nonce: int
    g: int
    dh_prime: bytes
    g_a: bytes
    server_time: int
    def __init__(self, nonce: int, server_nonce: int, g: int, dh_prime: bytes, g_a: bytes, server_time: int):
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'server_nonce', server_nonce)
        object.__setattr__(self, 'g', g)
        object.__setattr__(self, 'dh_prime', dh_prime)
        object.__setattr__(self, 'g_a', g_a)
        object.__setattr__(self, 'server_time', server_time)

    def _bytes(self):
        return b''.join((
            b'\xba\r\x89\xb5',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            struct.pack('<i', self.g),
            self._serialize_bytes(self.dh_prime),
            self._serialize_bytes(self.g_a),
            struct.pack('<i', self.server_time),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _g = reader.read_int()
        _dh_prime = reader.tgread_bytes()
        _g_a = reader.tgread_bytes()
        _server_time = reader.read_int()
        return cls(nonce=_nonce, server_nonce=_server_nonce, g=_g, dh_prime=_dh_prime, g_a=_g_a, server_time=_server_time)


@dataclasses.dataclass(init=False, frozen=True)
class ServerDHParamsFail(TLObject):
    """
    Constructor for Server_DH_Params: Instance of either ServerDHParamsFail, ServerDHParamsOk.
    """
    __slots__ = ('nonce', 'server_nonce', 'new_nonce_hash',)
    CONSTRUCTOR_ID = 0x79cb045d
    SUBCLASS_OF_ID = 0xa6188d9e

    nonce: int
    server_nonce: int
    new_nonce_hash: int
    def __init__(self, nonce: int, server_nonce: int, new_nonce_hash: int):
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'server_nonce', server_nonce)
        object.__setattr__(self, 'new_nonce_hash', new_nonce_hash)

    def _bytes(self):
        return b''.join((
            b']\x04\xcby',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce_hash.to_bytes(16, 'little', signed=True),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce_hash = reader.read_large_int(bits=128)
        return cls(nonce=_nonce, server_nonce=_server_nonce, new_nonce_hash=_new_nonce_hash)


@dataclasses.dataclass(init=False, frozen=True)
class ServerDHParamsOk(TLObject):
    """
    Constructor for Server_DH_Params: Instance of either ServerDHParamsFail, ServerDHParamsOk.
    """
    __slots__ = ('nonce', 'server_nonce', 'encrypted_answer',)
    CONSTRUCTOR_ID = 0xd0e8075c
    SUBCLASS_OF_ID = 0xa6188d9e

    nonce: int
    server_nonce: int
    encrypted_answer: bytes
    def __init__(self, nonce: int, server_nonce: int, encrypted_answer: bytes):
        object.__setattr__(self, 'nonce', nonce)
        object.__setattr__(self, 'server_nonce', server_nonce)
        object.__setattr__(self, 'encrypted_answer', encrypted_answer)

    def _bytes(self):
        return b''.join((
            b'\\\x07\xe8\xd0',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self._serialize_bytes(self.encrypted_answer),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _encrypted_answer = reader.tgread_bytes()
        return cls(nonce=_nonce, server_nonce=_server_nonce, encrypted_answer=_encrypted_answer)


@dataclasses.dataclass(init=False, frozen=True)
class ShippingOption(TLObject):
    """
    Constructor for ShippingOption: Instance of ShippingOption.
    """
    __slots__ = ('id', 'title', 'prices',)
    CONSTRUCTOR_ID = 0xb6213cdf
    SUBCLASS_OF_ID = 0xf4e94c78

    id: str
    title: str
    prices: List['TypeLabeledPrice']
    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, title: str, prices: List['TypeLabeledPrice']):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'prices', prices)

    def _bytes(self):
        return b''.join((
            b'\xdf<!\xb6',
            self._serialize_bytes(self.id),
            self._serialize_bytes(self.title),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.prices)),b''.join(x._bytes() for x in self.prices),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _id = reader.tgread_string()
        _title = reader.tgread_string()
        reader.read_int()
        _prices = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _prices.append(_x)

        return cls(id=_id, title=_title, prices=_prices)


@dataclasses.dataclass(init=False, frozen=True)
class SpeakingInGroupCallAction(TLObject):
    """
    Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction, SpeakingInGroupCallAction, SendMessageHistoryImportAction, SendMessageChooseStickerAction, SendMessageEmojiInteraction, SendMessageEmojiInteractionSeen.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xd92c2285
    SUBCLASS_OF_ID = 0x20b2cc21

    def _bytes(self):
        return b''.join((
            b'\x85",\xd9',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class SponsoredMessage(TLObject):
    """
    Constructor for SponsoredMessage: Instance of SponsoredMessage.
    """
    __slots__ = ('message', 'random_id', 'from_id', 'chat_invite', 'chat_invite_hash', 'channel_post', 'start_param', 'entities',)
    CONSTRUCTOR_ID = 0x3a836df8
    SUBCLASS_OF_ID = 0xe157d836

    message: str
    random_id: bytes
    from_id: Optional['TypePeer']
    chat_invite: Optional['TypeChatInvite']
    chat_invite_hash: Optional[str]
    channel_post: Optional[int]
    start_param: Optional[str]
    entities: Optional[List['TypeMessageEntity']]
    def __init__(self, message: str, random_id: bytes=None, from_id: Optional['TypePeer']=None, chat_invite: Optional['TypeChatInvite']=None, chat_invite_hash: Optional[str]=None, channel_post: Optional[int]=None, start_param: Optional[str]=None, entities: Optional[List['TypeMessageEntity']]=None):
        object.__setattr__(self, 'message', message)
        object.__setattr__(self, 'random_id', random_id)
        object.__setattr__(self, 'from_id', from_id)
        object.__setattr__(self, 'chat_invite', chat_invite)
        object.__setattr__(self, 'chat_invite_hash', chat_invite_hash)
        object.__setattr__(self, 'channel_post', channel_post)
        object.__setattr__(self, 'start_param', start_param)
        object.__setattr__(self, 'entities', entities)

    def _bytes(self):
        assert ((self.chat_invite or self.chat_invite is not None) and (self.chat_invite_hash or self.chat_invite_hash is not None)) or ((self.chat_invite is None or self.chat_invite is False) and (self.chat_invite_hash is None or self.chat_invite_hash is False)), 'chat_invite, chat_invite_hash parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xf8m\x83:',
            struct.pack('<I', (0 if self.from_id is None or self.from_id is False else 8) | (0 if self.chat_invite is None or self.chat_invite is False else 16) | (0 if self.chat_invite_hash is None or self.chat_invite_hash is False else 16) | (0 if self.channel_post is None or self.channel_post is False else 4) | (0 if self.start_param is None or self.start_param is False else 1) | (0 if self.entities is None or self.entities is False else 2)),
            self._serialize_bytes(self.random_id),
            b'' if self.from_id is None or self.from_id is False else (self.from_id._bytes()),
            b'' if self.chat_invite is None or self.chat_invite is False else (self.chat_invite._bytes()),
            b'' if self.chat_invite_hash is None or self.chat_invite_hash is False else (self._serialize_bytes(self.chat_invite_hash)),
            b'' if self.channel_post is None or self.channel_post is False else (struct.pack('<i', self.channel_post)),
            b'' if self.start_param is None or self.start_param is False else (self._serialize_bytes(self.start_param)),
            self._serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _random_id = reader.tgread_bytes()
        if flags & 8:
            _from_id = reader.tgread_object()
        else:
            _from_id = None
        if flags & 16:
            _chat_invite = reader.tgread_object()
        else:
            _chat_invite = None
        if flags & 16:
            _chat_invite_hash = reader.tgread_string()
        else:
            _chat_invite_hash = None
        if flags & 4:
            _channel_post = reader.read_int()
        else:
            _channel_post = None
        if flags & 1:
            _start_param = reader.tgread_string()
        else:
            _start_param = None
        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(message=_message, random_id=_random_id, from_id=_from_id, chat_invite=_chat_invite, chat_invite_hash=_chat_invite_hash, channel_post=_channel_post, start_param=_start_param, entities=_entities)


@dataclasses.dataclass(init=False, frozen=True)
class StatsAbsValueAndPrev(TLObject):
    """
    Constructor for StatsAbsValueAndPrev: Instance of StatsAbsValueAndPrev.
    """
    __slots__ = ('current', 'previous',)
    CONSTRUCTOR_ID = 0xcb43acde
    SUBCLASS_OF_ID = 0x3ebe59af

    current: float
    previous: float
    def __init__(self, current: float, previous: float):
        object.__setattr__(self, 'current', current)
        object.__setattr__(self, 'previous', previous)

    def _bytes(self):
        return b''.join((
            b'\xde\xacC\xcb',
            struct.pack('<d', self.current),
            struct.pack('<d', self.previous),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _current = reader.read_double()
        _previous = reader.read_double()
        return cls(current=_current, previous=_previous)


@dataclasses.dataclass(init=False, frozen=True)
class StatsDateRangeDays(TLObject):
    """
    Constructor for StatsDateRangeDays: Instance of StatsDateRangeDays.
    """
    __slots__ = ('min_date', 'max_date',)
    CONSTRUCTOR_ID = 0xb637edaf
    SUBCLASS_OF_ID = 0x81236245

    min_date: Optional[datetime]
    max_date: Optional[datetime]
    def __init__(self, min_date: Optional[datetime], max_date: Optional[datetime]):
        object.__setattr__(self, 'min_date', min_date)
        object.__setattr__(self, 'max_date', max_date)

    def _bytes(self):
        return b''.join((
            b'\xaf\xed7\xb6',
            self._serialize_datetime(self.min_date),
            self._serialize_datetime(self.max_date),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _min_date = reader.tgread_date()
        _max_date = reader.tgread_date()
        return cls(min_date=_min_date, max_date=_max_date)


@dataclasses.dataclass(init=False, frozen=True)
class StatsGraph(TLObject):
    """
    Constructor for StatsGraph: Instance of either StatsGraphAsync, StatsGraphError, StatsGraph.
    """
    __slots__ = ('json', 'zoom_token',)
    CONSTRUCTOR_ID = 0x8ea464b6
    SUBCLASS_OF_ID = 0x9b903153

    json: 'TypeDataJSON'
    zoom_token: Optional[str]
    def __init__(self, json: 'TypeDataJSON', zoom_token: Optional[str]=None):
        object.__setattr__(self, 'json', json)
        object.__setattr__(self, 'zoom_token', zoom_token)

    def _bytes(self):
        return b''.join((
            b'\xb6d\xa4\x8e',
            struct.pack('<I', (0 if self.zoom_token is None or self.zoom_token is False else 1)),
            self.json._bytes(),
            b'' if self.zoom_token is None or self.zoom_token is False else (self._serialize_bytes(self.zoom_token)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _json = reader.tgread_object()
        if flags & 1:
            _zoom_token = reader.tgread_string()
        else:
            _zoom_token = None
        return cls(json=_json, zoom_token=_zoom_token)


@dataclasses.dataclass(init=False, frozen=True)
class StatsGraphAsync(TLObject):
    """
    Constructor for StatsGraph: Instance of either StatsGraphAsync, StatsGraphError, StatsGraph.
    """
    __slots__ = ('token',)
    CONSTRUCTOR_ID = 0x4a27eb2d
    SUBCLASS_OF_ID = 0x9b903153

    token: str
    def __init__(self, token: str):
        object.__setattr__(self, 'token', token)

    def _bytes(self):
        return b''.join((
            b"-\xeb'J",
            self._serialize_bytes(self.token),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _token = reader.tgread_string()
        return cls(token=_token)


@dataclasses.dataclass(init=False, frozen=True)
class StatsGraphError(TLObject):
    """
    Constructor for StatsGraph: Instance of either StatsGraphAsync, StatsGraphError, StatsGraph.
    """
    __slots__ = ('error',)
    CONSTRUCTOR_ID = 0xbedc9822
    SUBCLASS_OF_ID = 0x9b903153

    error: str
    def __init__(self, error: str):
        object.__setattr__(self, 'error', error)

    def _bytes(self):
        return b''.join((
            b'"\x98\xdc\xbe',
            self._serialize_bytes(self.error),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _error = reader.tgread_string()
        return cls(error=_error)


@dataclasses.dataclass(init=False, frozen=True)
class StatsGroupTopAdmin(TLObject):
    """
    Constructor for StatsGroupTopAdmin: Instance of StatsGroupTopAdmin.
    """
    __slots__ = ('user_id', 'deleted', 'kicked', 'banned',)
    CONSTRUCTOR_ID = 0xd7584c87
    SUBCLASS_OF_ID = 0x80359c5d

    user_id: int
    deleted: int
    kicked: int
    banned: int
    def __init__(self, user_id: int, deleted: int, kicked: int, banned: int):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'deleted', deleted)
        object.__setattr__(self, 'kicked', kicked)
        object.__setattr__(self, 'banned', banned)

    def _bytes(self):
        return b''.join((
            b'\x87LX\xd7',
            struct.pack('<q', self.user_id),
            struct.pack('<i', self.deleted),
            struct.pack('<i', self.kicked),
            struct.pack('<i', self.banned),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _deleted = reader.read_int()
        _kicked = reader.read_int()
        _banned = reader.read_int()
        return cls(user_id=_user_id, deleted=_deleted, kicked=_kicked, banned=_banned)


@dataclasses.dataclass(init=False, frozen=True)
class StatsGroupTopInviter(TLObject):
    """
    Constructor for StatsGroupTopInviter: Instance of StatsGroupTopInviter.
    """
    __slots__ = ('user_id', 'invitations',)
    CONSTRUCTOR_ID = 0x535f779d
    SUBCLASS_OF_ID = 0x85010c7a

    user_id: int
    invitations: int
    def __init__(self, user_id: int, invitations: int):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'invitations', invitations)

    def _bytes(self):
        return b''.join((
            b'\x9dw_S',
            struct.pack('<q', self.user_id),
            struct.pack('<i', self.invitations),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _invitations = reader.read_int()
        return cls(user_id=_user_id, invitations=_invitations)


@dataclasses.dataclass(init=False, frozen=True)
class StatsGroupTopPoster(TLObject):
    """
    Constructor for StatsGroupTopPoster: Instance of StatsGroupTopPoster.
    """
    __slots__ = ('user_id', 'messages', 'avg_chars',)
    CONSTRUCTOR_ID = 0x9d04af9b
    SUBCLASS_OF_ID = 0x81c5ce23

    user_id: int
    messages: int
    avg_chars: int
    def __init__(self, user_id: int, messages: int, avg_chars: int):
        object.__setattr__(self, 'user_id', user_id)
        object.__setattr__(self, 'messages', messages)
        object.__setattr__(self, 'avg_chars', avg_chars)

    def _bytes(self):
        return b''.join((
            b'\x9b\xaf\x04\x9d',
            struct.pack('<q', self.user_id),
            struct.pack('<i', self.messages),
            struct.pack('<i', self.avg_chars),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _user_id = reader.read_long()
        _messages = reader.read_int()
        _avg_chars = reader.read_int()
        return cls(user_id=_user_id, messages=_messages, avg_chars=_avg_chars)


@dataclasses.dataclass(init=False, frozen=True)
class StatsPercentValue(TLObject):
    """
    Constructor for StatsPercentValue: Instance of StatsPercentValue.
    """
    __slots__ = ('part', 'total',)
    CONSTRUCTOR_ID = 0xcbce2fe0
    SUBCLASS_OF_ID = 0x9702c51e

    part: float
    total: float
    def __init__(self, part: float, total: float):
        object.__setattr__(self, 'part', part)
        object.__setattr__(self, 'total', total)

    def _bytes(self):
        return b''.join((
            b'\xe0/\xce\xcb',
            struct.pack('<d', self.part),
            struct.pack('<d', self.total),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _part = reader.read_double()
        _total = reader.read_double()
        return cls(part=_part, total=_total)


@dataclasses.dataclass(init=False, frozen=True)
class StatsURL(TLObject):
    """
    Constructor for StatsURL: Instance of StatsURL.
    """
    __slots__ = ('url',)
    CONSTRUCTOR_ID = 0x47a971e0
    SUBCLASS_OF_ID = 0x8d4c94c0

    url: str
    def __init__(self, url: str):
        object.__setattr__(self, 'url', url)

    def _bytes(self):
        return b''.join((
            b'\xe0q\xa9G',
            self._serialize_bytes(self.url),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _url = reader.tgread_string()
        return cls(url=_url)


@dataclasses.dataclass(init=False, frozen=True)
class StickerPack(TLObject):
    """
    Constructor for StickerPack: Instance of StickerPack.
    """
    __slots__ = ('emoticon', 'documents',)
    CONSTRUCTOR_ID = 0x12b299d4
    SUBCLASS_OF_ID = 0x9fefa4d4

    emoticon: str
    documents: List[int]
    def __init__(self, emoticon: str, documents: List[int]):
        object.__setattr__(self, 'emoticon', emoticon)
        object.__setattr__(self, 'documents', documents)

    def _bytes(self):
        return b''.join((
            b'\xd4\x99\xb2\x12',
            self._serialize_bytes(self.emoticon),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.documents)),b''.join(struct.pack('<q', x) for x in self.documents),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _emoticon = reader.tgread_string()
        reader.read_int()
        _documents = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _documents.append(_x)

        return cls(emoticon=_emoticon, documents=_documents)


@dataclasses.dataclass(init=False, frozen=True)
class StickerSet(TLObject):
    """
    Constructor for StickerSet: Instance of StickerSet.
    """
    __slots__ = ('id', 'access_hash', 'title', 'short_name', 'count', 'hash', 'archived', 'official', 'masks', 'animated', 'videos', 'installed_date', 'thumbs', 'thumb_dc_id', 'thumb_version',)
    CONSTRUCTOR_ID = 0xd7df217a
    SUBCLASS_OF_ID = 0xbad3ff91

    id: int
    access_hash: int
    title: str
    short_name: str
    count: int
    hash: int
    archived: Optional[bool]
    official: Optional[bool]
    masks: Optional[bool]
    animated: Optional[bool]
    videos: Optional[bool]
    installed_date: Optional[datetime]
    thumbs: Optional[List['TypePhotoSize']]
    thumb_dc_id: Optional[int]
    thumb_version: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, title: str, short_name: str, count: int, hash: int, archived: Optional[bool]=None, official: Optional[bool]=None, masks: Optional[bool]=None, animated: Optional[bool]=None, videos: Optional[bool]=None, installed_date: Optional[datetime]=None, thumbs: Optional[List['TypePhotoSize']]=None, thumb_dc_id: Optional[int]=None, thumb_version: Optional[int]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'short_name', short_name)
        object.__setattr__(self, 'count', count)
        object.__setattr__(self, 'hash', hash)
        object.__setattr__(self, 'archived', archived)
        object.__setattr__(self, 'official', official)
        object.__setattr__(self, 'masks', masks)
        object.__setattr__(self, 'animated', animated)
        object.__setattr__(self, 'videos', videos)
        object.__setattr__(self, 'installed_date', installed_date)
        object.__setattr__(self, 'thumbs', thumbs)
        object.__setattr__(self, 'thumb_dc_id', thumb_dc_id)
        object.__setattr__(self, 'thumb_version', thumb_version)

    def _bytes(self):
        assert ((self.thumbs or self.thumbs is not None) and (self.thumb_dc_id or self.thumb_dc_id is not None) and (self.thumb_version or self.thumb_version is not None)) or ((self.thumbs is None or self.thumbs is False) and (self.thumb_dc_id is None or self.thumb_dc_id is False) and (self.thumb_version is None or self.thumb_version is False)), 'thumbs, thumb_dc_id, thumb_version parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'z!\xdf\xd7',
            struct.pack('<I', (0 if self.archived is None or self.archived is False else 2) | (0 if self.official is None or self.official is False else 4) | (0 if self.masks is None or self.masks is False else 8) | (0 if self.animated is None or self.animated is False else 32) | (0 if self.videos is None or self.videos is False else 64) | (0 if self.installed_date is None or self.installed_date is False else 1) | (0 if self.thumbs is None or self.thumbs is False else 16) | (0 if self.thumb_dc_id is None or self.thumb_dc_id is False else 16) | (0 if self.thumb_version is None or self.thumb_version is False else 16)),
            b'' if self.installed_date is None or self.installed_date is False else (self._serialize_datetime(self.installed_date)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_bytes(self.title),
            self._serialize_bytes(self.short_name),
            b'' if self.thumbs is None or self.thumbs is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.thumbs)),b''.join(x._bytes() for x in self.thumbs))),
            b'' if self.thumb_dc_id is None or self.thumb_dc_id is False else (struct.pack('<i', self.thumb_dc_id)),
            b'' if self.thumb_version is None or self.thumb_version is False else (struct.pack('<i', self.thumb_version)),
            struct.pack('<i', self.count),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _archived = bool(flags & 2)
        _official = bool(flags & 4)
        _masks = bool(flags & 8)
        _animated = bool(flags & 32)
        _videos = bool(flags & 64)
        if flags & 1:
            _installed_date = reader.tgread_date()
        else:
            _installed_date = None
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _title = reader.tgread_string()
        _short_name = reader.tgread_string()
        if flags & 16:
            reader.read_int()
            _thumbs = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _thumbs.append(_x)

        else:
            _thumbs = None
        if flags & 16:
            _thumb_dc_id = reader.read_int()
        else:
            _thumb_dc_id = None
        if flags & 16:
            _thumb_version = reader.read_int()
        else:
            _thumb_version = None
        _count = reader.read_int()
        _hash = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, title=_title, short_name=_short_name, count=_count, hash=_hash, archived=_archived, official=_official, masks=_masks, animated=_animated, videos=_videos, installed_date=_installed_date, thumbs=_thumbs, thumb_dc_id=_thumb_dc_id, thumb_version=_thumb_version)


@dataclasses.dataclass(init=False, frozen=True)
class StickerSetCovered(TLObject):
    """
    Constructor for StickerSetCovered: Instance of either StickerSetCovered, StickerSetMultiCovered.
    """
    __slots__ = ('set', 'cover',)
    CONSTRUCTOR_ID = 0x6410a5d2
    SUBCLASS_OF_ID = 0x7f86e4e5

    set: 'TypeStickerSet'
    cover: 'TypeDocument'
    # noinspection PyShadowingBuiltins
    def __init__(self, set: 'TypeStickerSet', cover: 'TypeDocument'):
        object.__setattr__(self, 'set', set)
        object.__setattr__(self, 'cover', cover)

    def _bytes(self):
        return b''.join((
            b'\xd2\xa5\x10d',
            self.set._bytes(),
            self.cover._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _set = reader.tgread_object()
        _cover = reader.tgread_object()
        return cls(set=_set, cover=_cover)


@dataclasses.dataclass(init=False, frozen=True)
class StickerSetMultiCovered(TLObject):
    """
    Constructor for StickerSetCovered: Instance of either StickerSetCovered, StickerSetMultiCovered.
    """
    __slots__ = ('set', 'covers',)
    CONSTRUCTOR_ID = 0x3407e51b
    SUBCLASS_OF_ID = 0x7f86e4e5

    set: 'TypeStickerSet'
    covers: List['TypeDocument']
    # noinspection PyShadowingBuiltins
    def __init__(self, set: 'TypeStickerSet', covers: List['TypeDocument']):
        object.__setattr__(self, 'set', set)
        object.__setattr__(self, 'covers', covers)

    def _bytes(self):
        return b''.join((
            b'\x1b\xe5\x074',
            self.set._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.covers)),b''.join(x._bytes() for x in self.covers),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _set = reader.tgread_object()
        reader.read_int()
        _covers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _covers.append(_x)

        return cls(set=_set, covers=_covers)


@dataclasses.dataclass(init=False, frozen=True)
class TextAnchor(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text', 'name',)
    CONSTRUCTOR_ID = 0x35553762
    SUBCLASS_OF_ID = 0xf1d0b479

    text: 'TypeRichText'
    name: str
    def __init__(self, text: 'TypeRichText', name: str):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'name', name)

    def _bytes(self):
        return b''.join((
            b'b7U5',
            self.text._bytes(),
            self._serialize_bytes(self.name),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        _name = reader.tgread_string()
        return cls(text=_text, name=_name)


@dataclasses.dataclass(init=False, frozen=True)
class TextBold(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0x6724abc4
    SUBCLASS_OF_ID = 0xf1d0b479

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xc4\xab$g',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class TextConcat(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('texts',)
    CONSTRUCTOR_ID = 0x7e6260d7
    SUBCLASS_OF_ID = 0xf1d0b479

    texts: List['TypeRichText']
    def __init__(self, texts: List['TypeRichText']):
        object.__setattr__(self, 'texts', texts)

    def _bytes(self):
        return b''.join((
            b'\xd7`b~',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.texts)),b''.join(x._bytes() for x in self.texts),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _texts = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _texts.append(_x)

        return cls(texts=_texts)


@dataclasses.dataclass(init=False, frozen=True)
class TextEmail(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text', 'email',)
    CONSTRUCTOR_ID = 0xde5a0dd6
    SUBCLASS_OF_ID = 0xf1d0b479

    text: 'TypeRichText'
    email: str
    def __init__(self, text: 'TypeRichText', email: str):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'email', email)

    def _bytes(self):
        return b''.join((
            b'\xd6\rZ\xde',
            self.text._bytes(),
            self._serialize_bytes(self.email),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        _email = reader.tgread_string()
        return cls(text=_text, email=_email)


@dataclasses.dataclass(init=False, frozen=True)
class TextEmpty(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0xdc3d824f
    SUBCLASS_OF_ID = 0xf1d0b479

    def _bytes(self):
        return b''.join((
            b'O\x82=\xdc',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class TextFixed(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0x6c3f19b9
    SUBCLASS_OF_ID = 0xf1d0b479

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xb9\x19?l',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class TextImage(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('document_id', 'w', 'h',)
    CONSTRUCTOR_ID = 0x81ccf4f
    SUBCLASS_OF_ID = 0xf1d0b479

    document_id: int
    w: int
    h: int
    def __init__(self, document_id: int, w: int, h: int):
        object.__setattr__(self, 'document_id', document_id)
        object.__setattr__(self, 'w', w)
        object.__setattr__(self, 'h', h)

    def _bytes(self):
        return b''.join((
            b'O\xcf\x1c\x08',
            struct.pack('<q', self.document_id),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _document_id = reader.read_long()
        _w = reader.read_int()
        _h = reader.read_int()
        return cls(document_id=_document_id, w=_w, h=_h)


@dataclasses.dataclass(init=False, frozen=True)
class TextItalic(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0xd912a59c
    SUBCLASS_OF_ID = 0xf1d0b479

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\x9c\xa5\x12\xd9',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class TextMarked(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0x34b8621
    SUBCLASS_OF_ID = 0xf1d0b479

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'!\x86K\x03',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class TextPhone(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text', 'phone',)
    CONSTRUCTOR_ID = 0x1ccb966a
    SUBCLASS_OF_ID = 0xf1d0b479

    text: 'TypeRichText'
    phone: str
    def __init__(self, text: 'TypeRichText', phone: str):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'phone', phone)

    def _bytes(self):
        return b''.join((
            b'j\x96\xcb\x1c',
            self.text._bytes(),
            self._serialize_bytes(self.phone),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        _phone = reader.tgread_string()
        return cls(text=_text, phone=_phone)


@dataclasses.dataclass(init=False, frozen=True)
class TextPlain(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0x744694e0
    SUBCLASS_OF_ID = 0xf1d0b479

    text: str
    def __init__(self, text: str):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xe0\x94Ft',
            self._serialize_bytes(self.text),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class TextStrike(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0x9bf8bb95
    SUBCLASS_OF_ID = 0xf1d0b479

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\x95\xbb\xf8\x9b',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class TextSubscript(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0xed6a8504
    SUBCLASS_OF_ID = 0xf1d0b479

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\x04\x85j\xed',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class TextSuperscript(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0xc7fb5e01
    SUBCLASS_OF_ID = 0xf1d0b479

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\x01^\xfb\xc7',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class TextUnderline(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text',)
    CONSTRUCTOR_ID = 0xc12622c4
    SUBCLASS_OF_ID = 0xf1d0b479

    text: 'TypeRichText'
    def __init__(self, text: 'TypeRichText'):
        object.__setattr__(self, 'text', text)

    def _bytes(self):
        return b''.join((
            b'\xc4"&\xc1',
            self.text._bytes(),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


@dataclasses.dataclass(init=False, frozen=True)
class TextUrl(TLObject):
    """
    Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
    """
    __slots__ = ('text', 'url', 'webpage_id',)
    CONSTRUCTOR_ID = 0x3c2884c1
    SUBCLASS_OF_ID = 0xf1d0b479

    text: 'TypeRichText'
    url: str
    webpage_id: int
    def __init__(self, text: 'TypeRichText', url: str, webpage_id: int):
        object.__setattr__(self, 'text', text)
        object.__setattr__(self, 'url', url)
        object.__setattr__(self, 'webpage_id', webpage_id)

    def _bytes(self):
        return b''.join((
            b'\xc1\x84(<',
            self.text._bytes(),
            self._serialize_bytes(self.url),
            struct.pack('<q', self.webpage_id),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _text = reader.tgread_object()
        _url = reader.tgread_string()
        _webpage_id = reader.read_long()
        return cls(text=_text, url=_url, webpage_id=_webpage_id)


@dataclasses.dataclass(init=False, frozen=True)
class Theme(TLObject):
    """
    Constructor for Theme: Instance of Theme.
    """
    __slots__ = ('id', 'access_hash', 'slug', 'title', 'creator', 'default', 'for_chat', 'document', 'settings', 'emoticon', 'installs_count',)
    CONSTRUCTOR_ID = 0xa00e67d6
    SUBCLASS_OF_ID = 0x56b4c80c

    id: int
    access_hash: int
    slug: str
    title: str
    creator: Optional[bool]
    default: Optional[bool]
    for_chat: Optional[bool]
    document: Optional['TypeDocument']
    settings: Optional[List['TypeThemeSettings']]
    emoticon: Optional[str]
    installs_count: Optional[int]
    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, slug: str, title: str, creator: Optional[bool]=None, default: Optional[bool]=None, for_chat: Optional[bool]=None, document: Optional['TypeDocument']=None, settings: Optional[List['TypeThemeSettings']]=None, emoticon: Optional[str]=None, installs_count: Optional[int]=None):
        object.__setattr__(self, 'id', id)
        object.__setattr__(self, 'access_hash', access_hash)
        object.__setattr__(self, 'slug', slug)
        object.__setattr__(self, 'title', title)
        object.__setattr__(self, 'creator', creator)
        object.__setattr__(self, 'default', default)
        object.__setattr__(self, 'for_chat', for_chat)
        object.__setattr__(self, 'document', document)
        object.__setattr__(self, 'settings', settings)
        object.__setattr__(self, 'emoticon', emoticon)
        object.__setattr__(self, 'installs_count', installs_count)

    def _bytes(self):
        return b''.join((
            b'\xd6g\x0e\xa0',
            struct.pack('<I', (0 if self.creator is None or self.creator is False else 1) | (0 if self.default is None or self.default is False else 2) | (0 if self.for_chat is None or self.for_chat is False else 32) | (0 if self.document is None or self.document is False else 4) | (0 if self.settings is None or self.settings is False else 8) | (0 if self.emoticon is None or self.emoticon is False else 64) | (0 if self.installs_count is None or self.installs_count is False else 16)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self._serialize_bytes(self.slug),
            self._serialize_bytes(self.title),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
            b'' if self.settings is None or self.settings is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.settings)),b''.join(x._bytes() for x in self.settings))),
            b'' if self.emoticon is None or self.emoticon is False else (self._serialize_bytes(self.emoticon)),
            b'' if self.installs_count is None or self.installs_count is False else (struct.pack('<i', self.installs_count)),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _creator = bool(flags & 1)
        _default = bool(flags & 2)
        _for_chat = bool(flags & 32)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _slug = reader.tgread_string()
        _title = reader.tgread_string()
        if flags & 4:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 8:
            reader.read_int()
            _settings = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _settings.append(_x)

        else:
            _settings = None
        if flags & 64:
            _emoticon = reader.tgread_string()
        else:
            _emoticon = None
        if flags & 16:
            _installs_count = reader.read_int()
        else:
            _installs_count = None
        return cls(id=_id, access_hash=_access_hash, slug=_slug, title=_title, creator=_creator, default=_default, for_chat=_for_chat, document=_document, settings=_settings, emoticon=_emoticon, installs_count=_installs_count)


@dataclasses.dataclass(init=False, frozen=True)
class ThemeSettings(TLObject):
    """
    Constructor for ThemeSettings: Instance of ThemeSettings.
    """
    __slots__ = ('base_theme', 'accent_color', 'message_colors_animated', 'outbox_accent_color', 'message_colors', 'wallpaper',)
    CONSTRUCTOR_ID = 0xfa58b6d4
    SUBCLASS_OF_ID = 0x82666d38

    base_theme: 'TypeBaseTheme'
    accent_color: int
    message_colors_animated: Optional[bool]
    outbox_accent_color: Optional[int]
    message_colors: Optional[List[int]]
    wallpaper: Optional['TypeWallPaper']
    def __init__(self, base_theme: 'TypeBaseTheme', accent_color: int, message_colors_animated: Optional[bool]=None, outbox_accent_color: Optional[int]=None, message_colors: Optional[List[int]]=None, wallpaper: Optional['TypeWallPaper']=None):
        object.__setattr__(self, 'base_theme', base_theme)
        object.__setattr__(self, 'accent_color', accent_color)
        object.__setattr__(self, 'message_colors_animated', message_colors_animated)
        object.__setattr__(self, 'outbox_accent_color', outbox_accent_color)
        object.__setattr__(self, 'message_colors', message_colors)
        object.__setattr__(self, 'wallpaper', wallpaper)

    def _bytes(self):
        return b''.join((
            b'\xd4\xb6X\xfa',
            struct.pack('<I', (0 if self.message_colors_animated is None or self.message_colors_animated is False else 4) | (0 if self.outbox_accent_color is None or self.outbox_accent_color is False else 8) | (0 if self.message_colors is None or self.message_colors is False else 1) | (0 if self.wallpaper is None or self.wallpaper is False else 2)),
            self.base_theme._bytes(),
            struct.pack('<i', self.accent_color),
            b'' if self.outbox_accent_color is None or self.outbox_accent_color is False else (struct.pack('<i', self.outbox_accent_color)),
            b'' if self.message_colors is None or self.message_colors is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.message_colors)),b''.join(struct.pack('<i', x) for x in self.message_colors))),
            b'' if self.wallpaper is None or self.wallpaper is False else (self.wallpaper._bytes()),
        ))

    @classmethod
    def _from_reader(cls, reader):
        flags = reader.read_int()

        _message_colors_animated = bool(flags & 4)
        _base_theme = reader.tgread_object()
        _accent_color = reader.read_int()
        if flags & 8:
            _outbox_accent_color = reader.read_int()
        else:
            _outbox_accent_color = None
        if flags & 1:
            reader.read_int()
            _message_colors = []
            for _ in range(reader.read_int()):
                _x = reader.read_int()
                _message_colors.append(_x)

        else:
            _message_colors = None
        if flags & 2:
            _wallpaper = reader.tgread_object()
        else:
            _wallpaper = None
        return cls(base_theme=_base_theme, accent_color=_accent_color, message_colors_animated=_message_colors_animated, outbox_accent_color=_outbox_accent_color, message_colors=_message_colors, wallpaper=_wallpaper)


@dataclasses.dataclass(init=False, frozen=True)
class TlsBlockDomain(TLObject):
    """
    Constructor for TlsBlock: Instance of either TlsBlockString, TlsBlockRandom, TlsBlockZero, TlsBlockDomain, TlsBlockGrease, TlsBlockPublicKey, TlsBlockScope.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x10e8636f
    SUBCLASS_OF_ID = 0xf1163490

    def _bytes(self):
        return b''.join((
            b'oc\xe8\x10',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class TlsBlockGrease(TLObject):
    """
    Constructor for TlsBlock: Instance of either TlsBlockString, TlsBlockRandom, TlsBlockZero, TlsBlockDomain, TlsBlockGrease, TlsBlockPublicKey, TlsBlockScope.
    """
    __slots__ = ('seed',)
    CONSTRUCTOR_ID = 0xe675a1c1
    SUBCLASS_OF_ID = 0xf1163490

    seed: int
    def __init__(self, seed: int):
        object.__setattr__(self, 'seed', seed)

    def _bytes(self):
        return b''.join((
            b'\xc1\xa1u\xe6',
            struct.pack('<i', self.seed),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _seed = reader.read_int()
        return cls(seed=_seed)


@dataclasses.dataclass(init=False, frozen=True)
class TlsBlockPublicKey(TLObject):
    """
    Constructor for TlsBlock: Instance of either TlsBlockString, TlsBlockRandom, TlsBlockZero, TlsBlockDomain, TlsBlockGrease, TlsBlockPublicKey, TlsBlockScope.
    """
    __slots__ = ()
    CONSTRUCTOR_ID = 0x9eb95b5c
    SUBCLASS_OF_ID = 0xf1163490

    def _bytes(self):
        return b''.join((
            b'\\[\xb9\x9e',
        ))

    @classmethod
    def _from_reader(cls, reader):
        return cls()


@dataclasses.dataclass(init=False, frozen=True)
class TlsBlockRandom(TLObject):
    """
    Constructor for TlsBlock: Instance of either TlsBlockString, TlsBlockRandom, TlsBlockZero, TlsBlockDomain, TlsBlockGrease, TlsBlockPublicKey, TlsBlockScope.
    """
    __slots__ = ('length',)
    CONSTRUCTOR_ID = 0x4d4dc41e
    SUBCLASS_OF_ID = 0xf1163490

    length: int
    def __init__(self, length: int):
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\x1e\xc4MM',
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _length = reader.read_int()
        return cls(length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class TlsBlockScope(TLObject):
    """
    Constructor for TlsBlock: Instance of either TlsBlockString, TlsBlockRandom, TlsBlockZero, TlsBlockDomain, TlsBlockGrease, TlsBlockPublicKey, TlsBlockScope.
    """
    __slots__ = ('entries',)
    CONSTRUCTOR_ID = 0xe725d44f
    SUBCLASS_OF_ID = 0xf1163490

    entries: List['TypeTlsBlock']
    def __init__(self, entries: List['TypeTlsBlock']):
        object.__setattr__(self, 'entries', entries)

    def _bytes(self):
        return b''.join((
            b'O\xd4%\xe7',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entries)),b''.join(x._bytes() for x in self.entries),
        ))

    @classmethod
    def _from_reader(cls, reader):
        reader.read_int()
        _entries = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _entries.append(_x)

        return cls(entries=_entries)


@dataclasses.dataclass(init=False, frozen=True)
class TlsBlockString(TLObject):
    """
    Constructor for TlsBlock: Instance of either TlsBlockString, TlsBlockRandom, TlsBlockZero, TlsBlockDomain, TlsBlockGrease, TlsBlockPublicKey, TlsBlockScope.
    """
    __slots__ = ('data',)
    CONSTRUCTOR_ID = 0x4218a164
    SUBCLASS_OF_ID = 0xf1163490

    data: str
    def __init__(self, data: str):
        object.__setattr__(self, 'data', data)

    def _bytes(self):
        return b''.join((
            b'd\xa1\x18B',
            self._serialize_bytes(self.data),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _data = reader.tgread_string()
        return cls(data=_data)


@dataclasses.dataclass(init=False, frozen=True)
class TlsBlockZero(TLObject):
    """
    Constructor for TlsBlock: Instance of either TlsBlockString, TlsBlockRandom, TlsBlockZero, TlsBlockDomain, TlsBlockGrease, TlsBlockPublicKey, TlsBlockScope.
    """
    __slots__ = ('length',)
    CONSTRUCTOR_ID = 0x9333afb
    SUBCLASS_OF_ID = 0xf1163490

    length: int
    def __init__(self, length: int):
        object.__setattr__(self, 'length', length)

    def _bytes(self):
        return b''.join((
            b'\xfb:3\t',
            struct.pack('<i', self.length),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _length = reader.read_int()
        return cls(length=_length)


@dataclasses.dataclass(init=False, frozen=True)
class TlsClientHello(TLObject):
    """
    Constructor for TlsClientHello: Instance of TlsClientHello.
    """
    __slots__ = ('blocks',)
    CONSTRUCTOR_ID = 0x6c52c484
    SUBCLASS_OF_ID = 0xbef20920

    blocks: List['TypeTlsBlock']
    def __init__(self, blocks: List['TypeTlsBlock']):
        object.__setattr__(self, 'blocks', blocks)

    def _bytes(self):
        return b''.join((
            b'\x84\xc4Rl',
            struct.pack('<i', len(self.blocks)),b''.join(x._bytes() for x in self.blocks),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        return cls(blocks=_blocks)


@dataclasses.dataclass(init=False, frozen=True)
class TopPeer(TLObject):
    """
    Constructor for TopPeer: Instance of TopPeer.
    """
    __slots__ = ('peer', 'rating',)
    CONSTRUCTOR_ID = 0xedcdc05b
    SUBCLASS_OF_ID = 0x6916c601

    peer: 'TypePeer'
    rating: float
    def __init__(self, peer: 'TypePeer', rating: float):
        object.__setattr__(self, 'peer', peer)
        object.__setattr__(self, 'rating', rating)

    def _bytes(self):
        return b''.join((
            b'[\xc0\xcd\xed',
            self.peer._bytes(),
            struct.pack('<d', self.rating),
        ))

    @classmethod
    def _from_reader(cls, reader):
        _peer = reader.tgread_object()
        _rating = reader.read_double()
        return cls(peer=_peer, rating=_rating)


@dataclasses.dataclass(init=False, frozen=True)
class TopPeerCategoryBotsInline(TLObject):
    """
    Constructor fo