from typing import Union
from logging import getLogger

from beartype import beartype

from cript.data_model.subobjects.base_subobject import BaseSubobject


logger = getLogger(__name__)


class Parameter(BaseSubobject):
    """Object representing a an input value to an :class:`Algorithm`."""

    node_name = "Parameter"
    alt_names = ["parameters"]

    @beartype
    def __init__(
        self,
        key: str,
        value: Union[int, float],
        unit: Union[str, None] = None,
    ):
        super().__init__()
        self.key = key
        self.unit = unit
        self.value = value
