# jupyter-flex: Easy interactive dashboards for Jupyter

[![PyPI](https://badge.fury.io/py/jupyter-flex.svg)](https://pypi.org/project/jupyter-flex/)
[![Testing](https://github.com/danielfrg/jupyter-flex/workflows/test/badge.svg)](https://github.com/danielfrg/jupyter-flex/actions)
[![Coverage Status](https://codecov.io/gh/danielfrg/jupyter-flex/branch/master/graph/badge.svg)](https://codecov.io/gh/danielfrg/jupyter-flex?branch=master)
[![License](http://img.shields.io/:license-Apache%202-blue.svg)](https://github.com/danielfrg/jupyter-flex/blob/master/LICENSE.txt)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/danielfrg/jupyter-flex/0.6.4)
[![Testing](https://github.com/danielfrg/jupyter-flex/workflows/docs/badge.svg)](https://jupyter-flex.extrapolations.dev/)

Use Jupyter Notebooks to quickly create interactive dashboards.

-   Use Markdown headers and Jupyter Notebook cell tags to define the dashboard layout and its components
-   Flexible and easy way to specify row and column based layouts
-   Use [nbconvert](https://nbconvert.readthedocs.io/en/latest/) to create static reports
-   Use [Voila](https://github.com/voila-dashboards/voila) to start a live Jupyter Kernel for fully dynamic applications
-   Support for [Jupyter widgets](https://ipywidgets.readthedocs.io/en/latest/)

Inspired by [Flex Dashboards](https://rmarkdown.rstudio.com/flexdashboard/).

<a href="https://mybinder.org/v2/gh/danielfrg/jupyter-flex/0.6.4?urlpath=%2Fvoila%2Frender%2Fexamples%2Fmovie-explorer.ipynb"><img src="https://jupyter-flex.extrapolations.dev/assets/img/screenshots/movie-explorer.png" alt="Jupyter-flex: Movie Explorer"  width=276></a>
<a href="https://jupyter-flex.extrapolations.dev/examples/nba-scoring.html"><img src="https://jupyter-flex.extrapolations.dev/assets/img/screenshots/nba-scoring.png" alt="Jupyter-flex: NBA Scoring" width=276></a>
<a href="https://jupyter-flex.extrapolations.dev/examples/altair.html"><img src="https://jupyter-flex.extrapolations.dev/assets/img/screenshots/plots/altair.png" alt="Jupyter-flex: Bokeh plots"  width=276></a>

## Installation

```
pip install jupyter-flex
```

## Learning More

Learn more in the [jupyter-flex documentation](https://jupyter-flex.extrapolations.dev).
