"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineBadgeNotification = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const codePipeline = require("@aws-cdk/aws-codepipeline");
const targets = require("@aws-cdk/aws-events-targets");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const ssm = require("@aws-cdk/aws-ssm");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class CodePipelineBadgeNotification extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g;
        super(scope, id);
        /**
         * @experimental
         */
        this.badgeUrl = '';
        /**
         * @experimental
         */
        this.codePipelineLink = '';
        const pipeline = codePipeline.Pipeline.fromPipelineArn(this, 'CodePipeline', props.pipelineArn);
        const gitHubToken = ((_b = props === null || props === void 0 ? void 0 : props.gitHubTokenFromSecretsManager) === null || _b === void 0 ? void 0 : _b.secretsManagerArn) && ((_c = props === null || props === void 0 ? void 0 : props.gitHubTokenFromSecretsManager) === null || _c === void 0 ? void 0 : _c.secretKey)
            ? cdk.SecretValue.secretsManager(props.gitHubTokenFromSecretsManager.secretsManagerArn, {
                jsonField: props.gitHubTokenFromSecretsManager.secretKey,
            })
            : null;
        const targetLambda = this.createCodePipelineEventLambdaFunction(pipeline.pipelineName, gitHubToken, (_d = props === null || props === void 0 ? void 0 : props.notification) === null || _d === void 0 ? void 0 : _d.stageName, (_e = props === null || props === void 0 ? void 0 : props.notification) === null || _e === void 0 ? void 0 : _e.ssmSlackWebHookUrl, (_f = props === null || props === void 0 ? void 0 : props.notification) === null || _f === void 0 ? void 0 : _f.ssmGoogleChatWebHookUrl, (_g = props === null || props === void 0 ? void 0 : props.notification) === null || _g === void 0 ? void 0 : _g.ssmTelegramWebHookUrl);
        pipeline.onStateChange('CodePipelineChange', {
            eventPattern: {
                source: ['aws.codepipeline'],
                detailType: ['CodePipeline Pipeline Execution State Change'],
            },
            target: new targets.LambdaFunction(targetLambda),
        });
    }
    createCodePipelineEventLambdaFunction(codePipelineName, gitHubToken, stage, ssmSlackWebHookUrl, ssmGoogleChatWebHookUrl, ssmTelegramWebHookUrl) {
        var _b, _c;
        const badgeBucket = new s3.Bucket(this, 'BadgeBucket', {
            publicReadAccess: true,
        });
        const stageKeyName = stage ? `${stage}-` : '';
        const badgeBucketImageKeyName = `${stageKeyName}latest-build.svg`;
        const lambdaFunc = new lambda.DockerImageFunction(this, 'CodepipelineEventLambda', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/codepipeline-event'), {
                cmd: ['codepipelineEventLambda.handler'],
            }),
            environment: {
                STAGE: stage !== null && stage !== void 0 ? stage : '',
                SLACK_WEBHOOK_URL: ssmSlackWebHookUrl ?
                    ssm.StringParameter.valueForStringParameter(this, ssmSlackWebHookUrl) : '',
                GOOGLE_CHAT_WEBHOOK_URL: ssmGoogleChatWebHookUrl ?
                    ssm.StringParameter.valueForStringParameter(this, ssmGoogleChatWebHookUrl) : '',
                TELEGRAM_WEBHOOK_URL: ssmTelegramWebHookUrl ?
                    ssm.StringParameter.valueForStringParameter(this, ssmTelegramWebHookUrl) : '',
                BADGE_BUCKET_NAME: badgeBucket.bucketName,
                BADGE_BUCKET_IMAGE_KEY_NAME: badgeBucketImageKeyName,
                CODE_PIPELINE_NAME: codePipelineName,
                GITHUB_PERSONAL_TOKEN: gitHubToken ? `${gitHubToken}` : '',
            },
            timeout: cdk.Duration.seconds(30),
        });
        badgeBucket.grantReadWrite(lambdaFunc);
        if (ssmSlackWebHookUrl && lambdaFunc.role) {
            lambdaFunc.role.attachInlinePolicy(new iam.Policy(this, 'ssmSlackWebHookUrl', {
                statements: [
                    new iam.PolicyStatement({
                        effect: iam.Effect.ALLOW,
                        actions: ['ssm:GetParameter', 'ssm:GetParameters'],
                        resources: [`arn:aws:ssm:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:parameter/${ssmSlackWebHookUrl}`],
                    }),
                ],
            }));
        }
        if (ssmGoogleChatWebHookUrl && lambdaFunc.role) {
            lambdaFunc.role.attachInlinePolicy(new iam.Policy(this, 'ssmGoogleChatWebHookUrl', {
                statements: [
                    new iam.PolicyStatement({
                        effect: iam.Effect.ALLOW,
                        actions: ['ssm:GetParameter', 'ssm:GetParameters'],
                        resources: [`arn:aws:ssm:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:parameter/${ssmGoogleChatWebHookUrl}`],
                    }),
                ],
            }));
        }
        if (ssmTelegramWebHookUrl && lambdaFunc.role) {
            lambdaFunc.role.attachInlinePolicy(new iam.Policy(this, 'ssmTelegramWebHookUrl', {
                statements: [
                    new iam.PolicyStatement({
                        effect: iam.Effect.ALLOW,
                        actions: ['ssm:GetParameter', 'ssm:GetParameters'],
                        resources: [`arn:aws:ssm:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:parameter/${ssmTelegramWebHookUrl}`],
                    }),
                ],
            }));
        }
        const region = (_b = cdk.Aws.REGION) !== null && _b !== void 0 ? _b : 'ap-northeast-1';
        this.badgeUrl = `https://${badgeBucket.bucketName}.s3-ap-northeast-1.amazonaws.com/${badgeBucketImageKeyName}#1`;
        this.codePipelineLink = `https://${region}.console.aws.amazon.com/codesuite/codepipeline/pipelines/${codePipelineName}/view`;
        new cdk.CfnOutput(this, 'badgeMarkdownLink', {
            value: `[![Build Status](${this.badgeUrl})](${this.codePipelineLink})`,
        });
        (_c = lambdaFunc.role) === null || _c === void 0 ? void 0 : _c.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AWSCodePipeline_ReadOnlyAccess'));
        this.tagResource(lambdaFunc);
        return lambdaFunc;
    }
    tagResource(scope) {
        cdk.Tags.of(scope).add('CDK-CfnStackId', cdk.Aws.STACK_ID);
        cdk.Tags.of(scope).add('CDK-CfnStackName', cdk.Aws.STACK_NAME);
    }
}
exports.CodePipelineBadgeNotification = CodePipelineBadgeNotification;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineBadgeNotification[_a] = { fqn: "cdk-codepipeline-badge-notification.CodePipelineBadgeNotification", version: "0.2.49" };
//# sourceMappingURL=data:application/json;base64,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