# -*- coding: utf-8 -*-
# Generated by Django 1.11.3 on 2017-08-17 00:52
from __future__ import unicode_literals

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Client",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("current_version", models.CharField(editable=False, max_length=255)),
                (
                    "itunes_url",
                    models.CharField(
                        blank=True,
                        help_text="Enter the url to iTunes to automatically pull in new release notes as drafts.",
                        max_length=1000,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name="ReleaseNote",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("notes", models.TextField()),
                ("release_date", models.DateField(default=datetime.datetime.today)),
                (
                    "is_published",
                    models.BooleanField(
                        default=False,
                        help_text="Check this box when you're ready to publish",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("modified", models.DateTimeField(auto_now=True)),
                (
                    "client",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="release_notes",
                        to="product_release_notes.Client",
                    ),
                ),
            ],
            options={
                "ordering": ["-release_date"],
            },
        ),
        migrations.CreateModel(
            name="ReleaseNoteEdit",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("notes", models.TextField()),
                ("is_published", models.BooleanField(default=False)),
                ("edited_at", models.DateTimeField(auto_now=True)),
                (
                    "author",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="releas",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
    ]
