/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ValidationResult {
    private final List<Violation> violations = new ArrayList<Violation>();

    public <T extends Violation> void addViolation(T violation) {
        this.violations.add(violation);
    }

    public List<Violation> getViolations() {
        return Collections.unmodifiableList(this.violations);
    }

    public boolean isValid() {
        return this.violations.isEmpty();
    }

    public static abstract class Violation {
        Violation() {
        }
    }

    public static final class UnexpectedOption
    extends Violation {
        private final String optionName;

        public UnexpectedOption(String optionName) {
            this.optionName = Preconditions.checkNotNull(optionName, "Name of missing option can't be null.");
        }

        public String getOptionName() {
            return this.optionName;
        }
    }

    public static final class OptionMissing
    extends Violation {
        private final String optionName;

        public OptionMissing(String optionName) {
            this.optionName = Preconditions.checkNotNull(optionName, "Name of missing option can't be null.");
        }

        public String getOptionName() {
            return this.optionName;
        }
    }

    public static final class ArgumentMissing
    extends Violation {
    }
}

