/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.cyclopsgroup.jcli.ArgumentProcessorFactory;
import org.cyclopsgroup.jcli.GnuParser;
import org.cyclopsgroup.jcli.ValidationResult;
import org.cyclopsgroup.jcli.spi.CommandLineParser;
import org.cyclopsgroup.jcli.spi.ParsingContext;

public abstract class ArgumentProcessor<T> {
    public static <T> ArgumentProcessor<T> forType(Class<? extends T> beanType) {
        return ArgumentProcessor.newInstance(beanType, new GnuParser());
    }

    public static <T> ArgumentProcessor<T> forTypeOf(T bean) {
        return ArgumentProcessor.forType(bean.getClass());
    }

    public static <T> ArgumentProcessor<T> newInstance(Class<? extends T> beanType, CommandLineParser parser) {
        return ArgumentProcessorFactory.getInstance().newProcessor(beanType, parser);
    }

    public static <T> ArgumentProcessor<T> newInstance(Class<T> beanType) {
        return ArgumentProcessor.forType(beanType);
    }

    public abstract ParsingContext createParsingContext();

    public abstract void printHelp(PrintWriter var1) throws IOException;

    public abstract T process(List<String> var1, T var2);

    public T process(String[] arguments, T bean) {
        return this.process(Arrays.asList(arguments), bean);
    }

    public abstract T processProperties(Properties var1, T var2);

    public abstract ValidationResult validate(String[] var1);
}

