/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.ref;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.cyclopsgroup.caff.ref.AccessFailureException;
import org.cyclopsgroup.caff.ref.ValueReference;

class PropertyValueReference<T>
extends ValueReference<T> {
    private final String name;
    private final Method reader;
    private final boolean readerPublic;
    private final Class<?> type;
    private final Method writer;
    private final boolean writerPublic;

    PropertyValueReference(PropertyDescriptor descriptor) {
        this(descriptor.getName(), descriptor.getPropertyType(), descriptor.getReadMethod(), descriptor.getWriteMethod());
    }

    PropertyValueReference(String name, Class<?> type, @Nullable Method reader, @Nullable Method writer) {
        this.name = Preconditions.checkNotNull(name, "Property name is required.");
        this.type = Preconditions.checkNotNull(type, "Property type is required.");
        this.reader = reader;
        this.readerPublic = reader != null && (reader.getModifiers() & 1) > 0;
        this.writer = writer;
        this.writerPublic = writer != null && (writer.getModifiers() & 1) > 0;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)((Annotation)Arrays.asList(this.reader, this.writer).stream().filter(m -> m != null).map(m -> m.getAnnotation(annotationType)).filter(a -> a != null).findAny().orElse(null));
    }

    @Override
    public ImmutableList<AnnotatedElement> getAnontatedElements() {
        return FluentIterable.of(this.reader, this.writer).filter(e -> e != null).toList();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isReadable() {
        return this.reader != null;
    }

    @Override
    public boolean isWritable() {
        return this.writer != null;
    }

    @Override
    public Object readValue(T owner) {
        if (this.reader == null) {
            throw new IllegalStateException("Property " + this.name + " isn't readable");
        }
        if (!this.readerPublic && !this.reader.isAccessible()) {
            this.reader.setAccessible(true);
        }
        try {
            return this.reader.invoke(owner, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AccessFailureException("Can't read property " + this.name + " from object " + owner, e);
        }
    }

    @Override
    public void writeValue(Object value, T owner) {
        if (this.writer == null) {
            throw new IllegalStateException("Property " + this.name + " isn't writable");
        }
        if (value == null && this.type.isPrimitive()) {
            return;
        }
        if (!this.writerPublic && !this.writer.isAccessible()) {
            this.writer.setAccessible(true);
        }
        try {
            this.writer.invoke(owner, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Can't set property " + this.name + " of object " + owner + " to " + value, e);
        }
    }
}

