/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.caff.format;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.cyclopsgroup.caff.CharArrayCharSequence;
import org.cyclopsgroup.caff.format.InvalidTypeException;

public abstract class Format<T> {
    private final Class<T> beanType;

    protected Format(Class<T> beanType) {
        if (beanType == null) {
            throw new NullPointerException("Type of bean can't be NULL");
        }
        this.beanType = beanType;
    }

    final T createBean() {
        try {
            return this.beanType.newInstance();
        }
        catch (InstantiationException e) {
            throw new InvalidTypeException("Can't create instance of " + this.beanType, e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidTypeException("Can't create instance of " + this.beanType, e);
        }
    }

    public char[] formatToCharArray(T object) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        this.print(object, output);
        output.flush();
        return output.toCharArray();
    }

    public String formatToString(T object) throws IOException {
        return new String(this.formatToCharArray(object));
    }

    public T parse(CharSequence content) throws IOException {
        return this.parse(new CharArrayReader(CharArrayCharSequence.sequenceToArray(content)));
    }

    public T parse(Reader reader) throws IOException {
        T bean = this.createBean();
        this.populate(bean, reader);
        return bean;
    }

    public abstract void populate(T var1, Reader var2) throws IOException;

    public abstract void print(T var1, Writer var2) throws IOException;
}

