"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable no-console */
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
function base62Encode(int) {
    const characterSet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    if (int === 0)
        return '0';
    let s = '';
    while (int > 0) {
        s = characterSet[int % 62] + s;
        int = Math.floor(int / 62);
    }
    return s;
}
;
function getEnv(name) {
    const value = process.env[name];
    if (!value) {
        throw new Error(`The environment variable ${name} is not defined`);
    }
    return value;
}
const documentClient = new aws_sdk_1.DynamoDB.DocumentClient({ apiVersion: '2012-08-10' });
const s3 = new aws_sdk_1.S3({ apiVersion: '2006-03-01' });
async function handler(event) {
    var _a, _b;
    console.log('Event: %j', event);
    const response = {
        statusCode: 201,
        body: '',
        headers: process.env.CORS_ALLOW_ORIGINS
            ? { 'Access-Control-Allow-Origin': process.env.CORS_ALLOW_ORIGINS }
            : undefined,
    };
    try {
        const body = JSON.parse((_a = event.body) !== null && _a !== void 0 ? _a : '{}');
        if (!body.url) {
            return {
                ...response,
                statusCode: 400,
            };
        }
        // Get next counter value
        const update = await documentClient.update({
            TableName: getEnv('TABLE_NAME'),
            Key: { key: 'counter' },
            UpdateExpression: 'ADD #value :incr',
            ExpressionAttributeNames: { '#value': 'value' },
            ExpressionAttributeValues: { ':incr': 1 },
            ReturnValues: 'UPDATED_NEW',
        }).promise();
        const value = (_b = update.Attributes) === null || _b === void 0 ? void 0 : _b.value;
        if (!value) {
            throw new Error('Cannot get next counter value');
        }
        const key = base62Encode(value);
        console.log('Key: %j', key);
        const putObject = await s3.putObject({
            Bucket: getEnv('BUCKET_NAME'),
            Key: key,
            ContentType: 'text/html',
            Body: `<html><head><meta http-equiv="Refresh" content="0;url=${body.url}"/></head></html>`,
        }).promise();
        console.log('Put object: %j', putObject);
        // Return short url
        return {
            ...response,
            body: JSON.stringify({
                url: body.url,
                shortUrl: `https://${getEnv('DOMAIN_NAME')}/${key}`,
            }),
        };
    }
    catch (err) {
        console.log(err);
        return {
            ...response,
            statusCode: 500,
        };
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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