"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const path = require("path");
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
const s3 = new aws_sdk_1.S3();
async function handler(assetHashes) {
    var _a;
    if (!process.env.BUCKET_NAME) {
        throw new Error('Missing BUCKET_NAME');
    }
    let deleted = 0;
    let reclaimed = 0;
    let nextToken;
    let finished = false;
    while (!finished) {
        const response = await s3.listObjectsV2({
            Bucket: process.env.BUCKET_NAME,
            ContinuationToken: nextToken,
        }).promise();
        const toDelete = (_a = response.Contents) === null || _a === void 0 ? void 0 : _a.filter(x => {
            if (!x.Key) {
                return false;
            }
            const hash = path.basename(x.Key, path.extname(x.Key));
            let pred = !assetHashes.includes(hash);
            if (process.env.RETAIN_MILLISECONDS) {
                if (!x.LastModified) {
                    return false;
                }
                const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
                pred = pred && x.LastModified < limitDate;
            }
            return pred;
        });
        if (toDelete && toDelete.length !== 0) {
            if (process.env.RUN) {
                await s3.deleteObjects({
                    Bucket: process.env.BUCKET_NAME,
                    Delete: {
                        Objects: toDelete.map(x => ({ Key: x.Key })),
                    },
                }).promise();
            }
            deleted += toDelete.length;
            reclaimed += toDelete.reduce((acc, x) => { var _a; return acc + ((_a = x.Size) !== null && _a !== void 0 ? _a : 0); }, 0);
        }
        nextToken = response.NextContinuationToken;
        if (nextToken === undefined) {
            finished = true;
        }
    }
    return {
        Deleted: deleted,
        Reclaimed: reclaimed,
    };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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