/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable.reference;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jf.dexlib2.base.reference.BaseCallSiteReference;
import org.jf.dexlib2.iface.reference.CallSiteReference;
import org.jf.dexlib2.iface.reference.MethodHandleReference;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.immutable.reference.ImmutableMethodHandleReference;
import org.jf.dexlib2.immutable.reference.ImmutableMethodProtoReference;
import org.jf.dexlib2.immutable.reference.ImmutableReference;
import org.jf.dexlib2.immutable.value.ImmutableEncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableEncodedValueFactory;
import org.jf.util.ImmutableUtils;

public class ImmutableCallSiteReference
extends BaseCallSiteReference
implements ImmutableReference {
    protected final String name;
    protected final ImmutableMethodHandleReference methodHandle;
    protected final String methodName;
    protected final ImmutableMethodProtoReference methodProto;
    protected final ImmutableList<? extends ImmutableEncodedValue> extraArguments;

    public ImmutableCallSiteReference(String name, ImmutableMethodHandleReference methodHandle, String methodName, ImmutableMethodProtoReference methodProto, ImmutableList<? extends ImmutableEncodedValue> extraArguments) {
        this.name = name;
        this.methodHandle = methodHandle;
        this.methodName = methodName;
        this.methodProto = methodProto;
        this.extraArguments = ImmutableUtils.nullToEmptyList(extraArguments);
    }

    public static ImmutableCallSiteReference of(CallSiteReference callSiteReference) {
        if (callSiteReference instanceof ImmutableCallSiteReference) {
            return (ImmutableCallSiteReference)callSiteReference;
        }
        return new ImmutableCallSiteReference(callSiteReference.getName(), ImmutableMethodHandleReference.of(callSiteReference.getMethodHandle()), callSiteReference.getMethodName(), ImmutableMethodProtoReference.of(callSiteReference.getMethodProto()), ImmutableEncodedValueFactory.immutableListOf(callSiteReference.getExtraArguments()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MethodHandleReference getMethodHandle() {
        return this.methodHandle;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public MethodProtoReference getMethodProto() {
        return this.methodProto;
    }

    @Override
    public List<? extends EncodedValue> getExtraArguments() {
        return this.extraArguments;
    }
}

