/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.ProtoIdItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.StringIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeIdItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class MethodIdItem {
    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            public String getItemName() {
                return "method_id_item";
            }

            @Override
            public void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                int classIndex = this.dexFile.getBuffer().readUshort(out.getCursor());
                out.annotate(2, "class_idx = %s", TypeIdItem.getReferenceAnnotation(this.dexFile, classIndex));
                int protoIndex = this.dexFile.getBuffer().readUshort(out.getCursor());
                out.annotate(2, "proto_idx = %s", ProtoIdItem.getReferenceAnnotation(this.dexFile, protoIndex));
                int nameIndex = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "name_idx = %s", StringIdItem.getReferenceAnnotation(this.dexFile, nameIndex));
            }
        };
    }

    public static String asString(DexBackedDexFile dexFile, int methodIndex) {
        int methodOffset = dexFile.getMethodSection().getOffset(methodIndex);
        int classIndex = dexFile.getBuffer().readUshort(methodOffset + 0);
        String classType = (String)dexFile.getTypeSection().get(classIndex);
        int protoIndex = dexFile.getBuffer().readUshort(methodOffset + 2);
        String protoString = ProtoIdItem.asString(dexFile, protoIndex);
        int nameIndex = dexFile.getBuffer().readSmallUint(methodOffset + 4);
        String methodName = (String)dexFile.getStringSection().get(nameIndex);
        return String.format("%s->%s%s", classType, methodName, protoString);
    }

    public static String getReferenceAnnotation(DexBackedDexFile dexFile, int methodIndex) {
        try {
            String methodString = MethodIdItem.asString(dexFile, methodIndex);
            return String.format("method_id_item[%d]: %s", methodIndex, methodString);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return String.format("method_id_item[%d]", methodIndex);
        }
    }
}

