/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.DexBackedTryBlock;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import org.jf.dexlib2.dexbacked.util.DebugInfo;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.dexbacked.util.VariableSizeLookaheadIterator;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.util.AlignmentUtils;
import org.jf.util.ExceptionWithContext;

public class DexBackedMethodImplementation
implements MethodImplementation {
    public final DexBackedDexFile dexFile;
    public final DexBackedMethod method;
    protected final int codeOffset;

    protected DexBackedMethodImplementation(DexBackedDexFile dexFile, DexBackedMethod method, int codeOffset) {
        this.dexFile = dexFile;
        this.method = method;
        this.codeOffset = codeOffset;
    }

    @Override
    public int getRegisterCount() {
        return this.dexFile.getDataBuffer().readUshort(this.codeOffset);
    }

    protected int getInstructionsSize() {
        return this.dexFile.getDataBuffer().readSmallUint(this.codeOffset + 12);
    }

    protected int getInstructionsStartOffset() {
        return this.codeOffset + 16;
    }

    @Override
    public Iterable<? extends Instruction> getInstructions() {
        int instructionsSize = this.getInstructionsSize();
        final int instructionsStartOffset = this.getInstructionsStartOffset();
        final int endOffset = instructionsStartOffset + instructionsSize * 2;
        return new Iterable<Instruction>(){

            @Override
            public Iterator<Instruction> iterator() {
                return new VariableSizeLookaheadIterator<Instruction>(DexBackedMethodImplementation.this.dexFile.getDataBuffer(), instructionsStartOffset){

                    @Override
                    protected Instruction readNextItem(DexReader reader) {
                        if (reader.getOffset() >= endOffset) {
                            return (Instruction)this.endOfData();
                        }
                        Instruction instruction = DexBackedInstruction.readFrom(DexBackedMethodImplementation.this.dexFile, reader);
                        int offset = reader.getOffset();
                        if (offset > endOffset || offset < 0) {
                            throw new ExceptionWithContext("The last instruction in method %s is truncated", DexBackedMethodImplementation.this.method);
                        }
                        return instruction;
                    }
                };
            }
        };
    }

    protected int getTriesSize() {
        return this.dexFile.getDataBuffer().readUshort(this.codeOffset + 6);
    }

    public List<? extends DexBackedTryBlock> getTryBlocks() {
        final int triesSize = this.getTriesSize();
        if (triesSize > 0) {
            int instructionsSize = this.getInstructionsSize();
            final int triesStartOffset = AlignmentUtils.alignOffset(this.getInstructionsStartOffset() + instructionsSize * 2, 4);
            final int handlersStartOffset = triesStartOffset + triesSize * 8;
            return new FixedSizeList<DexBackedTryBlock>(){

                @Override
                public DexBackedTryBlock readItem(int index) {
                    return new DexBackedTryBlock(DexBackedMethodImplementation.this.dexFile, triesStartOffset + index * 8, handlersStartOffset);
                }

                @Override
                public int size() {
                    return triesSize;
                }
            };
        }
        return ImmutableList.of();
    }

    protected int getDebugOffset() {
        return this.dexFile.getDataBuffer().readInt(this.codeOffset + 8);
    }

    private DebugInfo getDebugInfo() {
        int debugOffset = this.getDebugOffset();
        if (debugOffset == -1 || debugOffset == 0) {
            return DebugInfo.newOrEmpty(this.dexFile, 0, this);
        }
        if (debugOffset < 0) {
            System.err.println(String.format("%s: Invalid debug offset", this.method));
            return DebugInfo.newOrEmpty(this.dexFile, 0, this);
        }
        if (debugOffset + this.dexFile.getBaseDataOffset() >= this.dexFile.getBuffer().buf.length) {
            System.err.println(String.format("%s: Invalid debug offset", this.method));
            return DebugInfo.newOrEmpty(this.dexFile, 0, this);
        }
        return DebugInfo.newOrEmpty(this.dexFile, debugOffset, this);
    }

    @Override
    public Iterable<? extends DebugItem> getDebugItems() {
        return this.getDebugInfo();
    }

    public Iterator<String> getParameterNames(DexReader dexReader) {
        return this.getDebugInfo().getParameterNames(dexReader);
    }
}

