/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.DirectExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public final class MoreExecutors {
    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    static Executor rejectionPropagatingExecutor(final Executor delegate, final AbstractFuture<?> future) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkNotNull(future);
        if (delegate == MoreExecutors.directExecutor()) {
            return delegate;
        }
        return new Executor(){
            boolean thrownFromDelegate = true;

            @Override
            public void execute(final Runnable command) {
                block2: {
                    try {
                        delegate.execute(new Runnable(){

                            @Override
                            public void run() {
                                thrownFromDelegate = false;
                                command.run();
                            }
                        });
                    }
                    catch (RejectedExecutionException e) {
                        if (!this.thrownFromDelegate) break block2;
                        future.setException(e);
                    }
                }
            }
        };
    }
}

