"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const cloudfront = require("@aws-cdk/aws-cloudfront");
const lib_1 = require("../lib");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, 'test-cloudfront-mediastore');
stack.templateOptions.description = 'Integration test for aws-cloudfront-mediastore override properties';
const mediaStoreContainerProps = {
    containerName: 'MyMediaStoreContainer',
    policy: JSON.stringify({
        Version: '2012-10-17',
        Statement: [{
                Sid: 'OverridePolicy',
                Effect: 'Allow',
                Principal: '*',
                Action: 'mediastore:*',
                Resource: '*'
            }]
    })
};
const cloudFrontDistributionProps = {
    defaultBehavior: {
        viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.HTTPS_ONLY,
        allowedMethods: cloudfront.AllowedMethods.ALLOW_ALL,
        cachedMethods: cloudfront.CachedMethods.CACHE_GET_HEAD
    }
};
// Instantiate construct
new lib_1.CloudFrontToMediaStore(stack, 'test-cloudfront-mediastore', {
    mediaStoreContainerProps,
    cloudFrontDistributionProps
});
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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