"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .field import FieldT, FieldTTypedDict
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class VerifyCredentialsTypedDict(TypedDict):
    payment_service_definition_id: str
    r"""The ID of the payment service definition to verify the fields against"""
    fields: List[FieldTTypedDict]
    r"""The fields and their values, or a set of updated fields to merge with existing values."""
    payment_service_id: NotRequired[Nullable[str]]
    r"""The optional ID of the configured payment service. New fields will be merged with any existing fields already stored before they are verified."""


class VerifyCredentials(BaseModel):
    payment_service_definition_id: str
    r"""The ID of the payment service definition to verify the fields against"""

    fields: List[FieldT]
    r"""The fields and their values, or a set of updated fields to merge with existing values."""

    payment_service_id: OptionalNullable[str] = UNSET
    r"""The optional ID of the configured payment service. New fields will be merged with any existing fields already stored before they are verified."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["payment_service_id"]
        nullable_fields = ["payment_service_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
