"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TokenPaymentMethodCreateTypedDict(TypedDict):
    r"""Create a transaction with the ID (token) of a stored payment method (and an optional URL for approval)"""

    id: str
    r"""The ID for the payment method."""
    method: Literal["id"]
    r"""Always `id`."""
    security_code: NotRequired[Nullable[str]]
    r"""The 3 or 4 digit security code often found on the card. This often referred to as the CVV or CVD."""
    redirect_url: NotRequired[Nullable[str]]
    r"""The URL to redirect a user back to after they approve the transaction in the browser."""


class TokenPaymentMethodCreate(BaseModel):
    r"""Create a transaction with the ID (token) of a stored payment method (and an optional URL for approval)"""

    id: str
    r"""The ID for the payment method."""

    METHOD: Annotated[
        Annotated[Optional[Literal["id"]], AfterValidator(validate_const("id"))],
        pydantic.Field(alias="method"),
    ] = "id"
    r"""Always `id`."""

    security_code: OptionalNullable[str] = UNSET
    r"""The 3 or 4 digit security code often found on the card. This often referred to as the CVV or CVD."""

    redirect_url: OptionalNullable[str] = UNSET
    r"""The URL to redirect a user back to after they approve the transaction in the browser."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["method", "security_code", "redirect_url"]
        nullable_fields = ["security_code", "redirect_url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
