"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class PayoutMerchantTypedDict(TypedDict):
    name: str
    r"""The name of the merchant."""
    identification_number: str
    r"""Unique value which identifies a merchant for processing transactions, also known as a MID."""
    phone_number: str
    r"""The phone number for the merchant which should be formatted according to the E164 number standard."""
    url: str
    r"""Merchant website URL."""
    statement_descriptor: str
    r"""Value to explain charges or payments on bank statements."""
    merchant_category_code: str
    r"""Merchant classification for the type of goods or services it provides."""
    address: NotRequired[Nullable[AddressTypedDict]]
    r"""The address for the merchant."""


class PayoutMerchant(BaseModel):
    name: str
    r"""The name of the merchant."""

    identification_number: str
    r"""Unique value which identifies a merchant for processing transactions, also known as a MID."""

    phone_number: str
    r"""The phone number for the merchant which should be formatted according to the E164 number standard."""

    url: str
    r"""Merchant website URL."""

    statement_descriptor: str
    r"""Value to explain charges or payments on bank statements."""

    merchant_category_code: str
    r"""Merchant classification for the type of goods or services it provides."""

    address: OptionalNullable[Address] = UNSET
    r"""The address for the merchant."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["address"]
        nullable_fields = ["address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
