"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .guestbuyer import GuestBuyer, GuestBuyerTypedDict
from .paymentmethodcard import PaymentMethodCard, PaymentMethodCardTypedDict
from .paymentmethodstoredcard import (
    PaymentMethodStoredCard,
    PaymentMethodStoredCardTypedDict,
)
from .payoutcategory import PayoutCategory
from .payoutconnectionoptions import (
    PayoutConnectionOptions,
    PayoutConnectionOptionsTypedDict,
)
from .payoutmerchant import PayoutMerchant, PayoutMerchantTypedDict
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


PayoutCreatePaymentMethodTypedDict = TypeAliasType(
    "PayoutCreatePaymentMethodTypedDict",
    Union[PaymentMethodStoredCardTypedDict, PaymentMethodCardTypedDict],
)
r"""The type of payment method to send funds too."""


PayoutCreatePaymentMethod = TypeAliasType(
    "PayoutCreatePaymentMethod", Union[PaymentMethodStoredCard, PaymentMethodCard]
)
r"""The type of payment method to send funds too."""


class PayoutCreateTypedDict(TypedDict):
    r"""PayoutCreate

    Represents the data required to create a new payout.
    """

    amount: int
    r"""The monetary amount for this payout, in the smallest currency unit for the given currency, for example `1299` cents to create an authorization for $12.99."""
    currency: str
    r"""The ISO-4217 currency code for this payout."""
    payment_service_id: str
    r"""The ID of the payment service to use for the payout."""
    payment_method: PayoutCreatePaymentMethodTypedDict
    r"""The type of payment method to send funds too."""
    category: NotRequired[Nullable[PayoutCategory]]
    r"""The type of payout to process."""
    external_identifier: NotRequired[Nullable[str]]
    r"""A value that can be used to match the payout against your own records."""
    buyer_id: NotRequired[Nullable[str]]
    r"""The `id` of a stored buyer to use for this payout Use this instead of the `buyer` or `buyer_external_identifier`."""
    buyer: NotRequired[Nullable[GuestBuyerTypedDict]]
    r"""Inline buyer details for the payout. Use this instead of the `buyer_id` or `buyer_external_identifier`."""
    buyer_external_identifier: NotRequired[Nullable[str]]
    r"""The `external_identifier` of a stored buyer to use for this payout. Use this instead of the `buyer_id` or `buyer`."""
    merchant: NotRequired[Nullable[PayoutMerchantTypedDict]]
    r"""Merchant information for the source of the payout."""
    connection_options: NotRequired[Nullable[PayoutConnectionOptionsTypedDict]]
    r"""Optional fields for processing payouts on specific payment services."""


class PayoutCreate(BaseModel):
    r"""PayoutCreate

    Represents the data required to create a new payout.
    """

    amount: int
    r"""The monetary amount for this payout, in the smallest currency unit for the given currency, for example `1299` cents to create an authorization for $12.99."""

    currency: str
    r"""The ISO-4217 currency code for this payout."""

    payment_service_id: str
    r"""The ID of the payment service to use for the payout."""

    payment_method: PayoutCreatePaymentMethod
    r"""The type of payment method to send funds too."""

    category: Annotated[
        OptionalNullable[PayoutCategory], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The type of payout to process."""

    external_identifier: OptionalNullable[str] = UNSET
    r"""A value that can be used to match the payout against your own records."""

    buyer_id: OptionalNullable[str] = UNSET
    r"""The `id` of a stored buyer to use for this payout Use this instead of the `buyer` or `buyer_external_identifier`."""

    buyer: OptionalNullable[GuestBuyer] = UNSET
    r"""Inline buyer details for the payout. Use this instead of the `buyer_id` or `buyer_external_identifier`."""

    buyer_external_identifier: OptionalNullable[str] = UNSET
    r"""The `external_identifier` of a stored buyer to use for this payout. Use this instead of the `buyer_id` or `buyer`."""

    merchant: OptionalNullable[PayoutMerchant] = UNSET
    r"""Merchant information for the source of the payout."""

    connection_options: OptionalNullable[PayoutConnectionOptions] = UNSET
    r"""Optional fields for processing payouts on specific payment services."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "category",
            "external_identifier",
            "buyer_id",
            "buyer",
            "buyer_external_identifier",
            "merchant",
            "connection_options",
        ]
        nullable_fields = [
            "category",
            "external_identifier",
            "buyer_id",
            "buyer",
            "buyer_external_identifier",
            "merchant",
            "connection_options",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
