"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .giftcarderrorcode import GiftCardErrorCode
from .giftcardredemptionstatus import GiftCardRedemptionStatus
from .transactiongiftcard import TransactionGiftCard, TransactionGiftCardTypedDict
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GiftCardRedemptionTypedDict(TypedDict):
    id: str
    r"""The ID for the gift card redemption."""
    status: GiftCardRedemptionStatus
    amount: int
    r"""The amount redeemed for this gift card."""
    refunded_amount: int
    r"""The amount refunded for this gift card. This can not be larger than `amount`."""
    gift_card: TransactionGiftCardTypedDict
    type: Literal["gift-card-redemption"]
    r"""Always `gift-card-redemption`."""
    gift_card_service_redemption_id: NotRequired[Nullable[str]]
    r"""The gift card service's unique ID for the redemption."""
    error_code: NotRequired[Nullable[GiftCardErrorCode]]
    r"""If this gift card redemption resulted in an error, this will contain the internal code for the error."""
    raw_error_code: NotRequired[Nullable[str]]
    r"""If this gift card redemption resulted in an error, this will contain the raw error code received from the gift card provider."""
    raw_error_message: NotRequired[Nullable[str]]
    r"""If this gift card redemption resulted in an error, this will contain the raw error message received from the gift card provider."""


class GiftCardRedemption(BaseModel):
    id: str
    r"""The ID for the gift card redemption."""

    status: Annotated[
        GiftCardRedemptionStatus, PlainValidator(validate_open_enum(False))
    ]

    amount: int
    r"""The amount redeemed for this gift card."""

    refunded_amount: int
    r"""The amount refunded for this gift card. This can not be larger than `amount`."""

    gift_card: TransactionGiftCard

    TYPE: Annotated[
        Annotated[
            Optional[Literal["gift-card-redemption"]],
            AfterValidator(validate_const("gift-card-redemption")),
        ],
        pydantic.Field(alias="type"),
    ] = "gift-card-redemption"
    r"""Always `gift-card-redemption`."""

    gift_card_service_redemption_id: OptionalNullable[str] = UNSET
    r"""The gift card service's unique ID for the redemption."""

    error_code: Annotated[
        OptionalNullable[GiftCardErrorCode], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""If this gift card redemption resulted in an error, this will contain the internal code for the error."""

    raw_error_code: OptionalNullable[str] = UNSET
    r"""If this gift card redemption resulted in an error, this will contain the raw error code received from the gift card provider."""

    raw_error_message: OptionalNullable[str] = UNSET
    r"""If this gift card redemption resulted in an error, this will contain the raw error message received from the gift card provider."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "gift_card_service_redemption_id",
            "error_code",
            "raw_error_code",
            "raw_error_message",
        ]
        nullable_fields = [
            "gift_card_service_redemption_id",
            "error_code",
            "raw_error_code",
            "raw_error_message",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
