"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .buyer import Buyer, BuyerTypedDict
from .giftcardservice import GiftCardService, GiftCardServiceTypedDict
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GiftCardTypedDict(TypedDict):
    id: str
    r"""The ID for the gift card."""
    merchant_account_id: str
    r"""The ID of the merchant account this buyer belongs to."""
    gift_card_service: GiftCardServiceTypedDict
    bin: str
    r"""The first 6 digits of the full gift card number."""
    sub_bin: str
    r"""The 3 digits after the `bin` of the full gift card number."""
    last4: str
    r"""The last 4 digits for the gift card."""
    created_at: datetime
    r"""The date this gift card record was created at."""
    updated_at: datetime
    r"""The date this gift card record was last updated at."""
    type: Literal["gift-card"]
    r"""Always `gift-card`."""
    expiration_date: NotRequired[Nullable[datetime]]
    r"""The date and time when this gift card expires. This is a full date/time and may be more accurate than the actual expiry date received by the gift card service."""
    buyer: NotRequired[Nullable[BuyerTypedDict]]
    r"""The buyer for which this gift card is stored."""


class GiftCard(BaseModel):
    id: str
    r"""The ID for the gift card."""

    merchant_account_id: str
    r"""The ID of the merchant account this buyer belongs to."""

    gift_card_service: GiftCardService

    bin: str
    r"""The first 6 digits of the full gift card number."""

    sub_bin: str
    r"""The 3 digits after the `bin` of the full gift card number."""

    last4: str
    r"""The last 4 digits for the gift card."""

    created_at: datetime
    r"""The date this gift card record was created at."""

    updated_at: datetime
    r"""The date this gift card record was last updated at."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["gift-card"]], AfterValidator(validate_const("gift-card"))
        ],
        pydantic.Field(alias="type"),
    ] = "gift-card"
    r"""Always `gift-card`."""

    expiration_date: OptionalNullable[datetime] = UNSET
    r"""The date and time when this gift card expires. This is a full date/time and may be more accurate than the actual expiry date received by the gift card service."""

    buyer: OptionalNullable[Buyer] = UNSET
    r"""The buyer for which this gift card is stored."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type", "expiration_date", "buyer"]
        nullable_fields = ["expiration_date", "buyer"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
