"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class ForterAntiFraudOptionsCartItemBeneficiaryAddressTypedDict(TypedDict):
    country: str
    r"""The country code of the beneficiary's address."""
    address1: NotRequired[Nullable[str]]
    r"""First line of the beneficiary's address."""
    address2: NotRequired[Nullable[str]]
    r"""Second line of the beneficiary's address."""
    zip: NotRequired[Nullable[str]]
    r"""Zip or postal code of the beneficiary's address."""
    region: NotRequired[Nullable[str]]
    r"""State or region of the beneficiary's address."""
    company: NotRequired[Nullable[str]]
    r"""Company name associated with the beneficiary's address."""
    city: NotRequired[Nullable[str]]
    r"""City of the beneficiary's address."""


class ForterAntiFraudOptionsCartItemBeneficiaryAddress(BaseModel):
    country: str
    r"""The country code of the beneficiary's address."""

    address1: OptionalNullable[str] = UNSET
    r"""First line of the beneficiary's address."""

    address2: OptionalNullable[str] = UNSET
    r"""Second line of the beneficiary's address."""

    zip: OptionalNullable[str] = UNSET
    r"""Zip or postal code of the beneficiary's address."""

    region: OptionalNullable[str] = UNSET
    r"""State or region of the beneficiary's address."""

    company: OptionalNullable[str] = UNSET
    r"""Company name associated with the beneficiary's address."""

    city: OptionalNullable[str] = UNSET
    r"""City of the beneficiary's address."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["address1", "address2", "zip", "region", "company", "city"]
        nullable_fields = ["address1", "address2", "zip", "region", "company", "city"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
