"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, UnrecognizedStr
from gr4vy.utils import validate_open_enum
from pydantic.functional_validators import PlainValidator
from typing import Literal, Union
from typing_extensions import Annotated, TypedDict


SubscriptionFrequencyUnit = Union[
    Literal[
        "MONTH",
        "WEEK",
        "BI_MONTHLY",
        "ONDEMAND",
        "QUARTER",
        "YEAR",
        "SEMI_ANNUALLY",
        "DAY",
    ],
    UnrecognizedStr,
]
r"""Indicates the frequency unit for the subscription. Allowed values are: `DAY`, `WEEK`, `MONTH`, `BI_MONTHLY`, `QUARTER`, `SEMI_ANNUALLY`, `YEAR`, `ONDEMAND`."""


class DlocalUPIRecurringInfoOptionsTypedDict(TypedDict):
    subscription_frequency_unit: SubscriptionFrequencyUnit
    r"""Indicates the frequency unit for the subscription. Allowed values are: `DAY`, `WEEK`, `MONTH`, `BI_MONTHLY`, `QUARTER`, `SEMI_ANNUALLY`, `YEAR`, `ONDEMAND`."""
    subscription_frequency: int
    r"""Indicates the frequency for the subscription."""
    subscription_start_at: str
    r"""Indicates the start date for the subscription in format `YYYYMMDD`."""
    subscription_end_at: str
    r"""Indicates the end date for the subscription in format `YYYYMMDD`."""


class DlocalUPIRecurringInfoOptions(BaseModel):
    subscription_frequency_unit: Annotated[
        SubscriptionFrequencyUnit, PlainValidator(validate_open_enum(False))
    ]
    r"""Indicates the frequency unit for the subscription. Allowed values are: `DAY`, `WEEK`, `MONTH`, `BI_MONTHLY`, `QUARTER`, `SEMI_ANNUALLY`, `YEAR`, `ONDEMAND`."""

    subscription_frequency: int
    r"""Indicates the frequency for the subscription."""

    subscription_start_at: str
    r"""Indicates the start date for the subscription in format `YYYYMMDD`."""

    subscription_end_at: str
    r"""Indicates the end date for the subscription in format `YYYYMMDD`."""
