"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .createsessionstatus import CreateSessionStatus
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Any, Dict, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateSessionTypedDict(TypedDict):
    r"""The session data received from the payment service."""

    status: CreateSessionStatus
    type: Literal["payment-service-session"]
    r"""Always `payment-service-session`."""
    code: NotRequired[Nullable[str]]
    r"""A generic error code that may be returned when the session could not be generated."""
    status_code: NotRequired[Nullable[int]]
    r"""The HTTP status code received from the payment service."""
    response_body: NotRequired[Nullable[Dict[str, Any]]]
    r"""The JSON response body received from the payment service."""


class CreateSession(BaseModel):
    r"""The session data received from the payment service."""

    status: Annotated[CreateSessionStatus, PlainValidator(validate_open_enum(False))]

    TYPE: Annotated[
        Annotated[
            Optional[Literal["payment-service-session"]],
            AfterValidator(validate_const("payment-service-session")),
        ],
        pydantic.Field(alias="type"),
    ] = "payment-service-session"
    r"""Always `payment-service-session`."""

    code: OptionalNullable[str] = UNSET
    r"""A generic error code that may be returned when the session could not be generated."""

    status_code: OptionalNullable[int] = UNSET
    r"""The HTTP status code received from the payment service."""

    response_body: OptionalNullable[Dict[str, Any]] = UNSET
    r"""The JSON response body received from the payment service."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type", "code", "status_code", "response_body"]
        nullable_fields = ["code", "status_code", "response_body"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
