"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .transaction import Transaction, TransactionTypedDict
from .transactioncapture import TransactionCapture, TransactionCaptureTypedDict
from .transactioncapturecreate import (
    TransactionCaptureCreate,
    TransactionCaptureCreateTypedDict,
)
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
    get_discriminator,
)
import pydantic
from pydantic import Discriminator, Tag, model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CaptureTransactionGlobalsTypedDict(TypedDict):
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class CaptureTransactionGlobals(BaseModel):
    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""


class CaptureTransactionRequestTypedDict(TypedDict):
    transaction_id: str
    r"""The ID of the transaction"""
    transaction_capture_create: TransactionCaptureCreateTypedDict
    prefer: NotRequired[Nullable[List[str]]]
    r"""The preferred resource type in the response."""
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class CaptureTransactionRequest(BaseModel):
    transaction_id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the transaction"""

    transaction_capture_create: Annotated[
        TransactionCaptureCreate,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    prefer: Annotated[
        OptionalNullable[List[str]],
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = UNSET
    r"""The preferred resource type in the response."""

    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["prefer", "merchant_account_id"]
        nullable_fields = ["prefer"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


ResponseCaptureTransactionTypedDict = TypeAliasType(
    "ResponseCaptureTransactionTypedDict",
    Union[TransactionCaptureTypedDict, TransactionTypedDict],
)
r"""Successful Response"""


ResponseCaptureTransaction = Annotated[
    Union[
        Annotated[Transaction, Tag("processing")],
        Annotated[Transaction, Tag("authorization_succeeded")],
        Annotated[Transaction, Tag("authorization_declined")],
        Annotated[Transaction, Tag("authorization_failed")],
        Annotated[Transaction, Tag("authorization_voided")],
        Annotated[Transaction, Tag("authorization_void_pending")],
        Annotated[Transaction, Tag("capture_succeeded")],
        Annotated[Transaction, Tag("capture_pending")],
        Annotated[Transaction, Tag("buyer_approval_pending")],
        Annotated[TransactionCapture, Tag("succeeded")],
        Annotated[TransactionCapture, Tag("pending")],
        Annotated[TransactionCapture, Tag("declined")],
        Annotated[TransactionCapture, Tag("failed")],
    ],
    Discriminator(lambda m: get_discriminator(m, "status", "status")),
]
r"""Successful Response"""
