"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .billingdetails import BillingDetails, BillingDetailsTypedDict
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class BuyerUpdateTypedDict(TypedDict):
    r"""Request body for updating an existing buyer"""

    display_name: NotRequired[Nullable[str]]
    r"""The display name for the buyer."""
    external_identifier: NotRequired[Nullable[str]]
    r"""The merchant identifier for this buyer."""
    account_number: NotRequired[Nullable[str]]
    r"""The buyer account number"""
    billing_details: NotRequired[Nullable[BillingDetailsTypedDict]]
    r"""The billing name, address, email, and other fields for this buyer."""


class BuyerUpdate(BaseModel):
    r"""Request body for updating an existing buyer"""

    display_name: OptionalNullable[str] = UNSET
    r"""The display name for the buyer."""

    external_identifier: OptionalNullable[str] = UNSET
    r"""The merchant identifier for this buyer."""

    account_number: OptionalNullable[str] = UNSET
    r"""The buyer account number"""

    billing_details: OptionalNullable[BillingDetails] = UNSET
    r"""The billing name, address, email, and other fields for this buyer."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "display_name",
            "external_identifier",
            "account_number",
            "billing_details",
        ]
        nullable_fields = [
            "display_name",
            "external_identifier",
            "account_number",
            "billing_details",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
