# generated by datamodel-codegen:
#   filename:  concourse_pipeline_schema.json
#   timestamp: 2022-07-13T17:57:35+00:00

from __future__ import annotations

import re
from enum import Enum
from typing import Any, Literal, Optional, Union

from pydantic import BaseModel, ConstrainedStr, Extra, Field


class Identifier(ConstrainedStr):
    regex = re.compile(r"^[a-z][\w\d\-_.]*$")


class Step(BaseModel):
    pass


class Version(BaseModel):
    __root__: dict[str, str]


class Value(str):
    pass


class Duration(BaseModel):
    __root__: str


class RegistryImage(BaseModel):
    repository: str
    tag: str = "latest"


class DisplayConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    background_image: Optional[str] = Field(
        None,
        description=(
            "Allow users to specify a custom background image which is put at 30% "
            " opacity, grayscaled and blended into existing background. Must be an "
            " http, https, or relative URL."
        ),
    )


class Cache(BaseModel):
    class Config:
        extra = Extra.forbid

    path: Optional[str] = Field(
        None,
        description=(
            "The path to a directory to be cached.    Paths are relative to the working"
            " directory of the task. Absolute paths  are not respected."
        ),
    )


class Format(str, Enum):
    """
        The format of the file's content.    If unset, Concourse will try to detect the format from the file  extension. If the file format cannot be determined, Concourse will  fallback to `trim` .    If set to `json` , `yaml` , or `yml` , the file content  will be parsed accordingly and the resulting structure will be the  value of the var.    If set to `trim` , the var will be set to the content of the file  with any trailing and leading whitespace removed.    If set to `raw` , the var will be set to the content of the file  without modification (i.e. with any existing whitespace).
    @example  Loading a var with multiple fields
       Let's say we have a file with multiple fields, like this yaml file:      yaml  https://raw.githubusercontent.com/concourse/examples/master/pipelines/vars-file.yml      We could pass these values to subsequent steps by loading it  into a var with `load_var` , which will detect that it is in YAML  format based on the file extension:     ```yaml
    jobs:
    - name: loading-vars
      plan:
      - get: examples
      - load_var: version
        file: examples/pipelines/vars-file.yml
      - put: img
        params:
          version: "((.:version.hello))-((.:version.number))"


    resources:
    - name: examples
      type: git
      icon: github
      source:
        uri: https://github.com/concourse/examples.git
    - name: img
      type: mock
    ```     If the file `vars-file.yml` was generated in a task and printed  these values, they would be automatically redacted unless    schema.load-var.reveal `reveal: true` is set.
    """

    json = "json"
    yaml = "yaml"
    yml = "yml"
    trim = "trim"
    raw = "raw"


class Platform(str, Enum):
    """
    The platform the task should run on. This determines the pool of workers  that the task can run against.    Technically any string value is allowed so long as a worker advertises the  same platform, but in practice only `linux` , `darwin` , and   `windows` are in use.
    """

    linux = "linux"
    darwin = "darwin"
    windows = "windows"


class VarSource(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = Field(
        None,
        description=(
            "The name of the `((var))` source. This should be short and  simple. This"
            " name will be referenced  var-syntax  throughout  the config."
        ),
    )


class Vars(BaseModel):
    pass


class Command(BaseModel):
    class Config:
        extra = Extra.forbid

    args: Optional[list[str]] = Field(
        None,
        description=(
            "Arguments to pass to the command. Note that when executed with    fly-cli "
            " Fly  , any arguments passed to  fly-execute    are appended to this"
            " array."
        ),
    )
    user: Optional[str] = Field(
        None,
        description=(
            "Explicitly set the user to run as. If not specified, this defaults to the "
            " user configured by the task's image. If not specified there, it's up to "
            " the Garden backend, and may be e.g. `root` on Linux."
        ),
    )
    path: Optional[str] = Field(
        None,
        description=(
            "The name of or path to the executable to run.     `path` is relative to"
            " the working directory. If `dir` is  specified to set the working"
            " directory, then `path` is relative to  it.    This is commonly a path to"
            " a script provided by one of the task's inputs,  e.g."
            " `my-resource/scripts/test` . It could also be a command like   `bash`"
            " (respecting standard `$PATH` lookup rules), or an absolute  path to a"
            " file to execute, e.g. `/bin/bash` ."
        ),
    )
    dir: Optional[str] = Field(
        None,
        description=(
            "A directory, relative to the initial working directory, to set as the "
            " working directory when running the script."
        ),
    )


class Number(BaseModel):
    __root__: float


class DummyConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    vars: Optional[Vars] = Field(
        None, description="A mapping of var name to var value."
    )


class GroupConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[Identifier] = Field(
        None,
        description=(
            "A unique name for the group. This should be short and simple as it will "
            " be used as the tab name for navigation."
        ),
    )
    jobs: Optional[list[str]] = Field(
        None,
        description=(
            "A list of jobs that should appear in this group. A job may  appear in"
            " multiple groups. Neighbours of jobs in the current group will also "
            " appear on the same page in order to give context of the location of the "
            " group in the pipeline.    You may also use any valid  glob "
            " https://www.man7.org/linux/man-pages/man7/glob.7.html    to represent"
            " several jobs, e.g.:     ```yaml\ngroups:\n- name: develop\n  jobs:\n  -"
            " terraform-*\n  - test\n  - deploy-{dev,staging}\n- name: ship\n  jobs:\n "
            ' - deploy-prod\n- name: all\n  jobs:\n  - "*"\n```     In this example,'
            " the `develop` group will match   `terraform-apply` , `terraform-destroy`"
            " , `test` ,   `deploy-dev` , `deploy-staging` . The `ship` group will only"
            " match   `deploy-prod` . The `all` group will match all jobs in the"
            " pipeline.      Note that depending on how it's used, `*` , `{` , and  "
            " `}` have special meaning in YAML, and may need to be quoted (as  was done"
            " in the `all` job above)"
        ),
    )


class PutStep(Step):
    class Config:
        extra = Extra.forbid

    resource: Optional[str] = Field(
        None,
        description=(
            "Defaults to the value of `put` .  The resource to update,  as configured"
            " in  schema.pipeline.resources  .     \n@example  Re-label Put Resource \n"
            '    ```yaml\njobs:\n- name: fetch-repo\n  plan:\n    # puts to "repo" and'
            ' fetches new version under artifact name "thecode"\n  - put: thecode\n   '
            " resource: repo\n    params:\n      version: put-only\n  - task: ls-repo\n"
            "    config:\n      platform: linux\n      image_resource:\n        type:"
            ' mock\n        source: {mirror_self: true}\n      # pass the "thecode"'
            " artifact into the task\n      inputs:\n      - name: thecode\n     "
            ' run:\n        path: ls\n        args: ["-lah","thecode"]\n\nresources:\n-'
            " name: repo\n  type: mock\n```"
        ),
    )
    params: Optional[dict[str, Any]] = Field(
        None,
        description=(
            "Arbitrary configuration to pass to the resource. Refer to the resource "
            " type's documentation to see what it supports.     \n@example  Putting"
            " with params \n    ```yaml\njobs:\n- name: resource-params\n  plan:\n  -"
            " put: cyberdeck\n    params:\n      version:"
            ' "made-via-params"\n\nresources:\n- name: cyberdeck\n  type: mock\n```'
        ),
    )
    get_params: Optional[dict[str, Any]] = Field(
        None,
        description=(
            "Arbitrary configuration to pass to the resource during the implicit  "
            " `get` step. Refer to the resource type's documentation to see what  it"
            " supports.     \n@example  Parameterizing the implicit `get`\n   You can"
            " control the settings of the implicit `get` step  by setting `get_params`"
            " . For example, if you did not want a `put`   step utilizing the  "
            " `registry-image` resource  type "
            " https://github.com/concourse/registry-image-resource  to download the "
            " image, you would implement your `put` step as such:     ```yaml\nplan:\n-"
            " put: app-image\n  params:\n    build: git-resource\n  get_params:\n   "
            " skip_download: true\n```"
        ),
    )
    put: Optional[Union[str, Identifier]] = Field(
        None,
        description=(
            "When the step succeeds, the version by the step will be immediately "
            " fetched via an additional implicit  get-step  . This is so  that later"
            " steps in your plan can use the artifact that was produced.  The artifact"
            " will be available under the identifier `put`   specifies.     \n@example "
            " Getting and Putting \n   The following plan fetches a version using   "
            " get-step `get` and pushes it to another resource  using  put-step `put` :"
            "     ```yaml\njobs:\n- name: get-and-pull\n  plan:\n  - get: the-ice\n  -"
            " put: cyberdeck\n    params:\n      file:"
            " the-ice/version.txt\n\nresources:\n- name: the-ice\n  type: mock\n "
            ' source:\n    create_files:\n      version.txt: "made-via-source"\n- name:'
            " cyberdeck\n  type: mock\n```"
        ),
    )
    inputs: Optional[
        Union[Literal["all"], Literal["detect"], list[Identifier]]
    ] = Field(
        None,
        description=(
            "Default `all` .  When not set, or set to `all` , all  artifacts will be"
            " provided. This can result in slow performance if the  prior steps in the"
            " build plan register a bunch of large artifacts  before this step, so you"
            " may want to consider being explicit.    If configured as a list of"
            " identifiers, only the listed artifacts will  be provided to the"
            " container.    If set to `detect` , the artifacts are detected based on"
            " the  configured  schema.put.params  by looking for all string values  and"
            " using the first path segment as an identifier. (This may become the "
            " default in the future.)     \n@example  Put Input Methods \n   "
            " ```yaml\njobs:\n- name: put-input-methods\n  plan:\n  - in_parallel:\n   "
            " - get: repo-dev\n    - get: repo-master\n    - get: app-image\n    - get:"
            " ci\n  - put: all-inputs\n    resource: repo\n    inputs: all # default"
            " option\n    params:\n      file: ci/version.txt\n  - put: detect-inputs\n"
            '    resource: repo\n    inputs: detect # will only stream the "ci"'
            " artifact\n    params:\n      file: ci/version.txt\n  - put:"
            " explicit-inputs\n    resource: repo\n    inputs: # explicitly list"
            " artifacts to stream to put step\n      - ci\n    params:\n      file:"
            " ci/version.txt\n\nresources:\n- name: repo\n  type: mock\n- name:"
            " repo-dev\n  type: mock\n- name: repo-master\n  type: mock\n- name:"
            " app-image\n  type: mock\n- name: ci\n  type: mock\n  source:\n   "
            ' create_files:\n      version.txt: "42"\n```'
        ),
    )


class AnonymousResource(BaseModel):
    class Config:
        extra = Extra.forbid

    source: Optional[dict[str, Any]] = Field(
        None,
        description=(
            "The configuration for the resource; see    schema.resource.source  ."
        ),
    )
    params: Optional[dict[str, Any]] = Field(
        None,
        description=(
            "A map of arbitrary configuration to forward to the resource. Refer to the "
            " resource type's documentation to see what it supports."
        ),
    )
    version: Optional[Version] = Field(
        None,
        description=(
            "A specific version of the resource to fetch. This should be a map with "
            " string keys and values. If not specified, the latest version will be "
            " fetched."
        ),
    )
    type: Optional[str] = Field(
        None,
        description=(
            "The type of the resource. Usually `registry-image` .    You can use any"
            " resource type that returns a filesystem in the correct  format: a"
            " `/rootfs` directory containing a full filesystem, and a   `metadata.json`"
            " file containing."
        ),
    )


class Output(BaseModel):
    class Config:
        extra = Extra.forbid

    path: Optional[str] = Field(
        None,
        description=(
            "The path to a directory where the output will be taken from. If not "
            " specified, the output's `name` is used.    Paths are relative to the"
            " working directory of the task. Absolute paths are not respected."
        ),
    )
    name: Optional[Identifier] = Field(
        None,
        description=(
            "The name of the output. The contents under `path` will be made  available"
            " to the rest of the plan under this name."
        ),
    )


class BuildLogRetentionPolicy(BaseModel):
    class Config:
        extra = Extra.forbid

    days: Optional[Number] = Field(
        None,
        description=(
            "Keep logs for builds which have finished within the specified number of "
            " days."
        ),
    )
    minimum_succeeded_builds: Optional[Number] = Field(
        None,
        description=(
            "Keep a minimum number of successful build logs that would normally be "
            " reaped.    Requires    schema.build_log_retention_policy.builds `builds`"
            " to  be set to an integer higher than 0 in order to work. For example, if "
            "   schema.build_log_retention_policy.builds `builds` is  set to 5, and"
            " this attribute to 1, say a job has the following build  history: 7(f),"
            " 6(f), 5(f), 4(f), 3(f), 2(f), 1(s), where f means  failed and s means"
            " succeeded, then builds 2 and 3 will be reaped,  because it retains 5"
            " build logs, and at least 1 succeeded build log.  Default is 0."
        ),
    )
    builds: Optional[Number] = Field(
        None, description="Keep logs for the last specified number of builds."
    )


class Input(BaseModel):
    class Config:
        extra = Extra.forbid

    path: Optional[str] = Field(
        None,
        description=(
            "The path where the input will be placed. If not specified, the input's  "
            " `name` is used.    Paths are relative to the working directory of the"
            " task. Absolute paths  are not respected."
        ),
    )
    optional: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  If `true` , then the input is not  required by the"
            " task. The task may run even if this input is missing.    An `optional`"
            " input that is missing will not appear in the current  directory of the"
            " running task."
        ),
    )
    name: Optional[Identifier] = Field(None, description="The name of the input.")


class AcrossVar(BaseModel):
    class Config:
        extra = Extra.forbid

    var: Optional[Identifier] = Field(
        None,
        description=(
            'The name of the variable that will be added to the    local-vars  " `.` "'
            " var source  . This variable will only be  accessible in the scope of the"
            " step - each iteration of the step gets  its own scope.    If a variable"
            " of the same name already exists in the parent scope, a  warning will be"
            " printed."
        ),
    )
    values: Optional[list[Value]] = Field(
        None,
        description=(
            "The list of values that the  schema.across_var.var  var  will  iterate"
            " over when running the substep. If multiple  schema.across_var  vars   "
            " are configured, all combinations of values across all vars will run.   "
            " The list of values may also be interpolated. For instance, you may use "
            " the  load-var-step  to first load a list of  schema.value    into a "
            " local-vars  local var  , and then iterate across that dynamic  list of"
            " values.     \n@example  Value combinations \n   The following "
            " schema.across  will run the task   `foo/build.yml` for each package"
            " defined in `foo/packages-to-build.json`   with Go 1.15 and 1.16.    "
            " ```yaml\nplan:\n- get: foo\n- load_var: packages\n  file:"
            " foo/packages-to-build.json\n- across:\n  - var: package\n    values:"
            " ((.:packages))\n  - var: go_version\n    values: ['1.15', '1.16']\n "
            " task: build\n  file: foo/build.yml\n  vars:\n    go_version:"
            " ((.:go_version))\n    package: ((.:package))\n```     Supposing"
            " `foo/packages-to-build.json` had the following content:  "
            ' ```json\n["./cmd/first", "./cmd/second", "./cmd/third"]\n```     ...then'
            " the task `foo/build.yml` would be run with the following  var"
            ' combinations:         `{package: "./cmd/first", go_version: "1.15"}`     '
            '   `{package: "./cmd/first", go_version: "1.16"}`        `{package:'
            ' "./cmd/second", go_version: "1.15"}`        `{package: "./cmd/second",'
            ' go_version: "1.16"}`        `{package: "./cmd/third", go_version:'
            ' "1.15"}`        `{package: "./cmd/third", go_version: "1.16"}`'
        ),
    )
    fail_fast: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  When enabled, the `across` step will  fail fast by"
            " returning as soon as any sub-step fails. This means that running steps "
            " will be interrupted and pending steps will no longer be scheduled."
        ),
    )
    max_in_flight: Optional[Union[Literal["all"], Number]] = Field(
        None,
        description=(
            "Default `1` .  If set to `all` , the substep will run  with all"
            " combinations of the current var in parallel. If set to a    schema.number"
            "  , only that number of substeps may run in parallel.     \n@example "
            " Multiple vars \n   If multiple  schema.across_var  vars  are configured,"
            " the  effective `max_in_flight` is multiplicative. For instance:    "
            " ```yaml\nplan:\n- across:\n  - var: var1\n    values: [a, b, c]\n   "
            " max_in_flight: all\n  - var: var2\n    values: [1, 2]\n  - var: var3\n   "
            " values: [foo, bar]\n    max_in_flight: 2\n```     Here, ** 6 substeps **"
            " will run in parallel, since all 3 of   `var1` 's values can run in"
            " parallel, and 2 of `var3` 's  values can run in parallel."
        ),
    )


class DummyVarSource(BaseModel):
    class Config:
        extra = Extra.forbid

    config: Optional[DummyConfig] = Field(
        None,
        description=(
            "dummy_config      vars  vars    A mapping of var name to var value."
        ),
    )
    type: Optional[Literal["dummy"]] = Field(
        None,
        description=(
            "The `dummy` type supports configuring a static map of vars to values.   "
            " This is really only useful if you have no better alternative for"
            " credential  management but still have sensitive values that you would"
            " like to    creds-redacting  redact  them from build output."
        ),
    )


class VaultConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    path_prefix: Optional[str] = Field(
        None,
        description=(
            "Default `/concourse` .  A prefix under which to  look for all credential"
            " values.    See  vault-path-prefix  for more information."
        ),
    )
    auth_retry_max: Optional[Duration] = Field(
        None,
        description="When failing to authenticate, give up after this amount of  time.",
    )
    url: Optional[str] = Field(None, description="The URL of the Vault API.")
    client_cert: Optional[str] = Field(
        None,
        description=(
            "A PEM encoded client certificate, for use with TLS based auth.    See "
            " vault-cert-auth  for more information."
        ),
    )
    client_key: Optional[str] = Field(
        None,
        description=(
            "A PEM encoded client key, for use with TLS based auth.    See "
            " vault-cert-auth  for more information."
        ),
    )
    auth_backend: Optional[str] = Field(
        None,
        description=(
            "Authenticate using an auth backend, e.g. `cert` or   `approle` .    See "
            " vault-approle-auth  or  vault-cert-auth  for  more information."
        ),
    )
    server_name: Optional[str] = Field(
        None, description="The expected name of the server when connecting through TLS."
    )
    lookup_templates: Optional[list[str]] = Field(
        None,
        description=(
            'Default `["/{{.Team}}/{{.Pipeline}}/{{.Secret}}",'
            ' "/{{.Team}}/{{.Secret}}"]` .      A list of path templates to be expanded'
            " in a team and pipeline context  subject to the `path_prefix` and"
            " `namespace` .    See  vault-lookup-templates  for more information."
        ),
    )
    ca_cert: Optional[str] = Field(
        None,
        description=(
            "The PEM encoded contents of a CA certificate to use when  connecting to"
            " the API."
        ),
    )
    client_token: Optional[str] = Field(
        None,
        description=(
            "Authenticate via a periodic client token.    See  vault-periodic-token "
            " for more information."
        ),
    )
    shared_path: Optional[str] = Field(
        None,
        description=(
            "An additional path under which credentials will be looked up.    See "
            " vault-shared-path  for more information."
        ),
    )
    namespace: Optional[str] = Field(
        None,
        description=(
            "A  Vault  namespace "
            " https://www.vaultproject.io/docs/enterprise/namespaces/index.html    to"
            " operate under."
        ),
    )
    insecure_skip_verify: Optional[bool] = Field(
        None,
        description=(
            "Skip TLS validation. Not recommended. Don't do it. No really,  don't."
        ),
    )
    auth_max_ttl: Optional[Duration] = Field(
        None,
        description=(
            "Maximum duration to elapse before forcing the client to log in  again."
        ),
    )
    auth_params: Optional[dict[str, str]] = Field(
        None,
        description=(
            "A key-value map of parameters to pass during authentication.    See "
            " vault-approle-auth  for more information."
        ),
    )
    auth_retry_initial: Optional[Duration] = Field(
        None,
        description=(
            "When retrying during authentication, start with this retry  interval. The"
            " interval will increase exponentially until   `auth_retry_max` is reached."
        ),
    )


class SetPipelineStep(Step):
    class Config:
        extra = Extra.forbid

    set_pipeline: Optional[Union[Identifier, Literal["self"]]] = Field(
        None,
        description=(
            "The identifier specifies the name of the pipeline to configure. Unless   "
            " schema.set-pipeline.team  is set, it will be configured  within the"
            " current team and be created  unpaused  . If set to `self` ,  the current"
            " pipeline will update its own config.         `set_pipeline: self` was"
            " introduced in Concourse v6.5.0. It is  considered an ** experimental **"
            " feature and may be removed at any  time. Contribute to the associated   "
            " discussion  https://github.com/concourse/concourse/discussions/5732   "
            " with feedback.           \n@example  One pipeline configuring another \n "
            "  This is a way to ensure a pipeline stays up to date with its definition"
            " in  a source code repository, eliminating the need to manually run   "
            " fly-set-pipeline  .     ```yaml\njobs:\n- name: set-pipeline\n  plan:\n "
            " - get: examples\n    trigger: true\n  - set_pipeline: hello-world  #"
            " pipeline's name\n    file: examples/pipelines/hello-world.yml  #"
            " pipeline's config\n\nresources:\n- name: examples\n  type: git\n  icon:"
            " github\n  source:\n    uri:"
            " https://github.com/concourse/examples.git\n```"
        ),
    )
    var_files: Optional[list[str]] = Field(
        None,
        description=(
            "A list of paths to `.yml` files that will be passed to the  pipeline"
            " config in the same manner as the `--load-vars-from` flag  to "
            " fly-set-pipeline  . This means that if a variable appears  in multiple"
            " files, the value from a file that is passed later in the  list will"
            " override the values from files earlier in the list.     \n@example "
            " Configuring static vars with a vars file \n   Where the vars file looks"
            " like:    yaml "
            " https://raw.githubusercontent.com/concourse/examples/master/pipelines/vars-file.yml"
            "      And the pipeline config is:     ```yaml\njobs:\n- name:"
            " set-pipeline-vars-only\n  plan:\n  - get: examples\n  - set_pipeline:"
            " pipeline-set-with-vars\n    file: examples/pipelines/pipeline-vars.yml\n "
            "   var_files:\n      - examples/pipelines/vars-file.yml\n\nresources:\n-"
            " name: examples\n  type: git\n  icon: github\n  source:\n    uri:"
            " https://github.com/concourse/examples.git\n```"
        ),
    )
    file: Optional[str] = Field(
        None,
        description=(
            "The path to the pipeline's configuration file.     `file` points at a"
            " `.yml` file containing the pipeline  configuration, which allows this to"
            " be tracked with your resources or  generated by a  task-step  .    The"
            " first segment in the path should refer to another artifact from the "
            " plan, and the rest of the path is relative to that artifact.    "
            " \n@example  Fetching and configuring a pipeline \n   The  get-step  can"
            " be used to fetch your configuration from  a `git` repo and auto-configure"
            " it using a    set-pipeline-step  :     ```yaml\njobs:\n- name:"
            " set-pipeline\n  plan:\n  - get: examples\n    trigger: true\n  -"
            " set_pipeline: hello-world  # pipeline's name\n    file:"
            " examples/pipelines/hello-world.yml  # pipeline's config\n\nresources:\n-"
            " name: examples\n  type: git\n  icon: github\n  source:\n    uri:"
            " https://github.com/concourse/examples.git\n```"
        ),
    )
    instance_vars: Optional[Vars] = Field(
        None,
        description=(
            "A map of instance vars used to identify    instanced-pipelines  instanced"
            " pipelines  . These vars will also be    pipeline-static-vars "
            " interpolated into the pipeline config  .    Note that variables set with"
            " this field will not propagate to tasks configured  via  schema.task.file "
            " . If you want those variables to be determined  at the time the pipeline"
            " is set, use  schema.task.vars  as well.          instanced-pipelines "
            " Instance pipelines  are experimental  and need to be enabled by setting"
            " the   `--enable-pipeline-instances` flag on the  web-node  .        "
            " \n@example  Configuring instance vars \n   The following pipeline will"
            " create one instance group with three  pipelines. The instance group is"
            " called `my-bots` and each  pipeline has a different set of"
            " `instance_vars` making it  distinct from the other pipelines in the"
            " instance group.   ```yaml\njobs:\n- name: set-pipeline-instance-group\n "
            " plan:\n  - get: examples\n  - in_parallel:\n    - set_pipeline: my-bots\n"
            "      file: examples/pipelines/pipeline-vars.yml\n      instance_vars:\n  "
            '      first: initial\n        number: "9000"\n        hello: HAL\n    -'
            " set_pipeline: my-bots\n      file: examples/pipelines/pipeline-vars.yml\n"
            '      instance_vars:\n        first: second\n        number: "3000"\n     '
            "   hello: WALLY-E\n    - set_pipeline: my-bots\n      file:"
            " examples/pipelines/pipeline-vars.yml\n      instance_vars:\n       "
            ' first: the-third\n        number: "6000"\n        hello:'
            " R2D2\n\nresources:\n- name: examples\n  type: git\n  icon: github\n "
            " source:\n    uri: https://github.com/concourse/examples.git\n```       "
            " \n@example  Configuring instance vars and vars \n   Both `instance_vars`"
            " and `vars` may be statically. The  difference between the two fields is"
            " that `instance_vars` are  used to identify a pipeline and render the"
            " pipeline config.   `vars` are only used for rendering the pipeline"
            " config:     ```yaml\njobs:\n- name: set-pipeline-vars-and-instance-vars\n"
            "  plan:\n  - get: examples\n  - set_pipeline: my-bots\n    file:"
            " examples/pipelines/pipeline-vars.yml\n    instance_vars:\n      first:"
            ' initial\n      number: "9000"\n    vars:\n      hello:'
            " HAL\n\nresources:\n- name: examples\n  type: git\n  icon: github\n "
            " source:\n    uri: https://github.com/concourse/examples.git\n```"
        ),
    )
    vars: Optional[Vars] = Field(
        None,
        description=(
            "A map of template variables to pass to the pipeline config. Unlike   "
            " schema.set-pipeline.instance_vars `instance_vars` ,   `vars` are solely"
            " used to for    pipeline-static-vars  interpolation  , and do not become a"
            " part of  the pipeline's identifier.    Note that variables set with this"
            " field will not propagate to tasks configured  via  schema.task.file  . If"
            " you want those variables to be determined  at the time the pipeline is"
            " set, use  schema.task.vars  as well.     \n@example  Configuring static"
            " vars \n    ```yaml\njobs:\n- name: set-pipeline-vars-only\n  plan:\n  -"
            " get: examples\n  - set_pipeline: pipeline-set-with-vars\n    file:"
            " examples/pipelines/pipeline-vars.yml\n    vars:\n      first: initial\n  "
            '    number: "9000"\n      hello: HAL\n\nresources:\n- name: examples\n '
            " type: git\n  icon: github\n  source:\n    uri:"
            " https://github.com/concourse/examples.git\n```"
        ),
    )
    team: Optional[Identifier] = Field(
        None,
        description=(
            "By default, the `set_pipeline` step sets the pipeline for the  same  teams"
            "  team  that is running the build.    The `team` attribute can be used to"
            " specify another team.    Only the  main-team  is allowed to set another"
            " team's  pipeline.  Any team other than the  main-team  using the   `team`"
            " attribute will error, unless they reference their own team.        The"
            " `team` attribute was introduced in Concourse v6.4.0. It is  considered an"
            " ** experimental ** feature and may be removed at any  time. Contribute to"
            " the associated    discussion "
            " https://github.com/concourse/concourse/discussions/5731    with feedback."
            "         \n@example  Setting a pipeline on another team \n   "
            " ```yaml\njobs:\n- name: set-pipeline\n  plan:\n  - get: examples\n   "
            " trigger: true\n  - set_pipeline: hello-world\n    file:"
            " examples/pipelines/hello-world.yml\n    team: other-team  # name of the"
            " team goes here\n\nresources:\n- name: examples\n  type: git\n  icon:"
            " github\n  source:\n    uri:"
            " https://github.com/concourse/examples.git\n```"
        ),
    )


class LoadVarStep(Step):
    class Config:
        extra = Extra.forbid

    format: Optional[Format] = Field(
        None,
        description=(
            "The format of the file's content.    If unset, Concourse will try to"
            " detect the format from the file  extension. If the file format cannot be"
            " determined, Concourse will  fallback to `trim` .    If set to `json` ,"
            " `yaml` , or `yml` , the file content  will be parsed accordingly and the"
            " resulting structure will be the  value of the var.    If set to `trim` ,"
            " the var will be set to the content of the file  with any trailing and"
            " leading whitespace removed.    If set to `raw` , the var will be set to"
            " the content of the file  without modification (i.e. with any existing"
            " whitespace).     \n@example  Loading a var with multiple fields \n  "
            " Let's say we have a file with multiple fields, like this yaml file:     "
            " yaml "
            " https://raw.githubusercontent.com/concourse/examples/master/pipelines/vars-file.yml"
            "      We could pass these values to subsequent steps by loading it  into a"
            " var with `load_var` , which will detect that it is in YAML  format based"
            " on the file extension:     ```yaml\njobs:\n- name: loading-vars\n "
            " plan:\n  - get: examples\n  - load_var: version\n    file:"
            " examples/pipelines/vars-file.yml\n  - put: img\n    params:\n     "
            ' version: "((.:version.hello))-((.:version.number))"\n\n\nresources:\n-'
            " name: examples\n  type: git\n  icon: github\n  source:\n    uri:"
            " https://github.com/concourse/examples.git\n- name: img\n  type: mock\n```"
            "     If the file `vars-file.yml` was generated in a task and printed "
            " these values, they would be automatically redacted unless   "
            " schema.load-var.reveal `reveal: true` is set."
        ),
    )
    load_var: Optional[Identifier] = Field(
        None,
        description=(
            "The identifier will be the name of var, available to subsequent steps  as"
            " a  local-vars  local build var  .     \n@example  Loading a simple value"
            " as a var \n   The following pipeline loads vars from a text file whose"
            " contents are  used as a version number to  put-step `put` .    "
            " ```yaml\njobs:\n- name: loading-vars\n  plan:\n  - get: examples\n  -"
            " load_var: version\n    file: examples/misc/simple-value.txt\n  - put:"
            " img\n    params:\n      version: ((.:version))\n\n\nresources:\n- name:"
            " examples\n  type: git\n  icon: github\n  source:\n    uri:"
            " https://github.com/concourse/examples.git\n- name: img\n  type: mock\n```"
            "      `simple-value.txt` looks like this:   "
            " https://raw.githubusercontent.com/concourse/examples/master/misc/simple-value.txt"
        ),
    )
    reveal: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  If set to `true` , allow the var's  content to be"
            " printed in the build output even with secret redaction  enabled."
        ),
    )
    file: Optional[str] = Field(
        None,
        description=(
            "The path to a file whose content shall be read and used as the var's "
            " value."
        ),
    )


class Resource(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[Identifier] = Field(
        None,
        description=(
            "The name of the resource. This should be short and simple. This name will "
            " be referenced by  build-plans  build plans  of jobs in the  pipeline."
        ),
    )
    version: Optional[Version] = Field(
        None,
        description=(
            "A version to pin the resource to across the pipeline. This has the same "
            " effect as setting  schema.get.version  on every    get-step  referencing"
            " the resource.    Resources can also be temporarily pinned to a version"
            " via the API and web UI.  However this functionality is disabled if the"
            " resource is pinned via  configuration, and if a pipeline is configured to"
            " have a version pinned while  also pinned in the web UI, the configuration"
            " takes precedence and will clear  out the temporary pin."
        ),
    )
    check_timeout: Optional[Duration] = Field(
        None,
        description=(
            "Default `1h` .  The time limit on checking new versions of  resources."
            " Acceptable interval options are defined by the    time.ParseDuration "
            " function  https://golang.org/pkg/time/#ParseDuration  ."
        ),
    )
    tags: Optional[list[str]] = Field(
        None,
        description=(
            "Default `[]` .  A list of tags to determine which workers the  checks will"
            " be performed on. You'll want to specify this if the source is  internal"
            " to a worker's network, for example.        This does not apply tags to"
            " all  get-step  get steps  or    put-step  put steps  that use the"
            " resource. If you want these steps  to use tags, you must set  schema.tags"
            "  for each step."
        ),
    )
    source: Optional[dict[str, Any]] = Field(
        None,
        description=(
            "The configuration for the resource. This varies by resource type, and is a"
            " black  box to Concourse; it is blindly passed to the resource at runtime."
            "    To use `git` as an example, the source may contain the repo URI, the "
            " branch of the repo to track, and a private key to use when"
            " pushing/pulling.    By convention, documentation for each resource type's"
            " configuration is  in each implementation's `README` .    You can find the"
            " source for the resource types provided with Concourse at the    Concourse"
            " GitHub  organization  https://github.com/concourse?q=-resource  ."
        ),
    )
    expose_build_created_by: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  If set to `true` , environment variable   "
            " resource-metadata `BUILD_CREATED_BY` will be available  in the metadata"
            " of a  get-step  get step  or    put-step  put step  ."
        ),
    )
    old_name: Optional[Identifier] = Field(
        None,
        description=(
            "The old name of the resource. If configured, the history of the old"
            " resource will be  inherited to the new one. Once the pipeline is set,"
            " this field can be  removed as the history has been transferred.    "
            " \n@example  Renaming a resource \n   This can be used to rename a"
            " resource without losing its history, like so:     ```yaml\nresources:\n-"
            " name: new-name\n  old_name: current-name\n  type: git\n  source: {uri:"
            ' "https://github.com/vito/booklit"}\n```     After the pipeline is set,'
            " the resource was successfully renamed, so the `old_name` field can  be"
            " removed from the resource:     ```yaml\nresources:\n- name: new-name\n "
            ' type: git\n  source: {uri: "https://github.com/vito/booklit"}\n```'
        ),
    )
    public: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  If set to `true` , the metadata for each  version of"
            " the resource will be viewable by unauthenticated users (assuming  the"
            " pipeline has been  exposing  exposed  ).    Resource metadata should"
            " never contain credentials or secret information, but  this is off by"
            " default just to be safe in case users don't want to show  things like"
            " commit messages and authors to the public.    Note: even when set to"
            " `false` , the versions identifiers will be  visible. In addition, if a"
            " resource is fetched in a build whose job is marked    schema.job.public "
            " , metadata will be visible in the build output."
        ),
    )
    check_every: Optional[Union[Duration, Literal["never"]]] = Field(
        None,
        description=(
            "Default `1m` .  The interval on which to check for new versions  of the"
            " resource. Acceptable interval options are defined by the   "
            " time.ParseDuration  function  https://golang.org/pkg/time/#ParseDuration "
            " .    If set to `never` the resource will not be automatically checked."
            " The  resource can still be checked manually via the web UI, fly, or"
            " webhooks."
        ),
    )
    webhook_token: Optional[str] = Field(
        None,
        description=(
            "If specified, web hooks can be sent to trigger an immediate  check    of"
            " the resource, specifying this value as a primitive form of "
            " authentication via query params.    After configuring this value, you"
            " would then configure your hook sender with  the following painfully long"
            " path appended to your external URL:     `\n     "
            " /api/v1/teams/TEAM_NAME/pipelines/PIPELINE_NAME/resources/RESOURCE_NAME/check/webhook?webhook_token=WEBHOOK_TOKEN\n"
            "    `     For  managing-instanced-pipelines  instance pipelines  you will "
            " need to include the pipeline vars for a single pipeline instance."
            " Currently  you can not have webhooks for all instances of a pipeline.   "
            " The pipeline vars should be added to the webhook URL as  URL  parameters "
            " https://developer.mozilla.org/en-US/docs/Learn/Common_questions/What_is_a_URL#parameters"
            '    with the format `vars.MY-VAR="SOME-VALUE"` . A webhook URL for a '
            " pipeline instance may look like this:     `\n     "
            ' /api/v1/teams/TEAM_NAME/pipelines/PIPELINE_NAME/resources/RESOURCE_NAME/check/webhook?webhook_token=WEBHOOK_TOKEN&vars.my-var="some-value"&vars.second-var="two"\n'
            "    `     Note that the request payload sent to this API endpoint is"
            " entirely  ignored.  You should configure the resource as if you're not"
            " using web  hooks, as the resource  schema.resource.source  config  is"
            ' still  the "source of truth."'
        ),
    )
    icon: Optional[str] = Field(
        None,
        description=(
            "The name of a  Material Design icon  https://materialdesignicons.com/   "
            " to show next to the resource name in the web UI. For example,  "
            " `github` ."
        ),
    )
    type: Optional[str] = Field(
        None,
        description="The  resource-types  resource type  implementing the resource.",
    )


class ContainerLimits(BaseModel):
    class Config:
        extra = Extra.forbid

    cpu: Optional[Number] = Field(
        None,
        description=(
            "The maximum amount of CPU available to the task container, measured in "
            " shares. 0 means unlimited.    CPU shares are relative to the CPU shares"
            " of other containers on a  worker. For example, if you have two containers"
            " both with a CPU  limit of 2 shares then each container will get 50% of"
            " the CPU's time.     ```\nContainer A: 2 shares - 50% CPU\nContainer B: 2"
            " shares - 50% CPU\nTotal CPU shares declared: 4\n```     If you introduce"
            " another container then the number of CPU time per  container changes. CPU"
            " shares are relative to each other.   ```\nContainer A: 2 shares - 25%"
            " CPU\nContainer B: 2 shares - 25% CPU\nContainer C: 4 shares - 50%"
            " CPU\nTotal CPU shares declared: 8\n```"
        ),
    )
    memory: Optional[Number] = Field(
        None,
        description=(
            "The maximum amount of memory available to the task container, measured in "
            " bytes. 0 means unlimited."
        ),
    )


class ResourceType(BaseModel):
    class Config:
        extra = Extra.forbid

    privileged: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  If set to `true` , the resource's  containers will be"
            " run with full capabilities, as determined by the worker  backend the task"
            " runs on.    For Linux-based backends it typically determines whether or"
            " not the  container will run in a separate user namespace, and whether the"
            '   `root` user is "actual" `root` (if set to `true` ) or a user '
            " namespaced `root` (if set to `false` , the default).    This is a gaping"
            " security hole; only configure it if the resource type needs  it (which"
            " should be called out in its documentation). This is not up to the "
            " resource type to decide dynamically, so as to prevent privilege"
            " escalation  via third-party resource type exploits."
        ),
    )
    params: Optional[dict[str, Any]] = Field(
        None,
        description=(
            "Arbitrary config to pass when running the `get` to fetch the resource "
            " type's image."
        ),
    )
    source: Optional[dict[str, Any]] = Field(
        None,
        description=(
            "The configuration for the resource type's resource. This varies  by"
            " resource type, and is a black box to Concourse; it is blindly passed to "
            " the resource at runtime.    To use `registry-image` as an example, the"
            " source would contain something  like `repository: username/reponame` ."
            " See the  Registry Image  resource "
            " https://github.com/concourse/registry-image-resource  (or whatever "
            " resource type your resource type uses) for more information."
        ),
    )
    tags: Optional[list[str]] = Field(
        None,
        description=(
            "Default `[]` .  A list of tags to determine which workers the  checks will"
            " be performed on. You'll want to specify this if the source is  internal"
            " to a worker's network, for example. See also    schema.tags  ."
        ),
    )
    type: Optional[Union[str, Identifier]] = Field(
        None,
        description=(
            "The type of the resource used to provide the resource type's container "
            " image.    This is a bit meta. Usually this value will be `registry-image`"
            " as the  resource type must result in a container image.    A resource"
            " type's type can refer to other resource types, and can also use the  core"
            " type that it's overriding. This is useful for bringing in a newer or "
            " forked `registry-image` resource."
        ),
    )
    name: Optional[Identifier] = Field(
        None,
        description=(
            "The name of the resource type. This should be short and simple. This name "
            " will be referenced by  schema.pipeline.resources  defined within  the"
            " same pipeline, and  schema.task-config.image_resource  s used  by tasks"
            " running in the pipeline.    Pipeline-provided resource types can override"
            " the core resource types by  specifying the same name."
        ),
    )
    check_every: Optional[Duration] = Field(
        None,
        description=(
            "Default `1m` .  The interval on which to check for new versions  of the"
            " resource type. Acceptable interval options are defined by the   "
            " time.ParseDuration  function "
            " https://golang.org/pkg/time/#ParseDuration  ."
        ),
    )
    defaults: Optional[dict[str, Any]] = Field(
        None,
        description=(
            "The default configuration for the resource type. This varies  by resource"
            " type, and is a black box to Concourse; it is merged with  (duplicate"
            " fields are overwritten by)  schema.resource.source    and passed to the"
            " resource at runtime.     \n@example  Setting default configuration for"
            " resources \n    ```yaml\nresource_types:\n- name: gcs\n  type:"
            " registry-image\n  source:\n    repository: frodenas/gcs-resource\n "
            " defaults:\n    json_key: ((default_key))\n\nresources:\n- name:"
            " bucket-a\n  type: gcs\n  source:\n    bucket: a\n\n- name: bucket-b\n "
            " type: gcs\n  source:\n    bucket: b\n\n- name: bucket-c\n  type: gcs\n "
            " source:\n    bucket: c\n    json_key: ((different_key))\n```         "
            " \n@example  Overriding default resource types \n   Since it's possible to"
            " overwrite the base resource types, it can be  used to give defaults to"
            " resources at the pipeline level.     ```yaml\nresource_types:\n- name:"
            " registry-image\n  type: registry-image\n  source:\n    repository:"
            " concourse/registry-image-resource\n  defaults:\n    registry_mirror:\n   "
            "   host: https://registry.mirror.example.com\n\nresources:\n- name:"
            " mirrored-image\n  type: registry-image\n  source:\n    repository:"
            " busybox\n```     Alternatively, the web node can be configured to use   "
            " resource-defaults  defaults for base resource types"
        ),
    )


class GetStep(Step):
    class Config:
        extra = Extra.forbid

    version: Optional[Union[Literal["latest"], Literal["every"], Version]] = Field(
        None,
        description=(
            "Default `latest` .  The version of the resource to fetch.    If set to"
            " `latest` , scheduling will just find the latest available  version of a"
            " resource and use it, allowing versions to be skipped.  This is  usually"
            " what you want, e.g. if someone pushes 100 git commits.    If set to"
            " `every` , builds will walk through all available versions of  the"
            " resource. Note that if `passed` is also configured, it will only  step"
            " through the versions satisfying the constraints.    If set to a specific"
            " version (e.g. `{ref: abcdef123}` ), only that  version will be used. Note"
            " that the version must be available and detected by  the resource,"
            " otherwise the input will never be satisfied. You may want to  use "
            " fly-check-resource  to force detection of resource versions,  if you need"
            " to use an older one that was never detected (as all newly  configured"
            " resources start from the latest version)."
        ),
    )
    passed: Optional[list[str]] = Field(
        None,
        description=(
            "When specified, only the versions of the resource that made it through "
            " the given list of jobs (AND-ed together) will be considered when "
            " triggering and fetching.     \n@example  Fanning out and in \n   If"
            " multiple `get` s are configured with `passed`   constraints, all of the"
            " mentioned jobs are correlated.     ```yaml\njobs:\n- name:"
            " lvl-1-firewall\n  plan:\n  - in_parallel:\n    - get: black-ice\n    -"
            " get: control-node\n    - get: cyberdeck\n\n- name: lvl-2-unit\n  plan:\n "
            " - in_parallel:\n    - get: black-ice\n      passed: [lvl-1-firewall]\n   "
            " - get: control-node\n      passed: [lvl-1-firewall]\n    - get:"
            " cyberdeck\n      passed: [lvl-1-firewall]\n\n- name: lvl-2-integration\n "
            " plan:\n  - in_parallel:\n    - get: black-ice\n      passed:"
            " [lvl-1-firewall]\n    - get: control-node\n      passed:"
            " [lvl-1-firewall]\n    - get: cyberdeck\n      passed:"
            " [lvl-1-firewall]\n\n- name: lvl-3-production\n  plan:\n  - in_parallel:\n"
            "    - get: black-ice\n      passed: [lvl-2-unit,lvl-2-integration]\n    -"
            " get: control-node\n      passed: [lvl-2-unit,lvl-2-integration]\n    -"
            " get: cyberdeck\n      passed:"
            " [lvl-2-unit,lvl-2-integration]\n\nresources:\n- name: black-ice\n  type:"
            " mock\n  source:\n    initial_version: lvl4\n- name: control-node\n  type:"
            " mock\n  source:\n    initial_version: tower\n- name: cyberdeck\n  type:"
            " mock\n  source:\n    initial_version: mk3\n```     For the final job,"
            " `lvl-3-production` , only versions that have  passed the previous two"
            " jobs ( `lvl-2-unit` and   `lvl-2-integration` ) will be passed to"
            " `lvl-3-production` .    This is crucial to being able to implement safe"
            ' "fan-in" semantics as  things progress through a pipeline.'
        ),
    )
    trigger: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  If set to `true` , new builds of the  job will be"
            " automatically created when a new version for this input  becomes"
            " available.    Note: if none of a job's `get` steps are set to `true` ,"
            " the  job can only be manually triggered.     \n@example  Automatically"
            " trigger job on new versions \n      ```yaml\njobs:\n- name: fetch-repo\n "
            " plan:\n  - get: repo\n    trigger: true # automatically runs the job\n  -"
            " task: ls-repo\n    config:\n      platform: linux\n     "
            " image_resource:\n        type: mock\n        source: {mirror_self:"
            " true}\n      inputs:\n      - name: repo\n      run:\n        path: ls\n "
            '       args: ["-lah","repo"]\n\nresources:\n- name: repo\n  type: git\n '
            " source:\n    uri: https://github.com/concourse/examples.git\n```"
        ),
    )
    get: Optional[Union[str, Identifier]] = Field(
        None,
        description=(
            "The fetched bits will be registered in the build's artifact namespace "
            " under the given identifier. Subsequent  task-step  and    put-step  which"
            " list the identifier as an input will have a  copy of the bits in their"
            " working directory.     \n@example  Fetching a repo and passing it to a"
            " task \n   Almost every simple job will look something like this: fetch my"
            " code  with a  get-step  and do something (run tests) with it in a   "
            " task-step  .     ```yaml\njobs:\n- name: fetch-repo\n  plan:\n  - get:"
            ' repo # fetches repo under artifact name "repo"\n  - task: ls-repo\n   '
            " config:\n      platform: linux\n      image_resource:\n        type:"
            ' mock\n        source: {mirror_self: true}\n      # pass the "repo"'
            " artifact into the task\n      inputs:\n      - name: repo\n      run:\n  "
            '      path: ls\n        args: ["-lah","repo"]\n\nresources:\n- name:'
            " repo\n  type: git\n  source:\n    uri:"
            " https://github.com/concourse/examples.git\n```"
        ),
    )
    resource: Optional[str] = Field(
        None,
        description=(
            "Defaults to the value of `get` .  The resource to fetch,  as configured in"
            "  schema.pipeline.resources  .    Use this attribute to rename a resource"
            " from the overall pipeline context  into the job-specific context.    "
            " \n@example  Re-labelling artifact \n    ```yaml\njobs:\n- name:"
            ' fetch-repo\n  plan:\n  - get: thecode # fetches "repo" under artifact'
            ' name "thecode"\n    resource: repo\n  - task: ls-repo\n    config:\n     '
            " platform: linux\n      image_resource:\n        type: mock\n       "
            ' source: {mirror_self: true}\n      # pass the "thecode" artifact into the'
            " task\n      inputs:\n      - name: thecode\n      run:\n        path:"
            ' ls\n        args: ["-lah","thecode"]\n\nresources:\n- name: repo\n  type:'
            " git\n  source:\n    uri: https://github.com/concourse/examples.git\n```"
        ),
    )
    params: Optional[dict[str, Any]] = Field(
        None,
        description=(
            "Arbitrary configuration to pass to the resource. Refer to the resource "
            " type's documentation to see what it supports.     \n@example  Fetching"
            " with `params`\n    ```yaml\njobs:\n- name: resource-params\n  plan:\n  -"
            " get: cyberdeck\n    params:\n      create_files_via_params:\n       "
            ' version_to_put.txt: "made-via-params"\n  - put: cyberdeck\n    params:\n '
            "     file: cyberdeck/version_to_put.txt\n\n\nresources:\n- name:"
            " cyberdeck\n  type: mock\n```"
        ),
    )


class VaultVarSource(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[Literal["vault"]] = Field(
        None,
        description=(
            "The `vault` type supports configuring a    Vault "
            " https://www.vaultproject.io  server as a   `((var))` source."
        ),
    )
    config: Optional[VaultConfig] = Field(
        None,
        description=(
            "Configuration for the Vault server has the following schema:     "
            " vault_config      url  string    The URL of the Vault API.         "
            " ca_cert  string    The PEM encoded contents of a CA certificate to use"
            " when  connecting to the API.          path_prefix  string      Default"
            " `/concourse` .  A prefix under which to  look for all credential values. "
            "   See  vault-path-prefix  for more information.          lookup_templates"
            '  [string]      Default `["/{{.Team}}/{{.Pipeline}}/{{.Secret}}",'
            ' "/{{.Team}}/{{.Secret}}"]` .      A list of path templates to be expanded'
            " in a team and pipeline context  subject to the `path_prefix` and"
            " `namespace` .    See  vault-lookup-templates  for more information.      "
            "    shared_path  string    An additional path under which credentials will"
            " be looked up.    See  vault-shared-path  for more information.         "
            " namespace  string    A  Vault  namespace "
            " https://www.vaultproject.io/docs/enterprise/namespaces/index.html    to"
            " operate under.          client_cert  string    A PEM encoded client"
            " certificate, for use with TLS based auth.    See  vault-cert-auth  for"
            " more information.          client_key  string    A PEM encoded client"
            " key, for use with TLS based auth.    See  vault-cert-auth  for more"
            " information.          server_name  string    The expected name of the"
            " server when connecting through TLS.          insecure_skip_verify "
            " boolean    Skip TLS validation. Not recommended. Don't do it. No really,"
            "  don't.          client_token  string    Authenticate via a periodic"
            " client token.    See  vault-periodic-token  for more information.        "
            "  auth_backend  string    Authenticate using an auth backend, e.g. `cert`"
            " or   `approle` .    See  vault-approle-auth  or  vault-cert-auth  for "
            " more information.          auth_params  {string: string}    A key-value"
            " map of parameters to pass during authentication.    See "
            " vault-approle-auth  for more information.          auth_max_ttl  duration"
            "    Maximum duration to elapse before forcing the client to log in  again."
            "          auth_retry_max  duration    When failing to authenticate, give"
            " up after this amount of  time.          auth_retry_initial  duration   "
            " When retrying during authentication, start with this retry  interval. The"
            " interval will increase exponentially until   `auth_retry_max` is reached."
        ),
    )


class TaskConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    image_resource: Optional[AnonymousResource] = Field(
        None,
        description=(
            "The container image to run with, as provided by an anonymous    resources "
            " resource  definition.    Whenever the task runs, the anonymous resource"
            " will be `check` ed to  discover the latest version available. The image"
            " will then be fetched onto  the worker, if necessary, just prior to"
            " running the task.    To use an image provided by a previous step within"
            " your build plan, set    schema.task.image  on the  task-step    instead. "
            "        ** NOTE: ** This field is only required for tasks targeting the   "
            " schema.task-config.platform  Linux platform  . This field will be "
            " ignored for Windows and Darwin workers. Windows containers are currently "
            " not supported and Darwin does not have native containers. The task will "
            " run inside a clean temporary directory on the Windows/Darwin worker with "
            " any inputs and outputs copied into the same directory. Any dependencies "
            " should be pre-installed on the worker.         \n@example  Using the"
            " `golang` Docker image \n   The following task config will use the"
            " `golang` Docker  image  https://hub.docker.com/_/golang  to run `go"
            " version` :     ```yaml\nplatform: linux\n\nimage_resource:\n  type:"
            " registry-image\n  source: {repository: golang}\n\nrun:\n  path: go\n "
            " args: [version]\n```           anonymous_resource      type "
            " resource_type.name    The type of the resource. Usually `registry-image`"
            " .    You can use any resource type that returns a filesystem in the"
            " correct  format: a `/rootfs` directory containing a full filesystem, and"
            " a   `metadata.json` file containing.          source  config    The"
            " configuration for the resource; see    schema.resource.source  .         "
            " params  config    A map of arbitrary configuration to forward to the"
            " resource. Refer to the  resource type's documentation to see what it"
            " supports.          version  version    A specific version of the resource"
            " to fetch. This should be a map with  string keys and values. If not"
            " specified, the latest version will be  fetched."
        ),
    )
    caches: Optional[list[Cache]] = Field(
        None,
        description=(
            "The cached directories shared between task runs.    On the task's first"
            " run, all cache directories will be empty. It is the  responsibility of"
            " the task to populate these directories with any artifacts  to be cached."
            " On subsequent runs, the cached directories will contain those  artifacts."
            "    Caches are scoped to the worker the task is run on, so you will not"
            " get a  cache hit when subsequent builds run on different workers. This"
            " also means  that caching is not intended to share state between workers,"
            " and your task  should be able to run whether or not the cache is warmed. "
            "   Caches are also scoped to a particular task name inside of a pipeline's"
            "  job. As a consequence, if the job name, step name or cache path are "
            " changed, the cache will not be used. This also means that caches do not "
            " exist for one-off builds.      cache      path  dir-path    The path to a"
            " directory to be cached.    Paths are relative to the working directory of"
            " the task. Absolute paths  are not respected."
        ),
    )
    run: Optional[Command] = Field(
        None,
        description=(
            "The command to execute in the container.    Note that this is  not "
            " provided as a script blob, but explicit   `path` and `args` values; this"
            " allows `fly` to forward  arguments to the script, and forces your config"
            " `.yml` to stay fairly  small.      command      path  file-path    The"
            " name of or path to the executable to run.     `path` is relative to the"
            " working directory. If `dir` is  specified to set the working directory,"
            " then `path` is relative to  it.    This is commonly a path to a script"
            " provided by one of the task's inputs,  e.g. `my-resource/scripts/test` ."
            " It could also be a command like   `bash` (respecting standard `$PATH`"
            " lookup rules), or an absolute  path to a file to execute, e.g."
            " `/bin/bash` .          args  [string]    Arguments to pass to the"
            " command. Note that when executed with    fly-cli  Fly  , any arguments"
            " passed to  fly-execute    are appended to this array.          dir "
            " dir-path    A directory, relative to the initial working directory, to"
            " set as the  working directory when running the script.          user "
            " string    Explicitly set the user to run as. If not specified, this"
            " defaults to the  user configured by the task's image. If not specified"
            " there, it's up to  the Garden backend, and may be e.g. `root` on Linux."
        ),
    )
    inputs: Optional[list[Input]] = Field(
        None,
        description=(
            "The set of artifacts used by task, determining which artifacts will be "
            " available in the current directory when the task runs.    These are"
            " satisfied by  get-step  s or    schema.task-config.outputs  of a previous"
            " task. These can also  be provided by `-i` with  fly-execute  .    If any"
            " required inputs are missing at run-time, then the task will error "
            " immediately.      input      name  identifier    The name of the input.  "
            "        path  dir-path    The path where the input will be placed. If not"
            " specified, the input's   `name` is used.    Paths are relative to the"
            " working directory of the task. Absolute paths  are not respected.        "
            "  optional  boolean      Default `false` .  If `true` , then the input is"
            " not  required by the task. The task may run even if this input is"
            " missing.    An `optional` input that is missing will not appear in the"
            " current  directory of the running task."
        ),
    )
    platform: Optional[Platform] = Field(
        None,
        description=(
            "The platform the task should run on. This determines the pool of workers "
            " that the task can run against.    Technically any string value is allowed"
            " so long as a worker advertises the  same platform, but in practice only"
            " `linux` , `darwin` , and   `windows` are in use."
        ),
    )
    params: Optional[dict[str, Optional[str]]] = Field(
        None,
        description=(
            "A key-value mapping of string keys and values that are exposed to the task"
            "  via environment variables.    Pipelines can override these params by"
            " setting    schema.task.params  on the  task-step  . This is a common "
            " method of providing credentials to a task."
        ),
    )
    container_limits: Optional[ContainerLimits] = Field(
        None,
        description=(
            "CPU and memory limits to enforce on the task container.    Note that these"
            " values, when specified, will override any limits set by  passing the"
            " `--default-task-cpu-limit` or   `--default-task-memory-limit` flags to"
            " the `concourse web` command.      container_limits      cpu  number   "
            " The maximum amount of CPU available to the task container, measured in "
            " shares. 0 means unlimited.    CPU shares are relative to the CPU shares"
            " of other containers on a  worker. For example, if you have two containers"
            " both with a CPU  limit of 2 shares then each container will get 50% of"
            " the CPU's time.     ```\nContainer A: 2 shares - 50% CPU\nContainer B: 2"
            " shares - 50% CPU\nTotal CPU shares declared: 4\n```     If you introduce"
            " another container then the number of CPU time per  container changes. CPU"
            " shares are relative to each other.   ```\nContainer A: 2 shares - 25%"
            " CPU\nContainer B: 2 shares - 25% CPU\nContainer C: 4 shares - 50%"
            " CPU\nTotal CPU shares declared: 8\n```           memory  number    The"
            " maximum amount of memory available to the task container, measured in "
            " bytes. 0 means unlimited."
        ),
    )
    outputs: Optional[list[Output]] = Field(
        None,
        description=(
            "The artifacts produced by the task.    Each output configures a directory"
            " to make available to later steps in the    build-plans  build plan  . The"
            " directory will be automatically  created before the task runs, and the"
            " task should place any artifacts it  wants to export in the directory.    "
            "  output      name  identifier    The name of the output. The contents"
            " under `path` will be made  available to the rest of the plan under this"
            " name.          path  dir-path    The path to a directory where the output"
            " will be taken from. If not  specified, the output's `name` is used.   "
            " Paths are relative to the working directory of the task. Absolute paths"
            " are not respected."
        ),
    )
    rootfs_uri: Optional[str] = Field(
        None,
        description=(
            "A string specifying the rootfs uri of the container, as interpreted by"
            " your  worker's Garden backend.      schema.task-config.image_resource  is"
            " the preferred way to specify base image.  You should only use this if you"
            " have no other option and you really know  what you're doing."
        ),
    )


class TaskStep(Step):
    class Config:
        extra = Extra.forbid

    config: Optional[TaskConfig] = Field(
        None,
        description=(
            "The  tasks  task config  to execute.   \n@example  Task config \n   "
            " ```yaml\njobs:\n- name: job\n  public: true\n  plan:\n  - task:"
            " simple-task\n    config: # contains all field in a task config\n     "
            " platform: linux\n      image_resource:\n        type: registry-image\n   "
            "     source: { repository: busybox }\n      run:\n        path: echo\n    "
            '    args: ["Hello world!"]\n```'
        ),
    )
    file: Optional[str] = Field(
        None,
        description=(
            "A dynamic alternative to  schema.task.config  .     `file` points at a"
            " `.yml` file containing the    tasks  task config  , which allows this to"
            " be tracked with  your resources.    The first segment in the path should"
            " refer to another source from the  plan, and the rest of the path is"
            " relative to that source.    The content of the config file may contain"
            " template `((vars))` ,  which will be filled in using  schema.task.vars   "
            " or a configured  creds  credential manager  .   \n@example  Using a task"
            " config file \n   Uses  this config file "
            " https://github.com/concourse/examples/blob/master/tasks/hello-world.yml "
            " .   ```yaml\njobs:\n- name: task-config-in-file\n  plan:\n  - get: ci\n "
            " - task: config-from-file\n    file:"
            " ci/tasks/hello-world.yml\n\nresources:\n- name: ci\n  type: git\n "
            " source:\n    uri: https://github.com/concourse/examples.git\n```"
        ),
    )
    params: Optional[dict[str, Optional[str]]] = Field(
        None,
        description=(
            "A map of task environment variable parameters to set, overriding those "
            " configured in the task's `config` or `file` .    The difference between "
            " schema.task.params `params`   and  schema.task.vars `vars` is that   "
            " schema.task.vars `vars` allows you to interpolate any  template variable"
            " in an external task file, while    schema.task.params `params` can be"
            " used to overwrite  task parameters specifically. Also,   "
            " schema.task.params `params` can have default values  declared in the"
            " task.     \n@example  Running a task with env var params \n   Let's say"
            " we have a  schema.task-config  task config  like  so:      yaml "
            " https://raw.githubusercontent.com/concourse/examples/master/tasks/print-param.yml"
            "      This indicates that there are two params which can be set:  "
            " `ECHO_ME` , which has a default, and `ALSO_ME` which has no  default set."
            "    A pipeline could run the task with values passed in like so:    "
            " ```yaml\njobs:\n- name: task-params\n  plan:\n  - get: ci\n  - task:"
            " constrained-task\n    file: ci/tasks/print-param.yml\n    params:\n     "
            ' ECHO_ME: "Eat your fruits"\n      ALSO_ME: "veggies"\n\nresources:\n-'
            " name: ci\n  type: git\n  source:\n    uri:"
            " https://github.com/concourse/examples.git\n```          \n@example  Using"
            " with `((vars))`\n    ```yaml\njobs:\n- name: task-params\n  plan:\n  -"
            " get: ci\n  - task: constrained-task\n    file: ci/tasks/print-param.yml\n"
            "    params:\n      ECHO_ME: ((some-var))\n      ALSO_ME:"
            " ((another-var))\n\nresources:\n- name: ci\n  type: git\n  source:\n   "
            " uri: https://github.com/concourse/examples.git\n```"
        ),
    )
    task: Optional[Identifier] = Field(
        None,
        description=(
            "The identifier value is just a name - short and sweet. The value is  shown"
            " in the web UI but otherwise has no affect on anything. This may  change"
            " in the future;  RFC  #32  https://github.com/concourse/rfcs/pull/32 "
            " proposes that the name  be used to reference a file within the project.  "
            "   \n@example  Functions from inputs to outputs \n   You can think of"
            " tasks like functions. They have predefined inputs  and outputs and can be"
            " written in idempotent ways.    The following pipeline contains a function"
            " that increments a number.  You can think of the task `add-one` like this"
            " pseudo-function:     ```\nfunc AddOne(num int) int {\n  return num +"
            " 1\n}\n```      ```yaml\njobs:\n- name: idempotent-task\n  plan:\n  - get:"
            " counter\n  - task: add-one\n    config:\n      platform: linux\n     "
            " image_resource:\n        type: mock\n        source: {mirror_self:"
            " true}\n      inputs:\n      - name: counter\n      outputs:\n      -"
            " name: counter\n      run:\n        path: sh\n        args:\n        -"
            " -c\n        - |\n          COUNTER=$(cat counter/version)\n         "
            ' NEXT=$(($COUNTER + 1))\n          echo "new version: $NEXT"\n         '
            " echo $NEXT > counter/next\n  - put: counter\n    params:\n      file:"
            " counter/next\n\nresources:\n- name: counter\n  type: mock\n  source:\n   "
            ' initial_version: "1"\n```'
        ),
    )
    privileged: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  If set to `true` , the task will run  with escalated"
            " capabilities available on the task's platform.        Setting"
            " `privileged: true` is a gaping security hole; use wisely  and only if"
            " necessary. This is not part of the task configuration in  order to"
            " prevent privilege escalation via pull requests changing the  task file.  "
            "      For the `linux` platform, this determines whether or not the "
            " container will run in a separate user namespace. When set to   `true` ,"
            " the container's `root` user is  actual     `root` , i.e. not in a user"
            " namespace. This is not recommended, and  should  never  be used with code"
            " you do not trust - e.g. pull  requests.    For macOS and Windows this"
            " field has no effect since workloads on  those machines are not"
            " containerized."
        ),
    )
    vars: Optional[Vars] = Field(
        None,
        description=(
            "A map of template variables to pass to an external task. Not to be "
            " confused with  schema.task.params  , which provides    environment"
            " variables  to the task.    This is to be used with external tasks defined"
            " in    schema.task.file  .     \n@example  Parameterizing a task config"
            " file with vars \n   A var may be statically passed like so:    "
            " ```yaml\njobs:\n- name: task-vars\n  plan:\n  - get: ci\n  - task:"
            " override-task-vars\n    file: ci/tasks/print-var.yml\n    vars: #"
            ' statically defined vars\n      my-var: "Cookies are the best"\n     '
            ' second-var: "chips are a close second"\n\nresources:\n- name: ci\n  type:'
            " git\n  source:\n    uri: https://github.com/concourse/examples.git\n```  "
            "   When run with the following  tasks  task config  :      yaml "
            " https://raw.githubusercontent.com/concourse/examples/master/tasks/print-var.yml"
            '      The `"((my-var))"` will be resolved to `"Cookies are the\n         '
            ' best"` and `((second-var))` will be resolved to `"chips are\n          a'
            ' close second"` .    This can also be used in combination with  vars  from'
            " a    creds  credential manager  (i.e. Vault) as a way to re-map  variable"
            " names to match what the task is expecting:     ```yaml\njobs:\n- name:"
            " task-vars\n  plan:\n  - get: ci\n  - task: override-task-vars\n    file:"
            " ci/tasks/print-var.yml\n    vars: # re-mapped vars\n      my-var:"
            " ((var-from-vault))\n      second-var: ((apple.type))\n\nresources:\n-"
            " name: ci\n  type: git\n  source:\n    uri:"
            " https://github.com/concourse/examples.git\n```"
        ),
    )
    output_mapping: Optional[dict[str, str]] = Field(
        None,
        description=(
            "A map from task output names to concrete names to register in the build "
            " plan. This allows a task with generic output names to be used multiple "
            " times in the same plan.     \n@example  Using with `input_mapping`\n  "
            " This is often used together with    schema.task.input_mapping  :    Given"
            " this task config:    yaml "
            " https://raw.githubusercontent.com/concourse/examples/master/tasks/generic-outputs.yml"
            "      This pipeline will map the inputs and outputs of the task to match "
            " the name of the resources in the pipeline.   ```yaml\njobs:\n- name:"
            " task-output-mapping\n  plan:\n  - in_parallel:\n    - get: repo\n    -"
            " get: repo-dev\n    - get: ci\n  - task: create-outputs\n   "
            " input_mapping:\n      main: repo\n      dev: repo-dev\n   "
            " output_mapping:\n      main: repo\n      dev: repo-dev\n    file:"
            " ci/tasks/generic-outputs.yml\n  - in_parallel:\n    - put: repo\n     "
            " params:\n        file: repo/version\n    - put: repo-dev\n      params:\n"
            "        file: repo-dev/version\n\nresources:\n- name: repo\n  type:"
            " mock\n- name: repo-dev\n  type: mock\n- name: ci\n  type: git\n "
            " source:\n    uri: https://github.com/concourse/examples.git\n```"
        ),
    )
    image: Optional[Identifier] = Field(
        None,
        description=(
            "Specifies an artifact source containing an image to use for the task. "
            " This overrides any  schema.task-config.image_resource  configuration"
            " present in  the task configuration.    This is very useful when part of"
            " your pipeline involves building an image,  possibly with dependencies"
            " pre-baked. You can then propagate that image  through the rest of your"
            " pipeline, guaranteeing that the correct version (and  thus a consistent"
            " set of dependencies) is used throughout your pipeline.     \n@example "
            " Fetching and using an image \n   This can be used to explicitly keep"
            " track of dependent images. You  could also modify it to build and push"
            " the image in one job and use  it in later jobs. See "
            " building-and-pushing-an-image  .     ```yaml\nresources:\n- name:"
            " golang\n  type: registry-image\n  source:\n    repository: golang  #"
            ' could also be the full URL "docker.io/golang"\n    tag:'
            ' "1.17"\n\njobs:\n- name: fetch-and-run-image\n  plan:\n  - get: golang\n '
            " - task: use-fetched-image-in-task\n    image: golang   # reference the"
            " image from the get step\n    config:\n      platform: linux\n      run:\n"
            '        path: go\n        args: ["version"]\n```          \n@example '
            " Building and using an image \n    "
            " building-an-image-and-using-it-in-a-task"
        ),
    )
    input_mapping: Optional[dict[str, str]] = Field(
        None,
        description=(
            "A map from task input names to concrete names in the build plan. This "
            " allows a task with generic input names to be used multiple times in the "
            " same plan, mapping its inputs to specific resources within the plan.    "
            " \n@example  Generic task input names \n   The following example"
            " demonstrates a task with generic `main`   and `dev` inputs being mapped"
            " to more specific artifact names,   `repo` and `repo-dev` :    "
            " ```yaml\njobs:\n- name: task-input-mapping\n  plan:\n  - in_parallel:\n  "
            "  - get: repo\n    - get: repo-dev\n    - get: ci\n  - task: list-inputs\n"
            "    input_mapping:\n      main: repo\n      dev: repo-dev\n    file:"
            " ci/tasks/generic-inputs.yml\n\nresources:\n- name: repo\n  type: mock\n-"
            " name: repo-dev\n  type: mock\n- name: ci\n  type: git\n  source:\n   "
            " uri: https://github.com/concourse/examples.git\n```"
        ),
    )
    container_limits: Optional[ContainerLimits] = Field(
        None,
        description=(
            "CPU and memory limits to enforce on the task container.    Note that these"
            " values, when specified, will override any limits set by  passing the"
            " `--default-task-cpu-limit` or   `--default-task-memory-limit` flags to"
            " the `concourse web` command.    These values will also override any"
            " configuration set on a    schema.task-config.container_limits  task's"
            " config   `container_limits` .      cpu  number    The maximum amount of"
            " CPU available to the task container, measured in  shares. 0 means"
            " unlimited.    CPU shares are relative to the CPU shares of other"
            " containers on a  worker. For example, if you have two containers both"
            " with a CPU  limit of 2 shares then each container will get 50% of the"
            " CPU's time.     ```\nContainer A: 2 shares - 50% CPU\nContainer B: 2"
            " shares - 50% CPU\nTotal CPU shares declared: 4\n```     If you introduce"
            " another container then the number of CPU time per  container changes. CPU"
            " shares are relative to each other.   ```\nContainer A: 2 shares - 25%"
            " CPU\nContainer B: 2 shares - 25% CPU\nContainer C: 4 shares - 50%"
            " CPU\nTotal CPU shares declared: 8\n```           memory  number    The"
            " maximum amount of memory available to the task container, measured in "
            " bytes. 0 means unlimited.         \n@example  Setting CPU and Memory"
            " limits \n   This task will only be given 10MB of memory and 2 CPU shares."
            "     ```yaml\njobs:\n- name: limited-resources\n  plan:\n  - task:"
            " constrained-task\n    container_limits:\n      cpu: 2 # CPU shares are"
            " relative\n      memory: 10000000 # 10MB\n    config:\n      platform:"
            " linux\n      image_resource:\n        type: registry-image\n       "
            " source: { repository: busybox }\n      run:\n        path: echo\n       "
            ' args: ["Hello world!"]\n```'
        ),
    )


class InParallelStep(Step):
    class Config:
        extra = Extra.forbid

    in_parallel: Optional[Union[list[Step], InParallelConfig]] = Field(
        None,
        description=(
            "Steps are either configured as a array or within an   "
            " schema.in_parallel_config  .     \n@example  Fetching artifacts in"
            " parallel \n   Using the `in_parallel` step where possible is the easiest"
            " way  to speeding up a builds.    It is often used to fetch all dependent"
            " resources together at the  start of a build plan:     ```yaml\njobs:\n-"
            " name: get-in-parallel\n  plan:\n  - in_parallel:\n    - get: ci\n    -"
            " get: repo\n    - get: code\n\n\nresources:\n- name: repo\n  type: mock\n-"
            " name: code\n  type: mock\n- name: ci\n  type: mock\n```         "
            " \n@example  Running a build matrix \n   If any step in the `in_parallel`"
            " fails, the build will fail, making it  useful for build matrices:    "
            " ```yaml\nplan:\n- get: some-repo\n- in_parallel:\n  - task:"
            " unit-windows\n    file: some-repo/ci/windows.yml\n  - task: unit-linux\n "
            "   file: some-repo/ci/linux.yml\n  - task: unit-darwin\n    file:"
            " some-repo/ci/darwin.yml\n```"
        ),
    )


class Job(BaseModel):
    class Config:
        extra = Extra.forbid

    build_logs_to_retain: Optional[Number] = Field(
        None,
        description=(
            "Deprecated.  Equivalent to setting   "
            " schema.build_log_retention_policy.builds"
            " `job.build_log_retention.builds` ."
        ),
    )
    max_in_flight: Optional[Number] = Field(
        None,
        description=(
            "If set, specifies a maximum number of builds to run at a time. If  "
            " `serial` or `serial_groups` are set, they take precedence and  force this"
            " value to be `1` ."
        ),
    )
    serial: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  If set to `true` , builds will queue up  and execute"
            " one-by-one, rather than executing in parallel."
        ),
    )
    old_name: Optional[Identifier] = Field(
        None,
        description=(
            "The old name of the job. If configured, the history of old job will be "
            " inherited to the new one. Once the pipeline is set, this field can be "
            " removed as the builds have been transfered.     \n@example  Renaming a"
            " job \n   This can be used to rename a job without losing its history,"
            " like so:     ```yaml\njobs:\n- name: new-name\n  old_name: current-name\n"
            "  plan: [{get: 10m}]\n```     After the pipeline is set, because the"
            " builds have been inherited, the job can  have the field removed:    "
            " ```yaml\njobs:\n- name: new-name\n  plan: [{get: 10m}]\n```"
        ),
    )
    on_success: Optional[Step] = Field(
        None,
        description=(
            "Step to execute when the job succeeds. Equivalent to the   "
            " schema.on_success  hook."
        ),
    )
    ensure: Optional[Step] = Field(
        None,
        description=(
            "Step to execute regardless of whether the job succeeds, fails, errors, or "
            " aborts. Equivalent to the  schema.ensure  hook."
        ),
    )
    on_error: Optional[Step] = Field(
        None,
        description=(
            "Step to execute when the job errors. Equivalent to the    schema.on_error "
            " hook."
        ),
    )
    disable_manual_trigger: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  If set to `true` , manual triggering of  the job (via"
            " the web UI or  fly-trigger-job  ) will be disabled."
        ),
    )
    serial_groups: Optional[list[Identifier]] = Field(
        None,
        description=(
            "Default `[]` .  When set to an array of arbitrary tag-like  strings,"
            " builds of this job and other jobs referencing the same tags will  be"
            " serialized.     \n@example  Limiting parallelism \n   This can be used to"
            " ensure that certain jobs do not run at the same time,  like so:    "
            " ```yaml\njobs:\n- name: job-a\n  serial_groups: [some-tag]\n- name:"
            " job-b\n  serial_groups: [some-tag, some-other-tag]\n- name: job-c\n "
            " serial_groups: [some-other-tag]\n```     In this example, `job-a` and"
            " `job-c` can run concurrently, but  neither job can run builds at the same"
            " time as `job-b` .    The builds are executed in their order of creation,"
            " across all jobs with  common tags."
        ),
    )
    build_log_retention: Optional[BuildLogRetentionPolicy] = Field(
        None,
        description=(
            "Configures the retention policy for build logs. This is useful if you have"
            "  a job that runs often but after some amount of time the logs aren't"
            " worth  keeping around.    Builds which are not retained by the configured"
            " policy will have their logs  reaped. If this configuration is omitted,"
            " logs are kept forever (unless    build-log-retention  is configured"
            " globally).     \n@example  A complicated example \n   The following"
            " example will keep logs for any builds that have completed in  the last 2"
            " days, while also keeping the last 1000 builds and at least 1  succeeded"
            " build.     ```yaml\njobs:\n- name: smoke-tests\n  build_log_retention:\n "
            "   days: 2\n    builds: 1000\n    minimum_succeeded_builds: 1\n  plan:\n "
            " - get: 10m\n  - task: smoke-tests\n    # ...\n```     If more than 1000"
            " builds finish in the past 2 days,  all  of them  will be retained thanks"
            " to the    schema.build_log_retention_policy.days `days`   configuration."
            " Similarly, if there are 1000 builds spanning more than 2  days, they will"
            " also be kept thanks to the    schema.build_log_retention_policy.builds"
            " `builds`   configuration. And if they all happened to have failed, the   "
            " schema.build_log_retention_policy.minimum_succeeded_builds"
            " `minimum_succeeded_builds`   will keep around at least one successful"
            " build. All policies operate  independently.         "
            " build_log_retention_policy      days  number    Keep logs for builds"
            " which have finished within the specified number of  days.          builds"
            "  number    Keep logs for the last specified number of builds.         "
            " minimum_succeeded_builds  number    Keep a minimum number of successful"
            " build logs that would normally be  reaped.    Requires   "
            " schema.build_log_retention_policy.builds `builds` to  be set to an"
            " integer higher than 0 in order to work. For example, if   "
            " schema.build_log_retention_policy.builds `builds` is  set to 5, and this"
            " attribute to 1, say a job has the following build  history: 7(f), 6(f),"
            " 5(f), 4(f), 3(f), 2(f), 1(s), where f means  failed and s means"
            " succeeded, then builds 2 and 3 will be reaped,  because it retains 5"
            " build logs, and at least 1 succeeded build log.  Default is 0."
        ),
    )
    name: Optional[Identifier] = Field(
        None,
        description=(
            "The name of the job. This should be short; it will show up in URLs."
        ),
    )
    plan: Optional[list[Step]] = Field(
        None, description="The sequence of  steps  steps  to execute."
    )
    interruptible: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  Normally, when a worker is shutting down it  will wait"
            " for builds with containers running on that worker to finish  before"
            " exiting. If this value is set to `true` , the worker will not  wait on"
            " the builds of this job. You may want this if e.g. you have a "
            " self-deploying Concourse or long-running-but-low-importance jobs."
        ),
    )
    public: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  If set to `true` , the build log of this  job will be"
            " viewable by unauthenticated users. Unauthenticated users will  always be"
            " able to see the inputs, outputs, and build status history of a  job. This"
            " is useful if you would like to expose your pipeline publicly  without"
            " showing sensitive information in the build log.    Note: when this is set"
            " to `true` , any  get-step  and    put-step  s will show the metadata for"
            " their resource version,  regardless of whether the resource itself has"
            " set  schema.resource.public    to `true` ."
        ),
    )
    on_failure: Optional[Step] = Field(
        None,
        description=(
            "Step to execute when the job fails. Equivalent to the    schema.on_failure"
            "  hook."
        ),
    )
    on_abort: Optional[Step] = Field(
        None,
        description=(
            "Step to execute when the job aborts. Equivalent to the    schema.on_abort "
            " hook."
        ),
    )


class Pipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    jobs: Optional[list[Job]] = Field(
        None,
        description=(
            "A set of  jobs  jobs  for the pipeline to continuously schedule. At least"
            " one job is required for a pipeline to be valid."
        ),
    )
    groups: Optional[list[GroupConfig]] = Field(
        None,
        description=(
            "A list of job groups to use for organizing jobs in the web UI.    Groups"
            " have no functional effect on your pipeline. They are purely for  making"
            " it easier to grok large pipelines in the web UI.    Note: once you have"
            " added groups to your pipeline, all jobs must be in a  group.    "
            " \n@example  Grouping jobs \n   The following example will make the"
            ' "tests" group the default view (since  it\'s listed first), separating'
            ' the later jobs into a "publish" group:     ```yaml\ngroups:\n- name:'
            " test\n  jobs:\n  - unit\n  - integration\n- name: publish\n  jobs:\n  -"
            " deploy\n  - shipit\n```     This would display two tabs at the top of the"
            ' home page: "test" and  "publish".    For a real world example of how'
            " groups can be used to simplify navigation  and provide logical grouping,"
            " see the groups used at the top of the page  in the  Concourse pipeline "
            " https://ci.concourse-ci.org  .          group_config      name "
            " identifier    A unique name for the group. This should be short and"
            " simple as it will  be used as the tab name for navigation.          jobs "
            " [job.name]    A list of jobs that should appear in this group. A job may "
            " appear in multiple groups. Neighbours of jobs in the current group will"
            " also  appear on the same page in order to give context of the location of"
            " the  group in the pipeline.    You may also use any valid  glob "
            " https://www.man7.org/linux/man-pages/man7/glob.7.html    to represent"
            " several jobs, e.g.:     ```yaml\ngroups:\n- name: develop\n  jobs:\n  -"
            " terraform-*\n  - test\n  - deploy-{dev,staging}\n- name: ship\n  jobs:\n "
            ' - deploy-prod\n- name: all\n  jobs:\n  - "*"\n```     In this example,'
            " the `develop` group will match   `terraform-apply` , `terraform-destroy`"
            " , `test` ,   `deploy-dev` , `deploy-staging` . The `ship` group will only"
            " match   `deploy-prod` . The `all` group will match all jobs in the"
            " pipeline.      Note that depending on how it's used, `*` , `{` , and  "
            " `}` have special meaning in YAML, and may need to be quoted (as  was done"
            " in the `all` job above)"
        ),
    )
    resource_types: Optional[list[ResourceType]] = Field(
        None,
        description=(
            "A set of  resource-types  resource types  for resources within the "
            " pipeline to use."
        ),
    )
    var_sources: Optional[list[VarSource]] = Field(
        None, description="A set of  var-sources  for the pipeline to use."
    )
    display: Optional[DisplayConfig] = Field(
        None,
        description=(
            "`display` was introduced in Concourse v6.6.0. It is considered an   **"
            " experimental ** feature.        Visual configurations for personalizing"
            " your pipeline.     \n@example  Background image \n   The following"
            " example will display an image in the background of the pipeline  it is"
            " configured on.     ```yaml\ndisplay:\n  background_image:"
            " https://avatars1.githubusercontent.com/u/7809479?s=400&v=4\n```          "
            " display_config      background_image  string    Allow users to specify a"
            " custom background image which is put at 30%  opacity, grayscaled and"
            " blended into existing background. Must be an  http, https, or relative"
            " URL."
        ),
    )
    resources: Optional[list[Resource]] = Field(
        None,
        description=(
            "A set of  resources  resources  for the pipeline to continuously  check."
        ),
    )


class TryStep(Step):
    class Config:
        extra = Extra.forbid

    try_: Optional[Step] = Field(
        None,
        alias="try",
        description=(
            "Performs the given step, ignoring any failure and masking it with "
            " success.    This can be used when you want to perform some side-effect,"
            " but you  don't really want the whole build to fail if it doesn't work.   "
            "  \n@example  Allowing non-critical behavior to fail \n   When emitting"
            " logs somewhere for analyzing later, if the destination flakes  out it may"
            " not really be critical, so we may want to just swallow the  error:    "
            " ```yaml\nplan:\n- task: run-tests\n  config: # ...\n  on_success:\n   "
            " try:\n      put: test-logs\n      params:\n        from:"
            " run-tests/*.log\n- task: do-something-else\n  config: # ...\n```"
        ),
    )


class InParallelConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    limit: Optional[Number] = Field(
        None,
        description=(
            "Default unlimited.  A sempahore which limits the  parallelism when"
            " executing the steps in a `in_parallel` step.  When set, the number of"
            " running steps will not exceed the limit.    When not specified,"
            " `in_parallel` will execute all steps  immediately.   \n@example  Limiting"
            " parallelism \n   Using `limit` is useful for performing parallel"
            " execution of a  growing number of tasks without overloading your workers."
            " In the  example below, two tasks will be run in parallel and in order"
            " until  all steps have been executed:     ```yaml\njobs:\n- name:"
            " limit-in-parallel\n  plan:\n  - get: examples\n  - in_parallel:\n     "
            " limit: 2\n      steps:\n      - task: print-date\n        file:"
            " examples/tasks/print-date.yml\n      - task: hello-world\n        file:"
            " examples/tasks/hello-world.yml\n      - task: print-var\n        file:"
            " examples/tasks/print-var.yml\n        vars:\n          my-var: hello\n   "
            "       second-var: good-bye\n\n\nresources:\n- name: examples\n  type:"
            " git\n  source:\n    uri: https://github.com/concourse/examples.git\n```"
        ),
    )
    fail_fast: Optional[bool] = Field(
        None,
        description=(
            "Default `false` .  When enabled the parallel step will  fail fast by"
            " returning as soon as any sub-step fails. This means that running steps "
            " will be interrupted and pending steps will no longer be scheduled."
        ),
    )
    steps: Optional[list[Step]] = Field(
        None,
        description=(
            "The steps to perform in parallel.   \n@example  Fetching artifacts in"
            " parallel \n   Using the `in_parallel` step where possible is the easiest"
            " way  to speeding up a builds.    It is often used to fetch all dependent"
            " resources together at the  start of a build plan:     ```yaml\njobs:\n-"
            " name: get-in-parallel\n  plan:\n  - in_parallel:\n      limit: 2\n     "
            " fail_fast: false\n      steps:\n      - get: ci\n      - get: repo\n     "
            " - get: code\n\n\nresources:\n- name: repo\n  type: mock\n- name: code\n "
            " type: mock\n- name: ci\n  type: mock\n```"
        ),
    )


class DoStep(Step):
    class Config:
        extra = Extra.forbid

    do: Optional[list[Step]] = Field(
        None,
        description=(
            "@example  Running multiple steps in a try \n   This can be used to perform"
            " multiple steps serially in a    try-step  :     ```yaml\njobs:\n- name:"
            " with-do\n  plan:\n  - try:\n      do:\n      - get: black-ice\n      -"
            " get: control-node\n      - get: cyberdeck\n\nresources:\n- name:"
            " black-ice\n  type: mock\n- name: control-node\n  type: mock\n- name:"
            " cyberdeck\n  type: mock\n```"
        ),
    )


InParallelStep.update_forward_refs()
Job.update_forward_refs()
Step.update_forward_refs()
